/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.perm.AssignSource;
import kd.hr.hbp.common.model.perm.DimGroupParam;
import kd.hr.hbp.common.model.perm.DimValueParam;
import kd.hr.hbp.common.model.perm.EntityBdDataRuleParam;
import kd.hr.hbp.common.model.perm.EntityDataRuleParam;
import kd.hr.hbp.common.model.perm.EntityFieldPermParam;
import kd.hr.hbp.common.model.perm.PermDataRangeParam;
import kd.hr.hbp.common.model.perm.UserBucaPermDataParam;
import kd.hr.hbp.common.model.perm.UserRoleAssignParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.FieldPermModel;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.service.perm.RoleMemberService;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignSaveService;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RoleAssignLogBussinessHelper;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.RoleBdDataRuleEntryModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import kd.hr.hrcs.common.constants.perm.RoleDataRuleEntryModel;
import kd.hr.hrcs.common.constants.perm.RoleDataRuleMainModel;

public class RoleAssignParamBuilder {
    private static final Log LOGGER = LogFactory.getLog(RoleAssignParamBuilder.class);

    public static List<UserRoleAssignParam> buildUserRoleAssignParams(String roleId, long permFileId, Date validStart, Date validEnd, List<RoleDataPermModel> models, Map<String, UserRoleFieldPermInfo> fieldPermInfo, String operationType, Long beforeRelateId, String pageSource) {
        try {
            UserRoleAssignParam param = new UserRoleAssignParam(Long.valueOf(permFileId), roleId, validStart, validEnd, Long.valueOf(RequestContext.get().getCurrUserId()));
            param.setCustomData(true);
            AssignSource assignSource = param.getAssignSource();
            assignSource.setBeforeRelateId(beforeRelateId);
            assignSource.setPageSource(pageSource);
            if (HRStringUtils.equals((String)operationType, (String)"userRoleCopy")) {
                assignSource.setSourceType("2");
            } else {
                assignSource.setSourceType("1");
            }
            if (HRStringUtils.equals((String)"userRoleAdd", (String)operationType) || HRStringUtils.equals((String)"userRoleCopy", (String)operationType) || HRStringUtils.equals((String)"userRoleInit", (String)operationType)) {
                assignSource.setObType(operationType);
            } else {
                assignSource.setObType("userRoleModify");
                param.setUserRoleAssignParamBefore(RoleAssignParamBuilder.buildBeforeUserRoleAssignParams(roleId, beforeRelateId));
            }
            HashMap bucaPermData = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList dataRuleParams = Lists.newArrayListWithExpectedSize((int)16);
            ArrayList bdDataRuleParams = Lists.newArrayListWithExpectedSize((int)16);
            ArrayList fieldPermParams = Lists.newArrayListWithExpectedSize((int)16);
            PermDataRangeParam dataRangeParam = new PermDataRangeParam((Map)bucaPermData, (List)dataRuleParams, (List)bdDataRuleParams, (List)fieldPermParams);
            param.setDataRangeParam(dataRangeParam);
            for (RoleDataPermModel roleDataPermModel : models) {
                UserBucaPermDataParam bucaDataParam = new UserBucaPermDataParam();
                bucaDataParam.setBucaId(Long.valueOf(roleDataPermModel.getHrBuCaFunc()));
                bucaPermData.put(roleDataPermModel.getHrBuCaFunc(), bucaDataParam);
                Map orgMaps = roleDataPermModel.getOrgMap();
                HashMap orgInfosParam = Maps.newHashMapWithExpectedSize((int)orgMaps.size());
                for (Map orgMap : orgMaps.values()) {
                    orgInfosParam.put(Long.parseLong((String)orgMap.get("id")), (Boolean)orgMap.get("includeSub"));
                }
                bucaDataParam.setOrgInfos((Map)orgInfosParam);
                Map dimGroupMap = roleDataPermModel.getDimGroupMap();
                ArrayList userDimGroupData = Lists.newArrayListWithExpectedSize((int)dimGroupMap.size());
                bucaDataParam.setUserDimGroupData((List)userDimGroupData);
                for (DimGrpModel groupModel : dimGroupMap.values()) {
                    TreeMap dimMap = groupModel.getDimMap();
                    DimGroupParam groupParam = new DimGroupParam();
                    HashMap dimValuesMap = Maps.newHashMapWithExpectedSize((int)dimMap.size());
                    groupParam.setDimValuesMap((Map)dimValuesMap);
                    for (DimModel dimModel : dimMap.values()) {
                        String dimId = dimModel.getDimId();
                        Map dimValues = dimModel.getDimValues();
                        if (HRStringUtils.equals((String)dimModel.getLimit(), (String)"1")) {
                            DimValueParam dimValueParam = new DimValueParam();
                            dimValueParam.setAll(true);
                            dimValuesMap.put(Long.parseLong(dimId), Lists.newArrayList((Object[])new DimValueParam[]{dimValueParam}));
                            continue;
                        }
                        ArrayList dimValueParams = Lists.newArrayListWithExpectedSize((int)dimValues.size());
                        for (Map dimValue : dimValues.values()) {
                            Object classify;
                            DimValueParam dimValueParam = new DimValueParam();
                            dimValueParam.setAll(false);
                            dimValueParam.setDimVal((String)dimValue.get("id"));
                            dimValueParam.setContainsSub(((Boolean)dimValue.get("includeSub")).booleanValue());
                            dimValueParam.setAdminContainsSub(dimValue.getOrDefault("includeSubAdminOrg", Boolean.FALSE).booleanValue());
                            Iterator<Object> structProject = dimValue.get("structProject");
                            if (Objects.nonNull(structProject)) {
                                if (structProject instanceof Map) {
                                    dimValueParam.setStructProject(Long.valueOf(Long.parseLong(((Map)((Object)structProject)).get("id").toString())));
                                } else if (structProject instanceof DynamicObject) {
                                    dimValueParam.setStructProject((Long)((DynamicObject)structProject).getPkValue());
                                } else {
                                    dimValueParam.setStructProject(Long.valueOf(Long.parseLong(structProject.toString())));
                                }
                            }
                            if (Objects.nonNull(classify = dimValue.get("otClassify"))) {
                                if (classify instanceof Map) {
                                    dimValueParam.setOtClassify(Long.valueOf(Long.parseLong(((Map)classify).get("id").toString())));
                                } else if (classify instanceof DynamicObject) {
                                    dimValueParam.setOtClassify((Long)((DynamicObject)classify).getPkValue());
                                } else {
                                    dimValueParam.setOtClassify(Long.valueOf(Long.parseLong(classify.toString())));
                                }
                            }
                            dimValueParam.setValType(dimValue.getOrDefault("valueType", "1"));
                            String dynaCondStr = (String)dimValue.get("dynamicCondition");
                            if (HRStringUtils.isEmpty((String)dynaCondStr)) {
                                dynaCondStr = "0";
                            }
                            dimValueParam.setDynaCondId(Long.valueOf(Long.parseLong(dynaCondStr)));
                            dimValueParams.add(dimValueParam);
                        }
                        dimValuesMap.put(Long.parseLong(dimId), dimValueParams);
                    }
                    userDimGroupData.add(groupParam);
                }
                Map appEntity2DataRules = roleDataPermModel.getAppEntity2DataRules();
                if (CollectionUtils.isEmpty((Map)appEntity2DataRules)) continue;
                for (Map.Entry entityEntry : appEntity2DataRules.entrySet()) {
                    String appEntityKey = (String)entityEntry.getKey();
                    String[] split = appEntityKey.split("#");
                    String appId = split[0];
                    String entityNumber = split[1];
                    RoleDataRuleMainModel drModel = (RoleDataRuleMainModel)entityEntry.getValue();
                    Map dataRuleMap = drModel.getDataRuleMap();
                    Map bdDataRuleMap = drModel.getBdDataRuleMap();
                    for (Map.Entry entry : dataRuleMap.entrySet()) {
                        if (HRStringUtils.equals((String)((String)entry.getKey()), (String)"emptyFlag")) continue;
                        RoleDataRuleEntryModel drEntryModel = (RoleDataRuleEntryModel)entry.getValue();
                        for (String permItemId : drEntryModel.getPermItem()) {
                            EntityDataRuleParam drParam = new EntityDataRuleParam(appId, entityNumber, permItemId, Long.valueOf(Long.parseLong(drEntryModel.getDataRuleId())));
                            dataRuleParams.add(drParam);
                        }
                    }
                    for (Map.Entry entry : bdDataRuleMap.entrySet()) {
                        if (HRStringUtils.equals((String)((String)entry.getKey()), (String)"emptyFlag")) continue;
                        RoleBdDataRuleEntryModel bdEntryModel = (RoleBdDataRuleEntryModel)entry.getValue();
                        EntityBdDataRuleParam bdParam = new EntityBdDataRuleParam(appId, entityNumber, bdEntryModel.getProperty(), bdEntryModel.getPropertyNum(), Long.valueOf(Long.parseLong(bdEntryModel.getDataRuleId())));
                        bdDataRuleParams.add(bdParam);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(fieldPermInfo)) {
                for (Map.Entry entry : fieldPermInfo.entrySet()) {
                    String[] entityTypeInfo = ((String)entry.getKey()).split("@");
                    UserRoleFieldPermInfo userRoleFieldPermInfo = (UserRoleFieldPermInfo)entry.getValue();
                    List<FieldPermModel> fieldList = userRoleFieldPermInfo.getFieldPermModelList();
                    if (CollectionUtils.isEmpty(fieldList)) continue;
                    for (FieldPermModel field : fieldList) {
                        EntityFieldPermParam fieldPermParam = new EntityFieldPermParam();
                        fieldPermParam.setAppId(entityTypeInfo[0]);
                        fieldPermParam.setEntityNumber(entityTypeInfo[1]);
                        fieldPermParam.setPropKey(field.getFiledNum());
                        fieldPermParam.setCanRead(RoleAssignParamBuilder.convertFieldValue(field.getIsBanRead()).booleanValue());
                        fieldPermParam.setCanWrite(RoleAssignParamBuilder.convertFieldValue(field.getIsBanWrite()).booleanValue());
                        fieldPermParam.setFieldName(field.getFiledName());
                        fieldPermParams.add(fieldPermParam);
                    }
                }
            }
            return Lists.newArrayList((Object[])new UserRoleAssignParam[]{param});
        }
        catch (Exception ex) {
            LOGGER.error("CommonRoleAssignUser buildUserRoleAssignParams error.", (Throwable)ex);
            return Lists.newArrayListWithExpectedSize((int)0);
        }
    }

    public static UserRoleAssignParam buildBeforeUserRoleAssignParams(String roleId, Long relationId) {
        try {
            HRBaseServiceHelper USER_ROLE_RE_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
            DynamicObject relateDy = USER_ROLE_RE_HELPER.queryOne((Object)relationId);
            long permFileId = relateDy.getLong("permfile.id");
            Date validStart = relateDy.getDate("validstart");
            Date validEnd = relateDy.getDate("validend");
            String customEnable = relateDy.getString("customenable");
            Map<String, UserRoleFieldPermInfo> fieldPermInfo = RoleMemberService.getUserFieldPermInfoFromDatabase(null, null, relationId);
            List<RoleDataPermModel> models = RoleMemberAssignSaveService.getRoleMemberInfoCustom(relationId);
            if (CollectionUtils.isEmpty(models)) {
                LOGGER.info("buildBeforeUserRoleAssignParams is empty relationId={}", (Object)relationId);
                return null;
            }
            UserRoleAssignParam param = new UserRoleAssignParam(Long.valueOf(permFileId), roleId, validStart, validEnd, Long.valueOf(RequestContext.get().getCurrUserId()));
            param.setCustomData(customEnable.equals("1"));
            AssignSource assignSource = param.getAssignSource();
            assignSource.setRelateId(relationId);
            assignSource.setSourceType(relateDy.getString("sourcetype"));
            assignSource.setInitRecordId(Long.valueOf(relateDy.getLong("initrecord.id")));
            assignSource.setSchemeId(Long.valueOf(relateDy.getLong("scheme.id")));
            RoleAssignLogBussinessHelper.setSourceTypeAndSchemeName(assignSource, relationId);
            if (!customEnable.equals("1")) {
                return param;
            }
            HashMap bucaPermData = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList dataRuleParams = Lists.newArrayListWithExpectedSize((int)16);
            ArrayList bdDataRuleParams = Lists.newArrayListWithExpectedSize((int)16);
            ArrayList fieldPermParams = Lists.newArrayListWithExpectedSize((int)16);
            PermDataRangeParam dataRangeParam = new PermDataRangeParam((Map)bucaPermData, (List)dataRuleParams, (List)bdDataRuleParams, (List)fieldPermParams);
            param.setDataRangeParam(dataRangeParam);
            for (RoleDataPermModel roleDataPermModel : models) {
                UserBucaPermDataParam bucaDataParam = new UserBucaPermDataParam();
                bucaDataParam.setBucaId(Long.valueOf(roleDataPermModel.getHrBuCaFunc()));
                bucaPermData.put(roleDataPermModel.getHrBuCaFunc(), bucaDataParam);
                Map orgMaps = roleDataPermModel.getOrgMap();
                HashMap orgInfosParam = Maps.newHashMapWithExpectedSize((int)orgMaps.size());
                for (Map orgMap : orgMaps.values()) {
                    orgInfosParam.put(Long.parseLong((String)orgMap.get("id")), (Boolean)orgMap.get("includeSub"));
                }
                bucaDataParam.setOrgInfos((Map)orgInfosParam);
                Map dimGroupMap = roleDataPermModel.getDimGroupMap();
                ArrayList userDimGroupData = Lists.newArrayListWithExpectedSize((int)dimGroupMap.size());
                bucaDataParam.setUserDimGroupData((List)userDimGroupData);
                for (DimGrpModel groupModel : dimGroupMap.values()) {
                    TreeMap dimMap = groupModel.getDimMap();
                    DimGroupParam groupParam = new DimGroupParam();
                    HashMap dimValuesMap = Maps.newHashMapWithExpectedSize((int)dimMap.size());
                    groupParam.setDimValuesMap((Map)dimValuesMap);
                    for (DimModel dimModel : dimMap.values()) {
                        String dimId = dimModel.getDimId();
                        Map dimValues = dimModel.getDimValues();
                        if (HRStringUtils.equals((String)dimModel.getLimit(), (String)"1")) {
                            DimValueParam dimValueParam = new DimValueParam();
                            dimValueParam.setAll(true);
                            dimValuesMap.put(Long.parseLong(dimId), Lists.newArrayList((Object[])new DimValueParam[]{dimValueParam}));
                            continue;
                        }
                        ArrayList dimValueParams = Lists.newArrayListWithExpectedSize((int)dimValues.size());
                        for (Map dimValue : dimValues.values()) {
                            Object classify;
                            DimValueParam dimValueParam = new DimValueParam();
                            dimValueParam.setAll(false);
                            dimValueParam.setDimVal((String)dimValue.get("id"));
                            dimValueParam.setContainsSub(((Boolean)dimValue.get("includeSub")).booleanValue());
                            dimValueParam.setAdminContainsSub(dimValue.getOrDefault("includeSubAdminOrg", Boolean.FALSE).booleanValue());
                            Iterator<Object> structProject = dimValue.get("structProject");
                            if (Objects.nonNull(structProject)) {
                                if (structProject instanceof Map) {
                                    dimValueParam.setStructProject(Long.valueOf(Long.parseLong(((Map)((Object)structProject)).get("id").toString())));
                                } else if (structProject instanceof DynamicObject) {
                                    dimValueParam.setStructProject((Long)((DynamicObject)structProject).getPkValue());
                                } else {
                                    dimValueParam.setStructProject(Long.valueOf(Long.parseLong(structProject.toString())));
                                }
                            }
                            if (Objects.nonNull(classify = dimValue.get("otClassify"))) {
                                if (classify instanceof Map) {
                                    dimValueParam.setOtClassify(Long.valueOf(Long.parseLong(((Map)classify).get("id").toString())));
                                } else if (classify instanceof DynamicObject) {
                                    dimValueParam.setOtClassify((Long)((DynamicObject)classify).getPkValue());
                                } else {
                                    dimValueParam.setOtClassify(Long.valueOf(Long.parseLong(classify.toString())));
                                }
                            }
                            dimValueParam.setValType(dimValue.getOrDefault("valueType", "1"));
                            String dynaCondStr = (String)dimValue.get("dynamicCondition");
                            if (HRStringUtils.isEmpty((String)dynaCondStr)) {
                                dynaCondStr = "0";
                            }
                            dimValueParam.setDynaCondId(Long.valueOf(Long.parseLong(dynaCondStr)));
                            dimValueParams.add(dimValueParam);
                        }
                        dimValuesMap.put(Long.parseLong(dimId), dimValueParams);
                    }
                    userDimGroupData.add(groupParam);
                }
                Map appEntity2DataRules = roleDataPermModel.getAppEntity2DataRules();
                if (CollectionUtils.isEmpty((Map)appEntity2DataRules)) continue;
                for (Map.Entry entityEntry : appEntity2DataRules.entrySet()) {
                    String appEntityKey = (String)entityEntry.getKey();
                    String[] split = appEntityKey.split("#");
                    String appId = split[0];
                    String entityNumber = split[1];
                    RoleDataRuleMainModel drModel = (RoleDataRuleMainModel)entityEntry.getValue();
                    Map dataRuleMap = drModel.getDataRuleMap();
                    Map bdDataRuleMap = drModel.getBdDataRuleMap();
                    for (Map.Entry entry : dataRuleMap.entrySet()) {
                        if (HRStringUtils.equals((String)((String)entry.getKey()), (String)"emptyFlag")) continue;
                        RoleDataRuleEntryModel drEntryModel = (RoleDataRuleEntryModel)entry.getValue();
                        for (String permItemId : drEntryModel.getPermItem()) {
                            EntityDataRuleParam drParam = new EntityDataRuleParam(appId, entityNumber, permItemId, Long.valueOf(Long.parseLong(drEntryModel.getDataRuleId())));
                            dataRuleParams.add(drParam);
                        }
                    }
                    for (Map.Entry entry : bdDataRuleMap.entrySet()) {
                        if (HRStringUtils.equals((String)((String)entry.getKey()), (String)"emptyFlag")) continue;
                        RoleBdDataRuleEntryModel bdEntryModel = (RoleBdDataRuleEntryModel)entry.getValue();
                        EntityBdDataRuleParam bdParam = new EntityBdDataRuleParam(appId, entityNumber, bdEntryModel.getProperty(), bdEntryModel.getPropertyNum(), Long.valueOf(Long.parseLong(bdEntryModel.getDataRuleId())));
                        bdDataRuleParams.add(bdParam);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(fieldPermInfo)) {
                for (Map.Entry entry : fieldPermInfo.entrySet()) {
                    String[] entityTypeInfo = ((String)entry.getKey()).split("@");
                    UserRoleFieldPermInfo userRoleFieldPermInfo = (UserRoleFieldPermInfo)entry.getValue();
                    List<FieldPermModel> fieldList = userRoleFieldPermInfo.getFieldPermModelList();
                    if (CollectionUtils.isEmpty(fieldList)) continue;
                    for (FieldPermModel field : fieldList) {
                        EntityFieldPermParam fieldPermParam = new EntityFieldPermParam();
                        fieldPermParam.setAppId(entityTypeInfo[0]);
                        fieldPermParam.setEntityNumber(entityTypeInfo[1]);
                        fieldPermParam.setPropKey(field.getFiledNum());
                        fieldPermParam.setCanRead(RoleAssignParamBuilder.convertFieldValue(field.getIsBanRead()).booleanValue());
                        fieldPermParam.setCanWrite(RoleAssignParamBuilder.convertFieldValue(field.getIsBanWrite()).booleanValue());
                        fieldPermParam.setFieldName(field.getFiledName());
                        fieldPermParams.add(fieldPermParam);
                    }
                }
            }
            return param;
        }
        catch (Exception ex) {
            LOGGER.error("CommonRoleAssignUser buildUserRoleAssignParams error.", (Throwable)ex);
            return null;
        }
    }

    private static Boolean convertFieldValue(String isBan) {
        switch (isBan) {
            case "true": 
            case "1": {
                return false;
            }
            case "false": 
            case "0": {
                return true;
            }
        }
        return null;
    }
}

