/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.model.perm.AssignSource;
import kd.hr.hbp.common.model.perm.DimGroupParam;
import kd.hr.hbp.common.model.perm.DimValueParam;
import kd.hr.hbp.common.model.perm.EntityBdDataRuleParam;
import kd.hr.hbp.common.model.perm.EntityDataRuleParam;
import kd.hr.hbp.common.model.perm.EntityFieldPermParam;
import kd.hr.hbp.common.model.perm.UserBucaPermDataParam;
import kd.hr.hbp.common.model.perm.UserRoleAssignParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.servicehelper.PermFilesServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.PermLogServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RoleAssignLogServiceHelper;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.common.model.perminit.OrgRangeBean;
import org.apache.commons.collections.CollectionUtils;

public class RoleAssignService {
    private static final Log LOGGER = LogFactory.getLog(RoleAssignService.class);
    private static final HRBaseServiceHelper SYS_USER_ROLE_HELPER = new HRBaseServiceHelper("perm_userrole");
    private static final HRBaseServiceHelper USER_ROLE_RELAT_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
    private static final HRBaseServiceHelper USER_ROLE_HELPER = new HRBaseServiceHelper("hrcs_userrole");
    private static final HRBaseServiceHelper USER_ROLE_DIMGRP_HELPER = new HRBaseServiceHelper("hrcs_userroledimgrp");
    private static final HRBaseServiceHelper USER_DATARULE_HELPER = new HRBaseServiceHelper("hrcs_userdatarule");
    private static final HRBaseServiceHelper USER_FIELD_HELPER = new HRBaseServiceHelper("hrcs_userfield");
    private static final HRBaseServiceHelper DIM_HELPER = new HRBaseServiceHelper("hrcs_dimension");

    private static void resetValidDate(List<UserRoleAssignParam> userRoleAssignParams, boolean enableValidateTime) {
        for (UserRoleAssignParam param : userRoleAssignParams) {
            if (!enableValidateTime) {
                param.setValidStart(null);
                param.setValidEnd(null);
            }
            if (param.getValidStart() != null) {
                param.setValidStart(PermRoleUtil.formatStartDate(param.getValidStart()));
            }
            if (param.getValidEnd() == null) continue;
            param.setValidEnd(PermRoleUtil.formatEndDate(param.getValidEnd()));
        }
    }

    private static void resetSourceType(List<UserRoleAssignParam> userRoleAssignParams) {
        for (UserRoleAssignParam param : userRoleAssignParams) {
            UserRoleAssignParam paramBefore;
            AssignSource assignSource = param.getAssignSource();
            if (!HRStringUtils.equals((String)assignSource.getSourceType(), (String)"1") || Objects.isNull(paramBefore = param.getUserRoleAssignParamBefore())) continue;
            AssignSource assignSourceBefore = paramBefore.getAssignSource();
            assignSource.setSourceType(assignSourceBefore.getSourceType());
            assignSource.setInitRecordId(assignSourceBefore.getInitRecordId());
            assignSource.setSchemeId(assignSourceBefore.getSchemeId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> roleAssignUserBatch(List<UserRoleAssignParam> userRoleAssignParams) {
        LOGGER.info("roleAssignUserBatch start,userRoleAssignParams:{}", userRoleAssignParams);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        try {
            boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
            RoleAssignService.resetValidDate(userRoleAssignParams, enableValidateTime);
            RoleAssignService.resetSourceType(userRoleAssignParams);
            List<Long> permFileIds = userRoleAssignParams.stream().map(UserRoleAssignParam::getPermFileId).collect(Collectors.toList());
            Map<Long, Long> permFileUserMap = PermFilesServiceHelper.getPermFileUserMapByPermFile(permFileIds);
            Map<Integer, List<OrgRangeBean>> userOrgRangeMap = RoleAssignService.calUserOrgs(userRoleAssignParams);
            Map<String, String> sysUserRoleIdMap = RoleAssignService.buildSysUserRoleIdMap(userRoleAssignParams, userOrgRangeMap);
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    RoleAssignService.saveToSysUserRole(userRoleAssignParams, userOrgRangeMap, sysUserRoleIdMap, permFileUserMap, enableValidateTime);
                }
                catch (Exception ex) {
                    LOGGER.error("roleAssignUserBatch save to sys error.", (Throwable)ex);
                    txHandle.markRollback();
                    result.put("success", "false");
                    result.put("code", EnumResponseCode.FAIL.getCode());
                    result.put("message", ex.getMessage());
                    HashMap hashMap = result;
                    if (txHandle == null) return hashMap;
                    if (throwable == null) {
                        txHandle.close();
                        return hashMap;
                    }
                    try {
                        txHandle.close();
                        return hashMap;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return hashMap;
                    }
                }
            }
            boolean isSaveToHmpSuccess = true;
            try (TXHandle txHandle2 = TX.requiresNew();){
                try {
                    Map<Integer, Long> userRoleRelatIdMap = RoleAssignService.buildUserRoleRelatIdMap(userRoleAssignParams);
                    RoleAssignService.saveToUserRoleRelat(userRoleAssignParams, userRoleRelatIdMap, permFileUserMap, enableValidateTime);
                    RoleAssignService.saveToUserRole(userRoleAssignParams, userOrgRangeMap, sysUserRoleIdMap, userRoleRelatIdMap);
                    RoleAssignService.saveToUserDimGroup(userRoleAssignParams, userRoleRelatIdMap);
                    RoleAssignService.saveToUserDataRule(userRoleAssignParams, userRoleRelatIdMap);
                    RoleAssignService.saveToUserField(userRoleAssignParams, userRoleRelatIdMap);
                }
                catch (Exception ex) {
                    LOGGER.error("roleAssignUserBatch save to hmp error.", (Throwable)ex);
                    txHandle2.markRollback();
                    isSaveToHmpSuccess = false;
                }
            }
            if (!isSaveToHmpSuccess) {
                var9_14 = null;
                try (TXHandle txHandleSys = TX.requiresNew();){
                    try {
                        SYS_USER_ROLE_HELPER.delete((Object[])sysUserRoleIdMap.values().toArray(new String[0]));
                    }
                    catch (Exception exception) {
                        LOGGER.error("roleAssignUserBatch sys rollback error.", (Throwable)exception);
                    }
                }
                catch (Throwable throwable7) {
                    var9_14 = throwable7;
                    throw throwable7;
                }
                result.put("success", "false");
                result.put("code", EnumResponseCode.FAIL.getCode());
                result.put("message", "roleAssignUserBatch save to hmp error.");
                return result;
            }
            result.put("success", "true");
            result.put("code", EnumResponseCode.SUCCESS.getCode());
            result.put("message", "ok");
            HRPermCacheMgr.clearAllCache();
            RoleAssignService.saveRoleAssignPermLog(userRoleAssignParams);
        }
        catch (Exception ex) {
            LOGGER.error("roleAssignUserBatch error.", (Throwable)ex);
            result.put("success", "false");
            result.put("code", EnumResponseCode.FAIL.getCode());
            result.put("message", ex.getMessage());
        }
        LOGGER.info("roleAssignUserBatch end. ");
        return result;
    }

    private static void saveRoleAssignPermLog(List<UserRoleAssignParam> userRoleAssignParams) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (int i = 0; i < userRoleAssignParams.size(); ++i) {
            UserRoleAssignParam userRoleAssignParam = userRoleAssignParams.get(i);
            AssignSource assignSource = userRoleAssignParam.getAssignSource();
            String opType = assignSource.getObType();
            RoleAssignLogServiceHelper.roleAssignPermLog(opType, new UserRoleAssignParam(), userRoleAssignParam, i, dynamicObjectCollection);
        }
        if (CollectionUtils.isNotEmpty(userRoleAssignParams)) {
            PermLogServiceHelper.savePermLogs(dynamicObjectCollection);
        }
    }

    private static void saveToSysUserRole(List<UserRoleAssignParam> userRoleAssignParams, Map<Integer, List<OrgRangeBean>> userOrgRangeMap, Map<String, String> sysUserRoleIdMap, Map<Long, Long> permFileUserMap, boolean enableValidateTime) {
        DynamicObjectCollection permUserRoleColl = new DynamicObjectCollection();
        for (int idx = 0; idx < userRoleAssignParams.size(); ++idx) {
            UserRoleAssignParam param = userRoleAssignParams.get(idx);
            List<OrgRangeBean> orgRangeBeans = userOrgRangeMap.get(idx);
            for (OrgRangeBean orgRangeBean : orgRangeBeans) {
                DynamicObject permUserRole = SYS_USER_ROLE_HELPER.generateEmptyDynamicObject();
                String sysUserRoleIdKey = RoleAssignService.joinToKey(idx, orgRangeBean.getBucaFuncId(), orgRangeBean.getOrgId());
                permUserRole.set("id", (Object)sysUserRoleIdMap.get(sysUserRoleIdKey));
                permUserRole.set("user", (Object)permFileUserMap.get(param.getPermFileId()));
                permUserRole.set("org", (Object)orgRangeBean.getOrgId());
                permUserRole.set("role", (Object)param.getRoleId());
                permUserRole.set("includesuborg", (Object)orgRangeBean.getIncludeSub());
                permUserRole.set("source", (Object)"hr");
                permUserRole.set("dimtype", (Object)"bos_org");
                if (enableValidateTime) {
                    permUserRole.set("starttime", (Object)param.getValidStart());
                    permUserRole.set("endtime", (Object)param.getValidEnd());
                }
                permUserRoleColl.add((Object)permUserRole);
            }
        }
        SYS_USER_ROLE_HELPER.save(permUserRoleColl);
    }

    private static void saveToUserRole(List<UserRoleAssignParam> userRoleAssignParams, Map<Integer, List<OrgRangeBean>> userOrgRangeMap, Map<String, String> sysUserRoleIdMap, Map<Integer, Long> userRoleRelatIdMap) {
        DynamicObjectCollection userRoleColl = new DynamicObjectCollection();
        for (int idx = 0; idx < userRoleAssignParams.size(); ++idx) {
            UserRoleAssignParam param = userRoleAssignParams.get(idx);
            List<OrgRangeBean> orgRangeBeans = userOrgRangeMap.get(idx);
            for (OrgRangeBean orgRangeBean : orgRangeBeans) {
                DynamicObject userRoleDyna = USER_ROLE_HELPER.generateEmptyDynamicObject();
                userRoleDyna.set("org", (Object)orgRangeBean.getOrgId());
                userRoleDyna.set("includesuborg", (Object)orgRangeBean.getIncludeSub());
                userRoleDyna.set("userrolerealt", (Object)userRoleRelatIdMap.get(idx));
                String sysUserRoleIdKey = RoleAssignService.joinToKey(idx, orgRangeBean.getBucaFuncId(), orgRangeBean.getOrgId());
                userRoleDyna.set("userrolepf", (Object)sysUserRoleIdMap.get(sysUserRoleIdKey));
                userRoleDyna.set("bucafunc", (Object)orgRangeBean.getBucaFuncId());
                userRoleColl.add((Object)userRoleDyna);
            }
        }
        USER_ROLE_HELPER.save(userRoleColl);
    }

    private static Map<Integer, List<OrgRangeBean>> calUserOrgs(List<UserRoleAssignParam> userRoleAssignParams) {
        Set<String> keepSameRoles = userRoleAssignParams.stream().filter(param -> !param.isCustomData()).map(UserRoleAssignParam::getRoleId).collect(Collectors.toSet());
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        DynamicObject[] roleBuDynaArr = roleBuHelper.queryOriginalArray("hrbucafunc,role,org.id,containssub", new QFilter[]{new QFilter("role", "in", keepSameRoles)});
        HashMap roleOrgRangeMap = Maps.newHashMapWithExpectedSize((int)keepSameRoles.size());
        keepSameRoles.forEach(roleId -> {
            List cfr_ignored_0 = roleOrgRangeMap.put(roleId, Lists.newArrayListWithExpectedSize((int)16));
        });
        for (DynamicObject roleBuDyna : roleBuDynaArr) {
            String roleId2 = roleBuDyna.getString("role");
            OrgRangeBean orgRangeBean = new OrgRangeBean(Long.valueOf(roleBuDyna.getLong("hrbucafunc")), Long.valueOf(roleBuDyna.getLong("org.id")), Boolean.valueOf(roleBuDyna.getBoolean("containssub")));
            ((List)roleOrgRangeMap.get(roleId2)).add(orgRangeBean);
        }
        HashMap userOrgRangeMap = Maps.newHashMapWithExpectedSize((int)userRoleAssignParams.size());
        for (int idx = 0; idx < userRoleAssignParams.size(); ++idx) {
            UserRoleAssignParam param2 = userRoleAssignParams.get(idx);
            List<OrgRangeBean> userOrgRanges = Lists.newArrayListWithExpectedSize((int)16);
            if (param2.isCustomData()) {
                Map bucaPermData = param2.getDataRangeParam().getBucaPermData();
                for (UserBucaPermDataParam bucaPermDataParam : bucaPermData.values()) {
                    Long bucaId = bucaPermDataParam.getBucaId();
                    for (Map.Entry orgEntry : bucaPermDataParam.getOrgInfos().entrySet()) {
                        OrgRangeBean orgRangeBean = new OrgRangeBean(bucaId, (Long)orgEntry.getKey(), (Boolean)orgEntry.getValue());
                        userOrgRanges.add(orgRangeBean);
                    }
                }
            } else {
                userOrgRanges = (List)roleOrgRangeMap.get(param2.getRoleId());
            }
            userOrgRangeMap.put(idx, userOrgRanges);
        }
        return userOrgRangeMap;
    }

    private static void saveToUserRoleRelat(List<UserRoleAssignParam> userRoleAssignParams, Map<Integer, Long> userRoleRelatIdMap, Map<Long, Long> permFileUserMap, boolean enableValidateTime) {
        DynamicObjectCollection userRoleRelatColl = new DynamicObjectCollection();
        for (int idx = 0; idx < userRoleAssignParams.size(); ++idx) {
            UserRoleAssignParam param = userRoleAssignParams.get(idx);
            Long permFileId = param.getPermFileId();
            Long userRoleRelatId = userRoleRelatIdMap.get(idx);
            DynamicObject userRoleRelatDyna = USER_ROLE_RELAT_HELPER.generateEmptyDynamicObject();
            userRoleRelatDyna.set("id", (Object)userRoleRelatId);
            userRoleRelatDyna.set("permfile", (Object)permFileId);
            userRoleRelatDyna.set("user", (Object)permFileUserMap.get(permFileId));
            userRoleRelatDyna.set("role", (Object)param.getRoleId());
            userRoleRelatDyna.set("customenable", (Object)(param.isCustomData() ? "1" : "0"));
            if (enableValidateTime) {
                userRoleRelatDyna.set("validstart", (Object)param.getValidStart());
                userRoleRelatDyna.set("validend", (Object)param.getValidEnd());
            }
            Date now = new Date();
            userRoleRelatDyna.set("createtime", (Object)now);
            userRoleRelatDyna.set("creator", (Object)param.getCreatorId());
            userRoleRelatDyna.set("modifytime", (Object)now);
            userRoleRelatDyna.set("modifier", (Object)param.getCreatorId());
            AssignSource assignSource = param.getAssignSource();
            String sourceType = assignSource.getSourceType();
            if (HRStringUtils.isEmpty((String)sourceType)) {
                sourceType = "1";
            }
            userRoleRelatDyna.set("sourcetype", (Object)assignSource.getSourceType());
            if (HRStringUtils.equals((String)sourceType, (String)"3")) {
                userRoleRelatDyna.set("initrecord", (Object)assignSource.getInitRecordId());
            } else if (HRStringUtils.equals((String)sourceType, (String)"4")) {
                userRoleRelatDyna.set("scheme", (Object)assignSource.getSchemeId());
            }
            userRoleRelatColl.add((Object)userRoleRelatDyna);
        }
        USER_ROLE_RELAT_HELPER.save(userRoleRelatColl);
    }

    private static void saveToUserField(List<UserRoleAssignParam> userRoleAssignParams, Map<Integer, Long> userRoleRelatIdMap) {
        DynamicObjectCollection userFieldColl = new DynamicObjectCollection();
        for (int idx = 0; idx < userRoleAssignParams.size(); ++idx) {
            UserRoleAssignParam param = userRoleAssignParams.get(idx);
            Long userRoleRelatId = userRoleRelatIdMap.get(idx);
            List fieldPermParams = param.getDataRangeParam().getFieldPermParams();
            if (!CollectionUtils.isNotEmpty((Collection)fieldPermParams)) continue;
            HashMap entityFieldDynaMap = Maps.newHashMapWithExpectedSize((int)16);
            Date now = new Date();
            for (EntityFieldPermParam userFieldParam : fieldPermParams) {
                String key = RoleAssignService.joinToKey(userFieldParam.getAppId(), userFieldParam.getEntityNumber());
                DynamicObject entityFieldDyna = (DynamicObject)entityFieldDynaMap.get(key);
                if (Objects.isNull(entityFieldDyna)) {
                    entityFieldDyna = USER_FIELD_HELPER.generateEmptyDynamicObject();
                    entityFieldDyna.set("userrolerealt", (Object)userRoleRelatId);
                    entityFieldDyna.set("app", (Object)userFieldParam.getAppId());
                    entityFieldDyna.set("entitytype", (Object)userFieldParam.getEntityNumber());
                    entityFieldDyna.set("createtime", (Object)now);
                    entityFieldDyna.set("creator", (Object)param.getCreatorId());
                    entityFieldDyna.set("modifytime", (Object)now);
                    entityFieldDyna.set("modifier", (Object)param.getCreatorId());
                    entityFieldDynaMap.put(key, entityFieldDyna);
                    userFieldColl.add((Object)entityFieldDyna);
                }
                DynamicObjectCollection dataRuleEntryColl = entityFieldDyna.getDynamicObjectCollection("entryentity");
                DynamicObject entryRow = dataRuleEntryColl.addNew();
                entryRow.set("fieldname", (Object)userFieldParam.getPropKey());
                entryRow.set("isbanread", (Object)(!userFieldParam.isCanRead() ? 1 : 0));
                entryRow.set("isbanwrite", (Object)(!userFieldParam.isCanWrite() ? 1 : 0));
            }
        }
        USER_FIELD_HELPER.save(userFieldColl);
    }

    private static void saveToUserDataRule(List<UserRoleAssignParam> userRoleAssignParams, Map<Integer, Long> userRoleRelatIdMap) {
        DynamicObjectCollection userDataRuleColl = new DynamicObjectCollection();
        for (int idx = 0; idx < userRoleAssignParams.size(); ++idx) {
            DynamicObject entryRow;
            DynamicObjectCollection dataRuleEntryColl;
            DynamicObject entityDataRuleDyna;
            String key;
            UserRoleAssignParam param = userRoleAssignParams.get(idx);
            Long userRoleRelatId = userRoleRelatIdMap.get(idx);
            List dataRuleParams = param.getDataRangeParam().getDataRuleParams();
            List bdDataRuleParams = param.getDataRangeParam().getBdDataRuleParams();
            HashMap entityDataRuleDynaMap = Maps.newHashMapWithExpectedSize((int)16);
            Date now = new Date();
            if (CollectionUtils.isNotEmpty((Collection)dataRuleParams)) {
                for (EntityDataRuleParam dataRuleParam : dataRuleParams) {
                    key = RoleAssignService.joinToKey(dataRuleParam.getAppId(), dataRuleParam.getEntityNumber());
                    entityDataRuleDyna = (DynamicObject)entityDataRuleDynaMap.get(key);
                    if (Objects.isNull(entityDataRuleDyna)) {
                        entityDataRuleDyna = USER_DATARULE_HELPER.generateEmptyDynamicObject();
                        entityDataRuleDyna.set("userrolerelate", (Object)userRoleRelatId);
                        entityDataRuleDyna.set("app", (Object)dataRuleParam.getAppId());
                        entityDataRuleDyna.set("entitytype", (Object)dataRuleParam.getEntityNumber());
                        entityDataRuleDyna.set("createdatefield", (Object)now);
                        entityDataRuleDyna.set("createrfield", (Object)param.getCreatorId());
                        entityDataRuleDyna.set("modifierfield", (Object)now);
                        entityDataRuleDyna.set("modifierfield", (Object)param.getCreatorId());
                        entityDataRuleDynaMap.put(key, entityDataRuleDyna);
                        userDataRuleColl.add((Object)entityDataRuleDyna);
                    }
                    dataRuleEntryColl = entityDataRuleDyna.getDynamicObjectCollection("dataruleentry");
                    entryRow = dataRuleEntryColl.addNew();
                    entryRow.set("permitem", (Object)dataRuleParam.getPermItemId());
                    entryRow.set("datarule", (Object)dataRuleParam.getDataRuleId());
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)bdDataRuleParams)) continue;
            for (EntityBdDataRuleParam bdDataRuleParam : bdDataRuleParams) {
                key = RoleAssignService.joinToKey(bdDataRuleParam.getAppId(), bdDataRuleParam.getEntityNumber());
                entityDataRuleDyna = (DynamicObject)entityDataRuleDynaMap.get(key);
                if (Objects.isNull(entityDataRuleDyna)) {
                    entityDataRuleDyna = USER_DATARULE_HELPER.generateEmptyDynamicObject();
                    entityDataRuleDyna.set("userrolerelate", (Object)userRoleRelatId);
                    entityDataRuleDyna.set("app", (Object)bdDataRuleParam.getAppId());
                    entityDataRuleDyna.set("entitytype", (Object)bdDataRuleParam.getEntityNumber());
                    entityDataRuleDyna.set("createdatefield", (Object)now);
                    entityDataRuleDyna.set("createrfield", (Object)param.getCreatorId());
                    entityDataRuleDyna.set("modifierfield", (Object)now);
                    entityDataRuleDyna.set("modifierfield", (Object)param.getCreatorId());
                    entityDataRuleDynaMap.put(key, entityDataRuleDyna);
                    userDataRuleColl.add((Object)entityDataRuleDyna);
                }
                dataRuleEntryColl = entityDataRuleDyna.getDynamicObjectCollection("bddataruleentry");
                entryRow = dataRuleEntryColl.addNew();
                entryRow.set("propkey", (Object)bdDataRuleParam.getPropKey());
                entryRow.set("propentnum", (Object)bdDataRuleParam.getPropEntityNumber());
                entryRow.set("bddatarule", (Object)bdDataRuleParam.getDataRuleId());
            }
        }
        USER_DATARULE_HELPER.save(userDataRuleColl);
    }

    private static void saveToUserDimGroup(List<UserRoleAssignParam> userRoleAssignParams, Map<Integer, Long> userRoleRelatIdMap) {
        Date now = new Date();
        for (int idx = 0; idx < userRoleAssignParams.size(); ++idx) {
            UserRoleAssignParam param = userRoleAssignParams.get(idx);
            Long userRoleRelatId = userRoleRelatIdMap.get(idx);
            Map bucaPermDataMap = param.getDataRangeParam().getBucaPermData();
            if (bucaPermDataMap == null || bucaPermDataMap.size() <= 0) continue;
            DynamicObjectCollection userRoleDimGrpColl = new DynamicObjectCollection();
            for (Map.Entry permDataEntry : bucaPermDataMap.entrySet()) {
                Long bucaId = (Long)permDataEntry.getKey();
                UserBucaPermDataParam permDataParam = (UserBucaPermDataParam)permDataEntry.getValue();
                List userDimGroupData = permDataParam.getUserDimGroupData();
                if (CollectionUtils.isEmpty((Collection)userDimGroupData)) continue;
                for (DimGroupParam userDimGroupDatum : userDimGroupData) {
                    DynamicObject userRoleDimGrp = USER_ROLE_DIMGRP_HELPER.generateEmptyDynamicObject();
                    userRoleDimGrp.set("userrolerelat", (Object)userRoleRelatId);
                    userRoleDimGrp.set("bucafunc", (Object)bucaId);
                    userRoleDimGrp.set("createtime", (Object)now);
                    userRoleDimGrp.set("creator", (Object)param.getCreatorId());
                    userRoleDimGrp.set("modifytime", (Object)now);
                    userRoleDimGrp.set("modifier", (Object)param.getCreatorId());
                    DynamicObjectCollection dimValueCollection = userRoleDimGrp.getDynamicObjectCollection("entry");
                    Map dimValuesMap = userDimGroupDatum.getDimValuesMap();
                    for (Map.Entry dimValueEntry : dimValuesMap.entrySet()) {
                        Long dimId = (Long)dimValueEntry.getKey();
                        for (DimValueParam dimValueParam : (List)dimValueEntry.getValue()) {
                            DynamicObject row = dimValueCollection.addNew();
                            row.set("dimension", (Object)dimId);
                            row.set("isall", (Object)dimValueParam.isAll());
                            row.set("structproject", (Object)dimValueParam.getStructProject());
                            row.set("admincontainssub", (Object)dimValueParam.isAdminContainsSub());
                            row.set("containssub", (Object)dimValueParam.isContainsSub());
                            row.set("dimval", (Object)dimValueParam.getDimVal());
                            row.set("valtype", (Object)dimValueParam.getValType());
                            row.set("dynacond", (Object)dimValueParam.getDynaCondId());
                        }
                    }
                    userRoleDimGrpColl.add((Object)userRoleDimGrp);
                }
            }
            USER_ROLE_DIMGRP_HELPER.save(userRoleDimGrpColl);
        }
    }

    private static Map<Integer, Long> buildUserRoleRelatIdMap(List<UserRoleAssignParam> userRoleAssignParams) {
        HashMap userRoleRelatIdMap = Maps.newHashMapWithExpectedSize((int)userRoleAssignParams.size());
        long[] relatIds = ORM.create().genLongIds("hrcs_userrolerelat", userRoleAssignParams.size());
        for (int idx = 0; idx < userRoleAssignParams.size(); ++idx) {
            UserRoleAssignParam param = userRoleAssignParams.get(idx);
            param.getAssignSource().setRelateId(Long.valueOf(relatIds[idx]));
            userRoleRelatIdMap.put(idx, relatIds[idx]);
        }
        return userRoleRelatIdMap;
    }

    private static Map<String, String> buildSysUserRoleIdMap(List<UserRoleAssignParam> userRoleAssignParams, Map<Integer, List<OrgRangeBean>> userOrgRangeMap) {
        ArrayList sysUserRoleIdMapKeys = Lists.newArrayListWithExpectedSize((int)16);
        for (int idx = 0; idx < userRoleAssignParams.size(); ++idx) {
            UserRoleAssignParam param = userRoleAssignParams.get(idx);
            String roleId = param.getRoleId();
            List<OrgRangeBean> orgRangeBeans = userOrgRangeMap.get(idx);
            for (OrgRangeBean orgRangeBean : orgRangeBeans) {
                String key = RoleAssignService.joinToKey(idx, orgRangeBean.getBucaFuncId(), orgRangeBean.getOrgId());
                sysUserRoleIdMapKeys.add(key);
            }
        }
        HashMap sysUserRoleIdMap = Maps.newHashMapWithExpectedSize((int)sysUserRoleIdMapKeys.size());
        String[] ids = ORM.create().genStringIds("perm_userrole", sysUserRoleIdMapKeys.size());
        for (int idx = 0; idx < sysUserRoleIdMapKeys.size(); ++idx) {
            sysUserRoleIdMap.put(sysUserRoleIdMapKeys.get(idx), ids[idx]);
        }
        return sysUserRoleIdMap;
    }

    private static String joinToKey(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        if (objects.length < 1) {
            return sb.toString();
        }
        sb.append(objects[0].toString());
        for (int idx = 1; idx < objects.length; ++idx) {
            sb.append("_").append(objects[idx]);
        }
        return sb.toString();
    }
}

