/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.FieldPermModel;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRListFieldPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignSaveService;
import kd.hr.hrcs.bussiness.util.DynaSchemeRoleAssignDetailBean;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class DynaSchemeRoleAssignServiceHelper {
    private static final String HRBUCAFUNC = "bucafunc";
    private static final String ENTITYTYPE = "entitytype";
    private static final String ROLE_ENTRY_ID = "roleentryid";

    public static void enableChangeSaveHis(Map<Long, Long> idMap, Map<Long, Long> entryIdMap) {
        QFilter[] qFilters = new QFilter[]{new QFilter("scheme", "in", idMap.keySet()), new QFilter("iscurrentversion", "=", (Object)"1")};
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("hrcs_dynaschemeorg");
        DynamicObject[] orgArr = orgHelper.loadDynamicObjectArray(qFilters);
        HRBaseServiceHelper dimGrpHelper = new HRBaseServiceHelper("hrcs_dynaschemedimgrp");
        DynamicObject[] dimGrpArr = dimGrpHelper.loadDynamicObjectArray(qFilters);
        HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("hrcs_dynaschemedatarule");
        DynamicObject[] dataRuleArr = dataRuleHelper.loadDynamicObjectArray(qFilters);
        HRBaseServiceHelper fieldHelper = new HRBaseServiceHelper("hrcs_dynaschemefield");
        DynamicObject[] fieldArr = fieldHelper.loadDynamicObjectArray(qFilters);
        ArrayList hisVersionParamBos = Lists.newArrayListWithExpectedSize((int)4);
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setEffImmediately(true);
        if (orgArr.length > 0) {
            DynamicObject[] copyOrgArr = DynaSchemeRoleAssignServiceHelper.copyAndReplaceId(orgHelper, idMap, entryIdMap, orgArr);
            HisVersionParamBo orgHisVersionParamBo = new HisVersionParamBo();
            orgHisVersionParamBo.setHisDyns(copyOrgArr);
            orgHisVersionParamBo.setEntityNumber("hrcs_dynaschemeorg");
            hisVersionParamBos.add(orgHisVersionParamBo);
        }
        if (dimGrpArr.length > 0) {
            DynamicObject[] copyDimGrpArr = DynaSchemeRoleAssignServiceHelper.copyAndReplaceId(dimGrpHelper, idMap, entryIdMap, dimGrpArr);
            HisVersionParamBo dimGrpHisVersionParamBo = new HisVersionParamBo();
            dimGrpHisVersionParamBo.setHisDyns(copyDimGrpArr);
            dimGrpHisVersionParamBo.setEntityNumber("hrcs_dynaschemedimgrp");
            hisVersionParamBos.add(dimGrpHisVersionParamBo);
        }
        if (dataRuleArr.length > 0) {
            DynamicObject[] copyDataRuleArr = DynaSchemeRoleAssignServiceHelper.copyAndReplaceId(dataRuleHelper, idMap, entryIdMap, dataRuleArr);
            HisVersionParamBo dataRuleHisVersionParamBo = new HisVersionParamBo();
            dataRuleHisVersionParamBo.setHisDyns(copyDataRuleArr);
            dataRuleHisVersionParamBo.setEntityNumber("hrcs_dynaschemedatarule");
            hisVersionParamBos.add(dataRuleHisVersionParamBo);
        }
        if (fieldArr.length > 0) {
            DynamicObject[] copyFieldArr = DynaSchemeRoleAssignServiceHelper.copyAndReplaceId(fieldHelper, idMap, entryIdMap, fieldArr);
            HisVersionParamBo fieldHisVersionParamBo = new HisVersionParamBo();
            fieldHisVersionParamBo.setHisDyns(copyFieldArr);
            fieldHisVersionParamBo.setEntityNumber("hrcs_dynaschemefield");
            hisVersionParamBos.add(fieldHisVersionParamBo);
        }
        hisVersionParamListBo.setListHisVersionParamBo((List)hisVersionParamBos);
        HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    private static DynamicObject[] copyAndReplaceId(HRBaseServiceHelper serviceHelper, Map<Long, Long> idMap, Map<Long, Long> entryIdMap, DynamicObject[] sourceArr) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)sourceArr.length);
        for (DynamicObject sourceDy : sourceArr) {
            DynamicObject copyDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)sourceDy, (DynamicObject)copyDy, (boolean)true);
            long schemeId = copyDy.getLong("scheme.id");
            long roleEntryId = copyDy.getLong(ROLE_ENTRY_ID);
            copyDy.set("scheme_id", (Object)idMap.get(schemeId));
            copyDy.set(ROLE_ENTRY_ID, (Object)entryIdMap.get(roleEntryId));
            list.add(copyDy);
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static void saveRoleCustomHis(List<Object> successPkIds, boolean isAudit) {
        QFilter[] qFilters = new QFilter[]{new QFilter("scheme", "in", successPkIds)};
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("hrcs_dynaschemeorg");
        DynamicObject[] orgArr = orgHelper.loadDynamicObjectArray(qFilters);
        HRBaseServiceHelper dimGrpHelper = new HRBaseServiceHelper("hrcs_dynaschemedimgrp");
        DynamicObject[] dimGrpArr = dimGrpHelper.loadDynamicObjectArray(qFilters);
        HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("hrcs_dynaschemedatarule");
        DynamicObject[] dataRuleArr = dataRuleHelper.loadDynamicObjectArray(qFilters);
        HRBaseServiceHelper fieldHelper = new HRBaseServiceHelper("hrcs_dynaschemefield");
        DynamicObject[] fieldArr = fieldHelper.loadDynamicObjectArray(qFilters);
        ArrayList hisVersionParamBos = Lists.newArrayListWithExpectedSize((int)4);
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setEffImmediately(true);
        if (orgArr.length > 0) {
            HisVersionParamBo orgHisVersionParamBo = new HisVersionParamBo();
            orgHisVersionParamBo.setHisDyns(orgArr);
            orgHisVersionParamBo.setEntityNumber("hrcs_dynaschemeorg");
            hisVersionParamBos.add(orgHisVersionParamBo);
        }
        if (dimGrpArr.length > 0) {
            HisVersionParamBo dimGrpHisVersionParamBo = new HisVersionParamBo();
            dimGrpHisVersionParamBo.setHisDyns(dimGrpArr);
            dimGrpHisVersionParamBo.setEntityNumber("hrcs_dynaschemedimgrp");
            hisVersionParamBos.add(dimGrpHisVersionParamBo);
        }
        if (dataRuleArr.length > 0) {
            HisVersionParamBo dataRuleHisVersionParamBo = new HisVersionParamBo();
            dataRuleHisVersionParamBo.setHisDyns(dataRuleArr);
            dataRuleHisVersionParamBo.setEntityNumber("hrcs_dynaschemedatarule");
            hisVersionParamBos.add(dataRuleHisVersionParamBo);
        }
        if (fieldArr.length > 0) {
            HisVersionParamBo fieldHisVersionParamBo = new HisVersionParamBo();
            fieldHisVersionParamBo.setHisDyns(fieldArr);
            fieldHisVersionParamBo.setEntityNumber("hrcs_dynaschemefield");
            hisVersionParamBos.add(fieldHisVersionParamBo);
        }
        hisVersionParamListBo.setListHisVersionParamBo((List)hisVersionParamBos);
        HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
        if (isAudit) {
            QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
            HRBaseServiceHelper schemeHelper = new HRBaseServiceHelper("hrcs_dynascheme");
            DynamicObject[] schemeArr = schemeHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("boid", "in", successPkIds)});
            HashMap boidMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap entryBoidMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject scheme : schemeArr) {
                long sourceVid = scheme.getLong("sourcevid");
                if (0L == sourceVid) continue;
                long id = scheme.getLong("id");
                boidMap.put(id, sourceVid);
                Optional<DynamicObject> optional = Arrays.stream(schemeArr).filter(it -> it.getLong("id") == sourceVid).findFirst();
                if (!optional.isPresent()) continue;
                DynamicObject hisScheme = optional.get();
                DynamicObjectCollection roleColl = scheme.getDynamicObjectCollection("roleentry");
                DynamicObjectCollection hisRoleColl = hisScheme.getDynamicObjectCollection("roleentry");
                int index = 0;
                for (DynamicObject role : roleColl) {
                    long entryId = role.getLong("id");
                    long hisEntryId = ((DynamicObject)hisRoleColl.get(index)).getLong("id");
                    entryBoidMap.put(entryId, hisEntryId);
                    ++index;
                }
            }
            QFilter[] hisFilters = new QFilter[]{new QFilter("scheme", "in", successPkIds), currentVersionFilter};
            DynamicObject[] orgHisArr = orgHelper.loadDynamicObjectArray(hisFilters);
            DynamicObject[] dimGrpHisArr = dimGrpHelper.loadDynamicObjectArray(hisFilters);
            DynamicObject[] dataRuleHisArr = dataRuleHelper.loadDynamicObjectArray(hisFilters);
            DynamicObject[] fieldHisArr = fieldHelper.loadDynamicObjectArray(hisFilters);
            DynaSchemeRoleAssignServiceHelper.replaceToHisId(orgHisArr, boidMap, entryBoidMap);
            DynaSchemeRoleAssignServiceHelper.replaceToHisId(dimGrpHisArr, boidMap, entryBoidMap);
            DynaSchemeRoleAssignServiceHelper.replaceToHisId(dataRuleHisArr, boidMap, entryBoidMap);
            DynaSchemeRoleAssignServiceHelper.replaceToHisId(fieldHisArr, boidMap, entryBoidMap);
            orgHelper.save(orgHisArr);
            dimGrpHelper.save(dimGrpHisArr);
            dataRuleHelper.save(dataRuleHisArr);
            fieldHelper.save(fieldHisArr);
        }
    }

    private static void replaceToHisId(DynamicObject[] curDataArr, Map<Long, Long> boidMap, Map<Long, Long> entryBoidMap) {
        for (DynamicObject curData : curDataArr) {
            long schemeId = curData.getLong("scheme.id");
            long roleEntryId = curData.getLong(ROLE_ENTRY_ID);
            curData.set("scheme", (Object)boidMap.get(schemeId));
            curData.set("iscurrentversion", (Object)"1");
            curData.set(ROLE_ENTRY_ID, (Object)entryBoidMap.get(roleEntryId));
        }
    }

    public static void saveRoleEntry(long dynamicSchemeId, DynamicObjectCollection roleEntry, boolean effImmediately) {
        ArrayList roleIds = Lists.newArrayListWithExpectedSize((int)roleEntry.size());
        HashMap permDataMaps = Maps.newHashMapWithExpectedSize((int)roleEntry.size());
        HashMap fieldPermDatas = Maps.newHashMapWithExpectedSize((int)roleEntry.size());
        for (DynamicObject row : roleEntry) {
            String customEnable = row.getString("customenable");
            if (HRStringUtils.equals((String)"0", (String)customEnable)) continue;
            long roleEntryId = row.getLong("id");
            String roleId = row.getString("role.id");
            roleIds.add(roleId);
            String customInfo = row.getString("custominfo");
            DynaSchemeRoleAssignDetailBean roleAssignDetail = (DynaSchemeRoleAssignDetailBean)SerializationUtils.fromJsonString((String)customInfo, DynaSchemeRoleAssignDetailBean.class);
            Map<String, UserRoleFieldPermInfo> fieldPermData = roleAssignDetail.getFieldDataMap();
            Map<String, RoleDataPermModel> dataPermMap = roleAssignDetail.getDataMap();
            if (MapUtils.isNotEmpty(fieldPermData)) {
                fieldPermDatas.put(roleId, Pair.of((Object)roleEntryId, fieldPermData));
            }
            if (!MapUtils.isNotEmpty(dataPermMap)) continue;
            permDataMaps.put(roleId, Pair.of((Object)roleEntryId, dataPermMap));
        }
        DynaSchemeRoleAssignServiceHelper.save(dynamicSchemeId, roleIds, permDataMaps, fieldPermDatas, effImmediately);
    }

    public static void save(long dynamicSchemeId, List<String> roleIds, Map<String, Pair<Long, Map<String, RoleDataPermModel>>> permDataMaps, Map<String, Pair<Long, Map<String, UserRoleFieldPermInfo>>> fieldPermDatas, boolean effImmediately) {
        try (TXHandle handle = TX.required();){
            DynamicObject[] fieldPermDys;
            HisModelController instance = HisModelController.getInstance();
            if (MapUtils.isNotEmpty(permDataMaps)) {
                DynamicObject[] dataRuleDys;
                DynamicObject[] dimDys;
                DynamicObject[] hrBuDys = DynaSchemeRoleAssignServiceHelper.saveHrBu(dynamicSchemeId, roleIds, permDataMaps);
                if (hrBuDys.length > 0) {
                    HisVersionParamBo orgHisVersionParamBo = new HisVersionParamBo();
                    orgHisVersionParamBo.setEffImmediately(effImmediately);
                    orgHisVersionParamBo.setEntityNumber("hrcs_dynaschemeorg");
                    orgHisVersionParamBo.setHisDyns(hrBuDys);
                    orgHisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
                    instance.noLineTimeHisVersionChange(orgHisVersionParamBo);
                }
                if ((dimDys = DynaSchemeRoleAssignServiceHelper.saveDimData(dynamicSchemeId, roleIds, permDataMaps)).length > 0) {
                    HisVersionParamBo dimGrpHisVersionParamBo = new HisVersionParamBo();
                    dimGrpHisVersionParamBo.setEffImmediately(effImmediately);
                    dimGrpHisVersionParamBo.setEntityNumber("hrcs_dynaschemedimgrp");
                    dimGrpHisVersionParamBo.setHisDyns(dimDys);
                    dimGrpHisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
                    instance.noLineTimeHisVersionChange(dimGrpHisVersionParamBo);
                }
                if ((dataRuleDys = DynaSchemeRoleAssignServiceHelper.saveRoleDataRule(dynamicSchemeId, roleIds, permDataMaps)).length > 0) {
                    HisVersionParamBo dataRuleHisVersionParamBo = new HisVersionParamBo();
                    dataRuleHisVersionParamBo.setEffImmediately(effImmediately);
                    dataRuleHisVersionParamBo.setEntityNumber("hrcs_dynaschemedatarule");
                    dataRuleHisVersionParamBo.setHisDyns(dataRuleDys);
                    dataRuleHisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
                    instance.noLineTimeHisVersionChange(dataRuleHisVersionParamBo);
                }
            }
            if (MapUtils.isNotEmpty(fieldPermDatas) && (fieldPermDys = DynaSchemeRoleAssignServiceHelper.saveRoleFieldPerm(dynamicSchemeId, roleIds, fieldPermDatas)).length > 0) {
                HisVersionParamBo fieldHisVersionParamBo = new HisVersionParamBo();
                fieldHisVersionParamBo.setEffImmediately(effImmediately);
                fieldHisVersionParamBo.setEntityNumber("hrcs_dynaschemefield");
                fieldHisVersionParamBo.setHisDyns(fieldPermDys);
                fieldHisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
                instance.noLineTimeHisVersionChange(fieldHisVersionParamBo);
            }
        }
    }

    private static DynamicObject[] saveHrBu(long dynamicSchemeId, List<String> roleIds, Map<String, Pair<Long, Map<String, RoleDataPermModel>>> permDataMaps) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynaschemeorg");
        helper.deleteByFilter(new QFilter[]{new QFilter("scheme", "=", (Object)dynamicSchemeId)});
        DynamicObject[] items = (DynamicObject[])roleIds.stream().filter(permDataMaps::containsKey).map(roleId -> {
            Long entryId = (Long)((Pair)permDataMaps.get(roleId)).getLeft();
            Map permDataMap = (Map)((Pair)permDataMaps.get(roleId)).getRight();
            Optional<Integer> reduce = permDataMap.values().stream().map(roleDataPermModel -> roleDataPermModel.getOrgMap().size()).reduce(Integer::sum);
            if (!reduce.isPresent()) {
                return null;
            }
            int hrBuSize = reduce.get();
            long[] ids = DBServiceHelper.genLongIds((String)"hrcs_dynaschemeorg", (int)hrBuSize);
            int idIdx = 0;
            ArrayList<DynamicObject> saveDyColl = new ArrayList<DynamicObject>();
            DynamicObject emptyDy = helper.generateEmptyDynamicObject();
            for (Map.Entry roleDataPermEntry : permDataMap.entrySet()) {
                String buCaId = (String)roleDataPermEntry.getKey();
                Map orgMap = ((RoleDataPermModel)roleDataPermEntry.getValue()).getOrgMap();
                for (Map.Entry orgEntry : orgMap.entrySet()) {
                    Map orgInfo = (Map)orgEntry.getValue();
                    DynamicObject dy = new DynamicObject(emptyDy.getDynamicObjectType());
                    dy.set("id", (Object)ids[idIdx]);
                    dy.set(ROLE_ENTRY_ID, (Object)entryId);
                    dy.set("scheme", (Object)dynamicSchemeId);
                    dy.set("role", roleId);
                    dy.set("org", (Object)Long.parseLong(String.valueOf(orgInfo.get("id"))));
                    dy.set("includesuborg", orgInfo.get("includeSub"));
                    dy.set(HRBUCAFUNC, (Object)Long.parseLong(buCaId));
                    saveDyColl.add(dy);
                    ++idIdx;
                }
            }
            return saveDyColl;
        }).filter(Objects::nonNull).flatMap(Collection::stream).toArray(DynamicObject[]::new);
        return items;
    }

    private static DynamicObject[] saveDimData(long dynamicSchemeId, List<String> roleIds, Map<String, Pair<Long, Map<String, RoleDataPermModel>>> permDataMaps) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynaschemedimgrp");
        helper.deleteByFilter(new QFilter[]{new QFilter("scheme", "=", (Object)dynamicSchemeId)});
        return (DynamicObject[])roleIds.stream().filter(permDataMaps::containsKey).map(roleId -> DynaSchemeRoleAssignServiceHelper.buildDimGrpData(dynamicSchemeId, roleId, (Pair<Long, Map<String, RoleDataPermModel>>)((Pair)permDataMaps.get(roleId)), helper)).flatMap(Collection::stream).toArray(DynamicObject[]::new);
    }

    private static DynamicObject[] saveRoleDataRule(long dynamicSchemeId, List<String> roleIds, Map<String, Pair<Long, Map<String, RoleDataPermModel>>> permDataMaps) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynaschemedatarule");
        helper.deleteByFilter(new QFilter[]{new QFilter("scheme", "=", (Object)dynamicSchemeId)});
        DynamicObject[] items = (DynamicObject[])roleIds.stream().filter(permDataMaps::containsKey).map(roleId -> {
            Long entryId = (Long)((Pair)permDataMaps.get(roleId)).getLeft();
            Map permDataMap = (Map)((Pair)permDataMaps.get(roleId)).getRight();
            Date now = new Date();
            ArrayList dataRules = new ArrayList();
            permDataMap.forEach((buCaFuncId, model) -> {
                Map appEntity2DataRules = model.getAppEntity2DataRules();
                if (appEntity2DataRules == null) {
                    return;
                }
                appEntity2DataRules.forEach((appEntity, dataRuleMainModel) -> {
                    String[] split = appEntity.split("#");
                    DynamicObject dataRuleMain = helper.generateEmptyDynamicObject();
                    dataRuleMain.set("scheme", (Object)dynamicSchemeId);
                    dataRuleMain.set("role", roleId);
                    dataRuleMain.set(ROLE_ENTRY_ID, (Object)entryId);
                    dataRuleMain.set("app", (Object)split[0]);
                    dataRuleMain.set(ENTITYTYPE, (Object)split[1]);
                    dataRuleMain.set(HRBUCAFUNC, buCaFuncId);
                    RoleMemberAssignSaveService.setSysField(dataRuleMain, now);
                    DynamicObjectCollection entryColl = helper.generateEmptyEntryCollection(dataRuleMain, "dataruleentry");
                    if (!CollectionUtils.isEmpty((Map)dataRuleMainModel.getDataRuleMap())) {
                        dataRuleMainModel.getDataRuleMap().forEach((key, value) -> {
                            if (HRStringUtils.equals((String)"emptyFlag", (String)key)) {
                                return;
                            }
                            value.getPermItem().forEach(permItem -> {
                                DynamicObject dataRuleEntry = helper.generateEmptyEntryDynamicObject("dataruleentry");
                                dataRuleEntry.set("permitem", permItem);
                                dataRuleEntry.set("datarule", (Object)value.getDataRuleId());
                                entryColl.add((Object)dataRuleEntry);
                            });
                        });
                    }
                    DynamicObjectCollection bdEntryColl = helper.generateEmptyEntryCollection(dataRuleMain, "hrcs_rolebdruleentry");
                    if (!CollectionUtils.isEmpty((Map)dataRuleMainModel.getBdDataRuleMap())) {
                        dataRuleMainModel.getBdDataRuleMap().forEach((propKey, bdDataRuleEntryModel) -> {
                            String property = bdDataRuleEntryModel.getProperty();
                            if (HRStringUtils.equals((String)"emptyFlag", (String)propKey)) {
                                return;
                            }
                            DynamicObject dataRuleEntry = helper.generateEmptyEntryDynamicObject("hrcs_rolebdruleentry");
                            dataRuleEntry.set("propkey", (Object)bdDataRuleEntryModel.getProperty());
                            dataRuleEntry.set("propkey", (Object)property);
                            dataRuleEntry.set("propentnum", (Object)bdDataRuleEntryModel.getPropertyNum());
                            dataRuleEntry.set("bddatarule", (Object)bdDataRuleEntryModel.getDataRuleId());
                            bdEntryColl.add((Object)dataRuleEntry);
                        });
                    }
                    if (CollectionUtils.isEmpty((Collection)bdEntryColl) && CollectionUtils.isEmpty((Collection)entryColl)) {
                        return;
                    }
                    dataRules.add(dataRuleMain);
                });
            });
            return dataRules;
        }).flatMap(Collection::stream).toArray(DynamicObject[]::new);
        return items;
    }

    private static DynamicObject[] saveRoleFieldPerm(long dynamicSchemeId, List<String> roleIds, Map<String, Pair<Long, Map<String, UserRoleFieldPermInfo>>> fieldPermInfos) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynaschemefield");
        helper.deleteByFilter(new QFilter[]{new QFilter("scheme", "=", (Object)dynamicSchemeId)});
        DynamicObject[] items = (DynamicObject[])roleIds.stream().filter(fieldPermInfos::containsKey).map(roleId -> {
            Long entryId = (Long)((Pair)fieldPermInfos.get(roleId)).getLeft();
            Map fieldPermInfo = (Map)((Pair)fieldPermInfos.get(roleId)).getRight();
            DynamicObject roleFieldPerm = helper.generateEmptyDynamicObject();
            DynamicObjectType roleFieldType = roleFieldPerm.getDynamicObjectType();
            DynamicObjectCollection roleFieldPerms = new DynamicObjectCollection();
            for (Map.Entry tempMap : fieldPermInfo.entrySet()) {
                String[] entityTypeInfo = ((String)tempMap.getKey()).split("@");
                roleFieldPerm = new DynamicObject(roleFieldType);
                roleFieldPerm.set("scheme", (Object)dynamicSchemeId);
                roleFieldPerm.set("role", roleId);
                roleFieldPerm.set(ROLE_ENTRY_ID, (Object)entryId);
                roleFieldPerm.set(ENTITYTYPE, (Object)entityTypeInfo[1]);
                roleFieldPerm.set("app", (Object)entityTypeInfo[0]);
                UserRoleFieldPermInfo userRoleFieldPermInfo = (UserRoleFieldPermInfo)tempMap.getValue();
                List<FieldPermModel> fieldList = userRoleFieldPermInfo.getFieldPermModelList();
                DynamicObjectCollection coll = helper.generateEmptyEntryCollection(roleFieldPerm, "fieldpermentry");
                for (FieldPermModel field : fieldList) {
                    DynamicObject fieldPermEntry = helper.generateEmptyEntryDynamicObject("fieldpermentry");
                    fieldPermEntry.set("fieldname", (Object)field.getFiledNum());
                    fieldPermEntry.set("isbanread", (Object)HRListFieldPermServiceHelper.getBlValue(field.getIsBanRead()));
                    fieldPermEntry.set("isbanwrite", (Object)HRListFieldPermServiceHelper.getBlValue(field.getIsBanWrite()));
                    coll.add((Object)fieldPermEntry);
                }
                roleFieldPerm.set("fieldpermentry", (Object)coll);
                roleFieldPerms.add((Object)roleFieldPerm);
            }
            return roleFieldPerms;
        }).flatMap(Collection::stream).toArray(DynamicObject[]::new);
        return items;
    }

    private static List<DynamicObject> buildDimGrpData(long dynaSchemeId, String roleId, Pair<Long, Map<String, RoleDataPermModel>> permDataMap, HRBaseServiceHelper helper) {
        ArrayList<DynamicObject> items = new ArrayList<DynamicObject>();
        Long entryId = (Long)permDataMap.getLeft();
        for (Map.Entry entry : ((Map)permDataMap.getRight()).entrySet()) {
            RoleDataPermModel roleDataPermModel = (RoleDataPermModel)entry.getValue();
            String buCaFuncId = (String)entry.getKey();
            Map dimGroupMap = roleDataPermModel.getDimGroupMap();
            for (Map.Entry dimGroupEntry : dimGroupMap.entrySet()) {
                DimGrpModel dimGroup = (DimGrpModel)dimGroupEntry.getValue();
                TreeMap dimMap = dimGroup.getDimMap();
                if (null == dimMap || dimMap.isEmpty()) continue;
                DynamicObject dimGrpDynamicObject = helper.generateEmptyDynamicObject();
                DynamicObjectCollection entryColl = helper.generateEmptyEntryCollection(dimGrpDynamicObject, "dimvalentry");
                dimGrpDynamicObject.set("scheme", (Object)dynaSchemeId);
                dimGrpDynamicObject.set(ROLE_ENTRY_ID, (Object)entryId);
                dimGrpDynamicObject.set("role", (Object)roleId);
                dimGrpDynamicObject.set(HRBUCAFUNC, (Object)buCaFuncId);
                dimGrpDynamicObject.set("index", (Object)dimGroup.getSeq());
                for (Map.Entry<String, DimModel> entry2 : dimMap.entrySet()) {
                    DimModel dimModel = (DimModel)entry2.getValue();
                    if (CollectionUtils.isEmpty((Map)dimModel.getDimValues()) && HRStringUtils.equals((String)"0", (String)dimModel.getLimit())) continue;
                    DynaSchemeRoleAssignServiceHelper.fillDimGrpEntry(helper, entryColl, entry2);
                }
                if (entryColl.size() <= 0) continue;
                items.add(dimGrpDynamicObject);
            }
        }
        return items;
    }

    private static void fillDimGrpEntry(HRBaseServiceHelper helper, DynamicObjectCollection entryColl, Map.Entry<String, DimModel> dim) {
        DynamicObject dataRuleEntry = helper.generateEmptyEntryDynamicObject("dimvalentry");
        DimModel dimModel = dim.getValue();
        Map dimValues = dimModel.getDimValues();
        if (CollectionUtils.isEmpty((Map)dimValues)) {
            dataRuleEntry.set("dimension", (Object)dimModel.getDimId());
            dataRuleEntry.set("isall", (Object)dimModel.getLimit());
            entryColl.add((Object)dataRuleEntry);
        } else {
            for (Map.Entry entry : dimValues.entrySet()) {
                dataRuleEntry = helper.generateEmptyEntryDynamicObject("dimvalentry");
                Map value = (Map)entry.getValue();
                String dynaCond = value.getOrDefault("dynamicCondition", "0");
                dataRuleEntry.set("dimension", (Object)dimModel.getDimId());
                dataRuleEntry.set("isall", (Object)dimModel.getLimit());
                dataRuleEntry.set("containssub", value.get("includeSub"));
                dataRuleEntry.set("admincontainssub", value.get("includeSubAdminOrg"));
                dataRuleEntry.set("dimval", value.get("id"));
                dataRuleEntry.set("valtype", (Object)value.getOrDefault("valueType", "1"));
                dataRuleEntry.set("dynacond", (Object)Long.parseLong(HRStringUtils.isEmpty((String)dynaCond) ? "0" : dynaCond));
                Object structProject = value.get("structProject");
                if (Objects.nonNull(structProject)) {
                    if (structProject instanceof Map) {
                        dataRuleEntry.set("structproject", (Object)Long.parseLong(((Map)structProject).get("id").toString()));
                    } else {
                        dataRuleEntry.set("structproject", (Object)Long.parseLong(structProject.toString()));
                    }
                }
                entryColl.add((Object)dataRuleEntry);
            }
        }
    }
}

