/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;

@ExcludeFromJacocoGeneratedReport
public class PermDiyDataService {
    private static final Log LOGGER = LogFactory.getLog(PermDiyDataService.class);

    public List<Map<String, Object>> getDiyData(DynamicObject dataSource, Long personId, Long employeeId) {
        LOGGER.info("PermDiyDataService_personId:{},employeeId:{}", (Object)personId, (Object)employeeId);
        DynamicObjectCollection paramEntry = dataSource.getDynamicObjectCollection("paramentry");
        Map<String, List<DynamicObject>> mServiceGroup = paramEntry.stream().filter(row -> HRStringUtils.equals((String)"custom", (String)row.getString("type"))).collect(Collectors.groupingBy(entry -> entry.getString("mserviceapp.number") + "." + entry.getString("mserviceclass") + "." + entry.getString("mservicemethod")));
        ArrayList allData = Lists.newArrayListWithExpectedSize((int)mServiceGroup.size());
        for (Map.Entry<String, List<DynamicObject>> entry2 : mServiceGroup.entrySet()) {
            List results;
            List<DynamicObject> value = entry2.getValue();
            DynamicObject first = value.get(0);
            String cloudNum = first.getString("mserviceapp.bizcloud.number").toLowerCase(Locale.ROOT);
            String appNum = first.getString("mserviceapp.number");
            String service = first.getString("mserviceclass");
            String method = first.getString("mservicemethod");
            String isvNum = first.getString("mserviceapp.isv");
            try {
                if ("kingdee".equals(isvNum)) {
                    if ("IHRPIEmployeeService".equals(service) && "getEmpentrel".equals(method)) {
                        Map data = (Map)HRMServiceHelper.invokeHRMPService((String)appNum, (String)service, (String)method, (Object[])new Object[]{employeeId});
                        results = Lists.newArrayListWithExpectedSize((int)1);
                        if (!CollectionUtils.isEmpty((Map)data)) {
                            results.add(data);
                        }
                    } else {
                        results = (List)HRMServiceHelper.invokeBizService((String)cloudNum, (String)appNum, (String)service, (String)method, (Object[])new Object[]{personId});
                    }
                } else {
                    results = (List)HRMServiceHelper.invokeService((String)cloudNum, (String)appNum, (String)service, (String)method, (Object[])new Object[]{personId});
                }
            }
            catch (Exception exception) {
                LOGGER.error("PermDiyDataService_invoke_error,service:{},method:{},msg:{}", new Object[]{service, method, exception.getMessage()});
                continue;
            }
            if (!CollectionUtils.isEmpty((Collection)results)) {
                allData.add(results);
            }
            LOGGER.info("PermDiyDataService_service:{},method:{},results:{}", new Object[]{service, method, results});
        }
        List cartesianList = Lists.cartesianProduct((List)allData);
        ArrayList personDataList = Lists.newArrayListWithExpectedSize((int)cartesianList.size());
        for (List cartesian : cartesianList) {
            if (CollectionUtils.isEmpty((Collection)cartesian)) continue;
            HashMap rowDataMap = Maps.newHashMapWithExpectedSize((int)cartesian.size());
            for (Map map : cartesian) {
                rowDataMap.putAll(map);
            }
            personDataList.add(rowDataMap);
        }
        return personDataList;
    }
}

