/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.perm.dyna.RuleParamApplyBean;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.dyna.DynaDataSourceServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper;
import kd.hr.hrcs.common.model.perm.PermConditionInfo;
import kd.hr.hrcs.common.model.perm.PermRuleConditionInfo;
import kd.hr.hrcs.common.model.perm.dyna.RuleParamDataSource;
import org.apache.commons.lang3.ObjectUtils;

@ExcludeFromJacocoGeneratedReport
public class RuleParamApplyServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(RuleParamApplyServiceHelper.class);

    public static void showApplyList(IFormView formView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("hrcs_ruleparamapplylist");
        formView.showForm(showParameter);
    }

    public static void showApplyDetail(long ruleParamId, IFormView formView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("hrcs_ruleparamapplydetail");
        showParameter.setCustomParam("ruleParamId", (Object)ruleParamId);
        String pageId = formView.getPageId() + "_" + ruleParamId;
        showParameter.setPageId(pageId);
        formView.showForm(showParameter);
    }

    public static List<RuleParamApplyBean> queryRuleParamListData() {
        HRBaseServiceHelper sceneHelper = new HRBaseServiceHelper("hrcs_dynascene");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter notNullFilter = new QFilter("msgpublisher", "!=", (Object)0L);
        DynamicObject[] sceneArr = sceneHelper.query("name,msgpublisher,authaction", new QFilter[]{enableFilter, notNullFilter});
        Map<Long, DynamicObject> sceneMap = Arrays.stream(sceneArr).filter(it -> ObjectUtils.isNotEmpty((Object)it.get("msgpublisher"))).collect(Collectors.toMap(it -> it.getLong("msgpublisher.id"), it -> it, (newVal, oldVal) -> newVal));
        HRBaseServiceHelper dataSourceHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        DynamicObject[] dataSourceArr = dataSourceHelper.query("msgpublisher,paramentry.ruleparam", new QFilter[]{enableFilter, notNullFilter});
        ArrayList ruleParamApplyBeanList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject dataSource : dataSourceArr) {
            DynamicObject msgPublisher = dataSource.getDynamicObject("msgpublisher");
            long msgPublisherId = msgPublisher.getLong("id");
            String msgPublisherName = msgPublisher.getString("name");
            if (!sceneMap.containsKey(msgPublisherId)) continue;
            DynamicObject sceneDy = sceneMap.get(msgPublisherId);
            DynamicObjectCollection paramEntry = dataSource.getDynamicObjectCollection("paramentry");
            for (DynamicObject entryRow : paramEntry) {
                DynamicObject ruleParam = entryRow.getDynamicObject("ruleparam");
                RuleParamApplyBean ruleParamApplyBean = new RuleParamApplyBean(ruleParam.getLong("id"), ruleParam.getString("name"), sceneDy.getString("name"), msgPublisherName, sceneDy.getString("authaction"));
                ruleParamApplyBeanList.add(ruleParamApplyBean);
            }
        }
        ruleParamApplyBeanList.sort(Comparator.comparing(RuleParamApplyBean::getRuleParamName));
        return ruleParamApplyBeanList;
    }

    public static Map<Long, DynamicObject> queryDsByPublisher(Set<Long> publisherIds) {
        HRBaseServiceHelper dataSourceHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dataSourceArr = dataSourceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, new QFilter("msgpublisher", "in", publisherIds)});
        HashMap publisherDSMap = Maps.newHashMapWithExpectedSize((int)dataSourceArr.length);
        for (DynamicObject dataSource : dataSourceArr) {
            publisherDSMap.put(dataSource.getLong("msgpublisher.id"), dataSource);
        }
        return publisherDSMap;
    }

    public static DynamicObject queryDsByPublisher(Long publisherId) {
        HRBaseServiceHelper dataSourceHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dataSourceArr = dataSourceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, new QFilter("msgpublisher", "=", (Object)publisherId)});
        if (dataSourceArr.length > 0) {
            return dataSourceArr[0];
        }
        return null;
    }

    public static DynamicObject queryDsBySceneId(Long sceneId) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        HRBaseServiceHelper sceneHelper = new HRBaseServiceHelper("hrcs_dynascene");
        DynamicObject sceneDyn = sceneHelper.queryOriginalOne("id,name,msgpublisher", new QFilter[]{new QFilter("id", "=", (Object)sceneId), enableFilter});
        long publisherId = sceneDyn.getLong("msgpublisher");
        HRBaseServiceHelper dataSourceHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        DynamicObject[] dataSourceArr = dataSourceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, new QFilter("msgpublisher", "=", (Object)publisherId)});
        if (dataSourceArr.length > 0) {
            return dataSourceArr[0];
        }
        return null;
    }

    public static DynamicObject queryCancelSource() {
        HRBaseServiceHelper dataSourceHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dataSourceArr = dataSourceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, new QFilter("iscancelds", "=", (Object)Boolean.TRUE)});
        if (dataSourceArr.length > 0) {
            return dataSourceArr[0];
        }
        return null;
    }

    public static DynamicObject[] queryDataSourceByRuleParamId(long ruleParamId) {
        HRBaseServiceHelper dataSourceHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return dataSourceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, new QFilter("msgpublisher", "!=", (Object)0L), new QFilter("paramentry.ruleparam", "=", (Object)ruleParamId), new QFilter("iscancelds", "=", (Object)Boolean.FALSE)});
    }

    private static int querySumDataSourceByRuleParamId(long ruleParamId, long publishId) {
        HRBaseServiceHelper dataSourceHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return dataSourceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, new QFilter("msgpublisher", "=", (Object)publishId), new QFilter("paramentry.ruleparam", "=", (Object)ruleParamId), new QFilter("iscancelds", "=", (Object)Boolean.FALSE)}).length;
    }

    private static int queryCancelDataSourceByRuleParamId(long ruleParamId) {
        HRBaseServiceHelper dataSourceHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return dataSourceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, new QFilter("paramentry.ruleparam", "=", (Object)ruleParamId), new QFilter("iscancelds", "=", (Object)Boolean.TRUE)}).length;
    }

    public static boolean getAssignRuleParamReference(long ruleParamId, long sceneId) {
        LOGGER.info("getAssignRuleParamReference ruleParamId={} sceneId={}", (Object)ruleParamId, (Object)sceneId);
        QFilter qFilter = new QFilter("search_assignscene.fbasedataid.id", "in", (Object)sceneId);
        HRBaseServiceHelper sceneHelper = new HRBaseServiceHelper("hrcs_dynascene");
        DynamicObject sceneDyn = sceneHelper.queryOriginalOne("id,name,msgpublisher", new QFilter[]{new QFilter("id", "=", (Object)sceneId)});
        long publishId = sceneDyn.getLong("msgpublisher");
        if (RuleParamApplyServiceHelper.querySumDataSourceByRuleParamId(ruleParamId, publishId) == 0) {
            LOGGER.info("querySumDataSourceByRuleParamId is null");
            return true;
        }
        return RuleParamApplyServiceHelper.validateScheme(ruleParamId, qFilter);
    }

    public static boolean getCancelRuleParamReference(long ruleParamId) {
        QFilter qFilter = new QFilter("search_cancelscene.fbasedataid.id", "is not null", null);
        if (RuleParamApplyServiceHelper.queryCancelDataSourceByRuleParamId(ruleParamId) == 0) {
            return true;
        }
        return RuleParamApplyServiceHelper.validateScheme(ruleParamId, qFilter);
    }

    private static boolean validateScheme(long ruleParamId, QFilter qFilter) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_dynascheme");
        DynamicObject[] conditions = baseServiceHelper.query("condition", new QFilter[]{qFilter});
        ArrayList objects = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject condition : conditions) {
            if (HRStringUtils.isEmpty((String)condition.getString("condition"))) continue;
            PermRuleConditionInfo ruleConditionInfo = (PermRuleConditionInfo)SerializationUtils.fromJsonString((String)condition.getString("condition"), PermRuleConditionInfo.class);
            List conditionList = ruleConditionInfo.getConditionList();
            LOGGER.info("conditionList={}", (Object)conditionList);
            List collect = conditionList.stream().map(PermConditionInfo::getParam).collect(Collectors.toList());
            if (!collect.contains(String.valueOf(ruleParamId))) continue;
            LOGGER.info("validateScheme ruleParamId={}", (Object)ruleParamId);
            objects.add(condition);
        }
        return CollectionUtils.isEmpty((Collection)objects);
    }

    public static Map<Long, DynamicObject> querySceneByRuleParam(long ruleParamId) {
        DynamicObject[] dataSourceArr = RuleParamApplyServiceHelper.queryDataSourceByRuleParamId(ruleParamId);
        HashMap publisherDSMap = Maps.newHashMapWithExpectedSize((int)dataSourceArr.length);
        for (DynamicObject dataSource : dataSourceArr) {
            publisherDSMap.put(dataSource.getLong("msgpublisher.id"), dataSource);
        }
        HRBaseServiceHelper sceneHelper = new HRBaseServiceHelper("hrcs_dynascene");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] sceneArr = sceneHelper.query("id,name,msgpublisher", new QFilter[]{enableFilter, new QFilter("msgpublisher", "in", publisherDSMap.keySet())});
        HashMap sceneDsMap = Maps.newHashMapWithExpectedSize((int)publisherDSMap.size());
        for (DynamicObject scene : sceneArr) {
            long sceneId = scene.getLong("id");
            long msgPublisherId = scene.getLong("msgpublisher.id");
            sceneDsMap.put(sceneId, publisherDSMap.get(msgPublisherId));
        }
        return sceneDsMap;
    }

    public static DynamicObject[] queryCancelDataSourceByRuleParam(long ruleParamId) {
        HRBaseServiceHelper dataSourceHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return dataSourceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, new QFilter("paramentry.ruleparam", "=", (Object)ruleParamId), new QFilter("iscancelds", "=", (Object)Boolean.TRUE)});
    }

    public static Map<Long, String> convertToFill(long ruleParamId, Map<Long, DynamicObject> sceneDsMap) {
        HashMap assignDsInfo = Maps.newHashMapWithExpectedSize((int)sceneDsMap.size());
        for (Map.Entry<Long, DynamicObject> entry : sceneDsMap.entrySet()) {
            Long sceneId = entry.getKey();
            DynamicObject dataSource = entry.getValue();
            long publisherId = dataSource.getLong("msgpublisher.id");
            DynamicObjectCollection paramEntry = dataSource.getDynamicObjectCollection("paramentry");
            DynamicObject entryRow = paramEntry.stream().filter(it -> it.getLong("ruleparam.id") == ruleParamId).findFirst().orElse(null);
            if (entryRow == null) continue;
            String fetchMode = entryRow.getString("fetchmode");
            RuleParamDataSource ruleParamDataSource = new RuleParamDataSource(fetchMode);
            ruleParamDataSource.setPublisherId(Long.valueOf(publisherId));
            ruleParamDataSource.setSysPreset(dataSource.getBoolean("issyspreset"));
            if (HRStringUtils.equals((String)"1", (String)fetchMode)) {
                String fetchSource = entryRow.getString("fetchsource");
                ruleParamDataSource.setDataSourceType(fetchSource);
                if (HRStringUtils.equals((String)"1", (String)fetchSource)) {
                    DynamicObjectCollection subEntry = entryRow.getDynamicObjectCollection("paramentitysubentry");
                    HashMap entityDsInfos = Maps.newHashMapWithExpectedSize((int)subEntry.size());
                    for (Object subEntryRow : subEntry) {
                        long entryPublisherId = subEntryRow.getLong("paramentity_publisherds.id");
                        String fieldKey = subEntryRow.getString("paramentity_propkey") + "#" + subEntryRow.getString("paramentity_propname");
                        entityDsInfos.put(entryPublisherId, fieldKey);
                    }
                    ArrayList<DynamicObject> publishEventDataSource = DynaDataSourceServiceHelper.getPublishEventDataSource(publisherId, "1");
                    if (!CollectionUtils.isEmpty(publishEventDataSource)) {
                        Object subEntryRow;
                        subEntryRow = publishEventDataSource.iterator();
                        while (subEntryRow.hasNext()) {
                            DynamicObject dynamicObject = (DynamicObject)subEntryRow.next();
                            long entryPublisherId = dynamicObject.getLong("id");
                            if (entityDsInfos.containsKey(entryPublisherId)) continue;
                            entityDsInfos.put(entryPublisherId, "#");
                        }
                    }
                    ruleParamDataSource.setEntityDsInfos((Map)entityDsInfos);
                } else {
                    long publisherSourceId = entryRow.getLong("publisherds.id");
                    String propKey = entryRow.getString("param_propkey");
                    String propName = entryRow.getString("param_propname");
                    ruleParamDataSource.setQuerySource(Long.valueOf(publisherSourceId));
                    ruleParamDataSource.setSourceFieldKey(propKey);
                    ruleParamDataSource.setSourceFieldName(propName);
                }
            } else {
                long formulaId = entryRow.getLong("dynaformula.id");
                ruleParamDataSource.setDynaFormulaId(Long.valueOf(formulaId));
            }
            assignDsInfo.put(sceneId, JSONArray.toJSONString((Object)ruleParamDataSource));
        }
        return assignDsInfo;
    }

    public static void openDynaFormulaPage(Object formulaId, Long ruleParamId, Long publisherId, String targetKey, IFormView formView) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hrcs_dynaformula");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        if (formulaId != null && (Long)formulaId != 0L) {
            showParameter.setPkId(formulaId);
        }
        showParameter.setCustomParam("msgpublisher", (Object)publisherId);
        showParameter.setCustomParam("ruleParamId", (Object)ruleParamId);
        formView.showForm((FormShowParameter)showParameter);
    }

    public static void openCancelDynaFormulaPage(Object formulaId, Long ruleParamId, String targetKey, IFormView formView) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hrcs_dynaformula");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        if (formulaId != null && (Long)formulaId != 0L) {
            showParameter.setPkId(formulaId);
        }
        showParameter.setCustomParam("newCancel", (Object)"1");
        showParameter.setCustomParam("ruleParamId", (Object)ruleParamId);
        formView.showForm((FormShowParameter)showParameter);
    }

    public static ArrayList<Map<String, Object>> getEntityFieldMap(String number) {
        ArrayList param = Lists.newArrayListWithCapacity((int)16);
        Map<String, String> entityFieldMap = RolePermLogServiceHelper.getEntityFieldMap(number);
        for (Map.Entry<String, String> entityField : entityFieldMap.entrySet()) {
            HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
            String fieldKey = entityField.getKey();
            String fieldName = entityField.getValue();
            objectObjectHashMap.put("fieldKey", fieldKey);
            objectObjectHashMap.put("fieldName", fieldName);
            param.add(objectObjectHashMap);
        }
        return param;
    }

    public static void showFieldForm(ArrayList<Map<String, Object>> param, CloseCallBack closeCallBack, IFormView formView) {
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)"hrcs_chooseapifield", (boolean)false, (int)0, (boolean)true);
        fsp.setCloseCallBack(closeCallBack);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("fieldParam", (Object)SerializationUtils.toJsonString(param));
        fsp.setHasRight(true);
        formView.showForm((FormShowParameter)fsp);
    }
}

