/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermFileSyncServiceHelper;
import kd.hr.hrcs.common.constants.perm.HRDynaPermConst;
import kd.hr.hrcs.common.model.perm.PersonInfo;
import kd.hr.hrcs.common.model.perm.dyna.ChgInfoResult;
import kd.hr.hrcs.common.model.perm.dyna.DynaApiInParam;
import kd.hr.hrcs.common.model.perm.dyna.DynaApiInfo;
import kd.hr.hrcs.common.model.perm.dyna.DynaPermConsumeContext;
import kd.hr.hrcs.common.model.perm.dyna.DynaPublisherDs;
import kd.hr.hrcs.common.model.perm.dyna.DynaRuleParam;
import org.apache.commons.collections4.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class DynaPermCommonService {
    private static final Log LOGGER = LogFactory.getLog(DynaPermCommonService.class);

    public static Map<Long, DynaPublisherDs> getPublisherDsByIds(Set<Long> publisherDsIds) {
        HRBaseServiceHelper publisherDsHelper = new HRBaseServiceHelper("hrcs_dynapublisherds");
        DynamicObject[] publisherDsDynaArr = publisherDsHelper.queryOriginalArray("id,number,sourceclassify,apisource.id,apisource.type,entitytype.number", new QFilter[]{new QFilter("id", "in", publisherDsIds)});
        HashMap publisherDsMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject publisherDsDyna : publisherDsDynaArr) {
            DynaPublisherDs dynaPublisherDs = new DynaPublisherDs();
            dynaPublisherDs.setId(Long.valueOf(publisherDsDyna.getLong("id")));
            dynaPublisherDs.setNumber(publisherDsDyna.getString("number"));
            String sourceClassify = publisherDsDyna.getString("sourceclassify");
            dynaPublisherDs.setSourceClassify(sourceClassify);
            if (HRStringUtils.equals((String)sourceClassify, (String)"2")) {
                dynaPublisherDs.setApiSourceId(Long.valueOf(publisherDsDyna.getLong("apisource.id")));
                dynaPublisherDs.setApiType(publisherDsDyna.getString("apisource.type"));
            } else if (HRStringUtils.equals((String)sourceClassify, (String)"1")) {
                dynaPublisherDs.setEntityNumber(publisherDsDyna.getString("entitytype.number"));
            }
            publisherDsMap.put(dynaPublisherDs.getId(), dynaPublisherDs);
        }
        return publisherDsMap;
    }

    public static Map<Long, DynaApiInfo> getApiInParamInfoByPublisherDs(Set<Long> publisherDsIds) {
        HRBaseServiceHelper publisherDsHelper = new HRBaseServiceHelper("hrcs_dynapublisherds");
        DynamicObject[] publisherDsDynaArr = publisherDsHelper.query("id,sourceclassify,apisource.id,paramentry.apifieldkey,paramentry.seq,paramentry.inputparamentryid,paramentry.invokeapisource", new QFilter[]{new QFilter("id", "in", publisherDsIds)});
        HashSet apiIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject publisherDsDyna : publisherDsDynaArr) {
            if (!HRStringUtils.equals((String)publisherDsDyna.getString("sourceclassify"), (String)"2")) continue;
            apiIds.add(publisherDsDyna.getLong("apisource.id"));
        }
        HRBaseServiceHelper apiHelper = new HRBaseServiceHelper("hrcs_apideploy");
        DynamicObject[] apiDynaArr = apiHelper.query("id,type,bizcloud.number,bizapp.number,bizapp.isv,service,method,inputentryentity.id,inputentryentity.inputfieldtype,inputentryentity.inputfielddefault,inputentryentity.seq", new QFilter[]{new QFilter("id", "in", (Object)apiIds)});
        HashMap apiDynaMap = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(apiDynaArr).forEach(dyna -> apiDynaMap.put(dyna.getLong("id"), dyna));
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyna2 : publisherDsDynaArr) {
            DynaApiInfo dynaApiInfo = new DynaApiInfo();
            dynaApiInfo.setPublisherDsId(Long.valueOf(dyna2.getLong("id")));
            Long apiId = dyna2.getLong("apisource.id");
            dynaApiInfo.setApiSourceId(apiId);
            DynamicObject apiDyna = (DynamicObject)apiDynaMap.get(apiId);
            HashMap inParamEntryDynaMap = Maps.newHashMapWithExpectedSize((int)16);
            if (apiDyna != null) {
                dynaApiInfo.setType(apiDyna.getString("type"));
                dynaApiInfo.setCloudNumber(apiDyna.getString("bizcloud.number"));
                dynaApiInfo.setAppNumber(apiDyna.getString("bizapp.number"));
                dynaApiInfo.setIsv(apiDyna.getString("bizapp.isv"));
                dynaApiInfo.setServiceClass(apiDyna.getString("service"));
                dynaApiInfo.setMethod(apiDyna.getString("method"));
                for (DynamicObject inParamEntryDyna : apiDyna.getDynamicObjectCollection("inputentryentity")) {
                    inParamEntryDynaMap.put(inParamEntryDyna.getLong("id"), inParamEntryDyna);
                }
            }
            LOGGER.info("DynaPermMsgConsumer getApiInParamInfoByDs apiId:{},inParamEntryDynaMap:{}", (Object)apiId, (Object)inParamEntryDynaMap);
            ArrayList apiInParams = Lists.newArrayListWithExpectedSize((int)16);
            DynamicObjectCollection paramEntry = dyna2.getDynamicObjectCollection("paramentry");
            LOGGER.info("DynaPermMsgConsumer getApiInParamInfoByDs apiId:{},dsParamEntry:{} ", (Object)apiId, (Object)paramEntry);
            for (DynamicObject entryDyna : paramEntry) {
                DynaApiInParam inParam = new DynaApiInParam();
                inParam.setInParamEntryId(Long.valueOf(entryDyna.getLong("inputparamentryid")));
                inParam.setSrcFieldKey(entryDyna.getString("apifieldkey"));
                inParam.setInvokeApiSourceId(Long.valueOf(entryDyna.getLong("invokeapisource.id")));
                DynamicObject inParamEntryDyna = (DynamicObject)inParamEntryDynaMap.get(entryDyna.getLong("inputparamentryid"));
                if (Objects.isNull(inParamEntryDyna)) {
                    LOGGER.warn("DynaPermMsgConsumer getApiInParamInfoByDs apiinput entryid not exist!!!! apiId:{},entryid:{}", (Object)apiId, (Object)entryDyna.getLong("inputparamentryid"));
                    continue;
                }
                inParam.setInParamType(inParamEntryDyna.getString("inputfieldtype"));
                inParam.setInParamDefault(inParamEntryDyna.getString("inputfielddefault"));
                inParam.setSeq(Integer.valueOf(inParamEntryDyna.getInt("seq")));
                apiInParams.add(inParam);
            }
            Collections.sort(apiInParams, new Comparator<DynaApiInParam>(){

                @Override
                public int compare(DynaApiInParam o1, DynaApiInParam o2) {
                    return o1.getSeq().compareTo(o2.getSeq());
                }
            });
            dynaApiInfo.setApiInParams((List)apiInParams);
            result.put(dynaApiInfo.getPublisherDsId(), dynaApiInfo);
        }
        LOGGER.info("DynaPermMsgConsumer getApiInParamInfoByDs,publisherDsIds:{},apiIds:{},apiInfoMap:{}", new Object[]{publisherDsIds, apiIds, result});
        return result;
    }

    public static Object invokeMservice(String cloudNumber, String appNumber, DynaApiInfo apiInfo, Object[] invokeParamArr) {
        return DynaPermCommonService.invokeMservice(apiInfo.getIsv(), cloudNumber, appNumber, apiInfo.getServiceClass(), apiInfo.getMethod(), invokeParamArr);
    }

    public static Object invokeMservice(String isv, String cloudNumber, String appNumber, String serviceClass, String method, Object[] invokeParamArr) {
        if ("kingdee".equals(isv)) {
            return HRMServiceHelper.invokeBizService((String)cloudNumber, (String)appNumber, (String)serviceClass, (String)method, (Object[])invokeParamArr);
        }
        return HRMServiceHelper.invokeService((String)cloudNumber, (String)appNumber, (String)serviceClass, (String)method, (Object[])invokeParamArr);
    }

    public static Object getApiInParamValueByFieldKey(DynaApiInParam apiInParam, ChgInfoResult chgInfoResult, PersonInfo personInfo, Long depId) {
        String srcFieldKey = apiInParam.getSrcFieldKey();
        if (HRStringUtils.isNotEmpty((String)srcFieldKey)) {
            switch (srcFieldKey) {
                case "billId": {
                    return chgInfoResult.getBillId();
                }
                case "billNo": {
                    return chgInfoResult.getBillNo();
                }
                case "billSource": {
                    return chgInfoResult.getBillSource();
                }
                case "effectTime": {
                    return chgInfoResult.getEffectTime();
                }
                case "hrpi_employee.boid": {
                    return personInfo.getEmployeeId();
                }
                case "hrpi_cmpemp.boid": {
                    return chgInfoResult.getCmpempId();
                }
                case "hrpi_depemp.boid": {
                    return depId;
                }
                case "hrpi_person.boid": {
                    return personInfo.getPersonId();
                }
            }
            return null;
        }
        String defaultValue = apiInParam.getInParamDefault();
        if (HRStringUtils.isNotEmpty((String)defaultValue)) {
            String inParamType = apiInParam.getInParamType();
            if (HRStringUtils.equals((String)inParamType, (String)"java.lang.Long")) {
                if (defaultValue.endsWith("L") || defaultValue.endsWith("l")) {
                    defaultValue = defaultValue.substring(0, defaultValue.length() - 1);
                }
                return Long.parseLong(defaultValue);
            }
            if (HRStringUtils.equals((String)inParamType, (String)"java.lang.String")) {
                return defaultValue;
            }
        } else {
            return null;
        }
        return null;
    }

    public static String objectToString(Object obj) {
        if (Objects.isNull(obj)) {
            return "";
        }
        return obj.toString();
    }

    public static List<Map<String, Object>> trimBusinessStatus(List<Map<String, Object>> mserviceResultList) {
        if (CollectionUtils.isEmpty(mserviceResultList)) {
            return mserviceResultList;
        }
        ArrayList trimedResultList = Lists.newArrayListWithExpectedSize((int)mserviceResultList.size());
        for (Map<String, Object> mserviceResult : mserviceResultList) {
            if (!DynaPermCommonService.isStatusValid(mserviceResult, "hspm_ermanfile.businessstatus") || !DynaPermCommonService.isStatusValid(mserviceResult, "hspm_ermanfile.iscurrentversion") || !DynaPermCommonService.isStatusValid(mserviceResult, "businessstatus") || !DynaPermCommonService.isStatusValid(mserviceResult, "iscurrentversion")) continue;
            trimedResultList.add(mserviceResult);
        }
        return trimedResultList;
    }

    private static boolean isStatusValid(Map<String, Object> mserviceResult, String key) {
        if (!mserviceResult.containsKey(key)) {
            return true;
        }
        Object status = mserviceResult.get(key);
        if (status instanceof String) {
            String statusStr = (String)status;
            return HRStringUtils.equals((String)statusStr, (String)"1");
        }
        if (status instanceof Boolean) {
            return (Boolean)status;
        }
        if (status instanceof Long) {
            return Objects.equals((Long)status, 1L);
        }
        if (status instanceof Integer) {
            return Objects.equals((Integer)status, 1);
        }
        return true;
    }

    public static ChgInfoResult getChgInfoResultFromContext(DynaPermConsumeContext context, Long invokeApiSourceId) {
        ChgInfoResult chgInfoResult;
        if (Objects.equals(invokeApiSourceId, HRDynaPermConst.INVOKE_SOURCE_API)) {
            chgInfoResult = context.getChgInfoResult();
        } else {
            Map customChgInfoResultMap = context.getCustomChgInfoResultMap();
            chgInfoResult = (ChgInfoResult)customChgInfoResultMap.get(invokeApiSourceId);
            if (Objects.isNull(chgInfoResult)) {
                chgInfoResult = DynaPermCommonService.getChgInfoResultByRecordIdAndApiId(context.getRecordId(), invokeApiSourceId);
                customChgInfoResultMap.put(invokeApiSourceId, chgInfoResult);
            }
        }
        return chgInfoResult;
    }

    public static ChgInfoResult getChgInfoResultByRecordIdAndApiId(Object recordId, Long invokeApiSourceId) {
        Map<String, Object> fourDataMap = DynaPermCommonService.getChgInfoMapByRecordIdAndApiId(recordId, invokeApiSourceId);
        if (fourDataMap == null) {
            return null;
        }
        ChgInfoResult result = DynaPermCommonService.chgInfoMap2Result(fourDataMap);
        return result;
    }

    public static Map<String, Object> getChgInfoMapByRecordIdAndApiId(Object recordId, Long invokeApiSourceId) {
        Map res;
        if (Objects.isNull(invokeApiSourceId) || Objects.equals(invokeApiSourceId, 0L) || Objects.equals(invokeApiSourceId, HRDynaPermConst.INVOKE_SOURCE_API)) {
            res = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoByRecordId", (Object[])new Object[]{recordId});
        } else {
            HRBaseServiceHelper apiHelper = new HRBaseServiceHelper("hrcs_apideploy");
            DynamicObject apiDyna = apiHelper.queryOriginalOne("id,type,bizcloud.number,bizapp.number,bizapp.isv,service,method", new QFilter[]{new QFilter("id", "=", (Object)invokeApiSourceId)});
            if (Objects.isNull(apiDyna)) {
                return null;
            }
            res = (Map)DynaPermCommonService.invokeMservice(apiDyna.getString("bizapp.isv"), apiDyna.getString("bizcloud.number").toLowerCase(Locale.ROOT), apiDyna.getString("bizapp.number"), apiDyna.getString("service"), apiDyna.getString("method"), new Object[]{recordId});
        }
        LOGGER.info("DynaPermCommonService.getChgInfoByRecordIdAndApiId recordId:{},invokeApiSourceId:{},result:{}", new Object[]{recordId, invokeApiSourceId, res});
        boolean reqResult = (Boolean)res.get("success");
        Map<String, Object> fourDataMap = new HashMap<String, Object>(4);
        if (reqResult) {
            Map data = (Map)res.get("data");
            ArrayList fourData = (ArrayList)data.get("data");
            if (null != fourData && !kd.bos.orm.util.CollectionUtils.isEmpty((Map)((Map)fourData.get(0)))) {
                fourDataMap = (Map)fourData.get(0);
                fourDataMap.put("billId", data.get("billId"));
                fourDataMap.put("billSource", data.get("billSource"));
                fourDataMap.put("billNo", data.get("billNo"));
            }
        } else {
            LOGGER.info("DynaPermCommonService-fourData-error:{}", res.get("errorMsg"));
        }
        return fourDataMap;
    }

    public static ChgInfoResult chgInfoMap2Result(Map<String, Object> chgInfoMap) {
        Map cmpemp;
        Map person;
        Map employee;
        ChgInfoResult chgInfoResult = new ChgInfoResult();
        Long billId = (Long)chgInfoMap.get("billId");
        String billEntityNumber = (String)chgInfoMap.get("billSource");
        String billNo = (String)chgInfoMap.get("billNo");
        chgInfoResult.setBillId(billId);
        chgInfoResult.setBillSource(billEntityNumber);
        chgInfoResult.setBillNo(billNo);
        Map depemp = (Map)chgInfoMap.get("hrpi_depemp");
        if (Objects.nonNull(depemp)) {
            Long depEmpId = (Long)depemp.get("boid");
            chgInfoResult.setDepempId(depEmpId);
        }
        if (Objects.nonNull(employee = (Map)chgInfoMap.get("hrpi_employee"))) {
            Long employeeId = (Long)employee.get("boid");
            chgInfoResult.setEmployeeId(employeeId);
        }
        if (Objects.nonNull(person = (Map)chgInfoMap.get("hrpi_person"))) {
            Long personId = (Long)person.get("boid");
            chgInfoResult.setPersonId(personId);
            Long sysUserId = (Long)PermFileSyncServiceHelper.getSysUserId(personId);
            chgInfoResult.setUserId(sysUserId);
        }
        if (Objects.nonNull(cmpemp = (Map)chgInfoMap.get("hrpi_cmpemp"))) {
            Long cmpempId = (Long)cmpemp.get("boid");
            chgInfoResult.setCmpempId(cmpempId);
        }
        LOGGER.info("DynaPermMsgConsumer chgInfoMap2ApiParam result:{}", (Object)chgInfoResult);
        return chgInfoResult;
    }

    public static Object getPropValFromMserviceMap(Map<String, Object> mserviceMap, String propKey, DynaPermConsumeContext context, Long ruleParamId) {
        Object paramValue = mserviceMap.get(propKey);
        if (HRStringUtils.endsWithIgnoreCase((String)propKey, (String)".number")) {
            DynaRuleParam dynaRuleParam = (DynaRuleParam)context.getAllRuleParamMap().get(ruleParamId);
            String entityNumber = dynaRuleParam.getEntityType();
            paramValue = DynaPermCommonService.getIdByNumber(entityNumber, (String)paramValue);
        }
        return paramValue;
    }

    private static Object getIdByNumber(String entityNumber, String number) {
        DynamicObject dynamicObject;
        if (HRStringUtils.isEmpty((String)entityNumber) || HRStringUtils.isEmpty((String)number)) {
            return null;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        QFilter numberQFilter = new QFilter("number", "=", (Object)number);
        String hisModelType = HisCommonService.getInstance().entityInhRelation(entityNumber);
        if (!HRStringUtils.equals((String)hisModelType, (String)EnumEntityTpl.COMMON_TPL.getNumber())) {
            numberQFilter = numberQFilter.and("iscurrentversion", "=", (Object)"1");
        }
        if (!Objects.isNull(dynamicObject = helper.queryOriginalOne("id", numberQFilter))) {
            return dynamicObject.get("id");
        }
        return null;
    }
}

