/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.common.model.perm.DepInfo;
import kd.hr.hrcs.common.model.perm.PersonInfo;
import kd.hr.hrcs.common.model.perm.dyna.PermFile;

@ExcludeFromJacocoGeneratedReport
public class DynaPermFileService {
    private static final Log LOGGER = LogFactory.getLog(DynaPermFileService.class);
    private static final HRBaseServiceHelper PERM_FILE_HELPER = new HRBaseServiceHelper("hrcs_userpermfile");

    public static Set<PermFile> geneUserPermFile(List<PersonInfo> personInfoSet) {
        Set userIdSet = personInfoSet.stream().map(PersonInfo::getUserId).collect(Collectors.toSet());
        HashSet permFileSet = Sets.newHashSetWithExpectedSize((int)personInfoSet.size());
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject[] userDys = userHelper.queryOriginalArray("id,name", new QFilter[]{new QFilter("id", "in", userIdSet)});
        HashMap userIdNameMap = Maps.newHashMapWithExpectedSize((int)userDys.length);
        for (DynamicObject dy : userDys) {
            userIdNameMap.put(dy.getLong("id"), dy.getString("name"));
        }
        for (PersonInfo personInfo : personInfoSet) {
            Set<PermFile> permFiles = DynaPermFileService.genePermFileId(personInfo, userIdNameMap);
            permFileSet.addAll(permFiles);
        }
        return permFileSet;
    }

    private static Set<PermFile> genePermFileId(PersonInfo personInfo, Map<Long, String> userIdNameMap) {
        ArrayList addColl = Lists.newArrayListWithExpectedSize((int)16);
        QFilter[] personFilter = new QFilter[]{new QFilter("user", "=", (Object)personInfo.getUserId())};
        HashSet permFileSet = Sets.newHashSetWithExpectedSize((int)16);
        Object[] permFileDys = PERM_FILE_HELPER.query("id,user,org,permfileenable,username,description", personFilter);
        Set depSet = personInfo.getDepSet();
        if (HRArrayUtils.isEmpty((Object[])permFileDys) && CollectionUtils.isEmpty((Collection)depSet)) {
            DynamicObject newPermFile = PERM_FILE_HELPER.generateEmptyDynamicObject();
            newPermFile.set("user", (Object)personInfo.getUserId());
            newPermFile.set("id", (Object)RoleMemberAssignServiceHelper.genLongId("hrcs_userpermfile"));
            newPermFile.set("org", (Object)OrgServiceUtil.getBuRootOrgId());
            newPermFile.set("permfileenable", (Object)"1");
            newPermFile.set("username", (Object)userIdNameMap.get(personInfo.getUserId()));
            newPermFile.set("description", (Object)ResManager.loadKDString((String)"\u7531\u52a8\u6001\u6388\u6743\u81ea\u52a8\u521b\u5efa\u3002", (String)"DynaPermFileService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            addColl.add(newPermFile);
            LOGGER.info("EventPermService genePermFieldId not ermanfile & not permfile,add root org permfile.userId:{}", (Object)personInfo.getUserId());
            if (addColl.size() > 0) {
                permFileSet.addAll(DynaPermFileService.saveOrUpdatePermFile(addColl, "1"));
            }
        } else if (CollectionUtils.isEmpty((Collection)depSet)) {
            List<DynamicObject> enablePfLst = Arrays.stream(permFileDys).filter(it -> HRStringUtils.equals((String)"1", (String)it.getString("permfileenable"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(enablePfLst)) {
                List<DynamicObject> disPfLst = Arrays.stream(permFileDys).collect(Collectors.toList());
                disPfLst.forEach(it -> it.set("permfileenable", (Object)"1"));
                permFileSet.addAll(DynaPermFileService.saveOrUpdatePermFile(disPfLst, "2"));
                LOGGER.info("EventPermService genePermFieldId not ermanfile, enable existed permfiles size:{},userId:{}", (Object)disPfLst.size(), (Object)personInfo.getUserId());
            } else {
                permFileSet.addAll(DynaPermFileService.saveOrUpdatePermFile(enablePfLst, ""));
            }
        } else {
            Set<Long> buSet = depSet.stream().map(DepInfo::getBuId).collect(Collectors.toSet());
            for (Object dy : permFileDys) {
                Long org = dy.getLong("org.id");
                String status = dy.getString("permfileenable");
                if (!buSet.remove(org)) continue;
                if (!HRStringUtils.equals((String)"1", (String)status)) {
                    dy.set("permfileenable", (Object)"1");
                    permFileSet.addAll(DynaPermFileService.saveOrUpdatePermFile(Lists.newArrayList((Object[])new DynamicObject[]{dy}), "2"));
                    continue;
                }
                permFileSet.addAll(DynaPermFileService.saveOrUpdatePermFile(Lists.newArrayList((Object[])new DynamicObject[]{dy}), ""));
            }
            if (buSet.size() > 0) {
                DynamicObjectCollection coll = DynaPermFileService.getNewUserDc(personInfo.getUserId(), userIdNameMap.get(personInfo.getUserId()), buSet);
                permFileSet.addAll(DynaPermFileService.saveOrUpdatePermFile(new ArrayList<DynamicObject>((Collection<DynamicObject>)coll), "1"));
                LOGGER.info("EventPermService genePermFieldId have ermanfile ,create new permfiles size:{}.userId:{}.", (Object)coll.size(), (Object)personInfo.getUserId());
            }
        }
        return permFileSet;
    }

    private static Set<PermFile> saveOrUpdatePermFile(List<DynamicObject> pfList, String changeType) {
        Object[] pFiles = PERM_FILE_HELPER.save(pfList.toArray(new DynamicObject[0]));
        HashSet set = Sets.newHashSetWithExpectedSize((int)pfList.size());
        for (Object obj : pFiles) {
            DynamicObject dy = (DynamicObject)obj;
            PermFile permFile = new PermFile();
            permFile.setId(Long.valueOf(dy.getLong("id")));
            permFile.setUserId(DynaPermFileService.getUserIdFromDynaObject(dy));
            permFile.setChangeType(changeType);
            set.add(permFile);
        }
        return set;
    }

    private static Long getUserIdFromDynaObject(DynamicObject dyna) {
        Long userId = dyna.getLong("user.id");
        if (Objects.isNull(userId) || Objects.equals(userId, 0L)) {
            userId = dyna.getLong("user");
            LOGGER.info("DynaPermMsgConsumer getUserIdFromDynaObject getLong(\"user\")");
        } else {
            LOGGER.info("DynaPermMsgConsumer getUserIdFromDynaObject getLong(\"user.id\")");
        }
        return userId;
    }

    private static DynamicObjectCollection getNewUserDc(Long sysUserId, String userName, Set<Long> buSet) {
        long[] ids = RoleMemberAssignServiceHelper.genLongIds("hrcs_userpermfile", buSet.size());
        int index = 0;
        DynamicObjectCollection addColl = new DynamicObjectCollection();
        for (Long bu : buSet) {
            DynamicObject newPermFile = PERM_FILE_HELPER.generateEmptyDynamicObject();
            newPermFile.set("user", (Object)sysUserId);
            newPermFile.set("org", (Object)bu);
            newPermFile.set("id", (Object)ids[index]);
            newPermFile.set("permfileenable", (Object)"1");
            newPermFile.set("username", (Object)userName);
            addColl.add((Object)newPermFile);
            ++index;
        }
        return addColl;
    }
}

