/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import java.util.Collection;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.perm.dyna.DynaScheme;

@ExcludeFromJacocoGeneratedReport
public class DynaPermLogService {
    public static String getSchemeSimpleInfo(List<DynaScheme> schemeList) {
        StringBuilder sb = new StringBuilder();
        sb.append("[size:").append(schemeList.size());
        for (DynaScheme scheme : schemeList) {
            sb.append(", {id=").append(scheme.getId());
            sb.append(", number='").append(scheme.getNumber()).append('\'');
            sb.append(", name='").append(scheme.getName()).append('\'');
            sb.append(", authAction='").append(scheme.getAuthAction()).append('\'');
            sb.append(", conditionLength=").append(scheme.getCondition().length());
            sb.append("}\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public static void writeSchemeListLog(Log logger, List<DynaScheme> schemeList) {
        int schemeSize = schemeList.size();
        for (int idx = 0; idx < schemeSize; idx += 5) {
            int endIndex = Math.min(schemeSize, idx + 5);
            String schemeLogStr = DynaPermLogService.getSchemeDealResultInfo(schemeList.subList(idx, endIndex));
            logger.info("DynaPermMsgConsumer result:true,schemeList-{}: {}", (Object)(idx + 1), (Object)schemeLogStr);
        }
    }

    public static String getSchemeDealResultInfo(List<DynaScheme> schemeList) {
        StringBuilder sb = new StringBuilder();
        for (DynaScheme scheme : schemeList) {
            String authAction = scheme.getAuthAction();
            sb.append("{id=").append(scheme.getId());
            sb.append(", number='").append(scheme.getNumber()).append('\'');
            sb.append(", name='").append(scheme.getName()).append('\'');
            sb.append(", conditionLength=").append(scheme.getCondition().length());
            sb.append(", authAction='").append(authAction).append('\'');
            sb.append(", roleList=").append(scheme.getRoleList());
            if (CollectionUtils.isEmpty((Collection)scheme.getNeedAssignPermFiles()) && CollectionUtils.isEmpty((Collection)scheme.getNeedCancelRelats())) {
                sb.append(", action=null").append("\n");
            } else {
                sb.append(", action=[");
                if (CollectionUtils.isNotEmpty((Collection)scheme.getNeedAssignPermFiles())) {
                    sb.append(" ASSIGN ");
                }
                if (CollectionUtils.isNotEmpty((Collection)scheme.getNeedCancelRelats())) {
                    sb.append(" CANCEL ");
                }
                sb.append("]\n");
            }
            if (HRStringUtils.equals((String)authAction, (String)"2") || HRStringUtils.equals((String)authAction, (String)"3")) {
                sb.append("cancelPersonItemId=").append(scheme.getCancelPersonItemId());
                sb.append(", cancelPersonInfos=").append(scheme.getCancelPersonInfos());
                sb.append(", noMatchedUserIds=").append(scheme.getNoMatchedUserIds());
                sb.append(", needCancelRelatIds=").append(scheme.getNeedCancelRelats()).append("\n");
            }
            if (HRStringUtils.equals((String)authAction, (String)"1") || HRStringUtils.equals((String)authAction, (String)"3")) {
                sb.append("assignPersonItemId=").append(scheme.getAssignPersonItemId());
                sb.append(", assignPersonInfos=").append(scheme.getAssignPersonInfos());
                sb.append(", matchedAssignPersonInfos=").append(scheme.getMatchedAssignPersonInfos());
                sb.append(", needAssignPermFiles=").append(scheme.getNeedAssignPermFiles()).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

