/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaApplyRecordService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaPermCommonService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaPermDealTraceService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaPermLogService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaPermMsgService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaRoleAssignService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaSchemeMatchService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaSchemeRoleService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaSchemeService;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermFileSyncServiceHelper;
import kd.hr.hrcs.common.model.perm.dyna.ApplyRecord;
import kd.hr.hrcs.common.model.perm.dyna.ChgInfoResult;
import kd.hr.hrcs.common.model.perm.dyna.DynaDs;
import kd.hr.hrcs.common.model.perm.dyna.DynaDsPerson;
import kd.hr.hrcs.common.model.perm.dyna.DynaPermConsumeContext;
import kd.hr.hrcs.common.model.perm.dyna.DynaScene;
import kd.hr.hrcs.common.model.perm.dyna.DynaScheme;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

@ExcludeFromJacocoGeneratedReport
public class DynaPermMsgConsumer {
    private static final Log LOGGER = LogFactory.getLog(DynaPermMsgConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HRMServiceResult handleMsg(DynamicObject msgDyna) {
        LOGGER.info("DynaPermMsgConsumer entry,msgNumber:{},msgName:{} ", msgDyna.get("number"), (Object)msgDyna.getString("name"));
        boolean successFlag = true;
        try {
            String isDynaPermDelayConsume = System.getProperty("isDynaPermConsumeDelay", "true");
            if (HRStringUtils.equals((String)isDynaPermDelayConsume, (String)"true")) {
                long delayMills = 10000L;
                LOGGER.info("DynaPermMsgConsumer handleMsg delayMills:{}", (Object)delayMills);
                Thread.sleep(delayMills);
            }
            String contentBase64 = msgDyna.getString("msgcontent");
            Map msgContent = (Map)SerializationUtils.deSerializeFromBase64((String)contentBase64);
            Long recordId = (Long)msgContent.get("recordId");
            DynaPermConsumeContext context = DynaPermMsgService.buildConsumeContextByMsg(msgDyna);
            context.setRecordId(recordId);
            DynamicObject assignDsDyn = DynaPermMsgService.queryAssignDynaObjectByPublisherId(context.getPublisherId());
            Long chgInfoApiId = assignDsDyn.getLong("chginfoapi.id");
            Map<String, Object> chgInfoMap = DynaPermCommonService.getChgInfoMapByRecordIdAndApiId(recordId, chgInfoApiId);
            if (MapUtils.isEmpty(chgInfoMap)) {
                LOGGER.info("DynaPermMsgConsumer result:false,getChgInfoByRecordId return null,dynaperm_consumer_exit.recordId:{} ", (Object)recordId);
                HRMServiceResult hRMServiceResult = HRMServiceResult.success();
                return hRMServiceResult;
            }
            ChgInfoResult chgInfoResult = DynaPermCommonService.chgInfoMap2Result(chgInfoMap);
            context.setChgInfoResult(chgInfoResult);
            DynaScene scene = DynaPermMsgService.getSceneByPublisherId(context.getPublisherId());
            if (Objects.isNull(scene)) {
                LOGGER.info("DynaPermMsgConsumer result:false,scene is empty,dynaperm_consumer_exit");
                HRMServiceResult failMsg = HRMServiceResult.success();
                return failMsg;
            }
            context.setScene(scene);
            DynaDs assignDs = DynaPermMsgService.dynaObject2DataSourceBean(assignDsDyn, chgInfoResult.getBillSource());
            if (assignDs == null) {
                LOGGER.info("DynaPermMsgConsumer result:false,assignDs is empty,dynaperm_consumer_exit");
                HRMServiceResult exc = HRMServiceResult.success();
                return exc;
            }
            context.setAssignDyna(assignDsDyn);
            context.setAssignDs(assignDs);
            DynamicObject cancelDsDyn = DynaPermMsgService.queryCancelDynaObject();
            DynaDs cancelDs = DynaPermMsgService.dynaObject2DataSourceBean(cancelDsDyn, chgInfoResult.getBillSource());
            context.setCancelDyna(cancelDsDyn);
            context.setCancelDs(cancelDs);
            DynamicObject billDyna = null;
            if (HRStringUtils.isNotEmpty((String)chgInfoResult.getBillSource())) {
                HRBaseServiceHelper billHelper = new HRBaseServiceHelper(chgInfoResult.getBillSource());
                billDyna = billHelper.queryOne((Object)chgInfoResult.getBillId());
                context.setBillDyna(billDyna);
            }
            List<DynaDsPerson> dsPersonList = DynaPermMsgService.calDsPersonList(assignDs, chgInfoResult, billDyna);
            context.setDsPersonList(dsPersonList);
            if (CollectionUtils.isEmpty(dsPersonList)) {
                LOGGER.info("DynaPermMsgConsumer result:false,dsPersonList is empty,dynaperm_consumer_exit");
                HRMServiceResult hRMServiceResult = HRMServiceResult.success();
                return hRMServiceResult;
            }
            List<DynaScheme> schemeList = DynaSchemeService.getDynaSchemeByScene(scene.getId(), assignDs, chgInfoResult.getBillSource());
            context.setSchemeList(schemeList);
            if (CollectionUtils.isEmpty(schemeList)) {
                LOGGER.info("DynaPermMsgConsumer result:false,schemeList is empty,dynaperm_consumer_exit");
                HRMServiceResult exc = HRMServiceResult.success();
                return exc;
            }
            LOGGER.info("DynaPermMsgConsumer getDynaSchemeByScene result schemeList:{}", (Object)DynaPermLogService.getSchemeSimpleInfo(schemeList));
            ApplyRecord applyRecord = new ApplyRecord();
            applyRecord.setSceneId(scene.getId());
            applyRecord.setMessageId(context.getMsgId());
            applyRecord.setMsgPublisher(context.getPublisherId());
            context.setApplyRecord(applyRecord);
            DynaSchemeMatchService.setAllRuleParamsToContext(context);
            DynaSchemeService.calSchemeNeedCancelRelat(context, schemeList, dsPersonList, cancelDs);
            DynaSchemeService.doCancelRelats(schemeList, applyRecord);
            DynaSchemeService.calSchemeNeedAssignPermFiles(context, schemeList, dsPersonList);
            DynaSchemeRoleService.fillSchemeRoleDataRange(schemeList);
            DynaRoleAssignService.assignSchemeRole(context, schemeList, applyRecord);
            DynaRoleAssignService.doSaveRelatsToDb(schemeList);
            DynaApplyRecordService.saveApplyRecord(applyRecord);
            LOGGER.info("DynaPermMsgConsumer result:true,personSize:{},dsPersonList:{}", (Object)dsPersonList.size(), dsPersonList);
            LOGGER.info("DynaPermMsgConsumer result:true,schemeList size:{}", (Object)schemeList.size());
            DynaPermLogService.writeSchemeListLog(LOGGER, schemeList);
            LOGGER.info("DynaPermMsgConsumer result:true,applyRecord:{}", (Object)applyRecord);
            DynaPermDealTraceService.writeDealTraceLog(context);
        }
        catch (Exception ex) {
            successFlag = false;
            LOGGER.error("DynaPermMsgConsumer result:false,happen_exception.", (Throwable)ex);
        }
        finally {
            try {
                String successMsg = ResManager.loadKDString((String)"\u52a8\u6001\u6743\u9650\u5904\u7406\u5b8c\u6210", (String)"DynaPermMsgConsumer_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                String failMsg = ResManager.loadKDString((String)"\u52a8\u6001\u6743\u9650\u5904\u7406\u5931\u8d25", (String)"DynaPermMsgConsumer_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                PermFileSyncServiceHelper.rspConsumerMsg(msgDyna, successFlag, successMsg, failMsg);
            }
            catch (Exception exc) {
                LOGGER.error("DynaPermMsgConsumer-rsp-consumer-fail.", (Throwable)exc);
            }
        }
        return null;
    }
}

