/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaPersonService;
import kd.hr.hrcs.bussiness.servicehelper.perm.dyna.PersonService;
import kd.hr.hrcs.common.model.perm.PersonInfo;
import kd.hr.hrcs.common.model.perm.dyna.ChgInfoResult;
import kd.hr.hrcs.common.model.perm.dyna.DynaDs;
import kd.hr.hrcs.common.model.perm.dyna.DynaDsParam;
import kd.hr.hrcs.common.model.perm.dyna.DynaDsPerson;
import kd.hr.hrcs.common.model.perm.dyna.DynaDsPersonItem;
import kd.hr.hrcs.common.model.perm.dyna.DynaPermConsumeContext;
import kd.hr.hrcs.common.model.perm.dyna.DynaScene;

@ExcludeFromJacocoGeneratedReport
public class DynaPermMsgService {
    private static final Log LOGGER = LogFactory.getLog(DynaPermMsgService.class);
    private static final HRBaseServiceHelper DYNA_DS_HELPER = new HRBaseServiceHelper("hrcs_dynadatasource");

    public static DynaPermConsumeContext buildConsumeContextByMsg(DynamicObject msgDyna) {
        DynaPermConsumeContext context = new DynaPermConsumeContext();
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        context.setEnableValidateTime(enableValidateTime);
        String subscriberNumber = msgDyna.getString("msgsubno");
        Long publisherId = DynaPermMsgService.getPublishId(subscriberNumber);
        Long msgId = DynaPermMsgService.getMsgCenterId(msgDyna.getString("number"));
        context.setMsgNumber(msgDyna.getString("number"));
        context.setMsgName(msgDyna.getString("name"));
        context.setSubscriberNumber(subscriberNumber);
        context.setPublisherId(publisherId);
        context.setMsgId(msgId);
        context.setTraceId(RequestContext.get().getTraceId());
        return context;
    }

    public static DynaScene getSceneByPublisherId(Long publisherId) {
        HRBaseServiceHelper sceneHelper = new HRBaseServiceHelper("hrcs_dynascene");
        DynamicObject sceneDyn = sceneHelper.queryOne(new QFilter[]{new QFilter("msgpublisher", "=", (Object)publisherId), new QFilter("enable", "=", (Object)"1")});
        if (Objects.isNull(sceneDyn)) {
            LOGGER.info("DynaPermMsgConsumer getSceneByPublisherId sceneDyn is empty , code return");
            return null;
        }
        DynaScene scene = new DynaScene(Long.valueOf(sceneDyn.getLong("id")), sceneDyn.getString("number"));
        return scene;
    }

    public static DynamicObject queryAssignDynaObjectByPublisherId(Long publisherId) {
        DynamicObject assignDsDyn = DYNA_DS_HELPER.loadDynamicObject(new QFilter[]{new QFilter("msgpublisher", "=", (Object)publisherId), new QFilter("enable", "=", (Object)"1")});
        return assignDsDyn;
    }

    public static DynamicObject queryCancelDynaObject() {
        DynamicObject cancelDsDyn = DYNA_DS_HELPER.loadDynamicObject(new QFilter[]{new QFilter("iscancelds", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")});
        return cancelDsDyn;
    }

    public static List<DynaDsPerson> calDsPersonList(DynaDs assignDs, ChgInfoResult chgInfoResult, DynamicObject billDyna) {
        ArrayList dsPersonList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynaDsPersonItem dsPersonItem : assignDs.getPersonItemList()) {
            DynaDsPerson dsPerson = new DynaDsPerson();
            dsPerson.setPersonItemId(dsPersonItem.getPersonItemId());
            if (HRStringUtils.equals((String)dsPersonItem.getPersonClass(), (String)"2")) {
                dsPerson.setPersonType("4");
                dsPerson.setUserOrDepId(chgInfoResult.getDepempId());
            } else {
                Long personId = billDyna.getLong(dsPersonItem.getPropKey() + ".id");
                dsPerson.setPersonType(dsPersonItem.getPersonType());
                dsPerson.setUserOrDepId(personId);
            }
            PersonInfo personInfo = PersonService.getPersonInfo(dsPerson.getUserOrDepId(), dsPerson.getPersonType());
            if (Objects.isNull(personInfo.getUserId()) || Objects.equals(personInfo.getUserId(), 0L)) {
                LOGGER.info("DynaPermMsgConsumer calDsPersonList userId is null,do not deal. personInfo={}", (Object)personInfo);
                continue;
            }
            dsPerson.setPersonInfo(personInfo);
            dsPersonList.add(dsPerson);
        }
        return dsPersonList;
    }

    public static DynaDs dynaObject2DataSourceBean(DynamicObject dsDyn, String billEntityNumber) {
        if (Objects.isNull(dsDyn)) {
            return null;
        }
        DynaDs dsBean = new DynaDs();
        boolean isCancelDs = dsDyn.getBoolean("iscancelds");
        dsBean.setCancelDs(isCancelDs);
        dsBean.setId(Long.valueOf(dsDyn.getLong("id")));
        dsBean.setNumber(dsDyn.getString("number"));
        dsBean.setChgInfoApiId(Long.valueOf(dsDyn.getLong("chginfoapi.id")));
        DynamicObjectCollection paramEntry = dsDyn.getDynamicObjectCollection("paramentry");
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject paramEntryDyna : paramEntry) {
            DynaDsParam dynaDsParam = new DynaDsParam();
            dynaDsParam.setRuleParamId(Long.valueOf(paramEntryDyna.getLong("ruleparam.id")));
            String fetchMode = paramEntryDyna.getString("fetchmode");
            String fetchSource = paramEntryDyna.getString("fetchsource");
            dynaDsParam.setFetchMode(fetchMode);
            dynaDsParam.setFetchSource(fetchSource);
            dynaDsParam.setPublisherDsId(Long.valueOf(paramEntryDyna.getLong("publisherds.id")));
            dynaDsParam.setApiSourceId(Long.valueOf(paramEntryDyna.getLong("publisherds.apisource.id")));
            dynaDsParam.setFormulaId(Long.valueOf(paramEntryDyna.getLong("dynaformula.id")));
            if (HRStringUtils.equals((String)fetchMode, (String)"1")) {
                if (HRStringUtils.equals((String)fetchSource, (String)"2")) {
                    dynaDsParam.setPropKey(paramEntryDyna.getString("param_propkey"));
                } else if (HRStringUtils.equals((String)fetchSource, (String)"1")) {
                    DynamicObjectCollection entitySubEntry = paramEntryDyna.getDynamicObjectCollection("paramentitysubentry");
                    for (DynamicObject entitySubEntryDyna : entitySubEntry) {
                        String entityNumber = entitySubEntryDyna.getString("paramentity_publisherds.entitytype.number");
                        if (!HRStringUtils.equals((String)entityNumber, (String)billEntityNumber)) continue;
                        dynaDsParam.setPropKey(entitySubEntryDyna.getString("paramentity_propkey"));
                        break;
                    }
                }
            }
            paramList.add(dynaDsParam);
        }
        dsBean.setParamList((List)paramList);
        if (!isCancelDs) {
            DynamicObjectCollection assignsceneEntry = dsDyn.getDynamicObjectCollection("personentry");
            ArrayList personItemList = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject assignsceneEntryDyna : assignsceneEntry) {
                DynaDsPersonItem dynaDsPersonItem = new DynaDsPersonItem();
                String personClass = assignsceneEntryDyna.getString("personclass");
                dynaDsPersonItem.setPersonClass(personClass);
                String entityNumber = assignsceneEntryDyna.getString("person_entitytype.number");
                dynaDsPersonItem.setEntityNumber(entityNumber);
                String propKey = assignsceneEntryDyna.getString("person_propkey");
                dynaDsPersonItem.setPropKey(propKey);
                dynaDsPersonItem.setPersonItemId(Long.valueOf(assignsceneEntryDyna.getLong("personnameitem.id")));
                if (HRStringUtils.equals((String)personClass, (String)"1")) {
                    String personType = DynaPersonService.getFiledPersonType(entityNumber, propKey);
                    dynaDsPersonItem.setPersonType(personType);
                } else if (HRStringUtils.equals((String)personClass, (String)"2")) {
                    dynaDsPersonItem.setPersonType("4");
                }
                personItemList.add(dynaDsPersonItem);
            }
            dsBean.setPersonItemList((List)personItemList);
        }
        return dsBean;
    }

    private static Long getPublishId(String msgSubNo) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        DynamicObject dy = helper.queryOriginalOne("msgpublisher.id", new QFilter("number", "=", (Object)msgSubNo));
        return dy.getLong("msgpublisher.id");
    }

    private static Long getMsgCenterId(String number) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgcenter");
        DynamicObject dy = helper.queryOriginalOne("id", new QFilter[]{new QFilter("number", "=", (Object)number)});
        return dy.getLong("id");
    }
}

