/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.perm.AssignSource;
import kd.hr.hbp.common.model.perm.DimGroupParam;
import kd.hr.hbp.common.model.perm.DimValueParam;
import kd.hr.hbp.common.model.perm.EntityBdDataRuleParam;
import kd.hr.hbp.common.model.perm.EntityDataRuleParam;
import kd.hr.hbp.common.model.perm.EntityFieldPermParam;
import kd.hr.hbp.common.model.perm.PermDataRangeParam;
import kd.hr.hbp.common.model.perm.UserBucaPermDataParam;
import kd.hr.hbp.common.model.perm.UserRoleAssignParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.common.RoleAssignService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaApplyRecordService;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RoleAssignLogBussinessHelper;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.common.model.perm.SceneRoleInfo;
import kd.hr.hrcs.common.model.perm.dyna.ApplyRecord;
import kd.hr.hrcs.common.model.perm.dyna.BdRule;
import kd.hr.hrcs.common.model.perm.dyna.DynDim;
import kd.hr.hrcs.common.model.perm.dyna.DynaPermConsumeContext;
import kd.hr.hrcs.common.model.perm.dyna.DynaScheme;
import kd.hr.hrcs.common.model.perm.dyna.Field;
import kd.hr.hrcs.common.model.perm.dyna.PermFile;
import kd.hr.hrcs.common.model.perm.dyna.Rule;
import kd.hr.hrcs.common.model.perm.dyna.SchemeDim;
import kd.hr.hrcs.common.model.perm.dyna.SchemeField;
import kd.hr.hrcs.common.model.perm.dyna.SchemeOrg;
import kd.hr.hrcs.common.model.perm.dyna.SchemeRule;
import org.apache.commons.collections4.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class DynaRoleAssignService {
    private static final Log LOGGER = LogFactory.getLog(DynaRoleAssignService.class);
    private static final HRBaseServiceHelper USER_ROLE_RELAT_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");

    public static void cancelUserRole(Set<Long> relatIdSet, HashMap<Long, DynaScheme> relateIdSchemeMap) {
        LOGGER.info("DynaPermMsgConsumer cancelUserRole ,relatIdSet:{}\uff0crelateIdSchemeMap:{}", relatIdSet, relateIdSchemeMap);
        if (CollectionUtils.isEmpty(relatIdSet)) {
            LOGGER.info("DynaPermMsgConsumer cancelUserRole relatIdSet is empty,code return ");
            return;
        }
        HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper("hrcs_userrole");
        HRBaseServiceHelper userRoleRelHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        HRBaseServiceHelper sysUserRoleHelper = new HRBaseServiceHelper("perm_userrole");
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_userroledimgrp");
        HRBaseServiceHelper fieldHelper = new HRBaseServiceHelper("hrcs_userfield");
        DynamicObject[] userRoleRelDys = userRoleHelper.queryOriginalArray("id,userrolepf.id,userrolerealt", new QFilter[]{new QFilter("userrolerealt", "in", relatIdSet)});
        HashSet sysRelIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dy : userRoleRelDys) {
            sysRelIdSet.add(dy.getString("userrolepf.id"));
        }
        ArrayList<UserRoleAssignParam> permLogParams = RoleAssignLogBussinessHelper.getUserRoleAssignParamsBySchem(relatIdSet, relateIdSchemeMap);
        userRoleRelHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", relatIdSet)});
        userRoleHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerealt", "in", relatIdSet)});
        ruleHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerelate", "in", relatIdSet)});
        dimHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerelat", "in", relatIdSet)});
        fieldHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerealt", "in", relatIdSet)});
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                sysUserRoleHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", (Object)sysRelIdSet)});
            }
            catch (Exception ex) {
                LOGGER.error("DynaPermMsgConsumer cancelUserRole sysUserRole rollback");
                txHandle.markRollback();
            }
        }
        RoleAssignLogBussinessHelper.savePermLogs(permLogParams, "dynaPerm");
    }

    public static void assignSchemeRole(DynaPermConsumeContext context, List<DynaScheme> schemeList, ApplyRecord applyRecord) {
        if (schemeList.size() == 0) {
            LOGGER.info("DynaPermMsgConsumer assignSchemeRole,matchschemeList size:0, code return");
            return;
        }
        Date startDate = PermRoleUtil.formatStartDate(new Date());
        for (DynaScheme schemeInfo : schemeList) {
            if (HRStringUtils.equals((String)schemeInfo.getAuthAction(), (String)"2")) continue;
            if (CollectionUtils.isEmpty((Collection)schemeInfo.getRoleList())) {
                LOGGER.info("DynaPermMsgConsumer assignSchemeRole,get roles is null ,schemeInfo:{}", (Object)schemeInfo.getName());
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)schemeInfo.getNeedAssignPermFiles())) {
                LOGGER.info("DynaPermMsgConsumer assignSchemeRole,getAssignPermFiles is null ,schemeInfo:{}", (Object)schemeInfo.getName());
                continue;
            }
            ArrayList needUpdateRelatDynas = Lists.newArrayListWithExpectedSize((int)16);
            ArrayList needAddRelatParams = Lists.newArrayListWithExpectedSize((int)16);
            ArrayList sameRangeRoles = Lists.newArrayListWithExpectedSize((int)16);
            ArrayList customRangeRoles = Lists.newArrayListWithExpectedSize((int)16);
            for (SceneRoleInfo roleInfo : schemeInfo.getRoleList()) {
                if (HRStringUtils.equals((String)roleInfo.getCustomEnable(), (String)"0")) {
                    sameRangeRoles.add(roleInfo);
                    continue;
                }
                customRangeRoles.add(roleInfo);
            }
            Date endDate = PermRoleUtil.formatEndDate(PermRoleUtil.dateIncreaseByDay(startDate, schemeInfo.getAssignDays()));
            List permFiles = schemeInfo.getNeedAssignPermFiles();
            Set<Long> permFileIds = permFiles.stream().map(PermFile::getId).collect(Collectors.toSet());
            Map<String, List<DynamicObject>> existSameRangeRelats = DynaRoleAssignService.getSameRangeRelat(permFileIds, schemeInfo.getRoleList());
            for (SceneRoleInfo roleInfo : sameRangeRoles) {
                List<DynamicObject> relatDynas = existSameRangeRelats.getOrDefault(roleInfo.getRoleId(), Lists.newArrayList());
                Set existsFileIds = relatDynas.stream().map(dyna -> dyna.getLong("permfile.id")).collect(Collectors.toSet());
                for (PermFile permFile : permFiles) {
                    if (existsFileIds.contains(permFile.getId())) {
                        List<DynamicObject> toUpdateRelatDynas = relatDynas.stream().filter(dyna -> Objects.equals(dyna.getLong("permfile.id"), permFile.getId())).collect(Collectors.toList());
                        List<DynamicObject> updatedRelatDynas = DynaRoleAssignService.resetUpdateValidDate(context, toUpdateRelatDynas, startDate, endDate, schemeInfo.getId());
                        DynaApplyRecordService.addUpdatedRelatRoleToApplyRecord(applyRecord, updatedRelatDynas, schemeInfo.getId(), roleInfo, permFile);
                        needUpdateRelatDynas.addAll(updatedRelatDynas);
                        continue;
                    }
                    UserRoleAssignParam assignParam = new UserRoleAssignParam(permFile.getId(), roleInfo.getRoleId(), startDate, endDate, Long.valueOf(0L));
                    AssignSource assignSource = assignParam.getAssignSource();
                    assignSource.setSourceType("4");
                    assignSource.setSchemeId(schemeInfo.getId());
                    DynaApplyRecordService.addAddedRelatRoleToApplyRecord(applyRecord, assignParam, permFile);
                    needAddRelatParams.add(assignParam);
                }
            }
            HashMap relatDynaMap = Maps.newHashMapWithExpectedSize((int)16);
            Map<Long, List<SceneRoleInfo>> existCustomRangeRoles = DynaRoleAssignService.getCustomRangeRelat(permFileIds, schemeInfo.getRoleList(), relatDynaMap);
            for (SceneRoleInfo roleInfo : customRangeRoles) {
                for (PermFile permFile : permFiles) {
                    UserBucaPermDataParam userBucaPermDataParam;
                    Set<Long> userRoleRelatIdSet = DynaRoleAssignService.compareRoleCusDataRange(existCustomRangeRoles, permFile.getId(), roleInfo);
                    if (userRoleRelatIdSet.size() > 0) {
                        List<DynamicObject> toUpdateRelatDynas = DynaRoleAssignService.getRelatDynasFromMap(userRoleRelatIdSet, relatDynaMap);
                        List<DynamicObject> updatedRelatDynas = DynaRoleAssignService.resetUpdateValidDate(context, toUpdateRelatDynas, startDate, endDate, schemeInfo.getId());
                        DynaApplyRecordService.addUpdatedRelatRoleToApplyRecord(applyRecord, updatedRelatDynas, schemeInfo.getId(), roleInfo, permFile);
                        needUpdateRelatDynas.addAll(updatedRelatDynas);
                        continue;
                    }
                    UserRoleAssignParam assignParam = new UserRoleAssignParam(permFile.getId(), roleInfo.getRoleId(), startDate, endDate, Long.valueOf(0L));
                    AssignSource assignSource = assignParam.getAssignSource();
                    assignSource.setSourceType("4");
                    assignSource.setSchemeId(schemeInfo.getId());
                    assignParam.setCustomData(true);
                    PermDataRangeParam rangeParam = new PermDataRangeParam();
                    assignParam.setDataRangeParam(rangeParam);
                    Map bucaPermData = rangeParam.getBucaPermData();
                    for (SchemeOrg schemeOrg : roleInfo.getRoleBuLst()) {
                        userBucaPermDataParam = bucaPermData.getOrDefault(schemeOrg.getBuCaFunc(), new UserBucaPermDataParam(schemeOrg.getBuCaFunc()));
                        bucaPermData.put(schemeOrg.getBuCaFunc(), userBucaPermDataParam);
                        Map orgInfoMap = userBucaPermDataParam.getOrgInfos();
                        orgInfoMap.put(schemeOrg.getOrgId(), schemeOrg.isIncludeSubOrg());
                    }
                    for (SchemeDim schemeDimGroup : roleInfo.getRoleDimLst()) {
                        userBucaPermDataParam = bucaPermData.getOrDefault(schemeDimGroup.getBuCaFunc(), new UserBucaPermDataParam(schemeDimGroup.getBuCaFunc()));
                        bucaPermData.put(schemeDimGroup.getBuCaFunc(), userBucaPermDataParam);
                        List userDimGroupData = userBucaPermDataParam.getUserDimGroupData();
                        DimGroupParam groupParam = new DimGroupParam();
                        groupParam.setDimValuesMap(DynaRoleAssignService.dimGroupConvert(schemeDimGroup));
                        userDimGroupData.add(groupParam);
                    }
                    for (SchemeRule schemeRule : roleInfo.getRoleRuleLst()) {
                        List dataRuleParams = rangeParam.getDataRuleParams();
                        for (Rule rule : schemeRule.getRuleList()) {
                            EntityDataRuleParam dataRuleParam = new EntityDataRuleParam(schemeRule.getAppId(), schemeRule.getEntityNumber(), rule.getPermItemId(), rule.getDataRule());
                            dataRuleParams.add(dataRuleParam);
                        }
                        List bdDataRuleParams = rangeParam.getBdDataRuleParams();
                        for (BdRule bdRule : schemeRule.getBdRuleList()) {
                            EntityBdDataRuleParam bdDataRuleParam = new EntityBdDataRuleParam(schemeRule.getAppId(), schemeRule.getEntityNumber(), bdRule.getPropKey(), bdRule.getPropNum(), bdRule.getDataRule());
                            bdDataRuleParams.add(bdDataRuleParam);
                        }
                    }
                    for (SchemeField schemeField : roleInfo.getRoleFieldLst()) {
                        List fieldPermParams = rangeParam.getFieldPermParams();
                        List fieldList = schemeField.getFieldList();
                        for (Field field : fieldList) {
                            EntityFieldPermParam entityFieldPermParam = new EntityFieldPermParam(schemeField.getApp(), schemeField.getEntityType(), field.getFieldProp(), !field.isBanRead(), !field.isBanWrite());
                            fieldPermParams.add(entityFieldPermParam);
                        }
                    }
                    DynaApplyRecordService.addAddedRelatRoleToApplyRecord(applyRecord, assignParam, permFile);
                    needAddRelatParams.add(assignParam);
                }
            }
            if (needUpdateRelatDynas.size() > 0) {
                schemeInfo.setNeedUpdateRelatDynas((List)needUpdateRelatDynas);
            }
            if (needAddRelatParams.size() <= 0) continue;
            schemeInfo.setNeedAddRelatParams((List)needAddRelatParams);
        }
    }

    public static void doSaveRelatsToDb(List<DynaScheme> schemeList) {
        ArrayList allNeedUpdateRelatDynas = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList allNeedAddRelatParams = Lists.newArrayListWithExpectedSize((int)16);
        for (DynaScheme scheme : schemeList) {
            List needAddRelatParams;
            List needUpdateRelatDynas = scheme.getNeedUpdateRelatDynas();
            if (CollectionUtils.isNotEmpty((Collection)needUpdateRelatDynas)) {
                allNeedUpdateRelatDynas.addAll(needUpdateRelatDynas);
            }
            if (!CollectionUtils.isNotEmpty((Collection)(needAddRelatParams = scheme.getNeedAddRelatParams()))) continue;
            allNeedAddRelatParams.addAll(needAddRelatParams);
        }
        if (CollectionUtils.isNotEmpty((Collection)allNeedUpdateRelatDynas)) {
            USER_ROLE_RELAT_HELPER.update(allNeedUpdateRelatDynas.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)allNeedAddRelatParams)) {
            for (UserRoleAssignParam allNeedAddRelatParam : allNeedAddRelatParams) {
                AssignSource assignSource = allNeedAddRelatParam.getAssignSource();
                assignSource.setObType("userRoleAdd");
                assignSource.setPageSource("dynaPerm");
            }
            RoleAssignService.roleAssignUserBatch(allNeedAddRelatParams);
        }
        LOGGER.info("DynaPermMsgConsumer doSaveRelatsToDb,update size:{},add size:{}", (Object)allNeedUpdateRelatDynas.size(), (Object)allNeedAddRelatParams.size());
    }

    private static Map<Long, List<DimValueParam>> dimGroupConvert(SchemeDim schemeDimGroup) {
        HashMap dimValuesMap = Maps.newHashMapWithExpectedSize((int)16);
        List dynDims = schemeDimGroup.getDimList();
        if (CollectionUtils.isEmpty((Collection)dynDims)) {
            return dimValuesMap;
        }
        for (DynDim dynDim : dynDims) {
            List dimValueParams = dimValuesMap.getOrDefault(dynDim.getDimId(), Lists.newArrayListWithExpectedSize((int)16));
            dimValuesMap.put(dynDim.getDimId(), dimValueParams);
            DimValueParam dimValueParam = new DimValueParam(dynDim.isAll(), dynDim.getDimVal(), dynDim.isContainsSub(), dynDim.isAdminContainsSub(), dynDim.getStructProjectId());
            dimValueParam.setOtClassify(dynDim.getOtClassify());
            dimValueParam.setValType(dynDim.getValType());
            dimValueParam.setDynaCondId(dynDim.getDynaCondId());
            dimValueParams.add(dimValueParam);
        }
        return dimValuesMap;
    }

    private static List<DynamicObject> getRelatDynasFromMap(Set<Long> userRoleRltIdSet, Map<Long, DynamicObject> userRoleRltMap) {
        ArrayList dys = Lists.newArrayListWithExpectedSize((int)16);
        for (Long id : userRoleRltIdSet) {
            dys.add(userRoleRltMap.get(id));
        }
        return dys;
    }

    private static Set<Long> compareRoleCusDataRange(Map<Long, List<SceneRoleInfo>> cusAssignedRoles, Long fileId, SceneRoleInfo role) {
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
        if (cusAssignedRoles == null || cusAssignedRoles.size() == 0) {
            return Sets.newHashSet();
        }
        boolean hasPf = cusAssignedRoles.containsKey(fileId);
        if (!hasPf) {
            return Sets.newHashSet();
        }
        for (Map.Entry<Long, List<SceneRoleInfo>> entry : cusAssignedRoles.entrySet()) {
            for (SceneRoleInfo sc : entry.getValue()) {
                Long result = DynaRoleAssignService.matchOneRoleDataRg(sc, role);
                if (result <= 0L) continue;
                idSet.add(result);
            }
        }
        return idSet;
    }

    private static Long matchOneRoleDataRg(SceneRoleInfo dbRole, SceneRoleInfo dyRole) {
        List roleBuLst = dyRole.getRoleBuLst();
        List roleDimLst = dyRole.getRoleDimLst();
        List roleRuleLst = dyRole.getRoleRuleLst();
        List roleFieldLst = dyRole.getRoleFieldLst();
        List dbRoleBuLst = dbRole.getRoleBuLst();
        List dbRoleDimLst = dbRole.getRoleDimLst();
        List dbRoleRuleLst = dbRole.getRoleRuleLst();
        List dbRoleFieldLst = dbRole.getRoleFieldLst();
        boolean roleBuResult = DynaRoleAssignService.compareRoleBu(roleBuLst, dbRoleBuLst);
        boolean roleDimResult = DynaRoleAssignService.compareRoleDim(roleDimLst, dbRoleDimLst);
        boolean roleRuleResult = DynaRoleAssignService.compareRoleRule(roleRuleLst, dbRoleRuleLst);
        boolean roleFieldResult = DynaRoleAssignService.compareRoleField(roleFieldLst, dbRoleFieldLst);
        if (roleBuResult && roleDimResult && roleRuleResult && roleFieldResult) {
            return dbRole.getUserrolerealtId();
        }
        return 0L;
    }

    private static boolean compareRoleField(List<SchemeField> roleFieldLst, List<SchemeField> targetRoleFieldLst) {
        if (roleFieldLst.size() != targetRoleFieldLst.size()) {
            return false;
        }
        for (SchemeField schemeField : roleFieldLst) {
            if (!targetRoleFieldLst.stream().noneMatch(arg_0 -> ((SchemeField)schemeField).hasEquals(arg_0))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareRoleRule(List<SchemeRule> roleRuleLst, List<SchemeRule> targetRoleRuleLst) {
        if (roleRuleLst.size() != targetRoleRuleLst.size()) {
            return false;
        }
        for (SchemeRule schemeRule : roleRuleLst) {
            if (!targetRoleRuleLst.stream().noneMatch(arg_0 -> ((SchemeRule)schemeRule).hasEquals(arg_0))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareRoleDim(List<SchemeDim> roleDimLst, List<SchemeDim> targetRoleDimLst) {
        if (roleDimLst.size() != targetRoleDimLst.size()) {
            return false;
        }
        for (SchemeDim schemeDim : roleDimLst) {
            if (!targetRoleDimLst.stream().noneMatch(arg_0 -> ((SchemeDim)schemeDim).hasEquals(arg_0))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareRoleBu(List<SchemeOrg> roleBuLst, List<SchemeOrg> targetRoleBuLst) {
        if (roleBuLst.size() != targetRoleBuLst.size()) {
            return false;
        }
        for (SchemeOrg schemeOrg : roleBuLst) {
            if (!targetRoleBuLst.stream().noneMatch(arg_0 -> ((SchemeOrg)schemeOrg).hasEquals(arg_0))) continue;
            return false;
        }
        return true;
    }

    private static List<DynamicObject> resetUpdateValidDate(DynaPermConsumeContext context, List<DynamicObject> dys, Date startDate, Date endDate, Long schemeId) {
        Date now = new Date();
        ArrayList needUpdateRelatDynas = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dy : dys) {
            if (context.isEnableValidateTime()) {
                dy.set("validstart", (Object)startDate);
                dy.set("validend", (Object)endDate);
            } else {
                dy.set("validstart", null);
                dy.set("validend", null);
            }
            dy.set("sourcetype", (Object)"4");
            dy.set("scheme", (Object)schemeId);
            dy.set("createtime", (Object)now);
            needUpdateRelatDynas.add(dy);
        }
        return needUpdateRelatDynas;
    }

    private static Map<String, List<DynamicObject>> getSameRangeRelat(Set<Long> userPFIdSet, List<SceneRoleInfo> roleIdList) {
        HashMap PFMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper relHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        DynamicObject[] dys = relHelper.query("id,role.id,user.id,permfile.id,validstart,validend,scheme,createtime,customenable,sourcetype", new QFilter[]{new QFilter("role", "in", roleIdList.stream().map(SceneRoleInfo::getRoleId).collect(Collectors.toSet())), new QFilter("permfile", "in", userPFIdSet), new QFilter("sourcetype", "=", (Object)"4"), new QFilter("customenable", "=", (Object)"0")});
        if (dys == null || dys.length == 0) {
            return Maps.newHashMap();
        }
        for (DynamicObject dy : dys) {
            PFMap.computeIfAbsent(dy.getString("role.id"), key -> new ArrayList(16)).add(dy);
        }
        return PFMap;
    }

    private static Map<Long, List<SceneRoleInfo>> getCustomRangeRelat(Set<Long> userPFIdSet, List<SceneRoleInfo> roleList, Map<Long, DynamicObject> userRoleRelatMap) {
        HRBaseServiceHelper relHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        Object[] dys = relHelper.query("id,role.id,user.id,validstart,validend,scheme,createtime,customenable,permfile,sourcetype", new QFilter[]{new QFilter("role", "in", roleList.stream().map(SceneRoleInfo::getRoleId).collect(Collectors.toSet())), new QFilter("permfile", "in", userPFIdSet), new QFilter("scheme", "!=", (Object)0L), new QFilter("customenable", "=", (Object)"1")});
        if (dys == null || dys.length == 0) {
            return Maps.newHashMap();
        }
        for (Object dy : dys) {
            userRoleRelatMap.put(dy.getLong("id"), (DynamicObject)dy);
        }
        return DynaRoleAssignService.getRoleDataRange(Lists.newArrayList((Object[])dys));
    }

    public static Map<Long, List<SceneRoleInfo>> getRoleDataRange(List<DynamicObject> cusRoles) {
        HashSet userrolerealtSet = Sets.newHashSetWithExpectedSize((int)cusRoles.size());
        for (DynamicObject dy : cusRoles) {
            userrolerealtSet.add(dy.getLong("id"));
        }
        HRBaseServiceHelper buHelper = new HRBaseServiceHelper("hrcs_userrole");
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_userroledimgrp");
        HRBaseServiceHelper fieldHelper = new HRBaseServiceHelper("hrcs_userfield");
        DynamicObject[] buDys = buHelper.query("userrolerealt,bucafunc,org,includesuborg,role", new QFilter[]{new QFilter("userrolerealt", "in", (Object)userrolerealtSet)});
        DynamicObject[] ruleDys = ruleHelper.query("userrolerelate,app,entitytype,bucafunc,dataruleentry.permitem,dataruleentry.datarule,bddataruleentry.propkey,bddataruleentry.propentnum,bddataruleentry.bddatarule", new QFilter[]{new QFilter("userrolerelate", "in", (Object)userrolerealtSet)});
        DynamicObject[] dimDys = dimHelper.query("userrolerelat,bucafunc,entry.dimension,entry.isall,entry.structproject,entry.admincontainssub,entry.containssub,entry.dimval,entry.valtype,entry.dynacond", new QFilter[]{new QFilter("userrolerelat", "in", (Object)userrolerealtSet)});
        DynamicObject[] fieldDys = fieldHelper.query("userrolerealt,app,entitytype,entryentity.fieldname,entryentity.isbanread,entryentity.isbanwrite", new QFilter[]{new QFilter("userrolerealt", "in", (Object)userrolerealtSet)});
        List<SchemeOrg> roleBuLst = null;
        if (buDys != null && buDys.length > 0) {
            roleBuLst = DynaRoleAssignService.getDbRoleBu(buDys);
        }
        List<SchemeRule> roleRuleLst = null;
        if (ruleDys != null && ruleDys.length > 0) {
            roleRuleLst = DynaRoleAssignService.getDbRoleDataRule(ruleDys);
        }
        List<SchemeDim> roleDimLst = null;
        if (dimDys != null && dimDys.length > 0) {
            roleDimLst = DynaRoleAssignService.getDbRoleDim(dimDys);
        }
        List<SchemeField> roleFieldLst = null;
        if (fieldDys != null && fieldDys.length > 0) {
            roleFieldLst = DynaRoleAssignService.getDbRoleField(fieldDys);
        }
        HashMap userrolerealtMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject urt : cusRoles) {
            DynaRoleAssignService.setDbRoleBu(urt, roleBuLst, userrolerealtMap);
            DynaRoleAssignService.setDbRoleDr(urt, roleRuleLst, userrolerealtMap);
            DynaRoleAssignService.setDbRoleDim(urt, roleDimLst, userrolerealtMap);
            DynaRoleAssignService.setDbRoleField(urt, roleFieldLst, userrolerealtMap);
        }
        HashMap pfMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : userrolerealtMap.entrySet()) {
            Optional<DynamicObject> pfRet = cusRoles.stream().filter(it -> ((Long)entry.getKey()).equals(it.getLong("id"))).findFirst();
            if (!pfRet.isPresent()) continue;
            Long pf = pfRet.get().getLong("permfile.id");
            pfMap.computeIfAbsent(pf, key -> new ArrayList(16)).add(entry.getValue());
        }
        return pfMap;
    }

    private static List<SchemeOrg> getDbRoleBu(DynamicObject[] buDys) {
        ArrayList roleBuLst = Lists.newArrayListWithExpectedSize((int)buDys.length);
        for (DynamicObject dy : buDys) {
            SchemeOrg schemeOrg = new SchemeOrg();
            Long buCaFunc = dy.getLong("bucafunc");
            Long org = dy.getLong("org.id");
            boolean includeSubOrg = dy.getBoolean("includesuborg");
            Long userrolerealtId = dy.getLong("userrolerealt.id");
            schemeOrg.setBuCaFunc(buCaFunc);
            schemeOrg.setIncludeSubOrg(includeSubOrg);
            schemeOrg.setOrgId(org);
            schemeOrg.setUserrolerealtId(userrolerealtId);
            roleBuLst.add(schemeOrg);
        }
        return roleBuLst;
    }

    private static List<SchemeRule> getDbRoleDataRule(DynamicObject[] ruleDys) {
        ArrayList roleRuleLst = Lists.newArrayListWithExpectedSize((int)ruleDys.length);
        for (DynamicObject dy : ruleDys) {
            SchemeRule schemeRule = new SchemeRule();
            String app = dy.getString("app.id");
            String entityType = dy.getString("entitytype.id");
            Long userrolerealtId = dy.getLong("userrolerelate.id");
            schemeRule.setEntityNumber(entityType);
            schemeRule.setAppId(app);
            schemeRule.setUserrolerealtId(userrolerealtId);
            DynamicObjectCollection bdRuleEntry = dy.getDynamicObjectCollection("bddataruleentry");
            DynamicObjectCollection ruleEntry = dy.getDynamicObjectCollection("dataruleentry");
            if (!bdRuleEntry.isEmpty()) {
                ArrayList bdRuleList = Lists.newArrayListWithExpectedSize((int)ruleEntry.size());
                for (DynamicObject bdDy : bdRuleEntry) {
                    BdRule bdRule = new BdRule();
                    String propKey = bdDy.getString("propkey");
                    String propentNum = bdDy.getString("propentnum");
                    Long bdDataRule = bdDy.getLong("bddatarule.id");
                    bdRule.setDataRule(bdDataRule);
                    bdRule.setPropKey(propKey);
                    bdRule.setPropNum(propentNum);
                    bdRuleList.add(bdRule);
                }
                schemeRule.setBdRuleList((List)bdRuleList);
            }
            if (!ruleEntry.isEmpty()) {
                ArrayList ruleList = Lists.newArrayListWithExpectedSize((int)ruleEntry.size());
                for (DynamicObject ruleDy : ruleEntry) {
                    Rule rule = new Rule();
                    String permItem = ruleDy.getString("permitem.id");
                    Long dataRule = ruleDy.getLong("datarule.id");
                    rule.setDataRule(dataRule);
                    rule.setPermItemId(permItem);
                    ruleList.add(rule);
                }
                schemeRule.setRuleList((List)ruleList);
            }
            roleRuleLst.add(schemeRule);
        }
        return roleRuleLst;
    }

    private static List<SchemeDim> getDbRoleDim(DynamicObject[] dimDys) {
        ArrayList roleDimLst = Lists.newArrayListWithExpectedSize((int)dimDys.length);
        for (DynamicObject dy : dimDys) {
            SchemeDim schemeDim = new SchemeDim();
            Long buCaFunc = dy.getLong("bucafunc.id");
            Long userrolerealtId = dy.getLong("userrolerelat.id");
            schemeDim.setBuCaFunc(buCaFunc);
            schemeDim.setUserrolerealtId(userrolerealtId);
            DynamicObjectCollection dimEntry = dy.getDynamicObjectCollection("entry");
            if (!dimEntry.isEmpty()) {
                ArrayList dimList = Lists.newArrayListWithExpectedSize((int)dimEntry.size());
                for (DynamicObject dimDy : dimEntry) {
                    DynDim dim = new DynDim();
                    Long dimension = dimDy.getLong("dimension.id");
                    boolean isAll = dimDy.getBoolean("isall");
                    Long structProject = dimDy.getLong("structproject.id");
                    boolean adminContainsSub = dimDy.getBoolean("admincontainssub");
                    boolean containsSub = dimDy.getBoolean("containssub");
                    String dimVal = dimDy.getString("dimval");
                    String valType = dimDy.getString("valtype");
                    Long dynaCond = dimDy.getLong("dynacond.id");
                    dim.setDimId(dimension);
                    dim.setAll(isAll);
                    dim.setAdminContainsSub(adminContainsSub);
                    dim.setStructProjectId(structProject);
                    dim.setContainsSub(containsSub);
                    dim.setDimVal(dimVal);
                    dim.setValType(valType);
                    dim.setDynaCondId(dynaCond);
                    dimList.add(dim);
                }
                schemeDim.setDimList((List)dimList);
            }
            roleDimLst.add(schemeDim);
        }
        return roleDimLst;
    }

    private static List<SchemeField> getDbRoleField(DynamicObject[] fieldDys) {
        ArrayList roleFieldLst = Lists.newArrayListWithExpectedSize((int)fieldDys.length);
        for (DynamicObject dy : fieldDys) {
            SchemeField schemeField = new SchemeField();
            String app = dy.getString("app.id");
            String entityType = dy.getString("entitytype.id");
            Long userrolerealtId = dy.getLong("userrolerealt.id");
            schemeField.setUserrolerealtId(userrolerealtId);
            schemeField.setApp(app);
            schemeField.setEntityType(entityType);
            DynamicObjectCollection fieldEntry = dy.getDynamicObjectCollection("entryentity");
            if (!fieldEntry.isEmpty()) {
                ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)fieldEntry.size());
                for (DynamicObject fieldDy : fieldEntry) {
                    Field field = new Field();
                    String fieldName = fieldDy.getString("fieldname");
                    boolean isBanRead = fieldDy.getBoolean("isbanread");
                    boolean isBanWrite = fieldDy.getBoolean("isbanwrite");
                    field.setBanRead(isBanRead);
                    field.setBanWrite(isBanWrite);
                    field.setFieldProp(fieldName);
                    fieldList.add(field);
                }
                schemeField.setFieldList((List)fieldList);
            }
            roleFieldLst.add(schemeField);
        }
        return roleFieldLst;
    }

    private static void setDbRoleBu(DynamicObject urt, List<SchemeOrg> roleBuLst, Map<Long, SceneRoleInfo> userrolerealtMap) {
        if (CollectionUtils.isEmpty(roleBuLst)) {
            return;
        }
        Long userRoleRltId = urt.getLong("id");
        String roleId = urt.getString("role.id");
        String roleNumber = urt.getString("role.number");
        SceneRoleInfo sceneRoleInfo = userrolerealtMap.get(userRoleRltId);
        if (Objects.isNull(sceneRoleInfo)) {
            sceneRoleInfo = new SceneRoleInfo(roleNumber, "1", roleId);
            sceneRoleInfo.setUserrolerealtId(userRoleRltId);
            sceneRoleInfo.setRoleBuLst(roleBuLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
            userrolerealtMap.put(userRoleRltId, sceneRoleInfo);
        } else {
            sceneRoleInfo.setRoleBuLst(roleBuLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
        }
    }

    private static void setDbRoleDr(DynamicObject urt, List<SchemeRule> roleRuleLst, Map<Long, SceneRoleInfo> userrolerealtMap) {
        if (CollectionUtils.isEmpty(roleRuleLst)) {
            return;
        }
        Long userRoleRltId = urt.getLong("id");
        String roleId = urt.getString("role.id");
        String roleNumber = urt.getString("role.number");
        SceneRoleInfo sceneRoleInfo = userrolerealtMap.get(userRoleRltId);
        if (Objects.isNull(sceneRoleInfo)) {
            sceneRoleInfo = new SceneRoleInfo(roleNumber, "1", roleId);
            sceneRoleInfo.setUserrolerealtId(userRoleRltId);
            sceneRoleInfo.setRoleRuleLst(roleRuleLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
            userrolerealtMap.put(userRoleRltId, sceneRoleInfo);
        } else {
            sceneRoleInfo.setRoleRuleLst(roleRuleLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
        }
    }

    private static void setDbRoleDim(DynamicObject urt, List<SchemeDim> roleDimLst, Map<Long, SceneRoleInfo> userrolerealtMap) {
        if (CollectionUtils.isEmpty(roleDimLst)) {
            return;
        }
        Long userRoleRltId = urt.getLong("id");
        String roleId = urt.getString("role.id");
        String roleNumber = urt.getString("role.number");
        SceneRoleInfo sceneRoleInfo = userrolerealtMap.get(userRoleRltId);
        if (Objects.isNull(sceneRoleInfo)) {
            sceneRoleInfo = new SceneRoleInfo(roleNumber, "1", roleId);
            sceneRoleInfo.setUserrolerealtId(userRoleRltId);
            sceneRoleInfo.setRoleDimLst(roleDimLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
            userrolerealtMap.put(userRoleRltId, sceneRoleInfo);
        } else {
            sceneRoleInfo.setRoleDimLst(roleDimLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
        }
    }

    private static void setDbRoleField(DynamicObject urt, List<SchemeField> roleFieldLst, Map<Long, SceneRoleInfo> userrolerealtMap) {
        if (CollectionUtils.isEmpty(roleFieldLst)) {
            return;
        }
        Long userRoleRltId = urt.getLong("id");
        String roleId = urt.getString("role.id");
        String roleNumber = urt.getString("role.number");
        SceneRoleInfo sceneRoleInfo = userrolerealtMap.get(userRoleRltId);
        if (Objects.isNull(sceneRoleInfo)) {
            sceneRoleInfo = new SceneRoleInfo(roleNumber, "1", roleId);
            sceneRoleInfo.setUserrolerealtId(userRoleRltId);
            sceneRoleInfo.setRoleFieldLst(roleFieldLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
            userrolerealtMap.put(userRoleRltId, sceneRoleInfo);
        } else {
            sceneRoleInfo.setRoleFieldLst(roleFieldLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
        }
    }
}

