/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.perm.SceneRoleInfo;
import kd.hr.hrcs.common.model.perm.dyna.BdRule;
import kd.hr.hrcs.common.model.perm.dyna.DynDim;
import kd.hr.hrcs.common.model.perm.dyna.DynaScheme;
import kd.hr.hrcs.common.model.perm.dyna.Field;
import kd.hr.hrcs.common.model.perm.dyna.Rule;
import kd.hr.hrcs.common.model.perm.dyna.SchemeDim;
import kd.hr.hrcs.common.model.perm.dyna.SchemeField;
import kd.hr.hrcs.common.model.perm.dyna.SchemeOrg;
import kd.hr.hrcs.common.model.perm.dyna.SchemeRule;

@ExcludeFromJacocoGeneratedReport
public class DynaSchemeRoleService {
    private static final Log LOGGER = LogFactory.getLog(DynaSchemeRoleService.class);

    public static void fillSchemeRoleDataRange(List<DynaScheme> schemeList) {
        schemeList.removeIf(it -> CollectionUtils.isEmpty((Collection)it.getRoleList()));
        HashSet entryIdSet = Sets.newHashSetWithExpectedSize((int)schemeList.size());
        HashSet schemeIdSet = Sets.newHashSetWithExpectedSize((int)schemeList.size());
        for (DynaScheme scheme : schemeList) {
            if (HRStringUtils.equals((String)scheme.getAuthAction(), (String)"2")) continue;
            for (SceneRoleInfo src : scheme.getRoleList()) {
                entryIdSet.add(src.getRoleEntryId());
            }
            schemeIdSet.add(scheme.getId());
        }
        if (entryIdSet.size() == 0) {
            return;
        }
        HRBaseServiceHelper buHelper = new HRBaseServiceHelper("hrcs_dynaschemeorg");
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_dynaschemedatarule");
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dynaschemedimgrp");
        HRBaseServiceHelper fieldHelper = new HRBaseServiceHelper("hrcs_dynaschemefield");
        DynamicObject[] buDys = buHelper.query("bucafunc,org,includesuborg,roleentryid,role,scheme", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("roleentryid", "in", (Object)entryIdSet), new QFilter("scheme.id", "in", (Object)schemeIdSet)});
        DynamicObject[] ruleDys = ruleHelper.query("scheme,role,app,entitytype,bucafunc,roleentryid,dataruleentry.permitem,dataruleentry.datarule,hrcs_rolebdruleentry.propkey,hrcs_rolebdruleentry.propentnum,hrcs_rolebdruleentry.bddatarule", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("roleentryid", "in", (Object)entryIdSet), new QFilter("scheme.id", "in", (Object)schemeIdSet)});
        DynamicObject[] dimDys = dimHelper.query("scheme,role,bucafunc,roleentryid,dimvalentry.dimension,dimvalentry.isall,dimvalentry.structproject,dimvalentry.admincontainssub,dimvalentry.containssub,dimvalentry.dimval,dimvalentry.valtype,dimvalentry.dynacond", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("roleentryid", "in", (Object)entryIdSet), new QFilter("scheme.id", "in", (Object)schemeIdSet)});
        DynamicObject[] fieldDys = fieldHelper.query("scheme,role,app,entitytype,roleentryid,fieldpermentry.fieldname,fieldpermentry.isbanread,fieldpermentry.isbanwrite", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("roleentryid", "in", (Object)entryIdSet), new QFilter("scheme.id", "in", (Object)schemeIdSet)});
        List<SchemeOrg> roleBuLst = null;
        if (buDys != null && buDys.length > 0) {
            roleBuLst = DynaSchemeRoleService.getRoleBu(buDys);
        }
        List<SchemeRule> roleRuleLst = null;
        if (ruleDys != null && ruleDys.length > 0) {
            roleRuleLst = DynaSchemeRoleService.getRoleDataRule(ruleDys);
        }
        List<SchemeDim> roleDimLst = null;
        if (dimDys != null && dimDys.length > 0) {
            roleDimLst = DynaSchemeRoleService.getRoleDim(dimDys);
        }
        List<SchemeField> roleFieldLst = null;
        if (fieldDys != null && fieldDys.length > 0) {
            roleFieldLst = DynaSchemeRoleService.getRoleField(fieldDys);
        }
        for (DynaScheme sc : schemeList) {
            for (SceneRoleInfo scr : sc.getRoleList()) {
                DynaSchemeRoleService.setRoleBu(scr, roleBuLst);
                DynaSchemeRoleService.setRoleDr(scr, roleRuleLst);
                DynaSchemeRoleService.setRoleDim(scr, roleDimLst);
                DynaSchemeRoleService.setRoleField(scr, roleFieldLst);
            }
        }
    }

    private static List<SchemeOrg> getRoleBu(DynamicObject[] buDys) {
        ArrayList roleBuLst = Lists.newArrayListWithExpectedSize((int)buDys.length);
        for (DynamicObject dy : buDys) {
            SchemeOrg schemeOrg = new SchemeOrg();
            Long scheme = dy.getLong("scheme.id");
            Long buCaFunc = dy.getLong("bucafunc.id");
            Long org = dy.getLong("org.id");
            boolean includeSubOrg = dy.getBoolean("includesuborg");
            Long roleEntryId = dy.getLong("roleentryid");
            String role = dy.getString("role.id");
            schemeOrg.setBuCaFunc(buCaFunc);
            schemeOrg.setScheme(scheme);
            schemeOrg.setIncludeSubOrg(includeSubOrg);
            schemeOrg.setOrgId(org);
            schemeOrg.setRoleEntryId(roleEntryId);
            schemeOrg.setRoleId(role);
            roleBuLst.add(schemeOrg);
        }
        return roleBuLst;
    }

    private static List<SchemeRule> getRoleDataRule(DynamicObject[] ruleDys) {
        ArrayList roleRuleLst = Lists.newArrayListWithExpectedSize((int)ruleDys.length);
        for (DynamicObject dy : ruleDys) {
            DynamicObjectCollection bdRuleEntry;
            SchemeRule schemeRule = new SchemeRule();
            Long scheme = dy.getLong("scheme.id");
            Long buCaFunc = dy.getLong("bucafunc.id");
            String app = dy.getString("app");
            Long roleEntryId = dy.getLong("roleentryid");
            String role = dy.getString("role.id");
            String entityType = dy.getString("entitytype");
            schemeRule.setScheme(scheme);
            schemeRule.setBuCaFunc(buCaFunc);
            schemeRule.setAppId(app);
            schemeRule.setRoleEntryId(roleEntryId);
            schemeRule.setRoleId(role);
            schemeRule.setEntityNumber(entityType);
            DynamicObjectCollection ruleEntry = dy.getDynamicObjectCollection("dataruleentry");
            if (!ruleEntry.isEmpty()) {
                ArrayList ruleList = Lists.newArrayListWithExpectedSize((int)ruleEntry.size());
                for (DynamicObject ruleDy : ruleEntry) {
                    Rule rule = new Rule();
                    String permItem = ruleDy.getString("permitem.id");
                    Long dataRule = ruleDy.getLong("datarule.id");
                    rule.setDataRule(dataRule);
                    rule.setPermItemId(permItem);
                    ruleList.add(rule);
                }
                schemeRule.setRuleList((List)ruleList);
            }
            if (!(bdRuleEntry = dy.getDynamicObjectCollection("hrcs_rolebdruleentry")).isEmpty()) {
                ArrayList bdRuleList = Lists.newArrayListWithExpectedSize((int)ruleEntry.size());
                for (DynamicObject bdDy : bdRuleEntry) {
                    BdRule bdRule = new BdRule();
                    String propKey = bdDy.getString("propkey");
                    String propentNum = bdDy.getString("propentnum");
                    Long bdDataRule = bdDy.getLong("bddatarule.id");
                    bdRule.setDataRule(bdDataRule);
                    bdRule.setPropKey(propKey);
                    bdRule.setPropNum(propentNum);
                    bdRuleList.add(bdRule);
                }
                schemeRule.setBdRuleList((List)bdRuleList);
            }
            roleRuleLst.add(schemeRule);
        }
        return roleRuleLst;
    }

    private static List<SchemeDim> getRoleDim(DynamicObject[] dimDys) {
        ArrayList roleDimLst = Lists.newArrayListWithExpectedSize((int)dimDys.length);
        for (DynamicObject dy : dimDys) {
            SchemeDim schemeDim = new SchemeDim();
            Long scheme = dy.getLong("scheme.id");
            Long buCaFunc = dy.getLong("bucafunc.id");
            Long roleEntryId = dy.getLong("roleentryid");
            String role = dy.getString("role.id");
            schemeDim.setScheme(scheme);
            schemeDim.setBuCaFunc(buCaFunc);
            schemeDim.setRoleEntryId(roleEntryId);
            schemeDim.setRoleId(role);
            DynamicObjectCollection dimEntry = dy.getDynamicObjectCollection("dimvalentry");
            if (!dimEntry.isEmpty()) {
                ArrayList dimList = Lists.newArrayListWithExpectedSize((int)dimEntry.size());
                for (DynamicObject dimDy : dimEntry) {
                    DynDim dim = new DynDim();
                    Long dimension = dimDy.getLong("dimension.id");
                    boolean isAll = dimDy.getBoolean("isall");
                    Long structProject = dimDy.getLong("structproject.id");
                    boolean adminContainsSub = dimDy.getBoolean("admincontainssub");
                    boolean containsSub = dimDy.getBoolean("containssub");
                    String dimVal = dimDy.getString("dimval");
                    String valType = dimDy.getString("valtype");
                    Long dynaCond = dimDy.getLong("dynacond.id");
                    dim.setDimId(dimension);
                    dim.setAll(isAll);
                    dim.setAdminContainsSub(adminContainsSub);
                    dim.setStructProjectId(structProject);
                    dim.setContainsSub(containsSub);
                    dim.setDimVal(dimVal);
                    dim.setValType(valType);
                    dim.setDynaCondId(dynaCond);
                    dimList.add(dim);
                }
                schemeDim.setDimList((List)dimList);
            }
            roleDimLst.add(schemeDim);
        }
        return roleDimLst;
    }

    private static List<SchemeField> getRoleField(DynamicObject[] fieldDys) {
        ArrayList roleFieldLst = Lists.newArrayListWithExpectedSize((int)fieldDys.length);
        for (DynamicObject dy : fieldDys) {
            SchemeField schemeField = new SchemeField();
            Long scheme = dy.getLong("scheme.id");
            String app = dy.getString("app.id");
            Long roleEntryId = dy.getLong("roleentryid");
            String role = dy.getString("role.id");
            String entityType = dy.getString("entitytype.id");
            schemeField.setApp(app);
            schemeField.setScheme(scheme);
            schemeField.setRoleId(role);
            schemeField.setRoleEntryId(roleEntryId);
            schemeField.setEntityType(entityType);
            DynamicObjectCollection fieldEntry = dy.getDynamicObjectCollection("fieldpermentry");
            if (!fieldEntry.isEmpty()) {
                ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)fieldEntry.size());
                for (DynamicObject fieldDy : fieldEntry) {
                    Field field = new Field();
                    String fieldName = fieldDy.getString("fieldname");
                    boolean isBanRead = fieldDy.getBoolean("isbanread");
                    boolean isBanWrite = fieldDy.getBoolean("isbanwrite");
                    field.setBanRead(isBanRead);
                    field.setBanWrite(isBanWrite);
                    field.setFieldProp(fieldName);
                    fieldList.add(field);
                }
                schemeField.setFieldList((List)fieldList);
            }
            roleFieldLst.add(schemeField);
        }
        return roleFieldLst;
    }

    private static void setRoleBu(SceneRoleInfo scr, List<SchemeOrg> roleBuLst) {
        if (roleBuLst == null) {
            return;
        }
        String roleId = scr.getRoleId();
        Long roleEntryId = scr.getRoleEntryId();
        List roleBu = roleBuLst.stream().filter(it -> HRStringUtils.equals((String)roleId, (String)it.getRoleId()) && roleEntryId.equals(it.getRoleEntryId())).collect(Collectors.toList());
        scr.setRoleBuLst(roleBu);
    }

    private static void setRoleDr(SceneRoleInfo scr, List<SchemeRule> roleRuleLst) {
        if (roleRuleLst == null) {
            return;
        }
        String roleId = scr.getRoleId();
        Long roleEntryId = scr.getRoleEntryId();
        List roleDr = roleRuleLst.stream().filter(it -> HRStringUtils.equals((String)roleId, (String)it.getRoleId()) && roleEntryId.equals(it.getRoleEntryId())).collect(Collectors.toList());
        scr.setRoleRuleLst(roleDr);
    }

    private static void setRoleDim(SceneRoleInfo scr, List<SchemeDim> roleDimLst) {
        if (roleDimLst == null) {
            return;
        }
        String roleId = scr.getRoleId();
        Long roleEntryId = scr.getRoleEntryId();
        List roleDim = roleDimLst.stream().filter(it -> HRStringUtils.equals((String)roleId, (String)it.getRoleId()) && roleEntryId.equals(it.getRoleEntryId())).collect(Collectors.toList());
        scr.setRoleDimLst(roleDim);
    }

    private static void setRoleField(SceneRoleInfo scr, List<SchemeField> roleFieldLst) {
        if (roleFieldLst == null) {
            return;
        }
        String roleId = scr.getRoleId();
        Long roleEntryId = scr.getRoleEntryId();
        List roleField = roleFieldLst.stream().filter(it -> HRStringUtils.equals((String)roleId, (String)it.getRoleId()) && roleEntryId.equals(it.getRoleEntryId())).collect(Collectors.toList());
        scr.setRoleFieldLst(roleField);
    }
}

