/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.tcc.TCCSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.common.model.perminit.ImportUserBdDataRuleModel;
import kd.hr.hrcs.common.model.perminit.ImportUserDataRuleModel;
import kd.hr.hrcs.common.model.perminit.ImportUserDimModel;
import kd.hr.hrcs.common.model.perminit.ImportUserFieldModel;
import kd.hr.hrcs.common.model.perminit.OrgRangeBean;
import kd.hr.hrcs.common.model.perminit.PermInitRecord;
import kd.hr.hrcs.common.model.perminit.PermInitTccParam;

public class PermInitConvertService {
    private static final Log LOGGER = LogFactory.getLog(PermInitConvertService.class);
    private static final HRBaseServiceHelper PERM_INIT_RECORD_HELPER = new HRBaseServiceHelper("hrcs_perminitrecord");

    public static boolean convertRecord(Long recordId) {
        LOGGER.info("ConvertPermInitRecord start,recordId:{}", (Object)recordId);
        DynamicObject recordDyna = PERM_INIT_RECORD_HELPER.loadDynamicObject(new QFilter("id", "=", (Object)recordId));
        if (recordDyna == null) {
            LOGGER.error("PermInitRecord not exist. recordId={}", (Object)recordId);
            return false;
        }
        if (!HRStringUtils.equals((String)recordDyna.getString("dealstatus"), (String)"0")) {
            LOGGER.error("PermInitRecord dealstatus is not 0. recordId={}", (Object)recordId);
            return false;
        }
        PermInitRecord initRecord = new PermInitRecord(recordId);
        initRecord.setIncludeSub(recordDyna.getBoolean("includesub"));
        List<ImportUserDimModel> userDimModelList = PermInitConvertService.buildUserDimModelList(recordDyna);
        initRecord.setUserDimModelList(userDimModelList);
        List<ImportUserDataRuleModel> userDataRuleModelList = PermInitConvertService.buildUserDataRuleModelList(recordDyna);
        initRecord.setUserDataRuleModelList(userDataRuleModelList);
        List<ImportUserBdDataRuleModel> userBdDataRuleModelList = PermInitConvertService.buildUserBdDataRuleModelList(recordDyna);
        initRecord.setUserBdDataRuleModelList(userBdDataRuleModelList);
        List<ImportUserFieldModel> userFieldModelList = PermInitConvertService.buildUserFieldModelList(recordDyna);
        initRecord.setUserFieldModelList(userFieldModelList);
        Map<String, List<OrgRangeBean>> roleOrgRangeMap = PermInitConvertService.buildRoleOrgMap(userDimModelList);
        initRecord.setRoleOrgRangeMap(roleOrgRangeMap);
        Map<String, String> sysUserRoleIdMap = PermInitConvertService.buildSysUserRoleIdMap(userDimModelList, roleOrgRangeMap);
        initRecord.setSysUserRoleIdMap(sysUserRoleIdMap);
        TCCSession session = DtxFactory.createTCC((String)"hrcs_perminit_recordconvert");
        try {
            String cloudId = "hrmp";
            String appId = "hrcs";
            PermInitTccParam permInitTccParam = new PermInitTccParam(initRecord);
            session.Try(cloudId, appId, "PermInitConvertToSysTccService", (Param)permInitTccParam, "convertToSys");
            session.Try(cloudId, appId, "PermInitConvertToHmpTccService", (Param)permInitTccParam, "convertToHmp");
        }
        catch (Exception ex) {
            session.rollback();
            LOGGER.error("convertPermInitRecord error.", (Throwable)ex);
            return false;
        }
        session.commit();
        LOGGER.info("ConvertPermInitRecord end,recordId:{}", (Object)recordId);
        return true;
    }

    private static List<ImportUserDimModel> buildUserDimModelList(DynamicObject recordDyna) {
        DynamicObjectCollection userDimEntryColl = recordDyna.getDynamicObjectCollection("userdimentry");
        ArrayList userDimModelList = Lists.newArrayListWithExpectedSize((int)userDimEntryColl.size());
        for (DynamicObject userDimEntry : userDimEntryColl) {
            ImportUserDimModel userDimModel = new ImportUserDimModel();
            userDimModel.setUserId(Long.valueOf(userDimEntry.getLong("dim_user.id")));
            userDimModel.setFileOrgId(Long.valueOf(userDimEntry.getLong("dim_fileorg.id")));
            userDimModel.setRoleId(userDimEntry.getString("dim_role.id"));
            userDimModel.setValidStart(userDimEntry.getDate("dim_validstart"));
            userDimModel.setValidEnd(userDimEntry.getDate("dim_validend"));
            userDimModel.setCustomEnable(userDimEntry.getBoolean("dim_customenable"));
            userDimModel.setBucaFuncId(Long.valueOf(userDimEntry.getLong("dim_bucafunc.id")));
            DynamicObjectCollection orgRangeColl = userDimEntry.getDynamicObjectCollection("dim_orgrange");
            List orgRangeList = orgRangeColl.stream().map(dyna -> dyna.getLong("fbasedataid_id")).collect(Collectors.toList());
            userDimModel.setOrgRangeList(orgRangeList);
            DynamicObjectCollection dimValSubEntryColl = userDimEntry.getDynamicObjectCollection("userdimvalueentry");
            ArrayList dimValues = Lists.newArrayListWithExpectedSize((int)dimValSubEntryColl.size());
            for (DynamicObject dimValDyna : dimValSubEntryColl) {
                dimValues.add(new DimValueBean(Long.valueOf(dimValDyna.getLong("dim_dimension.id")), Long.valueOf(dimValDyna.getLong("dim_otclassify.id")), dimValDyna.getString("dim_dimval"), dimValDyna.getBoolean("dim_isall"), Long.valueOf(dimValDyna.getLong("dim_structproject.id"))));
            }
            userDimModel.setDimValues((List)dimValues);
            userDimModelList.add(userDimModel);
        }
        return userDimModelList;
    }

    private static List<ImportUserDataRuleModel> buildUserDataRuleModelList(DynamicObject recordDyna) {
        DynamicObjectCollection userDataRuleEntryColl = recordDyna.getDynamicObjectCollection("userdataruleentry");
        ArrayList userDataRuleModelList = Lists.newArrayListWithExpectedSize((int)userDataRuleEntryColl.size());
        for (DynamicObject userDataRuleEntry : userDataRuleEntryColl) {
            ImportUserDataRuleModel userDataRuleModel = new ImportUserDataRuleModel();
            userDataRuleModel.setUserId(Long.valueOf(userDataRuleEntry.getLong("dr_user.id")));
            userDataRuleModel.setFileOrgId(Long.valueOf(userDataRuleEntry.getLong("dr_fileorg.id")));
            userDataRuleModel.setRoleId(userDataRuleEntry.getString("dr_role.id"));
            userDataRuleModel.setAppId(userDataRuleEntry.getString("dr_app.id"));
            userDataRuleModel.setEntityNumber(userDataRuleEntry.getString("dr_entitytype.number"));
            userDataRuleModel.setDataRuleId(Long.valueOf(userDataRuleEntry.getLong("dr_datarule.id")));
            DynamicObjectCollection permItemColl = userDataRuleEntry.getDynamicObjectCollection("dr_permitemmulti");
            List permItemList = permItemColl.stream().map(dyna -> dyna.getString("fbasedataid_id")).collect(Collectors.toList());
            userDataRuleModel.setPermItemList(permItemList);
            userDataRuleModelList.add(userDataRuleModel);
        }
        return userDataRuleModelList;
    }

    private static List<ImportUserBdDataRuleModel> buildUserBdDataRuleModelList(DynamicObject recordDyna) {
        DynamicObjectCollection userBdDataRuleEntryColl = recordDyna.getDynamicObjectCollection("userbdentry");
        ArrayList userBdDataRuleModelList = Lists.newArrayListWithExpectedSize((int)userBdDataRuleEntryColl.size());
        for (DynamicObject userBdDataRuleEntry : userBdDataRuleEntryColl) {
            ImportUserBdDataRuleModel userBdDataRuleModel = new ImportUserBdDataRuleModel();
            userBdDataRuleModel.setUserId(Long.valueOf(userBdDataRuleEntry.getLong("bd_user.id")));
            userBdDataRuleModel.setFileOrgId(Long.valueOf(userBdDataRuleEntry.getLong("bd_fileorg.id")));
            userBdDataRuleModel.setRoleId(userBdDataRuleEntry.getString("bd_role.id"));
            userBdDataRuleModel.setAppId(userBdDataRuleEntry.getString("bd_app.id"));
            userBdDataRuleModel.setEntityNumber(userBdDataRuleEntry.getString("bd_entitytype.number"));
            userBdDataRuleModel.setPropKey(userBdDataRuleEntry.getString("bd_propkey"));
            userBdDataRuleModel.setPropEntNum(userBdDataRuleEntry.getString("bd_propentnum"));
            userBdDataRuleModel.setDataRuleId(Long.valueOf(userBdDataRuleEntry.getLong("bd_datarule.id")));
            userBdDataRuleModelList.add(userBdDataRuleModel);
        }
        return userBdDataRuleModelList;
    }

    private static List<ImportUserFieldModel> buildUserFieldModelList(DynamicObject recordDyna) {
        DynamicObjectCollection userFieldEntryColl = recordDyna.getDynamicObjectCollection("userfieldentry");
        ArrayList userFieldModelList = Lists.newArrayListWithExpectedSize((int)userFieldEntryColl.size());
        for (DynamicObject userFieldEntry : userFieldEntryColl) {
            ImportUserFieldModel userFieldModel = new ImportUserFieldModel();
            userFieldModel.setUserId(Long.valueOf(userFieldEntry.getLong("field_user.id")));
            userFieldModel.setFileOrgId(Long.valueOf(userFieldEntry.getLong("field_fileorg.id")));
            userFieldModel.setRoleId(userFieldEntry.getString("field_role.id"));
            userFieldModel.setAppId(userFieldEntry.getString("field_app.id"));
            userFieldModel.setEntityNumber(userFieldEntry.getString("field_entitytype.number"));
            userFieldModel.setPropKey(userFieldEntry.getString("field_propkey"));
            userFieldModel.setCanRead(userFieldEntry.getBoolean("field_canread"));
            userFieldModel.setCanWrite(userFieldEntry.getBoolean("field_canwrite"));
            userFieldModelList.add(userFieldModel);
        }
        return userFieldModelList;
    }

    private static Map<String, List<OrgRangeBean>> buildRoleOrgMap(List<ImportUserDimModel> userDimModelList) {
        HashSet keepSameRoles = Sets.newHashSetWithExpectedSize((int)16);
        for (ImportUserDimModel userDimModel : userDimModelList) {
            if (userDimModel.getCustomEnable()) continue;
            keepSameRoles.add(userDimModel.getRoleId());
        }
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        DynamicObject[] roleBuDynaArr = roleBuHelper.queryOriginalArray("hrbucafunc,role,org.id,containssub", new QFilter[]{new QFilter("role", "in", (Object)keepSameRoles)});
        HashMap roleOrgRangeMap = Maps.newHashMapWithExpectedSize((int)keepSameRoles.size());
        keepSameRoles.forEach(roleId -> {
            List cfr_ignored_0 = roleOrgRangeMap.put(roleId, Lists.newArrayListWithExpectedSize((int)16));
        });
        for (DynamicObject roleBuDyna : roleBuDynaArr) {
            String roleId2 = roleBuDyna.getString("role");
            OrgRangeBean orgRangeBean = new OrgRangeBean(Long.valueOf(roleBuDyna.getLong("hrbucafunc")), Long.valueOf(roleBuDyna.getLong("org.id")), Boolean.valueOf(roleBuDyna.getBoolean("containssub")));
            ((List)roleOrgRangeMap.get(roleId2)).add(orgRangeBean);
        }
        return roleOrgRangeMap;
    }

    private static Map<String, String> buildSysUserRoleIdMap(List<ImportUserDimModel> userDimModelList, Map<String, List<OrgRangeBean>> roleOrgRangeMap) {
        ArrayList sysUserRoleIdMapKeys = Lists.newArrayListWithExpectedSize((int)16);
        for (ImportUserDimModel userDimModel : userDimModelList) {
            if (userDimModel.getCustomEnable()) {
                for (Long orgId : userDimModel.getOrgRangeList()) {
                    String key = PermInitServiceHelper.joinToKey(userDimModel.getUserId(), userDimModel.getFileOrgId(), userDimModel.getRoleId(), userDimModel.getBucaFuncId(), orgId);
                    sysUserRoleIdMapKeys.add(key);
                }
                continue;
            }
            List<OrgRangeBean> orgRangeBeans = roleOrgRangeMap.get(userDimModel.getRoleId());
            for (OrgRangeBean orgRangeBean : orgRangeBeans) {
                String key = PermInitServiceHelper.joinToKey(userDimModel.getUserId(), userDimModel.getFileOrgId(), userDimModel.getRoleId(), orgRangeBean.getBucaFuncId(), orgRangeBean.getOrgId());
                sysUserRoleIdMapKeys.add(key);
            }
        }
        HashMap sysUserRoleIdMap = Maps.newHashMapWithExpectedSize((int)sysUserRoleIdMapKeys.size());
        String[] ids = ORM.create().genStringIds("perm_userrole", sysUserRoleIdMapKeys.size());
        for (int idx = 0; idx < sysUserRoleIdMapKeys.size(); ++idx) {
            sysUserRoleIdMap.put(sysUserRoleIdMapKeys.get(idx), ids[idx]);
        }
        return sysUserRoleIdMap;
    }
}

