/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.RoleFuncInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class PermInitFinishValidateService {
    private static final Log LOGGER = LogFactory.getLog(PermInitFinishValidateService.class);

    public int[] clickFinishValidate(Long recordId) {
        HRBaseServiceHelper permInitRecordHelper = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject recordDyna = permInitRecordHelper.loadSingle((Object)recordId);
        DynamicObjectCollection userDimEntryColl = recordDyna.getDynamicObjectCollection("userdimentry");
        DynamicObjectCollection userDataRuleEntryColl = recordDyna.getDynamicObjectCollection("userdataruleentry");
        DynamicObjectCollection userBdEntryColl = recordDyna.getDynamicObjectCollection("userbdentry");
        DynamicObjectCollection userFieldEntryColl = recordDyna.getDynamicObjectCollection("userfieldentry");
        Set<String> roleIdsSheetBack3 = this.collectRole(userDataRuleEntryColl, userBdEntryColl, userFieldEntryColl);
        Map<String, List<RoleFuncInfo>> roleFuncMap = PermInitServiceHelper.queryRoleFuncInfo(roleIdsSheetBack3);
        Set<Long> dataRuleIds = this.collectDataRule(userDataRuleEntryColl, userBdEntryColl);
        Map<Long, DynamicObject> dataRuleMap = PermInitServiceHelper.queryDataRuleInfo(dataRuleIds);
        HashMap userRoleCheckResultMap = Maps.newHashMapWithExpectedSize((int)userDimEntryColl.size());
        int userRoleErrorNum = this.checkUserRoleSheet(userDimEntryColl, userRoleCheckResultMap);
        int dateRuleErrorNum = this.checkDataRuleSheet(userDataRuleEntryColl, userRoleCheckResultMap, roleFuncMap, dataRuleMap);
        int bdDataRuleErrorNum = this.checkBdDataRuleSheet(userBdEntryColl, userRoleCheckResultMap, roleFuncMap, dataRuleMap);
        int fieldErrorNum = this.checkFieldSheet(userFieldEntryColl, userRoleCheckResultMap, roleFuncMap);
        LOGGER.info("clickFinishValidate result userRoleErrorNum:{},dateRuleErrorNum:{},bdDataRuleErrorNum:{},fieldErrorNum:{}", new Object[]{userRoleErrorNum, dateRuleErrorNum, bdDataRuleErrorNum, fieldErrorNum});
        permInitRecordHelper.saveOne(recordDyna);
        return new int[]{userRoleErrorNum, dateRuleErrorNum, bdDataRuleErrorNum, fieldErrorNum};
    }

    private int checkUserRoleSheet(DynamicObjectCollection userDimEntryColl, Map<String, String> userRoleCheckResultMap) {
        int errorNum = 0;
        Set<String> roleIds = userDimEntryColl.stream().map(dyna -> dyna.getString("dim_role.id")).collect(Collectors.toSet());
        Set<Long> userIds = userDimEntryColl.stream().map(dyna -> dyna.getLong("dim_user.id")).collect(Collectors.toSet());
        Map<String, DynamicObject> sysRoleMap = PermInitServiceHelper.querySysRoleInfo(roleIds);
        Map<Long, DynamicObject> sysUserMap = PermInitServiceHelper.querySysUserInfo(userIds);
        Map<String, DynamicObject> permFileMap = PermInitServiceHelper.queryPermFileInfo(userIds);
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        Map<String, Set<Long>> roleBucaFuncMapFromRecord = this.collectRoleBucaFromRecord(userDimEntryColl);
        Map<String, Set<Long>> roleBucaFuncMapFromDb = PermInitServiceHelper.queryRoleBucaFuncInfo(roleIds);
        Map<Long, String> bucaFuncNameMap = PermInitServiceHelper.queryBucaFuncInfo();
        Map<String, List<Long>> roleBusMap = PermInitServiceHelper.queryRoleBus(roleIds);
        Map<String, DynamicObject> hrRoleDynaMap = PermInitServiceHelper.queryHrRoleInfo(roleIds);
        Map<String, Set<Long>> roleBucaDimMap = PermInitServiceHelper.queryRoleDimensionInfo(roleIds);
        Map<Long, String> dimNameMap = PermInitServiceHelper.queryDimNameInfo();
        String separator = ResManager.loadKDString((String)";", (String)"PermInitFinishValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        Map<Long, String> allDynaCondNameMap = PermInitServiceHelper.getAllDynaCondNameMap();
        Map<Long, String> allDynaCondMapIdNumber = PermInitServiceHelper.getAllDynaCondMapIdNumber();
        for (DynamicObject userRoleEntry : userDimEntryColl) {
            String errorMsg;
            DynamicObject fileDyna;
            userRoleEntry.set("dim_errormsg", (Object)" ");
            Long userId = userRoleEntry.getLong("dim_user.id");
            Long fileOrgId = userRoleEntry.getLong("dim_fileorg.id");
            String roleId = userRoleEntry.getString("dim_role.id");
            Long bucaFuncId = userRoleEntry.getLong("dim_bucafunc.id");
            String checkResultKey = PermInitServiceHelper.joinToKey(userId, fileOrgId, roleId);
            ArrayList errorStrList = Lists.newArrayListWithExpectedSize((int)10);
            DynamicObject sysRoleDyna = sysRoleMap.get(roleId);
            if (sysRoleDyna == null) {
                errorStrList.add(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            } else if (!sysRoleDyna.getBoolean("enable")) {
                errorStrList.add(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u7528\u6237", (String)"PermInitFinishValidateService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (sysUserMap.get(userId).getBoolean("isforbidden")) {
                errorStrList.add(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u89d2\u8272", (String)"PermInitFinishValidateService_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if ((fileDyna = permFileMap.get(PermInitServiceHelper.joinToKey(userId, userRoleEntry.getLong("dim_fileorg.id")))) == null) {
                errorStrList.add(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709HR\u7ba1\u7406\u7ec4\u7ec7\u7684\u6743\u9650\u6863\u6848", (String)"PermInitFinishValidateService_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            } else if (!fileDyna.getBoolean("permfileenable")) {
                errorStrList.add(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6240\u5c5e\u7684\u7ec4\u7ec7\u7684\u6743\u9650\u6863\u6848\u5df2\u5931\u6548\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u89d2\u8272", (String)"PermInitFinishValidateService_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)errorStrList)) {
                userRoleEntry.set("dim_errormsg", (Object)String.join((CharSequence)separator, errorStrList));
                userRoleCheckResultMap.put(checkResultKey, "fail");
                ++errorNum;
                continue;
            }
            Set<Long> roleBucaFuncListFromRecord = roleBucaFuncMapFromRecord.get(roleId);
            Set<Long> roleBucaFuncListFromDb = roleBucaFuncMapFromDb.get(roleId);
            roleBucaFuncListFromRecord = this.nullGuard(roleBucaFuncListFromRecord);
            Sets.SetView roleBucaFuncListNoExist = Sets.difference(roleBucaFuncListFromDb = this.nullGuard(roleBucaFuncListFromDb), roleBucaFuncListFromRecord);
            if (CollectionUtils.isNotEmpty((Collection)roleBucaFuncListNoExist)) {
                List bucaNames = roleBucaFuncListNoExist.stream().map(bucaId -> (String)bucaFuncNameMap.get(bucaId)).collect(Collectors.toList());
                String roleBucaNameNoExist = String.join((CharSequence)ResManager.loadKDString((String)";", (String)"PermInitFinishValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]), bucaNames);
                errorStrList.add(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u7f3a\u5c11\u201c%s\u201d\u804c\u80fd\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_12", (String)"hrmp-hrcs-business", (Object[])new Object[]{roleBucaNameNoExist}));
            }
            if (!roleBucaFuncListFromDb.contains(bucaFuncId)) {
                errorStrList.add(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u65e0\u201c%s\u201d\u804c\u80fd\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_13", (String)"hrmp-hrcs-business", (Object[])new Object[]{bucaFuncNameMap.get(bucaFuncId)}));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)errorStrList)) {
                userRoleEntry.set("dim_errormsg", (Object)String.join((CharSequence)separator, errorStrList));
                userRoleCheckResultMap.put(checkResultKey, "fail");
                ++errorNum;
                continue;
            }
            DynamicObject hrRoleDyna = hrRoleDynaMap.get(roleId);
            boolean isAllowCustom = hrRoleDyna.getBoolean("property");
            boolean isCustom = userRoleEntry.getBoolean("dim_customenable");
            if (!isAllowCustom && isCustom) {
                errorStrList.add(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u7684\u6570\u636e\u8303\u56f4\u5c5e\u6027\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u201c\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4\u201d\uff0c\u8bf7\u8c03\u6574\u6570\u636e", (String)"PermInitFinishValidateService_14", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (isAllowCustom && CollectionUtils.isEmpty((Collection)roleBusMap.get(roleId)) && !isCustom) {
                errorStrList.add(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u7684\u6570\u636e\u8303\u56f4\u5c5e\u6027\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u201c\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\uff0c\u8bf7\u8c03\u6574\u6570\u636e", (String)"PermInitFinishValidateService_19", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)errorStrList)) {
                userRoleEntry.set("dim_errormsg", (Object)String.join((CharSequence)separator, errorStrList));
                userRoleCheckResultMap.put(checkResultKey, "fail");
                ++errorNum;
                continue;
            }
            HashMap dynacondMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap orgTeamDynacondMap = Maps.newHashMapWithExpectedSize((int)16);
            Pair<Map<Long, List<String>>, Map<String, List<String>>> dimValPair = this.collectDimVals(userRoleEntry, dynacondMap, orgTeamDynacondMap);
            Map allDimValMap = (Map)dimValPair.getLeft();
            Map otDimtMap = (Map)dimValPair.getRight();
            HashMap oTDimValueMap = Maps.newHashMapWithExpectedSize((int)16);
            Map<Long, Map<String, Pair<String, String>>> dimValNameResult = PermInitServiceHelper.structDimInfo(allDimValMap, otDimtMap, oTDimValueMap);
            HashSet allDimIdList = Sets.newHashSetWithExpectedSize((int)16);
            for (Long aLong : dynacondMap.keySet()) {
                allDimIdList.add(aLong.toString());
            }
            allDimIdList.addAll(orgTeamDynacondMap.keySet());
            Map<String, List<String>> dimDynaRangeMap = PermInitServiceHelper.getDimDynaRangeMap(allDimIdList);
            HashSet notExistValDims = Sets.newHashSetWithExpectedSize((int)16);
            ArrayList otDimIds = Lists.newArrayListWithExpectedSize((int)otDimtMap.size());
            for (String string : otDimtMap.keySet()) {
                otDimIds.add(Long.valueOf(string.split("#")[0]));
            }
            for (Map.Entry entry : allDimValMap.entrySet()) {
                Long dimId2 = (Long)entry.getKey();
                List dimVals = (List)entry.getValue();
                if (otDimIds.contains(dimId2)) continue;
                Iterator iterator = dimVals.iterator();
                while (iterator.hasNext()) {
                    String dimVal = (String)iterator.next();
                    Map<String, Pair<String, String>> map = dimValNameResult.get(dimId2);
                    if (map == null) {
                        notExistValDims.add(dimId2);
                        continue;
                    }
                    if (map.get(dimVal) != null) continue;
                    notExistValDims.add(dimId2);
                }
            }
            StringBuilder notRightDynaStringBuilder = new StringBuilder();
            StringBuilder stringBuilder = new StringBuilder();
            Set<Long> allDynaCondId = allDynaCondNameMap.keySet();
            for (Map.Entry entry : dynacondMap.entrySet()) {
                ArrayList notRightDynas = Lists.newArrayListWithCapacity((int)16);
                Long l = (Long)entry.getKey();
                List<String> dynaRanges = dimDynaRangeMap.get(l.toString());
                List value = (List)entry.getValue();
                if (!allDynaCondId.containsAll(value)) {
                    notExistValDims.add(l);
                    continue;
                }
                for (Long dynaid : value) {
                    if (!CollectionUtils.isNotEmpty(dynaRanges) || dynaRanges.contains(allDynaCondMapIdNumber.get(dynaid))) continue;
                    notRightDynas.add(allDynaCondNameMap.get(dynaid));
                }
                if (!CollectionUtils.isNotEmpty((Collection)notRightDynas)) continue;
                String dynaNotRightErrMsg = ResManager.loadKDString((String)"%s\uff1b", (String)"PermInitFinishValidateService_22", (String)"hrmp-hrcs-business", (Object[])new Object[]{String.join((CharSequence)"\u3001", notRightDynas)});
                String validateService_23 = String.format(ResManager.loadKDString((String)"\u52a8\u6001\u6570\u636e\u8303\u56f4\u201c%1$s\u201d\u4e0d\u9002\u7528\u4e8e\u201d%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\uff1b", (String)"PermInitFinishValidateService_23", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dynaNotRightErrMsg, dimNameMap.get(l));
                notRightDynaStringBuilder.append(validateService_23);
            }
            if (CollectionUtils.isNotEmpty((Collection)notExistValDims)) {
                Set dimNames = notExistValDims.stream().map(dimId -> (String)dimNameMap.get(dimId)).collect(Collectors.toSet());
                String string = String.join((CharSequence)ResManager.loadKDString((String)";", (String)"PermInitFinishValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dimNames);
                String errorMsg2 = ResManager.loadKDString((String)"\u3010*%s*\u3011\u7684\u90e8\u5206\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_20", (String)"hrmp-hrcs-business", (Object[])new Object[]{string});
                LOGGER.info("notExistValDims:{},notExistValDimName:{}", (Object)notExistValDims, (Object)string);
                userRoleEntry.set("dim_errormsg", (Object)errorMsg2);
                userRoleCheckResultMap.put(checkResultKey, "fail");
                ++errorNum;
                continue;
            }
            if (HRStringUtils.isNotEmpty((String)notRightDynaStringBuilder.toString())) {
                userRoleEntry.set("dim_errormsg", (Object)notRightDynaStringBuilder.toString());
                userRoleCheckResultMap.put(checkResultKey, "fail");
                ++errorNum;
                continue;
            }
            String unlimited = ResManager.loadKDString((String)"\u4e0d\u9650", (String)"PermInitImportValidateService_38", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            HashSet hashSet = Sets.newHashSet((Object[])new String[]{unlimited, "all", "All", "ALL", "aLL", "alL", "aLl", "AlL"});
            if (MapUtils.isNotEmpty((Map)otDimtMap)) {
                for (Map.Entry entry : otDimtMap.entrySet()) {
                    Object dimName;
                    String dimKey = (String)entry.getKey();
                    Long dimId4 = Long.valueOf(dimKey.split("#")[0]);
                    Long structProId = Long.valueOf(dimKey.split("#")[1]);
                    List dimVals = (List)entry.getValue();
                    List noLimitedDimVals = dimVals.stream().filter(it -> !unlimitedSet.contains(it)).collect(Collectors.toList());
                    List triples = (List)oTDimValueMap.get(dimId4);
                    if (CollectionUtils.isEmpty((Collection)triples)) {
                        if (!CollectionUtils.isNotEmpty(noLimitedDimVals)) continue;
                        dimName = dimNameMap.get(dimId4);
                        String errorMsg3 = ResManager.loadKDString((String)"\u3010*%s*\u3011\u7684\u90e8\u5206\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_20", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimName});
                        LOGGER.info("triples:{},dimKey:{},dimVals:{},noLimitedDimVals:{}", new Object[]{triples, dimKey, dimVals, noLimitedDimVals});
                        userRoleEntry.set("dim_errormsg", (Object)errorMsg3);
                        userRoleCheckResultMap.put(checkResultKey, "fail");
                        ++errorNum;
                        continue;
                    }
                    noLimitedDimVals.removeIf(it -> this.getNotExtDv(triples, (String)it, structProId));
                    if (!CollectionUtils.isNotEmpty(noLimitedDimVals)) continue;
                    dimName = dimNameMap.get(dimId4);
                    String errorMsg2 = ResManager.loadKDString((String)"\u3010*%s*\u3011\u7684\u90e8\u5206\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_20", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimName});
                    LOGGER.info("triples:{},dimKey:{},dimVals:{},noLimitedDimVals:{}", new Object[]{triples, dimKey, dimVals, noLimitedDimVals});
                    userRoleEntry.set("dim_errormsg", (Object)errorMsg2);
                    userRoleCheckResultMap.put(checkResultKey, "fail");
                    ++errorNum;
                }
            }
            HashSet notExistDynaconds = Sets.newHashSetWithExpectedSize((int)16);
            for (Map.Entry entry4 : orgTeamDynacondMap.entrySet()) {
                String dimKey = (String)entry4.getKey();
                Long dimId5 = Long.valueOf(dimKey.split("#")[0]);
                ArrayList notRightDynas = Lists.newArrayListWithCapacity((int)16);
                List<String> dynaRanges = dimDynaRangeMap.get(dimKey);
                List value = (List)entry4.getValue();
                if (!allDynaCondId.containsAll(value)) {
                    notExistDynaconds.add(dimId5);
                    continue;
                }
                for (Long dynaid : value) {
                    if (!CollectionUtils.isNotEmpty(dynaRanges) || dynaRanges.contains(allDynaCondMapIdNumber.get(dynaid))) continue;
                    notRightDynas.add(allDynaCondNameMap.get(dynaid));
                }
                if (!CollectionUtils.isNotEmpty((Collection)notRightDynas)) continue;
                String dynaNotRightErrMsg = ResManager.loadKDString((String)"%s\uff1b", (String)"PermInitFinishValidateService_22", (String)"hrmp-hrcs-business", (Object[])new Object[]{String.join((CharSequence)"\u3001", notRightDynas)});
                String validateService_23 = String.format(ResManager.loadKDString((String)"\u52a8\u6001\u6570\u636e\u8303\u56f4\u201c%1$s\u201d\u4e0d\u9002\u7528\u4e8e\u201d%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\uff1b", (String)"PermInitFinishValidateService_23", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dynaNotRightErrMsg, dimNameMap.get(dimId5));
                stringBuilder.append(validateService_23);
            }
            if (CollectionUtils.isNotEmpty((Collection)notExistDynaconds)) {
                Set set = notExistDynaconds.stream().map(dimId -> (String)dimNameMap.get(dimId)).collect(Collectors.toSet());
                String notExistValDimName = String.join((CharSequence)ResManager.loadKDString((String)";", (String)"PermInitFinishValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]), set);
                errorMsg = ResManager.loadKDString((String)"\u3010*%s*\u3011\u7684\u90e8\u5206\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_20", (String)"hrmp-hrcs-business", (Object[])new Object[]{notExistValDimName});
                LOGGER.info("notExistValDims:{},notExistValDimName:{}", (Object)notExistDynaconds, (Object)notExistValDimName);
                userRoleEntry.set("dim_errormsg", (Object)errorMsg);
                userRoleCheckResultMap.put(checkResultKey, "fail");
                ++errorNum;
                continue;
            }
            if (HRStringUtils.isNotEmpty((String)stringBuilder.toString())) {
                userRoleEntry.set("dim_errormsg", (Object)stringBuilder.toString());
                userRoleCheckResultMap.put(checkResultKey, "fail");
                ++errorNum;
                continue;
            }
            if (enableValidateTime) {
                Date date = userRoleEntry.getDate("dim_validstart");
                Date validEnd = userRoleEntry.getDate("dim_validend");
                if (date == null || validEnd == null) {
                    errorMsg = ResManager.loadKDString((String)"\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_17", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                    userRoleEntry.set("dim_errormsg", (Object)errorMsg);
                    userRoleCheckResultMap.put(checkResultKey, "fail");
                    ++errorNum;
                    continue;
                }
            }
            if (!isCustom) continue;
            DynamicObjectCollection dynamicObjectCollection = userRoleEntry.getDynamicObjectCollection("userdimvalueentry");
            HashSet dimIdsFromRecord = Sets.newHashSetWithExpectedSize((int)16);
            dynamicObjectCollection.forEach(dimValDyna -> dimIdsFromRecord.add(dimValDyna.getLong("dim_dimension.id")));
            Set<Long> dimIdsFromDb = roleBucaDimMap.get(PermInitServiceHelper.joinToKey(roleId, bucaFuncId));
            dimIdsFromDb = this.nullGuard(dimIdsFromDb);
            if (CollectionUtils.isEmpty(dimIdsFromDb) && CollectionUtils.isNotEmpty((Collection)dimIdsFromRecord)) {
                Set dimNamesFromRecord = dimIdsFromRecord.stream().map(id -> (String)dimNameMap.get(id)).collect(Collectors.toSet());
                String redundantDimName = String.join((CharSequence)ResManager.loadKDString((String)";", (String)"PermInitFinishValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dimNamesFromRecord);
                String errorMsg4 = ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u65e0\u9700\u8bbe\u7f6e\u201c%s\u201d\u89d2\u8272\u7ef4\u5ea6", (String)"PermInitFinishValidateService_15", (String)"hrmp-hrcs-business", (Object[])new Object[]{redundantDimName});
                userRoleEntry.set("dim_errormsg", (Object)errorMsg4);
                userRoleCheckResultMap.put(checkResultKey, "fail");
                ++errorNum;
                continue;
            }
            Sets.SetView redundantDims = Sets.difference((Set)dimIdsFromRecord, dimIdsFromDb);
            Sets.SetView lackDims = Sets.difference(dimIdsFromDb, (Set)dimIdsFromRecord);
            if (!CollectionUtils.isNotEmpty((Collection)redundantDims) && !CollectionUtils.isNotEmpty((Collection)lackDims)) continue;
            Set dimNamesFromDb = dimIdsFromDb.stream().map(id -> (String)dimNameMap.get(id)).collect(Collectors.toSet());
            String needDimName = String.join((CharSequence)ResManager.loadKDString((String)";", (String)"PermInitFinishValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dimNamesFromDb);
            String errorMsg5 = ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u53ea\u9700\u8bbe\u7f6e\u201c%s\u201d\uff0c\u65e0\u9700\u8bbe\u7f6e\u5176\u4ed6\u89d2\u8272\u7ef4\u5ea6", (String)"PermInitFinishValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{needDimName});
            userRoleEntry.set("dim_errormsg", (Object)errorMsg5);
            userRoleCheckResultMap.put(checkResultKey, "fail");
            ++errorNum;
        }
        return errorNum;
    }

    private boolean getNotExtDv(List<Triple<Long, String, Long>> triples, String number, Long structProId) {
        for (Triple<Long, String, Long> triple : triples) {
            if ((!structProId.equals(triple.getLeft()) || !number.equals(String.valueOf(triple.getRight()))) && (structProId.equals(1010L) || !((Long)triple.getLeft()).equals(1010L) || !number.equals(String.valueOf(triple.getRight())))) continue;
            return true;
        }
        return false;
    }

    private int checkDataRuleSheet(DynamicObjectCollection userDataRuleEntryColl, Map<String, String> userRoleCheckResultMap, Map<String, List<RoleFuncInfo>> roleFuncMap, Map<Long, DynamicObject> dataRuleMap) {
        int errorNum = 0;
        String separator = ResManager.loadKDString((String)";", (String)"PermInitFinishValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        for (DynamicObject userDataRuleEntry : userDataRuleEntryColl) {
            boolean dataRuleEnable;
            DynamicObject dataRuleDyna;
            userDataRuleEntry.set("dr_errormsg", (Object)" ");
            String roleId = userDataRuleEntry.getString("dr_role.id");
            String appId = userDataRuleEntry.getString("dr_app.id");
            String entityNum = userDataRuleEntry.getString("dr_entitytype.number");
            String userRoleKey = PermInitServiceHelper.joinToKey(userDataRuleEntry.getLong("dr_user.id"), userDataRuleEntry.getLong("dr_fileorg.id"), roleId);
            if (this.isUserRoleCheckFail(userRoleCheckResultMap, userRoleKey)) {
                String errorMsg = ResManager.loadKDString((String)"\u201c\u7528\u6237\u89d2\u8272\u201d\u4e0d\u5b58\u5728\u7528\u6237\u89d2\u8272\u8bb0\u5f55\uff0c\u6216\u8005\u201c\u7528\u6237\u89d2\u8272\u201d\u7684\u6570\u636e\u6821\u9a8c\u5931\u8d25", (String)"PermInitFinishValidateService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                userDataRuleEntry.set("dr_errormsg", (Object)errorMsg);
                ++errorNum;
                continue;
            }
            List<RoleFuncInfo> roleFuncInfos = roleFuncMap.get(roleId);
            ArrayList errorStrList = Lists.newArrayListWithExpectedSize((int)10);
            if (!this.roleFuncHasApp(roleFuncInfos, appId)) {
                errorStrList.add(ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u5e94\u7528\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (!this.roleFuncHasEntity(roleFuncInfos, appId, entityNum)) {
                errorStrList.add(ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u4e1a\u52a1\u5bf9\u8c61\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if ((dataRuleDyna = dataRuleMap.get(userDataRuleEntry.getLong("dr_datarule.id"))) == null) {
                errorStrList.add(ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)errorStrList)) {
                userDataRuleEntry.set("dr_errormsg", (Object)String.join((CharSequence)separator, errorStrList));
                ++errorNum;
                continue;
            }
            if (Objects.nonNull(dataRuleDyna) && !(dataRuleEnable = dataRuleDyna.getBoolean("enable"))) {
                String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u89c4\u5219", (String)"PermInitFinishValidateService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                userDataRuleEntry.set("dr_errormsg", (Object)errorMsg);
                ++errorNum;
                continue;
            }
            DynamicObjectCollection permItemColl = userDataRuleEntry.getDynamicObjectCollection("dr_permitemmulti");
            List<String> permItemList = permItemColl.stream().map(dyna -> dyna.getString("fbasedataid_id")).collect(Collectors.toList());
            List<String> notPermItemIdList = this.roleNotPermItemList(roleFuncInfos, appId, entityNum, permItemList);
            if (!CollectionUtils.isNotEmpty(notPermItemIdList)) continue;
            List<String> notPermItemNameList = this.getPermItemName(permItemColl, notPermItemIdList);
            String nameStr = String.join((CharSequence)ResManager.loadKDString((String)";", (String)"PermInitFinishValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]), notPermItemNameList);
            String errorMsg = ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u4e1a\u52a1\u5bf9\u8c61\u7684\u201c%s\u6743\u9650\u9879\u201d", (String)"PermInitFinishValidateService_6", (String)"hrmp-hrcs-business", (Object[])new Object[]{nameStr});
            userDataRuleEntry.set("dr_errormsg", (Object)errorMsg);
            ++errorNum;
        }
        return errorNum;
    }

    private int checkBdDataRuleSheet(DynamicObjectCollection userBdEntryColl, Map<String, String> userRoleCheckResultMap, Map<String, List<RoleFuncInfo>> roleFuncMap, Map<Long, DynamicObject> dataRuleMap) {
        int errorNum = 0;
        String separator = ResManager.loadKDString((String)";", (String)"PermInitFinishValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        for (DynamicObject userBdDataRuleEntry : userBdEntryColl) {
            boolean dataRuleEnable;
            DynamicObject dataRuleDyna;
            userBdDataRuleEntry.set("bd_errormsg", (Object)" ");
            String roleId = userBdDataRuleEntry.getString("bd_role.id");
            String appId = userBdDataRuleEntry.getString("bd_app.id");
            String entityNum = userBdDataRuleEntry.getString("bd_entitytype.number");
            String userRoleKey = PermInitServiceHelper.joinToKey(userBdDataRuleEntry.getLong("bd_user.id"), userBdDataRuleEntry.getLong("bd_fileorg.id"), roleId);
            if (this.isUserRoleCheckFail(userRoleCheckResultMap, userRoleKey)) {
                String errorMsg = ResManager.loadKDString((String)"\u201c\u7528\u6237\u89d2\u8272\u201d\u4e0d\u5b58\u5728\u7528\u6237\u89d2\u8272\u8bb0\u5f55\uff0c\u6216\u8005\u201c\u7528\u6237\u89d2\u8272\u201d\u7684\u6570\u636e\u6821\u9a8c\u5931\u8d25", (String)"PermInitFinishValidateService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                userBdDataRuleEntry.set("bd_errormsg", (Object)errorMsg);
                ++errorNum;
                continue;
            }
            List<RoleFuncInfo> roleFuncInfos = roleFuncMap.get(roleId);
            ArrayList errorStrList = Lists.newArrayListWithExpectedSize((int)10);
            if (!this.roleFuncHasApp(roleFuncInfos, appId)) {
                errorStrList.add(ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u5e94\u7528\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (!this.roleFuncHasEntity(roleFuncInfos, appId, entityNum)) {
                errorStrList.add(ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u4e1a\u52a1\u5bf9\u8c61\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if ((dataRuleDyna = dataRuleMap.get(userBdDataRuleEntry.getLong("bd_datarule.id"))) == null) {
                errorStrList.add(ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)errorStrList)) {
                userBdDataRuleEntry.set("bd_errormsg", (Object)String.join((CharSequence)separator, errorStrList));
                ++errorNum;
                continue;
            }
            if (!Objects.nonNull(dataRuleDyna) || (dataRuleEnable = dataRuleDyna.getBoolean("enable"))) continue;
            String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u89c4\u5219", (String)"PermInitFinishValidateService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            userBdDataRuleEntry.set("bd_errormsg", (Object)errorMsg);
            ++errorNum;
        }
        return errorNum;
    }

    private int checkFieldSheet(DynamicObjectCollection userFieldEntryColl, Map<String, String> userRoleCheckResultMap, Map<String, List<RoleFuncInfo>> roleFuncMap) {
        int errorNum = 0;
        String separator = ResManager.loadKDString((String)";", (String)"PermInitFinishValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        for (DynamicObject userFieldEntry : userFieldEntryColl) {
            userFieldEntry.set("field_errormsg", (Object)" ");
            String roleId = userFieldEntry.getString("field_role.id");
            String appId = userFieldEntry.getString("field_app.id");
            String entityNum = userFieldEntry.getString("field_entitytype.number");
            String userRoleKey = PermInitServiceHelper.joinToKey(userFieldEntry.getLong("field_user.id"), userFieldEntry.getLong("field_fileorg.id"), roleId);
            if (this.isUserRoleCheckFail(userRoleCheckResultMap, userRoleKey)) {
                String errorMsg = ResManager.loadKDString((String)"\u201c\u7528\u6237\u89d2\u8272\u201d\u4e0d\u5b58\u5728\u7528\u6237\u89d2\u8272\u8bb0\u5f55\uff0c\u6216\u8005\u201c\u7528\u6237\u89d2\u8272\u201d\u7684\u6570\u636e\u6821\u9a8c\u5931\u8d25", (String)"PermInitFinishValidateService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                userFieldEntry.set("field_errormsg", (Object)errorMsg);
                ++errorNum;
                continue;
            }
            List<RoleFuncInfo> roleFuncInfos = roleFuncMap.get(roleId);
            ArrayList errorStrList = Lists.newArrayListWithExpectedSize((int)10);
            if (!this.roleFuncHasApp(roleFuncInfos, appId)) {
                errorStrList.add(ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u5e94\u7528\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (!this.roleFuncHasEntity(roleFuncInfos, appId, entityNum)) {
                errorStrList.add(ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u4e1a\u52a1\u5bf9\u8c61\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitFinishValidateService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)errorStrList)) continue;
            userFieldEntry.set("field_errormsg", (Object)String.join((CharSequence)separator, errorStrList));
            ++errorNum;
        }
        return errorNum;
    }

    private boolean isUserRoleCheckFail(Map<String, String> userRoleCheckResultMap, String userRoleKey) {
        String userRoleCheckResult = userRoleCheckResultMap.get(userRoleKey);
        return userRoleCheckResult != null && HRStringUtils.equals((String)userRoleCheckResult, (String)"fail");
    }

    private Set<Long> nullGuard(Set<Long> list) {
        if (list == null) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        return list;
    }

    private Map<String, Set<Long>> collectRoleBucaFromRecord(DynamicObjectCollection userDimEntryColl) {
        HashMap roleBucaFuncMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject userDimEntry : userDimEntryColl) {
            String roleId = userDimEntry.getString("dim_role.id");
            Set bucaList = (Set)roleBucaFuncMap.get(roleId);
            if (bucaList == null) {
                bucaList = Sets.newHashSetWithExpectedSize((int)16);
                roleBucaFuncMap.put(roleId, bucaList);
            }
            bucaList.add(userDimEntry.getLong("dim_bucafunc.id"));
        }
        return roleBucaFuncMap;
    }

    private List<String> getPermItemName(DynamicObjectCollection permItemColl, List<String> notPermItemIdList) {
        ArrayList notPermItemNameList = Lists.newArrayListWithExpectedSize((int)16);
        block0: for (String permItemId : notPermItemIdList) {
            for (DynamicObject dyna : permItemColl) {
                DynamicObject permItemDyna = dyna.getDynamicObject("fbasedataid");
                if (!HRStringUtils.equals((String)permItemDyna.getString("id"), (String)permItemId)) continue;
                notPermItemNameList.add(permItemDyna.getString("name"));
                continue block0;
            }
        }
        return notPermItemNameList;
    }

    private boolean roleFuncHasApp(List<RoleFuncInfo> roleFuncInfos, String appId) {
        for (RoleFuncInfo roleFuncInfo : roleFuncInfos) {
            if (!HRStringUtils.equals((String)roleFuncInfo.getAppId(), (String)appId)) continue;
            return true;
        }
        return false;
    }

    private boolean roleFuncHasEntity(List<RoleFuncInfo> roleFuncInfos, String appId, String entityNum) {
        for (RoleFuncInfo roleFuncInfo : roleFuncInfos) {
            if (!HRStringUtils.equals((String)roleFuncInfo.getAppId(), (String)appId) || !HRStringUtils.equals((String)roleFuncInfo.getEntityNum(), (String)entityNum)) continue;
            return true;
        }
        return false;
    }

    private List<String> roleNotPermItemList(List<RoleFuncInfo> roleFuncInfos, String appId, String entityNum, List<String> permItemIds) {
        ArrayList notPermItemList = Lists.newArrayListWithExpectedSize((int)16);
        for (String permItemId : permItemIds) {
            if (this.roleFuncHasPermItem(roleFuncInfos, appId, entityNum, permItemId)) continue;
            notPermItemList.add(permItemId);
        }
        return notPermItemList;
    }

    private boolean roleFuncHasPermItem(List<RoleFuncInfo> roleFuncInfos, String appId, String entityNum, String permItemId) {
        for (RoleFuncInfo roleFuncInfo : roleFuncInfos) {
            if (!HRStringUtils.equals((String)roleFuncInfo.getAppId(), (String)appId) || !HRStringUtils.equals((String)roleFuncInfo.getEntityNum(), (String)entityNum) || !HRStringUtils.equals((String)roleFuncInfo.getPermItemId(), (String)permItemId)) continue;
            return true;
        }
        return false;
    }

    private Set<String> collectRole(DynamicObjectCollection userDataRuleEntryColl, DynamicObjectCollection userBdEntryColl, DynamicObjectCollection userFieldEntryColl) {
        HashSet roleIds = Sets.newHashSetWithExpectedSize((int)16);
        userDataRuleEntryColl.forEach(dyna -> roleIds.add(dyna.getString("dr_role.id")));
        userBdEntryColl.forEach(dyna -> roleIds.add(dyna.getString("bd_role.id")));
        userFieldEntryColl.forEach(dyna -> roleIds.add(dyna.getString("field_role.id")));
        return roleIds;
    }

    private Set<Long> collectDataRule(DynamicObjectCollection userDataRuleEntryColl, DynamicObjectCollection userBdEntryColl) {
        HashSet dataRuleIds = Sets.newHashSetWithExpectedSize((int)16);
        userDataRuleEntryColl.forEach(dyna -> dataRuleIds.add(dyna.getLong("dr_datarule.id")));
        userBdEntryColl.forEach(dyna -> dataRuleIds.add(dyna.getLong("bd_datarule.id")));
        return dataRuleIds;
    }

    private Pair<Map<Long, List<String>>, Map<String, List<String>>> collectDimVals(DynamicObject userRoleEntry, Map<Long, List<Long>> dynacondMap, Map<String, List<Long>> orgTeamDynacondMap) {
        HashMap allDimValMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap allDimStructProjectMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection dimValSubEntryColl = userRoleEntry.getDynamicObjectCollection("userdimvalueentry");
        for (DynamicObject dimValDyna : dimValSubEntryColl) {
            List dimValList;
            String otDimId;
            Long structProjectId;
            Long dimensionId;
            String dim_valtype = dimValDyna.getString("dim_valtype");
            if (HRStringUtils.equals((String)"2", (String)dim_valtype)) {
                dimensionId = dimValDyna.getLong("dim_dimension.id");
                structProjectId = dimValDyna.getLong("dim_structproject.id");
                otDimId = "";
                if (structProjectId != null && structProjectId != 0L) {
                    otDimId = dimensionId + "#" + structProjectId;
                    ArrayList otDynaCondIdList = orgTeamDynacondMap.get(otDimId);
                    if (otDynaCondIdList == null) {
                        otDynaCondIdList = Lists.newArrayListWithExpectedSize((int)16);
                        orgTeamDynacondMap.put(otDimId, otDynaCondIdList);
                    }
                    otDynaCondIdList.add(dimValDyna.getLong("dim_dynacond.id"));
                    continue;
                }
                ArrayList dynaCondIdList = dynacondMap.get(dimensionId);
                if (dynaCondIdList == null) {
                    dynaCondIdList = Lists.newArrayListWithExpectedSize((int)16);
                    dynacondMap.put(dimensionId, dynaCondIdList);
                }
                dynaCondIdList.add(dimValDyna.getLong("dim_dynacond.id"));
                continue;
            }
            if (dimValDyna.getBoolean("dim_isall")) continue;
            dimensionId = dimValDyna.getLong("dim_dimension.id");
            structProjectId = dimValDyna.getLong("dim_structproject.id");
            otDimId = "";
            if (structProjectId != null && structProjectId != 0L) {
                otDimId = dimensionId + "#" + structProjectId;
            }
            if ((dimValList = (List)allDimValMap.get(dimensionId)) == null) {
                dimValList = Lists.newArrayListWithExpectedSize((int)16);
                allDimValMap.put(dimensionId, dimValList);
            }
            if (HRStringUtils.isNotEmpty((String)otDimId)) {
                List otDimValList = (List)allDimStructProjectMap.get(otDimId);
                if (otDimValList == null) {
                    otDimValList = Lists.newArrayListWithExpectedSize((int)16);
                    allDimStructProjectMap.put(otDimId, otDimValList);
                }
                otDimValList.add(dimValDyna.getString("dim_dimval"));
            }
            dimValList.add(dimValDyna.getString("dim_dimval"));
        }
        return Pair.of((Object)allDimValMap, (Object)allDimStructProjectMap);
    }
}

