/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.helper.EntityPropParser;
import kd.hr.hrcs.bussiness.service.perm.init.PermInitImportService;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleInitValidateService;
import kd.hr.hrcs.bussiness.service.perm.init.PermTemplateFieldMap;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.common.model.perminit.ImportUserBdDataRuleModel;
import kd.hr.hrcs.common.model.perminit.ImportUserDataRuleModel;
import kd.hr.hrcs.common.model.perminit.ImportUserDimModel;
import kd.hr.hrcs.common.model.perminit.ImportUserFieldModel;
import kd.hr.hrcs.common.model.perminit.ObjStatus;
import kd.hr.hrcs.common.model.perminit.PermInitRecord;
import kd.hr.hrcs.common.model.perminit.RecordCheckInfo;
import kd.hr.hrcs.common.model.perminit.RoleInfoData;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@ExcludeFromJacocoGeneratedReport
public class PermInitImportValidateService {
    private static final Log LOGGER = LogFactory.getLog(PermInitImportValidateService.class);
    public Map<String, Long> userIdMap = Maps.newHashMapWithExpectedSize((int)16);
    public Map<String, String> userIdStatusMap = Maps.newHashMapWithExpectedSize((int)16);
    public Map<String, String> roleNumIdMap = Maps.newHashMapWithExpectedSize((int)16);
    public Map<String, String> roleNumStatusMap = Maps.newHashMapWithExpectedSize((int)16);
    public Map<String, Long> orgNumIdMap = Maps.newHashMapWithExpectedSize((int)16);
    public Map<String, String> orgNumStatusMap = Maps.newHashMapWithExpectedSize((int)16);
    public Map<Long, Set<String>> buOrgMap = Maps.newHashMapWithExpectedSize((int)16);
    public Map<String, String> dataRuleMap = Maps.newHashMapWithExpectedSize((int)16);
    public Map<String, Long> buViewIdMap = Maps.newHashMapWithExpectedSize((int)16);
    private int totalCount = 0;
    private int finishCount = 0;
    private IFormView view;
    public RecordCheckInfo recordCheckInfo;
    public PermInitImportService permInitImportService = new PermInitImportService();
    private static final String TERMINATOR = "terminator";
    private static final String CURRENT_STATUS = "currentStatus";
    private Map<String, ImportLogger> importLoggerMap;
    private Map<String, Integer> countMap;

    public PermInitImportValidateService(Map<String, ImportLogger> importLoggerMap, Map<String, Integer> countMap, IFormView view) {
        this.importLoggerMap = importLoggerMap;
        this.countMap = countMap;
        this.totalCount = this.getTotal();
        this.view = view;
    }

    public PermInitImportValidateService(IFormView view) {
        this.view = view;
    }

    public boolean isTerminator() {
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        String status = cache.get(CURRENT_STATUS);
        return HRStringUtils.isNotEmpty((String)status) && HRStringUtils.equals((String)TERMINATOR, (String)status);
    }

    public void feedbackProgress(boolean complete, String errorUrl, String allErrUrl) {
        int oldProgress;
        JSONObject map;
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        String cachedLogStr = cache.get("Cached_Import_Logger");
        JSONObject jSONObject = map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
        if (this.totalCount == 0) {
            return;
        }
        int progress = this.finishCount * 100 / this.totalCount;
        if (progress > map.getIntValue("progress") && progress <= 10) {
            progress = 25;
        }
        if (progress >= 99 && !complete) {
            progress = 90;
        }
        if (progress >= 99) {
            progress = 100;
        }
        if (complete) {
            progress = 100;
        }
        if (progress > (oldProgress = map.getIntValue("progress"))) {
            map.put("progress", (Object)progress);
        }
        map.put("total", (Object)this.totalCount);
        map.put("succeed", (Object)0);
        map.put("failed", (Object)0);
        map.put("errFileUrl", (Object)errorUrl);
        map.put("allErrFileUrl", (Object)allErrUrl);
        map.put("complete", (Object)complete);
        map.put("userEndTime", (Object)String.valueOf(System.currentTimeMillis()));
        if (complete) {
            int userRoleFailed = this.importLoggerMap.get("importUserR").getLogCache().size();
            int userRoleSucceed = this.countMap.get("importUserR") - userRoleFailed;
            int dataRuleFailed = this.importLoggerMap.get("importUserDr").getLogCache().size();
            int dataRuleSucceed = this.countMap.get("importUserDr") - dataRuleFailed;
            int bdRuleFailed = this.importLoggerMap.get("importUserBD").getLogCache().size();
            int bdRuleSucceed = this.countMap.get("importUserBD") - bdRuleFailed;
            int userFieldFailed = this.importLoggerMap.get("importUserFp").getLogCache().size();
            int userFieldSucceed = this.countMap.get("importUserFp") - userFieldFailed;
            map.put("importUserR", (Object)userRoleSucceed);
            map.put("importUserDr", (Object)dataRuleSucceed);
            map.put("importUserBD", (Object)bdRuleSucceed);
            map.put("importUserFp", (Object)userFieldSucceed);
            map.put("importUserRF", (Object)userRoleFailed);
            map.put("importUserDrF", (Object)dataRuleFailed);
            map.put("importUserBDF", (Object)bdRuleFailed);
            map.put("importUserFpF", (Object)userFieldFailed);
        }
        cachedLogStr = JSON.toJSONString((Object)map);
        cache.put("Cached_Import_Logger", cachedLogStr);
        cache.saveChanges();
    }

    private int getTotal() {
        int total = 0;
        for (Map.Entry<String, Integer> entry : this.countMap.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    public void initExcelData(PermInitRecord permInitRecord, List<ImportBillData> rowDataList) throws ParseException {
        ArrayList userDimModelList = Lists.newArrayListWithExpectedSize((int)16);
        permInitRecord.setUserDimModelList((List)userDimModelList);
        this.initUserInfo(rowDataList);
        HashSet userRoleOrgSet = Sets.newHashSetWithExpectedSize((int)rowDataList.size());
        HashSet roleSet = Sets.newHashSetWithExpectedSize((int)rowDataList.size());
        HashSet userCodeSet = Sets.newHashSetWithExpectedSize((int)rowDataList.size());
        HashMap roleEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap roleBdEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap userRoleOrgDataScopeMap = Maps.newHashMapWithExpectedSize((int)16);
        List<ImportBillData> userRoleBillDataList = rowDataList.stream().filter(it -> HRStringUtils.equals((String)it.getData().getString("sheetKey"), (String)"importUserR")).collect(Collectors.toList());
        HashMap<String, List<String>> allDimValList = new HashMap<String, List<String>>(16);
        HashMap<Integer, Map<String, List<String>>> dimValList = new HashMap<Integer, Map<String, List<String>>>(10);
        HashMap<String, List<String>> buOrgMap = new HashMap<String, List<String>>(16);
        HashMap<String, Set<String>> roleBuInfo = new HashMap<String, Set<String>>(16);
        HashMap<String, Set<String>> roleValidTimeInfo = new HashMap<String, Set<String>>(16);
        HashMap<String, Set<String>> roleOrgInfo = new HashMap<String, Set<String>>(16);
        this.recordCheckInfo = new RecordCheckInfo();
        for (ImportBillData billData : rowDataList) {
            String entityNum;
            String roleNum;
            JSONObject data = billData.getData();
            String sheetKey = data.getString("sheetKey");
            if ("importUserR".equals(sheetKey)) {
                roleNum = data.getString(PermTemplateFieldMap.UserRole.role_num.getKey());
                roleSet.add(roleNum);
                String userCode = data.getString(PermTemplateFieldMap.UserRole.user_num.getKey());
                userCodeSet.add(userCode);
                continue;
            }
            if ("importUserBD".equals(sheetKey)) {
                String bdPro;
                roleNum = data.getString(PermTemplateFieldMap.UserRole.role_num.getKey());
                entityNum = data.getString(PermTemplateFieldMap.UserDr.entity_num.getKey());
                String bdEntity = this.permInitImportService.getBdEntity(entityNum, bdPro = data.getString(PermTemplateFieldMap.UserBD.bd_prop.getKey()));
                if (HRStringUtils.isNotEmpty((String)bdEntity)) {
                    roleEntityMap.computeIfAbsent(roleNum, key -> new HashSet(16)).add(bdEntity);
                }
                if (!HRStringUtils.isNotEmpty((String)entityNum)) continue;
                roleBdEntityMap.computeIfAbsent(roleNum, key -> new HashSet(16)).add(entityNum);
                continue;
            }
            if (!"importUserDr".equals(sheetKey) && !"importUserFp".equals(sheetKey)) continue;
            roleNum = data.getString(PermTemplateFieldMap.UserRole.role_num.getKey());
            entityNum = data.getString(PermTemplateFieldMap.UserDr.entity_num.getKey());
            roleEntityMap.computeIfAbsent(roleNum, key -> new HashSet(16)).add(entityNum);
        }
        Set<String> rangeInconsistencyRowKeys = this.countRangeInconsistencyUserRole(userRoleBillDataList);
        Map<String, RoleInfoData> roleExcelData = this.permInitImportService.getRoleInitInfo(roleSet, this.roleNumIdMap, roleEntityMap, roleBdEntityMap);
        this.recordCheckInfo.setRoleExcelData(roleExcelData);
        this.recordCheckInfo.setUserPermFile(this.permInitImportService.getUserPermFile(userCodeSet));
        HashMap dimValListContainsSubTemp = Maps.newHashMapWithExpectedSize((int)16);
        this.analysisURDimValueInfo(userRoleBillDataList, dimValList, allDimValList, buOrgMap, roleBuInfo, roleValidTimeInfo, roleOrgInfo, dimValListContainsSubTemp);
        HashMap oTDimValueMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, Map<String, String>> allDimValues = PermInitServiceHelper.structDimInfoByNumber(allDimValList, oTDimValueMap);
        Map<Long, String> enmuMap = this.initEnum(allDimValList);
        Map<String, Set<String>> buOrgInfo = this.queryBuOrgRange(buOrgMap);
        HashSet dimIds = new HashSet(16);
        roleExcelData.values().stream().filter(it -> MapUtils.isNotEmpty((Map)it.getDimValuesMap())).forEach(roleInfoData -> roleInfoData.getDimValuesMap().values().forEach(dimVals -> dimVals.forEach(dv -> dimIds.add(dv.getDimId()))));
        Map<String, String> dimIdNameInfo = this.queryDimNames();
        dimIdNameInfo.put("buorg", ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4", (String)"PermInitImportValidateService_61", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        Map<String, Set<String>> lackBuInfos = this.checkRoleLackBu(roleBuInfo);
        Map<String, List<Long>> roleBusMap = PermInitServiceHelper.queryRoleBus(Sets.newConcurrentHashSet(this.roleNumIdMap.values()));
        Map<String, List<String>> dimDynaRangeMap = PermInitServiceHelper.getDimDynaRangeMap(allDimValList.keySet());
        List<String> allDynaCondNumbers = PermInitServiceHelper.getAllDynaCondNumbers();
        Map<String, Long> allDynaCondMap = PermInitServiceHelper.getAllDynaCondMap();
        Map<String, Pair<String, String>> dimInfoMap = PermInitServiceHelper.getDimTypeMap(allDimValList.keySet());
        HashSet rowKeys = Sets.newHashSetWithExpectedSize((int)rowDataList.size());
        for (ImportBillData billData : rowDataList) {
            JSONObject data = billData.getData();
            String sheetKey = data.getString("sheetKey");
            if (this.isTerminator()) break;
            if (!"importUserR".equals(sheetKey)) continue;
            if (this.checkUserRole(data, userDimModelList, rowKeys, rangeInconsistencyRowKeys, allDimValues, dimValList, dimIdNameInfo, buOrgInfo, lackBuInfos, roleValidTimeInfo, roleOrgInfo, oTDimValueMap, enmuMap, roleBusMap, dimValListContainsSubTemp, dimInfoMap, dimDynaRangeMap, allDynaCondNumbers, allDynaCondMap)) {
                String roleNum = data.getString(PermTemplateFieldMap.UserRole.role_num.getKey());
                String userCode = data.getString(PermTemplateFieldMap.UserRole.user_num.getKey());
                String orgCode = data.getString(PermTemplateFieldMap.UserRole.org_num.getKey());
                String key2 = userCode + "#" + orgCode + "#" + roleNum;
                userRoleOrgSet.add(key2);
                String dataScope = data.getString(PermTemplateFieldMap.UserRole.data_scope.getKey());
                userRoleOrgDataScopeMap.put(key2, PermTemplateFieldMap.getCustom(dataScope));
            }
            this.countProgress();
        }
        this.recordCheckInfo.setUserRoleOrgSet((Set)userRoleOrgSet);
        this.recordCheckInfo.setUserRoleOrgDataScopeMap((Map)userRoleOrgDataScopeMap);
    }

    private Map<Long, String> initEnum(Map<String, List<String>> allDimValList) {
        DynamicObject[] dimArr;
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        Set<String> dimIdStrs = allDimValList.keySet();
        Set dimIdSet = dimIdStrs.stream().filter(it -> !it.contains("#")).map(Long::valueOf).collect(Collectors.toSet());
        for (DynamicObject dim : dimArr = dimHelper.query("id,datasource", new QFilter[]{new QFilter("id", "in", dimIdSet)})) {
            Long dimId = dim.getLong("id");
            String datasource = dim.getString("datasource");
            if (!HRStringUtils.equals((String)"enum", (String)datasource)) continue;
            result.put(dimId, datasource);
        }
        return result;
    }

    private Map<String, String> queryDimNames() {
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        return dimHelper.queryOriginalCollection("id,name", new QFilter[0]).stream().collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("name"), (newVal, oldVal) -> newVal));
    }

    private Map<String, Set<String>> checkRoleLackBu(Map<String, Set<String>> roleBuInfo) {
        Map roleExcelData = this.recordCheckInfo.getRoleExcelData();
        HashMap<String, Set<String>> lackBuInfos = new HashMap<String, Set<String>>(roleBuInfo.size());
        for (Map.Entry<String, Set<String>> entry : roleBuInfo.entrySet()) {
            String key = entry.getKey();
            String roleNum = key.split("#")[2];
            Set<String> fillInBus = entry.getValue();
            RoleInfoData roleInfoData = (RoleInfoData)roleExcelData.get(roleNum);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(fillInBus) || ObjectUtils.isEmpty((Object)roleInfoData) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)roleInfoData.getRoleBuType())) continue;
            List roleBuTypes = roleInfoData.getRoleBuType();
            LOGGER.info("PermInitImportPlugin: fillInBus = {}, roleBuTypes = {}", fillInBus, (Object)roleBuTypes);
            fillInBus.removeIf(HRStringUtils::isEmpty);
            roleBuTypes.removeIf(HRStringUtils::isEmpty);
            if (!CollectionUtils.isNotEmpty(fillInBus) || !CollectionUtils.isNotEmpty((Collection)roleBuTypes) || fillInBus.containsAll(roleBuTypes)) continue;
            HashSet lackBus = Sets.newHashSetWithExpectedSize((int)16);
            lackBus.addAll(roleBuTypes);
            lackBus.removeAll(fillInBus);
            lackBuInfos.put(key, lackBus);
        }
        return lackBuInfos;
    }

    private Map<String, Set<String>> queryBuOrgRange(Map<String, List<String>> buOrgMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter finalFilter = null;
        for (Map.Entry<String, List<String>> entry : buOrgMap.entrySet()) {
            Long viewId = this.buViewIdMap.get(entry.getKey());
            if (null == viewId) continue;
            QFilter viewQf = new QFilter("view", "=", (Object)viewId);
            QFilter orgQf = new QFilter("org.number", "in", entry.getValue());
            QFilter and = viewQf.and(orgQf);
            if (finalFilter == null) {
                finalFilter = and;
                continue;
            }
            finalFilter.or(and);
        }
        DynamicObject[] query = serviceHelper.queryOriginalArray("id,org.number,view.name", new QFilter[]{finalFilter});
        HashMap<String, Set<String>> buOrgInfo = new HashMap<String, Set<String>>(buOrgMap.size());
        for (DynamicObject orgStruct : query) {
            String view = orgStruct.getString("view.name");
            String org = orgStruct.getString("org.number");
            Set orgNums = buOrgInfo.computeIfAbsent(view, key -> Sets.newHashSetWithExpectedSize((int)16));
            orgNums.add(org);
        }
        return buOrgInfo;
    }

    private void analysisURDimValueInfo(List<ImportBillData> userRoleBillDataList, Map<Integer, Map<String, List<String>>> dimValList, Map<String, List<String>> allDimValList, Map<String, List<String>> buOrgMap, Map<String, Set<String>> roleBuInfo, Map<String, Set<String>> roleValidTimeInfo, Map<String, Set<String>> roleOrgInfo, Map<Integer, Map<String, Map<String, String>>> dimValListContainsSubTemp) {
        HashMap<String, List> allDimValListTemp = new HashMap<String, List>(16);
        HashMap dimValListTemp = new HashMap(10);
        HashMap<String, List> buOrgMapTemp = new HashMap<String, List>(16);
        HashMap<String, Set> roleBuInfoTemp = new HashMap<String, Set>(16);
        HashMap<String, Set> roleValidTimeInfoTemp = new HashMap<String, Set>(16);
        HashMap<String, Set> roleOrgInfoTemp = new HashMap<String, Set>(16);
        for (ImportBillData importBillData : userRoleBillDataList) {
            JSONObject data = importBillData.getData();
            int rowNum = data.getInteger("rowNum");
            String userNum = data.getString(PermTemplateFieldMap.UserRole.user_num.getKey());
            String roleNum = data.getString(PermTemplateFieldMap.UserRole.role_num.getKey());
            String orgNum = data.getString(PermTemplateFieldMap.UserRole.org_num.getKey());
            String startTimeStr = data.getString(PermTemplateFieldMap.UserRole.start_time.getKey());
            String endTimeStr = data.getString(PermTemplateFieldMap.UserRole.end_time.getKey());
            String userOrgRoleKey = userNum + "#" + orgNum + "#" + roleNum;
            String hasDim = data.getString("hasDim");
            if ("Y".equals(hasDim)) {
                List dims = (List)data.get((Object)"dim");
                HashMap<String, ArrayList> dimValTemp = new HashMap<String, ArrayList>(dims.size());
                HashMap<String, Map<String, String>> dimValContainsSubTemp = new HashMap<String, Map<String, String>>(dims.size());
                for (Map dimInfo : dims) {
                    String ot = (String)dimInfo.get("ot");
                    String dimNum = (String)dimInfo.get("code");
                    String dimId = String.valueOf(dimInfo.get("id"));
                    if (HRStringUtils.equals((String)ot, (String)"Y")) {
                        dimNum = (String)dimInfo.get("oldCode");
                        dimId = dimId + "#" + dimInfo.get("type");
                    }
                    String dimValStr = data.getString(dimNum);
                    Set<String> dimValues = this.dealValueCode(dimValStr);
                    Map<String, String> orgRangeMapContainsSub = PermRoleInitValidateService.dealValueCodeContainsSub(dimValStr);
                    List allDimVals = allDimValListTemp.computeIfAbsent(dimId, key -> new ArrayList(10));
                    allDimVals.addAll(dimValues);
                    dimValTemp.put(dimId, Lists.newArrayList(dimValues));
                    dimValContainsSubTemp.put(dimId, orgRangeMapContainsSub);
                }
                dimValListTemp.put(rowNum, dimValTemp);
                dimValListContainsSubTemp.put(rowNum, dimValContainsSubTemp);
            }
            String buType = data.getString("butype");
            String orgStr = data.getString("buorg");
            if (HRStringUtils.isNotEmpty((String)buType) && HRStringUtils.isNotEmpty((String)orgStr)) {
                Set<String> rowOrgNums = this.dealValueCode(orgStr);
                List orgNums = buOrgMapTemp.computeIfAbsent(buType, key -> Lists.newArrayListWithCapacity((int)10));
                orgNums.addAll(rowOrgNums);
                ArrayList orgList = Lists.newArrayList(rowOrgNums);
                Collections.sort(orgList);
                String orgInfoStr = String.join((CharSequence)",", orgList);
                Set orgRowInfos = roleOrgInfoTemp.computeIfAbsent(userOrgRoleKey + "#" + buType, key -> Sets.newHashSetWithExpectedSize((int)16));
                orgRowInfos.add(orgInfoStr);
            }
            Set bus = roleBuInfoTemp.computeIfAbsent(userOrgRoleKey, key -> Sets.newHashSetWithExpectedSize((int)16));
            bus.add(buType);
            try {
                String endStr;
                String startStr;
                if (HRStringUtils.isNotEmpty((String)startTimeStr)) {
                    Date startTime = HRDateTimeUtils.parseDate((String)startTimeStr);
                    startStr = String.valueOf(startTime.getTime());
                } else {
                    startStr = "null";
                }
                if (HRStringUtils.isNotEmpty((String)endTimeStr)) {
                    Date endTime = HRDateTimeUtils.parseDate((String)endTimeStr);
                    endStr = String.valueOf(endTime.getTime());
                } else {
                    endStr = "null";
                }
                String validTimeStr = startStr + "-" + endStr;
                Set valids = roleValidTimeInfoTemp.computeIfAbsent(userOrgRoleKey, key -> Sets.newHashSetWithExpectedSize((int)16));
                valids.add(validTimeStr);
            }
            catch (ParseException exception) {
                LOGGER.error((Throwable)exception);
            }
        }
        allDimValList.putAll(allDimValListTemp);
        dimValList.putAll(dimValListTemp);
        buOrgMap.putAll(buOrgMapTemp);
        roleBuInfo.putAll(roleBuInfoTemp);
        roleOrgInfo.putAll(roleOrgInfoTemp);
        roleValidTimeInfo.putAll(roleValidTimeInfoTemp);
    }

    private Set<String> countRangeInconsistencyUserRole(List<ImportBillData> userRoleBillDataList) {
        HashMap<String, Set> rowRangeMap = new HashMap<String, Set>(userRoleBillDataList.size());
        for (ImportBillData importBillData : userRoleBillDataList) {
            JSONObject data = importBillData.getData();
            String userNum = data.getString(PermTemplateFieldMap.UserRole.user_num.getKey());
            String roleNum = data.getString(PermTemplateFieldMap.UserRole.role_num.getKey());
            String orgNum = data.getString(PermTemplateFieldMap.UserRole.org_num.getKey());
            String dataScope = data.getString(PermTemplateFieldMap.UserRole.data_scope.getKey());
            String userOrgRoleKey = userNum + "#" + orgNum + "#" + roleNum;
            Set dataScopes = rowRangeMap.computeIfAbsent(userOrgRoleKey, key -> Sets.newHashSetWithExpectedSize((int)16));
            dataScopes.add(dataScope);
        }
        Set<String> rangeInconsistencyRowKeys = rowRangeMap.entrySet().stream().filter(it -> ((Set)it.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        return rangeInconsistencyRowKeys;
    }

    public void initParams(PermInitRecord permInitRecord, List<ImportBillData> rowDataList, Long recordId) throws ParseException {
        ArrayList userDataRuleModelList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList userBdDataRuleModelList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList userFieldModelList = Lists.newArrayListWithExpectedSize((int)16);
        permInitRecord.setUserBdDataRuleModelList((List)userBdDataRuleModelList);
        permInitRecord.setUserDataRuleModelList((List)userDataRuleModelList);
        permInitRecord.setUserFieldModelList((List)userFieldModelList);
        permInitRecord.setId(recordId);
        HashSet userFieldExistProps = Sets.newHashSetWithExpectedSize((int)16);
        HashMap userFieldPropMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap drExistPerms = Maps.newHashMapWithExpectedSize((int)16);
        HashMap duplicatePermRows = Maps.newHashMapWithExpectedSize((int)16);
        HashMap bdPropRowMap = Maps.newHashMapWithExpectedSize((int)16);
        for (ImportBillData bill : rowDataList) {
            if (this.isTerminator()) break;
            JSONObject data = bill.getData();
            String sheetKey = data.getString("sheetKey");
            if ("importUserDr".equals(sheetKey)) {
                this.initUserDataRule(data, userDataRuleModelList, drExistPerms, duplicatePermRows);
                this.countProgress();
                continue;
            }
            if ("importUserBD".equals(sheetKey)) {
                this.initUserBDRule(data, userBdDataRuleModelList, bdPropRowMap);
                this.countProgress();
                continue;
            }
            if (!"importUserFp".equals(sheetKey)) continue;
            this.initUserField(bill, userFieldModelList, userFieldPropMap, userFieldExistProps, this.importLoggerMap.get("importUserFp"));
            this.countProgress();
        }
        this.signDRDuplicatePermRow(drExistPerms, duplicatePermRows);
        this.signBDDuplicateFieldRow(bdPropRowMap);
        this.signDuplicateFieldRow(userFieldPropMap, userFieldExistProps);
        this.filterErrorRowData(permInitRecord);
    }

    private void countProgress() {
        ++this.finishCount;
        this.feedbackProgress(false, null, null);
    }

    private void signBDDuplicateFieldRow(Map<String, List<Integer>> bdPropRowMap) {
        ImportLogger importLogger = this.importLoggerMap.get("importUserBD");
        for (Map.Entry<String, List<Integer>> entry : bdPropRowMap.entrySet()) {
            List<Integer> rowIndexs = entry.getValue();
            if (rowIndexs.size() <= 1) continue;
            for (Integer rowIndex : rowIndexs) {
                importLogger.fail();
                importLogger.log(rowIndex, ResManager.loadKDString((String)"\u5b57\u6bb5\u5c5e\u6027\u7684\u6570\u636e\u89c4\u5219\u65b9\u6848\u91cd\u590d", (String)"PermInitImportValidateService_26", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
        }
    }

    private void filterErrorRowData(PermInitRecord permInitRecord) {
        List userDimModelList = permInitRecord.getUserDimModelList();
        List userDataRuleModelList = permInitRecord.getUserDataRuleModelList();
        List userBdDataRuleModelList = permInitRecord.getUserBdDataRuleModelList();
        List userFieldModelList = permInitRecord.getUserFieldModelList();
        if (CollectionUtils.isNotEmpty((Collection)userDimModelList)) {
            permInitRecord.setUserDimModelList(userDimModelList.stream().filter(it -> !this.importLoggerMap.get("importUserR").getLogCache().containsKey(it.getRowNum())).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)userDataRuleModelList)) {
            permInitRecord.setUserDataRuleModelList(userDataRuleModelList.stream().filter(it -> !this.importLoggerMap.get("importUserDr").getLogCache().containsKey(it.getRowNum())).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)userBdDataRuleModelList)) {
            permInitRecord.setUserBdDataRuleModelList(userBdDataRuleModelList.stream().filter(it -> !this.importLoggerMap.get("importUserBD").getLogCache().containsKey(it.getRowNum())).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)userFieldModelList)) {
            permInitRecord.setUserFieldModelList(userFieldModelList.stream().filter(it -> !this.importLoggerMap.get("importUserFp").getLogCache().containsKey(it.getRowNum())).collect(Collectors.toList()));
        }
    }

    private void signDuplicateFieldRow(Map<String, List<Integer>> userFieldPropMap, Set<String> userFieldExistProps) {
        ImportLogger importLogger = this.importLoggerMap.get("importUserFp");
        for (String rowKey : userFieldExistProps) {
            List<Integer> rowIndexs = userFieldPropMap.get(rowKey);
            for (Integer rowIndex : rowIndexs) {
                importLogger.fail();
                importLogger.log(rowIndex, ResManager.loadKDString((String)"\u5b57\u6bb5\u5c5e\u6027\u91cd\u590d", (String)"PermInitImportValidateService_12", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
        }
    }

    private void signDRDuplicatePermRow(Map<String, Map<String, Integer>> drExistPerms, Map<String, Set<String>> duplicatePermRows) {
        ImportLogger importLogger = this.importLoggerMap.get("importUserDr");
        for (Map.Entry<String, Set<String>> entry : duplicatePermRows.entrySet()) {
            String entity = entry.getKey();
            Set<String> perms = entry.getValue();
            Map<String, Integer> permRowMap = drExistPerms.get(entity);
            for (String perm : perms) {
                Integer rowIndex = permRowMap.get(perm);
                importLogger.fail();
                importLogger.log(rowIndex, ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u201c%s\u201d\u6743\u9650\u9879\u7684\u6570\u636e\u89c4\u5219\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_23", (String)"hrmp-hrcs-business", (Object[])new Object[]{perm}));
            }
        }
    }

    public void initUserInfo(List<ImportBillData> rowDataList) {
        DynamicObjectCollection roles;
        HRBaseServiceHelper roleHelper;
        HashSet userNumSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet roleNumSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet orgNumSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet ruleNumSet = Sets.newHashSetWithExpectedSize((int)16);
        Set collect = rowDataList.stream().filter(it -> it.getData().containsValue((Object)"importUserR")).collect(Collectors.toSet());
        for (ImportBillData bill : rowDataList) {
            JSONObject dataJson = bill.getData();
            String sheetKey = dataJson.getString("sheetKey");
            JSONObject data = bill.getData();
            if ("importUserR".equals(sheetKey)) {
                userNumSet.add(data.getString(PermTemplateFieldMap.UserRole.user_num.getKey()));
                roleNumSet.add(data.getString(PermTemplateFieldMap.UserRole.role_num.getKey()));
                orgNumSet.add(data.getString(PermTemplateFieldMap.UserRole.org_num.getKey()));
                String orgCodeStr = data.getString(PermTemplateFieldMap.UserRole.bu_org.getKey());
                if (!HRStringUtils.isNotEmpty((String)orgCodeStr)) continue;
                Set<String> set = this.dealValueCode(orgCodeStr);
                orgNumSet.addAll(set);
                continue;
            }
            if (!"importUserDr".equals(sheetKey) && !"importUserBD".equals(sheetKey)) continue;
            String ruleNum = data.getString(PermTemplateFieldMap.UserBD.rule_num.getKey());
            ruleNumSet.add(ruleNum);
        }
        if (userNumSet.size() > 0) {
            HRBaseServiceHelper userHelper = new HRBaseServiceHelper("bos_user");
            DynamicObjectCollection userDys = userHelper.queryOriginalCollection("id,number,isforbidden", new QFilter[]{new QFilter("number", "in", (Object)userNumSet)});
            for (DynamicObject obj : userDys) {
                this.userIdMap.put(obj.getString("number"), obj.getLong("id"));
                this.userIdStatusMap.put(obj.getString("number"), obj.getString("isforbidden"));
            }
        }
        if (roleNumSet.size() > 0) {
            roleHelper = new HRBaseServiceHelper("perm_role");
            roles = roleHelper.queryOriginalCollection("id,number,enable", new QFilter[]{new QFilter("number", "in", (Object)roleNumSet)});
            for (DynamicObject obj : roles) {
                this.roleNumIdMap.put(obj.getString("number"), obj.getString("id"));
                this.roleNumStatusMap.put(obj.getString("number"), obj.getString("enable"));
            }
        }
        if (orgNumSet.size() > 0) {
            roleHelper = new HRBaseServiceHelper("bos_org");
            roles = roleHelper.queryOriginalCollection("id,number,enable", new QFilter[]{new QFilter("number", "in", (Object)orgNumSet)});
            for (DynamicObject obj : roles) {
                this.orgNumIdMap.put(obj.getString("number"), obj.getLong("id"));
                this.orgNumStatusMap.put(obj.getString("number"), obj.getString("enable"));
            }
            HRBaseServiceHelper orgStructHelper = new HRBaseServiceHelper("bos_org_structure");
            DynamicObjectCollection orgStructures = orgStructHelper.queryOriginalCollection("org.number,view.id", new QFilter[]{new QFilter("org.number", "in", (Object)orgNumSet)});
            for (DynamicObject orgStructure : orgStructures) {
                this.buOrgMap.computeIfAbsent(orgStructure.getLong("view.id"), key -> Sets.newHashSetWithExpectedSize((int)16)).add(orgStructure.getString("org.number"));
            }
        }
        if (ruleNumSet.size() > 0) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_datarule");
            DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("number,name", new QFilter[]{new QFilter("number", "in", (Object)ruleNumSet)});
            for (DynamicObject dy : dynamicObjects) {
                String number = dy.getString("number");
                String name = dy.getString("name");
                this.dataRuleMap.put(number, name);
            }
        }
        HRBaseServiceHelper buHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        DynamicObjectCollection budys = buHelper.queryOriginalCollection("id,name", new QFilter[]{new QFilter("issyspreset", "=", (Object)"1")});
        for (DynamicObject dy : budys) {
            String name = dy.getString("name");
            Long id = dy.getLong("id");
            this.buViewIdMap.put(name, id);
        }
    }

    public void initUserField(ImportBillData billData, List<ImportUserFieldModel> userFieldModelList, Map<String, List<Integer>> userFieldPropMap, Set<String> userFieldExistProps, ImportLogger importLogger) {
        String rowKey;
        ArrayList rowIndexs;
        JSONObject data = billData.getData();
        int rowNum = data.getInteger("rowNum");
        String userNum = data.getString(PermTemplateFieldMap.UserField.user_num.getKey());
        String roleNum = data.getString(PermTemplateFieldMap.UserField.role_num.getKey());
        String orgNum = data.getString(PermTemplateFieldMap.UserField.org_num.getKey());
        String appNum = data.getString(PermTemplateFieldMap.UserField.app_num.getKey());
        String entityNum = data.getString(PermTemplateFieldMap.UserField.entity_num.getKey());
        String fieldProp = data.getString(PermTemplateFieldMap.UserField.field_prop.getKey());
        if (!this.customRoleRangeValidate(data, rowNum, importLogger)) {
            return;
        }
        Long userId = this.userIdMap.get(userNum);
        String roleId = this.roleNumIdMap.get(roleNum);
        String userOrgRoleId = userNum + "#" + orgNum + "#" + roleNum;
        if (!this.roleLegalValidate(data, rowNum, importLogger)) {
            return;
        }
        RoleInfoData roleInfoData = (RoleInfoData)this.recordCheckInfo.getRoleExcelData().get(roleNum);
        if (roleInfoData != null) {
            Set appSet = roleInfoData.getAppSet();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)appSet) || !appSet.contains(appNum)) {
                String tip = ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u9519\u8bef\u6216\u8be5\u89d2\u8272\u65e0\u201c%s\u201d\u5e94\u7528\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_10", (String)"hrmp-hrcs-business", (Object[])new Object[]{appNum});
                importLogger.fail();
                importLogger.log(Integer.valueOf(rowNum), tip);
                return;
            }
            Set entityNums = (Set)roleInfoData.getEntityNumberMap().get(appNum);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entityNums) || !entityNums.contains(entityNum)) {
                String tip = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u9519\u8bef\uff0c\u6216\u8be5\u89d2\u8272\u65e0\u201c%1$s\u201d\u6743\u9650\u7684\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]), appNum, entityNum);
                importLogger.fail();
                importLogger.log(Integer.valueOf(rowNum), tip);
                return;
            }
            Set props = (Set)roleInfoData.getEntityFieldProMap().get(entityNum);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)props) || !props.contains(fieldProp)) {
                String tip = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u65e0\u201c%s\u201d\u5b57\u6bb5\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_60", (String)"hrmp-hrcs-business", (Object[])new Object[]{fieldProp});
                importLogger.fail();
                importLogger.log(Integer.valueOf(rowNum), tip);
                return;
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(rowIndexs = userFieldPropMap.get(rowKey = userOrgRoleId + appNum + entityNum + fieldProp))) {
            rowIndexs = Lists.newArrayList((Object[])new Integer[]{rowNum});
            userFieldPropMap.put(rowKey, rowIndexs);
        } else {
            rowIndexs.add(rowNum);
            userFieldExistProps.add(rowKey);
        }
        StringBuilder errorMsg = new StringBuilder();
        String enableVal = ResManager.loadKDString((String)"\u5141\u8bb8", (String)"PermSheetHelper_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String disableVal = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8", (String)"PermSheetHelper_58", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String view = data.getString(PermTemplateFieldMap.UserField.view.getKey());
        String edit = data.getString(PermTemplateFieldMap.UserField.edit.getKey());
        LOGGER.info("PermInitImportValidateService userField enableVal:{},disableVal:{},view:{},edit:{}", new Object[]{enableVal, disableVal, view, edit});
        if (!HRStringUtils.equals((String)view, (String)enableVal) && !HRStringUtils.equals((String)view, (String)disableVal)) {
            errorMsg.append(ResManager.loadKDString((String)"\u67e5\u770b\u5217\u3001", (String)"PermInitImportValidateService_15", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (!HRStringUtils.equals((String)edit, (String)enableVal) && !HRStringUtils.equals((String)edit, (String)disableVal)) {
            errorMsg.append(ResManager.loadKDString((String)"\u7f16\u8f91\u5217\u3001", (String)"PermInitImportValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (errorMsg.length() > 0) {
            errorMsg.deleteCharAt(errorMsg.length() - 1);
            errorMsg.append(ResManager.loadKDString((String)"\u503c\u9519\u8bef", (String)"PermInitImportValidateService_17", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            importLogger.fail();
            importLogger.log(Integer.valueOf(rowNum), errorMsg.toString());
            return;
        }
        if (HRStringUtils.equals((String)view, (String)disableVal) && HRStringUtils.equals((String)edit, (String)enableVal)) {
            importLogger.fail();
            importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u67e5\u770b\u65f6\uff0c\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91", (String)"PermInitImportValidateService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            return;
        }
        ImportUserFieldModel importUserFieldModel = new ImportUserFieldModel();
        importUserFieldModel.setRowNum(rowNum);
        userFieldModelList.add(importUserFieldModel);
        importUserFieldModel.setUserId(userId);
        importUserFieldModel.setRoleId(roleId);
        importUserFieldModel.setFileOrgId(this.orgNumIdMap.get(orgNum));
        importUserFieldModel.setAppId(this.permInitImportService.getAppId(appNum));
        importUserFieldModel.setEntityNumber(entityNum);
        importUserFieldModel.setPropKey(fieldProp);
        importUserFieldModel.setCanRead(PermTemplateFieldMap.getFieldCustomEnable(view));
        importUserFieldModel.setCanWrite(PermTemplateFieldMap.getFieldCustomEnable(data.getString(PermTemplateFieldMap.UserField.edit.getKey())));
    }

    private boolean customRoleRangeValidate(JSONObject data, int startIndex, ImportLogger importLogger) {
        String appNum = data.getString(PermTemplateFieldMap.UserField.app_num.getKey());
        String entityNum = data.getString(PermTemplateFieldMap.UserField.entity_num.getKey());
        String fieldProp = data.getString(PermTemplateFieldMap.UserField.field_prop.getKey());
        StringBuilder requestedMsg = new StringBuilder();
        this.baseColumnValidate(data, requestedMsg);
        if (HRStringUtils.isEmpty((String)appNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u5e94\u7528\u3001", (String)"PermInitImportValidateService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)entityNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u3001", (String)"PermInitImportValidateService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)fieldProp)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u5c5e\u6027\u3001", (String)"PermInitImportValidateService_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (requestedMsg.length() > 0) {
            requestedMsg.deleteCharAt(requestedMsg.length() - 1);
            requestedMsg.append(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a", (String)"PermInitImportValidateService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            importLogger.fail();
            importLogger.log(Integer.valueOf(startIndex), requestedMsg.toString());
            return false;
        }
        return true;
    }

    private void baseColumnValidate(JSONObject data, StringBuilder requestedMsg) {
        String userNum = data.getString(PermTemplateFieldMap.UserField.user_num.getKey());
        String roleNum = data.getString(PermTemplateFieldMap.UserField.role_num.getKey());
        String orgNum = data.getString(PermTemplateFieldMap.UserField.org_num.getKey());
        if (HRStringUtils.isEmpty((String)userNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u5de5\u53f7\u3001", (String)"PermInitImportValidateService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)roleNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u89d2\u8272\u3001", (String)"PermInitImportValidateService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)orgNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u3001", (String)"PermInitImportValidateService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
    }

    public void initUserBDRule(JSONObject data, List<ImportUserBdDataRuleModel> userBdDataRuleModelList, Map<String, List<Integer>> bdPropRowMap) {
        ImportLogger importLogger = this.importLoggerMap.get("importUserBD");
        int rowNum = data.getInteger("rowNum");
        String userNum = data.getString(PermTemplateFieldMap.UserBD.user_num.getKey());
        String roleNum = data.getString(PermTemplateFieldMap.UserBD.role_num.getKey());
        String orgNum = data.getString(PermTemplateFieldMap.UserBD.org_num.getKey());
        String ruleNum = data.getString(PermTemplateFieldMap.UserBD.rule_num.getKey());
        String appNum = data.getString(PermTemplateFieldMap.UserBD.app_num.getKey());
        String entityNum = data.getString(PermTemplateFieldMap.UserBD.entity_num.getKey());
        String bdPro = data.getString(PermTemplateFieldMap.UserBD.bd_prop.getKey());
        if (!this.bdRuleRequestedValidate(data, rowNum, importLogger)) {
            return;
        }
        if (!this.roleLegalValidate(data, rowNum, importLogger)) {
            return;
        }
        String errorMsg = "";
        RoleInfoData roleInfoData = (RoleInfoData)this.recordCheckInfo.getRoleExcelData().get(roleNum);
        if (roleInfoData != null) {
            Set appSet = roleInfoData.getAppSet();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)appSet) || !appSet.contains(appNum)) {
                String tip = ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u9519\u8bef\u6216\u8be5\u89d2\u8272\u65e0\u201c%s\u201d\u5e94\u7528\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_10", (String)"hrmp-hrcs-business", (Object[])new Object[]{appNum});
                importLogger.fail();
                importLogger.log(Integer.valueOf(rowNum), tip);
                return;
            }
            Set entityNums = (Set)roleInfoData.getEntityNumberMap().get(appNum);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entityNums) || !entityNums.contains(entityNum)) {
                String tip = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u9519\u8bef\uff0c\u6216\u8be5\u89d2\u8272\u65e0\u201c%1$s\u201d\u6743\u9650\u7684\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]), appNum, entityNum);
                importLogger.fail();
                importLogger.log(Integer.valueOf(rowNum), tip);
                return;
            }
            if (HRStringUtils.isNotEmpty((String)bdPro)) {
                Set perms = (Set)roleInfoData.getEntityBdFieldProMap().get(entityNum);
                LOGGER.info("PermInitImportPlugin: entityNum= {}, bdFieldProps = {}", (Object)entityNum, (Object)perms);
                if (CollectionUtils.isEmpty((Collection)perms) || !perms.contains(bdPro)) {
                    importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u5c5e\u4e8e\u8be5\u4e1a\u52a1\u5bf9\u8c61\u6216\u975e\u57fa\u7840\u8d44\u6599\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_54", (String)"hrmp-hrcs-business", (Object[])new Object[]{bdPro}));
                    return;
                }
            }
        }
        String targetEntityNumber = EntityPropParser.getPropF7EntityNumber(entityNum, bdPro);
        if (HRStringUtils.isNotEmpty((String)ruleNum) && roleInfoData != null) {
            if (!this.dataRuleMap.containsKey(ruleNum)) {
                errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_20", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            } else {
                List objStatuses = (List)roleInfoData.getEntityDataRuleMap().get(targetEntityNumber);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)objStatuses)) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u201c%2$s\u201d\u5bf9\u8c61\u7684\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_27", (String)"hrmp-hrcs-business", (Object[])new Object[0]), ruleNum, targetEntityNumber);
                } else {
                    Optional<ObjStatus> first = objStatuses.stream().filter(it -> HRStringUtils.equals((String)ruleNum, (String)it.getNumber())).findFirst();
                    if (!first.isPresent()) {
                        errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u201c%2$s\u201d\u5bf9\u8c61\u7684\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_27", (String)"hrmp-hrcs-business", (Object[])new Object[0]), ruleNum, targetEntityNumber);
                    } else {
                        ObjStatus objStatus = first.get();
                        if (HRStringUtils.equals((String)"0", (String)objStatus.getEnable())) {
                            errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u89c4\u5219", (String)"PermInitImportValidateService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                        }
                    }
                }
            }
        }
        if (errorMsg.length() > 0) {
            importLogger.fail();
            importLogger.log(Integer.valueOf(rowNum), errorMsg);
            return;
        }
        String userOrgRoleId = userNum + "#" + orgNum + "#" + roleNum;
        String rowKey = userOrgRoleId + appNum + entityNum + bdPro;
        ArrayList rowIndexs = bdPropRowMap.get(rowKey);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(rowIndexs)) {
            rowIndexs = Lists.newArrayList((Object[])new Integer[]{rowNum});
            bdPropRowMap.put(rowKey, rowIndexs);
        } else {
            rowIndexs.add(rowNum);
        }
        ImportUserBdDataRuleModel importUserBdDataRuleModel = new ImportUserBdDataRuleModel();
        importUserBdDataRuleModel.setRowNum(rowNum);
        userBdDataRuleModelList.add(importUserBdDataRuleModel);
        importUserBdDataRuleModel.setUserId(this.userIdMap.get(data.getString(PermTemplateFieldMap.UserBD.user_num.getKey())));
        importUserBdDataRuleModel.setRoleId(this.roleNumIdMap.get(data.getString(PermTemplateFieldMap.UserBD.role_num.getKey())));
        importUserBdDataRuleModel.setFileOrgId(this.orgNumIdMap.get(data.getString(PermTemplateFieldMap.UserBD.org_num.getKey())));
        importUserBdDataRuleModel.setEntityNumber(data.getString(PermTemplateFieldMap.UserBD.entity_num.getKey()));
        importUserBdDataRuleModel.setPropEntNum(targetEntityNumber);
        importUserBdDataRuleModel.setAppId(this.permInitImportService.getAppId(data.getString(PermTemplateFieldMap.UserBD.app_num.getKey())));
        importUserBdDataRuleModel.setPropKey(data.getString(PermTemplateFieldMap.UserBD.bd_prop.getKey()));
        importUserBdDataRuleModel.setDataRuleId(this.permInitImportService.queryDataRuleColByNumber(data.getString(PermTemplateFieldMap.UserBD.rule_num.getKey())));
    }

    private boolean roleLegalValidate(JSONObject data, int rowNum, ImportLogger importLogger) {
        String userNum = data.getString(PermTemplateFieldMap.UserBD.user_num.getKey());
        String roleNum = data.getString(PermTemplateFieldMap.UserBD.role_num.getKey());
        String orgNum = data.getString(PermTemplateFieldMap.UserBD.org_num.getKey());
        StringBuilder errorMsg = new StringBuilder();
        String userOrgRoleId = userNum + "#" + orgNum + "#" + roleNum;
        if (!this.recordCheckInfo.getUserRoleOrgSet().contains(userOrgRoleId)) {
            errorMsg.append(ResManager.loadKDString((String)"\u201c\u7528\u6237\u89d2\u8272\u201d\u4e0d\u5b58\u5728\u7528\u6237\u89d2\u8272\u8bb0\u5f55\uff0c\u6216\u8005\u201c\u7528\u6237\u89d2\u8272\u201d\u7684\u6570\u636e\u6821\u9a8c\u5931\u8d25", (String)"PermInitImportValidateService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        RoleInfoData roleInfoData = (RoleInfoData)this.recordCheckInfo.getRoleExcelData().get(roleNum);
        String roleScope = (String)this.recordCheckInfo.getUserRoleOrgDataScopeMap().get(userOrgRoleId);
        if (roleInfoData != null && HRStringUtils.equals((String)roleScope, (String)"0")) {
            errorMsg.append(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u7684\u89d2\u8272\u6570\u636e\u8303\u56f4\u5c5e\u6027\u4e3a\u201c\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4\u201d\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u6570\u636e\u89c4\u5219", (String)"PermInitImportValidateService_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (errorMsg.length() > 0) {
            importLogger.fail();
            importLogger.log(Integer.valueOf(rowNum), errorMsg.toString());
            return false;
        }
        return true;
    }

    private boolean bdRuleRequestedValidate(JSONObject data, int rowIndex, ImportLogger importLogger) {
        String appNum = data.getString(PermTemplateFieldMap.UserBD.app_num.getKey());
        String entityNum = data.getString(PermTemplateFieldMap.UserBD.entity_num.getKey());
        String bdPropNum = data.getString(PermTemplateFieldMap.UserBD.bd_prop.getKey());
        String ruleNum = data.getString(PermTemplateFieldMap.UserBD.rule_num.getKey());
        StringBuilder requestedMsg = new StringBuilder();
        this.baseColumnValidate(data, requestedMsg);
        if (HRStringUtils.isEmpty((String)appNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u5e94\u7528\u3001", (String)"PermInitImportValidateService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)entityNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u3001", (String)"PermInitImportValidateService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)bdPropNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u3001", (String)"PermInitImportValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)ruleNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u3001", (String)"PermInitImportValidateService_19", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (requestedMsg.length() > 0) {
            requestedMsg.deleteCharAt(requestedMsg.length() - 1);
            requestedMsg.append(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a", (String)"PermInitImportValidateService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            importLogger.fail();
            importLogger.log(Integer.valueOf(rowIndex), requestedMsg.toString());
            return false;
        }
        return true;
    }

    public void initUserDataRule(JSONObject data, List<ImportUserDataRuleModel> userDataRuleModelList, Map<String, Map<String, Integer>> drExistPerms, Map<String, Set<String>> duplicatePermRows) {
        boolean isRun = true;
        ImportLogger importLogger = this.importLoggerMap.get("importUserDr");
        int rowNum = data.getInteger("rowNum");
        String userNum = data.getString(PermTemplateFieldMap.UserRole.user_num.getKey());
        String roleNum = data.getString(PermTemplateFieldMap.UserRole.role_num.getKey());
        String orgNum = data.getString(PermTemplateFieldMap.UserRole.org_num.getKey());
        String ruleNum = data.getString(PermTemplateFieldMap.UserDr.rule_num.getKey());
        String appNum = data.getString(PermTemplateFieldMap.UserDr.app_num.getKey());
        String entityNum = data.getString(PermTemplateFieldMap.UserDr.entity_num.getKey());
        String permStr = data.getString(PermTemplateFieldMap.UserDr.perm.getKey());
        if (!this.drRequestedValidate(data, rowNum, importLogger)) {
            return;
        }
        if (!this.roleLegalValidate(data, rowNum, importLogger)) {
            return;
        }
        String errorMsg = "";
        RoleInfoData roleInfoData = (RoleInfoData)this.recordCheckInfo.getRoleExcelData().get(roleNum);
        if (roleInfoData != null) {
            Set appSet = roleInfoData.getAppSet();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)appSet) || !appSet.contains(appNum)) {
                String tip = ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u9519\u8bef\u6216\u8be5\u89d2\u8272\u65e0\u201c%s\u201d\u5e94\u7528\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_10", (String)"hrmp-hrcs-business", (Object[])new Object[]{appNum});
                importLogger.fail();
                importLogger.log(Integer.valueOf(rowNum), tip);
                return;
            }
            Set entityNums = (Set)roleInfoData.getEntityNumberMap().get(appNum);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entityNums) || !entityNums.contains(entityNum)) {
                String tip = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u9519\u8bef\uff0c\u6216\u8be5\u89d2\u8272\u65e0\u201c%1$s\u201d\u6743\u9650\u7684\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]), appNum, entityNum);
                importLogger.fail();
                importLogger.log(Integer.valueOf(rowNum), tip);
                return;
            }
        }
        if (HRStringUtils.isNotEmpty((String)ruleNum) && roleInfoData != null) {
            if (!this.dataRuleMap.containsKey(ruleNum)) {
                errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_20", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            } else {
                List objStatuses = (List)roleInfoData.getEntityDataRuleMap().get(entityNum);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)objStatuses)) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u201c%2$s\u201d\u5bf9\u8c61\u7684\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_27", (String)"hrmp-hrcs-business", (Object[])new Object[0]), ruleNum, entityNum);
                } else {
                    Optional<ObjStatus> first = objStatuses.stream().filter(it -> HRStringUtils.equals((String)ruleNum, (String)it.getNumber())).findFirst();
                    if (!first.isPresent()) {
                        errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u201c%2$s\u201d\u5bf9\u8c61\u7684\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_27", (String)"hrmp-hrcs-business", (Object[])new Object[0]), ruleNum, entityNum);
                    } else {
                        ObjStatus objStatus = first.get();
                        if (HRStringUtils.equals((String)"0", (String)objStatus.getEnable())) {
                            errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u89c4\u5219", (String)"PermInitImportValidateService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                        }
                    }
                }
            }
        }
        if (errorMsg.length() > 0) {
            importLogger.fail();
            importLogger.log(Integer.valueOf(rowNum), errorMsg);
            return;
        }
        String permPrefix = userNum + "#" + orgNum + "#" + roleNum + "#" + appNum + "#" + entityNum;
        if (HRStringUtils.isNotEmpty((String)roleNum) && roleInfoData != null && HRStringUtils.isNotEmpty((String)permStr)) {
            List perms = (List)roleInfoData.getEntityNumPermMap().get(entityNum);
            ArrayList lst = Lists.newArrayListWithExpectedSize((int)2);
            ArrayList duplicatePerms = Lists.newArrayListWithExpectedSize((int)10);
            boolean hasImportExportPerm = false;
            if (CollectionUtils.isNotEmpty((Collection)perms)) {
                String[] permNames;
                Map<String, String> nameIdMap = perms.stream().collect(Collectors.toMap(ObjStatus::getName, ObjStatus::getPermId, (newVal, oldVal) -> newVal));
                String permst = permStr.replaceAll("\uff1b", ";");
                for (String permName : permNames = permst.split(";")) {
                    String rowKey;
                    if (perms.stream().noneMatch(it -> it.getName().equals(permName))) {
                        lst.add(permName);
                    }
                    if (drExistPerms.containsKey(rowKey = permPrefix + "#" + permName)) {
                        duplicatePerms.add(permName);
                        Set duplicatePermNames = duplicatePermRows.computeIfAbsent(rowKey, key -> Sets.newHashSetWithExpectedSize((int)16));
                        duplicatePermNames.add(permName);
                    } else {
                        Map permRowMap = drExistPerms.computeIfAbsent(rowKey, key -> Maps.newHashMapWithExpectedSize((int)16));
                        permRowMap.put(permName, rowNum);
                    }
                    if (hasImportExportPerm || !HRStringUtils.equals((String)nameIdMap.get(permName), (String)"4730fc9f000003ae") && !HRStringUtils.equals((String)nameIdMap.get(permName), (String)"4730fc9f000004ae")) continue;
                    String tip = ResManager.loadKDString((String)"\u5bfc\u5165\u5bfc\u51fa\u6743\u9650\u9879\uff0c\u4e0d\u652f\u6301\u6570\u636e\u89c4\u5219\u65b9\u6848", (String)"PermInitImportValidateService_25", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                    importLogger.log(Integer.valueOf(rowNum), tip);
                    hasImportExportPerm = true;
                    isRun = false;
                }
                if (lst.size() > 0) {
                    String join = String.join((CharSequence)"\u3001", lst);
                    String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u4e1a\u52a1\u5bf9\u8c61\u7684\u201c%s\u6743\u9650\u9879\u201d", (String)"PermInitImportValidateService_22", (String)"hrmp-hrcs-business", (Object[])new Object[0]), join);
                    importLogger.log(Integer.valueOf(rowNum), tip);
                    isRun = false;
                }
                if (duplicatePerms.size() > 0) {
                    String duplicatePermStr = String.join((CharSequence)"\u3001", duplicatePerms);
                    String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u201c%s\u201d\u6743\u9650\u9879\u7684\u6570\u636e\u89c4\u5219\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_23", (String)"hrmp-hrcs-business", (Object[])new Object[0]), duplicatePermStr);
                    importLogger.log(Integer.valueOf(rowNum), tip);
                    isRun = false;
                }
            }
        }
        if (!isRun) {
            return;
        }
        ImportUserDataRuleModel importUserDataRuleModel = new ImportUserDataRuleModel();
        importUserDataRuleModel.setRowNum(rowNum);
        userDataRuleModelList.add(importUserDataRuleModel);
        importUserDataRuleModel.setUserId(this.userIdMap.get(data.getString(PermTemplateFieldMap.UserDr.user_num.getKey())));
        importUserDataRuleModel.setRoleId(this.roleNumIdMap.get(data.getString(PermTemplateFieldMap.UserDr.role_num.getKey())));
        importUserDataRuleModel.setFileOrgId(this.orgNumIdMap.get(data.getString(PermTemplateFieldMap.UserDr.org_num.getKey())));
        importUserDataRuleModel.setEntityNumber(entityNum);
        importUserDataRuleModel.setAppId(this.permInitImportService.getAppId(appNum));
        List permList = (List)roleInfoData.getEntityNumPermMap().get(entityNum);
        if (HRStringUtils.isNotEmpty((String)permStr)) {
            List collect;
            String permst = permStr.replaceAll("\uff1b", ";");
            String[] split = permst.split(";");
            if (CollectionUtils.isNotEmpty((Collection)permList) && CollectionUtils.isNotEmpty(collect = permList.stream().filter(it -> Lists.newArrayList((Object[])split).contains(it.getName())).map(ObjStatus::getPermId).collect(Collectors.toList()))) {
                List permItemList = collect.stream().distinct().collect(Collectors.toList());
                importUserDataRuleModel.setPermItemList(permItemList);
            }
        } else if (CollectionUtils.isNotEmpty((Collection)permList)) {
            importUserDataRuleModel.setPermItemList(permList.stream().map(ObjStatus::getPermId).collect(Collectors.toList()));
        }
        importUserDataRuleModel.setDataRuleId(this.permInitImportService.queryDataRuleColByNumber(ruleNum));
    }

    private boolean drRequestedValidate(JSONObject data, int rowIndex, ImportLogger importLogger) {
        String appNum = data.getString(PermTemplateFieldMap.UserDr.app_num.getKey());
        String entityNum = data.getString(PermTemplateFieldMap.UserDr.entity_num.getKey());
        String ruleNum = data.getString(PermTemplateFieldMap.UserDr.rule_num.getKey());
        StringBuilder requestedMsg = new StringBuilder();
        this.baseColumnValidate(data, requestedMsg);
        if (HRStringUtils.isEmpty((String)appNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u5e94\u7528\u3001", (String)"PermInitImportValidateService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)entityNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u3001", (String)"PermInitImportValidateService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)ruleNum)) {
            requestedMsg.append(ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u3001", (String)"PermInitImportValidateService_19", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (requestedMsg.length() > 0) {
            requestedMsg.deleteCharAt(requestedMsg.length() - 1);
            requestedMsg.append(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a", (String)"PermInitImportValidateService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            importLogger.fail();
            importLogger.log(Integer.valueOf(rowIndex), requestedMsg.toString());
            return false;
        }
        return true;
    }

    private boolean checkUserRole(JSONObject data, List<ImportUserDimModel> userDimModelList, Set<String> rowKeys, Set<String> rangeInconsistencyRowKeys, Map<String, Map<String, String>> allDimValues, Map<Integer, Map<String, List<String>>> dimValList, Map<String, String> dimIdNameInfo, Map<String, Set<String>> buOrgInfo, Map<String, Set<String>> lackBuRowKeys, Map<String, Set<String>> roleValidTimeInfo, Map<String, Set<String>> roleOrgInfo, Map<Long, List<Triple<Long, String, Long>>> oTDimValueMap, Map<Long, String> enmuMap, Map<String, List<Long>> roleBusMap, Map<Integer, Map<String, Map<String, String>>> dimValListContainsSubTemp, Map<String, Pair<String, String>> dimInfoMap, Map<String, List<String>> dimDynaRangeMap, List<String> allDynaCondNumbers, Map<String, Long> allDynaCondMap) throws ParseException {
        String dimKey;
        String dimValStr;
        Set<String> set;
        List buType;
        RoleInfoData roleInfoData;
        String endTime;
        String startTime;
        boolean enableValidateTime;
        boolean orgEmpty;
        ImportLogger importLogger = this.importLoggerMap.get("importUserR");
        int rowNum = data.getInteger("rowNum");
        String userNum = data.getString(PermTemplateFieldMap.UserRole.user_num.getKey());
        String roleNum = data.getString(PermTemplateFieldMap.UserRole.role_num.getKey());
        String orgNum = data.getString(PermTemplateFieldMap.UserRole.org_num.getKey());
        String dataScope = data.getString(PermTemplateFieldMap.UserRole.data_scope.getKey());
        String buTypeStr = data.getString(PermTemplateFieldMap.UserRole.bu_type.getKey());
        String userOrgRoleKey = userNum + "#" + orgNum + "#" + roleNum;
        StringBuilder msg = new StringBuilder();
        if (HRStringUtils.isEmpty((String)userNum)) {
            msg.append(ResManager.loadKDString((String)"\u201c\u5de5\u53f7\u201d\u3001", (String)"PermInitImportValidateService_62", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)roleNum)) {
            msg.append(ResManager.loadKDString((String)"\u201c\u89d2\u8272\u201d\u3001", (String)"PermInitImportValidateService_63", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (orgEmpty = HRStringUtils.isEmpty((String)orgNum)) {
            msg.append(ResManager.loadKDString((String)"\u201cHR\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001", (String)"PermInitImportValidateService_64", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)dataScope)) {
            msg.append(ResManager.loadKDString((String)"\u201c\u6570\u636e\u8303\u56f4\u5c5e\u6027\u201d\u3001", (String)"PermInitImportValidateService_65", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)buTypeStr)) {
            msg.append(ResManager.loadKDString((String)"\u201c\u804c\u80fd\u201d\u3001", (String)"PermInitImportValidateService_66", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (enableValidateTime = PermCommonUtil.isEnableValidateTime()) {
            startTime = data.getString(PermTemplateFieldMap.UserRole.start_time.getKey());
            endTime = data.getString(PermTemplateFieldMap.UserRole.end_time.getKey());
            if (HRStringUtils.isEmpty((String)startTime)) {
                msg.append(ResManager.loadKDString((String)"\u201c\u6709\u6548\u5f00\u59cb\u65e5\u671f\u201d\u3001", (String)"PermInitImportValidateService_67", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (HRStringUtils.isEmpty((String)endTime)) {
                msg.append(ResManager.loadKDString((String)"\u201c\u6709\u6548\u7ed3\u675f\u65e5\u671f\u201d\u3001", (String)"PermInitImportValidateService_68", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            msg.append(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a", (String)"PermInitImportValidateService_77", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            importLogger.log(Integer.valueOf(rowNum), msg.toString());
            return false;
        }
        if (HRStringUtils.isNotEmpty((String)userNum) && !this.userIdMap.containsKey(userNum)) {
            msg.append(ResManager.loadKDString((String)"\u5de5\u53f7\u3001", (String)"PermInitImportValidateService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isNotEmpty((String)orgNum) && !this.orgNumIdMap.containsKey(orgNum)) {
            msg.append(ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u3001", (String)"PermInitImportValidateService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            String errorMsg = ResManager.loadKDString((String)"%s\u7684\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_78", (String)"hrmp-hrcs-business", (Object[])new Object[]{msg.toString()});
            importLogger.log(Integer.valueOf(rowNum), errorMsg);
            return false;
        }
        if (enableValidateTime) {
            startTime = data.getString(PermTemplateFieldMap.UserRole.start_time.getKey());
            endTime = data.getString(PermTemplateFieldMap.UserRole.end_time.getKey());
            if (!this.permInitImportService.checkDate(startTime)) {
                msg.append(ResManager.loadKDString((String)"\u201c\u6709\u6548\u5f00\u59cb\u65e5\u671f\u201d\u3001", (String)"PermInitImportValidateService_67", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (!this.permInitImportService.checkDate(endTime)) {
                msg.append(ResManager.loadKDString((String)"\u201c\u6709\u6548\u7ed3\u675f\u65e5\u671f\u201d\u3001", (String)"PermInitImportValidateService_68", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            msg.append(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u53c2\u8003\u6279\u6ce8", (String)"PermInitImportValidateService_69", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            importLogger.log(Integer.valueOf(rowNum), msg.toString());
            return false;
        }
        if (HRStringUtils.isNotEmpty((String)roleNum) && !this.roleNumIdMap.containsKey(roleNum)) {
            String tip = ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_70", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            importLogger.log(Integer.valueOf(rowNum), tip);
            return false;
        }
        String usrStatus = this.userIdStatusMap.get(userNum);
        if (HRStringUtils.isNotEmpty((String)usrStatus) && HRStringUtils.equals((String)"true", (String)usrStatus)) {
            String tip = ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u89d2\u8272", (String)"PermInitImportValidateService_71", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            importLogger.log(Integer.valueOf(rowNum), tip);
            return false;
        }
        String roleStatus = this.roleNumStatusMap.get(roleNum);
        if (HRStringUtils.isNotEmpty((String)roleStatus) && HRStringUtils.equals((String)roleStatus, (String)"0")) {
            String tip = ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u7528\u6237", (String)"PermInitImportValidateService_72", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            importLogger.log(Integer.valueOf(rowNum), tip);
            return false;
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            importLogger.log(Integer.valueOf(rowNum), msg.toString());
            return false;
        }
        List permFileList = (List)this.recordCheckInfo.getUserPermFile().get(userNum);
        if (CollectionUtils.isNotEmpty((Collection)permFileList)) {
            Optional<ObjStatus> first = permFileList.stream().filter(it -> HRStringUtils.equals((String)orgNum, (String)it.getOrgNumber())).findFirst();
            if (first.isPresent()) {
                ObjStatus objStatus = first.get();
                if (HRStringUtils.equals((String)objStatus.getStatus(), (String)"0")) {
                    msg.append(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6240\u5c5e\u7684\u7ec4\u7ec7\u7684\u6743\u9650\u6863\u6848\u5df2\u5931\u6548\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u89d2\u8272", (String)"PermInitImportValidateService_73", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                }
            } else {
                msg.append(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709HR\u7ba1\u7406\u7ec4\u7ec7\u7684\u6743\u9650\u6863\u6848", (String)"PermInitImportValidateService_74", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
        }
        if (msg.length() > 0) {
            importLogger.log(Integer.valueOf(rowNum), msg.toString());
            return false;
        }
        if (enableValidateTime) {
            Set<String> valids;
            Date endTimeDt;
            String startTime2 = data.getString(PermTemplateFieldMap.UserRole.start_time.getKey());
            String endTime2 = data.getString(PermTemplateFieldMap.UserRole.end_time.getKey());
            Date startTimeDt = this.permInitImportService.parseDate(startTime2);
            if (startTimeDt.after(endTimeDt = this.permInitImportService.parseDate(endTime2))) {
                msg.append(ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6709\u6548\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff1b", (String)"PermInitImportValidateService_75", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (CollectionUtils.isNotEmpty(valids = roleValidTimeInfo.get(userOrgRoleKey)) && valids.size() > 1) {
                msg.append(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\uff0c\u7528\u6237\u5728\u89d2\u8272\u4e0a\u7684\u6709\u6548\u671f\u4e0d\u4e00\u81f4\uff1b", (String)"PermInitImportValidateService_76", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
        }
        if ((roleInfoData = (RoleInfoData)this.recordCheckInfo.getRoleExcelData().get(roleNum)) != null && !roleInfoData.getBuType().contains(buTypeStr)) {
            String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b\u7684\u503c\u9519\u8bef\uff0c\u8bf7\u53c2\u8003\u6279\u6ce8\uff1b", (String)"PermInitImportValidateService_56", (String)"hrmp-hrcs-business", (Object[])new Object[0]), buTypeStr);
            msg.append(tip);
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            importLogger.log(Integer.valueOf(rowNum), msg.toString());
            return false;
        }
        if (roleInfoData != null && HRStringUtils.isNotEmpty((String)buTypeStr) && CollectionUtils.isNotEmpty((Collection)(buType = roleInfoData.getRoleBuType())) && !buType.contains(buTypeStr)) {
            String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u65e0\u201c%s\u201d\u804c\u80fd\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermInitImportValidateService_55", (String)"hrmp-hrcs-business", (Object[])new Object[0]), buTypeStr);
            importLogger.log(Integer.valueOf(rowNum), tip);
            return false;
        }
        String separator = ResManager.loadKDString((String)"\u3001", (String)"PermInitImportValidateService_37", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        if (lackBuRowKeys.containsKey(userOrgRoleKey)) {
            Set<String> lackBus = lackBuRowKeys.get(userOrgRoleKey);
            String lackBuStr = lackBus.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
            msg.append(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u7f3a\u5c11%s\u804c\u80fd\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_43", (String)"hrmp-hrcs-business", (Object[])new Object[]{lackBuStr}));
            importLogger.log(Integer.valueOf(rowNum), msg.toString());
            return false;
        }
        String orgCodeStr = data.getString(PermTemplateFieldMap.UserRole.bu_org.getKey());
        String customRange = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4", (String)"PermInitImportValidateService_28", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String roleRef = ResManager.loadKDString((String)"\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4", (String)"PermInitImportValidateService_29", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        boolean consistWithRole = HRStringUtils.equals((String)dataScope, (String)roleRef);
        if (!HRStringUtils.equals((String)dataScope, (String)customRange) && !consistWithRole) {
            String tip = ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u5c5e\u6027\u7684\u503c\u9519\u8bef\uff0c\u8bf7\u53c2\u8003\u793a\u6279\u6ce8", (String)"PermInitImportValidateService_30", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            importLogger.log(Integer.valueOf(rowNum), tip);
            return false;
        }
        String uniqueBuRowKey = userOrgRoleKey + buTypeStr;
        if (consistWithRole) {
            if (rowKeys.contains(uniqueBuRowKey)) {
                String tip = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u89d2\u8272\u8bb0\u5f55\uff0c\u65e0\u9700\u5bfc\u5165", (String)"PermInitImportValidateService_31", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                importLogger.log(Integer.valueOf(rowNum), tip);
                return false;
            }
            rowKeys.add(uniqueBuRowKey);
        }
        if (rangeInconsistencyRowKeys.contains(userOrgRoleKey)) {
            String tip = ResManager.loadKDString((String)"\u7528\u6237\u5728\u76f8\u540c\u89d2\u8272\u4e0a\u7684\u6570\u636e\u8303\u56f4\u5c5e\u6027\u9700\u4fdd\u6301\u4e00\u81f4", (String)"PermInitImportValidateService_32", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            importLogger.log(Integer.valueOf(rowNum), tip);
            return false;
        }
        if (roleInfoData != null) {
            if (HRStringUtils.equals((String)roleInfoData.getDataScope(), (String)"0") && HRStringUtils.equals((String)dataScope, (String)customRange)) {
                String tip = ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u7684\u6570\u636e\u8303\u56f4\u5c5e\u6027\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u201c\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4\u201d\uff0c\u8bf7\u8c03\u6574\u6570\u636e", (String)"PermInitImportValidateService_33", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                importLogger.log(Integer.valueOf(rowNum), tip);
                return false;
            }
            if (HRStringUtils.equals((String)roleInfoData.getDataScope(), (String)"1") && consistWithRole && CollectionUtils.isEmpty((Collection)roleBusMap.get(this.roleNumIdMap.get(roleNum)))) {
                String tip = ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u7684\u6570\u636e\u8303\u56f4\u5c5e\u6027\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u201c\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\uff0c\u8bf7\u8c03\u6574\u6570\u636e", (String)"PermInitImportValidateService_34", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                importLogger.log(Integer.valueOf(rowNum), tip);
                return false;
            }
        }
        String hasDim = data.getString("hasDim");
        boolean hasDimFlag = "Y".equals(hasDim);
        boolean orgNotEmpty = HRStringUtils.isNotEmpty((String)orgCodeStr);
        if (consistWithRole) {
            boolean filledDim = false;
            if (hasDimFlag) {
                List dims = (List)data.get((Object)"dim");
                List dimNums = dims.stream().map(it -> HRStringUtils.equals((String)((String)it.get("ot")), (String)"N") ? it.get("code") : it.get("oldCode")).map(it -> String.valueOf(it)).collect(Collectors.toList());
                filledDim = dimNums.stream().anyMatch(dimNum -> HRStringUtils.isNotEmpty((String)data.getString(dimNum)));
            }
            if (orgNotEmpty || filledDim) {
                String tip = ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u5c5e\u6027\u4e3a\u201c\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4\u201d\uff0c\u65e0\u9700\u8bbe\u7f6e\u201c\u7ec4\u7ec7\u8303\u56f4\u201d\u548c\u201c\u89d2\u8272\u7ef4\u5ea6\u201d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8303\u56f4\u5c5e\u6027", (String)"PermInitImportValidateService_35", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                importLogger.log(Integer.valueOf(rowNum), tip);
                return false;
            }
        }
        String unlimited = ResManager.loadKDString((String)"\u4e0d\u9650", (String)"PermInitImportValidateService_38", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        HashSet unlimitedSet = Sets.newHashSet((Object[])new String[]{unlimited, "all", "All", "ALL", "aLL", "alL", "aLl", "AlL"});
        Set<String> allOrgNums = this.orgNumIdMap.keySet();
        Set<String> orgNums = this.dealValueCode(orgCodeStr);
        Iterator<String> iterator = orgNums.iterator();
        HashSet containsSubNotRightSet = Sets.newHashSetWithExpectedSize((int)16);
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (!PermInitServiceHelper.isRightContainsSub(next)) continue;
            containsSubNotRightSet.add(next);
            iterator.remove();
        }
        if (CollectionUtils.isNotEmpty((Collection)containsSubNotRightSet)) {
            String containsSubNotRight = containsSubNotRightSet.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
            msg.append(String.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u201d\uff1a%s\u7f16\u7801\u503c\u4e0d\u5b58\u5728\u6216\u5305\u542b\u4e0b\u7ea7\u5f55\u5165\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_54", (String)"hrmp-hrcs-business", (Object[])new Object[0]), containsSubNotRight));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orgNums)) {
            Set orgNumWithDynaRange = orgNums.stream().filter(orgNumStr -> orgNumStr.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)).collect(Collectors.toSet());
            Set orgNumWithOutDynaRange = orgNums.stream().filter(orgNumStr -> !orgNumStr.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(orgNumWithDynaRange)) {
                String notApplyDynaRange = orgNumWithDynaRange.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
                msg.append(ResManager.loadKDString((String)"\u52a8\u6001\u6570\u636e\u8303\u56f4%s\u4e0d\u9002\u7528\u4e8e\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_81", (String)"hrmp-hrcs-business", (Object[])new Object[]{notApplyDynaRange}));
            }
            HashSet orgNumCopy = Sets.newHashSet(orgNumWithOutDynaRange);
            orgNumCopy.removeIf(allOrgNums::contains);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgNumCopy)) {
                LOGGER.info("PermInitImportPlugin : orgNumIdMap.key = {} , orgNums = {}", allOrgNums, orgNums);
                String string = orgNumCopy.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
                msg.append(ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u8303\u56f4\u201d\u7684\u503c%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_39", (String)"hrmp-hrcs-business", (Object[])new Object[]{string}));
            }
            if (orgNumCopy.size() <= 0) {
                Long l = this.buViewIdMap.get(buTypeStr);
                Set<String> buOrgNums = this.buOrgMap.get(l);
                if (org.apache.commons.collections.CollectionUtils.isEmpty(buOrgNums)) {
                    String notExistOrg = orgNumCopy.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
                    msg.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_59", (String)"hrmp-hrcs-business", (Object[])new Object[0]), notExistOrg, buTypeStr));
                } else {
                    orgNumWithOutDynaRange.removeIf(buOrgNums::contains);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orgNumWithOutDynaRange)) {
                        String notBuExistOrg = orgNumWithOutDynaRange.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
                        msg.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_59", (String)"hrmp-hrcs-business", (Object[])new Object[0]), notBuExistOrg, buTypeStr));
                    }
                }
            }
        }
        Map<String, List<String>> dimInfo = dimValList.get(rowNum);
        Map<String, Map<String, String>> dimInfoWithContainsSub = dimValListContainsSubTemp.get(rowNum);
        if (MapUtils.isNotEmpty(dimInfo)) {
            for (Map.Entry entry : dimInfo.entrySet()) {
                List dimVals = (List)entry.getValue();
                String dimKey2 = (String)entry.getKey();
                if (dimKey2.contains("#")) {
                    dimKey2 = Long.valueOf(dimKey2.split("#")[0]).toString();
                }
                if (!dimVals.stream().anyMatch(unlimitedSet::contains) || dimVals.size() <= 1) continue;
                msg.append(ResManager.loadKDString((String)"\u201c%s\u201d\uff1a\u201c\u4e0d\u9650\u201d\u4e0e\u5177\u4f53\u7684\u7ef4\u5ea6\u503c\u4e0d\u5141\u8bb8\u540c\u65f6\u5f55\u5165\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_40", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimIdNameInfo.get(dimKey2)}));
            }
        }
        if (msg.length() > 0) {
            importLogger.log(Integer.valueOf(rowNum), msg.toString());
            return false;
        }
        String buRowKey = userOrgRoleKey + "#" + buTypeStr;
        if (CollectionUtils.isNotEmpty((Collection)roleOrgInfo.get(buRowKey)) && roleOrgInfo.get(buRowKey).size() > 1) {
            msg.append(ResManager.loadKDString((String)"\u7528\u6237\u5728\u76f8\u540c\u89d2\u8272\u3001\u76f8\u540c\u804c\u80fd\u4e0b\uff0c\u5e94\u4fdd\u6301\u201c\u7ec4\u7ec7\u8303\u56f4\u201d\u4e00\u81f4\u3002", (String)"PermInitImportValidateService_53", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(set = buOrgInfo.get(buTypeStr)) && org.apache.commons.collections.CollectionUtils.isNotEmpty(orgNums)) {
            orgNums.removeIf(set::contains);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orgNums)) {
                String notExistOrg = orgNums.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
                msg.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u201c%2$s\u201d\u7684\u7ec4\u7ec7\uff0c\u8bf7\u8c03\u6574\u6570\u636e", (String)"PermInitImportValidateService_41", (String)"hrmp-hrcs-business", (Object[])new Object[0]), notExistOrg, buTypeStr));
            }
        }
        if (msg.length() > 0) {
            importLogger.log(Integer.valueOf(rowNum), msg.toString());
            return false;
        }
        boolean roleCustom = HRStringUtils.equals((String)dataScope, (String)customRange);
        List dimValueBeans = (List)roleInfoData.getDimValuesMap().get(buTypeStr);
        ArrayList<String> roleDimEmpty = new ArrayList<String>(10);
        if (roleCustom) {
            if (!orgNotEmpty) {
                roleDimEmpty.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4", (String)"PermInitImportValidateService_61", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (hasDimFlag) {
                String dimIdStr;
                dimValueBeans = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dimValueBeans) ? Lists.newArrayListWithExpectedSize((int)10) : dimValueBeans;
                List<Long> dimIds = dimValueBeans.stream().map(DimValueBean::getDimId).collect(Collectors.toList());
                List dims = (List)data.get((Object)"dim");
                ArrayList<String> arrayList = new ArrayList<String>(dims.size());
                HashMap<Long, Boolean> dimFilled = new HashMap<Long, Boolean>(dims.size());
                dimIds.forEach(dimId -> dimFilled.put((Long)dimId, Boolean.FALSE));
                Iterator<Object> iterator2 = dims.iterator();
                while (iterator2.hasNext()) {
                    Map map = (Map)iterator2.next();
                    Long dimId2 = (Long)map.get("id");
                    dimIdStr = String.valueOf(dimId2);
                    String string = (String)map.get("ot");
                    String dimNum2 = (String)map.get("code");
                    if (HRStringUtils.equals((String)string, (String)"Y")) {
                        dimNum2 = (String)map.get("oldCode");
                    }
                    dimValStr = data.getString(dimNum2);
                    Set<String> dimVals = this.dealValueCode(dimValStr);
                    if (HRStringUtils.isNotEmpty((String)dimValStr)) {
                        dimFilled.put(dimId2, Boolean.TRUE);
                    }
                    if (!HRStringUtils.equals((String)"Y", (String)string)) continue;
                    if (!dimVals.stream().anyMatch(unlimitedSet::contains)) continue;
                    msg.append(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4e0d\u9650\uff1b", (String)"PermInitImportValidateService_49", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimIdNameInfo.get(dimIdStr)}));
                }
                for (Map.Entry entry : dimFilled.entrySet()) {
                    Long dimId2 = (Long)entry.getKey();
                    dimIdStr = String.valueOf(dimId2);
                    Boolean bl = (Boolean)entry.getValue();
                    if (dimIds.contains(dimId2) && !bl.booleanValue()) {
                        roleDimEmpty.add(dimIdNameInfo.get(dimIdStr));
                    }
                    if (dimIds.contains(dimId2) || !bl.booleanValue()) continue;
                    arrayList.add(dimIdNameInfo.get(dimIdStr));
                }
                boolean dimEmpty = org.apache.commons.collections.CollectionUtils.isNotEmpty(roleDimEmpty);
                boolean bl = org.apache.commons.collections.CollectionUtils.isNotEmpty(arrayList);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dimValueBeans)) {
                    if (bl) {
                        msg.append(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u65e0\u9700\u8bbe\u7f6e\u201c\u89d2\u8272\u7ef4\u5ea6\u201d", (String)"PermInitImportValidateService_46", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                    }
                } else {
                    String roleDimEmptyStr = roleDimEmpty.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_47", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
                    String roleNoDimStr = arrayList.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_47", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
                    if (dimEmpty && bl) {
                        String string = String.format(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u5c5e\u6027\u4e3a\u201c\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\u3002\u8bf7\u8bbe\u7f6e%1$s\uff0c\u65e0\u9700\u8bbe\u7f6e%2$s", (String)"PermInitImportValidateService_50", (String)"hrmp-hrcs-business", (Object[])new Object[0]), roleDimEmptyStr, roleNoDimStr);
                        msg.append(string);
                    }
                    if (dimEmpty && !bl) {
                        msg.append(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u5c5e\u6027\u4e3a\u201c\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\u65f6\uff0c\u9700\u8bbe\u7f6e%s", (String)"PermInitImportValidateService_51", (String)"hrmp-hrcs-business", (Object[])new Object[]{roleDimEmptyStr}));
                    }
                    if (!dimEmpty && bl) {
                        String string = dimIds.stream().map(it -> String.valueOf(it)).map(dimIdNameInfo::get).map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_47", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
                        msg.append(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u53ea\u9700\u8bbe\u7f6e\u201c%s\u201d\uff0c\u65e0\u9700\u8bbe\u7f6e\u5176\u4ed6\u89d2\u8272\u7ef4\u5ea6", (String)"PermInitImportValidateService_58", (String)"hrmp-hrcs-business", (Object[])new Object[]{string}));
                    }
                    roleDimEmpty.clear();
                }
            }
        }
        if (roleDimEmpty.size() > 0) {
            String roleDimEmptyStr = roleDimEmpty.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_47", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
            msg.append(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u5c5e\u6027\u4e3a\u201c\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\u65f6\uff0c\u9700\u8bbe\u7f6e%s", (String)"PermInitImportValidateService_51", (String)"hrmp-hrcs-business", (Object[])new Object[]{roleDimEmptyStr}));
        }
        if (msg.length() > 0) {
            importLogger.log(Integer.valueOf(rowNum), msg.toString());
            return false;
        }
        HashMap otDim = Maps.newHashMapWithExpectedSize((int)16);
        if (MapUtils.isNotEmpty(dimInfo)) {
            for (Map.Entry<String, List<String>> entry : dimInfo.entrySet()) {
                dimKey = entry.getKey();
                if (dimKey.contains("#")) {
                    otDim.put(entry.getKey(), entry.getValue());
                    continue;
                }
                Pair<String, String> dimInfoWithType = dimInfoMap.get(dimKey);
                List<String> list = entry.getValue();
                this.setContainsSubNotRightMsg(dimIdNameInfo, msg, dimKey, list);
                List<String> dimValsWithDynaRange = list.stream().filter(dimVal -> dimVal.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)).collect(Collectors.toList());
                List dimValsWithOutDynaRange = list.stream().filter(dimVal -> !dimVal.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)).collect(Collectors.toList());
                List<String> list2 = dimValsWithOutDynaRange.stream().filter(it -> !unlimitedSet.contains(it)).collect(Collectors.toList());
                Map<String, String> existDimVals = allDimValues.get(dimKey);
                Map<String, String> dimInfoValWithContainsSub = dimInfoWithContainsSub.get(dimKey);
                if (MapUtils.isEmpty(existDimVals)) {
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list2)) {
                        this.checkContainsSubOrExist(dimIdNameInfo, msg, separator, dimKey, list2);
                    }
                } else {
                    Set<String> existDimValNums = existDimVals.keySet();
                    list2.removeIf(existDimValNums::contains);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list2)) {
                        this.checkContainsSubOrExist(dimIdNameInfo, msg, separator, dimKey, list2);
                    }
                    existDimValNums.removeIf(list2::contains);
                    ArrayList dimContainsSub = Lists.newArrayListWithCapacity((int)16);
                    if (PermInitServiceHelper.checkBaseDataTreeContainsSub(dimInfoWithType)) {
                        for (Map.Entry<String, String> dimValWithContainsSub : dimInfoValWithContainsSub.entrySet()) {
                            String key = dimValWithContainsSub.getKey();
                            String value = dimValWithContainsSub.getValue();
                            if (!existDimValNums.contains(key) || !HRStringUtils.equals((String)"1", (String)value)) continue;
                            dimContainsSub.add(key);
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)dimContainsSub)) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ef4\u5ea6\u4e0d\u652f\u6301\u5305\u542b\u4e0b\u7ea7\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_80", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dimIdNameInfo.get(dimKey)));
                    }
                }
                this.checkDimDynaRange(dimIdNameInfo, dimDynaRangeMap, allDynaCondNumbers, msg, separator, dimKey, dimValsWithDynaRange, Long.parseLong(dimKey));
            }
        }
        if (MapUtils.isNotEmpty((Map)otDim)) {
            for (Map.Entry entry : otDim.entrySet()) {
                dimKey = (String)entry.getKey();
                Long dimId3 = Long.valueOf(dimKey.split("#")[0]);
                Long l = Long.valueOf(dimKey.split("#")[1]);
                List dimVals = (List)entry.getValue();
                this.setContainsSubNotRightMsg(dimIdNameInfo, msg, dimId3.toString(), dimVals);
                List<String> dimValsWithDynaRange = dimVals.stream().filter(dimVal -> dimVal.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)).collect(Collectors.toList());
                List list = dimVals.stream().filter(dimVal -> !dimVal.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)).collect(Collectors.toList());
                List<String> noLimitedDimVals = list.stream().filter(it -> !unlimitedSet.contains(it)).collect(Collectors.toList());
                List<Triple<Long, String, Long>> triples = oTDimValueMap.get(dimId3);
                if (CollectionUtils.isEmpty(triples)) {
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(noLimitedDimVals)) {
                        this.checkContainsSubOrExist(dimIdNameInfo, msg, separator, String.valueOf(dimId3), noLimitedDimVals);
                    }
                } else {
                    noLimitedDimVals.removeIf(it -> this.getNotExtDv(triples, (String)it, structProId));
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(noLimitedDimVals)) {
                        this.checkContainsSubOrExist(dimIdNameInfo, msg, separator, String.valueOf(dimId3), noLimitedDimVals);
                    }
                }
                this.checkDimDynaRange(dimIdNameInfo, dimDynaRangeMap, allDynaCondNumbers, msg, separator, dimKey, dimValsWithDynaRange, dimId3);
            }
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            importLogger.log(Integer.valueOf(rowNum), msg.toString());
            return false;
        }
        ImportUserDimModel importUserDimModel = new ImportUserDimModel();
        importUserDimModel.setRowNum(rowNum);
        userDimModelList.add(importUserDimModel);
        importUserDimModel.setUserId(this.userIdMap.get(userNum));
        importUserDimModel.setRoleId(this.roleNumIdMap.get(roleNum));
        importUserDimModel.setFileOrgId(this.orgNumIdMap.get(orgNum));
        if (data.containsKey((Object)PermTemplateFieldMap.UserRole.start_time.getKey())) {
            importUserDimModel.setValidStart(this.permInitImportService.parseDate(data.getString(PermTemplateFieldMap.UserRole.start_time.getKey())));
        }
        if (data.containsKey((Object)PermTemplateFieldMap.UserRole.end_time.getKey())) {
            importUserDimModel.setValidEnd(this.permInitImportService.parseDate(data.getString(PermTemplateFieldMap.UserRole.end_time.getKey())));
        }
        importUserDimModel.setCustomEnable(PermTemplateFieldMap.getCustomEnable(dataScope));
        Long l = this.permInitImportService.getBuId(buTypeStr);
        importUserDimModel.setBucaFuncId(l);
        if (orgNotEmpty) {
            Set<String> set2 = this.dealValueCode(orgCodeStr);
            Map<String, String> orgRangeMapContainsSub = PermRoleInitValidateService.dealValueCodeContainsSub(orgCodeStr);
            importUserDimModel.setOrgRangeList(this.permInitImportService.getBuIdByCode(set2, l));
            Map<String, DynamicObject> map = this.permInitImportService.getBuIdMapByCode(set2);
            HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject value = (DynamicObject)entry.getValue();
                if (value == null) continue;
                objectObjectHashMap.put(String.valueOf(value.getLong("id")), orgRangeMapContainsSub.get(entry.getKey()));
            }
            importUserDimModel.setOrgRangeMapContainsSub((Map)objectObjectHashMap);
        }
        if ("Y".equals(hasDim)) {
            List dim = (List)data.get((Object)"dim");
            ArrayList dimValues = Lists.newArrayListWithExpectedSize((int)dim.size());
            for (Map map : dim) {
                if (map.size() == 5) {
                    String dimVal2 = data.getString((String)map.get("oldCode"));
                    if (HRStringUtils.isEmpty((String)dimVal2)) continue;
                    Long l2 = (Long)map.get("id");
                    Long otClassifyId = Long.parseLong(String.valueOf(map.get("type")));
                    String[] val = null;
                    String dimValStr2 = dimVal2.replaceAll("\\n", "");
                    String dotStr = dimValStr2.replaceAll("\uff1b", ";").replaceAll("\u3010", "[");
                    String[] stringArray = val = dotStr.split(";");
                    int n = stringArray.length;
                    for (int key = 0; key < n; ++key) {
                        String dv = stringArray[key];
                        String[] dvs = dv.split("\\[");
                        String dimCode = dvs[0];
                        DimValueBean dimValueBean = this.getOtDimValue(oTDimValueMap, l2, dimCode = this.getDimValCode(dimCode), otClassifyId);
                        if (dimValueBean != null) {
                            if (dv.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)) {
                                dimValueBean.setValueType("2");
                                dimValueBean.setDynacondId(allDynaCondMap.get(dimCode));
                                dimValueBean.setDimVal(allDynaCondMap.get(dimCode) == null ? "" : allDynaCondMap.get(dimCode).toString());
                                dimValueBean.setDimVal(allDynaCondMap.get(dimCode) == null ? "" : allDynaCondMap.get(dimCode).toString());
                            } else {
                                dimValueBean.setValueType("1");
                                if (dv.contains(PermInitServiceHelper.getContainsSubText())) {
                                    dimValueBean.setContainsSub(true);
                                } else {
                                    dimValueBean.setContainsSub(false);
                                }
                            }
                        }
                        if (!Objects.nonNull(dimValueBean)) continue;
                        dimValues.add(dimValueBean);
                    }
                    continue;
                }
                Long dimId5 = (Long)map.get("id");
                String string = data.getString((String)map.get("code"));
                if (HRStringUtils.isEmpty((String)string)) continue;
                String[] val = null;
                dimValStr = string.replaceAll("\\n", "");
                String dotStr = dimValStr.replaceAll("\uff1b", ";").replaceAll("\u3010", "[");
                for (String dv : val = dotStr.split(";")) {
                    String[] dvs = dv.split("\\[");
                    String dimCode = dvs[0];
                    dimCode = this.getDimValCode(dimCode);
                    DimValueBean dimValueBean = this.permInitImportService.getAllDimValTip().contains(dimCode) ? new DimValueBean(dimId5, Long.valueOf(0L), null, true) : (dv.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX) ? new DimValueBean(dimId5, Long.valueOf(0L), null, false) : this.getDimValue(allDimValues, dimId5, dimCode, enmuMap));
                    if (dimValueBean != null) {
                        if (dv.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)) {
                            dimValueBean.setValueType("2");
                            dimValueBean.setDynacondId(allDynaCondMap.get(dimCode));
                            dimValueBean.setDimVal(allDynaCondMap.get(dimCode) == null ? "" : allDynaCondMap.get(dimCode).toString());
                        } else {
                            dimValueBean.setValueType("1");
                            if (dv.contains(PermInitServiceHelper.getContainsSubText())) {
                                dimValueBean.setContainsSub(true);
                            } else {
                                dimValueBean.setContainsSub(false);
                            }
                        }
                    }
                    dimValues.add(dimValueBean);
                }
            }
            importUserDimModel.setDimValues((List)dimValues);
        }
        return true;
    }

    private void checkContainsSubOrExist(Map<String, String> dimIdNameInfo, StringBuilder msg, String separator, String dimKey, List<String> noLimitedDimVals) {
        String notExistDimVal = noLimitedDimVals.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
        msg.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u503c%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff1b", (String)"PermInitImportValidateService_42", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dimIdNameInfo.get(dimKey), notExistDimVal));
    }

    private void setContainsSubNotRightMsg(Map<String, String> dimIdNameInfo, StringBuilder msg, String dimKey, List<String> dimVals) {
        Iterator<String> iteratorVals = dimVals.iterator();
        ArrayList containsSubNotRightList = Lists.newArrayListWithCapacity((int)16);
        while (iteratorVals.hasNext()) {
            String next = iteratorVals.next();
            if (!PermInitServiceHelper.isRightContainsSub(next)) continue;
            containsSubNotRightList.add(next);
            iteratorVals.remove();
        }
        for (String containsSubNotRight : containsSubNotRightList) {
            msg.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u7f16\u7801\u503c\u4e0d\u5b58\u5728\u6216\u5305\u542b\u4e0b\u7ea7\u5f55\u5165\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_52", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dimIdNameInfo.get(dimKey), containsSubNotRight));
        }
    }

    private String getDimValCode(String dimCode) {
        if (dimCode.contains(PermInitServiceHelper.getContainsSubText())) {
            dimCode = dimCode.substring(0, dimCode.lastIndexOf(PermInitServiceHelper.getContainsSubText()));
        }
        return dimCode;
    }

    private void checkDimDynaRange(Map<String, String> dimIdNameInfo, Map<String, List<String>> dimDynaRangeMap, List<String> allDynaCondNumbers, StringBuilder msg, String separator, String dimKey, List<String> dimValsWithDynaRange, Long dimId) {
        if (CollectionUtils.isNotEmpty(dimValsWithDynaRange)) {
            ArrayList dimValsWithDynaRangeCopy = Lists.newArrayList(dimValsWithDynaRange);
            dimValsWithDynaRange.removeIf(allDynaCondNumbers::contains);
            if (CollectionUtils.isNotEmpty(dimValsWithDynaRange)) {
                String notExistDimDynaCond = dimValsWithDynaRange.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
                msg.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u7684\u52a8\u6001\u6570\u636e\u8303\u56f4%2$s\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_83", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dimIdNameInfo.get(dimId.toString()), notExistDimDynaCond));
            } else {
                List<String> existDimDynas = dimDynaRangeMap.get(dimKey);
                dimValsWithDynaRangeCopy.removeIf(existDimDynas::contains);
                if (CollectionUtils.isNotEmpty((Collection)dimValsWithDynaRangeCopy)) {
                    String notApplyDimDynaCond = dimValsWithDynaRangeCopy.stream().map(it -> ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermInitImportValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{it})).collect(Collectors.joining(separator));
                    msg.append(String.format(ResManager.loadKDString((String)"\u52a8\u6001\u6570\u636e\u8303\u56f4%1$s\u4e0d\u9002\u7528\u4e8e\u201d%2$s\u201d\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_82", (String)"hrmp-hrcs-business", (Object[])new Object[0]), notApplyDimDynaCond, dimIdNameInfo.get(dimId.toString())));
                }
            }
        }
    }

    private boolean getNotExtDv(List<Triple<Long, String, Long>> triples, String number, Long structProId) {
        for (Triple<Long, String, Long> triple : triples) {
            if ((!structProId.equals(triple.getLeft()) || !number.equals(triple.getMiddle())) && (structProId.equals(1010L) || !((Long)triple.getLeft()).equals(1010L) || !number.equals(triple.getMiddle()))) continue;
            return true;
        }
        return false;
    }

    private DimValueBean getDimValue(Map<String, Map<String, String>> allDimValues, Long dimId, String dimCode, Map<Long, String> enmuMap) {
        DimValueBean dimValueBean = null;
        Map<String, String> valueMap = allDimValues.get(String.valueOf(dimId));
        if (valueMap == null) {
            return null;
        }
        String dimValue = null;
        dimValue = enmuMap.containsKey(dimId) ? dimCode : valueMap.get(dimCode);
        if (HRStringUtils.isNotEmpty((String)dimValue)) {
            dimValueBean = new DimValueBean(dimId, null, dimValue);
        }
        return dimValueBean;
    }

    private DimValueBean getOtDimValue(Map<Long, List<Triple<Long, String, Long>>> allDimValues, Long dimId, String dimCode, Long otClassifyId) {
        DimValueBean dimValueBean = null;
        List<Triple<Long, String, Long>> triples = allDimValues.get(dimId);
        if (triples == null) {
            if (dimCode.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)) {
                dimValueBean = new DimValueBean(dimId, otClassifyId, null, false, otClassifyId);
                return dimValueBean;
            }
            return null;
        }
        String dimValue = null;
        for (Triple<Long, String, Long> triple : triples) {
            if (!((String)triple.getMiddle()).equals(dimCode)) continue;
            dimValue = String.valueOf(triple.getRight());
            break;
        }
        if (HRStringUtils.isNotEmpty(dimValue)) {
            dimValueBean = new DimValueBean(dimId, otClassifyId, dimValue, false, otClassifyId);
        } else if (dimCode.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)) {
            dimValueBean = new DimValueBean(dimId, otClassifyId, null, false, otClassifyId);
        }
        return dimValueBean;
    }

    private Set<String> dealValueCode(String orgCodeStr) {
        if (HRStringUtils.isEmpty((String)orgCodeStr)) {
            return Sets.newHashSet();
        }
        String unlimited = ResManager.loadKDString((String)"\u4e0d\u9650", (String)"PermInitImportValidateService_38", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String codeStr = orgCodeStr.replaceAll("\\n", "").replaceAll("\u3010", "[");
        String dotStr = codeStr.replaceAll("\uff1b", ";");
        String[] val = dotStr.split(";");
        HashSet codeSet = Sets.newHashSetWithExpectedSize((int)val.length);
        for (String dv : val) {
            String code;
            if (dv.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)) {
                String[] dvs = dv.split("\\[");
                code = dvs[0];
                codeSet.add(code);
                continue;
            }
            if (!dv.contains("[")) {
                if (dv.equals("all") || dv.equals(unlimited) || dv.equals("All") || dv.equals("ALL") || dv.equals("aLL") || dv.equals("alL") || dv.equals("AlL") || dv.equals("aLl")) {
                    String[] dvs = dv.split("\\[");
                    code = dvs[0];
                    codeSet.add(code);
                    continue;
                }
                int index = dv.lastIndexOf(PermInitServiceHelper.getContainsSubText());
                if (index > 0) {
                    code = dv.substring(0, index);
                    codeSet.add(code);
                    continue;
                }
                codeSet.add(dv);
                continue;
            }
            String[] dvs = dv.split("\\[");
            code = dvs[0];
            String name = dvs[1];
            if (code.contains(PermInitServiceHelper.getContainsSubText())) {
                code = code.substring(0, code.lastIndexOf(PermInitServiceHelper.getContainsSubText()));
                codeSet.add(code);
                continue;
            }
            if ((name.contains("<") || name.contains(">")) && !name.contains(PermInitServiceHelper.getContainsSubText())) {
                String replaceAll = dv.replaceAll("\u3011", "]");
                if (replaceAll.contains("]")) {
                    String codePre = replaceAll.substring(0, replaceAll.indexOf("["));
                    String codeSuf = replaceAll.substring(replaceAll.indexOf("]") + 1);
                    String orignalCode = codePre + codeSuf;
                    codeSet.add(orignalCode);
                    continue;
                }
                codeSet.add(code);
                continue;
            }
            codeSet.add(code);
        }
        return codeSet;
    }
}

