/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.common.model.perminit.ImportUserBdDataRuleModel;
import kd.hr.hrcs.common.model.perminit.ImportUserDataRuleModel;
import kd.hr.hrcs.common.model.perminit.ImportUserDimModel;
import kd.hr.hrcs.common.model.perminit.ImportUserFieldModel;
import kd.hr.hrcs.common.model.perminit.PermInitRecord;

public class PermInitRecordSaveService {
    private static final Log LOGGER = LogFactory.getLog(PermInitRecordSaveService.class);
    private static final HRBaseServiceHelper PERM_INIT_HELPER = new HRBaseServiceHelper("hrcs_perminitrecord");

    public static boolean saveImportData(PermInitRecord initRecord) {
        if (CollectionUtils.isEmpty((Collection)initRecord.getUserDimModelList())) {
            LOGGER.info("userDimModelList is empty,not need to save.recordId={}", (Object)initRecord.getId());
            return true;
        }
        DynamicObject recordDyna = PERM_INIT_HELPER.loadSingle((Object)initRecord.getId());
        if (recordDyna == null) {
            LOGGER.info("perminit record not exist. recordId={}", (Object)initRecord.getId());
            return false;
        }
        DynamicObjectCollection userDimEntryColl = PermInitRecordSaveService.buildUserDimEntry(recordDyna, initRecord);
        recordDyna.set("userdimentry", (Object)userDimEntryColl);
        DynamicObjectCollection userDataRuleEntryColl = PermInitRecordSaveService.buildUserDataRuleEntry(recordDyna, initRecord);
        recordDyna.set("userdataruleentry", (Object)userDataRuleEntryColl);
        DynamicObjectCollection userBdDataRuleEntryColl = PermInitRecordSaveService.buildUserBdDataRuleEntry(recordDyna, initRecord);
        recordDyna.set("userbdentry", (Object)userBdDataRuleEntryColl);
        DynamicObjectCollection userFieldEntryColl = PermInitRecordSaveService.buildUserFieldEntry(recordDyna, initRecord);
        recordDyna.set("userfieldentry", (Object)userFieldEntryColl);
        recordDyna.set("initnumber", (Object)userDimEntryColl.size());
        PERM_INIT_HELPER.saveOne(recordDyna);
        return true;
    }

    private static DynamicObjectCollection buildUserDimEntry(DynamicObject recordDyna, PermInitRecord initRecord) {
        DynamicObjectCollection userDimEntryColl = PERM_INIT_HELPER.generateEmptyEntryCollection(recordDyna, "userdimentry");
        if (CollectionUtils.isEmpty((Collection)initRecord.getUserDimModelList())) {
            return userDimEntryColl;
        }
        for (ImportUserDimModel userDimModel : initRecord.getUserDimModelList()) {
            DynamicObject userDimEntryDyna = PERM_INIT_HELPER.generateEmptyEntryDynamicObject("userdimentry");
            userDimEntryDyna.set("dim_user", (Object)userDimModel.getUserId());
            userDimEntryDyna.set("dim_fileorg", (Object)userDimModel.getFileOrgId());
            userDimEntryDyna.set("dim_role", (Object)userDimModel.getRoleId());
            userDimEntryDyna.set("dim_validstart", (Object)userDimModel.getValidStart());
            userDimEntryDyna.set("dim_validend", (Object)userDimModel.getValidEnd());
            userDimEntryDyna.set("dim_customenable", (Object)userDimModel.getCustomEnableStr());
            userDimEntryDyna.set("dim_bucafunc", (Object)userDimModel.getBucaFuncId());
            userDimEntryDyna.set("dim_errormsg", (Object)userDimModel.getErrorMsg());
            if (userDimModel.getCustomEnable()) {
                if (CollectionUtils.isNotEmpty((Collection)userDimModel.getOrgRangeList())) {
                    Map orgRangeMapContainsSub = userDimModel.getOrgRangeMapContainsSub();
                    DynamicObjectCollection orgRangeColl = userDimEntryDyna.getDynamicObjectCollection("dim_orgrange");
                    DynamicObjectType orgRangeType = orgRangeColl.getDynamicObjectType();
                    for (Long orgId : userDimModel.getOrgRangeList()) {
                        DynamicObject orgDyna = new DynamicObject(orgRangeType);
                        orgDyna.set("fbasedataid", (Object)orgId);
                        orgRangeColl.add((Object)orgDyna);
                    }
                    userDimEntryDyna.set("dim_orgcontainssubstr", (Object)SerializationUtils.toJsonString((Object)orgRangeMapContainsSub));
                }
                if (CollectionUtils.isNotEmpty((Collection)userDimModel.getDimValues())) {
                    DynamicObjectCollection dimvalSubEntryColl = userDimEntryDyna.getDynamicObjectCollection("userdimvalueentry");
                    DynamicObjectType dimvalType = dimvalSubEntryColl.getDynamicObjectType();
                    for (DimValueBean dimValue : userDimModel.getDimValues()) {
                        DynamicObject dimvalDyna = new DynamicObject(dimvalType);
                        dimvalDyna.set("dim_dimension", (Object)dimValue.getDimId());
                        dimvalDyna.set("dim_otclassify", (Object)dimValue.getOtClassifyId());
                        dimvalDyna.set("dim_dimval", (Object)dimValue.getDimVal());
                        dimvalDyna.set("dim_isall", (Object)dimValue.isAll());
                        dimvalDyna.set("dim_containssub", (Object)dimValue.isContainsSub());
                        dimvalDyna.set("dim_structproject", (Object)dimValue.getStructProjectId());
                        dimvalDyna.set("dim_valtype", (Object)dimValue.getValueType());
                        dimvalDyna.set("dim_dynacond", (Object)dimValue.getDynacondId());
                        dimvalSubEntryColl.add((Object)dimvalDyna);
                    }
                }
            }
            userDimEntryColl.add((Object)userDimEntryDyna);
        }
        return userDimEntryColl;
    }

    private static DynamicObjectCollection buildUserDataRuleEntry(DynamicObject recordDyna, PermInitRecord initRecord) {
        DynamicObjectCollection userDataRuleEntryColl = PERM_INIT_HELPER.generateEmptyEntryCollection(recordDyna, "userdataruleentry");
        if (CollectionUtils.isEmpty((Collection)initRecord.getUserDataRuleModelList())) {
            return userDataRuleEntryColl;
        }
        for (ImportUserDataRuleModel userDataRuleModel : initRecord.getUserDataRuleModelList()) {
            DynamicObject userDataRuleEntryDyna = PERM_INIT_HELPER.generateEmptyEntryDynamicObject("userdataruleentry");
            userDataRuleEntryDyna.set("dr_user", (Object)userDataRuleModel.getUserId());
            userDataRuleEntryDyna.set("dr_fileorg", (Object)userDataRuleModel.getFileOrgId());
            userDataRuleEntryDyna.set("dr_role", (Object)userDataRuleModel.getRoleId());
            userDataRuleEntryDyna.set("dr_errormsg", (Object)userDataRuleModel.getErrorMsg());
            userDataRuleEntryDyna.set("dr_app", (Object)userDataRuleModel.getAppId());
            userDataRuleEntryDyna.set("dr_entitytype", (Object)userDataRuleModel.getEntityNumber());
            userDataRuleEntryDyna.set("dr_datarule", (Object)userDataRuleModel.getDataRuleId());
            DynamicObjectCollection permItemColl = userDataRuleEntryDyna.getDynamicObjectCollection("dr_permitemmulti");
            DynamicObjectType permItemType = permItemColl.getDynamicObjectType();
            for (String permItemId : userDataRuleModel.getPermItemList()) {
                DynamicObject permItemDyna = new DynamicObject(permItemType);
                permItemDyna.set("fbasedataid", (Object)permItemId);
                permItemColl.add((Object)permItemDyna);
            }
            userDataRuleEntryColl.add((Object)userDataRuleEntryDyna);
        }
        return userDataRuleEntryColl;
    }

    private static DynamicObjectCollection buildUserBdDataRuleEntry(DynamicObject recordDyna, PermInitRecord initRecord) {
        DynamicObjectCollection userBdDataRuleEntryColl = PERM_INIT_HELPER.generateEmptyEntryCollection(recordDyna, "userbdentry");
        if (CollectionUtils.isEmpty((Collection)initRecord.getUserBdDataRuleModelList())) {
            return userBdDataRuleEntryColl;
        }
        for (ImportUserBdDataRuleModel userBdDataRuleModel : initRecord.getUserBdDataRuleModelList()) {
            DynamicObject userBdDataRuleEntryDyna = PERM_INIT_HELPER.generateEmptyEntryDynamicObject("userbdentry");
            userBdDataRuleEntryDyna.set("bd_user", (Object)userBdDataRuleModel.getUserId());
            userBdDataRuleEntryDyna.set("bd_fileorg", (Object)userBdDataRuleModel.getFileOrgId());
            userBdDataRuleEntryDyna.set("bd_role", (Object)userBdDataRuleModel.getRoleId());
            userBdDataRuleEntryDyna.set("bd_errormsg", (Object)userBdDataRuleModel.getErrorMsg());
            userBdDataRuleEntryDyna.set("bd_app", (Object)userBdDataRuleModel.getAppId());
            userBdDataRuleEntryDyna.set("bd_entitytype", (Object)userBdDataRuleModel.getEntityNumber());
            userBdDataRuleEntryDyna.set("bd_propkey", (Object)userBdDataRuleModel.getPropKey());
            userBdDataRuleEntryDyna.set("bd_propentnum", (Object)userBdDataRuleModel.getPropEntNum());
            userBdDataRuleEntryDyna.set("bd_datarule", (Object)userBdDataRuleModel.getDataRuleId());
            userBdDataRuleEntryColl.add((Object)userBdDataRuleEntryDyna);
        }
        return userBdDataRuleEntryColl;
    }

    private static DynamicObjectCollection buildUserFieldEntry(DynamicObject recordDyna, PermInitRecord initRecord) {
        DynamicObjectCollection userFieldEntryColl = PERM_INIT_HELPER.generateEmptyEntryCollection(recordDyna, "userfieldentry");
        if (CollectionUtils.isEmpty((Collection)initRecord.getUserFieldModelList())) {
            return userFieldEntryColl;
        }
        for (ImportUserFieldModel userFieldModel : initRecord.getUserFieldModelList()) {
            DynamicObject userFieldEntryDyna = PERM_INIT_HELPER.generateEmptyEntryDynamicObject("userfieldentry");
            userFieldEntryDyna.set("field_user", (Object)userFieldModel.getUserId());
            userFieldEntryDyna.set("field_fileorg", (Object)userFieldModel.getFileOrgId());
            userFieldEntryDyna.set("field_role", (Object)userFieldModel.getRoleId());
            userFieldEntryDyna.set("field_errormsg", (Object)userFieldModel.getErrorMsg());
            userFieldEntryDyna.set("field_app", (Object)userFieldModel.getAppId());
            userFieldEntryDyna.set("field_entitytype", (Object)userFieldModel.getEntityNumber());
            userFieldEntryDyna.set("field_propkey", (Object)userFieldModel.getPropKey());
            userFieldEntryDyna.set("field_canread", (Object)PermInitRecordSaveService.getFieldStatusStr(userFieldModel.isCanRead()));
            userFieldEntryDyna.set("field_canwrite", (Object)PermInitRecordSaveService.getFieldStatusStr(userFieldModel.isCanWrite()));
            userFieldEntryColl.add((Object)userFieldEntryDyna);
        }
        return userFieldEntryColl;
    }

    private static String getFieldStatusStr(Boolean can) {
        if (can.booleanValue()) {
            return "1";
        }
        return "0";
    }
}

