/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.init.PermInitImportService;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleFuncService;
import kd.hr.hrcs.common.model.perminit.DataRangeInitModel;
import kd.hr.hrcs.common.model.perminit.DimInitCheckedBO;
import kd.hr.hrcs.common.model.perminit.DimInitModel;
import kd.hr.hrcs.common.model.perminit.ExcelCellInfo;
import kd.hr.hrcs.common.model.perminit.FieldPermInitModel;
import kd.hr.hrcs.common.model.perminit.FunctionItemInitModel;
import kd.hr.hrcs.common.model.perminit.PermRoleInitRecord;
import kd.hr.hrcs.common.model.perminit.RoleInitModel;
import org.apache.commons.lang3.tuple.Pair;

public class PermRoleDataPckService {
    private Set<String> roleSet;
    private Map<String, Map<Integer, String>> logMap = Maps.newHashMapWithExpectedSize((int)16);
    private Set<String> errorRoleSet = Sets.newHashSetWithExpectedSize((int)16);
    private Map<String, Integer> funcRoleMap;
    private Map<Integer, List<Pair<Integer, String>>> colErrorMap;
    private boolean hasErrorLine = false;
    private Map<String, Set<String>> roleCountMap;
    private Map<Integer, String> dimErrorMap;
    List<ExcelCellInfo> roleFunList;
    private Map<String, List<String>> dimMustMap;

    public PermRoleDataPckService(Set<String> roleSet) {
        this.roleSet = roleSet;
    }

    public PermRoleInitRecord getExcelRowData(List<ImportBillData> rowDataList, Long id, Map<String, Map<Integer, String>> logMap, Map<String, Integer> funcRoleMap, Map<Integer, List<Pair<Integer, String>>> colErrorMap, Table<String, Integer, List<ExcelCellInfo>> headerTb, Map<String, Set<String>> roleMap, Map<Integer, String> dimErrorMap, List<ExcelCellInfo> roleFunList, Map<String, List<String>> dimMustMap) {
        PermRoleInitRecord permRoleInitRecord = new PermRoleInitRecord();
        permRoleInitRecord.setId(id);
        this.logMap = logMap;
        this.funcRoleMap = funcRoleMap;
        this.colErrorMap = colErrorMap;
        this.roleCountMap = roleMap;
        this.dimErrorMap = dimErrorMap;
        this.roleFunList = roleFunList;
        this.dimMustMap = dimMustMap;
        List excelCellInfos = (List)headerTb.get((Object)"importRoleList", (Object)2);
        if (CollectionUtils.isNotEmpty((Collection)excelCellInfos)) {
            this.hasErrorLine = ((ExcelCellInfo)excelCellInfos.get(2)).isHasErrorLine();
        }
        HashMap errRoleMap = Maps.newHashMapWithExpectedSize((int)16);
        List<ImportBillData> roleList = rowDataList.stream().filter(it -> it.getData().getString("sheetKey").equals("importRoleList")).collect(Collectors.toList());
        List<ImportBillData> roleFuncPermList = rowDataList.stream().filter(it -> it.getData().getString("sheetKey").equals("importRoleFunc")).collect(Collectors.toList());
        List<ImportBillData> roleDimList = rowDataList.stream().filter(it -> it.getData().getString("sheetKey").equals("importRoleDim")).collect(Collectors.toList());
        List<ImportBillData> roleDataRangeList = rowDataList.stream().filter(it -> it.getData().getString("sheetKey").equals("importRoleDataRange")).collect(Collectors.toList());
        List<ImportBillData> roleFieldList = rowDataList.stream().filter(it -> it.getData().getString("sheetKey").equals("importRoleFp")).collect(Collectors.toList());
        permRoleInitRecord.setRoleInitModelList(this.getExcelRoleList(roleList, errRoleMap));
        permRoleInitRecord.setFunctionItemInitModelList(this.getExcelRoleFuncPerm(roleFuncPermList, errRoleMap));
        permRoleInitRecord.setDimInitModelList(this.getExcelRoleDim(roleDimList));
        permRoleInitRecord.setDataRangeInitModelList(this.getExcelRoleDataRange(roleDataRangeList));
        permRoleInitRecord.setFieldPermInitModelList(this.getExcelRoleField(roleFieldList));
        permRoleInitRecord.setErrorRoleSet(this.errorRoleSet);
        return permRoleInitRecord;
    }

    private List<DataRangeInitModel> getExcelRoleDataRange(List<ImportBillData> roleDataRangeList) {
        ArrayList dataRangeInitModelList = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(roleDataRangeList)) {
            return dataRangeInitModelList;
        }
        int roleCount = 0;
        HashMap checkEmptyRow = Maps.newHashMapWithExpectedSize((int)16);
        this.logMap.put("importRoleDataRange", checkEmptyRow);
        for (ImportBillData importBillData : roleDataRangeList) {
            JSONObject data = importBillData.getData();
            int rowNum = data.getInteger("rowNum");
            DataRangeInitModel dataRangeInitModel = new DataRangeInitModel();
            dataRangeInitModel.setRowNum(Integer.valueOf(rowNum));
            dataRangeInitModel.setRoleNumber(data.getString("roleNumber"));
            if (HRStringUtils.isNotEmpty((String)dataRangeInitModel.getRoleNumber())) {
                this.roleCountMap.computeIfAbsent("importRoleDataRange", key -> Sets.newHashSet()).add(dataRangeInitModel.getRoleNumber());
            } else {
                this.roleCountMap.computeIfAbsent("importRoleDataRange", key -> Sets.newHashSet()).add(String.valueOf(roleCount++));
            }
            dataRangeInitModel.setRoleName(data.getString("roleName"));
            dataRangeInitModel.setOrgRange(data.getString("orgRange"));
            dataRangeInitModel.setBuCaFuncName(data.getString("buCaFuncName"));
            HashMap dimMap = Maps.newHashMapWithExpectedSize((int)16);
            JSONArray dim = data.getJSONArray("dim");
            if (Objects.nonNull(dim)) {
                for (Object obj : dim) {
                    String key2;
                    HashMap dimCode = (HashMap)obj;
                    String ot = (String)dimCode.get("ot");
                    if (HRStringUtils.equals((String)"Y", (String)ot)) {
                        key2 = dimCode.get("id") + "#" + dimCode.get("type");
                        dimMap.put(key2, data.getString((String)dimCode.get("oldCode")));
                        continue;
                    }
                    key2 = String.valueOf(dimCode.get("id"));
                    dimMap.put(key2, data.getString((String)dimCode.get("code")));
                }
            }
            dataRangeInitModel.setStructValueMap((Map)dimMap);
            if (!this.checkEmptyDataRangeRow(dataRangeInitModel, checkEmptyRow)) continue;
            dataRangeInitModelList.add(dataRangeInitModel);
        }
        return dataRangeInitModelList;
    }

    private List<DimInitModel> getExcelRoleDim(List<ImportBillData> roleDimList) {
        ArrayList dimInitModelList = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(roleDimList)) {
            return dimInitModelList;
        }
        HashMap checkEmptyRow = Maps.newHashMapWithExpectedSize((int)16);
        this.logMap.put("importRoleDim", checkEmptyRow);
        int roleCount = 0;
        Map<String, Long> dims = new PermInitImportService().getDims(true);
        for (ImportBillData importBillData : roleDimList) {
            JSONObject data = importBillData.getData();
            int rowNum = data.getInteger("rowNum");
            HashMap dimCheckedMap = Maps.newHashMapWithExpectedSize((int)16);
            DimInitModel dimInitModel = new DimInitModel();
            dimInitModel.setRowNum(Integer.valueOf(rowNum));
            dimInitModel.setRoleNumber(data.getString("roleNumber"));
            if (HRStringUtils.isNotEmpty((String)dimInitModel.getRoleNumber())) {
                this.roleCountMap.computeIfAbsent("importRoleDim", key -> Sets.newHashSet()).add(dimInitModel.getRoleNumber());
            } else {
                this.roleCountMap.computeIfAbsent("importRoleDim", key -> Sets.newHashSet()).add(String.valueOf(roleCount++));
            }
            dimInitModel.setRoleName(data.getString("roleName"));
            dimInitModel.setBuCaFuncName(data.getString("buCaFuncName"));
            JSONObject column = data.getJSONObject("column");
            JSONObject dimExcelName = data.getJSONObject("dimExcelName");
            for (String dimCode : dimExcelName.keySet()) {
                DimInitCheckedBO dimInitCheckedBO = new DimInitCheckedBO();
                dimInitCheckedBO.setDimName(dimExcelName.getString(dimCode));
                dimInitCheckedBO.setColNum(column.getInteger(dimCode));
                dimInitCheckedBO.setDimId(dims.get(dimCode));
                dimCheckedMap.put(dimCode, dimInitCheckedBO);
                String check = data.getString(dimCode);
                if (HRStringUtils.isNotEmpty((String)check) && !"\u221a".equals(check)) {
                    dimInitCheckedBO.setCheck(Boolean.valueOf(false));
                    this.dimErrorMap.put(rowNum, ResManager.loadKDString((String)"\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u8bf7\u6309\u8981\u6c42\u6253\u221a\u9009\u62e9\u7ef4\u5ea6\u5217\u3002", (String)"PermRoleDataPckService_24", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                    continue;
                }
                dimInitCheckedBO.setCheck(Boolean.valueOf(HRStringUtils.isNotEmpty((String)check) && "\u221a".equals(check)));
            }
            dimInitModel.setDimCheckedMap((Map)dimCheckedMap);
            if (this.checkEmptyDimRow(dimInitModel, checkEmptyRow)) {
                dimInitModelList.add(dimInitModel);
                continue;
            }
            this.errorRoleSet.add(dimInitModel.getRoleNumber());
        }
        return dimInitModelList;
    }

    private List<FieldPermInitModel> getExcelRoleField(List<ImportBillData> roleFieldList) {
        ArrayList fieldPermInitModelList = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(roleFieldList)) {
            return fieldPermInitModelList;
        }
        HashMap checkEmptyRow = Maps.newHashMapWithExpectedSize((int)16);
        this.logMap.put("importRoleFp", checkEmptyRow);
        int roleCount = 0;
        for (ImportBillData importBillData : roleFieldList) {
            JSONObject data = importBillData.getData();
            int rowNum = data.getInteger("rowNum");
            FieldPermInitModel fieldPermInitModel = new FieldPermInitModel();
            fieldPermInitModel.setRowNum(Integer.valueOf(rowNum));
            fieldPermInitModel.setRoleNumber(data.getString("roleNumber"));
            if (HRStringUtils.isNotEmpty((String)fieldPermInitModel.getRoleNumber())) {
                this.roleCountMap.computeIfAbsent("importRoleFp", key -> Sets.newHashSet()).add(fieldPermInitModel.getRoleNumber());
            } else {
                this.roleCountMap.computeIfAbsent("importRoleFp", key -> Sets.newHashSet()).add(String.valueOf(roleCount++));
            }
            fieldPermInitModel.setRoleName(data.getString("roleName"));
            fieldPermInitModel.setAppNum(data.getString("appNum"));
            fieldPermInitModel.setAppName(data.getString("appName"));
            fieldPermInitModel.setEntityNum(data.getString("entityNum"));
            fieldPermInitModel.setEntityName(data.getString("entityName"));
            fieldPermInitModel.setFieldNumber(data.getString("fieldNumber"));
            fieldPermInitModel.setFieldName(data.getString("fieldName"));
            fieldPermInitModel.setView(data.getString("view"));
            fieldPermInitModel.setEdit(data.getString("edit"));
            if (!this.checkEmptyFieldRow(fieldPermInitModel, checkEmptyRow)) continue;
            fieldPermInitModelList.add(fieldPermInitModel);
        }
        return fieldPermInitModelList;
    }

    private List<FunctionItemInitModel> getExcelRoleFuncPerm(List<ImportBillData> roleFuncPermList, Map<Integer, String> errRoleMap) {
        ArrayList functionItemInitModelList = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(roleFuncPermList)) {
            this.initFuncList(functionItemInitModelList);
            return functionItemInitModelList;
        }
        HashSet entitySet = Sets.newHashSetWithExpectedSize((int)16);
        this.roleCountMap.put("importRoleFunc", this.roleCountMap.get("importRoleList"));
        HashMap checkEmptyRow = Maps.newHashMapWithExpectedSize((int)16);
        this.logMap.put("importRoleFunc", checkEmptyRow);
        for (ImportBillData importBillData : roleFuncPermList) {
            FunctionItemInitModel functionItemInitModel = new FunctionItemInitModel();
            JSONObject data = importBillData.getData();
            int rowNum = data.getInteger("rowNum");
            if (this.hasErrorLine && rowNum == 4) continue;
            entitySet.add(data.getString("entityNum"));
            functionItemInitModel.setRowNum(Integer.valueOf(rowNum));
            functionItemInitModel.setCloudNum(data.getString("cloudNum"));
            functionItemInitModel.setCloudName(data.getString("cloudName"));
            functionItemInitModel.setAppNum(data.getString("appNum"));
            functionItemInitModel.setAppName(data.getString("appName"));
            functionItemInitModel.setEntityNum(data.getString("entityNum"));
            functionItemInitModel.setEntityName(data.getString("entityName"));
            functionItemInitModel.setName(data.getString("name"));
            functionItemInitModel.setBuCaFuncName(data.getString("buCaFuncName"));
            HashMap roleCheckedMap = Maps.newHashMapWithExpectedSize((int)16);
            JSONObject column = data.getJSONObject("column");
            if (this.hasErrorLine) {
                for (String roleNum : this.roleSet) {
                    Optional<ExcelCellInfo> any = this.roleFunList.stream().filter(it -> HRStringUtils.isNotEmpty((String)it.getName()) && it.getName().equals(roleNum)).findAny();
                    if (!any.isPresent()) continue;
                    int colIndex = any.get().getColIndex();
                    String check = data.getString(colIndex + "");
                    if (HRStringUtils.isNotEmpty((String)check) && !"\u221a".equals(check)) {
                        ArrayList pairs = this.colErrorMap.get(rowNum);
                        if (pairs == null) {
                            pairs = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)colIndex, (Object)ResManager.loadKDString((String)"\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u8bf7\u6309\u8981\u6c42\u6253\u221a\u9009\u62e9\u6743\u9650\u9879\u3002", (String)"PermRoleDataPckService_23", (String)"hrmp-hrcs-business", (Object[])new Object[0]))});
                        } else {
                            pairs.add((Pair<Integer, String>)Pair.of((Object)colIndex, (Object)ResManager.loadKDString((String)"\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u8bf7\u6309\u8981\u6c42\u6253\u221a\u9009\u62e9\u6743\u9650\u9879\u3002", (String)"PermRoleDataPckService_23", (String)"hrmp-hrcs-business", (Object[])new Object[0])));
                        }
                        this.colErrorMap.put(rowNum, pairs);
                        continue;
                    }
                    if ("\u221a".equals(check)) {
                        roleCheckedMap.put(roleNum, Pair.of((Object)colIndex, (Object)true));
                        continue;
                    }
                    roleCheckedMap.put(roleNum, Pair.of((Object)colIndex, (Object)false));
                }
            } else {
                for (String roleNum : this.roleSet) {
                    String check = data.getString(roleNum);
                    Integer integer = column.getInteger(roleNum);
                    if (HRStringUtils.isNotEmpty((String)check) && !"\u221a".equals(check)) {
                        ArrayList pairs = this.colErrorMap.get(rowNum);
                        if (pairs == null) {
                            pairs = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)integer, (Object)ResManager.loadKDString((String)"\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u8bf7\u6309\u8981\u6c42\u6253\u221a\u9009\u62e9\u6743\u9650\u9879\u3002", (String)"PermRoleDataPckService_23", (String)"hrmp-hrcs-business", (Object[])new Object[0]))});
                        } else {
                            pairs.add((Pair<Integer, String>)Pair.of((Object)integer, (Object)ResManager.loadKDString((String)"\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u8bf7\u6309\u8981\u6c42\u6253\u221a\u9009\u62e9\u6743\u9650\u9879\u3002", (String)"PermRoleDataPckService_23", (String)"hrmp-hrcs-business", (Object[])new Object[0])));
                        }
                        this.colErrorMap.put(rowNum, pairs);
                        continue;
                    }
                    if ("\u221a".equals(check)) {
                        roleCheckedMap.put(roleNum, Pair.of((Object)integer, (Object)true));
                        continue;
                    }
                    roleCheckedMap.put(roleNum, Pair.of((Object)integer, (Object)false));
                }
            }
            functionItemInitModel.setRoleCheckedMap((Map)roleCheckedMap);
            if (this.checkEmptyFuncRow(functionItemInitModel, checkEmptyRow) && !this.colErrorMap.containsKey(rowNum)) {
                functionItemInitModelList.add(functionItemInitModel);
            }
            this.initFuncList(functionItemInitModelList);
        }
        this.dimMustMap.putAll(this.initDimMap(entitySet));
        this.initEmpRoleErr(errRoleMap);
        return functionItemInitModelList;
    }

    private Map<String, List<String>> initDimMap(Set<String> entitySet) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, DynamicObject> dimMap = new PermRoleFuncService().getDimMap(entitySet);
        if (dimMap != null) {
            for (Map.Entry<String, DynamicObject> entry : dimMap.entrySet()) {
                DynamicObjectCollection dimEntry = entry.getValue().getDynamicObjectCollection("entryentity");
                for (DynamicObject row : dimEntry) {
                    boolean isMust = row.getBoolean("ismust");
                    String name = row.getString("dimension.name");
                    if (!isMust) continue;
                    List dimList = result.computeIfAbsent(entry.getKey(), key -> Lists.newArrayListWithExpectedSize((int)16));
                    dimList.add(name);
                }
            }
            return result;
        }
        return Maps.newHashMap();
    }

    private void initEmpRoleErr(Map<Integer, String> errRoleMap) {
        if (errRoleMap != null && errRoleMap.size() > 0) {
            errRoleMap.forEach((key, value) -> {
                List<Pair<Integer, String>> pairs = this.colErrorMap.get(4);
                if (pairs != null && pairs.size() > 0) {
                    Optional<Pair> first = pairs.stream().filter(it -> ((Integer)it.getLeft()).equals(key)).findFirst();
                    if (first.isPresent()) {
                        Pair pair = first.get();
                        String concat = ((String)pair.getRight()).concat((String)value);
                        pair.setValue((Object)concat);
                    } else {
                        pairs.add((Pair<Integer, String>)Pair.of((Object)key, (Object)value));
                    }
                } else {
                    this.colErrorMap.put(4, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)key, (Object)value)}));
                }
            });
        }
    }

    private void initFuncList(List<FunctionItemInitModel> functionItemInitModelList) {
        if (functionItemInitModelList.size() == 0) {
            FunctionItemInitModel funcInitModel = new FunctionItemInitModel();
            HashMap roleCheckedMap = Maps.newHashMapWithExpectedSize((int)16);
            this.funcRoleMap.forEach((key, value) -> roleCheckedMap.put(key, Pair.of((Object)value, (Object)false)));
            funcInitModel.setRoleCheckedMap((Map)roleCheckedMap);
            funcInitModel.setRowNum(Integer.valueOf(4));
            functionItemInitModelList.add(funcInitModel);
        }
    }

    private List<RoleInitModel> getExcelRoleList(List<ImportBillData> roleList, Map<Integer, String> errRoleMap) {
        ArrayList roleInitModelList = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(roleList)) {
            return roleInitModelList;
        }
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        Lang lang = RequestContext.get().getLang();
        HashMap checkEmptyRow = Maps.newHashMapWithExpectedSize((int)16);
        this.logMap.put("importRoleList", checkEmptyRow);
        int roleCount = 0;
        for (ImportBillData importBillData : roleList) {
            HashMap mulLangMap = Maps.newHashMapWithExpectedSize((int)4);
            RoleInitModel roleInitModel = new RoleInitModel();
            JSONObject data = importBillData.getData();
            int rowNum = data.getInteger("rowNum");
            roleInitModel.setRowNum(Integer.valueOf(rowNum));
            roleInitModel.setRoleNumber(data.getString("roleNumber"));
            roleInitModel.setRoleName((ILocaleString)new LocaleString(data.getString("roleName_" + lang.name())));
            this.dealExcelMulLangValue(enabledLangList, mulLangMap, data);
            roleInitModel.setRoleRemark((ILocaleString)new LocaleString("roleRemark_" + lang.name()));
            roleInitModel.setMulLangMap((Map)mulLangMap);
            roleInitModel.setRoleGroupNumber(data.getString("roleGroupNumber"));
            if (HRStringUtils.isNotEmpty((String)roleInitModel.getRoleNumber())) {
                this.roleCountMap.computeIfAbsent("importRoleList", key -> Sets.newHashSet()).add(roleInitModel.getRoleNumber());
            } else {
                this.roleCountMap.computeIfAbsent("importRoleList", key -> Sets.newHashSet()).add(String.valueOf(roleCount++));
            }
            roleInitModel.setRoleGroupName(data.getString("roleGroupName"));
            roleInitModel.setRoleProperty(data.getString("roleProperty"));
            roleInitModel.setRoleCBisIntersection(data.getString("roleCBisIntersection"));
            roleInitModel.setUseScope(data.getString("useScope"));
            roleInitModel.setCreateAdminGrpNumber(data.getString("createAdminGrpNumber"));
            roleInitModel.setCreateAdminGrpName(data.getString("createAdminGrpName"));
            roleInitModel.setOpenRangeWithView(data.getString("openRangeWithView"));
            roleInitModel.setOpenRangeWithEdit(data.getString("openRangeWithEdit"));
            if (!this.checkEmptyRoleListRow(roleInitModel, checkEmptyRow, errRoleMap)) continue;
            roleInitModelList.add(roleInitModel);
        }
        return roleInitModelList;
    }

    private int getFunCol(int roleRowNum) {
        if (this.hasErrorLine) {
            return roleRowNum + 5;
        }
        return roleRowNum + 4;
    }

    private boolean checkEmptyRoleListRow(RoleInitModel roleInitModel, Map<Integer, String> checkEmptyRow, Map<Integer, String> errRoleMap) {
        String errMsg = ResManager.loadKDString((String)"\u201c\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u201d\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u89d2\u8272\uff0c\u6216\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        StringBuilder msg = new StringBuilder();
        if (HRStringUtils.isEmpty((String)roleInitModel.getRoleNumber())) {
            msg.append(ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801\u3001", (String)"PermRoleDataPckService_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            errRoleMap.put(this.getFunCol(roleInitModel.getRowNum()), errMsg);
        }
        if (Objects.isNull(roleInitModel.getRoleName().getLocaleValue())) {
            msg.append(ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0\u3001", (String)"PermRoleDataPckService_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)roleInitModel.getRoleProperty())) {
            msg.append(ResManager.loadKDString((String)"\u89d2\u8272\u6210\u5458\u8303\u56f4\u5c5e\u6027\u3001", (String)"PermRoleDataPckService_12", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)roleInitModel.getUseScope())) {
            msg.append(ResManager.loadKDString((String)"\u516c\u5f00\u72b6\u6001\u3001", (String)"PermRoleDataPckService_14", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        boolean result = true;
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            msg.append(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PermRoleDataPckService_15", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            result = false;
        }
        if (HRStringUtils.isNotEmpty((String)roleInitModel.getRoleNumber()) && roleInitModel.getRoleNumber().length() > 30) {
            msg.append(ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801\u8d85\u8fc730\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PermRoleDataPckService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            result = false;
        }
        if (HRStringUtils.isNotEmpty((String)roleInitModel.getRoleName().getLocaleValue()) && roleInitModel.getRoleName().getLocaleValue().length() > 50) {
            msg.append(ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0\u8d85\u8fc750\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\uff1b", (String)"PermRoleDataPckService_22", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            result = false;
        }
        if (!result) {
            checkEmptyRow.put(roleInitModel.getRowNum(), msg.toString());
        }
        return result;
    }

    private boolean checkEmptyFuncRow(FunctionItemInitModel functionItemInitModel, Map<Integer, String> checkEmptyRow) {
        StringBuilder msg = new StringBuilder();
        if (HRStringUtils.isEmpty((String)functionItemInitModel.getAppNum())) {
            msg.append(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u3001", (String)"PermRoleDataPckService_16", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)functionItemInitModel.getEntityNum())) {
            msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u3001", (String)"PermRoleDataPckService_17", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)functionItemInitModel.getName())) {
            msg.append(ResManager.loadKDString((String)"\u6743\u9650\u9879\u3001", (String)"PermRoleDataPckService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            msg.append(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PermRoleDataPckService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            checkEmptyRow.put(functionItemInitModel.getRowNum(), msg.toString());
            return false;
        }
        return true;
    }

    private boolean checkEmptyDimRow(DimInitModel dimInitModel, Map<Integer, String> checkEmptyRow) {
        StringBuilder msg = new StringBuilder();
        if (HRStringUtils.isEmpty((String)dimInitModel.getRoleNumber())) {
            msg.append(ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801\u3001", (String)"PermRoleDataPckService_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)dimInitModel.getBuCaFuncName())) {
            msg.append(ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b\u3001", (String)"PermRoleDataPckService_19", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            msg.append(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PermRoleDataPckService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            checkEmptyRow.put(dimInitModel.getRowNum(), msg.toString());
            return false;
        }
        return true;
    }

    private boolean checkEmptyDataRangeRow(DataRangeInitModel dataRangeInitModel, Map<Integer, String> checkEmptyRow) {
        StringBuilder msg = new StringBuilder();
        if (HRStringUtils.isEmpty((String)dataRangeInitModel.getRoleNumber())) {
            msg.append(ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801\u3001", (String)"PermRoleDataPckService_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)dataRangeInitModel.getBuCaFuncName())) {
            msg.append(ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b\u3001", (String)"PermRoleDataPckService_19", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)dataRangeInitModel.getOrgRange())) {
            msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u3001", (String)"PermRoleDataPckService_20", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            msg.append(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PermRoleDataPckService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            checkEmptyRow.put(dataRangeInitModel.getRowNum(), msg.toString());
            return false;
        }
        return true;
    }

    private boolean checkEmptyFieldRow(FieldPermInitModel fieldPermInitModel, Map<Integer, String> checkEmptyRow) {
        StringBuilder msg = new StringBuilder();
        if (HRStringUtils.isEmpty((String)fieldPermInitModel.getRoleNumber())) {
            msg.append(ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801\u3001", (String)"PermRoleDataPckService_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)fieldPermInitModel.getAppNum())) {
            msg.append(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u3001", (String)"PermRoleDataPckService_16", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)fieldPermInitModel.getEntityNum())) {
            msg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u3001", (String)"PermRoleDataPckService_17", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)fieldPermInitModel.getFieldNumber())) {
            msg.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u5c5e\u6027\u3001", (String)"PermRoleDataPckService_13", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)fieldPermInitModel.getView())) {
            msg.append(ResManager.loadKDString((String)"\u67e5\u770b\u3001", (String)"PermRoleDataPckService_25", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)fieldPermInitModel.getEdit())) {
            msg.append(ResManager.loadKDString((String)"\u7f16\u8f91\u3001", (String)"PermRoleDataPckService_26", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
            msg.append(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PermRoleDataPckService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            checkEmptyRow.put(fieldPermInitModel.getRowNum(), msg.toString());
            return false;
        }
        return true;
    }

    private void dealExcelMulLangValue(List<EnabledLang> enabledLangList, Map<String, String> mulLangMap, JSONObject data) {
        for (EnabledLang enabledLang : enabledLangList) {
            String roleNameKey = "roleName_" + enabledLang.getNumber();
            String remarkKey = "roleRemark_" + enabledLang.getNumber();
            mulLangMap.put(roleNameKey, data.getString(roleNameKey));
            mulLangMap.put(remarkKey, data.getString(remarkKey));
        }
    }

    public String getUseScope(String useScope) {
        HashMap useScopeMap = Maps.newHashMapWithExpectedSize((int)4);
        useScopeMap.put(ResManager.loadKDString((String)"\u79c1\u6709", (String)"PermRoleDataPckService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "0");
        useScopeMap.put(ResManager.loadKDString((String)"\u5206\u914d", (String)"PermRoleDataPckService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "1");
        useScopeMap.put(ResManager.loadKDString((String)"\u516c\u5f00", (String)"PermRoleDataPckService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "2");
        return (String)useScopeMap.get(useScope);
    }

    public String getRoleProperty(String pro) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        resultMap.put(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49", (String)"PermRoleDataPckService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "0");
        resultMap.put(ResManager.loadKDString((String)"\u5141\u8bb8\u81ea\u5b9a\u4e49", (String)"PermRoleDataPckService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "1");
        return (String)resultMap.get(pro);
    }

    public String getRoleBc(String pro) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        resultMap.put(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4\u4e0d\u53d7\u89d2\u8272\u9650\u5236", (String)"PermRoleDataPckService_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "0");
        resultMap.put(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4\u53d7\u89d2\u8272\u9650\u5236", (String)"PermRoleDataPckService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "1");
        resultMap.put(ResManager.loadKDString((String)"\u4ec5\u81ea\u5b9a\u4e49\u6570\u636e\u8303\u56f4\u53d7\u89d2\u8272\u9650\u5236", (String)"PermRoleDataPckService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "2");
        resultMap.put(ResManager.loadKDString((String)"\u4ec5\u81ea\u5b9a\u4e49\u5b57\u6bb5\u6743\u9650\u53d7\u89d2\u8272\u9650\u5236", (String)"PermRoleDataPckService_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "3");
        return (String)resultMap.get(pro);
    }
}

