/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleTemplateFieldMap;

public class PermRoleInitImportService {
    private Map<String, ImportLogger> importLoggerMap;
    private Map<String, Integer> countMap;
    private int totalCount = 0;
    private int finishCount = 0;
    private IFormView view;

    public boolean containsValue(String sheetName) {
        long count = PermRoleTemplateFieldMap.getRoleTemplateNames().values().stream().filter(it -> it.contains(sheetName)).count();
        return count > 0L;
    }

    public PermRoleInitImportService(Map<String, ImportLogger> importLoggerMap, Map<String, Integer> countMap, IFormView view) {
        this.importLoggerMap = importLoggerMap;
        this.countMap = countMap;
        this.view = view;
    }

    public PermRoleInitImportService() {
    }

    public String dealSheetName(String sheetName) {
        if (sheetName.length() > 32) {
            return sheetName.substring(0, 31);
        }
        return sheetName;
    }

    public void feedbackProgress(boolean complete, String allErrUrl) {
        int progress;
        JSONObject map;
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        String cachedLogStr = cache.get("Cached_Import_Logger");
        JSONObject jSONObject = map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
        if (this.totalCount == 0 && complete) {
            this.totalCount = 1;
        }
        if ((progress = this.finishCount * 100 / this.totalCount) > map.getIntValue("progress") && progress <= 10) {
            progress = 25;
        }
        if (progress >= 99 && !complete) {
            progress = 90;
        }
        if (progress >= 99) {
            progress = 100;
        }
        if (complete) {
            progress = 100;
        }
        map.put("progress", (Object)progress);
        map.put("total", (Object)this.totalCount);
        map.put("succeed", (Object)0);
        map.put("failed", (Object)0);
        map.put("allErrFileUrl", (Object)allErrUrl);
        map.put("complete", (Object)complete);
        map.put("userEndTime", (Object)String.valueOf(System.currentTimeMillis()));
        if (complete) {
            int roleListFailed = this.importLoggerMap.get("importRoleList").getLogCache().size();
            int roleListSucceed = this.countMap.get("importRoleList") - roleListFailed;
            roleListSucceed = Math.max(roleListSucceed, 0);
            int roleFuncFailed = this.importLoggerMap.get("importRoleFunc").getLogCache().size();
            int roleFuncSucceed = this.countMap.get("importRoleFunc") - roleFuncFailed;
            roleFuncSucceed = Math.max(roleFuncSucceed, 0);
            int roleDimFailed = this.importLoggerMap.get("importRoleDim").getLogCache().size();
            int roleDimSucceed = this.countMap.get("importRoleDim") - roleDimFailed;
            roleDimSucceed = Math.max(roleDimSucceed, 0);
            int roleDataRangeFailed = this.importLoggerMap.get("importRoleDataRange").getLogCache().size();
            int roleDataRangeSucceed = this.countMap.get("importRoleDataRange") - roleDataRangeFailed;
            roleDataRangeSucceed = Math.max(roleDataRangeSucceed, 0);
            int fieldFailed = this.importLoggerMap.get("importRoleFp").getLogCache().size();
            int fieldSucceed = this.countMap.get("importRoleFp") - fieldFailed;
            fieldSucceed = Math.max(fieldSucceed, 0);
            map.put("importRoleList", (Object)roleListSucceed);
            map.put("importRoleFunc", (Object)roleFuncSucceed);
            map.put("importRoleDim", (Object)roleDimSucceed);
            map.put("importRoleDataRange", (Object)roleDataRangeSucceed);
            map.put("importRoleFp", (Object)fieldSucceed);
            map.put("importRoleListF", (Object)roleListFailed);
            map.put("importRoleFuncF", (Object)roleFuncFailed);
            map.put("importRoleDimF", (Object)roleDimFailed);
            map.put("importRoleDataRangeF", (Object)roleDataRangeFailed);
            map.put("importRoleFpF", (Object)fieldFailed);
        }
        cachedLogStr = JSON.toJSONString((Object)map);
        cache.put("Cached_Import_Logger", cachedLogStr);
        cache.saveChanges();
    }
}

