/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.perm.DimGroupParam;
import kd.hr.hbp.common.model.perm.DimValueParam;
import kd.hr.hbp.common.model.perm.EntityBdDataRuleParam;
import kd.hr.hbp.common.model.perm.EntityDataRuleParam;
import kd.hr.hbp.common.model.perm.EntityFieldPermParam;
import kd.hr.hbp.common.model.perm.UserBucaPermDataParam;
import kd.hr.hbp.common.model.perm.UserRoleAssignParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.common.RoleAssignService;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class UserPermInitConvertService {
    private static final Log LOGGER = LogFactory.getLog(UserPermInitConvertService.class);
    private static final HRBaseServiceHelper PERM_INIT_RECORD_HELPER = new HRBaseServiceHelper("hrcs_perminitrecord");
    private static final HRBaseServiceHelper PERM_FILE_HELPER = new HRBaseServiceHelper("hrcs_userpermfile");

    public static boolean convertRecord(Long recordId) {
        LOGGER.info("ConvertPermInitRecord start,recordId:{}", (Object)recordId);
        DynamicObject recordDyna = PERM_INIT_RECORD_HELPER.loadDynamicObject(new QFilter("id", "=", (Object)recordId));
        if (recordDyna == null) {
            LOGGER.error("PermInitRecord not exist. recordId={}", (Object)recordId);
            return false;
        }
        if (!HRStringUtils.equals((String)recordDyna.getString("dealstatus"), (String)"0")) {
            LOGGER.error("PermInitRecord dealstatus is not 0. recordId={}", (Object)recordId);
            return false;
        }
        DynamicObjectCollection userDimEntryColl = recordDyna.getDynamicObjectCollection("userdimentry");
        Set userIds = userDimEntryColl.stream().map(userDimEntry -> userDimEntry.getLong("dim_user.id")).collect(Collectors.toSet());
        DynamicObject[] permFileDynaArr = PERM_FILE_HELPER.queryOriginalArray("id,user.id,org.id,permfileenable", new QFilter[]{new QFilter("user.id", "in", userIds)});
        HashMap permFileIdMap = Maps.newHashMapWithExpectedSize((int)permFileDynaArr.length);
        for (DynamicObject permFileDyna : permFileDynaArr) {
            String key = PermInitServiceHelper.joinToKey(permFileDyna.getLong("user.id"), permFileDyna.getLong("org.id"));
            permFileIdMap.put(key, permFileDyna.getLong("id"));
        }
        try {
            UserRoleAssignParam assignParam;
            String assignParamKey;
            Boolean includeSub = recordDyna.getBoolean("includesub");
            HashMap assignParamMap = Maps.newHashMapWithExpectedSize((int)16);
            HashSet dimIds = Sets.newHashSetWithExpectedSize((int)16);
            for (DynamicObject userDimEntry2 : userDimEntryColl) {
                DynamicObjectCollection dimValSubEntryColl = userDimEntry2.getDynamicObjectCollection("userdimvalueentry");
                Iterator iterator = dimValSubEntryColl.iterator();
                while (iterator.hasNext()) {
                    DynamicObject dimValDyna = (DynamicObject)iterator.next();
                    dimIds.add(dimValDyna.getLong("dim_dimension.id"));
                }
            }
            HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
            Map<Long, Pair> dimInfoMap = Arrays.stream(dimHelper.query("id,datasource,showtype", new QFilter[]{new QFilter("id", "in", (Object)dimIds)})).collect(Collectors.toMap(it -> it.getLong("id"), it -> Pair.of((Object)it.getString("datasource"), (Object)it.getString("showtype")), (oldValue, newValue) -> oldValue));
            for (Object userDimEntry3 : userDimEntryColl) {
                Long bucaId;
                Iterator assignSource;
                String permFileKey = PermInitServiceHelper.joinToKey(userDimEntry3.getLong("dim_user.id"), userDimEntry3.getLong("dim_fileorg.id"));
                Long permFileId = (Long)permFileIdMap.get(permFileKey);
                assignParamKey = PermInitServiceHelper.joinToKey(userDimEntry3.getLong("dim_user.id"), userDimEntry3.getLong("dim_fileorg.id"), userDimEntry3.getString("dim_role.id"));
                Boolean isCustom = userDimEntry3.getBoolean("dim_customenable");
                assignParam = (UserRoleAssignParam)assignParamMap.get(assignParamKey);
                if (!Objects.isNull(assignParam) && !isCustom.booleanValue()) continue;
                if (Objects.isNull(assignParam)) {
                    assignParam = new UserRoleAssignParam();
                    assignSource = assignParam.getAssignSource();
                    assignSource.setObType("userRoleInit");
                    assignSource.setPageSource("hrcs_perminitrecord");
                    assignParamMap.put(assignParamKey, assignParam);
                }
                assignParam.setPermFileId(permFileId);
                assignParam.setRoleId(userDimEntry3.getString("dim_role.id"));
                assignParam.setValidStart(userDimEntry3.getDate("dim_validstart"));
                assignParam.setValidEnd(userDimEntry3.getDate("dim_validend"));
                assignParam.setCustomData(isCustom.booleanValue());
                assignParam.setCreatorId(Long.valueOf(RequestContext.get().getCurrUserId()));
                assignSource = assignParam.getAssignSource();
                assignSource.setSourceType("3");
                assignSource.setInitRecordId(recordId);
                if (!isCustom.booleanValue()) continue;
                Map bucaPermDataMap = assignParam.getDataRangeParam().getBucaPermData();
                UserBucaPermDataParam bucaPermDataParam = (UserBucaPermDataParam)bucaPermDataMap.get(bucaId = Long.valueOf(userDimEntry3.getLong("dim_bucafunc.id")));
                if (Objects.isNull(bucaPermDataParam)) {
                    bucaPermDataParam = new UserBucaPermDataParam();
                    bucaPermDataParam.setBucaId(bucaId);
                    bucaPermDataMap.put(bucaId, bucaPermDataParam);
                }
                HashMap orgInfoMap = Maps.newHashMapWithExpectedSize((int)16);
                DynamicObjectCollection orgRangeColl = userDimEntry3.getDynamicObjectCollection("dim_orgrange");
                String dim_orgcontainssubstr = userDimEntry3.getString("dim_orgcontainssubstr");
                Map orgRangeContainsSubMap = Maps.newHashMapWithExpectedSize((int)16);
                if (!HRStringUtils.isEmpty((String)dim_orgcontainssubstr)) {
                    orgRangeContainsSubMap = (Map)SerializationUtils.fromJsonString((String)dim_orgcontainssubstr, Map.class);
                    for (DynamicObject orgRangeDyna : orgRangeColl) {
                        orgInfoMap.put(orgRangeDyna.getLong("fbasedataid_id"), HRStringUtils.equals((String)"1", (String)((String)orgRangeContainsSubMap.get(String.valueOf(orgRangeDyna.getLong("fbasedataid_id"))))));
                    }
                }
                bucaPermDataParam.setOrgInfos((Map)orgInfoMap);
                List userDimGroupData = bucaPermDataParam.getUserDimGroupData();
                HashMap dimValuesMap = Maps.newHashMapWithExpectedSize((int)16);
                DynamicObjectCollection dimValSubEntryColl = userDimEntry3.getDynamicObjectCollection("userdimvalueentry");
                for (DynamicObject dimValDyna : dimValSubEntryColl) {
                    Long dimensionId = dimValDyna.getLong("dim_dimension.id");
                    List dimValueParams = (List)dimValuesMap.get(dimensionId);
                    if (Objects.isNull(dimValueParams)) {
                        dimValueParams = Lists.newArrayListWithExpectedSize((int)16);
                        dimValuesMap.put(dimensionId, dimValueParams);
                    }
                    boolean dim_containssub = dimValDyna.getBoolean("dim_containssub");
                    DimValueParam tmpDimValueParam = new DimValueParam(dimValDyna.getBoolean("dim_isall"), dimValDyna.getString("dim_dimval"), dim_containssub, dim_containssub, Long.valueOf(dimValDyna.getLong("dim_structproject.id")));
                    String dim_valtype = dimValDyna.getString("dim_valtype");
                    Object dim_dynacond = dimValDyna.get("dim_dynacond.id");
                    tmpDimValueParam.setValType(dim_valtype);
                    tmpDimValueParam.setDynaCondId((Long)dim_dynacond);
                    Pair dimInfo = dimInfoMap.get(dimensionId);
                    if (null == dimInfo) {
                        tmpDimValueParam.setContainsSub(false);
                        tmpDimValueParam.setAdminContainsSub(false);
                        LOGGER.info("Got empty dimInfo with dimId: {}.", (Object)dimensionId);
                    } else if (!(HRStringUtils.equals((String)"orgteam", (String)((String)dimInfo.getKey())) || HRStringUtils.equals((String)"hrbu", (String)((String)dimInfo.getKey())) && HRStringUtils.equals((String)"tree", (String)((String)dimInfo.getValue())) || HRStringUtils.equals((String)"basedata", (String)((String)dimInfo.getKey())) && HRStringUtils.equals((String)"tree", (String)((String)dimInfo.getValue())))) {
                        tmpDimValueParam.setContainsSub(false);
                        tmpDimValueParam.setAdminContainsSub(false);
                    }
                    dimValueParams.add(tmpDimValueParam);
                }
                userDimGroupData.add(new DimGroupParam((Map)dimValuesMap));
            }
            DynamicObjectCollection userDataRuleEntryColl = recordDyna.getDynamicObjectCollection("userdataruleentry");
            for (Object userDataRuleEntry : userDataRuleEntryColl) {
                String assignParamKey2 = PermInitServiceHelper.joinToKey(userDataRuleEntry.getLong("dr_user.id"), userDataRuleEntry.getLong("dr_fileorg.id"), userDataRuleEntry.getString("dr_role.id"));
                UserRoleAssignParam assignParam2 = (UserRoleAssignParam)assignParamMap.get(assignParamKey2);
                List dataRuleParams = assignParam2.getDataRangeParam().getDataRuleParams();
                DynamicObjectCollection permItemColl = userDataRuleEntry.getDynamicObjectCollection("dr_permitemmulti");
                for (DynamicObject dyna : permItemColl) {
                    EntityDataRuleParam dataRuleParam = new EntityDataRuleParam(userDataRuleEntry.getString("dr_app.id"), userDataRuleEntry.getString("dr_entitytype.number"), dyna.getString("fbasedataid_id"), Long.valueOf(userDataRuleEntry.getLong("dr_datarule.id")));
                    dataRuleParams.add(dataRuleParam);
                }
            }
            DynamicObjectCollection userBdDataRuleEntryColl = recordDyna.getDynamicObjectCollection("userbdentry");
            for (Object userBdDataRuleEntry : userBdDataRuleEntryColl) {
                assignParamKey = PermInitServiceHelper.joinToKey(userBdDataRuleEntry.getLong("bd_user.id"), userBdDataRuleEntry.getLong("bd_fileorg.id"), userBdDataRuleEntry.getString("bd_role.id"));
                UserRoleAssignParam assignParam3 = (UserRoleAssignParam)assignParamMap.get(assignParamKey);
                List bdDataRuleParams = assignParam3.getDataRangeParam().getBdDataRuleParams();
                EntityBdDataRuleParam bdDataRuleParam = new EntityBdDataRuleParam(userBdDataRuleEntry.getString("bd_app.id"), userBdDataRuleEntry.getString("bd_entitytype.number"), userBdDataRuleEntry.getString("bd_propkey"), userBdDataRuleEntry.getString("bd_propentnum"), Long.valueOf(userBdDataRuleEntry.getLong("bd_datarule.id")));
                bdDataRuleParams.add(bdDataRuleParam);
            }
            DynamicObjectCollection userFieldEntryColl = recordDyna.getDynamicObjectCollection("userfieldentry");
            for (DynamicObject userFieldEntry : userFieldEntryColl) {
                String assignParamKey3 = PermInitServiceHelper.joinToKey(userFieldEntry.getLong("field_user.id"), userFieldEntry.getLong("field_fileorg.id"), userFieldEntry.getString("field_role.id"));
                assignParam = (UserRoleAssignParam)assignParamMap.get(assignParamKey3);
                List fieldPermParams = assignParam.getDataRangeParam().getFieldPermParams();
                EntityFieldPermParam fieldPermParam = new EntityFieldPermParam(userFieldEntry.getString("field_app.id"), userFieldEntry.getString("field_entitytype.number"), userFieldEntry.getString("field_propkey"), userFieldEntry.getBoolean("field_canread"), userFieldEntry.getBoolean("field_canwrite"));
                try {
                    Map<String, String> entityFieldMap = RolePermLogServiceHelper.getEntityFieldMap(userFieldEntry.getString("field_entitytype.number"));
                    String field_propkey = entityFieldMap.get(userFieldEntry.getString("field_propkey"));
                    fieldPermParam.setFieldName(field_propkey);
                }
                catch (Exception exception) {
                    LOGGER.error("convertRecord RolePermLogServiceHelper.getEntityFieldMap error", (Throwable)exception);
                }
                fieldPermParams.add(fieldPermParam);
            }
            RoleAssignService.roleAssignUserBatch(Lists.newArrayList(assignParamMap.values()));
            DynamicObject dynamicObject = PERM_INIT_RECORD_HELPER.generateEmptyDynamicObject();
            dynamicObject.set("id", (Object)recordId);
            dynamicObject.set("dealstatus", (Object)"1");
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            HRPermCacheMgr.clearAllCache();
            LOGGER.info("ConvertPermInitRecord end,recordId:{}", (Object)recordId);
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("convertPermInitRecord error. recordId:" + recordId, (Throwable)ex);
            return false;
        }
    }
}

