/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init.roleinit;

import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.common.model.perminit.DataRangeInitModel;
import kd.hr.hrcs.common.model.perminit.DimInitCheckedBO;
import kd.hr.hrcs.common.model.perminit.DimInitModel;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.common.model.perminit.FieldPermInitModel;
import kd.hr.hrcs.common.model.perminit.FunctionItemInitModel;
import kd.hr.hrcs.common.model.perminit.PermRoleInitRecord;
import kd.hr.hrcs.common.model.perminit.RoleInitModel;
import org.apache.commons.lang3.tuple.Pair;

public class PermRoleInitRecordSaveService {
    private static final Log LOGGER = LogFactory.getLog(PermRoleInitRecordSaveService.class);
    private static final HRBaseServiceHelper PERM_INIT_HELPER = new HRBaseServiceHelper("hrcs_perminitrecord");

    public static boolean saveImportData(PermRoleInitRecord initRecord) {
        if (CollectionUtils.isEmpty((Collection)initRecord.getRoleInitModelList())) {
            LOGGER.info("roleInitModelList is empty,not need to save.recordId={}", (Object)initRecord.getId());
            return true;
        }
        DynamicObject recordDyna = PERM_INIT_HELPER.loadSingle((Object)initRecord.getId());
        if (recordDyna == null) {
            LOGGER.info("role perminit record not exist. recordId={}", (Object)initRecord.getId());
            return false;
        }
        DynamicObjectCollection roleBaseEntryColl = PermRoleInitRecordSaveService.buildRoleBaseEntry(recordDyna, initRecord);
        recordDyna.set("rolebaseentry", (Object)roleBaseEntryColl);
        DynamicObjectCollection roleFuncEntryColl = PermRoleInitRecordSaveService.buildRoleFuncEntry(recordDyna, initRecord);
        recordDyna.set("rolefuncentry", (Object)roleFuncEntryColl);
        DynamicObjectCollection roleDimEntryColl = PermRoleInitRecordSaveService.buildRoleDimEntry(recordDyna, initRecord);
        recordDyna.set("roledimentry", (Object)roleDimEntryColl);
        DynamicObjectCollection roleDataEntryColl = PermRoleInitRecordSaveService.buildRoleDataEntry(recordDyna, initRecord);
        recordDyna.set("roledataentry", (Object)roleDataEntryColl);
        DynamicObjectCollection roleFieldEntryColl = PermRoleInitRecordSaveService.buildRoleFieldEntry(recordDyna, initRecord);
        recordDyna.set("rolefieldentry", (Object)roleFieldEntryColl);
        recordDyna.set("initnumber", (Object)roleBaseEntryColl.size());
        PERM_INIT_HELPER.saveOne(recordDyna);
        return true;
    }

    private static DynamicObjectCollection buildRoleDataEntry(DynamicObject recordDyna, PermRoleInitRecord initRecord) {
        DynamicObjectCollection roleDataEntryColl = PERM_INIT_HELPER.generateEmptyEntryCollection(recordDyna, "roledataentry");
        if (CollectionUtils.isEmpty((Collection)initRecord.getDataRangeInitModelList())) {
            return roleDataEntryColl;
        }
        for (DataRangeInitModel roleDataModel : initRecord.getDataRangeInitModelList()) {
            DynamicObject roleDataEntryDyna = PERM_INIT_HELPER.generateEmptyEntryDynamicObject("roledataentry");
            roleDataEntryDyna.set("rdata_rolenumber", (Object)roleDataModel.getRoleNumber());
            roleDataEntryDyna.set("rdata_bucafunc", (Object)roleDataModel.getBuCaFuncId());
            if (CollectionUtils.isNotEmpty((Collection)roleDataModel.getOrgRangeList())) {
                Map orgRangeContainsSubList = roleDataModel.getOrgRangeContainsSubMap();
                roleDataEntryDyna.set("rdata_orgcontainssubstr", (Object)SerializationUtils.toJsonString((Object)orgRangeContainsSubList));
                DynamicObjectCollection orgRangeColl = roleDataEntryDyna.getDynamicObjectCollection("rdata_orgrange");
                DynamicObjectType orgRangeType = orgRangeColl.getDynamicObjectType();
                for (Long orgId : roleDataModel.getOrgRangeList()) {
                    DynamicObject orgDyna = new DynamicObject(orgRangeType);
                    orgDyna.set("fbasedataid", (Object)orgId);
                    orgRangeColl.add((Object)orgDyna);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)roleDataModel.getDimValues())) {
                DynamicObjectCollection dimvalSubEntryColl = roleDataEntryDyna.getDynamicObjectCollection("roledatavalentry");
                DynamicObjectType dimvalType = dimvalSubEntryColl.getDynamicObjectType();
                for (DimValueBean dimValue : roleDataModel.getDimValues()) {
                    DynamicObject dimvalDyna = new DynamicObject(dimvalType);
                    dimvalDyna.set("rdata_dimension", (Object)dimValue.getDimId());
                    dimvalDyna.set("rdata_dimval", (Object)dimValue.getDimVal());
                    dimvalDyna.set("rdata_isall", (Object)dimValue.isAll());
                    dimvalDyna.set("rdata_structproject", (Object)dimValue.getStructProjectId());
                    dimvalDyna.set("rdata_containssub", (Object)dimValue.isContainsSub());
                    dimvalDyna.set("rdata_valtype", (Object)dimValue.getValueType());
                    dimvalDyna.set("rdata_dynacond", (Object)dimValue.getDynacondId());
                    dimvalSubEntryColl.add((Object)dimvalDyna);
                }
            }
            roleDataEntryColl.add((Object)roleDataEntryDyna);
        }
        return roleDataEntryColl;
    }

    private static DynamicObjectCollection buildRoleFieldEntry(DynamicObject recordDyna, PermRoleInitRecord initRecord) {
        DynamicObjectCollection roleFieldEntryColl = PERM_INIT_HELPER.generateEmptyEntryCollection(recordDyna, "rolefieldentry");
        if (CollectionUtils.isEmpty((Collection)initRecord.getFieldPermInitModelList())) {
            return roleFieldEntryColl;
        }
        for (FieldPermInitModel roleFieldModel : initRecord.getFieldPermInitModelList()) {
            DynamicObject roleFieldEntryDyna = PERM_INIT_HELPER.generateEmptyEntryDynamicObject("rolefieldentry");
            roleFieldEntryDyna.set("rfield_rolenumber", (Object)roleFieldModel.getRoleNumber());
            roleFieldEntryDyna.set("rfield_app", (Object)roleFieldModel.getAppId());
            roleFieldEntryDyna.set("rfield_entitytype", (Object)roleFieldModel.getEntityNum());
            roleFieldEntryDyna.set("rfield_propkey", (Object)roleFieldModel.getFieldNumber());
            roleFieldEntryDyna.set("rfield_canread", (Object)roleFieldModel.getView());
            roleFieldEntryDyna.set("rfield_canwrite", (Object)roleFieldModel.getEdit());
            roleFieldEntryColl.add((Object)roleFieldEntryDyna);
        }
        return roleFieldEntryColl;
    }

    private static DynamicObjectCollection buildRoleDimEntry(DynamicObject recordDyna, PermRoleInitRecord initRecord) {
        DynamicObjectCollection roleDimEntryColl = PERM_INIT_HELPER.generateEmptyEntryCollection(recordDyna, "roledimentry");
        if (CollectionUtils.isEmpty((Collection)initRecord.getDimInitModelList())) {
            return roleDimEntryColl;
        }
        for (DimInitModel roleDimModel : initRecord.getDimInitModelList()) {
            for (Map.Entry entry : roleDimModel.getDimCheckedMap().entrySet()) {
                DimInitCheckedBO dimInitCheckedBO = (DimInitCheckedBO)entry.getValue();
                if (!dimInitCheckedBO.getCheck().booleanValue()) continue;
                DynamicObject roleDimEntryDyna = PERM_INIT_HELPER.generateEmptyEntryDynamicObject("roledimentry");
                roleDimEntryDyna.set("rdim_rolenumber", (Object)roleDimModel.getRoleNumber());
                roleDimEntryDyna.set("rdim_bucafunc", (Object)roleDimModel.getBuCaFuncId());
                roleDimEntryDyna.set("rdim_dimension", (Object)dimInitCheckedBO.getDimId());
                roleDimEntryColl.add((Object)roleDimEntryDyna);
            }
        }
        return roleDimEntryColl;
    }

    private static DynamicObjectCollection buildRoleFuncEntry(DynamicObject recordDyna, PermRoleInitRecord initRecord) {
        DynamicObjectCollection roleFuncEntryColl = PERM_INIT_HELPER.generateEmptyEntryCollection(recordDyna, "rolefuncentry");
        if (CollectionUtils.isEmpty((Collection)initRecord.getFunctionItemInitModelList())) {
            return roleFuncEntryColl;
        }
        for (FunctionItemInitModel roleFuncModel : initRecord.getFunctionItemInitModelList()) {
            for (Map.Entry entry : roleFuncModel.getRoleCheckedMap().entrySet()) {
                Pair pair = (Pair)entry.getValue();
                if (!((Boolean)pair.getRight()).booleanValue()) continue;
                DynamicObject roleFuncEntryDyna = PERM_INIT_HELPER.generateEmptyEntryDynamicObject("rolefuncentry");
                roleFuncEntryDyna.set("rfunc_rolenumber", entry.getKey());
                roleFuncEntryDyna.set("rfunc_app", (Object)roleFuncModel.getAppId());
                roleFuncEntryDyna.set("rfunc_entitytype", (Object)roleFuncModel.getEntityNum());
                roleFuncEntryDyna.set("rfunc_permitem", (Object)roleFuncModel.getPermItemId());
                roleFuncEntryColl.add((Object)roleFuncEntryDyna);
            }
        }
        return roleFuncEntryColl;
    }

    private static DynamicObjectCollection buildRoleBaseEntry(DynamicObject recordDyna, PermRoleInitRecord initRecord) {
        DynamicObjectCollection roleBaseEntryColl = PERM_INIT_HELPER.generateEmptyEntryCollection(recordDyna, "rolebaseentry");
        if (CollectionUtils.isEmpty((Collection)initRecord.getRoleInitModelList())) {
            return roleBaseEntryColl;
        }
        for (RoleInitModel roleInitModel : initRecord.getRoleInitModelList()) {
            DynamicObject roleBaseEntryDyna = PERM_INIT_HELPER.generateEmptyEntryDynamicObject("rolebaseentry");
            roleBaseEntryDyna.set("rbase_number", (Object)roleInitModel.getRoleNumber());
            ILocaleString nameLocale = PermRoleInitRecordSaveService.buildLocaleString(roleInitModel.getMulLangMap(), "roleName");
            roleBaseEntryDyna.set("rbase_name", (Object)nameLocale);
            roleBaseEntryDyna.set("rbase_group", (Object)roleInitModel.getRoleGroupId());
            roleBaseEntryDyna.set("rbase_property", (Object)roleInitModel.getRoleProperty());
            roleBaseEntryDyna.set("rbase_isintersection", (Object)roleInitModel.getRoleCBisIntersection());
            roleBaseEntryDyna.set("rbase_createadmingrp", (Object)roleInitModel.getCreateAdminGrpId());
            roleBaseEntryDyna.set("rbase_usescope", (Object)roleInitModel.getUseScope());
            if (CollectionUtils.isNotEmpty((Collection)roleInitModel.getOpenRangeWithViewIds())) {
                DynamicObjectCollection openScopeViewColl = roleBaseEntryDyna.getDynamicObjectCollection("rbase_openscopeview");
                DynamicObjectType openScopeViewType = openScopeViewColl.getDynamicObjectType();
                for (Long adminGroupId : roleInitModel.getOpenRangeWithViewIds()) {
                    DynamicObject openScopeViewDyna = new DynamicObject(openScopeViewType);
                    openScopeViewDyna.set("fbasedataid", (Object)adminGroupId);
                    openScopeViewColl.add((Object)openScopeViewDyna);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)roleInitModel.getOpenRangeWithEditIds())) {
                DynamicObjectCollection openScopeEditColl = roleBaseEntryDyna.getDynamicObjectCollection("rbase_openscopeedit");
                DynamicObjectType openScopeEditType = openScopeEditColl.getDynamicObjectType();
                for (Long adminGroupId : roleInitModel.getOpenRangeWithEditIds()) {
                    DynamicObject openScopeEditDyna = new DynamicObject(openScopeEditType);
                    openScopeEditDyna.set("fbasedataid", (Object)adminGroupId);
                    openScopeEditColl.add((Object)openScopeEditDyna);
                }
            }
            ILocaleString remarkLocale = PermRoleInitRecordSaveService.buildLocaleString(roleInitModel.getMulLangMap(), "roleRemark");
            roleBaseEntryDyna.set("rbase_remark", (Object)remarkLocale);
            roleBaseEntryColl.add((Object)roleBaseEntryDyna);
        }
        return roleBaseEntryColl;
    }

    private static String getFieldStatusStr(Boolean can) {
        if (can.booleanValue()) {
            return "1";
        }
        return "0";
    }

    private static ILocaleString buildLocaleString(Map<String, String> mulLangMap, String propKey) {
        LocaleString nameLocale = new LocaleString();
        for (Map.Entry<String, String> entry : mulLangMap.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(propKey + "_")) continue;
            String lang = key.replaceFirst(propKey + "_", "");
            nameLocale.setItem(lang, (Object)entry.getValue());
        }
        return nameLocale;
    }
}

