/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init.roleinit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.RoleInfo;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.SaveRoleServiceHelper;
import kd.hr.hrcs.common.model.perminit.RoleInitTccParamBO;

public class PermRoleInitSysService {
    private static volatile PermRoleInitSysService service = null;
    private static final String splitStr = "####";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PermRoleInitSysService getInstance() {
        if (service != null) return service;
        Class<PermRoleInitSysService> clazz = PermRoleInitSysService.class;
        synchronized (PermRoleInitSysService.class) {
            if (service != null) return service;
            service = new PermRoleInitSysService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public boolean saveData(Object paramBO) {
        RoleInitTccParamBO roleInitTccParamBO = (RoleInitTccParamBO)paramBO;
        if (roleInitTccParamBO == null) {
            return false;
        }
        this.saveBaseRoleInfo(roleInitTccParamBO);
        this.saveRoleFuncInfo(roleInitTccParamBO);
        return true;
    }

    private boolean saveBaseRoleInfo(RoleInitTccParamBO roleInitTccParamBO) {
        DynamicObject dynamicObject = roleInitTccParamBO.getDynamicObject();
        DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("rolebaseentry");
        if (collection == null || collection.size() == 0) {
            return false;
        }
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        if (roleNumberKeyMap == null || roleNumberKeyMap.isEmpty()) {
            return false;
        }
        StringBuilder processInfo = new StringBuilder();
        for (DynamicObject entry : collection) {
            Object remarkObj;
            String roleNumber = entry.getString("rbase_number");
            RoleInfo roleInfo = new RoleInfo();
            String key = (String)roleNumberKeyMap.get(roleNumber);
            roleInfo.setId(key);
            roleInfo.setNum(roleNumber);
            roleInfo.setLocaleName((ILocaleString)((OrmLocaleValue)entry.get("rbase_name")));
            roleInfo.setEnable(true);
            DynamicObject roleGrp = entry.getDynamicObject("rbase_group");
            if (Objects.nonNull(roleGrp)) {
                String groupId = roleGrp.getString("id");
                roleInfo.setGroupId(groupId);
            }
            if (Objects.nonNull(remarkObj = entry.get("rbase_remark"))) {
                roleInfo.setRemarkLocale((ILocaleString)((OrmLocaleValue)remarkObj));
            }
            roleInfo.setLocaleName(entry.getLocaleString("rbase_name"));
            roleInfo.setType(",1,");
            roleInfo.setUseScope("0");
            DynamicObject createAdminGrp = entry.getDynamicObject("rbase_createadmingrp");
            if (null != createAdminGrp) {
                roleInfo.setCreateAdminGrp(createAdminGrp.getString("id"));
            }
            if (!PermissionServiceHelper.newRole((RoleInfo)roleInfo, (StringBuilder)processInfo)) {
                return false;
            }
            roleNumberKeyMap.put(roleNumber, roleInfo.getId());
        }
        roleInitTccParamBO.setRoleNumberKeyMap(roleNumberKeyMap);
        return true;
    }

    private boolean saveRoleFuncInfo(RoleInitTccParamBO roleInitTccParamBO) {
        List dataLists;
        DynamicObject dynamicObject = roleInitTccParamBO.getDynamicObject();
        DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("rolefuncentry");
        if (collection == null || collection.size() == 0) {
            return false;
        }
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        if (roleNumberKeyMap == null || roleNumberKeyMap.isEmpty()) {
            return false;
        }
        HashMap mapData = Maps.newHashMapWithExpectedSize((int)16);
        HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)collection.size());
        for (DynamicObject entry : collection) {
            String roleNumber = entry.getString("rfunc_rolenumber");
            String roleId = (String)roleNumberKeyMap.get(roleNumber);
            dataLists = (List)mapData.get(roleId);
            if (CollectionUtils.isEmpty((Collection)dataLists)) {
                dataLists = Lists.newArrayListWithCapacity((int)10);
                mapData.put(roleId, dataLists);
            }
            String appId = entry.getString("rfunc_app.id");
            appIdSet.add(appId);
            String entityNumber = entry.getString("rfunc_entitytype.number");
            String permItemId = entry.getString("rfunc_permitem.id");
            HashMap mapNest = Maps.newHashMapWithExpectedSize((int)3);
            mapNest.put("appId", appId);
            mapNest.put("entityNumber", entityNumber);
            mapNest.put("permItemId", permItemId);
            dataLists.add(mapNest);
        }
        this.addRelatePerm(mapData, appIdSet);
        for (Map.Entry mapEntry : mapData.entrySet()) {
            StringBuilder processInfo;
            boolean result;
            String roleId = (String)mapEntry.getKey();
            dataLists = (List)mapEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)dataLists) || (result = SaveRoleServiceHelper.doSaveFuncPerm4New(roleId, dataLists, processInfo = new StringBuilder()))) continue;
            return false;
        }
        return true;
    }

    private Set<String> getAllRelateCfgData() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        QFilter[] filters = new QFilter[]{new QFilter("isassign", "=", (Object)"1")};
        DynamicObject[] dynamicObjects = helper.query("app,entitytype,permitem", filters);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        HashSet keys = Sets.newHashSetWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String appId = dynamicObject.getString("app.id");
            String entityNumber = dynamicObject.getString("entitytype.number");
            String permItemId = dynamicObject.getString("permitem.id");
            keys.add(appId + splitStr + entityNumber + splitStr + permItemId);
        }
        return keys;
    }

    private Map<String, List<String>> getPermRelate(Set<String> appIdSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_permrelat");
        QFilter[] filters = new QFilter[]{new QFilter("bizapp", "in", appIdSet)};
        DynamicObject[] dynamicObjects = helper.query("bizapp,entitytype,mainpermitem,entryentity.entitytypeid,entryentity.app,entryentity.permitemid", filters);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        HashSet relatePermItemNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            relatePermItemNumberSet.add(dynamicObject.getString("mainpermitem"));
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject relateDy : entry) {
                String[] relatePermItemNumbers;
                String relatePermItemNumber = relateDy.getString("permitemid");
                for (String number : relatePermItemNumbers = relatePermItemNumber.split(",")) {
                    relatePermItemNumberSet.add(number);
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)relatePermItemNumberSet)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_permitem");
        DynamicObject[] permItemDys = serviceHelper.query("number,id", new QFilter[]{new QFilter("number", "in", (Object)relatePermItemNumberSet)});
        HashMap permIdNumberMap = Maps.newHashMapWithExpectedSize((int)permItemDys.length);
        for (DynamicObject dynamicObject : permItemDys) {
            String number = dynamicObject.getString("number");
            String permId = dynamicObject.getString("id");
            if (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)permId)) continue;
            permIdNumberMap.put(number, permId);
        }
        if (permIdNumberMap == null || permIdNumberMap.isEmpty()) {
            return null;
        }
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String appId = dynamicObject.getString("bizapp.id");
            String entityNumber = dynamicObject.getString("entitytype.number");
            String permItemNumber = dynamicObject.getString("mainpermitem");
            String permItemId = (String)permIdNumberMap.get(permItemNumber);
            String key = this.buildKey(appId, entityNumber, permItemId);
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entry)) continue;
            List relateData = (List)hashMap.get(key);
            if (relateData == null) {
                relateData = Lists.newArrayListWithCapacity((int)entry.size());
                hashMap.put(key, relateData);
            }
            for (DynamicObject relateDy : entry) {
                String[] relatePermItemNumbers;
                String relateAppId = relateDy.getString("app_id");
                String relateEntityNumber = relateDy.getString("entitytypeid_id");
                String relatePermItemNumber = relateDy.getString("permitemid");
                if (StringUtils.isEmpty((String)relateAppId) || StringUtils.isEmpty((String)relateEntityNumber) || StringUtils.isEmpty((String)relatePermItemNumber)) continue;
                for (String relateItemNumber : relatePermItemNumbers = relatePermItemNumber.split(",")) {
                    String relateItemId = (String)permIdNumberMap.get(relateItemNumber);
                    relateData.add(this.buildKey(relateAppId, relateEntityNumber, relateItemId));
                }
            }
        }
        return hashMap;
    }

    public void addRelatePerm(Map<String, List<Map<String, String>>> mapData, Set<String> appIdSet) {
        Map<String, List<String>> mapPermRelate = this.getPermRelate(appIdSet);
        if (mapPermRelate == null || mapPermRelate.isEmpty()) {
            return;
        }
        Set<String> cfgKeys = this.getAllRelateCfgData();
        for (Map.Entry<String, List<Map<String, String>>> mapEntry : mapData.entrySet()) {
            String key;
            String permItemId;
            String entityNumber;
            String appId;
            List<Map<String, String>> dataLists = mapEntry.getValue();
            if (CollectionUtils.isEmpty(dataLists)) continue;
            ArrayList relateDataLists = Lists.newArrayListWithCapacity((int)10);
            HashSet keys = Sets.newHashSetWithExpectedSize((int)dataLists.size());
            for (Map<String, String> mapPermItem : dataLists) {
                appId = mapPermItem.get("appId");
                entityNumber = mapPermItem.get("entityNumber");
                permItemId = mapPermItem.get("permItemId");
                key = this.buildKey(appId, entityNumber, permItemId);
                keys.add(key);
            }
            for (Map<String, String> mapPermItem : dataLists) {
                appId = mapPermItem.get("appId");
                key = this.buildKey(appId, entityNumber = mapPermItem.get("entityNumber"), permItemId = mapPermItem.get("permItemId"));
                List<String> relatePermList = mapPermRelate.get(key);
                if (CollectionUtils.isEmpty(relatePermList)) continue;
                for (String value : relatePermList) {
                    String[] values;
                    if (StringUtils.isEmpty((String)value) || cfgKeys.contains(value) || keys.contains(value) || (values = value.split(splitStr)) == null || values.length != 3) continue;
                    String relateAppId = values[0];
                    String relateEntityNumber = values[1];
                    String relatePermItemId = values[2];
                    HashMap relateMap = Maps.newHashMapWithExpectedSize((int)3);
                    relateMap.put("appId", relateAppId);
                    relateMap.put("entityNumber", relateEntityNumber);
                    relateMap.put("permItemId", relatePermItemId);
                    relateDataLists.add(relateMap);
                }
            }
            dataLists.addAll(relateDataLists);
        }
    }

    private String buildKey(String appId, String entityNumber, String permItemId) {
        return appId + splitStr + entityNumber + splitStr + permItemId;
    }

    public void deleteSysRoleInit(Object paramBO) {
        RoleInitTccParamBO roleInitTccParamBO = (RoleInitTccParamBO)paramBO;
        if (roleInitTccParamBO == null) {
            return;
        }
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        if (roleNumberKeyMap == null || roleNumberKeyMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : roleNumberKeyMap.entrySet()) {
            String key = (String)entry.getValue();
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setId(key);
            HRBaseServiceHelper bosRoleHelper = new HRBaseServiceHelper("perm_role");
            DynamicObject bosRole = bosRoleHelper.queryOne((Object)roleInfo.getId());
            bosRole.set("enable", (Object)"0");
            OperationServiceHelper.executeOperate((String)"save", (String)"perm_role", (DynamicObject[])new DynamicObject[]{bosRole}, (OperateOption)OperateOption.create());
            PermissionServiceHelper.deleteRole((RoleInfo)roleInfo, (StringBuilder)new StringBuilder());
        }
    }
}

