/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.log;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.PermLogServiceHelper;
import kd.hr.hrcs.common.constants.perm.log.EntityCtrlModel;

public class EntityCtrlLogService {
    public static void resolveLog(List<EntityCtrlModel> entityCtrlLogInfos) {
        HRBaseServiceHelper logHelper = new HRBaseServiceHelper("hrcs_permlog");
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        Map<Long, String> opName = EntityCtrlLogService.getOpName();
        for (int index = 0; index < entityCtrlLogInfos.size(); ++index) {
            EntityCtrlModel entityCtrlLogInfo = entityCtrlLogInfos.get(index);
            DynamicObject permLogDy = logHelper.generateEmptyDynamicObject();
            permLogDy.set("number", (Object)(HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + String.format("%03d", index)));
            permLogDy.set("operator", (Object)RequestContext.get().getCurrUserId());
            permLogDy.set("operationtime", (Object)new Date());
            permLogDy.set("description", (Object)"");
            permLogDy.set("clienttype", (Object)"web");
            permLogDy.set("opentitytype", (Object)"hrcs_entityctrl");
            long logType = entityCtrlLogInfo.getLogType();
            permLogDy.set("opbtnname", (Object)opName.get(logType));
            permLogDy.set("logtype", (Object)logType);
            String entityType = entityCtrlLogInfo.getEntityType();
            List beforeEntryRows = entityCtrlLogInfo.getBeforeEntryRows();
            List effectDimRoleList = entityCtrlLogInfo.getEffectDimRoleList();
            EntityCtrlModel entityCtrlModel = new EntityCtrlModel(entityType);
            entityCtrlModel.setBeforeEntryRows(beforeEntryRows);
            entityCtrlModel.setEffectDimRoleList(effectDimRoleList);
            permLogDy.set("entitytype", (Object)entityType);
            permLogDy.set("beforeopdata", (Object)JSONArray.toJSONString((Object)entityCtrlModel));
            permLogDy.set("afteropdata", (Object)JSONArray.toJSONString((Object)entityCtrlLogInfo.getAfterEntryRows()));
            dynamicObjectCollection.add((Object)permLogDy);
        }
        PermLogServiceHelper.savePermLogs(dynamicObjectCollection);
    }

    public static Map<Long, String> getOpName() {
        HashMap opNameMap = Maps.newHashMapWithExpectedSize((int)3);
        String add = ResManager.loadKDString((String)"\u65b0\u589e", (String)"EntityCtrlLogService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String delete = ResManager.loadKDString((String)"\u5220\u9664", (String)"EntityCtrlLogService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String modify = ResManager.loadKDString((String)"\u4fee\u6539", (String)"EntityCtrlLogService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        opNameMap.put(4010L, add);
        opNameMap.put(4015L, modify);
        opNameMap.put(4020L, delete);
        return opNameMap;
    }

    public static Map<String, String> getAuthTips() {
        String authRow = ResManager.loadKDString((String)"\u884c\u6570\u636e\u8303\u56f4", (String)"EntityCtrlLogService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String authBD = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u9009\u62e9\u8303\u56f4", (String)"EntityCtrlLogService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String authAll = ResManager.loadKDString((String)"\u5168\u90e8", (String)"EntityCtrlLogService_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        HashMap authTips = Maps.newHashMapWithExpectedSize((int)3);
        authTips.put("1", authRow);
        authTips.put("2", authBD);
        authTips.put("3", authAll);
        return authTips;
    }

    public static Map<Boolean, String> getMustMap() {
        String must = ResManager.loadKDString((String)"\u662f", (String)"EntityCtrlLogService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String unMust = ResManager.loadKDString((String)"\u5426", (String)"EntityCtrlLogService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        HashMap mustMap = Maps.newHashMapWithExpectedSize((int)2);
        mustMap.put(Boolean.TRUE, must);
        mustMap.put(Boolean.FALSE, unMust);
        return mustMap;
    }
}

