/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.log;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.MsgCenterServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.PermLogServiceHelper;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;
import kd.hr.hrcs.common.constants.perm.log.RoleInfoLogModel;

public class PermLogService
implements HRCSBaseConstants {
    private static final Log LOGGER = LogFactory.getLog(PermLogService.class);
    public static final long LOG_TYPE_NEW = 1010L;
    public static final long LOG_TYPE_COPY = 1015L;
    public static final long LOG_TYPE_MODIFY = 1025L;
    public static final long LOG_TYPE_DELETE = 1030L;
    private static final HRBaseServiceHelper PERM_LOG_HELPER = new HRBaseServiceHelper("hrcs_permlog");
    private static final HRBaseServiceHelper USER_ROLE_RE_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HRMServiceResult consumerDyPermLog(DynamicObject msgDy) {
        LOGGER.info("PermLogService-msgInfo:msgDy:{}", (Object)msgDy);
        boolean successFlag = true;
        try {
            DynamicObject[] dynamicObjects;
            String contentBase64 = msgDy.getString("msgcontent");
            Map msgContent = (Map)SerializationUtils.deSerializeFromBase64((String)contentBase64);
            List permLogIds = (List)msgContent.get("permLogId");
            LOGGER.info("PermLogService-msgInfo:permLogId:{}", (Object)permLogIds);
            for (DynamicObject dynamicObject : dynamicObjects = PERM_LOG_HELPER.loadDynamicObjectArray(permLogIds.toArray())) {
                String handlerClass = dynamicObject.getString("logtype.handlerclass");
                this.invoke(handlerClass, "doHandler", dynamicObject);
            }
        }
        catch (Exception ex) {
            successFlag = false;
            LOGGER.error("PermLogService-consumer-entryJob-fail", (Throwable)ex);
        }
        finally {
            try {
                String successMsg = ResManager.loadKDString((String)"\u6743\u9650\u65e5\u5fd7\u5904\u7406\u5b8c\u6210\u3002", (String)"PermLogService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                String failMsg = ResManager.loadKDString((String)"\u6743\u9650\u65e5\u5fd7\u5904\u7406\u5931\u8d25\u3002", (String)"PermLogService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                PermLogService.rspConsumerMsg(msgDy, successFlag, successMsg, failMsg);
            }
            catch (Exception exc) {
                LOGGER.error("PermLogService-rsp-consumer-entryJob-fail.", (Throwable)exc);
            }
        }
        return HRMServiceResult.success();
    }

    private Object invoke(String clazzName, String methodName, DynamicObject params) {
        try {
            Class<?> clazz = Class.forName(clazzName);
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod(methodName, DynamicObject.class);
            return method.invoke(instance, params);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.PermLogService.invoke.ClassNotFoundException:", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.PermLogService.invoke.InstantiationException:", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.PermLogService.invoke.IllegalAccessException:", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.PermLogService.invoke.NoSuchMethodException:", (Throwable)e);
        }
        catch (SecurityException e) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.PermLogService.invoke.SecurityException:", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.PermLogService.invoke.IllegalArgumentException:", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.PermLogService.invoke.InvocationTargetException:", (Throwable)e);
        }
        return null;
    }

    public static void rspConsumerMsg(DynamicObject msgDy, boolean successFlag, String successMsg, String failMsg) {
        HashMap<String, Object> consumeMsgMap = new HashMap<String, Object>(8);
        consumeMsgMap.put("msgCenterId", msgDy.getLong("msgcenterbo"));
        consumeMsgMap.put("msgSubNo", msgDy.get("msgsubno"));
        consumeMsgMap.put("businessTypeId", msgDy.getLong("msgbusinesstype"));
        consumeMsgMap.put("handleStatus", successFlag ? "1" : "3");
        consumeMsgMap.put("consumeMsg", successFlag ? successMsg : failMsg);
        MsgCenterServiceHelper.updateConsumeMsgInfo(consumeMsgMap);
    }

    public static void initPermLog(String opType, RoleInfoLogModel beforeRoleInfoLogModel, RoleInfoLogModel roleInfoLogModel, String roleId) {
        HRBaseServiceHelper logHelper = new HRBaseServiceHelper("hrcs_permlog");
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        DynamicObject permLogDy = logHelper.generateEmptyDynamicObject();
        permLogDy.set("number", (Object)(HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + "001"));
        permLogDy.set("operator", (Object)RequestContext.get().getCurrUserId());
        permLogDy.set("operationtime", (Object)new Date());
        permLogDy.set("role", (Object)roleId);
        permLogDy.set("description", (Object)"");
        permLogDy.set("clienttype", (Object)"web");
        if (HRStringUtils.equals((String)opType, (String)"add")) {
            permLogDy.set("opentitytype", (Object)"hrcs_newrole");
            permLogDy.set("opbtnname", (Object)ResManager.loadKDString((String)"\u65b0\u589e", (String)"PermLogService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            permLogDy.set("logtype", (Object)1010L);
        } else if (HRStringUtils.equals((String)opType, (String)"del")) {
            permLogDy.set("opentitytype", (Object)"hrcs_role");
            permLogDy.set("opbtnname", (Object)ResManager.loadKDString((String)"\u5220\u9664", (String)"PermLogService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            permLogDy.set("logtype", (Object)1030L);
        } else if (HRStringUtils.equals((String)opType, (String)"modify")) {
            permLogDy.set("opentitytype", (Object)"hrcs_modifyrole");
            permLogDy.set("opbtnname", (Object)ResManager.loadKDString((String)"\u4fee\u6539", (String)"PermLogService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            permLogDy.set("logtype", (Object)1025L);
        } else if (HRStringUtils.equals((String)opType, (String)"copy")) {
            permLogDy.set("opentitytype", (Object)"hrcs_modifyrole");
            permLogDy.set("opbtnname", (Object)ResManager.loadKDString((String)"\u4fee\u6539", (String)"PermLogService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            permLogDy.set("logtype", (Object)1015L);
        }
        permLogDy.set("beforeopdata", (Object)SerializationUtils.toJsonString((Object)beforeRoleInfoLogModel));
        permLogDy.set("afteropdata", (Object)SerializationUtils.toJsonString((Object)roleInfoLogModel));
        dynamicObjectCollection.add((Object)permLogDy);
        PermLogServiceHelper.savePermLogs(dynamicObjectCollection);
    }
}

