/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.log.handler;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.log.EntityCtrlLogService;
import kd.hr.hrcs.bussiness.service.perm.log.PermLogHandler;
import kd.hr.hrcs.common.constants.perm.log.DimRoleInfoModel;
import kd.hr.hrcs.common.constants.perm.log.EntityCtrlEntryRowModel;
import kd.hr.hrcs.common.constants.perm.log.EntityCtrlModel;
import kd.hr.hrcs.common.constants.perm.log.PermLogConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class EntityCtrlPermLogHandler
extends PermLogHandler
implements PermLogConstants {
    private static final Log LOGGER = LogFactory.getLog(EntityCtrlPermLogHandler.class);
    private static final HRBaseServiceHelper PERM_LOG_HELPER = new HRBaseServiceHelper("hrcs_permlog");

    @Override
    public void doHandler(DynamicObject permLog) {
        try {
            long logType = permLog.getLong("logtype.id");
            this.resolveLog(permLog, logType);
        }
        catch (Exception exception) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.handler.EntityCtrlPermLogHandler", (Throwable)exception);
        }
    }

    private void fillBaseEntry(List<EntityCtrlEntryRowModel> entryRowModelList, Long logType, String opName, DynamicObjectCollection baseInfoEntry) {
        Map<String, String> authTips = EntityCtrlLogService.getAuthTips();
        Map<Boolean, String> mustMap = EntityCtrlLogService.getMustMap();
        for (EntityCtrlEntryRowModel entryRow : entryRowModelList) {
            String prop = entryRow.getProp();
            String dim = entryRow.getDim();
            String authRange = entryRow.getAuthRange();
            Boolean isMust = entryRow.isMust();
            String opDataMsg = this.getOpDataMsg(dim, authTips.get(authRange), mustMap.get(isMust));
            DynamicObject newEntryRow = baseInfoEntry.addNew();
            newEntryRow.set("baseinfo_changefield", (Object)prop);
            if (4020L == logType) {
                newEntryRow.set("baseinfo_beforedata", (Object)opDataMsg);
            } else {
                newEntryRow.set("baseinfo_afterdata", (Object)opDataMsg);
            }
            newEntryRow.set("baseinfo_description", (Object)opName);
        }
    }

    private List<String> fillBaseEntryModify(List<EntityCtrlEntryRowModel> beforeEntryRows, List<EntityCtrlEntryRowModel> afterEntryRows, DynamicObjectCollection baseInfoEntry) {
        Map<String, String> authTips = EntityCtrlLogService.getAuthTips();
        Map<Boolean, String> mustMap = EntityCtrlLogService.getMustMap();
        Map<String, EntityCtrlEntryRowModel> propEntryMap = afterEntryRows.stream().collect(Collectors.toMap(EntityCtrlEntryRowModel::getProp, it -> it));
        ArrayList changeAuthProps = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList beforeOpProps = Lists.newArrayListWithCapacity((int)beforeEntryRows.size());
        for (EntityCtrlEntryRowModel beforeEntryRow : beforeEntryRows) {
            String opName;
            String prop = beforeEntryRow.getProp();
            String dim = beforeEntryRow.getDim();
            String authRange = beforeEntryRow.getAuthRange();
            boolean isMust = beforeEntryRow.isMust();
            StringBuilder beforeOpDataMsg = new StringBuilder();
            beforeOpProps.add(prop);
            StringBuilder afterOpDataMsg = new StringBuilder();
            if (propEntryMap.containsKey(prop)) {
                EntityCtrlEntryRowModel afterEntryRow = propEntryMap.get(prop);
                String afterDim = afterEntryRow.getDim();
                String afterAuth = afterEntryRow.getAuthRange();
                boolean afterMust = afterEntryRow.isMust();
                if (beforeEntryRow.equals((Object)afterEntryRow)) continue;
                if (!HRStringUtils.equals((String)dim, (String)afterDim)) {
                    beforeOpDataMsg.append(this.getDimTip(dim));
                    afterOpDataMsg.append(this.getDimTip(afterDim));
                }
                if (!HRStringUtils.equals((String)authRange, (String)afterAuth)) {
                    beforeOpDataMsg.append(this.getAuthRangeTip(authTips.get(authRange)));
                    afterOpDataMsg.append(this.getAuthRangeTip(authTips.get(afterAuth)));
                    changeAuthProps.add(prop);
                }
                if (isMust != afterMust) {
                    beforeOpDataMsg.append(this.getMustTip(mustMap.get(isMust)));
                    afterOpDataMsg.append(this.getMustTip(mustMap.get(afterMust)));
                }
                opName = ResManager.loadKDString((String)"\u4fee\u6539", (String)"EntityCtrlPermLogHandler_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            } else {
                beforeOpDataMsg.append(this.getOpDataMsg(dim, authTips.get(authRange), mustMap.get(isMust)));
                opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"EntityCtrlPermLogHandler_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            }
            DynamicObject newEntryRow = baseInfoEntry.addNew();
            newEntryRow.set("baseinfo_changefield", (Object)prop);
            newEntryRow.set("baseinfo_beforedata", (Object)beforeOpDataMsg.toString());
            newEntryRow.set("baseinfo_afterdata", (Object)afterOpDataMsg.toString());
            newEntryRow.set("baseinfo_description", (Object)opName);
        }
        String add = ResManager.loadKDString((String)"\u65b0\u589e", (String)"EntityCtrlPermLogHandler_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        for (EntityCtrlEntryRowModel afterEntryRow : afterEntryRows) {
            String prop = afterEntryRow.getProp();
            if (beforeOpProps.contains(prop)) continue;
            String dim = afterEntryRow.getDim();
            String authRange = afterEntryRow.getAuthRange();
            Boolean isMust = afterEntryRow.isMust();
            String opDataMsg = this.getOpDataMsg(dim, authTips.get(authRange), mustMap.get(isMust));
            DynamicObject newEntryRow = baseInfoEntry.addNew();
            newEntryRow.set("baseinfo_changefield", (Object)prop);
            newEntryRow.set("baseinfo_afterdata", (Object)opDataMsg);
            newEntryRow.set("baseinfo_description", (Object)add);
        }
        return changeAuthProps;
    }

    private String getDimTip(String dim) {
        return ResManager.loadKDString((String)"\u7ef4\u5ea6\uff1a%s\n", (String)"EntityCtrlPermLogHandler_6", (String)"hrmp-hrcs-business", (Object[])new Object[]{dim});
    }

    private String getAuthRangeTip(String authRange) {
        return ResManager.loadKDString((String)"\u63a7\u6743\u8303\u56f4\uff1a%s\n", (String)"EntityCtrlPermLogHandler_7", (String)"hrmp-hrcs-business", (Object[])new Object[]{authRange});
    }

    private String getMustTip(String isMust) {
        return ResManager.loadKDString((String)"\u662f\u5426\u5fc5\u9009\uff1a%s\n", (String)"EntityCtrlPermLogHandler_8", (String)"hrmp-hrcs-business", (Object[])new Object[]{isMust});
    }

    private String getOpDataMsg(String dim, String authRange, String isMust) {
        return ResManager.loadKDString((String)"\u7ef4\u5ea6\uff1a%1$s\n\u63a7\u6743\u8303\u56f4\uff1a%2$s\n\u662f\u5426\u5fc5\u9009\uff1a%3$s", (String)"EntityCtrlPermLogHandler_5", (String)"hrmp-hrcs-business", (Object[])new Object[]{dim, authRange, isMust});
    }

    private void resolveLog(DynamicObject permLog, long logType) {
        Map<Long, String> opNameMap = EntityCtrlLogService.getOpName();
        String opName = opNameMap.get(logType);
        DynamicObjectCollection baseEntry = permLog.getDynamicObjectCollection("baseinfoentry");
        String beforeOpDataStr = permLog.getString("beforeopdata");
        EntityCtrlModel beforeOpData = (EntityCtrlModel)JSONArray.parseObject((String)beforeOpDataStr, EntityCtrlModel.class);
        String entityType = beforeOpData.getEntityType();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject entityDy = serviceHelper.queryOriginalOne("name", (Object)entityType);
        String entityName = entityDy.getString("name");
        List beforeEntryRows = beforeOpData.getBeforeEntryRows();
        String afterOpDataStr = permLog.getString("afteropdata");
        List afterEntryRows = JSONArray.parseArray((String)afterOpDataStr, EntityCtrlEntryRowModel.class);
        DynamicObjectCollection influRoleEntry = permLog.getDynamicObjectCollection("influroleentry");
        ArrayList effectRoleList = Lists.newArrayListWithExpectedSize((int)10);
        if (4020L == logType) {
            this.fillBaseEntry(beforeEntryRows, logType, opName, baseEntry);
        } else if (4010L == logType) {
            this.fillBaseEntry(afterEntryRows, logType, opName, baseEntry);
        } else {
            List<String> changeAuthProps = this.fillBaseEntryModify(beforeEntryRows, afterEntryRows, baseEntry);
            if (CollectionUtils.isNotEmpty(changeAuthProps)) {
                List<String> changeAuthEffRoles = this.appendEffRoles(entityType, changeAuthProps, influRoleEntry);
                effectRoleList.addAll(changeAuthEffRoles);
            }
        }
        List effectDimRoleList = beforeOpData.getEffectDimRoleList();
        effectDimRoleList.removeIf(it -> effectRoleList.contains(it.getRoleId()));
        List<String> otherEffectRoleList = this.fillEffRoleEntry(effectDimRoleList, influRoleEntry);
        effectRoleList.addAll(otherEffectRoleList);
        int effectUser = this.fillEffectUserEntry(effectRoleList, permLog.getDynamicObjectCollection("influuserentry"));
        permLog.set("hashandle", (Object)true);
        permLog.set("influusernumber", (Object)effectUser);
        permLog.set("description", (Object)String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\uff08%3$s\uff09\u201d\u7684\u4e1a\u52a1\u5bf9\u8c61\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"EntityCtrlPermLogHandler_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]), opName, entityType, entityName));
        PERM_LOG_HELPER.saveOne(permLog);
    }

    private List<String> appendEffRoles(String entityType, List<String> changeAuthProps, DynamicObjectCollection influRoleEntry) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roledimension");
        QFilter entityFilter = new QFilter("entry.entityType", "=", (Object)entityType);
        QFilter propFilter = new QFilter("entry.propkey", "in", changeAuthProps);
        QFilter enableFilter = new QFilter("entry.enable", "=", (Object)"1");
        DynamicObjectCollection collection = serviceHelper.queryOriginalCollection("role,role.number,role.name", new QFilter[]{entityFilter, propFilter, enableFilter});
        ArrayList effectRoleList = Lists.newArrayListWithExpectedSize((int)collection.size());
        for (DynamicObject row : collection) {
            DynamicObject entryRow = influRoleEntry.addNew();
            String roleId = row.getString("role");
            entryRow.set("influrole_role", (Object)roleId);
            entryRow.set("influrole_rolenumber", (Object)row.getString("role.number"));
            entryRow.set("influrole_rolename", (Object)row.getString("role.name"));
            effectRoleList.add(roleId);
        }
        return effectRoleList;
    }

    private List<String> fillEffRoleEntry(List<DimRoleInfoModel> effectDimRoleList, DynamicObjectCollection influRoleEntry) {
        effectDimRoleList.removeIf(it -> HRStringUtils.isEmpty((String)it.getRoleId()));
        List<String> effectRoleList = effectDimRoleList.stream().map(DimRoleInfoModel::getRoleId).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_role");
        DynamicObjectCollection collection = serviceHelper.queryOriginalCollection("id,number,name", new QFilter[]{new QFilter("id", "in", effectRoleList)});
        Map<String, Pair> roleInfo = collection.stream().collect(Collectors.toMap(it -> it.getString("id"), it -> Pair.of((Object)it.getString("number"), (Object)it.getString("name"))));
        HRBaseServiceHelper hrRoleServiceHelper = new HRBaseServiceHelper("hrcs_role");
        Set hrRoleIds = Arrays.stream(hrRoleServiceHelper.query("id", new QFilter[]{new QFilter("id", "in", effectRoleList)})).map(it -> it.getString("id")).collect(Collectors.toSet());
        HashMap opNameMap = Maps.newHashMapWithExpectedSize((int)3);
        String add = ResManager.loadKDString((String)"\u65b0\u589e", (String)"EntityCtrlPermLogHandler_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String delete = ResManager.loadKDString((String)"\u5220\u9664", (String)"EntityCtrlPermLogHandler_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String modify = ResManager.loadKDString((String)"\u4fee\u6539", (String)"EntityCtrlPermLogHandler_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        opNameMap.put("add", add);
        opNameMap.put("modify", modify);
        opNameMap.put("delete", delete);
        effectDimRoleList.sort(new Comparator<DimRoleInfoModel>(){

            @Override
            public int compare(DimRoleInfoModel o1, DimRoleInfoModel o2) {
                return o1.getRoleId().compareTo(o2.getRoleId());
            }
        });
        for (DimRoleInfoModel dimRoleInfoModel : effectDimRoleList) {
            String roleId = dimRoleInfoModel.getRoleId();
            if (!hrRoleIds.contains(roleId)) continue;
            DynamicObject entryRow = influRoleEntry.addNew();
            Pair detail = roleInfo.get(roleId);
            entryRow.set("influrole_role", (Object)roleId);
            entryRow.set("influrole_rolenumber", detail.getLeft());
            entryRow.set("influrole_rolename", detail.getRight());
            entryRow.set("influrole_bucafunc", (Object)dimRoleInfoModel.getBuId());
            entryRow.set("influrole_dimension", (Object)dimRoleInfoModel.getDimensionId());
            String opType = dimRoleInfoModel.getOpType();
            entryRow.set("influrole_description", opNameMap.get(opType));
        }
        return effectRoleList;
    }

    private int fillEffectUserEntry(List<String> effectRoleList, DynamicObjectCollection userEntry) {
        HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        DynamicObject[] userRoleDys = userRoleHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("role", "in", effectRoleList)});
        HRBaseServiceHelper roleRoleHelper = new HRBaseServiceHelper("hrcs_role");
        DynamicObjectCollection roleColl = roleRoleHelper.queryOriginalCollection("id,isintersection", new QFilter[]{new QFilter("id", "in", effectRoleList)});
        Map<String, String> roleMap = roleColl.stream().collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("isintersection"), (newVal, oldVal) -> newVal));
        for (DynamicObject userRoleDy : userRoleDys) {
            DynamicObject entryRow = userEntry.addNew();
            String roleId = userRoleDy.getString("role.id");
            entryRow.set("influuser_role", (Object)roleId);
            entryRow.set("influuser_rolenumber", (Object)userRoleDy.getString("role.number"));
            entryRow.set("influuser_rolename", (Object)userRoleDy.getString("role.name"));
            entryRow.set("influuser_permfile", (Object)userRoleDy.getString("permfile.id"));
            entryRow.set("influuser_fileorgname", (Object)userRoleDy.getString("permfile.org.name"));
            entryRow.set("influuser_fileorgnumber", (Object)userRoleDy.getString("permfile.org.number"));
            entryRow.set("influuser_validstart", (Object)userRoleDy.getDate("validstart"));
            entryRow.set("influuser_validend", (Object)userRoleDy.getDate("validend"));
            entryRow.set("influuser_dataproperty", (Object)userRoleDy.getString("customenable"));
            entryRow.set("influuser_creator", (Object)userRoleDy.getLong("creator.id"));
            entryRow.set("influuser_intersection", (Object)roleMap.get(roleId));
            entryRow.set("influuser_isuserforbidden", (Object)userRoleDy.getString("user.isforbidden"));
        }
        return userRoleDys.length;
    }
}

