/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.log.handler;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.log.PermLogHandler;
import kd.hr.hrcs.bussiness.service.perm.log.handler.RoleLogBaseService;
import kd.hr.hrcs.common.constants.perm.log.BDDataRuleModel;
import kd.hr.hrcs.common.constants.perm.log.DataRangeLogModel;
import kd.hr.hrcs.common.constants.perm.log.DataRuleModel;
import kd.hr.hrcs.common.constants.perm.log.DimGrpLogModel;
import kd.hr.hrcs.common.constants.perm.log.FieldModel;
import kd.hr.hrcs.common.constants.perm.log.FieldPermLogModel;
import kd.hr.hrcs.common.constants.perm.log.FunctionItemLogModel;
import kd.hr.hrcs.common.constants.perm.log.MulValue;
import kd.hr.hrcs.common.constants.perm.log.RoleDimLogModel;
import kd.hr.hrcs.common.constants.perm.log.RoleInfoLogModel;
import kd.hr.hrcs.common.constants.perm.log.ScopeModel;

@ExcludeFromJacocoGeneratedReport
public class RoleAddLogHandler
extends PermLogHandler {
    private static final Log LOGGER = LogFactory.getLog(RoleAddLogHandler.class);
    private static final HRBaseServiceHelper PERM_LOG_HELPER = new HRBaseServiceHelper("hrcs_permlog");

    @Override
    public void doHandler(DynamicObject permLog) {
        try {
            String afterOpData = permLog.getString("afteropdata");
            RoleInfoLogModel afterRoleInfo = (RoleInfoLogModel)SerializationUtils.fromJsonString((String)afterOpData, RoleInfoLogModel.class);
            List fieldModelList = afterRoleInfo.getFieldModelList();
            DynamicObjectCollection baseInfoEntry = permLog.getDynamicObjectCollection("baseinfoentry");
            block2: for (FieldModel fieldModel : fieldModelList) {
                DynamicObject baseinfoentry = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("baseinfoentry");
                baseinfoentry.set("baseinfo_changefield", (Object)fieldModel.getPropName());
                baseinfoentry.set("baseinfo_beforedata", (Object)"");
                baseinfoentry.set("baseinfo_description", (Object)RoleLogBaseService.getInstance().getAddStr());
                if (HRStringUtils.equals((String)fieldModel.getPropNum(), (String)"rolename") || HRStringUtils.equals((String)fieldModel.getPropNum(), (String)"roleremark")) {
                    baseinfoentry.set("baseinfo_afterdata", (Object)RoleAddLogHandler.getLocaleName(fieldModel.getMulValueList()));
                    for (MulValue mulValue : fieldModel.getMulValueList()) {
                        if (!HRStringUtils.isNotEmpty((String)mulValue.getValue())) continue;
                        baseInfoEntry.add((Object)baseinfoentry);
                        continue block2;
                    }
                    continue;
                }
                baseinfoentry.set("baseinfo_afterdata", (Object)fieldModel.getVal());
                if (!HRStringUtils.isNotEmpty((String)fieldModel.getVal())) continue;
                baseInfoEntry.add((Object)baseinfoentry);
            }
            List functionItemLogModelList = afterRoleInfo.getFunctionItemLogModelList();
            DynamicObjectCollection roleFuncEntry = permLog.getDynamicObjectCollection("rolefuncentry");
            for (FunctionItemLogModel functionItemLogModel : functionItemLogModelList) {
                DynamicObject entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rolefuncentry");
                RoleLogBaseService.getInstance().setBaseInfoFuncEntry(functionItemLogModel, entryDyna);
                entryDyna.set("rolefunc_description", (Object)RoleLogBaseService.getInstance().getAddStr());
                roleFuncEntry.add((Object)entryDyna);
            }
            List roleDimLogModelList = afterRoleInfo.getRoleDimLogModelList();
            DynamicObjectCollection roleDimEntry = permLog.getDynamicObjectCollection("roledimentry");
            for (Object roleDimLogModel : roleDimLogModelList) {
                DynamicObject entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roledimentry");
                RoleLogBaseService.getInstance().setBaseInfoRoleDimEntry((RoleDimLogModel)roleDimLogModel, entryDyna);
                entryDyna.set("roledim_beforedata", (Object)"");
                entryDyna.set("roledim_afterdata", (Object)RoleLogBaseService.getInstance().getCheckDimStr(roleDimLogModel.getCheck()));
                entryDyna.set("roledim_description", (Object)RoleLogBaseService.getInstance().getAddStr());
                roleDimEntry.add((Object)entryDyna);
            }
            this.handleDataRange(permLog, afterRoleInfo);
            List fieldPermLogModelList = afterRoleInfo.getFieldPermLogModelList();
            for (FieldPermLogModel fieldPermLogModel : fieldPermLogModelList) {
                DynamicObject entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rangefieldentry");
                DynamicObjectCollection rangeFieldEntry = permLog.getDynamicObjectCollection("rangefieldentry");
                RoleLogBaseService.getInstance().setRoleFieldEntry(fieldPermLogModel, entryDyna);
                entryDyna.set("rolefield_beforedata", (Object)"");
                entryDyna.set("rolefield_afterdata", (Object)RoleLogBaseService.getInstance().getRoleFieldString(fieldPermLogModel));
                entryDyna.set("rolefield_description", (Object)RoleLogBaseService.getInstance().getAddStr());
                rangeFieldEntry.add((Object)entryDyna);
            }
            List scopeModelList = afterRoleInfo.getScopeModelList();
            DynamicObjectCollection roleOpenEntry = permLog.getDynamicObjectCollection("roleopenentry");
            for (ScopeModel scopeModel : scopeModelList) {
                DynamicObject entry = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roleopenentry");
                entry.set("roleopen_admingroup", (Object)scopeModel.getAdminGroupId());
                entry.set("roleopen_admingroupnumber", (Object)scopeModel.getAdminGroupNumber());
                entry.set("roleopen_admingroupname", (Object)scopeModel.getAdminGroupName());
                entry.set("roleopen_beforedata", (Object)"");
                entry.set("roleopen_afterdata", (Object)RoleLogBaseService.getInstance().getScopeStr(scopeModel));
                entry.set("roleopen_description", (Object)RoleLogBaseService.getInstance().getAddStr());
                RoleLogBaseService.getInstance().getUserDynamicObjects(scopeModel, entry);
                roleOpenEntry.add((Object)entry);
            }
            permLog.set("rolenumber", (Object)afterRoleInfo.getRoleNumber());
            permLog.set("rolename", (Object)afterRoleInfo.getRoleName());
            permLog.set("hashandle", (Object)true);
            permLog.set("influusernumber", (Object)0);
            permLog.set("description", (Object)String.format(ResManager.loadKDString((String)"\u65b0\u589e\u201c%1$s %2$s\u201d\u3002", (String)"RoleAddLogHandler_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), afterRoleInfo.getRoleNumber(), afterRoleInfo.getRoleName()));
            PERM_LOG_HELPER.saveOne(permLog);
        }
        catch (Exception ex) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.handler.RoleAddLogHandler", (Throwable)ex);
        }
    }

    private static String getLocaleName(List<MulValue> mulValues) {
        if (mulValues == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (MulValue mulValue : mulValues) {
            sb.append(mulValue.getName()).append(":");
            sb.append(mulValue.getValue()).append("\n");
        }
        return sb.toString();
    }

    private void handleDataRange(DynamicObject dyn, RoleInfoLogModel afterRoleInfo) {
        DynamicObject entryDyna;
        List dataRangeLogModelList = afterRoleInfo.getDataRangeLogModelList();
        DynamicObjectCollection rangeOrgDataEntry = dyn.getDynamicObjectCollection("rangeorgentry");
        for (Object dataRangeLogModel : dataRangeLogModelList) {
            DynamicObject entryDyna2 = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rangeorgentry");
            entryDyna2.set("rangeorg_bucafunc", (Object)dataRangeLogModel.getBuCaFuncId());
            entryDyna2.set("rangeorg_beforeorgs", (Object)"");
            List orgRangeList = dataRangeLogModel.getOrgRangeList();
            if (CollectionUtils.isNotEmpty((Collection)orgRangeList)) {
                entryDyna2.set("rangeorg_afterorgs", (Object)RoleLogBaseService.getInstance().getOrgStr(orgRangeList));
            }
            entryDyna2.set("rangeorg_description", (Object)RoleLogBaseService.getInstance().getAddStr());
            rangeOrgDataEntry.add((Object)entryDyna2);
        }
        DynamicObjectCollection rangeDataEntry = dyn.getDynamicObjectCollection("rangebizentry");
        for (DataRangeLogModel dataRangeLogModel : dataRangeLogModelList) {
            List dimValues = dataRangeLogModel.getDimValues();
            RoleLogBaseService.getInstance().setDimValName(dimValues);
            for (DimGrpLogModel dimGrpLogModel : dimValues) {
                DynamicObject entryDyna3 = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rangebizentry");
                entryDyna3.set("rangebiz_bucafunc", (Object)dataRangeLogModel.getBuCaFuncId());
                entryDyna3.set("rangebiz_beforebizdata", (Object)"");
                String sb = RoleLogBaseService.getInstance().getDimDisValue(dimGrpLogModel);
                entryDyna3.set("rangebiz_afterbizdata", (Object)sb);
                entryDyna3.set("rangebiz_description", (Object)RoleLogBaseService.getInstance().getAddStr());
                rangeDataEntry.add((Object)entryDyna3);
            }
        }
        List bdDataRuleModelList = afterRoleInfo.getBdDataRuleModelList();
        List dataRuleModelList = afterRoleInfo.getDataRuleModelList();
        DynamicObjectCollection rangeDrEntry = dyn.getDynamicObjectCollection("rangedrentry");
        DynamicObjectCollection rangeBdEntry = dyn.getDynamicObjectCollection("rangebddrentry");
        List<Long> bdDataRuleIds = bdDataRuleModelList.stream().map(BDDataRuleModel::getDataRuleId).collect(Collectors.toList());
        List dataRuleIds = dataRuleModelList.stream().map(DataRuleModel::getDataRuleId).collect(Collectors.toList());
        bdDataRuleIds.addAll(dataRuleIds);
        Map<Long, String> map = RoleLogBaseService.getInstance().getLongStringMap(bdDataRuleIds);
        for (BDDataRuleModel bdDataRuleModel : bdDataRuleModelList) {
            entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rangebddrentry");
            RoleLogBaseService.getInstance().getBdEntry(bdDataRuleModel, entryDyna);
            entryDyna.set("rolebddr_beforedr", null);
            entryDyna.set("rolebddr_beforedrdesc", (Object)"");
            entryDyna.set("rolebddr_afterdr", (Object)bdDataRuleModel.getDataRuleId());
            entryDyna.set("rolebddr_afterdrdesc", (Object)map.get(bdDataRuleModel.getDataRuleId()));
            entryDyna.set("rolebddr_description", (Object)RoleLogBaseService.getInstance().getAddStr());
            rangeBdEntry.add((Object)entryDyna);
        }
        for (DataRuleModel dataRuleModel : dataRuleModelList) {
            entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rangedrentry");
            RoleLogBaseService.getInstance().getDrEntry(dataRuleModel, entryDyna);
            entryDyna.set("roledr_beforedr", null);
            entryDyna.set("roledr_beforedrdesc", (Object)"");
            entryDyna.set("roledr_afterdr", (Object)dataRuleModel.getDataRuleId());
            entryDyna.set("roledr_afterdrdesc", (Object)map.get(dataRuleModel.getDataRuleId()));
            entryDyna.set("roledr_description", (Object)RoleLogBaseService.getInstance().getAddStr());
            rangeDrEntry.add((Object)entryDyna);
        }
    }
}

