/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.log.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.log.PermLogHandler;
import kd.hr.hrcs.bussiness.service.perm.log.handler.RoleAddLogHandler;
import kd.hr.hrcs.bussiness.service.perm.log.handler.RoleLogBaseService;
import kd.hr.hrcs.common.constants.perm.log.BDDataRuleModel;
import kd.hr.hrcs.common.constants.perm.log.DataRangeLogModel;
import kd.hr.hrcs.common.constants.perm.log.DataRuleModel;
import kd.hr.hrcs.common.constants.perm.log.DimGrpLogModel;
import kd.hr.hrcs.common.constants.perm.log.FieldModel;
import kd.hr.hrcs.common.constants.perm.log.FieldPermLogModel;
import kd.hr.hrcs.common.constants.perm.log.FunctionItemLogModel;
import kd.hr.hrcs.common.constants.perm.log.MulValue;
import kd.hr.hrcs.common.constants.perm.log.RoleDimLogModel;
import kd.hr.hrcs.common.constants.perm.log.RoleInfoLogModel;
import kd.hr.hrcs.common.constants.perm.log.RoleUserFileModel;
import kd.hr.hrcs.common.constants.perm.log.ScopeModel;

@ExcludeFromJacocoGeneratedReport
public class RoleDeleteLogHandler
extends PermLogHandler {
    private static final Log LOGGER = LogFactory.getLog(RoleAddLogHandler.class);
    private static final HRBaseServiceHelper PERM_LOG_HELPER = new HRBaseServiceHelper("hrcs_permlog");

    @Override
    public void doHandler(DynamicObject dyn) {
        try {
            String beforeOpData = dyn.getString("beforeopdata");
            RoleInfoLogModel beforeRoleInfo = (RoleInfoLogModel)SerializationUtils.fromJsonString((String)beforeOpData, RoleInfoLogModel.class);
            List fieldModelList = beforeRoleInfo.getFieldModelList();
            DynamicObjectCollection baseInfoEntry = dyn.getDynamicObjectCollection("baseinfoentry");
            block2: for (FieldModel fieldModel : fieldModelList) {
                DynamicObject infoEntry = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("baseinfoentry");
                infoEntry.set("baseinfo_changefield", (Object)fieldModel.getPropName());
                infoEntry.set("baseinfo_afterdata", (Object)"");
                infoEntry.set("baseinfo_description", (Object)RoleLogBaseService.getInstance().getDelStr());
                if (HRStringUtils.equals((String)fieldModel.getPropNum(), (String)"rolename") || HRStringUtils.equals((String)fieldModel.getPropNum(), (String)"roleremark")) {
                    infoEntry.set("baseinfo_beforedata", (Object)RoleDeleteLogHandler.getLocaleName(fieldModel.getMulValueList()));
                    for (MulValue mulValue : fieldModel.getMulValueList()) {
                        if (!HRStringUtils.isNotEmpty((String)mulValue.getValue())) continue;
                        baseInfoEntry.add((Object)infoEntry);
                        continue block2;
                    }
                    continue;
                }
                infoEntry.set("baseinfo_beforedata", (Object)fieldModel.getVal());
                if (!HRStringUtils.isNotEmpty((String)fieldModel.getVal())) continue;
                baseInfoEntry.add((Object)infoEntry);
            }
            List functionItemLogModelList = beforeRoleInfo.getFunctionItemLogModelList();
            DynamicObjectCollection roleFuncEntry = dyn.getDynamicObjectCollection("rolefuncentry");
            for (FunctionItemLogModel functionItemLogModel : functionItemLogModelList) {
                DynamicObject entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rolefuncentry");
                RoleLogBaseService.getInstance().setBaseInfoFuncEntry(functionItemLogModel, entryDyna);
                entryDyna.set("rolefunc_description", (Object)RoleLogBaseService.getInstance().getDelStr());
                roleFuncEntry.add((Object)entryDyna);
            }
            List roleDimLogModelList = beforeRoleInfo.getRoleDimLogModelList();
            DynamicObjectCollection roleDimEntry = dyn.getDynamicObjectCollection("roledimentry");
            for (Object roleDimLogModel : roleDimLogModelList) {
                DynamicObject entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roledimentry");
                RoleLogBaseService.getInstance().setBaseInfoRoleDimEntry((RoleDimLogModel)roleDimLogModel, entryDyna);
                entryDyna.set("roledim_beforedata", (Object)RoleLogBaseService.getInstance().getCheckDimStr(roleDimLogModel.getCheck()));
                entryDyna.set("roledim_afterdata", (Object)"");
                entryDyna.set("roledim_description", (Object)RoleLogBaseService.getInstance().getDelStr());
                roleDimEntry.add((Object)entryDyna);
            }
            this.handleDataRange(dyn, beforeRoleInfo);
            List fieldPermLogModelList = beforeRoleInfo.getFieldPermLogModelList();
            for (FieldPermLogModel fieldPermLogModel : fieldPermLogModelList) {
                DynamicObject entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rangefieldentry");
                DynamicObjectCollection rangeFieldEntry = dyn.getDynamicObjectCollection("rangefieldentry");
                RoleLogBaseService.getInstance().setRoleFieldEntry(fieldPermLogModel, entryDyna);
                entryDyna.set("rolefield_beforedata", (Object)RoleLogBaseService.getInstance().getRoleFieldString(fieldPermLogModel));
                entryDyna.set("rolefield_afterdata", (Object)"");
                entryDyna.set("rolefield_description", (Object)RoleLogBaseService.getInstance().getDelStr());
                rangeFieldEntry.add((Object)entryDyna);
            }
            List scopeModelList = beforeRoleInfo.getScopeModelList();
            DynamicObjectCollection roleOpenEntry = dyn.getDynamicObjectCollection("roleopenentry");
            for (ScopeModel scopeModel : scopeModelList) {
                DynamicObject entry = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roleopenentry");
                entry.set("roleopen_admingroup", (Object)scopeModel.getAdminGroupId());
                entry.set("roleopen_admingroupnumber", (Object)scopeModel.getAdminGroupNumber());
                entry.set("roleopen_admingroupname", (Object)scopeModel.getAdminGroupName());
                entry.set("roleopen_beforedata", (Object)RoleLogBaseService.getInstance().getScopeStr(scopeModel));
                entry.set("roleopen_afterdata", (Object)"");
                entry.set("roleopen_description", (Object)RoleLogBaseService.getInstance().getDelStr());
                RoleLogBaseService.getInstance().getUserDynamicObjects(scopeModel, entry);
                roleOpenEntry.add((Object)entry);
            }
            DynamicObjectCollection inUserEntry = dyn.getDynamicObjectCollection("influuserentry");
            List roleUserFileModelList = beforeRoleInfo.getRoleUserFileModelList();
            List permFileIds = roleUserFileModelList.stream().map(RoleUserFileModel::getPermFileId).collect(Collectors.toList());
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
            DynamicObject[] permFileDys = helper.loadDynamicObjectArray(permFileIds.toArray());
            Map<Long, DynamicObject> dynamicObjectMap = Arrays.stream(permFileDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
            for (RoleUserFileModel roleUserFileModel : roleUserFileModelList) {
                DynamicObject entry = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roleopenentry");
                RoleLogBaseService.getInstance().getBaseInfoUserFiles(dynamicObjectMap, beforeRoleInfo, roleUserFileModel, entry);
                inUserEntry.add((Object)entry);
            }
            dyn.set("rolenumber", (Object)beforeRoleInfo.getRoleNumber());
            dyn.set("rolename", (Object)beforeRoleInfo.getRoleName());
            dyn.set("hashandle", (Object)true);
            dyn.set("influusernumber", (Object)roleUserFileModelList.size());
            dyn.set("description", (Object)String.format(ResManager.loadKDString((String)"\u5220\u9664\u201c%1$s %2$s\u201d\u3002", (String)"RoleDeleteLogHandler_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), beforeRoleInfo.getRoleNumber(), beforeRoleInfo.getRoleName()));
            PERM_LOG_HELPER.saveOne(dyn);
        }
        catch (Exception ex) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.handler.RoleDeleteLogHandler", (Throwable)ex);
        }
    }

    private static String getLocaleName(List<MulValue> mulValues) {
        if (mulValues == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (MulValue mulValue : mulValues) {
            sb.append(mulValue.getName()).append(":");
            sb.append(mulValue.getValue()).append("\n");
        }
        return sb.toString();
    }

    private void handleDataRange(DynamicObject dyn, RoleInfoLogModel beforeRoleInfo) {
        DynamicObject entryDyna;
        List dataRangeLogModelList = beforeRoleInfo.getDataRangeLogModelList();
        DynamicObjectCollection rangeOrgDataEntry = dyn.getDynamicObjectCollection("rangeorgentry");
        for (Object dataRangeLogModel : dataRangeLogModelList) {
            DynamicObject entryDyna2 = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rangeorgentry");
            entryDyna2.set("rangeorg_bucafunc", (Object)dataRangeLogModel.getBuCaFuncId());
            entryDyna2.set("rangeorg_afterorgs", (Object)"");
            List orgRangeList = dataRangeLogModel.getOrgRangeList();
            if (CollectionUtils.isNotEmpty((Collection)orgRangeList)) {
                entryDyna2.set("rangeorg_beforeorgs", (Object)RoleLogBaseService.getInstance().getOrgStr(orgRangeList));
            }
            entryDyna2.set("rangeorg_description", (Object)RoleLogBaseService.getInstance().getDelStr());
            rangeOrgDataEntry.add((Object)entryDyna2);
        }
        DynamicObjectCollection rangeDataEntry = dyn.getDynamicObjectCollection("rangebizentry");
        for (DataRangeLogModel dataRangeLogModel : dataRangeLogModelList) {
            List dimValues = dataRangeLogModel.getDimValues();
            RoleLogBaseService.getInstance().setDimValName(dimValues);
            for (DimGrpLogModel dimGrpLogModel : dimValues) {
                DynamicObject entryDyna3 = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rangebizentry");
                entryDyna3.set("rangebiz_bucafunc", (Object)dataRangeLogModel.getBuCaFuncId());
                entryDyna3.set("rangebiz_afterbizdata", (Object)"");
                String sb = RoleLogBaseService.getInstance().getDimDisValue(dimGrpLogModel);
                entryDyna3.set("rangebiz_beforebizdata", (Object)sb);
                entryDyna3.set("rangebiz_description", (Object)RoleLogBaseService.getInstance().getDelStr());
                rangeDataEntry.add((Object)entryDyna3);
            }
        }
        List bdDataRuleModelList = beforeRoleInfo.getBdDataRuleModelList();
        List dataRuleModelList = beforeRoleInfo.getDataRuleModelList();
        DynamicObjectCollection rangeDrEntry = dyn.getDynamicObjectCollection("rangedrentry");
        DynamicObjectCollection rangeBdEntry = dyn.getDynamicObjectCollection("rangebddrentry");
        List<Long> bdDataRuleIds = bdDataRuleModelList.stream().map(BDDataRuleModel::getDataRuleId).collect(Collectors.toList());
        List dataRuleIds = dataRuleModelList.stream().map(DataRuleModel::getDataRuleId).collect(Collectors.toList());
        bdDataRuleIds.addAll(dataRuleIds);
        Map<Long, String> map = RoleLogBaseService.getInstance().getLongStringMap(bdDataRuleIds);
        for (BDDataRuleModel bdDataRuleModel : bdDataRuleModelList) {
            entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rangebddrentry");
            RoleLogBaseService.getInstance().getBdEntry(bdDataRuleModel, entryDyna);
            entryDyna.set("rolebddr_beforedr", (Object)bdDataRuleModel.getDataRuleId());
            entryDyna.set("rolebddr_beforedrdesc", (Object)map.get(bdDataRuleModel.getDataRuleId()));
            entryDyna.set("rolebddr_afterdr", null);
            entryDyna.set("rolebddr_afterdrdesc", (Object)"");
            entryDyna.set("rolebddr_description", (Object)RoleLogBaseService.getInstance().getDelStr());
            rangeBdEntry.add((Object)entryDyna);
        }
        for (DataRuleModel dataRuleModel : dataRuleModelList) {
            entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rangedrentry");
            RoleLogBaseService.getInstance().getDrEntry(dataRuleModel, entryDyna);
            entryDyna.set("roledr_beforedr", (Object)dataRuleModel.getDataRuleId());
            entryDyna.set("roledr_beforedrdesc", (Object)map.get(dataRuleModel.getDataRuleId()));
            entryDyna.set("roledr_afterdr", null);
            entryDyna.set("roledr_afterdrdesc", (Object)"");
            entryDyna.set("roledr_description", (Object)RoleLogBaseService.getInstance().getDelStr());
            rangeDrEntry.add((Object)entryDyna);
        }
    }
}

