/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.log.handler;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RoleAssignLogBussinessHelper;
import kd.hr.hrcs.common.constants.perm.log.BDDataRuleModel;
import kd.hr.hrcs.common.constants.perm.log.DataRangeLogModel;
import kd.hr.hrcs.common.constants.perm.log.DataRuleModel;
import kd.hr.hrcs.common.constants.perm.log.DimGrpLogModel;
import kd.hr.hrcs.common.constants.perm.log.DimLogModel;
import kd.hr.hrcs.common.constants.perm.log.FieldPermLogModel;
import kd.hr.hrcs.common.constants.perm.log.FunctionItemLogModel;
import kd.hr.hrcs.common.constants.perm.log.OrgModel;
import kd.hr.hrcs.common.constants.perm.log.RoleDimLogModel;
import kd.hr.hrcs.common.constants.perm.log.RoleInfoLogModel;
import kd.hr.hrcs.common.constants.perm.log.RoleUserFileModel;
import kd.hr.hrcs.common.constants.perm.log.ScopeModel;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class RoleLogBaseService {
    private static volatile RoleLogBaseService service = null;
    private static final HRBaseServiceHelper DATA_RULE_HELPER = new HRBaseServiceHelper("hrcs_datarule");
    private static final Log LOGGER = LogFactory.getLog(RoleLogBaseService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RoleLogBaseService getInstance() {
        if (service != null) return service;
        Class<RoleLogBaseService> clazz = RoleLogBaseService.class;
        synchronized (RoleLogBaseService.class) {
            if (service != null) return service;
            service = new RoleLogBaseService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    private RoleLogBaseService() {
    }

    public String getCheckDimStr(boolean check) {
        String str = check ? ResManager.loadKDString((String)"\u5f00", (String)"RoleLogBaseHandler_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5173", (String)"RoleLogBaseHandler_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        return String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u63a7\u6743\uff1a%s", (String)"RoleLogBaseHandler_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]), str);
    }

    private String getStringVal(boolean view) {
        return view ? ResManager.loadKDString((String)"\u5141\u8bb8", (String)"RoleLogBaseHandler_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8", (String)"RoleLogBaseHandler_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public String getRoleFieldString(FieldPermLogModel fieldPermLogModel) {
        String viewStr = String.format(ResManager.loadKDString((String)"\u67e5\u770b\uff1a%s\u3002", (String)"RoleLogBaseHandler_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getStringVal(!fieldPermLogModel.getView()));
        String editStr = String.format(ResManager.loadKDString((String)"\u7f16\u8f91\uff1a%s\u3002", (String)"RoleLogBaseHandler_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getStringVal(!fieldPermLogModel.getEdit()));
        return viewStr + "\n" + editStr;
    }

    public String getBeforeRoleFieldString(FieldPermLogModel fieldPermLogModel, boolean isEditModify, boolean isViewModify) {
        String viewStr = String.format(ResManager.loadKDString((String)"\u67e5\u770b\uff1a%s\u3002", (String)"RoleLogBaseHandler_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getStringVal(!fieldPermLogModel.getBeforeView()));
        String editStr = String.format(ResManager.loadKDString((String)"\u7f16\u8f91\uff1a%s\u3002", (String)"RoleLogBaseHandler_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getStringVal(!fieldPermLogModel.getBeforeEdit()));
        if (isEditModify && isViewModify) {
            return viewStr + "\n" + editStr;
        }
        if (isViewModify) {
            return viewStr;
        }
        return editStr;
    }

    public String getScopeStr(ScopeModel scopeModel) {
        return String.format(ResManager.loadKDString((String)"\u4fee\u6539\u89d2\u8272\uff1a%s\u3002", (String)"RoleLogBaseHandler_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getStringVal(scopeModel.getModifiable()));
    }

    public String getBeforeScopeStr(ScopeModel scopeModel) {
        return String.format(ResManager.loadKDString((String)"\u4fee\u6539\u89d2\u8272\uff1a%s\u3002", (String)"RoleLogBaseHandler_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getStringVal(!scopeModel.getModifiable()));
    }

    public String getContainSubStr() {
        return ResManager.loadKDString((String)"\uff08\u5305\u542b\u4e0b\u7ea7\uff09", (String)"RoleLogBaseHandler_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public String getAllStr() {
        return ResManager.loadKDString((String)"\u4e0d\u9650", (String)"RoleLogBaseHandler_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public String getAddStr() {
        return ResManager.loadKDString((String)"\u65b0\u589e", (String)"RoleLogBaseHandler_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public String getDelStr() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"RoleLogBaseHandler_12", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public String getModifyStr() {
        return ResManager.loadKDString((String)"\u4fee\u6539", (String)"RoleLogBaseHandler_13", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public String getDimDisValue(DimGrpLogModel grpLogModel) {
        StringBuilder sb = new StringBuilder();
        List dimLogModelList = grpLogModel.getDimValues();
        List orgDimLogModelList = dimLogModelList.stream().filter(dimLogModel -> dimLogModel.getStructProject() != 0L).collect(Collectors.toList());
        Map<Long, List<DimLogModel>> orgGroupDimLogModelMap = orgDimLogModelList.stream().collect(Collectors.groupingBy(DimLogModel::getStructProject));
        for (Map.Entry<Long, List<DimLogModel>> longListEntry : orgGroupDimLogModelMap.entrySet()) {
            List<DimLogModel> longListEntryValue = longListEntry.getValue();
            for (int i = 0; i < longListEntryValue.size(); ++i) {
                DimLogModel dimLogModel2 = longListEntryValue.get(i);
                boolean adminContainsSub = dimLogModel2.getAdminContainsSub();
                boolean containsSub = dimLogModel2.getContainsSub();
                String valType = dimLogModel2.getValType();
                if (HRStringUtils.equals((String)"2", (String)valType)) {
                    if (i == 0) {
                        sb.append("\u3010").append(dimLogModel2.getDimName()).append("-").append(dimLogModel2.getStructProjectName()).append("\u3011").append(":").append(dimLogModel2.getDimValName());
                        continue;
                    }
                    sb.append(",").append(dimLogModel2.getDimValName());
                    continue;
                }
                if (i == 0) {
                    sb.append("\u3010").append(dimLogModel2.getDimName()).append("-").append(dimLogModel2.getStructProjectName()).append("\u3011").append(":").append(dimLogModel2.getDimValName()).append(adminContainsSub || containsSub ? this.getContainSubStr() : "");
                    continue;
                }
                sb.append(",").append(dimLogModel2.getDimValName()).append(adminContainsSub || containsSub ? this.getContainSubStr() : "");
            }
            sb.append("\n");
        }
        List otherDimLogModelList = dimLogModelList.stream().filter(dimLogModel -> dimLogModel.getStructProject() == 0L).collect(Collectors.toList());
        Map<Long, List<DimLogModel>> groupDimLogModelMap = otherDimLogModelList.stream().collect(Collectors.groupingBy(DimLogModel::getDimId));
        for (Map.Entry<Long, List<DimLogModel>> longListEntry : groupDimLogModelMap.entrySet()) {
            List<DimLogModel> longListEntryValue = longListEntry.getValue();
            for (int i = 0; i < longListEntryValue.size(); ++i) {
                DimLogModel dimLogModel3 = longListEntryValue.get(i);
                boolean all = dimLogModel3.getAll();
                boolean adminContainsSub = dimLogModel3.getAdminContainsSub();
                boolean containsSub = dimLogModel3.getContainsSub();
                if (i == 0) {
                    sb.append("\u3010").append(dimLogModel3.getDimName()).append("\u3011").append(":").append(all ? this.getAllStr() : dimLogModel3.getDimValName() + (adminContainsSub || containsSub ? this.getContainSubStr() : ""));
                    continue;
                }
                sb.append(",").append(dimLogModel3.getDimValName()).append(adminContainsSub || containsSub ? this.getContainSubStr() : "");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setDimValName(List<DimGrpLogModel> dimValues) {
        HRBaseServiceHelper dynaCondHelper = new HRBaseServiceHelper("hrcs_dynacond");
        for (DimGrpLogModel dimGrpLogModel : dimValues) {
            HashMap dimValueList = Maps.newHashMapWithExpectedSize((int)16);
            List logDimModelList = dimGrpLogModel.getDimValues();
            Map<Long, List<DimLogModel>> collect = logDimModelList.stream().collect(Collectors.groupingBy(DimLogModel::getDimId));
            for (Map.Entry<Long, List<DimLogModel>> longListEntry : collect.entrySet()) {
                List<DimLogModel> value = longListEntry.getValue();
                List valList = value.stream().map(DimLogModel::getDimVal).collect(Collectors.toList());
                dimValueList.put(longListEntry.getKey(), valList);
            }
            Map<Long, Map<String, Pair<String, String>>> dimValueMap = PermInitServiceHelper.structDimInfo(dimValueList);
            for (DimLogModel dimLogModel : dimGrpLogModel.getDimValues()) {
                long dimId = dimLogModel.getDimId();
                Long dynaCondId = dimLogModel.getDynaCondId();
                String valType = dimLogModel.getValType();
                if (HRStringUtils.equals((String)"2", (String)valType)) {
                    DynamicObject dynamicObject;
                    String dynaPermRangeName = "";
                    if (dynaCondId == null || dynaCondId == 0L || (dynamicObject = dynaCondHelper.queryOne((Object)dynaCondId)) == null) continue;
                    dynaPermRangeName = dynamicObject.getLocaleString("name").getLocaleValue();
                    dimLogModel.setDimValName(dynaPermRangeName);
                    continue;
                }
                Map<String, Pair<String, String>> stringPairMap = dimValueMap.get(dimId);
                if (stringPairMap == null) continue;
                dimLogModel.setDimValName(stringPairMap.get(dimLogModel.getDimVal()) == null ? "" : (String)stringPairMap.get(dimLogModel.getDimVal()).getLeft());
            }
        }
    }

    public String getComboItemTittle(String entityNumber, String fieldName, String value) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldName);
        List comboItems = ((ComboProp)property).getComboItems();
        for (ValueMapItem comboItem : comboItems) {
            if (!HRStringUtils.equals((String)comboItem.getValue(), (String)value)) continue;
            return comboItem.getName().getLocaleValue();
        }
        return "";
    }

    public void getBaseInfoUserFiles(Map<Long, DynamicObject> dynamicObjectMap, RoleInfoLogModel beforeRoleInfo, RoleUserFileModel roleUserFileModel, DynamicObject entry) {
        entry.set("influuser_role", (Object)roleUserFileModel.getRoleId());
        entry.set("influuser_rolenumber", (Object)beforeRoleInfo.getRoleNumber());
        entry.set("influuser_rolename", (Object)beforeRoleInfo.getRoleName());
        entry.set("influuser_permfile", (Object)roleUserFileModel.getPermFileId());
        DynamicObject dynamicObject = dynamicObjectMap.get(roleUserFileModel.getPermFileId());
        if (dynamicObject != null) {
            entry.set("influuser_fileorgnumber", (Object)dynamicObject.getString("org.number"));
            entry.set("influuser_fileorgname", (Object)dynamicObject.getString("org.name"));
            entry.set("influuser_isuserforbidden", (Object)dynamicObject.getBoolean("user.isforbidden"));
        }
        try {
            entry.set("influuser_validstart", HRStringUtils.isEmpty((String)roleUserFileModel.getStartTime()) ? null : HRDateTimeUtils.parseDate((String)roleUserFileModel.getStartTime()));
            entry.set("influuser_validend", HRStringUtils.isEmpty((String)roleUserFileModel.getEndTime()) ? null : HRDateTimeUtils.parseDate((String)roleUserFileModel.getEndTime()));
            entry.set("influuser_createtime", HRStringUtils.isEmpty((String)roleUserFileModel.getCreateTime()) ? null : HRDateTimeUtils.parseDate((String)roleUserFileModel.getCreateTime()));
        }
        catch (ParseException ex) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.handler.RoleLogBaseService.getBaseInfoUserFiles", (Throwable)ex);
        }
        entry.set("influuser_dataproperty", (Object)roleUserFileModel.getDataProperty());
        entry.set("influuser_creator", (Object)roleUserFileModel.getCreatorId());
        entry.set("influuser_intersection", (Object)beforeRoleInfo.getRoleCBisIntersection());
    }

    public void getUserDynamicObjects(ScopeModel scopeModel, DynamicObject entry) {
        List userIds = scopeModel.getUserIds();
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            DynamicObjectCollection inFluAdmins = entry.getDynamicObjectCollection("roleopen_influadmin");
            DynamicObjectType inFluAdminsDynamicObjectType = inFluAdmins.getDynamicObjectType();
            for (Long userId : userIds) {
                DynamicObject orgDyna = new DynamicObject(inFluAdminsDynamicObjectType);
                orgDyna.set("fbasedataid", (Object)userId);
                inFluAdmins.add((Object)orgDyna);
            }
            entry.set("roleopen_influadmin", (Object)inFluAdmins);
        }
    }

    private void getOrgDys(DataRangeLogModel dataRangeLogModel, List<OrgModel> orgRangeList, DynamicObjectCollection orgRangeColl) {
        DynamicObjectType orgRangeType = orgRangeColl.getDynamicObjectType();
        for (OrgModel orgModel : orgRangeList) {
            DynamicObject orgDyna = new DynamicObject(orgRangeType);
            Long buCaFuncId = orgModel.getBuCaFuncId();
            if (!buCaFuncId.equals(dataRangeLogModel.getBuCaFuncId())) continue;
            orgDyna.set("fbasedataid", (Object)orgModel.getOrgId());
            orgRangeColl.add((Object)orgDyna);
        }
    }

    public void setBaseInfoRoleDimEntry(RoleDimLogModel roleDimLogModel, DynamicObject entryDyna) {
        entryDyna.set("roledim_bucafunc", (Object)roleDimLogModel.getBuCaFuncId());
        entryDyna.set("roledim_dimension", (Object)roleDimLogModel.getDimId());
        entryDyna.set("roledim_bizapp", (Object)roleDimLogModel.getAppId());
        entryDyna.set("roledim_entitytype", (Object)roleDimLogModel.getEntityNum());
        entryDyna.set("roledim_propkey", (Object)roleDimLogModel.getPropKey());
        entryDyna.set("roledim_propname", (Object)roleDimLogModel.getPropName());
    }

    public void setBaseInfoFuncEntry(FunctionItemLogModel functionItemLogModel, DynamicObject entryDyna) {
        entryDyna.set("rolefunc_bizapp", (Object)functionItemLogModel.getAppId());
        entryDyna.set("rolefunc_entitytype", (Object)functionItemLogModel.getEntityNum());
        entryDyna.set("rolefunc_permitem", (Object)functionItemLogModel.getPermItemId());
    }

    public void getDrEntry(DataRuleModel dataRuleModel, DynamicObject entryDyna) {
        entryDyna.set("roledr_bizapp", (Object)dataRuleModel.getAppId());
        entryDyna.set("roledr_entitytype", (Object)dataRuleModel.getEntityNum());
        entryDyna.set("roledr_permitem", (Object)dataRuleModel.getPermItemId());
    }

    public void getBdEntry(BDDataRuleModel bdDataRuleModel, DynamicObject entryDyna) {
        entryDyna.set("rolebddr_bizapp", (Object)bdDataRuleModel.getAppId());
        entryDyna.set("rolebddr_entitytype", (Object)bdDataRuleModel.getEntityNum());
        entryDyna.set("rolebddr_propkey", (Object)bdDataRuleModel.getFieldNumber());
        entryDyna.set("rolebddr_propname", (Object)bdDataRuleModel.getFieldName());
    }

    public void setRoleFieldEntry(FieldPermLogModel fieldPermLogModel, DynamicObject entryDyna) {
        entryDyna.set("rolefield_bizapp", (Object)fieldPermLogModel.getAppId());
        entryDyna.set("rolefield_entitytype", (Object)fieldPermLogModel.getEntityNum());
        entryDyna.set("rolefield_propkey", (Object)fieldPermLogModel.getFieldNumber());
        entryDyna.set("rolefield_propname", (Object)fieldPermLogModel.getFieldName());
    }

    public Map<Long, String> getLongStringMap(List<Long> bdDataRuleIds) {
        Map<Long, Pair> ruleMap = DATA_RULE_HELPER.queryOriginalCollection("id,entitynum,rule", new QFilter[]{new QFilter("id", "in", bdDataRuleIds)}).stream().collect(Collectors.toMap(it -> it.getLong("id"), it -> Pair.of((Object)it.getString("entitynum"), (Object)it.getString("rule")), (oldVal, newVal) -> oldVal));
        HashMap map = Maps.newHashMapWithExpectedSize((int)ruleMap.size());
        Set<Long> longs = ruleMap.keySet();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_datarule");
        DynamicObject[] dataRuleDyList = hrBaseServiceHelper.query("id,rule,entitynum", new QFilter[]{new QFilter("id", "in", longs)});
        Map<Long, List<DynamicObject>> dataRuleMap = Arrays.stream(dataRuleDyList).collect(Collectors.groupingBy(dataRule -> dataRule.getLong("id")));
        for (Map.Entry<Long, Pair> longPairEntry : ruleMap.entrySet()) {
            Long key = longPairEntry.getKey();
            Pair value = longPairEntry.getValue();
            String name = "";
            if (dataRuleMap.containsKey(key)) {
                name = dataRuleMap.get(key).get(0).getLocaleString("name").getLocaleValue();
            }
            String dataRuleDisplayText = RoleAssignLogBussinessHelper.getDataRuleDisplayText((String)value.getValue(), (String)value.getKey());
            map.put(key, name + ":" + dataRuleDisplayText);
        }
        return map;
    }

    public String getOrgStr(List<OrgModel> orgRangeList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < orgRangeList.size(); ++i) {
            String orgName = orgRangeList.get(i).getOrgName();
            boolean containsSub = orgRangeList.get(i).getContainsSub();
            if (i == orgRangeList.size() - 1) {
                sb.append(orgName).append(containsSub ? this.getContainSubStr() : "");
                continue;
            }
            sb.append(orgName).append(containsSub ? this.getContainSubStr() : "").append("\uff0c");
        }
        return sb.toString();
    }

    public Object getRoleFieldString(FieldPermLogModel fieldPermLogModel, boolean isEditModify, boolean isViewModify) {
        String viewStr = String.format(ResManager.loadKDString((String)"\u67e5\u770b\uff1a%s\u3002", (String)"RoleLogBaseHandler_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getStringVal(!fieldPermLogModel.getView()));
        String editStr = String.format(ResManager.loadKDString((String)"\u7f16\u8f91\uff1a%s\u3002", (String)"RoleLogBaseHandler_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getStringVal(!fieldPermLogModel.getEdit()));
        if (isEditModify && isViewModify) {
            return viewStr + "\n" + editStr;
        }
        if (isViewModify) {
            return viewStr;
        }
        return editStr;
    }
}

