/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.prompt;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;
import kd.hr.hrcs.bussiness.servicehelper.prompt.PromptServiceHelper;

public class PromptImportService {
    public static void addField(List<ExportHeaderWriterFormat> headerWriterFormats) {
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLang = intService.getEnabledLang();
        for (ExportHeaderWriterFormat headerWriterFormat : headerWriterFormats) {
            if (!"hrcs_prompt".equals(headerWriterFormat.getEnityName())) continue;
            for (EnabledLang lang : enabledLang) {
                String key = "promptcontent." + lang.getNumber();
                headerWriterFormat.getFields().add(key);
                HashMap property = Maps.newHashMapWithExpectedSize((int)10);
                property.put("DisplayName", ResManager.loadKDString((String)"\u5bcc\u6587\u672c\u6587\u6848(%s)", (String)"PromptBatchImportPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{lang.getName()}));
                property.put("InputType", "varchar");
                property.put("PropType", null);
                headerWriterFormat.getProperties().put(key, property);
            }
            if (CollectionUtils.isEmpty((Collection)headerWriterFormat.getNext())) continue;
            headerWriterFormat.getNext().forEach(n -> n.setStartColNumber(n.getStartColNumber() + enabledLang.size()));
        }
    }

    public static void writeContentData(List<Map<Integer, Map<String, Object>>> tplDataRows) {
        HashSet promptNumberSet = Sets.newHashSetWithExpectedSize((int)tplDataRows.size());
        for (Map<Integer, Map<String, Object>> row : tplDataRows) {
            Map<String, Object> map = row.get(0);
            promptNumberSet.add((String)map.get("val"));
        }
        DynamicObject[] prompts = PromptServiceHelper.getPrompts(promptNumberSet);
        HashSet promptIdSet = Sets.newHashSetWithExpectedSize((int)prompts.length);
        HashMap promptIdMap = Maps.newHashMapWithExpectedSize((int)prompts.length);
        for (DynamicObject prompt : prompts) {
            long id = prompt.getLong("id");
            promptIdSet.add(id);
            promptIdMap.put(prompt.getString("number"), id);
        }
        HRBaseServiceHelper contentHelper = new HRBaseServiceHelper("hrcs_promptcontent");
        DynamicObject[] promptContent = contentHelper.query("promptcontent,contenttext,locale,prompt", new QFilter[]{new QFilter("prompt", "in", (Object)promptIdSet)});
        Map<Long, List<DynamicObject>> contentGroup = Arrays.stream(promptContent).collect(Collectors.groupingBy(pc -> pc.getLong("prompt")));
        for (Map<Integer, Map<String, Object>> row : tplDataRows) {
            Map<String, Object> numMap = row.get(0);
            String number = (String)numMap.get("val");
            Long id = (Long)promptIdMap.get(number);
            List<DynamicObject> contents = contentGroup.get(id);
            if (contents == null) continue;
            Map<String, String> contentMap = contents.stream().collect(Collectors.toMap(ct -> ct.getString("locale.number"), ct -> ct.getString("promptcontent")));
            for (Map.Entry<Integer, Map<String, Object>> entry : row.entrySet()) {
                Map<String, Object> map = entry.getValue();
                String key = (String)map.get("key");
                if (!key.startsWith("promptcontent.")) continue;
                String localeNum = key.substring(key.lastIndexOf(".") + 1);
                String content = contentMap.get(localeNum);
                map.put("val", content);
            }
        }
    }
}

