/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hr.hbp.business.service.message.MsgCenterResult;
import kd.hr.hbp.business.servicehelper.HRAppServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRISVUtils;
import kd.hr.hbp.common.util.HRListUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.MsgWarningServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class MsgCenterServiceHelper {
    private static final Log logger = LogFactory.getLog(MsgCenterServiceHelper.class);
    private static final HRBaseServiceHelper APP_HELPER = new HRBaseServiceHelper("bos_devportal_bizapp");
    private static int QUERY_MSG_PARAMS_SIZE_MAX = 500;

    public static DynamicObject retryMsgToBu(DynamicObject dy, HRBaseServiceHelper msgCenterHelper, HRBaseServiceHelper pubServiceHelper, HRBaseServiceHelper subServiceHelper, Map<Long, Boolean> subInvokeResult) {
        if (dy == null) {
            return null;
        }
        HashMap messageMap = Maps.newHashMapWithExpectedSize((int)16);
        MsgCenterServiceHelper.buildMessageMap(dy, messageMap);
        QFilter pubQFilter = new QFilter("id", "=", (Object)dy.getLong("msgpublisher.id"));
        DynamicObject pubDy = Objects.requireNonNull(pubServiceHelper.queryOne("msgprobo.id,actioncloud.id,actionapp.id,publishbd.id", new QFilter[]{pubQFilter}));
        messageMap.put("msgProBo", pubDy.getLong("msgprobo.id"));
        messageMap.put("msgCloud", pubDy.get("actioncloud.id"));
        messageMap.put("msgApp", pubDy.get("actionapp.id"));
        messageMap.put("msgBusinessType", pubDy.get("publishbd.id"));
        DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("entryentity");
        StringBuilder subInvokeError = new StringBuilder();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            long subscribeId = dynamicObject.getLong("subscribe.id");
            try {
                Object recstatus;
                dynamicObject.set("consumertime", (Object)HRDateTimeUtils.curDate());
                if (null != subInvokeResult && (null == subInvokeResult.get(subscribeId) || subInvokeResult.get(subscribeId).booleanValue()) || null != (recstatus = dynamicObject.get("recstatus")) && recstatus.equals("A") || StringUtils.isNotEmpty((CharSequence)dy.getString("groupnum")) && MsgCenterServiceHelper.checkGroupStrategy(dy.getString("groupnum"), dy.getDate("createtime"), msgCenterHelper, subscribeId)) continue;
                Map<String, String> subMap = MsgCenterServiceHelper.getConsumerMap(subServiceHelper, subscribeId);
                if (subMap.isEmpty()) {
                    logger.error("******* retryMsgToBu:{},\u4e0d\u5b58\u5728", (Object)subscribeId);
                    continue;
                }
                String consumerCloudNumber = subMap.get("consumerCloudNumber");
                String consumerAppNumber = subMap.get("consumerAppNumber");
                String consumerService = subMap.get("consumerService");
                String consumerMethod = subMap.get("consumerMethod");
                DynamicObject tplDy = HRProducerServiceHelper.buildMsgDyObj((Map)messageMap, subMap);
                logger.info("******* Msg Send to CLOUD:{}, APP:{}, Service:{}, Method {},Number:{}", new Object[]{consumerCloudNumber, consumerAppNumber, consumerService, consumerMethod, dy.get("number")});
                Object result = null;
                result = !HRISVUtils.isKingdeeIsv((String)consumerAppNumber) || StringUtils.isNotEmpty((CharSequence)subMap.get("isnonoriginal")) && Boolean.parseBoolean(subMap.get("isnonoriginal")) ? HRMServiceHelper.invokeService((String)consumerCloudNumber, (String)consumerAppNumber, (String)consumerService, (String)consumerMethod, (Object[])new Object[]{tplDy}) : HRMServiceHelper.invokeBizService((String)consumerCloudNumber, (String)consumerAppNumber, (String)consumerService, (String)consumerMethod, (Object[])new Object[]{tplDy});
                MsgCenterServiceHelper.parseResult(dynamicObject, result);
                if (null == recstatus || recstatus.equals("B")) {
                    dynamicObject.set("recstatus", (Object)"A");
                    dynamicObject.set("recmessage", (Object)"");
                    continue;
                }
                dynamicObject.set("recstatus", (Object)"B");
                continue;
            }
            catch (Exception ex) {
                logger.error("******* retryMsgToBu \u6d88\u606f\u91cd\u8bd5\u5931\u8d25:{},number:{}", new Object[]{subscribeId, dy.get("number"), ex});
                subInvokeError.append("retryMsgToBu_error:").append(ex.getMessage());
                dynamicObject.set("recmessage", (Object)MsgCenterServiceHelper.subStringByMaxLeng(ex.getMessage(), 500));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)subInvokeError)) {
            throw new KDBizException(subInvokeError.toString());
        }
        return dy;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void parseResult(DynamicObject dynamicObject, Object result) {
        if (!(result instanceof HRMServiceResult)) {
            return;
        }
        HRMServiceResult hrmServiceResult = (HRMServiceResult)result;
        if (!"success".equalsIgnoreCase(hrmServiceResult.getReturnCode())) {
            throw new KDBizException(new ErrorCode(hrmServiceResult.getReturnCode(), hrmServiceResult.getMessage()), new Object[0]);
        }
        if (hrmServiceResult.getReturnData() instanceof MsgCenterResult) {
            MsgCenterResult returnData = (MsgCenterResult)hrmServiceResult.getReturnData();
            if (StringUtils.isNotEmpty((CharSequence)returnData.getHandleStatus())) {
                dynamicObject.set("handlestatus", (Object)returnData.getHandleStatus());
            }
            if (StringUtils.isNotEmpty((CharSequence)returnData.getConsumeMsg())) {
                dynamicObject.set("msgdescription", (Object)returnData.getConsumeMsg());
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static String subStringByMaxLeng(String str, int maxLength) {
        if (HRStringUtils.isEmpty((String)str) || str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength);
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean checkGroupStrategy(String groupNum, Date createTime, HRBaseServiceHelper msgCenterHelper, long subscribeId) {
        QFilter groupNumFilter = new QFilter("groupnum", "=", (Object)groupNum);
        QFilter statusFilter = new QFilter("entryentity.recstatus", "in", (Object)"B");
        QFilter largeTimeFilter = new QFilter("createtime", "<", (Object)createTime);
        QFilter subscribeFilter = new QFilter("entryentity.subscribe.id", "=", (Object)subscribeId);
        return msgCenterHelper.isExists(new QFilter[]{subscribeFilter, largeTimeFilter, statusFilter, groupNumFilter});
    }

    private static Map<String, String> getConsumerMap(HRBaseServiceHelper subServiceHelper, long subscribe) {
        HashMap subInfoMap = Maps.newHashMapWithExpectedSize((int)7);
        QFilter subQFilter = new QFilter("id", "=", (Object)subscribe);
        QFilter subStatus = new QFilter("substatus", "=", (Object)"1");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        subQFilter.and(subStatus).and(enable);
        DynamicObject subDy = subServiceHelper.queryOriginalOne("msgsubno,consumercloud.id,consumercloud.number,consumerapp.id,consumerapp.number,consumerservice,consumermethod,subscribebd,isnonoriginal", new QFilter[]{subQFilter});
        if (null == subDy) {
            logger.error("******* getConsumerMap.subscribe:{},is null", (Object)subscribe);
            return subInfoMap;
        }
        subInfoMap.put("msgSubNo", subDy.getString("msgsubno"));
        subInfoMap.put("consumerCloudId", subDy.getString("consumercloud.id"));
        subInfoMap.put("consumerCloudNumber", subDy.getString("consumercloud.number").toLowerCase(Locale.ROOT));
        subInfoMap.put("consumerAppId", subDy.getString("consumerapp.id"));
        subInfoMap.put("consumerAppNumber", subDy.getString("consumerapp.number"));
        subInfoMap.put("consumerService", subDy.getString("consumerservice"));
        subInfoMap.put("consumerMethod", subDy.getString("consumermethod"));
        subInfoMap.put("isnonoriginal", subDy.getString("isnonoriginal"));
        return subInfoMap;
    }

    private static void buildMessageMap(DynamicObject dy, Map<String, Object> messageMap) {
        messageMap.put("msgCenterId", dy.getLong("id"));
        messageMap.put("msgNumber", dy.get("number"));
        messageMap.put("msgTitle", dy.get("msgtitle"));
        messageMap.put("msgDesc", dy.get("msgdesc"));
        messageMap.put("msgPublisherId", dy.getLong("msgpublisher.id"));
        messageMap.put("actionId", dy.getLong("action.id"));
        messageMap.put("msgTag", dy.get("msgtag"));
        messageMap.put("senderId", dy.getLong("sender.id"));
        messageMap.put("sendTime", dy.getDate("sendtime"));
        messageMap.put("params", dy.get("params"));
        if (StringUtils.isNotEmpty((CharSequence)dy.getString("groupnum"))) {
            messageMap.put("groupNumber", dy.getString("groupnum"));
        }
        if (dy.getInt("groupseq") > 0) {
            messageMap.put("groupSeq", dy.getInt("groupseq"));
        }
        if (dy.getInt("groupcount") > 0) {
            messageMap.put("groupNumber", dy.getInt("groupcount"));
        }
    }

    public static long saveActionTypeDy(DynamicObject dy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_actiontype");
        MsgCenterServiceHelper.checkNumberAndName(dy, serviceHelper);
        return ((DynamicObject)serviceHelper.saveOne(dy)).getLong("id");
    }

    public static long saveActionDy(DynamicObject dy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_action");
        MsgCenterServiceHelper.checkNumberAndName(dy, serviceHelper);
        return ((DynamicObject)serviceHelper.saveOne(dy)).getLong("id");
    }

    public static void saveMsgProbo(DynamicObject dy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcreatebo");
        serviceHelper.saveOne(dy);
    }

    public static long sendMsgToMsgCenter(DynamicObject dy) {
        long id = ORM.create().genLongId("hrcs_msgcenter");
        dy.set("id", (Object)id);
        DynamicObjectCollection entryentity = dy.getDynamicObjectCollection("entryentity");
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter subQfFilter = new QFilter("msgpublisher", "=", (Object)dy.getLong("msgpublisher"));
        subQfFilter.and(new QFilter("substatus", "=", (Object)"1"));
        subQfFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] result = subServiceHelper.queryOriginalArray("id,suber,subscribebd,msgsubno", new QFilter[]{subQfFilter});
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hrcs_msgcenter");
        EntityType type = (EntityType)mainType.getAllEntities().get("entryentity");
        for (DynamicObject subDy : result) {
            DynamicObject entryItem = (DynamicObject)type.createInstance();
            entryItem.set("subscribebd", subDy.get("subscribebd"));
            entryItem.set("consumer", subDy.get("suber"));
            entryItem.set("subscribe", (Object)subDy.getLong("id"));
            entryItem.set("msgsubno", subDy.get("msgsubno"));
            entryentity.add((Object)entryItem);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        return ((DynamicObject)serviceHelper.saveOne(dy)).getLong("id");
    }

    public static boolean validateMsgIsDuplicate(QFilter[] filters) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        if (Objects.isNull(filters) || filters.length == 0) {
            return false;
        }
        return serviceHelper.isExists(filters);
    }

    public static Long queryMsgCenter(QFilter[] filters) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        if (Objects.isNull(filters) || filters.length == 0) {
            return null;
        }
        DynamicObject dy = serviceHelper.queryOriginalOne("id", filters);
        if (null != dy) {
            return dy.getLong("id");
        }
        return null;
    }

    public static Map<String, Object> getSimplePubAndSubInfo(String msgPubNo) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter pubQFilter = new QFilter("msgpubno", "=", (Object)msgPubNo);
        DynamicObject pubDy = pubServiceHelper.queryOne("id,msgprobo.id,actioncloud.id,actionapp.id,publishbd.id,pubstatus,puber.id", new QFilter[]{pubQFilter});
        if (Objects.isNull(pubDy)) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6839\u636emsgPubNo\u83b7\u53d6\u53d1\u5e03\u4e2d\u5fc3\u5bf9\u8c61\u4e3a\u7a7amsgPubNo=%1$s", (String)"MsgCenterServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), msgPubNo));
        }
        if (!"P".equals(pubDy.getString("pubstatus"))) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u6d88\u606f\u7684\u53d1\u5e03\u72b6\u6001\u4e0d\u662f\u5df2\u53d1\u5e03msgPubNo=%1$s", (String)"MsgCenterServiceHelper_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]), msgPubNo));
        }
        long pubId = pubDy.getLong("id");
        long msgProBo = pubDy.getLong("msgprobo.id");
        map.put("msgPublisherId", pubId);
        map.put("msgProBo", msgProBo);
        map.put("pubEr", pubDy.getLong("puber.id"));
        map.put("msgCloud", pubDy.get("actioncloud.id"));
        map.put("msgApp", pubDy.get("actionapp.id"));
        map.put("msgBusinessType", pubDy.get("publishbd.id"));
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter subQFilter = new QFilter("msgpublisher", "=", (Object)pubId);
        QFilter subStatus = new QFilter("substatus", "=", (Object)"1");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        subQFilter.and(subStatus).and(enable);
        DynamicObject[] subDys = subServiceHelper.query("id,msgsubno,consumercloud.id,consumercloud.number,consumerapp.id,consumerapp.number,consumerservice,consumermethod,subscribebd,isnonoriginal", new QFilter[]{subQFilter});
        ArrayList subInfoList = new ArrayList(subDys.length);
        for (DynamicObject subDy : subDys) {
            HashMap<String, String> subMap = new HashMap<String, String>(5);
            String msgSubNo = subDy.getString("msgsubno");
            String consumerCloudId = subDy.getString("consumercloud.id");
            String consumerCloudNumber = subDy.getString("consumercloud.number");
            String consumerAppId = subDy.getString("consumerapp.id");
            String consumerAppNumber = subDy.getString("consumerapp.number");
            String consumerService = subDy.getString("consumerservice");
            String consumerMethod = subDy.getString("consumermethod");
            String businessTypeId = String.valueOf(subDy.getLong("subscribebd.id"));
            subMap.put("msgSubNo", msgSubNo);
            subMap.put("consumerCloudId", consumerCloudId);
            subMap.put("consumerCloud", consumerCloudNumber);
            subMap.put("consumerAppId", consumerAppId);
            subMap.put("consumerAPP", consumerAppNumber);
            subMap.put("consumerService", consumerService);
            subMap.put("consumerMethod", consumerMethod);
            subMap.put("businessTypeId", businessTypeId);
            subMap.put("subscribeId", subDy.getString("id"));
            subMap.put("isnonoriginal", subDy.getString("isnonoriginal"));
            subInfoList.add(subMap);
        }
        map.put("subInfoList", subInfoList);
        return map;
    }

    public static Map<String, Object> getSimpleActionInfo(String msgPubNo) {
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter pubQFilter = new QFilter("msgpubno", "=", (Object)msgPubNo);
        DynamicObject pubDy = pubServiceHelper.queryOriginalOne("actioncloud.id,actionapp.id,publishbd.id,actiontype.id,action.id", new QFilter[]{pubQFilter});
        if (pubDy == null) {
            return Maps.newLinkedHashMapWithExpectedSize((int)0);
        }
        String actionCloud = pubDy.getString("actioncloud.id");
        String actionApp = pubDy.getString("actionapp.id");
        String publishBDId = pubDy.getString("publishbd.id");
        String actionTypeId = pubDy.getString("actiontype.id");
        String actionId = pubDy.getString("action.id");
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("actionCloud", actionCloud);
        map.put("actionApp", actionApp);
        map.put("publishBDId", publishBDId);
        map.put("actionTypeId", actionTypeId);
        map.put("actionId", actionId);
        return map;
    }

    public static Map<Long, DynamicObject> getPubInfoListBySuberId(List<Long> ids) {
        DynamicObject[] msgDy;
        HashMap<Long, DynamicObject> adminOrgNameMap = new HashMap<Long, DynamicObject>();
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter subQfFilter = new QFilter("id", "in", ids);
        DynamicObject[] result = subServiceHelper.queryOriginalArray("id,msgpublisher.id", new QFilter[]{subQfFilter});
        HashMap<Long, Long> map = new HashMap<Long, Long>(result.length);
        for (DynamicObject dy : result) {
            map.put(dy.getLong("id"), dy.getLong("msgpublisher.id"));
        }
        ArrayList<Long> pubIds = new ArrayList<Long>(result.length);
        for (DynamicObject dy : result) {
            pubIds.add(dy.getLong("msgpublisher.id"));
        }
        QFilter pubQfFilter = new QFilter("id", "in", pubIds);
        for (DynamicObject dynamicObject : msgDy = pubServiceHelper.queryOriginalArray("id,puber.id,puber.name,subbusfield.id,actiontype.name,publishdate,publishbd.id,publishbd.name,msgtag,number,issubscribe,modifytime,pubstatus", new QFilter[]{pubQfFilter})) {
            for (Map.Entry entry : map.entrySet()) {
                if (dynamicObject.getLong("id") != ((Long)entry.getValue()).longValue()) continue;
                adminOrgNameMap.put((Long)entry.getKey(), dynamicObject);
            }
        }
        return adminOrgNameMap;
    }

    public static Map<Long, DynamicObject> getPubInfoByMsgId(List<Long> ids) {
        DynamicObject[] msgDy;
        if (ids == null) {
            return null;
        }
        HRBaseServiceHelper msgServiceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        HashMap<Long, DynamicObject> nameMap = new HashMap<Long, DynamicObject>(ids.size());
        QFilter subQfFilter = new QFilter("id", "in", ids);
        DynamicObject[] result = msgServiceHelper.queryOriginalArray("id,msgpublisher.id", new QFilter[]{subQfFilter});
        HashMap<Long, Long> map = new HashMap<Long, Long>(result.length);
        for (DynamicObject dy : result) {
            map.put(dy.getLong("id"), dy.getLong("msgpublisher.id"));
        }
        ArrayList<Long> pubIds = new ArrayList<Long>(result.length);
        for (DynamicObject dy : result) {
            pubIds.add(dy.getLong("msgpublisher.id"));
        }
        QFilter pubQfFilter = new QFilter("id", "in", pubIds);
        for (DynamicObject dynamicObject : msgDy = pubServiceHelper.queryOriginalArray("id,actioncloud.name,actionapp.name", new QFilter[]{pubQfFilter})) {
            for (Map.Entry entry : map.entrySet()) {
                if (dynamicObject.getLong("id") != ((Long)entry.getValue()).longValue()) continue;
                nameMap.put((Long)entry.getKey(), dynamicObject);
            }
        }
        return nameMap;
    }

    public static Map<Long, DynamicObject> getPubInfoListBySubLogId(List<Long> ids) {
        DynamicObject[] msgDy;
        if (ids == null) {
            return null;
        }
        HashMap<Long, DynamicObject> adminOrgNameMap = new HashMap<Long, DynamicObject>();
        HRBaseServiceHelper subLogServiceHelper = new HRBaseServiceHelper("hrcs_submgslog");
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter subQfFilter = new QFilter("id", "in", ids);
        DynamicObject[] result = subLogServiceHelper.queryOriginalArray("id,puber.id", new QFilter[]{subQfFilter});
        HashMap<Long, Long> map = new HashMap<Long, Long>(result.length);
        for (DynamicObject dy : result) {
            map.put(dy.getLong("id"), dy.getLong("puber.id"));
        }
        ArrayList<Long> pubIds = new ArrayList<Long>(result.length);
        for (DynamicObject dy : result) {
            pubIds.add(dy.getLong("puber.id"));
        }
        QFilter pubQfFilter = new QFilter("id", "in", pubIds);
        for (DynamicObject dynamicObject : msgDy = pubServiceHelper.queryOriginalArray("id,name,puber.id,actiontype.id,actiontype.name,number", new QFilter[]{pubQfFilter})) {
            for (Map.Entry entry : map.entrySet()) {
                if (dynamicObject.getLong("id") != ((Long)entry.getValue()).longValue()) continue;
                adminOrgNameMap.put((Long)entry.getKey(), dynamicObject);
            }
        }
        return adminOrgNameMap;
    }

    public static Map<Long, DynamicObject> getSubInfoListBySubLogId(List<Long> ids) {
        DynamicObject[] msgDy;
        if (ids == null) {
            return null;
        }
        HashMap<Long, DynamicObject> adminOrgNameMap = new HashMap<Long, DynamicObject>(ids.size());
        HRBaseServiceHelper subLogServiceHelper = new HRBaseServiceHelper("hrcs_submgslog");
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter subQfFilter = new QFilter("id", "in", ids);
        DynamicObject[] result = subLogServiceHelper.queryOriginalArray("id,suber.id", new QFilter[]{subQfFilter});
        HashMap<Long, Long> map = new HashMap<Long, Long>(result.length);
        for (DynamicObject dy : result) {
            map.put(dy.getLong("id"), dy.getLong("suber.id"));
        }
        ArrayList<Long> pubIds = new ArrayList<Long>(result.length);
        for (DynamicObject dy : result) {
            pubIds.add(dy.getLong("suber.id"));
        }
        QFilter pubQfFilter = new QFilter("id", "in", pubIds);
        for (DynamicObject dynamicObject : msgDy = pubServiceHelper.queryOriginalArray("id,number,consumercloud.name,consumerapp.name", new QFilter[]{pubQfFilter})) {
            for (Map.Entry entry : map.entrySet()) {
                if (dynamicObject.getLong("id") != ((Long)entry.getValue()).longValue()) continue;
                adminOrgNameMap.put((Long)entry.getKey(), dynamicObject);
            }
        }
        return adminOrgNameMap;
    }

    public static Map<Long, DynamicObject> getPubInfoListByPubLogId(List<Long> ids) {
        DynamicObject[] msgDy;
        HashMap<Long, DynamicObject> adminOrgNameMap = new HashMap<Long, DynamicObject>();
        HRBaseServiceHelper pubLogServiceHelper = new HRBaseServiceHelper("hrcs_pubmsglog");
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter subQfFilter = new QFilter("id", "in", ids);
        DynamicObject[] result = pubLogServiceHelper.queryOriginalArray("id,pubmsg.id", new QFilter[]{subQfFilter});
        HashMap<Long, Long> map = new HashMap<Long, Long>(result.length);
        for (DynamicObject dy : result) {
            map.put(dy.getLong("id"), dy.getLong("pubmsg.id"));
        }
        ArrayList<Long> pubIds = new ArrayList<Long>(result.length);
        for (DynamicObject dy : result) {
            pubIds.add(dy.getLong("pubmsg.id"));
        }
        QFilter pubQfFilter = new QFilter("id", "in", pubIds);
        for (DynamicObject dynamicObject : msgDy = pubServiceHelper.queryOriginalArray("id,actioncloud.name,publishbd.name,actionapp.name", new QFilter[]{pubQfFilter})) {
            for (Map.Entry entry : map.entrySet()) {
                if (dynamicObject.getLong("id") != ((Long)entry.getValue()).longValue()) continue;
                adminOrgNameMap.put((Long)entry.getKey(), dynamicObject);
            }
        }
        return adminOrgNameMap;
    }

    public static DynamicObject[] getPubInfoByBusinessType(long publishId, String consumerCloud, String consumerApp, String consumerService, String consumerMethod) {
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter subQfFilter = new QFilter("substatus", "=", (Object)"1");
        QFilter pubQFilter = new QFilter("msgpublisher", "=", (Object)publishId);
        QFilter consumerCloudFilter = new QFilter("consumercloud.id", "=", (Object)consumerCloud);
        QFilter consumerAppFilter = new QFilter("consumerapp.id", "=", (Object)consumerApp);
        QFilter consumerServiceFilter = new QFilter("consumerService", "=", (Object)consumerService);
        QFilter consumerMethodFilter = new QFilter("consumerMethod", "=", (Object)consumerMethod);
        return subServiceHelper.query("id,msgpublisher.id", new QFilter[]{subQfFilter, pubQFilter, consumerCloudFilter, consumerAppFilter, consumerServiceFilter, consumerMethodFilter});
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject getActionTypeByActionId(long actionId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_action");
        QFilter qFilter = new QFilter("id", "=", (Object)actionId);
        return serviceHelper.queryOne("id,actiontype.id", new QFilter[]{qFilter});
    }

    public static List<Map<String, String>> getAPIInfoByMsgSubNo(String msgSubNo) {
        if (HRStringUtils.isEmpty((String)msgSubNo)) {
            return Lists.newArrayList();
        }
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter subQFilter = new QFilter("msgsubno", "=", (Object)msgSubNo);
        DynamicObject[] dyCols = subServiceHelper.query("msgpublisher.id,apientryentity,apientryentity.apisource,apientryentity.apisource.isnonoriginal,apientryentity.apisubstatus,apientryentity.apinumber,apientryentity.apiname,apientryentity.apiservice,apientryentity.apimethod,apientryentity.apipubcloud,apientryentity.apipubapp,apientryentity.apidescription,apientryentity.params,apientryentity.apitype,apientryentity.inputparam,apientryentity.outputtype,apientryentity.outputparam", new QFilter[]{subQFilter});
        if (Objects.isNull(dyCols) || dyCols.length == 0) {
            return Lists.newArrayList();
        }
        DynamicObject subDy = dyCols[0];
        DynamicObjectCollection subEntityCols = (DynamicObjectCollection)subDy.get("apientryentity");
        long id = subDy.getLong("msgpublisher.id");
        DynamicObject dy = MsgCenterServiceHelper.getPubDyById(id);
        if (dy == null) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        DynamicObjectCollection pubEntityCols = (DynamicObjectCollection)dy.get("apientryentity");
        ArrayList rowList = Lists.newArrayListWithExpectedSize((int)subEntityCols.size());
        block0: for (DynamicObject subEntityCol : subEntityCols) {
            boolean apiSubstatus = StringUtils.equals((CharSequence)subEntityCol.getString("apisubstatus"), (CharSequence)"1");
            for (DynamicObject dynamicObject : pubEntityCols) {
                boolean apiEnable;
                if (!StringUtils.equals((CharSequence)dynamicObject.getString("apinumber"), (CharSequence)subEntityCol.getString("apinumber")) || (apiEnable = StringUtils.equals((CharSequence)dynamicObject.getString("apienable"), (CharSequence)"A")) && apiSubstatus) continue;
                rowList.add(subEntityCol);
                continue block0;
            }
        }
        for (DynamicObject row : rowList) {
            subEntityCols.remove((Object)row);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)subEntityCols.size());
        for (DynamicObject dyObject : subEntityCols) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("apitype", dyObject.getString("apitype"));
            map.put("id", dyObject.getString("apisource.id"));
            map.put("bizcloud", dyObject.getString("apipubcloud.number"));
            map.put("bizapp", dyObject.getString("apipubapp.number"));
            map.put("number", dyObject.getString("apinumber"));
            map.put("name", dyObject.getString("apiname"));
            String isoriginalapi = dyObject.getString("apisource.isnonoriginal");
            map.put("isvid", MsgCenterServiceHelper.getISV(isoriginalapi));
            map.put("service", dyObject.getString("apiservice"));
            map.put("method", dyObject.getString("apimethod"));
            map.put("apidescription", dyObject.getString("apidescription"));
            map.put("params", dyObject.getString("params"));
            map.put("inputparam", dyObject.getString("inputparam"));
            map.put("outputtype", dyObject.getString("outputtype"));
            map.put("outputparam", dyObject.getString("outputparam"));
            result.add(map);
        }
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getISV(String isoriginal) {
        if (StringUtils.isNotEmpty((CharSequence)isoriginal) && Boolean.parseBoolean(isoriginal)) {
            return ISVServiceHelper.getISVInfo().getId();
        }
        return "kingdee";
    }

    public static DynamicObject getPubDyById(long id) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgpublisher");
        DynamicObject dynamicObject = helper.queryOne((Object)id);
        if (Objects.nonNull(dynamicObject)) {
            return dynamicObject;
        }
        return null;
    }

    public static String getXMLDescById(long id) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_apideploy");
        DynamicObject dy = Objects.requireNonNull(helper.queryOriginalOne("id,apixml", (Object)id));
        return dy.getString("apixml");
    }

    public static DynamicObjectCollection getAPIFieldsById(Long id, String queryEntityTpeStr) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_apideploy");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject[] dy = helper.query("id,entryfield1,entryfield1.queryfieldentity1,entryfield1.queryfield11,entryfield1.apifieldkey1,entryfield1.apifieldname1,entryfield1.enablefield1,entryfield1.isparam1,entryfield1.fieldmainentity", new QFilter[]{qFilter});
        if (dy.length == 0) {
            return null;
        }
        DynamicObjectCollection cols = (DynamicObjectCollection)dy[0].get("entryfield1");
        Iterator iterator = cols.iterator();
        while (iterator.hasNext()) {
            DynamicObject dyCol = (DynamicObject)iterator.next();
            if (StringUtils.equals((CharSequence)dyCol.getString("fieldmainentity"), (CharSequence)queryEntityTpeStr)) continue;
            iterator.remove();
        }
        return cols;
    }

    public static DynamicObjectCollection getAPIFieldsByEntityName(Long id, String entityName, String queryEntityTpeStr) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_apideploy");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject[] dy = helper.query("id,entryfield1,entryfield1.queryfield11,entryfield1.queryfieldentity1,entryfield1.apifieldkey1,entryfield1.apifieldname1,entryfield1.enablefield1,entryfield1.isparam1,entryfield1.fieldmainentity", new QFilter[]{qFilter});
        if (dy.length == 0) {
            return null;
        }
        DynamicObjectCollection cols = (DynamicObjectCollection)dy[0].get("entryfield1");
        Iterator iterator = cols.iterator();
        while (iterator.hasNext()) {
            DynamicObject dyCol = (DynamicObject)iterator.next();
            if (StringUtils.equals((CharSequence)dyCol.getString("queryfieldentity1"), (CharSequence)entityName)) continue;
            iterator.remove();
        }
        return cols;
    }

    public static DynamicObject[] queryAPIsByNumber(List<String> numberList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_apideploy");
        QFilter qFilter = new QFilter("number", "in", numberList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dy = helper.query("id,number,type,name,service,method,description,enable,bizcloud,bizapp,inputparam,outputtype,outputparam,param", new QFilter[]{enableFilter, qFilter});
        return dy;
    }

    public static List<Map<String, Object>> getDataBySub(Long apiId, QFilter qFilter, String orderby) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_apideploy");
        QFilter idQFilter = new QFilter("id", "=", (Object)apiId);
        DynamicObject[] apiDys = helper.query("id,mainentity.number,entryfield1,entryfield1.queryfield11,entryfield1.queryfieldentity1,entryfield1.enablefield1,entryfield1.apifieldkey1", new QFilter[]{idQFilter});
        DynamicObject apiDy = apiDys[0];
        String mainEntity = apiDy.getString("mainentity.number");
        DynamicObjectCollection cols = (DynamicObjectCollection)apiDy.get("entryfield1");
        QueryEntityType queryType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)mainEntity);
        ArrayList responseBodyList = Lists.newArrayList();
        if (cols.isEmpty()) {
            return responseBodyList;
        }
        StringBuilder querySB = new StringBuilder();
        cols.forEach(dy -> {
            if (dy.getBoolean("enablefield1")) {
                querySB.append(dy.getString("queryfield11"));
                querySB.append(',');
            }
        });
        querySB.deleteCharAt(querySB.length() - 1);
        DataSet queryResultSet = queryType.getQueryDataSet(querySB.toString(), new QFilter[]{qFilter}, orderby);
        if (!queryResultSet.isEmpty()) {
            while (queryResultSet.hasNext()) {
                Row queryResult = queryResultSet.next();
                HashMap responseBody = new HashMap();
                cols.forEach(dy -> {
                    if (dy.getBoolean("enablefield1")) {
                        String keyData = dy.getString("queryfield11");
                        String key = dy.getString("apifieldkey1");
                        String queryfieldentity = dy.getString("queryfieldentity1");
                        Object value = queryResult.get(keyData);
                        responseBody.put(queryfieldentity + "." + key, value);
                    }
                });
                responseBodyList.add(responseBody);
            }
        }
        return responseBodyList;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void consumeMsgToMsgCenter(Long msgCenterId, Map<Long, MsgCenterResult> subInvokeResult) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        DynamicObject dy = serviceHelper.queryOne((Object)msgCenterId);
        if (dy == null) {
            return;
        }
        DynamicObjectCollection entirety = dy.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entirety.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entirety.get(i);
            long subId = dynamicObject.getLong("subscribe.id");
            MsgCenterResult msgCenterResult = subInvokeResult.get(subId);
            if (null == msgCenterResult) continue;
            dynamicObject.set("recstatus", (Object)msgCenterResult.getRecStatus());
            if (StringUtils.isNotEmpty((CharSequence)msgCenterResult.getRecMessage())) {
                dynamicObject.set("recmessage", (Object)MsgCenterServiceHelper.subStringByMaxLeng(msgCenterResult.getRecMessage(), 500));
            }
            if (StringUtils.isNotEmpty((CharSequence)msgCenterResult.getHandleStatus())) {
                dynamicObject.set("handlestatus", (Object)msgCenterResult.getHandleStatus());
            }
            if (StringUtils.isNotEmpty((CharSequence)msgCenterResult.getConsumeMsg())) {
                dynamicObject.set("msgdescription", (Object)msgCenterResult.getConsumeMsg());
            }
            if (!"B".equalsIgnoreCase(msgCenterResult.getRecStatus())) continue;
            logger.error("consumeMsgToMsgCenter_result_is_error_subscribeId_is_{},result_is_{}", (Object)subId, (Object)subInvokeResult.get(subId));
            MsgWarningServiceHelper.sendMsgWarning(dy, "rec", dynamicObject.getString("msgsubno"));
        }
        serviceHelper.saveOne(dy);
    }

    public static void consumeMsgToMsgCenter(Long msgCenterId, Map<Long, Boolean> subInvokeResult, Map<Long, String> errorMsgMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        DynamicObject dy = serviceHelper.queryOne((Object)msgCenterId);
        if (dy == null) {
            return;
        }
        DynamicObjectCollection entirety = dy.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entirety.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entirety.get(i);
            long subId = dynamicObject.getLong("subscribe.id");
            if (!subInvokeResult.containsKey(subId)) {
                subId = dynamicObject.getLong("subscribebd.id");
            }
            if (subInvokeResult.getOrDefault(subId, false).booleanValue()) {
                dynamicObject.set("recstatus", (Object)"A");
                continue;
            }
            logger.error("consumeMsgToMsgCenter_result_is_error_subscribeId_is_{},result_is_{}", (Object)subId, (Object)subInvokeResult.get(subId));
            dynamicObject.set("recstatus", (Object)"B");
            if (errorMsgMap != null && errorMsgMap.containsKey(subId)) {
                String recMessage = MsgCenterServiceHelper.subStringByMaxLeng(errorMsgMap.get(subId), 500);
                dynamicObject.set("recmessage", (Object)recMessage);
            }
            MsgWarningServiceHelper.sendMsgWarning(dy, "rec", dynamicObject.getString("msgsubno"));
        }
        serviceHelper.saveOne(dy);
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<Map<String, String>> getPubByActionId(Long actionId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter idQfFilter = new QFilter("action", "=", (Object)actionId);
        idQfFilter.and(new QFilter("pubstatus", "=", (Object)"P"));
        DynamicObject[] dyCols = helper.query("msgpubno,action.id,msgtag", new QFilter[]{idQfFilter});
        ArrayList result = Lists.newArrayListWithCapacity((int)dyCols.length);
        for (DynamicObject dy : dyCols) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("msgpubno", dy.getString("msgpubno"));
            map.put("actionId", dy.getString("action.id"));
            map.put("msgtag", dy.getString("msgtag"));
            result.add(map);
        }
        return result;
    }

    public static void updateConsumeMsgInfo(Map<String, Object> consumeMsgMap) {
        String msgSubNo;
        if (Objects.isNull(consumeMsgMap) || consumeMsgMap.isEmpty() || Objects.isNull(consumeMsgMap.get("msgCenterId")) || Objects.isNull(consumeMsgMap.get("businessTypeId")) && Objects.isNull(consumeMsgMap.get("msgSubNo")) || Objects.isNull(consumeMsgMap.get("handleStatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"msgCenterId\u6216(businessTypeId\u548cmsgSubNo)\u6216handleStatus\u4e3a\u7a7a", (String)"MsgCenterServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        Long msgCenterId = Long.valueOf(String.valueOf(consumeMsgMap.get("msgCenterId")));
        String consumeMsg = Objects.isNull(consumeMsgMap.get("consumeMsg")) ? "" : String.valueOf(consumeMsgMap.get("consumeMsg"));
        String handleStatus = String.valueOf(consumeMsgMap.get("handleStatus"));
        String string = msgSubNo = Objects.isNull(consumeMsgMap.get("msgSubNo")) ? String.valueOf(consumeMsgMap.get("businessTypeId")) : String.valueOf(consumeMsgMap.get("msgSubNo"));
        if (!("1".equalsIgnoreCase(handleStatus) || "2".equalsIgnoreCase(handleStatus) || "3".equalsIgnoreCase(handleStatus))) {
            throw new KDBizException(ResManager.loadKDString((String)"handleStatus\u72b6\u6001\u4e0d\u5728\u5df2\u5b9a\u4e49\u8303\u56f4\uff081,2,3\uff09", (String)"MsgCenterServiceHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        logger.info("updateConsumeMsgInfo_msgCenterId={},msgSubNo={}", (Object)msgCenterId, (Object)msgSubNo);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        DynamicObject dy = serviceHelper.queryOne("id,number,entryentity.subscribebd,entryentity.msgsubno,entryentity.consumerstatus,entryentity.handlestatus,entryentity.msgdescription,entryentity.exceptionfeedback,entryentity.exceptionfeedbackdesc", (Object)msgCenterId);
        if (dy == null) {
            logger.error("updateConsumeMsgInfo_error_msgCenterId_find_null;msgCenterId={}", (Object)msgCenterId);
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636emsgCenterId\u67e5\u8be2\u6d88\u606f\u4e2d\u5fc3\u4e3a\u7a7a", (String)"MsgCenterServiceHelper_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("entryentity");
        boolean findSuccess = false;
        StringBuilder sql = new StringBuilder("update t_hrcs_msgcenterentry ");
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject row = null;
        for (DynamicObject entryDy : entryEntity) {
            long subscribeId = entryDy.getLong("subscribebd.id");
            String msgsubno = entryDy.getString("msgsubno");
            if ((!StringUtils.isNotBlank((CharSequence)msgSubNo) || !msgSubNo.equalsIgnoreCase(msgsubno)) && !msgSubNo.equalsIgnoreCase(String.valueOf(subscribeId))) continue;
            sql.append(" set fconsumerstatus = ?  ");
            sql.append(", fhandlestatus = ?  ");
            sql.append(", fdescription = ?  ");
            paramList.add("A");
            paramList.add(handleStatus);
            paramList.add(consumeMsg);
            String feedback = entryDy.getString("exceptionfeedback");
            if (!HRStringUtils.isEmpty((String)feedback)) {
                sql.append(", fexceptionfeedback = ?  ");
                sql.append(", fexceptionfeedbackdesc = ?  ");
                paramList.add(null);
                paramList.add(null);
            }
            sql.append(" WHERE fentryid = ? ");
            paramList.add(entryDy.getLong("id"));
            findSuccess = true;
            row = entryDy;
            if ("1".equalsIgnoreCase(handleStatus)) break;
            MsgWarningServiceHelper.sendMsgWarning(dy, "consume", msgsubno);
            break;
        }
        if (!findSuccess) {
            logger.error("updateConsumeMsgInfo_error_businessTypeId_find_null;msgSubNo={}", (Object)msgSubNo);
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636ebusinessTypeId\u67e5\u8be2\u6d88\u606f\u4e2d\u6ca1\u6709\u5f53\u524d\u4e1a\u52a1\u7c7b\u578b\u7684\u6d88\u8d39\u8005\u4fe1\u606f", (String)"MsgCenterServiceHelper_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        HRDBUtil.update((DBRoute)new DBRoute("hmp"), (String)sql.toString(), (Object[])paramList.toArray(new Object[]{paramList.size()}));
        MsgCenterServiceHelper.saveMsgCenterLog(row, msgCenterId);
    }

    public static List<Map<String, Object>> getMsgCenterListInfo(List<Map<String, Object>> paramsList) {
        DynamicObject[] dynamicObjects;
        MsgCenterServiceHelper.validateParamsList(paramsList);
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>(10);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        String queryFields = "number,action.id,entryentity.subscribebd,entryentity.subscribebd.id,entryentity.consumer,entryentity.consumer.id,entryentity.recstatus,entryentity.consumerstatus,entryentity.msgdescription,entryentity.handlestatus";
        for (DynamicObject dynamicObject : dynamicObjects = serviceHelper.query(queryFields, new QFilter[]{MsgCenterServiceHelper.getMsgCenterListQFilter(paramsList)}, "id")) {
            HashMap<String, Object> dynRow = new HashMap<String, Object>(3);
            dynRow.put("msgNumber", dynamicObject.get("number"));
            if (dynamicObject.getDynamicObject("action") != null) {
                dynRow.put("actionId", dynamicObject.getDynamicObject("action").get("id"));
            } else {
                dynRow.put("actionId", null);
            }
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            ArrayList dataList = new ArrayList(10);
            if (dynamicObjectCollection != null) {
                for (int idx = 0; idx < dynamicObjectCollection.size(); ++idx) {
                    DynamicObject curObject = (DynamicObject)dynamicObjectCollection.get(idx);
                    HashMap<String, Object> detailRow = new HashMap<String, Object>(16);
                    if (curObject.getDynamicObject("subscribebd") != null) {
                        detailRow.put("subscribeBD", curObject.getDynamicObject("subscribebd").get("id"));
                    } else {
                        detailRow.put("subscribeBD", null);
                    }
                    if (curObject.getDynamicObject("consumer") != null) {
                        detailRow.put("consumer", curObject.getDynamicObject("consumer").get("id"));
                    } else {
                        detailRow.put("consumer", null);
                    }
                    detailRow.put("recStatus", curObject.get("recstatus"));
                    detailRow.put("consumerStatus", curObject.get("consumerstatus"));
                    detailRow.put("msgDescription", curObject.get("msgdescription"));
                    detailRow.put("handleStatus", curObject.get("handlestatus"));
                    dataList.add(detailRow);
                }
            }
            dynRow.put("dataList", dataList);
            returnList.add(dynRow);
        }
        return returnList;
    }

    private static QFilter getMsgCenterListQFilter(List<Map<String, Object>> paramsList) {
        QFilter qFilter = new QFilter("number", "=", (Object)"id");
        for (Map<String, Object> paramsMap : paramsList) {
            QFilter numberFilter = new QFilter("number", "=", paramsMap.get("msgNumber"));
            QFilter actionFilter = new QFilter("action", "=", paramsMap.get("actionId"));
            qFilter.or(numberFilter.and(actionFilter));
        }
        return qFilter;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void validateParamsList(List<Map<String, Object>> paramsList) {
        if (paramsList == null || paramsList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u5165\u53c2\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"MsgCenterServiceHelper_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (paramsList.size() > QUERY_MSG_PARAMS_SIZE_MAX) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u67e5\u8be2\u4fe1\u606f\u5165\u53c2\u8d85\u8fc7\u6700\u5927\u6570%1$s\uff0c\u8bf7\u62c6\u5206\u540e\u91cd\u8bd5\u3002", (String)"MsgCenterServiceHelper_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]), QUERY_MSG_PARAMS_SIZE_MAX));
        }
        for (int idx = 0; idx < paramsList.size(); ++idx) {
            Map<String, Object> paramsMap = paramsList.get(idx);
            if (!paramsMap.containsKey("msgNumber") || !paramsMap.containsKey("actionId")) {
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%1$s\u7ec4\u53c2\u6570\u5f02\u5e38\uff0c\u672a\u5305\u542b\u5165\u53c2 msgNumber \u6216 actionId \u3002", (String)"MsgCenterServiceHelper_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]), idx));
            }
            if (paramsMap.get("msgNumber") != null && paramsMap.get("actionId") != null && !HRStringUtils.isEmpty((String)String.valueOf(paramsMap.get("msgNumber"))) && !HRStringUtils.isEmpty((String)String.valueOf(paramsMap.get("actionId")))) continue;
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%1$s\u7ec4\u53c2\u6570\u5f02\u5e38\uff0cmsgNumber\u6216actionId\u4e3a\u7a7a\u3002", (String)"MsgCenterServiceHelper_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]), idx));
        }
    }

    public static List<Map<String, Object>> getMsgCenterInfo(String msgNumber, long actionId) {
        QFilter actionFilter;
        QFilter msgNumberFilter;
        HRBaseServiceHelper serviceHelper;
        DynamicObject queryDy;
        if (HRStringUtils.isEmpty((String)msgNumber) || actionId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"msgNumber\u6216actionId\u4e3a\u7a7a", (String)"MsgCenterServiceHelper_15", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (logger.isInfoEnabled()) {
            logger.info("getMsgCenterInfo_msgNumber={},actionId={}", (Object)msgNumber, (Object)actionId);
        }
        if (Objects.nonNull(queryDy = (serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter")).loadDynamicObject(new QFilter[]{msgNumberFilter = new QFilter("number", "=", (Object)msgNumber), actionFilter = new QFilter("action", "=", (Object)actionId)}))) {
            DynamicObjectCollection scribeDetails = queryDy.getDynamicObjectCollection("entryentity");
            ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>(scribeDetails.size());
            for (DynamicObject scribeDetail : scribeDetails) {
                HashMap map = Maps.newHashMap();
                map.put("subscribeBD", scribeDetail.getLong("subscribebd.id"));
                map.put("consumer", scribeDetail.getLong("consumer.id"));
                map.put("recStatus", scribeDetail.getString("recstatus"));
                map.put("consumerStatus", scribeDetail.getString("consumerstatus"));
                map.put("msgDescription", scribeDetail.getString("msgdescription"));
                map.put("handleStatus", scribeDetail.getString("handlestatus"));
                returnList.add(map);
            }
            return returnList;
        }
        throw new KDBizException(ResManager.loadKDString((String)"msgNumber\u548cactionId\u83b7\u53d6\u6d88\u606f\u4e3a\u7a7a", (String)"MsgCenterServiceHelper_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<String> checkApiIsSub(long pubId, List<Long> apiIds) {
        QFilter subStatusFilter;
        if (Objects.isNull(apiIds) || apiIds.isEmpty()) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        HRBaseServiceHelper subHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter pubFilter = new QFilter("msgpublisher.id", "=", (Object)pubId);
        DynamicObject[] idDys = subHelper.query("id", new QFilter[]{pubFilter, subStatusFilter = new QFilter("substatus", "=", (Object)"1")});
        if (idDys == null || idDys.length == 0) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        List ids = Stream.of(idDys).map(dy -> dy.getLong("id")).distinct().collect(Collectors.toList());
        ArrayList allParams = Lists.newArrayListWithExpectedSize((int)(ids.size() + apiIds.size()));
        allParams.addAll(ids);
        allParams.addAll(apiIds);
        String selectSql = "select fnumber as \"number\" from  t_hrcs_msgsubscribeapi where fid in (" + HRListUtils.getListInSqlPlaceholder(ids) + ") and fapisourceid in (" + HRListUtils.getListInSqlPlaceholder(apiIds) + ") and fapisubstatus = '1'";
        return (List)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)selectSql, (Object[])allParams.toArray(), rs -> {
            HashSet apiNumbers = Sets.newHashSetWithExpectedSize((int)16);
            while (rs.next()) {
                apiNumbers.add(rs.getString("number"));
            }
            return new ArrayList(apiNumbers);
        });
    }

    @ExcludeFromJacocoGeneratedReport
    private static void checkNumberAndName(DynamicObject dy, HRBaseServiceHelper serviceHelper) {
        DynamicObject dbDy;
        DynamicObject dbDy2;
        String number = dy.getString("number");
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        if (HRStringUtils.isEmpty((String)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u7a7a", (String)"MsgCenterServiceHelper_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (serviceHelper.isExists(numberFilter) && !(dbDy2 = serviceHelper.queryOriginalOne("id", numberFilter)).get("id").equals(dy.getPkValue())) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u91cd\u590d\u3002", (String)"MsgCenterServiceHelper_12", (String)"hrmp-hrcs-business", (Object[])new Object[0]), number));
        }
        String name = dy.getString("name");
        QFilter nameFilter = new QFilter("name", "=", (Object)name);
        if (HRStringUtils.isEmpty((String)name)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a", (String)"MsgCenterServiceHelper_13", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (serviceHelper.isExists(nameFilter) && !(dbDy = serviceHelper.queryOriginalOne("id", nameFilter)).get("id").equals(dy.getPkValue())) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u540d\u79f0\uff1a%1$s\u5df2\u91cd\u590d\u3002", (String)"MsgCenterServiceHelper_14", (String)"hrmp-hrcs-business", (Object[])new Object[0]), name));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<Long> getActionTypeIdsByBd(DynamicObject businessFieldDy) {
        if (Objects.nonNull(businessFieldDy) && Objects.nonNull(businessFieldDy.getPkValue())) {
            QFilter businessFieldFilter = new QFilter("businessdomain", "=", businessFieldDy.getPkValue());
            HRBaseServiceHelper actionTypeHelper = new HRBaseServiceHelper("hbss_actiontype");
            DynamicObject[] ids = actionTypeHelper.queryOriginalArray("id", new QFilter[]{businessFieldFilter});
            return Stream.of(ids).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return Lists.newArrayListWithExpectedSize((int)16);
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] getSubDysByFilters(String selectProperty, QFilter[] qFilters) {
        if (HRStringUtils.isEmpty((String)selectProperty) || Objects.isNull(qFilters) || qFilters.length == 0) {
            return new DynamicObject[0];
        }
        HRBaseServiceHelper subHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        return subHelper.query(selectProperty, qFilters);
    }

    private static void saveMsgCenterLog(DynamicObject row, Long msgCenterId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgexceptionlog");
        Date date = new Date();
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("msgcenter", (Object)msgCenterId);
        dynamicObject.set("msgcenterentry", (Object)row.getLong("id"));
        String handleStatus = row.getString("handlestatus");
        dynamicObject.set("handlestatus", (Object)handleStatus);
        DynamicObjectCollection warningCol = new DynamicObjectCollection();
        if (!"1".equalsIgnoreCase(handleStatus)) {
            DynamicObject entry = serviceHelper.generateEmptyEntryDynamicObject("entryentity");
            entry.set("warningtype", (Object)"C");
            entry.set("warningtime", (Object)date);
            warningCol.add((Object)entry);
        }
        dynamicObject.set("entryentity", (Object)warningCol);
        dynamicObject.set("createtime", (Object)date);
        dynamicObjectCollection.add((Object)dynamicObject);
        serviceHelper.save(dynamicObjectCollection);
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<Map<String, Object>> getConsumerInfoByPubId(long pubId) {
        DynamicObject[] msgDys;
        if (logger.isInfoEnabled()) {
            logger.info("getConsumerInfoByPubId={}", (Object)pubId);
        }
        ArrayList returnList = Lists.newArrayListWithExpectedSize((int)0);
        if (pubId == 0L) {
            return returnList;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        QFilter subQFilter = new QFilter("msgpublisher", "=", (Object)pubId);
        for (DynamicObject msgDy : msgDys = serviceHelper.loadDynamicObjectArray(new QFilter[]{subQFilter})) {
            DynamicObjectCollection scribeDetails = msgDy.getDynamicObjectCollection("entryentity");
            returnList = Lists.newArrayListWithExpectedSize((int)scribeDetails.size());
            for (DynamicObject scribeDetail : scribeDetails) {
                HashMap map = Maps.newHashMap();
                map.put("msgnumber", msgDy.getString("number"));
                map.put("subscribeBD", scribeDetail.getLong("subscribebd.id"));
                map.put("consumer", scribeDetail.getLong("consumer.id"));
                map.put("recStatus", scribeDetail.getString("recstatus"));
                map.put("consumerStatus", scribeDetail.getString("consumerstatus"));
                map.put("msgDescription", scribeDetail.getString("msgdescription"));
                map.put("handleStatus", scribeDetail.getString("handlestatus"));
                map.put("exceptionfeedback", scribeDetail.getString("exceptionfeedback"));
                map.put("exceptionfeedbackdesc", scribeDetail.getString("exceptionfeedbackdesc"));
                returnList.add(map);
            }
        }
        return returnList;
    }

    public static void setAppFilter(ListShowParameter showParameter) {
        HRBaseServiceHelper appBuFieldHelper;
        Set appIds;
        QFilter filter;
        DynamicObjectCollection dyColl;
        Set appIdSet = HRAppServiceHelper.getAllHRAppIds();
        if (!appIdSet.isEmpty()) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)appIdSet));
        }
        if ((dyColl = APP_HELPER.queryOriginalCollection("id", new QFilter[]{filter = new QFilter("masterid", "in", appIds = Stream.of((appBuFieldHelper = new HRBaseServiceHelper("hbss_appbusinesstype")).queryOriginalArray("app.id", new QFilter[]{new QFilter("businesstype", "is not null", null)})).map(dy -> dy.getString("app.id")).collect(Collectors.toSet()))})) != null && dyColl.size() > 0) {
            appIds.addAll(dyColl.stream().map(dy -> dy.getString("id")).collect(Collectors.toSet()));
        }
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", appIds));
        showParameter.getCustomParams().put("isShowExtapp", "true");
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObjectCollection getConsumerList(long id) {
        HRBaseServiceHelper msgCenterHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        DynamicObject dynamicObject = msgCenterHelper.queryOne("entryentity,entryentity.id,entryentity.recstatus,entryentity.handlestatus,entryentity.consumerstatus,entryentity.exceptionfeedback", new QFilter[]{new QFilter("id", "=", (Object)id)});
        return dynamicObject.getDynamicObjectCollection("entryentity");
    }

    public static void updateEnable(Long id, String enable) {
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        DynamicObject dynamicObject = subServiceHelper.queryOne((Object)id);
        dynamicObject.set("enable", (Object)enable);
        subServiceHelper.saveOne(dynamicObject);
    }

    public static Map<Long, DynamicObjectCollection> getConsumerMap(List<Long> ids) {
        DynamicObject[] dynamicObjects;
        if (ids == null) {
            return null;
        }
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper msgCenterHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        for (DynamicObject dynamicObject : dynamicObjects = msgCenterHelper.query("id,entryentity,entryentity.id,entryentity.recstatus,entryentity.handlestatus,entryentity.consumerstatus,entryentity.exceptionfeedback", new QFilter[]{new QFilter("id", "in", ids)})) {
            nameMap.put(dynamicObject.getLong("id"), dynamicObject.getDynamicObjectCollection("entryentity"));
        }
        return nameMap;
    }
}

