/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.activity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFExtendAttributeGroup;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.OperateResult;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.operation.CompleteOperationParam;
import kd.bos.workflow.engine.task.operation.DeleteOperationParam;
import kd.bos.workflow.engine.task.operation.TransferOperationParam;
import kd.bos.workflow.engine.task.operation.UpdateParticipantParam;
import kd.hr.hbp.business.extpoint.activity.IActivityTaskExtService;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.activity.exception.ActivityErrorCode;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityNodeLogServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivitySchemeServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.util.ActivityCommonUtil;
import kd.hr.hrcs.bussiness.servicehelper.activity.util.ActivityRecConstructHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.util.DecOptionNumberEnum;
import kd.hr.hrcs.bussiness.servicehelper.activity.util.WorkflowEventEnum;
import kd.hr.hrcs.common.constants.activity.ActivityConstants;
import org.apache.commons.lang3.tuple.Pair;

public class ActivityInsServiceHelper {
    private static final String ENTITYNAME_REC = "hrcs_actassignrec";
    private static final String ENTITYNAME_INS = "hrcs_activityins";
    private static final Log log = LogFactory.getLog(ActivityInsServiceHelper.class);
    private static final String PROPERTIES_INS = "id,applier,bizbillid,biznum,bizkey,bindbizbillid,bindbiznum,bindbizkey,bindinglayoutid,actthemestr,taskstatus,createtime,wfcurtaskid,wfprocessinsid,wfprocessdefinitionid,actscheme,schemenumber,schemeversion,activity,handletime,handlers,wfnode,globaltaskid,ssctaskid,taskswitch";
    private static final String HRCS_BUSINESS = "hrmp-hrcs-business";
    private static final Map<String, DecOptionNumberEnum> DEC_OPTION_NUMBER_MAPPING = new HashMap<String, DecOptionNumberEnum>();
    private static final String SSC_CLOUD_ID = "ssc";
    private static final String SSC_APP_ID = "task";
    private static final String SSC_SERVICE_NAME = "ITaskService";

    public static void rejectWorkFlowTask(TXHandle txHandle, Long actInsId, Long userId, String auditMessage, boolean rejectBackToNode) {
        String decOptionNumber = "reject";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("rejectBackToNode", String.valueOf(rejectBackToNode));
        variables.put("allowRejectAndGoBack", String.valueOf(rejectBackToNode));
        ActivityInsServiceHelper.completeWorkFlowTask(txHandle, actInsId, userId, decOptionNumber, auditMessage, variables);
    }

    public static void rejectWorkFlowToNodeTask(TXHandle txHandle, Long actInsId, Long userId, String auditMessage, boolean rejectBackToNode, String nextNodeId) {
        String decOptionNumber = "reject";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("rejectBackToNode", String.valueOf(rejectBackToNode));
        variables.put("allowRejectAndGoBack", String.valueOf(rejectBackToNode));
        variables.put("dynType", "dynReject");
        variables.put("nextNodeId", nextNodeId);
        ActivityInsServiceHelper.completeWorkFlowTask(txHandle, actInsId, userId, decOptionNumber, auditMessage, variables);
    }

    public static void consentWorkFlowTask(TXHandle txHandle, Long actInsId, Long userId, String auditMessage) {
        String decOptionNumber = "consent";
        ActivityInsServiceHelper.completeWorkFlowTask(txHandle, actInsId, userId, decOptionNumber, auditMessage, new HashMap<String, Object>());
    }

    public static void terminateWorkFlowTask(TXHandle txHandle, Long actInsId, Long userId, String auditMessage) {
        String decOptionNumber = "terminal";
        ActivityInsServiceHelper.completeWorkFlowTask(txHandle, actInsId, userId, decOptionNumber, auditMessage, new HashMap<String, Object>());
    }

    @ExcludeFromJacocoGeneratedReport
    private static void completeWorkFlowTask(TXHandle txHandle, Long actInsId, Long userId, String decOptionNumber, String auditMessage, Map<String, Object> variables) {
        DynamicObject actInsInfo = ActivityInsServiceHelper.getActivityInsById("wfcurtaskid,globaltaskid,actscheme,activity,handlers,taskswitch,wfprocessinsid,taskstatus,ssctaskid", actInsId);
        if (null == actInsInfo) {
            log.info("Got empty activity instance with id: {}.", (Object)actInsId);
            return;
        }
        long activitySchemeId = actInsInfo.getDynamicObject("actscheme").getLong("id");
        long activityId = actInsInfo.getDynamicObject("activity").getLong("id");
        Long taskId = actInsInfo.getLong("wfcurtaskid");
        Integer flowParam = ActivityInsServiceHelper.getFlowParam(activitySchemeId, activityId);
        if (userId == null || userId.compareTo(0L) == 0) {
            userId = RequestContext.get().getCurrUserId();
        }
        String taskSwitch = actInsInfo.getString("taskswitch");
        log.info("Task[{}] activitySchemeId:{}, activityId:{}, wfTaskId:{}, taskSwitch:{}.", new Object[]{actInsId, activitySchemeId, activityId, taskId, taskSwitch});
        try {
            if (HRStringUtils.equals((String)"2", (String)taskSwitch)) {
                long globalTaskId = actInsInfo.getLong("globaltaskid");
                log.info("Task[{}] globalTaskId:{}.", (Object)actInsId, (Object)globalTaskId);
                CompleteOperationParam completeOperationParam = new CompleteOperationParam();
                completeOperationParam.setTaskIds((List)Lists.newArrayList((Object[])new Long[]{globalTaskId}));
                completeOperationParam.setOperaterId(userId);
                completeOperationParam.setDecOptionNumber(decOptionNumber);
                completeOperationParam.setAuditMessage(HRStringUtils.isEmpty((String)auditMessage) ? "-" : auditMessage);
                completeOperationParam.setVariables(variables);
                BatchOperateResult operateResult = MessageCenterServiceHelper.completeBizTask((CompleteOperationParam)completeOperationParam);
                if (!operateResult.isSuccess()) {
                    String resultMessage = operateResult.getOperateResults().stream().map(OperateResult::getOperateMsg).reduce((acc, it) -> acc + "\n" + it).orElse("-");
                    log.info("Got error message: {} when drive task center with complete task[{}].", (Object)resultMessage, (Object)decOptionNumber);
                    txHandle.markRollback();
                }
            } else if (HRStringUtils.equals((String)"3", (String)taskSwitch)) {
                long sscTaskId = actInsInfo.getLong("ssctaskid");
                log.info("Task[{}] sscTaskId:{}.", (Object)actInsId, (Object)sscTaskId);
                if (0L == sscTaskId) {
                    return;
                }
                if (HRStringUtils.equals((String)"terminal", (String)decOptionNumber)) {
                    Map result;
                    HashMap paramMap;
                    String methodName;
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
                    Long finalUserId = userId;
                    Map<String, List> activityInsMap = Arrays.stream(serviceHelper.query("taskstatus,ssctaskid,handlers", new QFilter[]{new QFilter("wfprocessinsid", "=", (Object)actInsInfo.getLong("wfprocessinsid")), new QFilter("taskstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"10", "20"}))})).collect(Collectors.toMap(it -> it.getString("taskstatus"), it -> {
                        long processPersonId = finalUserId;
                        int handlersSize = it.getDynamicObjectCollection("handlers").size();
                        if (handlersSize > 0) {
                            processPersonId = (Long)((DynamicObject)((DynamicObject)it.getDynamicObjectCollection("handlers").get(0)).get("fbasedataid")).getPkValue();
                        }
                        return Collections.singletonList(Pair.of((Object)it.getLong("ssctaskid"), (Object)processPersonId));
                    }, (it1, it2) -> ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)it1, (Iterable)it2))));
                    log.info("Got activityInsMap: {}.", activityInsMap);
                    long operatorId = RequestContext.get().getCurrUserId();
                    List processingList = activityInsMap.get("20");
                    List toAssignList = activityInsMap.get("10");
                    if (null != processingList && !processingList.isEmpty()) {
                        methodName = "taskApproveByTerminate";
                        paramMap = new HashMap();
                        paramMap.put("list", processingList.stream().map(sscItemTask -> {
                            HashMap<String, Object> mapItem = new HashMap<String, Object>();
                            mapItem.put("taskId", sscItemTask.getKey());
                            mapItem.put("currentPersonId", sscItemTask.getValue());
                            mapItem.put("operatorId", operatorId);
                            return mapItem;
                        }).collect(Collectors.toList()));
                        log.info("Got request methodName: {} and params: {}.", (Object)methodName, paramMap);
                        result = (Map)HRMServiceHelper.invokeBizService((String)SSC_CLOUD_ID, (String)SSC_APP_ID, (String)SSC_SERVICE_NAME, (String)methodName, (Object[])new Object[]{paramMap});
                        log.info("Got result map: {}.", (Object)result);
                    }
                    if (null != toAssignList && !toAssignList.isEmpty()) {
                        methodName = "taskDeleteByTaskId";
                        paramMap = new HashMap();
                        paramMap.put("list", toAssignList.stream().map(sscItemTask -> {
                            HashMap<String, Object> mapItem = new HashMap<String, Object>();
                            mapItem.put("taskId", sscItemTask.getKey());
                            mapItem.put("currentPersonId", sscItemTask.getValue());
                            mapItem.put("operatorId", operatorId);
                            return mapItem;
                        }).collect(Collectors.toList()));
                        log.info("Got request methodName: {} and params: {}.", (Object)methodName, paramMap);
                        result = (Map)HRMServiceHelper.invokeBizService((String)SSC_CLOUD_ID, (String)SSC_APP_ID, (String)SSC_SERVICE_NAME, (String)methodName, (Object[])new Object[]{paramMap});
                        log.info("Got result map: {}.", (Object)result);
                    }
                } else {
                    String methodName = "taskApproveByComplete";
                    HashMap<String, Long> item = new HashMap<String, Long>();
                    item.put("taskId", sscTaskId);
                    item.put("currentPersonId", userId);
                    HashMap<String, ArrayList> paramMap = new HashMap<String, ArrayList>();
                    paramMap.put("list", Lists.newArrayList((Object[])new Map[]{item}));
                    log.info("Got request methodName: {} and params: {}.", (Object)methodName, paramMap);
                    Map result = (Map)HRMServiceHelper.invokeBizService((String)SSC_CLOUD_ID, (String)SSC_APP_ID, (String)SSC_SERVICE_NAME, (String)methodName, (Object[])new Object[]{paramMap});
                    log.info("Got result map: {}.", (Object)result);
                }
                TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)taskId);
                log.info("find taskInfo1 ? {} ,actInsId is {},taskId is {}, flowParam: {}.", new Object[]{taskInfo, actInsId, taskId, flowParam});
                if (null != taskInfo) {
                    WorkflowServiceHelper.completeTask((Long)taskId, (Long)userId, (String)decOptionNumber, (String)auditMessage, variables);
                } else {
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wf_hicomment");
                    QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", (Object)taskId)};
                    DynamicObject item = serviceHelper.queryOne("activityname", qFilters);
                    if (null != item) {
                        serviceHelper.deleteByFilter(qFilters);
                        Comment comment = WorkflowServiceHelper.createNewComment();
                        comment.setType("comment");
                        comment.setUserId(userId);
                        comment.setTime(TimeServiceHelper.now());
                        comment.setActivityName(item.getLocaleString("activityname"));
                        comment.setResultName((ILocaleString)DEC_OPTION_NUMBER_MAPPING.get(decOptionNumber).getName());
                        comment.setAssignee(ActivityInsServiceHelper.getAssignee(userId));
                        comment.setTaskId(taskId);
                        comment.setDecisionType("approve");
                        WorkflowServiceHelper.addComment((Comment)comment);
                    }
                }
            } else {
                TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)taskId);
                log.info("find taskInfo2 ? {} ,actInsId is {},taskId is {}", new Object[]{taskInfo, actInsId, taskId});
                if (taskInfo != null) {
                    WorkflowServiceHelper.completeTask((Long)taskId, (Long)userId, (String)decOptionNumber, (String)auditMessage, variables);
                } else {
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wf_hicomment");
                    QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", (Object)taskId)};
                    DynamicObject item = serviceHelper.queryOne("activityname", qFilters);
                    if (null != item) {
                        serviceHelper.deleteByFilter(qFilters);
                        Comment comment = WorkflowServiceHelper.createNewComment();
                        comment.setType("comment");
                        comment.setUserId(userId);
                        comment.setTime(TimeServiceHelper.now());
                        comment.setActivityName(item.getLocaleString("activityname"));
                        comment.setResultName((ILocaleString)DEC_OPTION_NUMBER_MAPPING.get(decOptionNumber).getName());
                        comment.setAssignee(ActivityInsServiceHelper.getAssignee(userId));
                        comment.setTaskId(taskId);
                        comment.setDecisionType("approve");
                        WorkflowServiceHelper.addComment((Comment)comment);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("Got exception when drive task center or workflow.", (Throwable)ex);
            throw new KDException((Throwable)ex, new ErrorCode("4", ResManager.loadKDString((String)"\u4e2d\u53f0\u8c03\u7528\u5de5\u4f5c\u6d41\u5931\u8d25", (String)"ActivityInsServiceHelper_13", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
        }
    }

    public static OperationResult reject(Long activityInsId, Long userId, String auditMessage) {
        return ActivityInsServiceHelper.reject(activityInsId, userId, auditMessage, false);
    }

    @ExcludeFromJacocoGeneratedReport
    public static OperationResult reject(Long activityInsId, Long userId, String auditMessage, boolean rejectBackToNode) {
        OperationResult result;
        block46: {
            DynamicObject taskInsInfo = ActivityInsServiceHelper.getActivityInsById("actscheme,activity,handlers,taskstatus,handletime,wfprocessinsid,wfnode,globaltaskid", activityInsId);
            result = ActivityInsServiceHelper.basicCheck(Boolean.TRUE, taskInsInfo, activityInsId);
            if (result.getAllErrorInfo().size() > 0) {
                return result;
            }
            String preTaskstatus = taskInsInfo.getString("taskstatus");
            long activitySchemeId = taskInsInfo.getLong("actscheme.id");
            long activityId = taskInsInfo.getLong("activity.id");
            Integer flowParam = ActivityInsServiceHelper.getFlowParam(activitySchemeId, activityId);
            if (ActivityConstants.FLOW_BY_HANDLE.compareTo(flowParam) == 0) {
                if (!ActivityCommonUtil.canRejectStatus(taskInsInfo)) {
                    result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u9a73\u56de\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"ActivityInsServiceHelper_1", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
                    result.setSuccess(false);
                    return result;
                }
                ActivityInsServiceHelper.constructTaskInfo(taskInsInfo, "30");
                DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "REJECT", userId, auditMessage, null);
                try (TXHandle txHandle = TX.required();){
                    try {
                        result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{taskInsInfo, recInfo}, (OperateOption)OperateOption.create());
                        ActivityNodeLogServiceHelper.save(preTaskstatus, "30", WorkflowEventEnum.REJECT.name(), userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                    }
                    catch (Exception exception) {
                        log.error("Got error when reject task.", (Throwable)exception);
                        throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                    }
                    try (TXHandle globalTaskTXHandle = TX.notSupported();){
                        try {
                            ActivityInsServiceHelper.rejectWorkFlowTask(txHandle, activityInsId, userId, auditMessage, rejectBackToNode);
                            break block46;
                        }
                        catch (Exception exception) {
                            log.error("Got error when reject workflow task.", (Throwable)exception);
                            throw new KDException((Throwable)exception, new ErrorCode("4", ResManager.loadKDString((String)"\u4e2d\u53f0\u8c03\u7528\u5de5\u4f5c\u6d41\u5931\u8d25", (String)"ActivityInsServiceHelper_13", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                        }
                    }
                }
            }
            if (ActivityConstants.FLOW_BY_ACTIVATE.compareTo(flowParam) == 0) {
                ActivityInsServiceHelper.constructTaskInfo(taskInsInfo, "30");
                DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "REJECT", userId, auditMessage, null);
                try (TXHandle txHandle = TX.required();){
                    try {
                        result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{taskInsInfo, recInfo}, (OperateOption)OperateOption.create());
                        ActivityNodeLogServiceHelper.save(preTaskstatus, "30", WorkflowEventEnum.REJECT.name(), userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                        break block46;
                    }
                    catch (Exception exception) {
                        log.error("Got error when reject task2.", (Throwable)exception);
                        throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                    }
                }
            }
            throw new KDBizException(ActivityErrorCode.analyzeSchemeFlowParamError(flowParam), new Object[0]);
        }
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    public static OperationResult terminate(Long activityInsId, Long userId, String auditMessage) {
        OperationResult result;
        block47: {
            DynamicObject taskInsInfo = ActivityInsServiceHelper.getActivityInsById("actscheme,activity,handlers,taskstatus,handletime,wfprocessinsid,wfnode", activityInsId);
            result = ActivityInsServiceHelper.basicCheck(Boolean.FALSE, taskInsInfo, activityInsId);
            if (result.getAllErrorInfo().size() > 0) {
                return result;
            }
            String preTaskstatus = taskInsInfo.getString("taskstatus");
            Integer flowParam = ActivityInsServiceHelper.getFlowParam(taskInsInfo.getLong("actscheme.id"), taskInsInfo.getLong("activity.id"));
            if (ActivityConstants.FLOW_BY_HANDLE.compareTo(flowParam) == 0) {
                if (!ActivityCommonUtil.canConsentOrTerminateStatus(taskInsInfo)) {
                    result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u7ec8\u6b62\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"ActivityInsServiceHelper_2", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
                    result.setSuccess(false);
                    return result;
                }
                ActivityInsServiceHelper.constructTaskInfo(taskInsInfo, "50");
                DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "TERMINATE", userId, auditMessage, null);
                try (TXHandle txHandle = TX.required();){
                    try (TXHandle globalTaskTXHandle = TX.notSupported();){
                        try {
                            ActivityInsServiceHelper.terminateWorkFlowTask(txHandle, activityInsId, userId, auditMessage);
                        }
                        catch (Exception exception) {
                            log.error("Got error when terminate workflow task.", (Throwable)exception);
                            throw new KDException((Throwable)exception, new ErrorCode("4", ResManager.loadKDString((String)"\u4e2d\u53f0\u8c03\u7528\u5de5\u4f5c\u6d41\u5931\u8d25", (String)"ActivityInsServiceHelper_13", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                        }
                    }
                    try {
                        result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{taskInsInfo, recInfo}, (OperateOption)OperateOption.create());
                        ActivityNodeLogServiceHelper.save(preTaskstatus, "50", WorkflowEventEnum.TERMINATE.name(), userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                        break block47;
                    }
                    catch (Exception exception) {
                        log.error("Got error when terminate task.", (Throwable)exception);
                        throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                    }
                }
            }
            if (ActivityConstants.FLOW_BY_ACTIVATE.compareTo(flowParam) == 0) {
                ActivityInsServiceHelper.constructTaskInfo(taskInsInfo, "50");
                DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "TERMINATE", userId, auditMessage, null);
                try (TXHandle txHandle = TX.required();){
                    try {
                        result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{taskInsInfo, recInfo}, (OperateOption)OperateOption.create());
                        ActivityNodeLogServiceHelper.save(preTaskstatus, "50", WorkflowEventEnum.TERMINATE.name(), userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                        break block47;
                    }
                    catch (Exception exception) {
                        log.error("Got error when terminate task2.", (Throwable)exception);
                        throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                    }
                }
            }
            throw new KDBizException(ActivityErrorCode.analyzeSchemeFlowParamError(flowParam), new Object[0]);
        }
        return result;
    }

    public static OperationResult consent(Long activityInsId, Long userId, String auditMessage) {
        OperationResult result;
        block61: {
            DynamicObject taskInsInfo = ActivityInsServiceHelper.getActivityInsById("actscheme,activity,handlers,taskstatus,handletime,wfprocessinsid,wfnode", activityInsId);
            DynamicObject activityScheme = taskInsInfo.getDynamicObject("actscheme");
            result = ActivityInsServiceHelper.checkNull(taskInsInfo, activityInsId);
            if (result.getAllErrorInfo().size() > 0) {
                return result;
            }
            DynamicObject tempActivityScheme = ActivitySchemeServiceHelper.getByNumberAndVersionAndActivityId("actschemeentry.checkhandler", activityScheme.getString("number"), activityScheme.getString("version"), taskInsInfo.getLong("activity.id"));
            boolean checkHandler = HRStringUtils.equals((String)"1", (String)((DynamicObject)((DynamicObject)tempActivityScheme.getDynamicObjectCollection("actschemeentry").get(0)).getDynamicObjectCollection("actinfo").get(0)).getString("checkhandler"));
            result = ActivityInsServiceHelper.basicCheck(checkHandler, taskInsInfo, activityInsId);
            if (result.getAllErrorInfo().size() > 0) {
                return result;
            }
            String preTaskstatus = taskInsInfo.getString("taskstatus");
            Integer flowParam = ActivityInsServiceHelper.getFlowParam(taskInsInfo.getLong("actscheme.id"), taskInsInfo.getLong("activity.id"));
            if (ActivityConstants.FLOW_BY_HANDLE.compareTo(flowParam) == 0) {
                if (!ActivityCommonUtil.canConsentOrTerminateStatus(taskInsInfo)) {
                    result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5904\u7406\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"ActivityInsServiceHelper_3", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
                    result.setSuccess(false);
                    return result;
                }
                ActivityInsServiceHelper.constructTaskInfo(taskInsInfo, "40");
                DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "CONSENT", userId, auditMessage, null);
                try (TXHandle txHandle = TX.required();){
                    try {
                        result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{taskInsInfo, recInfo}, (OperateOption)OperateOption.create());
                        ActivityNodeLogServiceHelper.save(preTaskstatus, "40", WorkflowEventEnum.CONSENT.name(), userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                    }
                    catch (Exception exception) {
                        log.error("Got error when consent task.", (Throwable)exception);
                        throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                    }
                    try (TXHandle globalTaskTXHandle = TX.notSupported();){
                        try {
                            ActivityInsServiceHelper.consentWorkFlowTask(txHandle, activityInsId, userId, auditMessage);
                            break block61;
                        }
                        catch (Exception exception) {
                            log.error("Got error when consent workflow task.", (Throwable)exception);
                            throw new KDException((Throwable)exception, new ErrorCode("4", ResManager.loadKDString((String)"\u4e2d\u53f0\u8c03\u7528\u5de5\u4f5c\u6d41\u5931\u8d25", (String)"ActivityInsServiceHelper_13", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                        }
                    }
                }
            }
            if (ActivityConstants.FLOW_BY_ACTIVATE.compareTo(flowParam) == 0) {
                ActivityInsServiceHelper.constructTaskInfo(taskInsInfo, "40");
                DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "CONSENT", userId, auditMessage, null);
                try (TXHandle txHandle = TX.required();){
                    try {
                        result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{taskInsInfo, recInfo}, (OperateOption)OperateOption.create());
                        ActivityNodeLogServiceHelper.save(preTaskstatus, "40", WorkflowEventEnum.CONSENT.name(), userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                    }
                    catch (Exception exception) {
                        log.error("Got error when consent task2.", (Throwable)exception);
                        throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                    }
                    try (TXHandle globalTaskTXHandle = TX.notSupported();){
                        try {
                            ActivityInsServiceHelper.consentWorkFlowTask(txHandle, activityInsId, userId, auditMessage);
                            break block61;
                        }
                        catch (Exception exception) {
                            log.error("Got error when consent workflow task2.", (Throwable)exception);
                            throw new KDException((Throwable)exception, new ErrorCode("4", ResManager.loadKDString((String)"\u4e2d\u53f0\u8c03\u7528\u5de5\u4f5c\u6d41\u5931\u8d25", (String)"ActivityInsServiceHelper_13", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                        }
                    }
                }
            }
            throw new KDBizException(ActivityErrorCode.analyzeSchemeFlowParamError(flowParam), new Object[0]);
        }
        return result;
    }

    private static void constructHandler(DynamicObjectCollection handlerColl) {
        DynamicObjectType dynamicObjectType = handlerColl.getDynamicObjectType();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        handlerColl.clear();
        DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
        DynamicObject handlerUsers = hrBaseServiceHelper.generateEmptyDynamicObject("bos_user");
        handlerUsers.set("id", (Object)RequestContext.get().getCurrUserId());
        mulBasedataDy.set("fbasedataid", (Object)handlerUsers);
        handlerColl.add((Object)mulBasedataDy);
    }

    private static void constructTaskInfo(DynamicObject taskInsInfo, String taskStatus) {
        taskInsInfo.set("taskstatus", (Object)taskStatus);
        taskInsInfo.set("handletime", (Object)TimeServiceHelper.now());
        DynamicObjectCollection handlerColl = taskInsInfo.getDynamicObjectCollection("handlers");
        ActivityInsServiceHelper.constructHandler(handlerColl);
    }

    private static OperationResult basicCheck(boolean checkHandler, DynamicObject taskInsInfo, Long activityInsId) {
        OperationResult result = new OperationResult();
        if (checkHandler && !ActivityInsServiceHelper.validateCanHandleByCurUser(taskInsInfo)) {
            result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u6d3b\u52a8\u5904\u7406\u4eba\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u9879\u64cd\u4f5c\u3002", (String)"ActivityInsServiceHelper_5", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
            result.setSuccess(false);
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    private static OperationResult checkNull(DynamicObject taskInsInfo, Long activityInsId) {
        OperationResult result = new OperationResult();
        if (taskInsInfo == null) {
            result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u6d3b\u52a8\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ActivityInsServiceHelper_4", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
            result.setSuccess(false);
            return result;
        }
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    private static OperationResult revocationBasicCheck(boolean checkHandler, DynamicObject taskInsInfo, Long activityInsId, OperationResult result) {
        if (taskInsInfo == null) {
            result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u6d3b\u52a8\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ActivityInsServiceHelper_4", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
            return result;
        }
        if (checkHandler && !ActivityInsServiceHelper.validateCanHandleByCurUser(taskInsInfo)) {
            result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u6d3b\u52a8\u5904\u7406\u4eba\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u9879\u64cd\u4f5c\u3002", (String)"ActivityInsServiceHelper_5", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
            return result;
        }
        return result;
    }

    public static DynamicObject getActivityInsById(String selectProperties, Long activityInsId) {
        String selector = PROPERTIES_INS;
        if (HRStringUtils.isNotEmpty((String)selectProperties)) {
            selector = selectProperties;
        }
        HRBaseServiceHelper insHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        return insHelper.queryOne(selector, new QFilter[]{new QFilter("id", "=", (Object)activityInsId)});
    }

    public static DynamicObject[] getActivityInsByIds(String selectProperties, Set<Long> activityInsIds) {
        String selector = PROPERTIES_INS;
        if (HRStringUtils.isNotEmpty((String)selectProperties)) {
            selector = selectProperties;
        }
        HRBaseServiceHelper insHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        return insHelper.query(selector, new QFilter[]{new QFilter("id", "in", activityInsIds)});
    }

    public static boolean validateCanHandleByCurUser(DynamicObject taskInsInfo) {
        DynamicObjectCollection handlerColl = taskInsInfo.getDynamicObjectCollection("handlers");
        Long curUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject temp : handlerColl) {
            Long dbHandlerId;
            if (temp.get("fbasedataid") == null || ((DynamicObject)temp.get("fbasedataid")).getPkValue() == null || curUserId.compareTo(dbHandlerId = (Long)((DynamicObject)temp.get("fbasedataid")).getPkValue()) != 0) continue;
            return true;
        }
        return false;
    }

    public static OperationResult generateActivityTask(String nodeId, Long bizBillCreatorId, String bizBillId, String bizNum, String bizKey, String bindBizBillId, String bindBizNum, String bindBizKey, String bindinglayoutid, Long wfProDefId, Long wfProInsId, Long wfCurTaskId, String activitySchemeNumber, String activitySchemeVersion, Long activityId, Long[] wfNodeParticipantIds) {
        DynamicObject actScheme = ActivitySchemeServiceHelper.getByNumberAndVersionAndActivityId("bizobj,actschemeentry.tasktheme,actschemeentry.activity", activitySchemeNumber, activitySchemeVersion, activityId);
        Long schemeId = null != actScheme ? Long.valueOf(actScheme.getLong("id")) : null;
        String taskSwitch = ActivityInsServiceHelper.getTaskSwitch(schemeId, activityId, wfProDefId, nodeId);
        if (HRStringUtils.equals((String)"3", (String)taskSwitch)) {
            wfNodeParticipantIds = new Long[]{};
        }
        DynamicObject actIns = BusinessDataServiceHelper.newDynamicObject((String)ENTITYNAME_INS);
        actIns.set("applier", (Object)bizBillCreatorId);
        actIns.set("bizbillid", (Object)bizBillId);
        actIns.set("biznum", (Object)bizNum);
        actIns.set("bizkey", (Object)bizKey);
        actIns.set("bindbizbillid", (Object)bindBizBillId);
        actIns.set("bindbiznum", (Object)bindBizNum);
        actIns.set("bindbizkey", (Object)bindBizKey);
        actIns.set("bindinglayoutid", (Object)bindinglayoutid);
        ActivityInsServiceHelper.setHandlersAndStatus(actIns, wfNodeParticipantIds);
        actIns.set("createtime", (Object)TimeServiceHelper.now());
        actIns.set("wfcurtaskid", (Object)wfCurTaskId);
        actIns.set("wfprocessdefinitionid", (Object)wfProDefId);
        actIns.set("wfprocessinsid", (Object)wfProInsId);
        actIns.set("schemenumber", (Object)activitySchemeNumber);
        actIns.set("schemeversion", (Object)activitySchemeVersion);
        actIns.set("activity", (Object)activityId);
        actIns.set("wfnode", (Object)nodeId);
        actIns.set("actthemestr", (Object)ActivitySchemeServiceHelper.transformActivityTheme(actScheme, activityId));
        actIns.set("actscheme", (Object)schemeId);
        actIns.set("taskswitch", (Object)taskSwitch);
        OperationResult result = ActivityInsServiceHelper.validateNotDupTask(activityId, schemeId, activitySchemeVersion, wfCurTaskId, bizBillId, bizKey, bindBizBillId);
        if (!result.isSuccess() && result.getAllErrorInfo().size() > 0) {
            result.setSuccess(false);
            return result;
        }
        Long actInsId = ORM.create().genLongId(ENTITYNAME_INS);
        actIns.set("id", (Object)actInsId);
        String desc = ResManager.loadKDString((String)"\u7531\u5de5\u4f5c\u6d41\u521b\u5efa\u5e76\u81ea\u52a8\u5206\u914d\u7ed9\u6d41\u7a0b\u53c2\u4e0e\u4eba\u3002", (String)"ActivityInsServiceHelper_6", (String)HRCS_BUSINESS, (Object[])new Object[0]);
        DynamicObject recDyn = new HRBaseServiceHelper(ENTITYNAME_REC).generateEmptyDynamicObject();
        recDyn.set("description", (Object)desc);
        recDyn.set("assigntype", (Object)"CREATE");
        recDyn.set("activityins", (Object)actInsId);
        if (null == schemeId) {
            result.setSuccess(false);
            return result;
        }
        return OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{actIns, recDyn}, (OperateOption)OperateOption.create());
    }

    private static void setHandlersAndStatus(DynamicObject actIns, Long[] wfNodeParticipantIds) {
        if (null != wfNodeParticipantIds && wfNodeParticipantIds.length > 0) {
            actIns.set("taskstatus", (Object)"20");
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
            DynamicObjectCollection dyColl = actIns.getDynamicObjectCollection("handlers");
            DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
            for (Long handlerId : wfNodeParticipantIds) {
                DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
                DynamicObject handlerUsers = hrBaseServiceHelper.generateEmptyDynamicObject("bos_user");
                handlerUsers.set("id", (Object)handlerId);
                mulBasedataDy.set("fbasedataid", (Object)handlerUsers);
                dyColl.add((Object)mulBasedataDy);
            }
        } else {
            actIns.set("taskstatus", (Object)"10");
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static OperationResult validateNotDupTask(Long activityId, Long schemeId, String activitySchemeVersion, Long wfCurTaskId, String bizBillId, String bizKey, String bindBizBillId) {
        OperationResult result = new OperationResult();
        HRBaseServiceHelper insHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        QFilter qfilter = new QFilter("activity", "=", (Object)activityId);
        qfilter.and(new QFilter("actscheme", "=", (Object)schemeId));
        qfilter.and(new QFilter("schemenumber", "=", (Object)activitySchemeVersion));
        qfilter.and(new QFilter("wfcurtaskid", "=", (Object)wfCurTaskId));
        qfilter.and(new QFilter("bizbillid", "=", (Object)bizBillId));
        qfilter.and(new QFilter("bizkey", "=", (Object)bizKey));
        qfilter.and(new QFilter("bindbizbillid", "=", (Object)bindBizBillId));
        QFilter statusFilter = new QFilter("taskstatus", "=", (Object)"10");
        statusFilter.or(new QFilter("taskstatus", "=", (Object)"20"));
        statusFilter.or(new QFilter("taskstatus", "=", (Object)"40"));
        qfilter.and(statusFilter);
        DynamicObject insInDB = insHelper.queryOne("id", qfilter);
        if (insInDB != null && insInDB.getPkValue() != null) {
            log.info(String.format("\u6839\u636e\u6d3b\u52a8id\u3001\u6d3b\u52a8\u65b9\u6848\u3001\u4e1a\u52a1\u5355\u636eid\u67e5\u8be2\u5230\u6709\u6b63\u5728\u6267\u884c\u7684\u6d3b\u52a8\u5b9e\u4f8b\uff0c\u56e0\u6b64\u4e0d\u91cd\u590d\u751f\u6210,\u8fc7\u6ee4\u6761\u4ef6\u4e3a \uff1a%s", qfilter.toSerializedString()));
            result.setSuccess(false);
            result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u5bf9\u5e94\u5355\u636e\u5df2\u6709\u6d3b\u52a8\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"ActivityInsServiceHelper_7", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, insInDB.getPkValue()));
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    public static OperationResult assignTask(Long activityInsId, List<Long> newHandlerId, String auditMessage) {
        OperationResult result;
        block37: {
            result = new OperationResult();
            DynamicObject actInsInfo = ActivityInsServiceHelper.getActivityInsById("", activityInsId);
            if (actInsInfo == null) {
                result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u6d3b\u52a8\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ActivityInsServiceHelper_4", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
                result.setSuccess(false);
                return result;
            }
            String preTaskstatus = actInsInfo.getString("taskstatus");
            if (newHandlerId == null || newHandlerId.size() == 0) {
                result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u5f85\u5206\u914d\u7684\u5904\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ActivityInsServiceHelper_8", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
                result.setSuccess(false);
                return result;
            }
            if (!ActivityCommonUtil.canAssignOrTransferStatus(actInsInfo)) {
                result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u975e\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u8fdb\u884c\u4e2d\u201d\u7684\u6d3b\u52a8\u4e0d\u5141\u8bb8\u8fdb\u884c\u5206\u914d\u64cd\u4f5c\u3002", (String)"ActivityInsServiceHelper_9", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
                result.setSuccess(false);
                return result;
            }
            Long curUserId = RequestContext.get().getCurrUserId();
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
            DynamicObjectCollection dyColl = actInsInfo.getDynamicObjectCollection("handlers");
            dyColl.clear();
            for (Long handlerId : newHandlerId) {
                DynamicObject mulBasedataDy = new DynamicObject(dyColl.getDynamicObjectType());
                DynamicObject handlerUsers = hrBaseServiceHelper.generateEmptyDynamicObject("bos_user");
                handlerUsers.set("id", (Object)handlerId);
                mulBasedataDy.set("fbasedataid", (Object)handlerUsers);
                dyColl.add((Object)mulBasedataDy);
            }
            actInsInfo.set("taskstatus", (Object)"20");
            DynamicObject assignRec = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "ASSIGN", curUserId, auditMessage, null);
            try (TXHandle txHandle = TX.required();){
                try {
                    result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{actInsInfo, assignRec}, (OperateOption)OperateOption.create());
                }
                catch (Exception exception) {
                    log.error("Got error when assign task.");
                    throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                }
                ActivityNodeLogServiceHelper.save(preTaskstatus, "20", WorkflowEventEnum.ASSIGN.name(), RequestContext.get().getCurrUserId(), actInsInfo.getLong("wfprocessinsid"), actInsInfo.getString("wfnode"));
                long activitySchemeId = actInsInfo.getLong("actscheme.id");
                long activityId = actInsInfo.getLong("activity.id");
                Integer flowParam = ActivityInsServiceHelper.getFlowParam(activitySchemeId, activityId);
                if (ActivityConstants.FLOW_BY_HANDLE.compareTo(flowParam) != 0) break block37;
                Long wfTaskID = actInsInfo.getLong("wfcurtaskid");
                String taskSwitch = actInsInfo.getString("taskswitch");
                log.info("Task[{}] activitySchemeId:{}, activityId:{}, wfTaskId:{}, taskSwitch:{}.", new Object[]{activityInsId, activitySchemeId, activityId, wfTaskID, taskSwitch});
                if (wfTaskID == 0L) break block37;
                log.info("Assign task [{}] with handlers [{}].", (Object)wfTaskID, newHandlerId);
                try (TXHandle globalTaskTXHandle = TX.notSupported();){
                    if (HRStringUtils.equals((String)"2", (String)taskSwitch)) {
                        long globalTaskId = actInsInfo.getLong("globaltaskid");
                        log.info("Task[{}] globalTaskId:{}.", (Object)activityInsId, (Object)globalTaskId);
                        UpdateParticipantParam updateParticipantParam = new UpdateParticipantParam();
                        updateParticipantParam.setTaskIds((List)Lists.newArrayList((Object[])new Long[]{globalTaskId}));
                        updateParticipantParam.setParticipantIds(newHandlerId);
                        BatchOperateResult operateResult = MessageCenterServiceHelper.updateParticipant((UpdateParticipantParam)updateParticipantParam);
                        if (!operateResult.isSuccess()) {
                            String resultMessage = operateResult.getOperateResults().stream().map(OperateResult::getOperateMsg).reduce((acc, it) -> acc + "\n" + it).orElse("-");
                            log.info("Got error message: {} when drive task center with transfer task.", (Object)resultMessage);
                            result.setSuccess(false);
                            result.addErrorInfo(new OperateErrorInfo(resultMessage, ErrorLevel.Error, actInsInfo.getPkValue()));
                            txHandle.markRollback();
                        }
                    } else if (HRStringUtils.equals((String)"3", (String)taskSwitch)) {
                        long sscTaskId = actInsInfo.getLong("ssctaskid");
                        log.info("Task[{}] sscTaskId:{}.", (Object)activityInsId, (Object)sscTaskId);
                    } else {
                        WorkflowServiceHelper.updateTaskInfoAndParticipant((TaskInfo)ActivityInsServiceHelper.getWFTaskInfo(wfTaskID), newHandlerId);
                    }
                }
                catch (Exception ex) {
                    log.error("Got error when assign workflow task", (Throwable)ex);
                    throw new KDException((Throwable)ex, new ErrorCode("4", ResManager.loadKDString((String)"\u4e2d\u53f0\u8c03\u7528\u5de5\u4f5c\u6d41\u5931\u8d25", (String)"ActivityInsServiceHelper_13", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                }
            }
        }
        return result;
    }

    private static TaskInfo getWFTaskInfo(Long wfTaskId) {
        return WorkflowServiceHelper.findTaskById((Long)wfTaskId);
    }

    public static OperationResult transferTask(Long activityInsId, Long newHandlerId, String auditMessage) {
        OperationResult result = new OperationResult();
        DynamicObject actInsInfo = ActivityInsServiceHelper.getActivityInsById("", activityInsId);
        if (actInsInfo == null) {
            result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u6d3b\u52a8\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ActivityInsServiceHelper_4", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
            result.setSuccess(false);
            return result;
        }
        if (!ActivityCommonUtil.canAssignOrTransferStatus(actInsInfo)) {
            result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u975e\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u8fdb\u884c\u4e2d\u201d\u7684\u6d3b\u52a8\u4e0d\u5141\u8bb8\u8fdb\u884c\u8f6c\u4ea4\u3002", (String)"ActivityInsServiceHelper_10", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
            result.setSuccess(false);
            return result;
        }
        DynamicObjectCollection handlerColl = actInsInfo.getDynamicObjectCollection("handlers");
        Long curUserId = RequestContext.get().getCurrUserId();
        boolean isCurrentHandler = false;
        DynamicObject transRecInfo = null;
        HashSet<Long> oriHandlerIDs = new HashSet<Long>(handlerColl.size());
        boolean isDupHandler = false;
        for (int i = 0; i < handlerColl.size(); ++i) {
            DynamicObject temp = (DynamicObject)handlerColl.get(i);
            if (temp.get("fbasedataid") == null || ((DynamicObject)temp.get("fbasedataid")).getPkValue() == null) continue;
            Long oriHandlerId = (Long)((DynamicObject)temp.get("fbasedataid")).getPkValue();
            if (oriHandlerIDs.contains(oriHandlerId)) {
                isDupHandler = true;
            }
            if (oriHandlerId.compareTo(newHandlerId) == 0) {
                isDupHandler = true;
            }
            oriHandlerIDs.add(oriHandlerId);
            if (oriHandlerId.compareTo(curUserId) != 0) continue;
            isCurrentHandler = true;
            temp.set("fbasedataid", (Object)newHandlerId);
            handlerColl.set(i, (Object)temp);
            transRecInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "TRANSFER", curUserId, auditMessage, null);
            DynamicObjectCollection curHandlerColl = transRecInfo.getDynamicObjectCollection("mulhandler");
            DynamicObjectType curDyType = curHandlerColl.getDynamicObjectType();
            DynamicObject curMulBasedataDy = new DynamicObject(curDyType);
            curMulBasedataDy.set("fbasedataid", (Object)newHandlerId);
            curHandlerColl.add((Object)curMulBasedataDy);
        }
        if (!isCurrentHandler) {
            result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u6d3b\u52a8\u5904\u7406\u4eba\u4e0d\u5141\u8bb8\u8fdb\u884c\u8f6c\u4ea4\u3002", (String)"ActivityInsServiceHelper_11", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, actInsInfo.getPkValue()));
            result.setSuccess(false);
            return result;
        }
        if (isDupHandler) {
            result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7684\u5904\u7406\u4eba\u5df2\u4e3a\u8be5\u4eba\u5458\uff0c\u4e0d\u5141\u8bb8\u8f6c\u4ea4\u3002", (String)"ActivityInsServiceHelper_12", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, actInsInfo.getPkValue()));
            result.setSuccess(false);
        } else {
            try (TXHandle txHandle = TX.required();){
                try {
                    result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{actInsInfo, transRecInfo}, (OperateOption)OperateOption.create());
                }
                catch (Exception exception) {
                    throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                }
                long activitySchemeId = actInsInfo.getLong("actscheme.id");
                long activityId = actInsInfo.getLong("activity.id");
                Integer flowParam = ActivityInsServiceHelper.getFlowParam(activitySchemeId, activityId);
                Long wfTaskId = actInsInfo.getLong("wfcurtaskid");
                LocaleString transferOpinion = new LocaleString(auditMessage);
                String taskSwitch = actInsInfo.getString("taskswitch");
                log.info("Task[{}] activitySchemeId:{}, activityId:{}, wfTaskId:{}, taskSwitch:{}.", new Object[]{activityInsId, activitySchemeId, activityId, wfTaskId, taskSwitch});
                try (TXHandle globalTaskTXHandle = TX.notSupported();){
                    try {
                        if (HRStringUtils.equals((String)"2", (String)taskSwitch)) {
                            long globalTaskId = actInsInfo.getLong("globaltaskid");
                            log.info("Task[{}] globalTaskId:{}.", (Object)activityInsId, (Object)globalTaskId);
                            TransferOperationParam transferOperationParam = new TransferOperationParam();
                            transferOperationParam.setTaskIds((List)Lists.newArrayList((Object[])new Long[]{globalTaskId}));
                            transferOperationParam.setOperaterId(Long.valueOf(RequestContext.get().getCurrUserId()));
                            transferOperationParam.setTransfererId(newHandlerId);
                            transferOperationParam.setTransferOpinion((ILocaleString)transferOpinion);
                            transferOperationParam.setTransferSubscribe(Boolean.TRUE.booleanValue());
                            BatchOperateResult operateResult = MessageCenterServiceHelper.transferBizTask((TransferOperationParam)transferOperationParam);
                            if (!operateResult.isSuccess()) {
                                String resultMessage = operateResult.getOperateResults().stream().map(OperateResult::getOperateMsg).reduce((acc, it) -> acc + "\n" + it).orElse("-");
                                log.info("Got error message: {} when drive task center with transfer task.", (Object)resultMessage);
                                result.setSuccess(false);
                                result.addErrorInfo(new OperateErrorInfo(resultMessage, ErrorLevel.Error, actInsInfo.getPkValue()));
                                txHandle.markRollback();
                            }
                        } else if (HRStringUtils.equals((String)"3", (String)taskSwitch)) {
                            long sscTaskId = actInsInfo.getLong("ssctaskid");
                            log.info("Task[{}] sscTaskId:{}.", (Object)activityInsId, (Object)sscTaskId);
                            TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)wfTaskId);
                            log.info(MessageFormat.format("find taskInfo ? {0} ,actInsId is {1},taskId is {2}", taskInfo, activityInsId, wfTaskId));
                            if (taskInfo != null) {
                                WorkflowServiceHelper.taskTransfer((Long)wfTaskId, (Long)newHandlerId, (ILocaleString)transferOpinion, (Boolean)Boolean.TRUE);
                            }
                        } else {
                            log.info("Ignore with taskSwitch: {}.", (Object)taskSwitch);
                            TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)wfTaskId);
                            log.info(MessageFormat.format("find taskInfo ? {0} ,actInsId is {1},taskId is {2}", taskInfo, activityInsId, wfTaskId));
                            if (taskInfo != null) {
                                WorkflowServiceHelper.taskTransfer((Long)wfTaskId, (Long)newHandlerId, (ILocaleString)transferOpinion, (Boolean)Boolean.TRUE);
                            }
                        }
                    }
                    catch (Exception ex) {
                        log.error("Got exception when invoke global task or workflow.", (Throwable)ex);
                        throw new KDException((Throwable)ex, new ErrorCode("4", ResManager.loadKDString((String)"\u4e2d\u53f0\u8c03\u7528\u5de5\u4f5c\u6d41\u5931\u8d25", (String)"ActivityInsServiceHelper_13", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                    }
                }
            }
        }
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void updateTaskBindBillInfo(Long taskId, String bindBizKey, Object bindBizBillId, String bindBizNum, String taskSwitch, Long taskIdValue) {
        if (ObjectUtils.isEmpty((Object)bindBizBillId) || !(bindBizBillId instanceof Long) && !(bindBizBillId instanceof String)) {
            throw new KDBizException(ActivityErrorCode.billCanNotBeNullOrThisTypeError(), new Object[0]);
        }
        Optional.ofNullable(ActivityInsServiceHelper.getActivityInsById("activity.bizobj.number,bindbizkey,bindbizbillid,bindbiznum,taskswitch,globaltaskid,ssctaskid", taskId)).ifPresent(taskInfo -> {
            String newBindBizKey = bindBizKey;
            if (HRStringUtils.isEmpty((String)newBindBizKey)) {
                newBindBizKey = taskInfo.getString("activity.bizobj.number");
            }
            taskInfo.set("bindbizkey", (Object)newBindBizKey);
            taskInfo.set("bindbizbillid", (Object)String.valueOf(bindBizBillId));
            taskInfo.set("bindbiznum", (Object)bindBizNum);
            if (HRStringUtils.equals((String)"2", (String)taskSwitch)) {
                taskInfo.set("globaltaskid", (Object)taskIdValue);
            } else if (HRStringUtils.equals((String)"3", (String)taskSwitch)) {
                taskInfo.set("ssctaskid", (Object)taskIdValue);
            }
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{taskInfo});
        });
    }

    public static DynamicObject getActivitySchemeByBindBizBillId(Object bindBizBillId) {
        if (ObjectUtils.isEmpty((Object)bindBizBillId) || !(bindBizBillId instanceof Long) && !(bindBizBillId instanceof String)) {
            throw new KDBizException(ActivityErrorCode.billCanNotBeNullOrThisTypeError(), new Object[0]);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        return serviceHelper.queryOne("actscheme", new QFilter[]{new QFilter("bindbizbillid", "=", (Object)String.valueOf(bindBizBillId))});
    }

    public static String getBizKey(Object entityId) {
        return Optional.ofNullable(new HRBaseServiceHelper("bos_entityobject").queryOne("id", entityId)).map(it -> it.getString("id")).orElse(null);
    }

    public static DynamicObject getLatestActivityTask(Object bizBillId, Long activityId) {
        if (ObjectUtils.isEmpty((Object)bizBillId) || !(bizBillId instanceof Long) && !(bizBillId instanceof String)) {
            throw new KDBizException(ActivityErrorCode.billCanNotBeNullOrThisTypeError(), new Object[0]);
        }
        QFilter billFilter = new QFilter("bizbillid", "=", (Object)String.valueOf(bizBillId));
        QFilter actFilter = new QFilter("activity.id", "=", (Object)activityId);
        QFilter[] filters = new QFilter[]{billFilter, actFilter};
        DynamicObjectCollection dyColl = QueryServiceHelper.query((String)ENTITYNAME_INS, (String)PROPERTIES_INS, (QFilter[])filters, (String)"createtime desc", (int)1);
        return dyColl.size() > 0 ? (DynamicObject)dyColl.get(0) : null;
    }

    public static DynamicObjectCollection getActivityTasks(String selectProperties, QFilter filters) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        String selector = ActivityInsServiceHelper.getSelector(selectProperties);
        DynamicObject[] dyArr = hrBaseServiceHelper.query(selector, new QFilter[]{filters});
        return ActivityInsServiceHelper.arrToColl(dyArr);
    }

    public static DynamicObjectCollection getActivityTasks(String selectProperties, String bizKey, Long userId, boolean isQueryAll) {
        if (userId == null || userId == 0L) {
            userId = RequestContext.get().getCurrUserId();
        }
        QFilter filter = new QFilter("handlers.fbasedataid", "in", (Object)userId);
        if (StringUtils.isNotEmpty((String)bizKey)) {
            filter.and(new QFilter("bizkey", "=", (Object)bizKey));
        }
        if (!isQueryAll) {
            filter.and(new QFilter("taskstatus", "=", (Object)"20"));
        }
        QFilter[] filters = new QFilter[]{filter};
        String selector = ActivityInsServiceHelper.getSelector(selectProperties);
        DynamicObject[] dyArr = new HRBaseServiceHelper(ENTITYNAME_INS).query(selector, filters);
        return ActivityInsServiceHelper.arrToColl(dyArr);
    }

    public static DynamicObjectCollection getActivityTasks(String selectProperties, String bizKey, String bindBizKey, Long userId, boolean isQueryAll) {
        if (userId == null || userId == 0L) {
            userId = RequestContext.get().getCurrUserId();
        }
        QFilter filter = new QFilter("handlers.fbasedataid", "in", (Object)userId);
        if (StringUtils.isNotEmpty((String)bizKey)) {
            filter.and(new QFilter("bizkey", "=", (Object)bizKey));
        }
        if (StringUtils.isNotEmpty((String)bindBizKey)) {
            filter.and(new QFilter("bindbizkey", "=", (Object)bindBizKey));
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        if (!isQueryAll) {
            filter.and(new QFilter("taskstatus", "=", (Object)"20"));
        }
        QFilter[] filters = new QFilter[]{filter};
        String selector = ActivityInsServiceHelper.getSelector(selectProperties);
        DynamicObject[] dyArr = hrBaseServiceHelper.query(selector, filters);
        return ActivityInsServiceHelper.arrToColl(dyArr);
    }

    public static DynamicObjectCollection getActivityTasksByUser(Long userId) {
        if (userId == null || userId == 0L) {
            userId = RequestContext.get().getCurrUserId();
        }
        QFilter billFilter = new QFilter("handlers.fbasedataid", "in", (Object)userId);
        QFilter[] filters = new QFilter[]{billFilter};
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        DynamicObject[] dyArr = hrBaseServiceHelper.query(PROPERTIES_INS, filters);
        return ActivityInsServiceHelper.arrToColl(dyArr);
    }

    private static DynamicObjectCollection arrToColl(DynamicObject[] dynArr) {
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        dyColl.addAll(Arrays.asList(dynArr));
        return dyColl;
    }

    private static String getSelector(String selectProperties) {
        String selector = PROPERTIES_INS;
        if (StringUtils.isNotEmpty((String)selectProperties)) {
            selector = selectProperties;
        }
        return selector;
    }

    public static Integer getFlowParam(Long activitySchemeId, Long activityId) {
        DynamicObject taskConfigInfo = ActivitySchemeServiceHelper.getTaskConfigByIdAndActivityId(activitySchemeId, activityId);
        return Optional.ofNullable(taskConfigInfo).map(it -> it.getInt("flowparam")).orElse(null);
    }

    public static Integer getFlowParam(Long actInsId) {
        DynamicObject insInfo = ActivityInsServiceHelper.getActivityInsById("", actInsId);
        return Optional.ofNullable(insInfo).map(it -> {
            Long activitySchemeId = it.getLong("actscheme.id");
            Long activityId = it.getLong("activity.id");
            return ActivityInsServiceHelper.getFlowParam(activitySchemeId, activityId);
        }).orElse(null);
    }

    public static DynamicObject[] getActivityInsByBizId(String selectProperties, String bizBillId) {
        String selector = PROPERTIES_INS;
        if (HRStringUtils.isNotEmpty((String)selectProperties)) {
            selector = selectProperties;
        }
        HRBaseServiceHelper insHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        return insHelper.query(selector, new QFilter[]{new QFilter("bizbillid", "=", (Object)bizBillId)});
    }

    public static void updateExceptionStatus(String result, Long exceptionId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_activityexception");
        DynamicObject dynamicObject = helper.queryOne("id,result,modifytime,modifier", new QFilter[]{new QFilter("id", "=", (Object)exceptionId)});
        dynamicObject.set("result", (Object)result);
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        helper.updateOne(dynamicObject);
    }

    @ExcludeFromJacocoGeneratedReport
    public static OperationResult revocation(String bizBillId, Long userId, String auditMessage, OperationResult result) {
        block27: {
            ArrayList<DynamicObject> runningActInsByBillid = ActivityInsServiceHelper.getRunningActInsByBillid(bizBillId);
            if (CollectionUtils.isEmpty(runningActInsByBillid)) {
                return result;
            }
            DynamicObject taskInsInfo = runningActInsByBillid.get(0);
            String preTaskstatus = taskInsInfo.getString("taskstatus");
            Long activityInsId = taskInsInfo.getLong("id");
            ActivityInsServiceHelper.revocationBasicCheck(Boolean.FALSE, taskInsInfo, activityInsId, result);
            if (result.getAllErrorInfo().size() > 0) {
                return result;
            }
            Integer flowParam = ActivityInsServiceHelper.getFlowParam(taskInsInfo.getLong("actscheme.id"), taskInsInfo.getLong("activity.id"));
            try (TXHandle txHandle = TX.required();){
                if (ActivityConstants.FLOW_BY_HANDLE.compareTo(flowParam) == 0) {
                    if (!ActivityCommonUtil.canConsentOrTerminateStatus(taskInsInfo)) {
                        result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u64a4\u56de\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"ActivityInsServiceHelper_15", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
                        OperationResult operationResult = result;
                        return operationResult;
                    }
                    ActivityInsServiceHelper.constructTaskInfo(taskInsInfo, "70");
                    DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "REVOCATION", userId, auditMessage, null);
                    try {
                        ActivityInsServiceHelper.abandonActivityIns(txHandle, taskInsInfo, userId);
                        result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{taskInsInfo, recInfo}, (OperateOption)OperateOption.create());
                        ActivityNodeLogServiceHelper.save(preTaskstatus, "70", WorkflowEventEnum.REVOKE.name(), userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                        break block27;
                    }
                    catch (Exception exception) {
                        throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                    }
                }
                if (ActivityConstants.FLOW_BY_ACTIVATE.compareTo(flowParam) == 0) {
                    for (DynamicObject dynamicObject : runningActInsByBillid) {
                        ActivityInsServiceHelper.constructTaskInfo(dynamicObject, "70");
                        DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(dynamicObject.getLong("id"), "REVOCATION", userId, auditMessage, null);
                        try {
                            result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{dynamicObject, recInfo}, (OperateOption)OperateOption.create());
                        }
                        catch (Exception exception) {
                            throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                        }
                    }
                    try {
                        ActivityInsServiceHelper.abandonActivityIns(txHandle, taskInsInfo, userId);
                    }
                    catch (Exception exception) {
                        throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                    }
                    ActivityNodeLogServiceHelper.save(preTaskstatus, "70", WorkflowEventEnum.REVOKE.name(), userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                    break block27;
                }
                throw new KDBizException(ActivityErrorCode.analyzeSchemeFlowParamError(flowParam), new Object[0]);
            }
        }
        return result;
    }

    private static void abandonActivityIns(TXHandle txHandle, DynamicObject taskInsInfo, Long userId) {
        DynamicObject[] query;
        HRBaseServiceHelper insHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        for (DynamicObject dynamicObject : query = insHelper.query("handlers,taskstatus,isabandon,globaltaskid,ssctaskid,taskswitch", new QFilter[]{new QFilter("bizbillid", "=", (Object)taskInsInfo.getString("bizbillid"))})) {
            dynamicObject.set("isabandon", (Object)"1");
        }
        insHelper.update(query);
        Map<String, List<DynamicObject>> activityInsMap = Arrays.stream(query).filter(it -> {
            String taskSwitch = it.getString("taskswitch");
            return HRStringUtils.equals((String)"2", (String)taskSwitch) || HRStringUtils.equals((String)"3", (String)taskSwitch);
        }).collect(Collectors.groupingBy(it -> it.getString("taskswitch")));
        List globalTaskActivityIns = activityInsMap.getOrDefault("2", new ArrayList());
        List sscTaskActivityIns = activityInsMap.getOrDefault("3", new ArrayList());
        if (!globalTaskActivityIns.isEmpty()) {
            List globalTaskIds = Arrays.stream(query).map(it -> it.getLong("globaltaskid")).filter(it -> 0L != it).distinct().collect(Collectors.toList());
            DeleteOperationParam deleteOperationParam = new DeleteOperationParam();
            deleteOperationParam.setTaskIds(globalTaskIds);
            deleteOperationParam.setOperaterId(userId);
            BatchOperateResult operateResult = MessageCenterServiceHelper.deleteBizTask((DeleteOperationParam)deleteOperationParam);
            if (!operateResult.isSuccess()) {
                String resultMessage = operateResult.getOperateResults().stream().map(OperateResult::getOperateMsg).reduce((acc, it) -> acc + "\n" + it).orElse("-");
                log.info("Got error message: {} when drive task center with delete task[{}].", (Object)resultMessage, (Object)deleteOperationParam);
                txHandle.markRollback();
            }
        }
        if (!sscTaskActivityIns.isEmpty()) {
            Map<String, List> sscActivityInsMap = sscTaskActivityIns.stream().collect(Collectors.toMap(it -> it.getString("taskstatus"), it -> {
                long processPersonId = userId;
                int handlersSize = it.getDynamicObjectCollection("handlers").size();
                if (handlersSize > 0) {
                    processPersonId = (Long)((DynamicObject)((DynamicObject)it.getDynamicObjectCollection("handlers").get(0)).get("fbasedataid")).getPkValue();
                }
                return Collections.singletonList(Pair.of((Object)it.getLong("ssctaskid"), (Object)processPersonId));
            }, (it1, it2) -> ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)it1, (Iterable)it2))));
            long operatorId = RequestContext.get().getCurrUserId();
            List processingList = sscActivityInsMap.getOrDefault("20", new ArrayList());
            List toAssignList = sscActivityInsMap.getOrDefault("10", new ArrayList());
            try (TXHandle taskTXHandle = TX.notSupported();){
                Map result;
                HashMap paramMap;
                String methodName;
                if (null != processingList && !processingList.isEmpty()) {
                    methodName = "taskApproveByTerminate";
                    paramMap = new HashMap();
                    paramMap.put("list", processingList.stream().map(sscItemTask -> {
                        HashMap<String, Object> mapItem = new HashMap<String, Object>();
                        mapItem.put("taskId", sscItemTask.getKey());
                        mapItem.put("currentPersonId", sscItemTask.getValue());
                        mapItem.put("operatorId", operatorId);
                        return mapItem;
                    }).collect(Collectors.toList()));
                    log.info("Got request methodName: {} and params: {}.", (Object)methodName, paramMap);
                    result = (Map)HRMServiceHelper.invokeBizService((String)SSC_CLOUD_ID, (String)SSC_APP_ID, (String)SSC_SERVICE_NAME, (String)methodName, (Object[])new Object[]{paramMap});
                    log.info("Got result map: {}.", (Object)result);
                }
                if (null != toAssignList && !toAssignList.isEmpty()) {
                    methodName = "taskDeleteByTaskId";
                    paramMap = new HashMap();
                    paramMap.put("list", toAssignList.stream().map(sscItemTask -> {
                        HashMap<String, Object> mapItem = new HashMap<String, Object>();
                        mapItem.put("taskId", sscItemTask.getKey());
                        mapItem.put("currentPersonId", sscItemTask.getValue());
                        mapItem.put("operatorId", operatorId);
                        return mapItem;
                    }).collect(Collectors.toList()));
                    log.info("Got request methodName: {} and params: {}.", (Object)methodName, paramMap);
                    result = (Map)HRMServiceHelper.invokeBizService((String)SSC_CLOUD_ID, (String)SSC_APP_ID, (String)SSC_SERVICE_NAME, (String)methodName, (Object[])new Object[]{paramMap});
                    log.info("Got result map: {}.", (Object)result);
                }
            }
        }
    }

    public static ArrayList<DynamicObject> getRunningActInsByBillid(String bizbillid) {
        DynamicObject[] query;
        HRBaseServiceHelper insHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        ArrayList actList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dynamicObject : query = insHelper.query("actscheme,activity,handlers,taskstatus,handletime,bizbillid,isabandon,wfprocessinsid,wfnode", new QFilter[]{new QFilter("bizbillid", "=", (Object)bizbillid)}, "createtime desc")) {
            if (!"20".equals(dynamicObject.getString("taskstatus")) && !"10".equals(dynamicObject.getString("taskstatus"))) continue;
            actList.add(dynamicObject);
        }
        return actList;
    }

    public static OperationResult rejectToNode(Long activityInsId, Long userId, String auditMessage, String nodeId, boolean rejectBackToNode) {
        OperationResult result;
        block35: {
            DynamicObject taskInsInfo = ActivityInsServiceHelper.getActivityInsById("actscheme,activity,handlers,taskstatus,handletime,wfprocessinsid,wfnode", activityInsId);
            result = ActivityInsServiceHelper.basicCheck(Boolean.TRUE, taskInsInfo, activityInsId);
            if (result.getAllErrorInfo().size() > 0) {
                return result;
            }
            String preTaskstatus = taskInsInfo.getString("taskstatus");
            Integer flowParam = ActivityInsServiceHelper.getFlowParam(taskInsInfo.getLong("actscheme.id"), taskInsInfo.getLong("activity.id"));
            if (ActivityConstants.FLOW_BY_HANDLE.compareTo(flowParam) == 0) {
                if (!ActivityCommonUtil.canRejectStatus(taskInsInfo)) {
                    result.addErrorInfo(new OperateErrorInfo(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u9a73\u56de\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"ActivityInsServiceHelper_1", (String)HRCS_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error, (Object)activityInsId));
                    result.setSuccess(false);
                    return result;
                }
                ActivityInsServiceHelper.constructTaskInfo(taskInsInfo, "30");
                DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "REJECT", userId, auditMessage, null);
                try (TXHandle txHandle = TX.required();){
                    try {
                        result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{taskInsInfo, recInfo}, (OperateOption)OperateOption.create());
                        ActivityNodeLogServiceHelper.save(preTaskstatus, "30", WorkflowEventEnum.REJECT.name(), userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                    }
                    catch (Exception exception) {
                        throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                    }
                    try (TXHandle globalTaskTXHandle = TX.notSupported();){
                        try {
                            ActivityInsServiceHelper.rejectWorkFlowToNodeTask(txHandle, activityInsId, userId, auditMessage, rejectBackToNode, nodeId);
                            break block35;
                        }
                        catch (Exception exception) {
                            log.error("Got error when reject to node workflow task.", (Throwable)exception);
                            throw new KDException((Throwable)exception, new ErrorCode("4", ResManager.loadKDString((String)"\u4e2d\u53f0\u8c03\u7528\u5de5\u4f5c\u6d41\u5931\u8d25", (String)"ActivityInsServiceHelper_13", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                        }
                    }
                }
            }
            if (ActivityConstants.FLOW_BY_ACTIVATE.compareTo(flowParam) == 0) {
                ActivityInsServiceHelper.constructTaskInfo(taskInsInfo, "30");
                DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(activityInsId, "REJECT", userId, auditMessage, null);
                try {
                    result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])new DynamicObject[]{taskInsInfo, recInfo}, (OperateOption)OperateOption.create());
                    ActivityNodeLogServiceHelper.save(preTaskstatus, "30", WorkflowEventEnum.REJECT.name(), userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                }
                catch (Exception exception) {
                    throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                }
            } else {
                throw new KDBizException(ActivityErrorCode.analyzeSchemeFlowParamError(flowParam), new Object[0]);
            }
        }
        return result;
    }

    private static ILocaleString getAssignee(Long userId) {
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject user = userHelper.queryOne("name", (Object)userId);
        HashMap<Long, ILocaleString> assignerMap = new HashMap<Long, ILocaleString>();
        assignerMap.put(userId, user.getLocaleString("name"));
        ArrayList assignerIds = new ArrayList(assignerMap.keySet());
        List userMainOrgList = UserServiceHelper.getUserMainOrgId(assignerIds);
        Map<Long, Long> userMainOrgMap = userMainOrgList.stream().collect(Collectors.toMap(it -> (Long)new ArrayList(it.keySet()).get(0), it -> new ArrayList(it.values()).stream().findAny().orElse(0L), (oldValue, newValue) -> oldValue));
        List mainOrgIdList = userMainOrgList.stream().flatMap(it -> it.values().stream()).distinct().collect(Collectors.toList());
        DynamicObject[] mainOgrItems = BusinessDataServiceHelper.load((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("fisadministrative", "=", (Object)"1"), new QFilter("id", "in", mainOrgIdList)});
        Map<Long, ILocaleString> mainOrgMap = Arrays.stream(mainOgrItems).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getLocaleString("name"), (oldValue, newValue) -> oldValue));
        HashMap mulLang = new HashMap();
        assignerMap.forEach((tempUserId, tempUserName) -> {
            Long tempMainOrgId = (Long)userMainOrgMap.get(tempUserId);
            ILocaleString mainOrgName = (ILocaleString)mainOrgMap.get(tempMainOrgId);
            if (null != tempMainOrgId && 0L != tempMainOrgId && null != mainOrgName) {
                mainOrgName.forEach((localeId, mainOrgNameStr) -> mulLang.compute(localeId, (key, value) -> {
                    String newValue = "";
                    if (null != value && !"".equals(value)) {
                        newValue = value + " | ";
                    }
                    if (null != mainOrgNameStr && !"".equals(mainOrgNameStr.trim())) {
                        return newValue + (String)tempUserName.get(key) + "  " + mainOrgNameStr;
                    }
                    return newValue + (String)tempUserName.get(key);
                }));
            } else {
                tempUserName.forEach((localeId, tempUserNameStr) -> mulLang.compute(localeId, (key, value) -> {
                    if (null != value && !"".equals(value)) {
                        return value + " | " + tempUserNameStr;
                    }
                    return tempUserNameStr;
                }));
            }
        });
        return LocaleString.fromMap(mulLang);
    }

    public static Map<String, String> getTaskConfig(Long procDefId, String currentNodeId) {
        List elements = WorkflowServiceHelper.getProcElementsByProcDefId((Long)procDefId);
        log.info("Got {} element with procDefId: {}.", (Object)Optional.ofNullable(elements).map(List::size).orElseGet(() -> -1), (Object)procDefId);
        if (null == elements) {
            return null;
        }
        Optional<WFExtendAttributeGroup> optionalWFExtendAttributeGroup = elements.stream().filter(it -> "HRActivity".equalsIgnoreCase(it.getType()) && currentNodeId.equalsIgnoreCase(it.getId())).findAny().map(item -> (WFAuditTask)item).map(WFFlowNode::getExtAttrGroup).map(it -> (WFExtendAttributeGroup)it.get("hractivityconfig")).filter(WFExtendAttributeGroup::isGroupEnable);
        if (optionalWFExtendAttributeGroup.isPresent()) {
            WFExtendAttributeGroup group = optionalWFExtendAttributeGroup.get();
            if (null != group.getExtAttrValue() && null != group.getExtAttrValue().get("taskconfig")) {
                Map map = (Map)SerializationUtils.fromJsonString((String)((String)group.getExtAttrValue().get("taskconfig")), Map.class);
                String saveValue = (String)map.get("saveValue");
                if (Pattern.compile("[0-9]+").matcher(saveValue).matches()) {
                    try (DataSet dataSet = DB.queryDataSet((String)"ActivityInsServiceHelper_t_hrcs_activitynodeconf_query", (DBRoute)new DBRoute("hmp"), (String)"select fsetting from t_hrcs_activitynodeconf where fid = ?", (Object[])new Object[]{Long.parseLong(saveValue)});){
                        while (dataSet.hasNext()) {
                            saveValue = dataSet.next().getString(0);
                        }
                    }
                }
                log.info("Got saveValue: {} from workflow node ext config.", (Object)saveValue);
                Map taskConfig = (Map)SerializationUtils.fromJsonString((String)saveValue, Map.class);
                return taskConfig;
            }
            log.info("Can not find task config group from proDefId: {}, currentNodeId: {}.", (Object)procDefId, (Object)currentNodeId);
        } else {
            log.info("Can not find element from proDefId: {}, currentNodeId: {}.", (Object)procDefId, (Object)currentNodeId);
        }
        return null;
    }

    private static String getTaskSwitch(Long activitySchemeId, Long activityId, Long procDefId, String currentNodeId) {
        log.info("getTaskSwitch params activitySchemeId: {}, activityId: {}, procDefId: {}, currentNodeId: {}.", new Object[]{activitySchemeId, activityId, procDefId, currentNodeId});
        String taskSwitch = "1";
        boolean inGlobalTask = ActivityInsServiceHelper.inGlobalTask(activitySchemeId, activityId, new HashMap<String, Object>());
        if (inGlobalTask) {
            taskSwitch = "2";
        } else {
            String taskValue;
            Map<String, String> taskConfig = ActivityInsServiceHelper.getTaskConfig(procDefId, currentNodeId);
            if (null != taskConfig && (HRStringUtils.equals((String)"2", (String)(taskValue = taskConfig.get("taskvalue"))) || HRStringUtils.equals((String)"3", (String)taskValue))) {
                taskSwitch = taskValue;
            }
        }
        return taskSwitch;
    }

    private static boolean inGlobalTask(Long activitySchemeId, Long activityId, Map<String, Object> vars) {
        HRPluginProxy proxy = new HRPluginProxy(null, IActivityTaskExtService.class, "kd.hr.hbp.business.extpoint.activity.IActivityTaskExtService", null);
        return proxy.callReplace(p -> p.inTodo(activitySchemeId.longValue(), activityId.longValue(), vars)).stream().filter(it -> it).findAny().orElse(Boolean.FALSE);
    }

    public static Long getActivityInsIdBySSCTaskId(Long sscTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        return Optional.ofNullable(serviceHelper.queryOne("id", new QFilter[]{new QFilter("ssctaskid", "=", (Object)sscTaskId)})).map(it -> it.getLong("id")).orElse(0L);
    }

    public static void revert(Long activityInsId) {
        try (TXHandle txHandle = TX.required();){
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
            DynamicObject actInsInfo = serviceHelper.queryOne("id,taskstatus,wfprocessinsid,wfnode,handlers", (Object)activityInsId);
            ActivityNodeLogServiceHelper.save(actInsInfo.getString("taskstatus"), "10", WorkflowEventEnum.ASSIGN.name(), RequestContext.get().getCurrUserId(), actInsInfo.getLong("wfprocessinsid"), actInsInfo.getString("wfnode"));
            actInsInfo.set("taskstatus", (Object)"10");
            actInsInfo.set("handlers", null);
            serviceHelper.updateOne(actInsInfo);
        }
    }

    static {
        DEC_OPTION_NUMBER_MAPPING.put("consent", DecOptionNumberEnum.CONSENT);
        DEC_OPTION_NUMBER_MAPPING.put("reject", DecOptionNumberEnum.REJECT);
        DEC_OPTION_NUMBER_MAPPING.put("terminal", DecOptionNumberEnum.TERMINAL);
    }
}

