/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.activity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.metadata.dao.designer.DesignerMetaDao;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.ServiceImpl;
import kd.bos.workflow.engine.impl.TaskServiceImpl;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.HRBizCloudServiceHelper;

public class ActivitySchemeServiceHelper {
    private static final String ENTITY_NAME = "hrcs_activityscheme";

    public static List<Map<String, String>> getBizCloud() {
        return HRBizCloudServiceHelper.getBizCloudIdAndName().stream().map(pair -> {
            HashMap<String, Object> bizCloudMap = new HashMap<String, Object>(16);
            bizCloudMap.put("id", "1_split_" + (String)pair.getKey());
            bizCloudMap.put("name", pair.getValue());
            return bizCloudMap;
        }).collect(Collectors.toList());
    }

    public static List<String> getAppIdsByCloudId(String cloudId, String appFlag) {
        return ActivitySchemeServiceHelper.findBizAppExistsEntity(cloudId, appFlag);
    }

    public static List<String> getAppByHbssCloudId(String cloudId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_cloud_app");
        DynamicObject[] query = serviceHelper.query("app,app.id", new QFilter[]{new QFilter("app.bizcloud.id", "=", (Object)cloudId)}, "index asc");
        List<String> collect = Arrays.stream(query).map(app -> app.getString("app.id")).collect(Collectors.toList());
        return collect;
    }

    public static void disableLatestById(List<Long> ids) {
        List pkIds = ids.stream().filter(it -> !it.equals(0L)).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        serviceHelper.update((DynamicObject[])Arrays.stream(serviceHelper.query("id, islatest", new QFilter[]{new QFilter("id", "in", pkIds)})).peek(it -> it.set("islatest", (Object)"0")).toArray(DynamicObject[]::new));
    }

    public static DynamicObject generateEmptyActivityScheme() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        return serviceHelper.generateEmptyDynamicObject();
    }

    public static DynamicObject getById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        return serviceHelper.queryOne("sequence", (Object)id);
    }

    public static DynamicObject[] getEntryByActivitySchemeIds(List<Long> ids) {
        List pkIds = ids.stream().filter(it -> !it.equals(0L)).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pkIds)};
        String selectProperties = "actschemeentry.activity,actschemeentry.actbizobj, actschemeentry.bindinglayoutid, actschemeentry.taskcreatetype, actschemeentry.tasktheme, actschemeentry.taskassignmenttype, actschemeentry.sla, actschemeentry.flowparam, actschemeentry.paramname, actschemeentry.paramnumber, actschemeentry.paramvalue,actschemeentry.pluginentry,actschemeentry.subentryentity,actschemeentry.targetfield,actschemeentry.targetfieldnumber,actschemeentry.soucefieldname,actschemeentry.sourcefield,actschemeentry.fieldactivityid,actschemeentry.plugintype,actschemeentry.plugindesc,actschemeentry.bizapp,actschemeentry.service,actschemeentry.method";
        String orders = "actschemeentry.seq asc";
        return serviceHelper.query(selectProperties, qFilters, orders);
    }

    public static DynamicObject getByNumberAndVersion(String selectProperties, String number, String version) {
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            selectProperties = "id";
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        return serviceHelper.queryOne(selectProperties, new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("version", "=", (Object)version)});
    }

    public static DynamicObject getByNumberAndVersionAndActivityId(String selectProperties, String number, String version, Long activityId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        DynamicObject item = serviceHelper.queryOne(selectProperties = HRStringUtils.isEmpty((String)selectProperties) ? "id,actschemeentry.activity" : selectProperties + ",actschemeentry.activity", new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("version", "=", (Object)version)});
        if (null != item) {
            item.getDynamicObjectCollection("actschemeentry").removeIf(it -> !activityId.equals(it.getDynamicObject("activity").getLong("id")));
        }
        return item;
    }

    public static DynamicObject getLatestByNumber(String selectProperties, String number) {
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            selectProperties = "id";
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        return serviceHelper.queryOne(selectProperties, new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("islatest", "=", (Object)"1")});
    }

    public static DynamicObject getByID(String selectProperties, Long schemeID) {
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            selectProperties = "id";
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        return serviceHelper.queryOne(selectProperties, new QFilter[]{new QFilter("id", "=", (Object)schemeID)});
    }

    public static DynamicObject getTaskConfigByIdAndActivityId(Long activitySchemeId, Long activityId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)activitySchemeId)};
        String selectProperties = "actschemeentry.activity,actschemeentry.taskcreatetype, actschemeentry.tasktheme, actschemeentry.taskassignmenttype,actschemeentry.sla,actschemeentry.flowparam,actschemeentry.globaltask";
        DynamicObject result = serviceHelper.queryOne(selectProperties, qFilters);
        return Optional.ofNullable(result).map(item -> {
            item.getDynamicObjectCollection("actschemeentry").removeIf(it -> !activityId.equals(it.getDynamicObject("activity").getLong("id")));
            return Optional.ofNullable(item.getDynamicObjectCollection("actschemeentry")).map(it -> (DynamicObject)((DynamicObject)it.get(0)).getDynamicObjectCollection("actinfo").get(0)).orElse(null);
        }).orElse(null);
    }

    public static List<DynamicObject> getDomainParamByIdAndActivityId(Long activitySchemeId, Long activityId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)activitySchemeId)};
        String selectProperties = "actschemeentry.activity,actschemeentry.paramname, actschemeentry.paramnumber, actschemeentry.paramvalue";
        DynamicObject result = serviceHelper.queryOne(selectProperties, qFilters);
        return Optional.ofNullable(result).map(item -> {
            item.getDynamicObjectCollection("actschemeentry").removeIf(it -> !activityId.equals(it.getDynamicObject("activity").getLong("id")));
            return item.getDynamicObjectCollection("actschemeentry").stream().map(it -> it.getDynamicObjectCollection("paramconfig")).flatMap(Collection::stream).collect(Collectors.toList());
        }).orElseGet(Collections::emptyList);
    }

    public static String transformActivityTheme(DynamicObject activityScheme, Long activityId) {
        if (null == activityScheme || null == activityId) {
            return "";
        }
        Optional<String> taskThemeExpr = activityScheme.getDynamicObjectCollection("actschemeentry").stream().filter(it -> activityId.equals(it.getDynamicObject("activity").getLong("id"))).findFirst().map(it -> ((DynamicObject)it.getDynamicObjectCollection("actinfo").get(0)).getString("tasktheme"));
        if (!taskThemeExpr.isPresent()) {
            return "";
        }
        DynamicObject bizObj = activityScheme.getDynamicObject("bizobj");
        BusinessModelVariableScope scope = new BusinessModelVariableScope(bizObj);
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        TaskServiceImpl taskService = new TaskServiceImpl(configuration);
        ((ServiceImpl)taskService).setCommandExecutor(configuration.getCommandExecutor());
        return taskService.contentParser(taskThemeExpr.get(), bizObj, (VariableScope)scope, false);
    }

    public static DynamicObject[] getLayoutByEntityId(String entityId) {
        QFilter[] filters = new QFilter[]{new QFilter("basedatafield", "=", (Object)entityId), new QFilter("id", "!=", (Object)entityId), new QFilter("modeltype", "!=", (Object)"PrintModel")};
        return new DesignerMetaDao().getFormDesignMeta("id,name,number", filters);
    }

    public static DynamicObject getByNumber(String number) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME);
        return serviceHelper.queryOne("id", new QFilter[]{new QFilter("number", "=", (Object)number)});
    }

    public static List<String> findBizAppExistsEntity(String bizCloudId, String appFlag) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT A.FID, A.FMASTERID, A.FINHERITPATH ");
        sql.append(" FROM T_META_BIZAPP A");
        sql.append(" WHERE A.FBIZCLOUDID = ?");
        sql.append(" AND a.fdeploystatus = '2' ");
        sql.append(" AND ( EXISTS (  ");
        sql.append("   SELECT 1 FROM T_META_ENTITYDESIGN E");
        sql.append("   LEFT JOIN T_META_BIZUNITRELFORM B  ");
        sql.append("   ON E.FID = B.FFORMID  ");
        sql.append("   LEFT JOIN t_meta_mainentityinfo f  ");
        sql.append("   on f.fdentityid = b.fformid  ");
        sql.append("   WHERE  B.FBIZAPPID = A.FID ");
        sql.append("   AND E.FMODELTYPE IN ('BillFormModel', 'BaseFormModel', 'DynamicFormModel') ");
        sql.append("   AND e.FISTEMPLATE = '0' ) ");
        sql.append(" )");
        Object[] filters = new String[]{bizCloudId};
        Set idSet = (Set)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, rs -> {
            HashMap extMap = Maps.newHashMapWithExpectedSize((int)16);
            HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)16);
            while (rs.next()) {
                String id = rs.getString(1);
                String masterId = rs.getString(2);
                String inheritPath = rs.getString(3);
                ActivitySchemeServiceHelper.addAppIdByTree(id, masterId, inheritPath, appIdSet, extMap);
            }
            if ("2".equals(appFlag)) {
                appIdSet.removeAll(extMap.keySet());
            }
            extMap.forEach((key, value) -> appIdSet.add(value[0]));
            return appIdSet;
        });
        return new ArrayList<String>(idSet);
    }

    public static void addAppIdByTree(String id, String masterId, String inheritPath, Set<String> appIdSet, Map<String, String[]> extMap) {
        if (!StringUtils.isEmpty((CharSequence)masterId)) {
            ActivitySchemeServiceHelper.findDeepestExtAndReplace(id, masterId, inheritPath, extMap);
        } else {
            appIdSet.add(id);
        }
    }

    public static void findDeepestExtAndReplace(String id, String masterId, String inheritPath, Map<String, String[]> extMap) {
        String[] ext = extMap.get(masterId);
        if (ext != null) {
            if (ext[1].length() < inheritPath.length()) {
                ext[0] = id;
                ext[1] = inheritPath;
            }
        } else {
            extMap.put(masterId, new String[]{id, inheritPath});
        }
    }
}

