/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.activity;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.util.WorkflowEventEnum;

public class WorkflowStatusEventServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(WorkflowStatusEventServiceHelper.class);

    public static void notifyClient(String entityNumber, WorkflowEventEnum type, Set<Long> activityInsIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityclientconf");
        DynamicObject item = serviceHelper.queryOne("cloud,queuename", new QFilter[]{new QFilter("bizobj.number", "=", (Object)entityNumber)});
        if (Objects.nonNull(item)) {
            String region = item.getDynamicObject("cloud").getString("number").toLowerCase(Locale.ROOT);
            String queue = item.getString("queuename").toLowerCase(Locale.ROOT);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("eventType", type.name());
            data.put("influencedInstanceIds", activityInsIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            WorkflowStatusEventServiceHelper.sendMQ(region, queue, data);
        } else {
            LOGGER.error("Can not find queue from activity client with bill: {}.", (Object)entityNumber);
        }
    }

    private static void sendMQ(String region, String queue, Map<String, Object> map) {
        try {
            HRProducerServiceHelper.publishDynamicQueue((String)region, (String)queue, map);
        }
        catch (Exception exception) {
            LOGGER.error("Can not send mq.", (Throwable)exception);
        }
    }
}

