/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.datarule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.HRCloudServiceHelper;

public class HRDataRuleServiceHelper {
    private static final int ENTITY_MAP_INITIALCAPACITY = 300;

    public static List<Map<String, String>> getBizCloud() {
        String localeid = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, al.fname ");
        sql.append(" from t_meta_bizcloud a ");
        sql.append(" inner join t_meta_bizcloud_l al ");
        sql.append(" on a.fid = al.fid ");
        sql.append(" where al.flocaleid = '").append(localeid).append("' ");
        sql.append(" and a.fvisible = '1' ");
        sql.append(" and a.fid in (").append(HRCloudServiceHelper.getAllHRAndSYSCloudIdInStr()).append(")");
        String cloudBlacklist = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (HRStringUtils.isNotEmpty((String)cloudBlacklist)) {
            sql.append(" and a.fid not in (").append(cloudBlacklist).append(") ");
        }
        sql.append(" and ( exists ( ");
        sql.append("   select 1 from t_meta_entitydesign e ");
        sql.append("   left join t_meta_bizunitrelform b ");
        sql.append("   on e.fid = b.fformid ");
        sql.append("   left join t_meta_bizapp c ");
        sql.append("   on b.fbizappid = c.fid  ");
        sql.append("   LEFT JOIN t_meta_mainentityinfo f  ");
        sql.append("   on f.fdentityid = b.fformid  ");
        sql.append("   where e.fmodeltype IN (");
        sql.append("'BillFormModel', 'BaseFormModel', 'QueryListModel'");
        sql.append(") ");
        sql.append("   and  c.fbizcloudid = a.fid ");
        sql.append("   and  c.fvisible = '1' ");
        sql.append("   and  e.fistemplate = '0' ) ");
        sql.append(" ) order by a.fseq asc");
        List bizCloudList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            ArrayList result = new ArrayList(10);
            while (rs.next()) {
                HashMap<String, String> bizCloudMap = new HashMap<String, String>(16);
                bizCloudMap.put("id", "1_split_" + rs.getString(1));
                bizCloudMap.put("name", rs.getString(2));
                result.add(bizCloudMap);
            }
            return result;
        });
        return bizCloudList;
    }

    public static Map<String, String> getBizObjectName(List<String> entityIds) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.fid,a.fdentityid, b.fname from t_meta_mainentityinfo a ");
        sql.append(" INNER JOIN t_meta_mainentityinfo_l b on (a.fid = b.fid and b.flocaleid = ?) ");
        sql.append(" where a.fdentityid in (");
        Object[] filters = new String[entityIds.size() + 1];
        filters[0] = RequestContext.get().getLang().name();
        for (int i = 0; i < entityIds.size(); ++i) {
            if (i == 0) {
                sql.append(" ? ");
            } else {
                sql.append(" ,? ");
            }
            filters[i + 1] = entityIds.get(i);
        }
        sql.append(") ");
        sql.append(" and a.fistemplate = '0'  ");
        sql.append(" and a.fmodeltype in (");
        sql.append("'BillFormModel', 'BaseFormModel', 'QueryListModel'");
        sql.append(") ");
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, rs -> {
            HashMap<String, String> result = new HashMap<String, String>(entityIds.size());
            while (rs.next()) {
                result.put(rs.getString("fdentityid"), rs.getString("fname"));
            }
            return result;
        });
    }

    public static Map<String, String> getBizObjectById(String entityId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.fid, b.fname from t_meta_mainentityinfo a ");
        sql.append(" INNER JOIN t_meta_mainentityinfo_l b on (a.fid = b.fid and b.flocaleid = ?) ");
        sql.append(" where a.fdentityid = ? ");
        sql.append(" and a.fistemplate = '0'  ");
        sql.append(" and a.fmodeltype in (");
        sql.append("'BillFormModel', 'BaseFormModel', 'QueryListModel'");
        sql.append(") ");
        Object[] filters = new String[]{RequestContext.get().getLang().name(), entityId};
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, rs -> {
            HashMap<String, String> result = new HashMap<String, String>(16);
            while (rs.next()) {
                result.put("number", rs.getString("fid"));
                result.put("name", rs.getString("fname"));
            }
            return result;
        });
    }

    public static List<String> findBizappExistsEntity(String bizCloudId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT A.FID, A.FMASTERID ");
        sql.append(" FROM T_META_BIZAPP A");
        sql.append(" WHERE A.FBIZCLOUDID = ?");
        sql.append(" AND a.fdeploystatus = '2' ");
        sql.append(" AND ( EXISTS (  ");
        sql.append("   SELECT 1 FROM T_META_ENTITYDESIGN E");
        sql.append("   LEFT JOIN T_META_BIZUNITRELFORM B  ");
        sql.append("   ON E.FID = B.FFORMID  ");
        sql.append("   LEFT JOIN t_meta_mainentityinfo f  ");
        sql.append("   on f.fdentityid = b.fformid  ");
        sql.append("   WHERE  B.FBIZAPPID = A.FID ");
        sql.append("   AND E.FMODELTYPE IN (");
        sql.append("'BillFormModel', 'BaseFormModel', 'QueryListModel'");
        sql.append(") ");
        sql.append("   AND e.FISTEMPLATE = '0' ) ");
        sql.append(" )");
        Object[] filters = new String[]{bizCloudId};
        Set idSet = (Set)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, rs -> {
            HashSet<String> ids = new HashSet<String>(300);
            while (rs.next()) {
                String id = rs.getString(1);
                String masterid = rs.getString(2);
                if (HRStringUtils.isNotEmpty((String)masterid)) {
                    ids.add(masterid);
                    continue;
                }
                ids.add(id);
            }
            return ids;
        });
        return new ArrayList<String>(idSet);
    }

    public static List<String> getAllExtAppId(String originalAppId) {
        StringBuilder sb = new StringBuilder("select fid from t_meta_bizapp where fmasterid = '").append(originalAppId).append('\'').append(" and fid <> '").append(originalAppId).append('\'');
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, rs -> {
            ArrayList<String> result = new ArrayList<String>(16);
            while (rs.next()) {
                result.add(rs.getString("fid"));
            }
            return result;
        });
    }

    public static List<String> getEntityNumByAppId(String appId) {
        StringBuilder sql = new StringBuilder("select a.fnumber from t_meta_entitydesign a left join t_meta_bizunitrelform b on a.fid = b.fformid where a.fistemplate = '0' and b.fbizappid in (?");
        List<String> allExtAppId = HRDataRuleServiceHelper.getAllExtAppId(appId);
        Object[] filters = new String[allExtAppId.size() + 1];
        for (int index = 0; index < allExtAppId.size() + 1; ++index) {
            if (index == 0) {
                filters[0] = appId;
                continue;
            }
            sql.append(" ,? ");
            filters[index] = allExtAppId.get(index - 1);
        }
        sql.append(" ) ");
        String appNumber = AppMetadataCache.getAppNumberById((String)appId);
        String entityNumBlacklist = RunModeServiceHelper.getEntityNumFromBlacklist((String)appNumber);
        if (HRStringUtils.isNotEmpty((String)entityNumBlacklist)) {
            sql.append(" and a.fnumber not in (").append(entityNumBlacklist).append(')');
        }
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, rs -> {
            ArrayList<String> result = new ArrayList<String>(300);
            while (rs.next()) {
                result.add(rs.getString("fnumber"));
            }
            return result;
        });
    }

    public static List<String> getEntityNumByCloudId(String cloudId) {
        String sql = "select a.fnumber from t_meta_entitydesign a  left join t_meta_bizunitrelform b on a.fid = b.fformid  left join t_meta_bizapp c on b.fbizappid = c.fid  where c.fbizcloudid = ?  and  c.fvisible = '1' and a.fistemplate = '0' ";
        String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
        if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
            sql = sql + " and c.fid not in (" + appBlacklist + ")";
        }
        Object[] filters = new String[]{cloudId};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])filters, rs -> {
            ArrayList<String> result = new ArrayList<String>(300);
            while (rs.next()) {
                result.add(rs.getString("fnumber"));
            }
            return result;
        });
    }
}

