/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.datarule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.HRCloudServiceHelper;
import kd.hr.hrcs.common.constants.datarule.DataRuleConstants;

public class HRDataRuleTreeSearchServiceHelper {
    public static void reBuildTreeBySearchKey(TreeView treeView, String searchText) {
        treeView.deleteAllNodes();
        List<Map<String, String>> entitys = HRDataRuleTreeSearchServiceHelper.getEntitysBySearchKey(searchText);
        Set<String> appIds = entitys.stream().map(entity -> (String)entity.get("appId")).collect(Collectors.toSet());
        List<Map<String, String>> apps = HRDataRuleTreeSearchServiceHelper.getAppsByIds(appIds);
        Set<String> cloudIds = apps.stream().map(app -> (String)app.get("cloudId")).collect(Collectors.toSet());
        List<Map<String, String>> clouds = HRDataRuleTreeSearchServiceHelper.getCloudsByIds(cloudIds);
        HRDataRuleTreeSearchServiceHelper.sortCloudNodes(clouds);
        HRDataRuleTreeSearchServiceHelper.addTreeNodeByLists(treeView, clouds, apps, entitys);
    }

    private static void sortCloudNodes(List<Map<String, String>> bizCloudNodeList) {
        final List<String> orderedCloudIds = HRCloudServiceHelper.getAllHRPermCloudOrderByAsc();
        Collections.sort(bizCloudNodeList, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                int index1 = orderedCloudIds.indexOf(o1.get("id"));
                int index2 = orderedCloudIds.indexOf(o2.get("id"));
                index1 = index1 == -1 ? Integer.MAX_VALUE : index1;
                index2 = index2 == -1 ? Integer.MAX_VALUE : index2;
                return index1 - index2;
            }
        });
    }

    private static void addTreeNodeByLists(TreeView treeView, List<Map<String, String>> clouds, List<Map<String, String>> apps, List<Map<String, String>> entitys) {
        TreeNode node;
        String parentId;
        String id;
        TreeNode rootNode = HRDataRuleTreeSearchServiceHelper.buildRootNode();
        treeView.addNode(rootNode);
        if (CollectionUtils.isEmpty(clouds)) {
            return;
        }
        Set cloudIdSet = clouds.stream().map(cloud -> (String)cloud.get("id")).collect(Collectors.toSet());
        apps = apps.stream().filter(app -> cloudIdSet.contains(app.get("cloudId"))).collect(Collectors.toList());
        Set appIdSet = apps.stream().map(app -> (String)app.get("id")).collect(Collectors.toSet());
        entitys = entitys.stream().filter(entity -> appIdSet.contains(entity.get("appId"))).collect(Collectors.toList());
        ArrayList childNodeList = Lists.newArrayListWithExpectedSize((int)clouds.size());
        for (Map<String, String> cloud2 : clouds) {
            id = "1_split_" + cloud2.get("id");
            TreeNode node2 = new TreeNode("1010", id, cloud2.get("name"), true);
            node2.setIsOpened(true);
            childNodeList.add(node2);
        }
        for (Map<String, String> app2 : apps) {
            id = "2_split_" + app2.get("id");
            parentId = "1_split_" + app2.get("cloudId");
            node = new TreeNode(parentId, id, app2.get("name"), true);
            node.setIsOpened(true);
            childNodeList.add(node);
        }
        for (Map<String, String> entity2 : entitys) {
            id = "3_split_" + entity2.get("id");
            parentId = "2_split_" + entity2.get("appId");
            node = new TreeNode(parentId, id, entity2.get("name"), false);
            childNodeList.add(node);
        }
        treeView.addNodes((List)childNodeList);
    }

    public static TreeNode buildRootNode() {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8", (String)"HRDataRuleTreeSearchServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "1010", rootName, true);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    private static List<Map<String, String>> getEntitysBySearchKey(String searchText) {
        Set blackEntityIds = RunModeServiceHelper.getAllEntityBlacklist().keySet();
        DynamicObjectCollection entityDynoColl = QueryServiceHelper.query((String)"bos_entityinfo", (String)"dentityid,name,bizappid", (QFilter[])new QFilter[]{new QFilter("name", "like", (Object)("%" + searchText + "%")), new QFilter("istemplate", "like", (Object)"0"), new QFilter("id", "not in", blackEntityIds), new QFilter("modeltype", "in", (Object)DataRuleConstants.Public.ENTITY_MODEL_TYPE_LIST)});
        Set apps = entityDynoColl.stream().map(dyno -> dyno.getString("bizappid")).collect(Collectors.toSet());
        DynamicObjectCollection appDynoColl = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", apps)});
        HashMap extAppMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject appDyno : appDynoColl) {
            String masterId = appDyno.getString("masterid");
            if (!HRStringUtils.isNotEmpty((String)masterId)) continue;
            extAppMap.put(appDyno.getString("id"), masterId);
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        for (DynamicObject entityDyno : entityDynoColl) {
            HashMap entityMap = Maps.newHashMapWithExpectedSize((int)3);
            entityMap.put("id", entityDyno.getString("dentityid"));
            entityMap.put("name", entityDyno.getString("name"));
            String appId = entityDyno.getString("bizappid");
            entityMap.put("appId", extAppMap.getOrDefault(appId, appId));
            result.add(entityMap);
        }
        return result;
    }

    private static List<Map<String, String>> getAppsByIds(Set<String> appIds) {
        Set blackApps = RunModeServiceHelper.getAppBlacklist().keySet();
        DynamicObjectCollection appColl = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,bizcloud.id", (QFilter[])new QFilter[]{new QFilter("id", "in", appIds), new QFilter("id", "not in", blackApps), new QFilter("deploystatus", "=", (Object)"2")});
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        String localeId = RequestContext.get().getLang().name();
        for (DynamicObject appDyno : appColl) {
            HashMap appMap = Maps.newHashMapWithExpectedSize((int)3);
            String appId = appDyno.getString("id");
            appMap.put("id", appId);
            appMap.put("cloudId", appDyno.getString("bizcloud.id"));
            String name = (String)AppMetadataCache.getAppInfo((String)appId).getName().get((Object)localeId);
            appMap.put("name", name);
            result.add(appMap);
        }
        return result;
    }

    private static List<Map<String, String>> getCloudsByIds(Set<String> cloudIds) {
        String cloudIdStr = HRDataRuleTreeSearchServiceHelper.list2JoinStr(cloudIds);
        String hrCloudStr = HRCloudServiceHelper.getAllHRAndSYSCloudIdInStr();
        String sql = "select a.fid,b.fname from t_meta_bizcloud a  left join t_meta_bizcloud_l b on (a.fid=b.fid and b.flocaleid=?)  where a.fid in (" + cloudIdStr + ") and a.fid in (" + hrCloudStr + ") and a.fvisible='1' ";
        String cloudBlacklist = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (HRStringUtils.isNotEmpty((String)cloudBlacklist)) {
            sql = sql + " and a.fid not in (" + cloudBlacklist + ")";
        }
        String langStr = RequestContext.get().getLang().name();
        Object[] params = new String[]{langStr};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            ArrayList<HashMap> result = new ArrayList<HashMap>(16);
            while (rs.next()) {
                HashMap cloudMap = Maps.newHashMapWithExpectedSize((int)3);
                cloudMap.put("id", rs.getString("fid"));
                cloudMap.put("name", rs.getString("fname"));
                result.add(cloudMap);
            }
            return result;
        });
    }

    private static String list2JoinStr(Collection<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "''";
        }
        return list.stream().map(str -> "'" + str + "'").collect(Collectors.joining(", "));
    }
}

