/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.econtract;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.util.AesCryptUtil;
import kd.hr.hrcs.common.utils.EContractUtil;
import kd.hr.hrcs.common.utils.HRHttpClientUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.conn.ConnectTimeoutException;

public class HRCloudApiReqServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRCloudApiReqServiceHelper.class);
    private String kdAppid;
    private String key;

    public HRCloudApiReqServiceHelper(String kdAppid, String key) {
        this.kdAppid = kdAppid;
        this.key = key;
    }

    public String getKdAppid() {
        return this.kdAppid;
    }

    public void setKdAppid(String kdAppid) {
        this.kdAppid = kdAppid;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Map<String, Object> doPostByMultipart(String api, Map<String, Object> entityMap, InputStream ins, String fileName) {
        String nonce = RandomStringUtils.random((int)32, (boolean)true, (boolean)true);
        String url = this.getReqParam(api, nonce);
        Map<String, Object> signature = this.getSignature(nonce, entityMap);
        ArrayList<HttpClientUtils.FormDataEntity> formDatas = new ArrayList<HttpClientUtils.FormDataEntity>(16);
        for (Map.Entry<String, Object> entry : signature.entrySet()) {
            HttpClientUtils.FormDataEntity formDataEntity = new HttpClientUtils.FormDataEntity(entry.getKey(), (String)entry.getValue());
            formDatas.add(formDataEntity);
        }
        if (ins != null && !StringUtils.isEmpty((String)fileName)) {
            HttpClientUtils.FormDataEntity formDataEntity = new HttpClientUtils.FormDataEntity("file", ins, fileName);
            formDatas.add(formDataEntity);
        }
        try {
            String resp = HRHttpClientUtils.postFormData((String)url, Collections.emptyMap(), formDatas, (int)3000, (int)60000);
            return (Map)SerializationUtils.fromJsonString((String)resp, HashMap.class);
        }
        catch (Exception e) {
            LOGGER.error("url={},e={}", (Object)url, (Object)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public Map<String, Object> doGet(String api, Map<String, Object> entityMap) {
        String nonce = RandomStringUtils.random((int)32, (boolean)true, (boolean)true);
        StringBuilder urlSb = new StringBuilder();
        urlSb.append(this.getReqParam(api, nonce));
        Map<String, Object> signature = this.getSignature(nonce, entityMap);
        urlSb.append('&');
        urlSb.append("sign");
        urlSb.append('=');
        urlSb.append(signature.get("sign"));
        try {
            String resp = HRHttpClientUtils.get((String)urlSb.toString());
            return (Map)SerializationUtils.fromJsonString((String)resp, HashMap.class);
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            throw new KDBizException(new ErrorCode("1119", ResManager.loadKDString((String)"\u8bbf\u95ee\u7535\u5b50\u7b7e\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"HRHttpClientUtils_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])), new Object[]{ResManager.loadKDString((String)"\u8bbf\u95ee\u7535\u5b50\u7b7e\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"HRHttpClientUtils_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])});
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public Map<String, Object> doPost(String api, Map<String, Object> entityMap) {
        HashMap<String, String> headerMap = new HashMap<String, String>(8);
        headerMap.put("Content-Type", "application/json");
        headerMap.put("charset", "utf-8");
        String nonce = RandomStringUtils.random((int)32, (boolean)true, (boolean)true);
        String url = this.getReqParam(api, nonce);
        Map<String, Object> signature = this.getSignature(nonce, entityMap);
        try {
            String resp = HRHttpClientUtils.postAppJson((String)url, headerMap, signature);
            return (Map)SerializationUtils.fromJsonString((String)resp, Map.class);
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            throw new KDBizException(new ErrorCode("1119", ResManager.loadKDString((String)"\u8bbf\u95ee\u7535\u5b50\u7b7e\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"HRHttpClientUtils_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])), new Object[]{ResManager.loadKDString((String)"\u8bbf\u95ee\u7535\u5b50\u7b7e\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"HRHttpClientUtils_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])});
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String getReqParam(String api, String nonce) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("kdAppId", this.getKdAppid());
        param.put("nonce", nonce);
        param.put("signType", "AES");
        return this.initUriPathParams(api, param);
    }

    private String initUriPathParams(String api, Map<String, String> map) {
        String kdContractUrl = EContractUtil.getKdContractUrl();
        if (HRStringUtils.isEmpty((String)kdContractUrl)) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u57df\u540d\u201c%1$s\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HRCloudApiReqServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "kdcontract.url"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(kdContractUrl);
        builder.append(api);
        builder.append('?');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.append(String.format(Locale.ROOT, "%s=%s&", entry.getKey(), entry.getValue()));
        }
        if (map.size() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private Map<String, Object> getSignature(String nonce, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> biz = new HashMap<String, Object>();
        biz.put("nonce", nonce);
        biz.put("version", EContractUtil.getKdContractVersion());
        biz.put("data", data);
        result.put("sign", AesCryptUtil.encryptBase64(this.getKey(), SerializationUtils.toJsonString(biz)));
        return result;
    }
}

