/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.econtract;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.common.econtract.HRWordUtils;
import kd.hr.hbp.common.model.econtract.CheckVariableResp;
import kd.hr.hbp.common.model.econtract.KeyWordMappingEntryParam;
import kd.hr.hbp.common.model.econtract.KeyWordMappingParam;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.constants.econtract.EContractConstant;
import kd.hr.hrcs.common.constants.econtract.TreeMethodEnum;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.econtract.EContTreeNode;
import kd.hr.hrcs.common.model.econtract.EsignUpgradTempVo;
import kd.hr.hrcs.common.util.EntityFieldTreeUtil;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class KeywordMappingServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(KeywordMappingServiceHelper.class);
    private static Map<String, String> longNameCach = Maps.newHashMapWithExpectedSize((int)16);

    public static int deleteKeywordMapping(String formNumber, Object bizTemplateId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        QFilter formNumberFilter = KeywordMappingServiceHelper.getFormFilter(formNumber, bizTemplateId);
        int deleteRow = serviceHelper.deleteByFilter(new QFilter[]{formNumberFilter});
        return deleteRow;
    }

    public static DynamicObject selectKeywordMapping(String formNumber, Object bizTemplateId) {
        String selectField = "id,entryentity.entityfield,entryentity.entitynumber,entryentity.wordfield,contempid,iscustomize";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        QFilter formNumberFilter = KeywordMappingServiceHelper.getFormFilter(formNumber, bizTemplateId);
        DynamicObject dynamicObject = serviceHelper.queryOne(selectField, formNumberFilter);
        return dynamicObject;
    }

    public static DynamicObject selectKeywordMappingWithCondition(String formNumber, Object bizTemplateId) {
        String selectField = "id,entryentity.entityfield,entryentity.entitynumber,entryentity.wordfield,contempid,entryentity.relateentityid,entryentity.filtercondition,entryentity.iscustomize,entryentity.customizekey,entryentity.variableid,entryentity.multlang";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        QFilter formNumberFilter = KeywordMappingServiceHelper.getFormFilter(formNumber, bizTemplateId);
        DynamicObject dynamicObject = serviceHelper.queryOne(selectField, formNumberFilter);
        return dynamicObject;
    }

    public static DynamicObject loadKeywordMapping(String formNumber, Object bizTemplateId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        QFilter formNumberFilter = KeywordMappingServiceHelper.getFormFilter(formNumber, bizTemplateId);
        DynamicObject dynamicObject = serviceHelper.loadDynamicObject(formNumberFilter);
        return dynamicObject;
    }

    public static DynamicObject loadRelateEntity(String formNumber, Object bizTemplateId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_relateentity");
        QFilter formNumberFilter = KeywordMappingServiceHelper.getMainFormFilter(formNumber, bizTemplateId);
        DynamicObject dynamicObject = serviceHelper.loadDynamicObject(formNumberFilter);
        return dynamicObject;
    }

    public static DynamicObject loadRelateEntityByContmepId(Object bizTemplateId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_relateentity");
        QFilter formNumberFilter = new QFilter("contempid", "=", bizTemplateId);
        DynamicObject dynamicObject = serviceHelper.loadDynamicObject(formNumberFilter);
        return dynamicObject;
    }

    public static DynamicObject loadKeywordMappingDyById(Object id) {
        DynamicObject dy = null;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_keywordmapping");
        dy = helper.loadSingle(id);
        return dy;
    }

    public static DynamicObject queryId(String formNumber, Object bizTemplateId) {
        DynamicObject dy = null;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_keywordmapping");
        QFilter formNumberFilter = KeywordMappingServiceHelper.getFormFilter(formNumber, bizTemplateId);
        dy = helper.queryOriginalOne("id", formNumberFilter);
        return dy;
    }

    public static Map<String, String> getMapFromKeywordMapping(DynamicObjectCollection dyColl) {
        HashMap fieldEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : dyColl) {
            String entityNumber = dy.getString("entitynumber");
            String entityField = dy.getString("entityfield");
            if (fieldEntityMap.size() == 0) {
                fieldEntityMap.put(entityNumber, entityField);
                continue;
            }
            for (Map.Entry entry : fieldEntityMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (HRStringUtils.equals((String)entityNumber, (String)key)) {
                    value = value + "," + entityField;
                    fieldEntityMap.put(key, value);
                    continue;
                }
                if (fieldEntityMap.containsKey(key)) continue;
                fieldEntityMap.put(entityNumber, entityField);
            }
        }
        return fieldEntityMap;
    }

    public static void saveOne(DynamicObject dy) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_keywordmapping");
        helper.saveOne(dy);
    }

    public static void update(DynamicObject dy) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_keywordmapping");
        helper.update(new DynamicObject[]{dy});
    }

    public static DynamicObjectCollection compareKeyword(Set<String> newFieldSet, DynamicObjectCollection entityColl, boolean isCopy) {
        DynamicObjectCollection returnColl;
        block8: {
            block7: {
                returnColl = new DynamicObjectCollection();
                if (!CollectionUtils.isEmpty(newFieldSet)) break block7;
                if (!isCopy) {
                    returnColl.addAll((Collection)entityColl);
                } else {
                    long[] newEntrtIds = DBServiceHelper.genLongIds((String)"hrcs_keymappingentry", (int)entityColl.size());
                    int i = 0;
                    for (DynamicObject dy : entityColl) {
                        DynamicObject newDy = new DynamicObject(dy.getDynamicObjectType());
                        HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newDy);
                        newDy.set("id", (Object)newEntrtIds[i]);
                        returnColl.add((Object)newDy);
                        ++i;
                    }
                }
                break block8;
            }
            long[] newEntrtIds = DBServiceHelper.genLongIds((String)"hrcs_keymappingentry", (int)newFieldSet.size());
            int i = 0;
            for (DynamicObject dy : entityColl) {
                String wordField = dy.getString("wordfield");
                if (!newFieldSet.contains(wordField)) continue;
                if (isCopy) {
                    DynamicObject newDy = new DynamicObject(dy.getDynamicObjectType());
                    HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newDy);
                    newDy.set("id", (Object)newEntrtIds[i]);
                    returnColl.add((Object)newDy);
                } else {
                    returnColl.add((Object)dy);
                }
                ++i;
                newFieldSet.remove(wordField);
            }
            if (newFieldSet.size() <= 0) break block8;
            int j = 0;
            for (String addField : newFieldSet) {
                DynamicObject dy = new DynamicObject(entityColl.getDynamicObjectType());
                dy.set("id", (Object)newEntrtIds[i + j]);
                dy.set("wordfield", (Object)addField);
                returnColl.add((Object)dy);
                ++j;
            }
        }
        return returnColl;
    }

    private static QFilter getFormFilter(String formNumber, Object bizTemplateId) {
        QFilter formNumberFilter = new QFilter("formnumber", "=", (Object)formNumber);
        formNumberFilter.and("contempid", "=", bizTemplateId);
        return formNumberFilter;
    }

    private static QFilter getMainFormFilter(String formNumber, Object bizTemplateId) {
        QFilter formNumberFilter = new QFilter("mainentity.number", "=", (Object)formNumber);
        formNumberFilter.and("contempid", "=", bizTemplateId);
        return formNumberFilter;
    }

    public static DynamicObject queryKeyWordMapping(String formNumber, Long contempid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        QFilter qFilter = new QFilter("formnumber", "=", (Object)formNumber);
        return serviceHelper.queryOne("entryentity,entryentity.entitynumber,entryentity.wordfield", new QFilter[]{qFilter, new QFilter("contempid", "=", (Object)contempid)});
    }

    public static int deleteRelateEntityMapping(Long contempDyId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_relateentity");
        int deleteRow = serviceHelper.deleteByFilter(new QFilter[]{new QFilter("contempid", "=", (Object)contempDyId)});
        return deleteRow;
    }

    public static DynamicObject getTplVariableConfig(Object pk) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        return serviceHelper.queryOne(pk);
    }

    public static HashMap<Long, DynamicObject> getAllTplVariableConfigMap() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        DynamicObject[] query = serviceHelper.query("isentry,entrynumber,sonentity,parentid", new QFilter[0]);
        HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : query) {
            objectObjectHashMap.put((Long)dynamicObject.getPkValue(), dynamicObject);
        }
        return objectObjectHashMap;
    }

    public static DynamicObject getTplVariableMainEntity(String formNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        return serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("mainentity", "=", (Object)formNumber), new QFilter("parentid", "=", (Object)0L)});
    }

    public static DynamicObject getTplVariableConfigSimple(String field, Object pk) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        return serviceHelper.queryOne(field, pk);
    }

    public static DynamicObject getEntityobject(String number) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbp_entityobject");
        return serviceHelper.queryOne((Object)number);
    }

    public static QFilter convertJsonToQFilter(String entityId, String dataRuleJson) {
        if (HRStringUtils.isEmpty((String)dataRuleJson)) {
            return null;
        }
        return HRPermCommonUtil.getQFilterFromFilterCondition((String)entityId, (String)dataRuleJson);
    }

    public static EntityMetadata getRuntimeMetaData(String entityId) {
        long l1 = System.currentTimeMillis();
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        long l2 = System.currentTimeMillis();
        LOGGER.info("HisCommonFilterService.getRuntimeMetaData excute time " + (l2 - l1));
        return metadata;
    }

    public static DynamicObject[] getTplvariableConfigList() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        return serviceHelper.query("sonentityalias", new QFilter[0]);
    }

    public static DynamicObject[] findEntityByParentId(long parentId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        return serviceHelper.query("parentid,isentry,entryname,entrynumber,sonentity,rule,entryentity", new QFilter[]{new QFilter("parentid", "=", (Object)parentId)});
    }

    public static void deleteEntityById(ArrayList<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        serviceHelper.delete((Object[])ids.toArray(new Long[ids.size()]));
    }

    public static void initEntityTree(TreeNode focusNode, IFormView view, String mainEntity, String mainEntityName, String treeNodeClick) {
        if (HRStringUtils.equals((String)"1", (String)treeNodeClick)) {
            return;
        }
        TreeView tv = (TreeView)view.getControl("treeviewap");
        tv.deleteAllNodes();
        ArrayList treeNodeInfos = Lists.newArrayListWithCapacity((int)16);
        TreeNode root = new TreeNode("0", mainEntity, mainEntityName);
        String[] treeNodeInfo = new String[]{root.getText(), root.getId(), root.getParentid()};
        treeNodeInfos.add(treeNodeInfo);
        tv.expand(root.getId());
        KeywordMappingServiceHelper.constractEntityTree(root, mainEntity, treeNodeInfos);
        tv.addNode(root);
        root.setIsOpened(true);
        tv.focusNode(focusNode);
        HashMap treeData = Maps.newHashMapWithExpectedSize((int)16);
        EContTreeNode eContTreeNode = KeywordMappingServiceHelper.cachTreeNodeJson(root);
        treeData.put("method", TreeMethodEnum.INIT_TREE);
        treeData.put("treeNodes", eContTreeNode);
        treeData.put("entityMappingPage", true);
        treeData.put("timestamp", System.currentTimeMillis());
        treeData.put("focusNodeId", focusNode.getId());
        CustomControl fieldTreeControl = (CustomControl)view.getControl("fieldmptreeap");
        if (!HRStringUtils.equals((String)"1", (String)treeNodeClick)) {
            fieldTreeControl.setData((Object)SerializationUtils.toJsonString((Object)treeData));
        }
        view.getPageCache().put("treeNodeInfos", SerializationUtils.toJsonString((Object)root));
    }

    public static EContTreeNode cachTreeNodeJson(TreeNode root) {
        EContTreeNode eContTreeNode = new EContTreeNode();
        eContTreeNode.setKey(root.getId());
        eContTreeNode.setTitle(root.getText());
        eContTreeNode.setHasConfigFilter("0");
        List children = root.getChildren();
        KeywordMappingServiceHelper.getTreeNodeInfoJson(children, eContTreeNode);
        return eContTreeNode;
    }

    private static void getTreeNodeInfoJson(List<TreeNode> children, EContTreeNode parentTreeNode) {
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        ArrayList childrenList = Lists.newArrayListWithCapacity((int)16);
        for (TreeNode child : children) {
            EContTreeNode eContTreeNode = new EContTreeNode();
            DynamicObject tplVariableConfig = KeywordMappingServiceHelper.getTplVariableConfig(child.getId());
            String rule = tplVariableConfig.getString("rule");
            if (HRStringUtils.isNotEmpty((String)rule)) {
                eContTreeNode.setHasConfigFilter("1");
            } else {
                eContTreeNode.setHasConfigFilter("0");
            }
            eContTreeNode.setKey(child.getId());
            eContTreeNode.setTitle(child.getText());
            eContTreeNode.setParentId(parentTreeNode.getKey());
            childrenList.add(eContTreeNode);
            KeywordMappingServiceHelper.getTreeNodeInfoJson(child.getChildren(), eContTreeNode);
        }
        parentTreeNode.setChildren((List)childrenList);
    }

    public static void constractEntityTree(TreeNode parentNode, String parentId, List<String[]> treeNodeInfos) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        DynamicObject[] query = serviceHelper.query("sonentityalias,sonentity,entryname", new QFilter[]{new QFilter("parentid", "=", (Object)Long.valueOf(parentId))}, "createtime asc");
        Arrays.stream(query).forEach(entityMapping -> {
            DynamicObject sonEntity = (DynamicObject)entityMapping.get("sonentity");
            String name = "";
            Object pkValue = entityMapping.getPkValue();
            name = null == sonEntity ? entityMapping.getString("entryname") : sonEntity.getString("name");
            String alias = entityMapping.getString("sonentityalias");
            TreeNode sonNode = new TreeNode(parentNode.getId(), pkValue.toString(), HRStringUtils.isEmpty((String)alias) ? name : alias);
            String[] treeNodeInfo = new String[]{sonNode.getText(), sonNode.getId(), sonNode.getParentid()};
            treeNodeInfos.add(treeNodeInfo);
            sonNode.setIsOpened(Boolean.TRUE.booleanValue());
            parentNode.addChild(sonNode);
            KeywordMappingServiceHelper.constractEntityTree(sonNode, pkValue.toString(), treeNodeInfos);
        });
    }

    public static void constractEntityTreeForShow(TreeNode parentNode, String parentId, Map<String, EContTreeNode> treeNodeInfos) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        DynamicObject[] query = serviceHelper.query("sonentityalias,sonentity,entryname,parententity,isentry,parententity,entrynumber", new QFilter[]{new QFilter("parentid", "=", (Object)Long.valueOf(parentId))}, "createtime asc");
        Arrays.stream(query).forEach(entityMapping -> {
            DynamicObject sonEntity = (DynamicObject)entityMapping.get("sonentity");
            String name = "";
            String entityNum = "";
            Object pkValue = entityMapping.getPkValue();
            if (null == sonEntity) {
                name = entityMapping.getString("entryname");
            } else {
                name = sonEntity.getString("name");
                entityNum = sonEntity.getString("number");
            }
            String alias = entityMapping.getString("sonentityalias");
            TreeNode sonNode = new TreeNode(parentNode.getId(), pkValue.toString(), HRStringUtils.isEmpty((String)alias) ? name : alias, (Object)entityNum);
            DynamicObject parentEntity = (DynamicObject)entityMapping.get("parententity");
            String parentEntityNum = parentEntity == null ? "" : parentEntity.getString("number");
            EContTreeNode eContTreeNode = new EContTreeNode(sonNode.getId(), sonNode.getText(), entityNum, sonNode.getParentid(), parentEntityNum, entityMapping.getString("isentry"), entityMapping.getString("entrynumber"));
            treeNodeInfos.put(sonNode.getId(), eContTreeNode);
            sonNode.setIsOpened(Boolean.TRUE.booleanValue());
            parentNode.addChild(sonNode);
            KeywordMappingServiceHelper.constractEntityTreeForShow(sonNode, pkValue.toString(), treeNodeInfos);
        });
    }

    public static void constractEntityTreeForCustom(EContTreeNode parentNode, String parentId, Map<String, EContTreeNode> treeNodeInfos) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        DynamicObject[] query = serviceHelper.query("sonentityalias,sonentity,entryname,parententity,isentry,parententity,entrynumber", new QFilter[]{new QFilter("parentid", "=", (Object)Long.valueOf(parentId))}, "createtime asc");
        ArrayList currentNodes = Lists.newArrayListWithCapacity((int)16);
        Arrays.stream(query).forEach(entityMapping -> {
            DynamicObject sonEntity = (DynamicObject)entityMapping.get("sonentity");
            String name = "";
            String entityNum = "";
            String currentIdPkValue = entityMapping.getPkValue().toString();
            if (null == sonEntity) {
                name = entityMapping.getString("entryname");
            } else {
                name = sonEntity.getString("name");
                entityNum = sonEntity.getString("number");
            }
            String alias = entityMapping.getString("sonentityalias");
            String text = HRStringUtils.isEmpty((String)alias) ? name : alias;
            DynamicObject parentEntity = (DynamicObject)entityMapping.get("parententity");
            String parentEntityNum = parentEntity == null ? "" : parentEntity.getString("number");
            EContTreeNode eContTreeNode = new EContTreeNode(currentIdPkValue, text, entityNum, parentNode.getKey(), parentEntityNum, entityMapping.getString("isentry"), entityMapping.getString("entrynumber"));
            treeNodeInfos.put(currentIdPkValue, eContTreeNode);
            currentNodes.add(eContTreeNode);
            KeywordMappingServiceHelper.constractEntityTreeForCustom(eContTreeNode, currentIdPkValue, treeNodeInfos);
        });
        if (!currentNodes.isEmpty()) {
            parentNode.setChildren((List)currentNodes);
        }
    }

    public static void upgradTplVariableData() {
        try (TXHandle txHandle = TX.required();){
            HRBaseServiceHelper commonVariableService = new HRBaseServiceHelper("hrcs_commonvariable");
            DynamicObject[] query = commonVariableService.query(new QFilter[0]);
            if (query != null) {
                ScheduleService.getInstance().getObjectFactory().getScheduleDao().disableSchedule("3IMLZ3SVTIPR");
                return;
            }
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_relateentity");
            DynamicObject[] relateEntitys = baseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("upgrad", "!=", (Object)"1")});
            if (relateEntitys == null || relateEntitys.length == 0) {
                KeywordMappingServiceHelper.upgradRepeatData();
                ScheduleService.getInstance().getObjectFactory().getScheduleDao().disableSchedule("3IMLZ3SVTIPR");
                return;
            }
            DynamicObjectCollection tplVariableConfigs = new DynamicObjectCollection();
            for (DynamicObject relateEntity : relateEntitys) {
                Long contempid = (Long)relateEntity.get("contempid");
                DynamicObjectCollection entitymappingconfig = relateEntity.getDynamicObjectCollection("entitymappingconfig");
                KeywordMappingServiceHelper.getChildren((ArrayList<DynamicObject>)tplVariableConfigs, "hlcm_contractapplybase", entitymappingconfig, EContractConstant.ROOT_ID, contempid);
            }
            KeywordMappingServiceHelper.updateMainEntityFilterCondition();
            HRBaseServiceHelper tplvariableconfig = new HRBaseServiceHelper("hrcs_tplvariableconfig");
            tplvariableconfig.save(tplVariableConfigs);
            KeywordMappingServiceHelper.updateUpgradFlag(relateEntitys);
            KeywordMappingServiceHelper.upgradRepeatData();
            ScheduleService.getInstance().getObjectFactory().getScheduleDao().disableSchedule("3IMLZ3SVTIPR");
        }
    }

    private static void updateUpgradFlag(DynamicObject[] relateEntitys) {
        DynamicObject[] upgrads;
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_relateentity");
        for (DynamicObject relateEntity : relateEntitys) {
            relateEntity.set("upgrad", (Object)"1");
        }
        baseServiceHelper.update(relateEntitys);
        HRBaseServiceHelper keywordMapping = new HRBaseServiceHelper("hrcs_keywordmapping");
        for (DynamicObject upgrad : upgrads = keywordMapping.query("upgrad", new QFilter[0])) {
            upgrad.set("upgrad", (Object)"1");
        }
        keywordMapping.update(upgrads);
    }

    private static void getChildren(ArrayList<DynamicObject> tplVariableConfigs, String entityNumber, DynamicObjectCollection entitymappingconfig, Long parentId, Long contempid) {
        for (DynamicObject entityMapping : entitymappingconfig) {
            String parentNumber = entityMapping.getDynamicObject("parententity").getString("number");
            String sonNumber = entityMapping.getDynamicObject("entity").getString("number");
            if (!entityNumber.equals(parentNumber)) continue;
            DynamicObject dynamicObject = KeywordMappingServiceHelper.genTplDynamicObject(sonNumber, parentNumber);
            dynamicObject.set("parentid", (Object)parentId);
            KeywordMappingServiceHelper.getEntryentity(entityMapping, dynamicObject, parentNumber, sonNumber);
            KeywordMappingServiceHelper.updateKeyWordRelateId(contempid, sonNumber, (Long)dynamicObject.getPkValue());
            tplVariableConfigs.add(dynamicObject);
            List<DynamicObject> entryDynamicObject = KeywordMappingServiceHelper.getEntryDynamicObject(sonNumber, (Long)dynamicObject.getPkValue());
            if (!CollectionUtils.isEmpty(entryDynamicObject)) {
                KeywordMappingServiceHelper.getEntryentityEntry(entryDynamicObject);
                KeywordMappingServiceHelper.updateKeyWordEntryRelateId(entryDynamicObject, contempid, sonNumber);
                tplVariableConfigs.addAll(entryDynamicObject);
            }
            KeywordMappingServiceHelper.getChildren(tplVariableConfigs, sonNumber, entitymappingconfig, (Long)dynamicObject.getPkValue(), contempid);
        }
    }

    private static void updateMainEntityFilterCondition() {
        DynamicObject[] contempIds;
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        for (DynamicObject dynamicObject : contempIds = baseServiceHelper.query("entryentity.entitynumber,entryentity.relateentityid,entryentity.filtercondition", new QFilter[]{new QFilter("upgrad", "!=", (Object)"1")})) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryentity) {
                String keyWordEntityNumber = object.getString("entitynumber");
                if (!"hlcm_contractapplybase".equals(keyWordEntityNumber)) continue;
                object.set("relateentityid", (Object)EContractConstant.ROOT_ID);
                String filtercondition = object.getString("filtercondition");
                if (KeywordMappingServiceHelper.setFilterCondition(filtercondition, EContractConstant.ROOT_ID.toString(), object)) continue;
            }
        }
        baseServiceHelper.update(contempIds);
    }

    private static void updateKeyWordRelateId(Long contempid, String entityNumber, Long relateEntityId) {
        DynamicObject[] contempIds;
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        for (DynamicObject dynamicObject : contempIds = baseServiceHelper.query("entryentity.entitynumber,entryentity.relateentityid,entryentity.filtercondition", new QFilter[]{new QFilter("contempid", "=", (Object)contempid), new QFilter("upgrad", "!=", (Object)"1")})) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryentity) {
                String keyWordEntityNumber = object.getString("entitynumber");
                if (!entityNumber.equals(keyWordEntityNumber)) continue;
                object.set("relateentityid", (Object)relateEntityId);
                String filtercondition = object.getString("filtercondition");
                if (KeywordMappingServiceHelper.setFilterCondition(filtercondition, relateEntityId.toString(), object)) continue;
            }
        }
        baseServiceHelper.update(contempIds);
    }

    private static void updateKeyWordEntryRelateId(List<DynamicObject> entryDynamicObject, Long contempid, String entityNumber) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        DynamicObject[] contempIds = baseServiceHelper.query("entryentity.entitynumber,entryentity.relateentityid,entryentity.filtercondition,entryentity.entityfield", new QFilter[]{new QFilter("contempid", "=", (Object)contempid), new QFilter("upgrad", "!=", (Object)"1")});
        for (DynamicObject entry : entryDynamicObject) {
            String entryNumber = entry.getString("entrynumber");
            String[] split = entryNumber.split("\\.");
            for (DynamicObject dynamicObject : contempIds) {
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject object : entryentity) {
                    String keyWordEntityNumber = object.getString("entitynumber");
                    String entityfield = object.getString("entityfield");
                    String filtercondition = object.getString("filtercondition");
                    if (!entityNumber.equals(keyWordEntityNumber) || !entityfield.contains(split[1])) continue;
                    object.set("relateentityid", entry.getPkValue());
                    if (KeywordMappingServiceHelper.setFilterCondition(filtercondition, entry.getPkValue().toString(), object)) continue;
                }
            }
        }
        baseServiceHelper.update(contempIds);
    }

    private static boolean setFilterCondition(String filtercondition, String relateEntityId, DynamicObject object) {
        if (HRStringUtils.isNotEmpty((String)filtercondition)) {
            if (!filtercondition.startsWith("{\"filterRow")) {
                return false;
            }
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)filtercondition, FilterCondition.class);
            HashMap conditionMap = Maps.newHashMapWithExpectedSize((int)16);
            conditionMap.put(relateEntityId, fc);
            String newFiltercondition = SerializationUtils.toJsonString((Object)conditionMap);
            object.set("filtercondition", (Object)newFiltercondition);
        }
        return true;
    }

    private static boolean setFilterConditionNew(String filtercondition, String relateEntityId, DynamicObject object) {
        if (HRStringUtils.isNotEmpty((String)filtercondition)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)filtercondition, FilterCondition.class);
            HashMap conditionMap = Maps.newHashMapWithExpectedSize((int)16);
            conditionMap.put(relateEntityId, fc);
            String newFiltercondition = SerializationUtils.toJsonString((Object)conditionMap);
            object.set("filtercondition", (Object)newFiltercondition);
        }
        return true;
    }

    private static void getEntryentity(DynamicObject entityMapping, DynamicObject mainDy, String parentNumber, String sonNumber) {
        DynamicObjectCollection subentryentity = entityMapping.getDynamicObjectCollection("subentryentity");
        HRBaseServiceHelper tplvariableconfig = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        DynamicObjectCollection dynamicObjects = tplvariableconfig.generateEmptyEntryCollection(mainDy, "entryentity");
        for (DynamicObject dynamicObject : subentryentity) {
            String parentEntityField = dynamicObject.getString("parententityfield");
            String entityField = dynamicObject.getString("entityfield");
            DynamicObject entryEntity = tplvariableconfig.generateEmptyEntryDynamicObject("entryentity");
            entryEntity.set("parentfield", (Object)parentEntityField);
            entryEntity.set("sonfield", (Object)entityField);
            entryEntity.set("parentfieldname", (Object)EntityFieldTreeUtil.getDisplayNameContainsEntry((String)(parentNumber + "." + parentEntityField), (Boolean)Boolean.FALSE));
            entryEntity.set("sonfieldname", (Object)EntityFieldTreeUtil.getDisplayNameContainsEntry((String)(sonNumber + "." + entityField), (Boolean)Boolean.FALSE));
            entryEntity.set("fieldcondition", (Object)ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"TplVariableConfigPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            dynamicObjects.add((Object)entryEntity);
        }
    }

    private static void getEntryentityEntry(List<DynamicObject> entryDynamicObject) {
        HRBaseServiceHelper tplvariableconfig = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        for (DynamicObject dynamicObject : entryDynamicObject) {
            DynamicObjectCollection dynamicObjects = tplvariableconfig.generateEmptyEntryCollection(dynamicObject, "entryentity");
            DynamicObject entryEntity = tplvariableconfig.generateEmptyEntryDynamicObject("entryentity");
            entryEntity.set("parentfield", (Object)"id");
            entryEntity.set("sonfield", (Object)"id");
            entryEntity.set("parentfieldname", (Object)"id");
            entryEntity.set("sonfieldname", (Object)"id");
            entryEntity.set("fieldcondition", (Object)ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"TplVariableConfigPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            dynamicObjects.add((Object)entryEntity);
        }
    }

    private static List<DynamicObject> getEntryDynamicObject(String entityNumber, Long parentId) {
        ArrayList entrys = Lists.newArrayListWithCapacity((int)16);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof EntryProp)) continue;
            String alias = ((EntryProp)property).getDynamicCollectionItemPropertyType().getAlias();
            if (Objects.isNull(property.getDisplayName()) || HRStringUtils.isEmpty((String)alias) || Objects.isNull(dataEntityType.getDisplayName())) continue;
            DynamicObject dynamicObject = KeywordMappingServiceHelper.genTplEntryDynamicObject(entityNumber, dataEntityType.getDisplayName().getLocaleValue(), property.getDisplayName().getLocaleValue(), property.getName(), parentId);
            entrys.add(dynamicObject);
        }
        return entrys;
    }

    private static DynamicObject genTplDynamicObject(String entityNumber, String parentNumber) {
        HRBaseServiceHelper tplvariableconfig = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        long[] longIds = DBServiceHelper.genLongIds((String)"hrcs_tplvariableconfig", (int)1);
        DynamicObject dynamicObject = tplvariableconfig.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)longIds[0]);
        dynamicObject.set("parententity", (Object)parentNumber);
        dynamicObject.set("sonentity", (Object)entityNumber);
        dynamicObject.set("mainentity", (Object)"hlcm_contractapplybase");
        dynamicObject.set("createorg", (Object)KeywordMappingServiceHelper.getOrgRootId());
        dynamicObject.set("ctrlstrategy", (Object)"5");
        dynamicObject.set("isentry", (Object)"0");
        dynamicObject.set("status", (Object)"C");
        return dynamicObject;
    }

    private static DynamicObject genTplEntryDynamicObject(String parentNumber, String parentName, String entryName, String entryNumber, Long parentId) {
        HRBaseServiceHelper tplvariableconfig = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        DynamicObject dynamicObject = tplvariableconfig.generateEmptyDynamicObject();
        dynamicObject.set("parentid", (Object)parentId);
        dynamicObject.set("parententity", (Object)parentNumber);
        dynamicObject.set("mainentity", (Object)"hlcm_contractapplybase");
        dynamicObject.set("createorg", (Object)KeywordMappingServiceHelper.getOrgRootId());
        dynamicObject.set("ctrlstrategy", (Object)"5");
        dynamicObject.set("isentry", (Object)"1");
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("entrynumber", (Object)(parentNumber + "." + entryNumber));
        dynamicObject.set("entryname", (Object)(parentName + "." + entryName));
        return dynamicObject;
    }

    public static String getOrgRootId() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("11");
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return rootNode.getId();
    }

    public static String getRootId(String formNumber) {
        DynamicObject tplVariableMainEntity = KeywordMappingServiceHelper.getTplVariableMainEntity(formNumber);
        return tplVariableMainEntity.getPkValue().toString();
    }

    public static ArrayList<String> getEntityLongPath(long parentId, ArrayList<String> pathList, Map<Long, DynamicObject> tplVariableConfigMap) {
        if (parentId == 0L) {
            return pathList;
        }
        DynamicObject entityByParentId = tplVariableConfigMap.get(parentId);
        if (entityByParentId == null) {
            try {
                entityByParentId = KeywordMappingServiceHelper.getTplVariableConfig(parentId);
                if (entityByParentId == null) {
                    return pathList;
                }
            }
            catch (Exception exception) {
                LOGGER.error("getEntityLongPath error parentid={}", (Object)parentId);
            }
            return pathList;
        }
        String localeValue = longNameCach.get(parentId + Lang.get().toString());
        if (HRStringUtils.isEmpty((String)localeValue)) {
            String isEntry = entityByParentId.getString("isentry");
            if (HRStringUtils.equals((String)"1", (String)isEntry)) {
                String entryNumber = entityByParentId.getString("entrynumber");
                String[] split = entryNumber.split("\\.");
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)split[0]);
                LocaleString displayName = dataEntityType.getProperty(split[1]).getDisplayName();
                localeValue = displayName.size() == 0 ? dataEntityType.getProperty(split[1]).getName() : displayName.getLocaleValue();
                pathList.add(localeValue);
                longNameCach.put(parentId + Lang.get().toString(), localeValue);
            } else {
                pathList.add(entityByParentId.getDynamicObject("sonentity").getLocaleString("name").getLocaleValue());
                longNameCach.put(parentId + Lang.get().toString(), entityByParentId.getDynamicObject("sonentity").getLocaleString("name").getLocaleValue());
            }
        } else {
            pathList.add(localeValue);
        }
        KeywordMappingServiceHelper.getEntityLongPath(entityByParentId.getLong("parentid"), pathList, tplVariableConfigMap);
        return pathList;
    }

    public static String getdisplayEntityPath(long parentId, ArrayList<String> pathList, Map<Long, DynamicObject> tplVariableConfigMap) {
        if (CollectionUtils.isEmpty(tplVariableConfigMap)) {
            tplVariableConfigMap = KeywordMappingServiceHelper.getAllTplVariableConfigMap();
        }
        KeywordMappingServiceHelper.getEntityLongPath(parentId, pathList, tplVariableConfigMap);
        Collections.reverse(pathList);
        String join = String.join((CharSequence)".", pathList);
        return join;
    }

    public static DynamicObject getCommonVariable(Object pkvalue) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_commonvariable");
        return baseServiceHelper.queryOne(pkvalue);
    }

    public static List<Map<String, Object>> getFilterField(List<Map<String, Object>> fieldColumns, DynamicObject tplVariableConfig, String entryFlag) {
        if ("1".equals(entryFlag)) {
            String entryNumber = tplVariableConfig.getString("entrynumber");
            String[] split = entryNumber.split("\\.");
            Set allHRCloudId = HRCloudServiceHelper.getAllHRCloudId();
            List<Map<String, Object>> fieldList = fieldColumns.stream().filter(fieldMap -> {
                String entryEntity = (String)fieldMap.get("entryEntity");
                return HRStringUtils.equals((String)entryEntity, (String)split[1]);
            }).collect(Collectors.toList());
            return fieldList;
        }
        return null;
    }

    public static String buildFilterDesc(String msg, String entityNumber, String filterConditionAllMapStr, String relateEntityId) {
        if (StringUtils.isEmpty((CharSequence)filterConditionAllMapStr)) {
            return msg;
        }
        Map filterMapAll = (Map)SerializationUtils.fromJsonString((String)filterConditionAllMapStr, Map.class);
        Map filterMap = (Map)filterMapAll.get(relateEntityId);
        if (filterMap == null || filterMap.isEmpty()) {
            return msg;
        }
        String filterCondition = SerializationUtils.toJsonString((Object)filterMap);
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)filterCondition, FilterCondition.class);
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)fc.getFilterRow())) {
            return msg;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, fc);
        filterBuilder.buildFilter();
        String orgFilterDesc = filterBuilder.getFilterStringDesc().replaceAll("\\s+", " ");
        String filterMsg = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", (String)"KeywordMappingPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String localeFilterMsg = String.format(Locale.ROOT, filterMsg, orgFilterDesc);
        int useMsgIndex = localeFilterMsg.lastIndexOf(")") - 4;
        String useLocaleStr = localeFilterMsg.substring(0, useMsgIndex).replaceFirst("\\(", "");
        return msg + "\r\n" + useLocaleStr;
    }

    public static boolean judgeMultiLang(EntityMetadata metadata, String entityFiled) {
        String field = "";
        field = entityFiled.contains(".") ? entityFiled.substring(entityFiled.lastIndexOf(".") + 1) : entityFiled;
        if (metadata == null) {
            return false;
        }
        List entityItems = metadata.getItems();
        if (entityItems == null) {
            return false;
        }
        for (EntityItem entityItem : entityItems) {
            if (!HRStringUtils.equals((String)entityItem.getKey(), (String)field) || !(entityItem instanceof MuliLangTextField)) continue;
            return true;
        }
        return false;
    }

    public static void getPrePathList(String formNumber, String[] split, ArrayList<String> pathList) {
        if (formNumber.contains(".")) {
            DynamicProperty entryPropProperty;
            String[] entryStr = formNumber.split("\\.");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entryStr[0]);
            DynamicProperty property = dataEntityType.getProperty(entryStr[1]);
            if (!(property instanceof EntryProp)) {
                return;
            }
            DynamicObjectType entryProp = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            String localeValue = entryProp.getProperty(split[1]).getDisplayName().getLocaleValue();
            pathList.add(localeValue);
            if (split.length > 2 && (entryPropProperty = entryProp.getProperty(split[1])) instanceof BasedataProp) {
                DataEntityPropertyCollection sonBaseDataProps = ((BasedataProp)entryPropProperty).getComplexType().getProperties();
                String subLocaleValue = ((IDataEntityProperty)sonBaseDataProps.get((Object)split[2])).getDisplayName().getLocaleValue();
                pathList.add(subLocaleValue);
            }
        } else {
            DynamicProperty property;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formNumber);
            if (dataEntityType == null) {
                return;
            }
            if (dataEntityType.getProperty(split[0]) == null) {
                return;
            }
            String localeValue = dataEntityType.getProperty(split[0]).getDisplayName().getLocaleValue();
            pathList.add(localeValue);
            if (split.length > 1 && (property = dataEntityType.getProperty(split[0])) instanceof BasedataProp) {
                DataEntityPropertyCollection sonBaseDataProps = ((BasedataProp)property).getComplexType().getProperties();
                String subLocaleValue = ((IDataEntityProperty)sonBaseDataProps.get((Object)split[1])).getDisplayName().getLocaleValue();
                pathList.add(subLocaleValue);
            }
        }
    }

    public static KeyWordMappingParam matchingVariable(List<String> keywords, String mainEntityNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_commonvariable");
        KeyWordMappingParam mappingParam = new KeyWordMappingParam();
        DynamicObject[] query = serviceHelper.query("name,multilang", new QFilter[]{new QFilter("mainentity", "=", (Object)mainEntityNumber), new QFilter("enable", "=", (Object)"1")});
        ArrayList entryList = Lists.newArrayListWithCapacity((int)16);
        for (String word : keywords) {
            word = word.substring(word.indexOf("{") + 1, word.indexOf("}"));
            ArrayList matchResult = Lists.newArrayListWithCapacity((int)16);
            block1: for (DynamicObject dynamicObject : query) {
                ILocaleString name = dynamicObject.getLocaleString("name");
                String multilang = dynamicObject.getString("multilang");
                ArrayList langMatchResult = Lists.newArrayListWithCapacity((int)16);
                for (Map.Entry entry : name.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if ("GLang".equals(key) || !value.equals(word)) continue;
                    KeyWordMappingEntryParam mappingEntryParam = new KeyWordMappingEntryParam();
                    mappingEntryParam.setWordField("${" + word + "}");
                    mappingEntryParam.setCommonVarId((Long)dynamicObject.getPkValue());
                    if ("1".equals(multilang)) {
                        mappingEntryParam.setLang(key);
                    }
                    langMatchResult.add(mappingEntryParam);
                }
                if (langMatchResult.size() > 1) {
                    List langList = langMatchResult.stream().map(KeyWordMappingEntryParam::getLang).collect(Collectors.toList());
                    if (langList.contains("zh_CN")) {
                        for (KeyWordMappingEntryParam keyWordMappingEntryParam : langMatchResult) {
                            String lang = keyWordMappingEntryParam.getLang();
                            if (!"zh_CN".equals(lang)) continue;
                            matchResult.add(keyWordMappingEntryParam);
                            continue block1;
                        }
                        continue;
                    }
                    matchResult.add(langMatchResult.get(0));
                    continue;
                }
                if (langMatchResult.size() != 1) continue;
                matchResult.addAll(langMatchResult);
            }
            if (matchResult.size() != 1) {
                KeyWordMappingEntryParam mappingEntryParam = new KeyWordMappingEntryParam();
                mappingEntryParam.setWordField("${" + word + "}");
                entryList.add(mappingEntryParam);
                continue;
            }
            entryList.addAll(matchResult);
        }
        mappingParam.setEntryParam((List)entryList);
        return mappingParam;
    }

    public static CheckVariableResp keyWordCheck(String url, boolean isTempFile) {
        ArrayList errorList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList successList = Lists.newArrayListWithExpectedSize((int)10);
        CheckVariableResp checkVariableResp = new CheckVariableResp();
        try (XWPFDocument document = HRWordUtils.getXWPFDocumentFromUrl((String)url, (boolean)isTempFile);){
            if (Objects.isNull(document)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20docx\u683c\u5f0f\u6587\u4ef6\u3002", (String)"KeywordMappingPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            StringBuffer strFormWord = HRWordUtils.getStringFormWord((XWPFDocument)document);
            Set keywordSet = HRWordUtils.getAllKeywords((StringBuffer)strFormWord);
            checkVariableResp.setCheckResult(true);
            for (String wordField : keywordSet) {
                String isEnableKeyword = KeywordMappingServiceHelper.checkWordField(wordField, errorList);
                if (!"0".equals(isEnableKeyword)) continue;
                checkVariableResp.setCheckResult(false);
            }
            if (checkVariableResp.getCheckResult()) {
                successList.addAll(keywordSet);
                checkVariableResp.setSuccessWords((List)successList);
            } else {
                checkVariableResp.setErrorWords((List)errorList);
            }
        }
        catch (IOException exception) {
            LOGGER.error("read word file error", (Throwable)exception);
        }
        return checkVariableResp;
    }

    private static String checkWordField(String wordField, List<String> errorList) {
        String isEnableKeyword = "1";
        int endIndex = wordField.indexOf("}");
        if (endIndex == -1) {
            isEnableKeyword = "0";
            errorList.add(wordField);
        }
        return isEnableKeyword;
    }

    public static DynamicObject getCommonVarById(Object pkValue) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_commonvariable");
        DynamicObject dynamicObject = serviceHelper.queryOne(pkValue);
        return dynamicObject;
    }

    public static Map<Long, List<DynamicObject>> groupTplvariableByParentId() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        DynamicObject[] relateEntity = serviceHelper.loadDynamicObjectArray(new QFilter[0]);
        Map<Long, List<DynamicObject>> result = Arrays.stream(relateEntity).collect(Collectors.groupingBy(dy -> dy.getLong("parentid")));
        return result;
    }

    public static Map<Long, String> getEntityIdFilterConditionMap(DynamicObjectCollection keywordMappingDyColl) {
        HashMap resutlMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : keywordMappingDyColl) {
            if (!HRStringUtils.isNotEmpty((String)dynamicObject.getString("filtercondition"))) continue;
            resutlMap.put(dynamicObject.getLong("relateentityid"), dynamicObject.getString("filtercondition"));
        }
        return resutlMap;
    }

    public static void saveMainEntity(String mainEntity) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        DynamicObject tplVariableMainEntity = "hlcm_contracttemplate".equals(mainEntity) ? KeywordMappingServiceHelper.getTplVariableMainEntity("hlcm_contractapplybase") : KeywordMappingServiceHelper.getTplVariableMainEntity(mainEntity);
        if (tplVariableMainEntity == null) {
            DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
            dynamicObject.set("mainentity", (Object)mainEntity);
            dynamicObject.set("sonentity", (Object)mainEntity);
            dynamicObject.set("isentry", (Object)"0");
            dynamicObject.set("parentid", (Object)0);
            serviceHelper.saveOne(dynamicObject);
        }
    }

    public static void upgradRepeatData() {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        KeywordMappingServiceHelper.mergeTplConfigByParentId(0L, new ArrayList<EsignUpgradTempVo>(), 1, dataMap);
        HashMap replaceMap = Maps.newHashMapWithExpectedSize((int)16);
        KeywordMappingServiceHelper.distinctTplConfig(dataMap, replaceMap);
        if (CollectionUtils.isEmpty((Map)replaceMap)) {
            return;
        }
        KeywordMappingServiceHelper.replaceTempRelateId(replaceMap);
        KeywordMappingServiceHelper.generateNewTplConfigData(dataMap, replaceMap);
    }

    private static void replaceTempRelateId(HashMap<Long, List<Long>> replaceMap) {
        DynamicObject[] data;
        HRBaseServiceHelper keywordMapping = new HRBaseServiceHelper("hrcs_keywordmapping");
        for (DynamicObject dynamicObject : data = keywordMapping.loadDynamicObjectArray(new QFilter[0])) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryentity) {
                long relateentityid = object.getLong("relateentityid");
                for (Map.Entry<Long, List<Long>> entry : replaceMap.entrySet()) {
                    Long key = entry.getKey();
                    List<Long> value = entry.getValue();
                    if (!value.contains(relateentityid)) continue;
                    object.set("relateentityid", (Object)key);
                    String filtercondition = object.getString("filtercondition");
                    if (!HRStringUtils.isNotEmpty((String)filtercondition)) continue;
                    Map condMap = (Map)SerializationUtils.fromJsonString((String)filtercondition, Map.class);
                    HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
                    objectObjectHashMap.put(key.toString(), condMap.get(relateentityid + ""));
                    object.set("filtercondition", (Object)SerializationUtils.toJsonString((Object)objectObjectHashMap));
                }
            }
        }
        keywordMapping.update(data);
    }

    private static void replaceTempRelateIdNew(HashMap<Long, Long> replaceMap) {
        DynamicObject[] data;
        HRBaseServiceHelper keywordMapping = new HRBaseServiceHelper("hrcs_keywordmapping");
        for (DynamicObject dynamicObject : data = keywordMapping.loadDynamicObjectArray(new QFilter[0])) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryentity) {
                long relateentityid = object.getLong("relateentityid");
                if (!replaceMap.containsKey(relateentityid)) continue;
                object.set("relateentityid", (Object)replaceMap.get(relateentityid));
                String filtercondition = object.getString("filtercondition");
                if (!HRStringUtils.isNotEmpty((String)filtercondition)) continue;
                Map condMap = (Map)SerializationUtils.fromJsonString((String)filtercondition, Map.class);
                HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
                objectObjectHashMap.put(replaceMap.get(relateentityid).toString(), condMap.get(relateentityid + ""));
                object.set("filtercondition", (Object)SerializationUtils.toJsonString((Object)objectObjectHashMap));
            }
        }
        keywordMapping.update(data);
    }

    private static void generateNewTplConfigData(HashMap<String, List<EsignUpgradTempVo>> dataMap, HashMap<Long, List<Long>> replaceMap) {
        HashMap parentIdReplace = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        Integer i = 1;
        while (i <= dataMap.size()) {
            Iterator<Map.Entry<Long, List<Long>>> iterator;
            Object esignUpgradTempVos;
            if (i != 1) {
                esignUpgradTempVos = dataMap.get(i.toString());
                iterator = esignUpgradTempVos.iterator();
                while (iterator.hasNext()) {
                    EsignUpgradTempVo esignUpgradTempVo = (EsignUpgradTempVo)iterator.next();
                    String isEntry = esignUpgradTempVo.getIsEntry();
                    DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                    long[] longIds = DBServiceHelper.genLongIds((String)"hrcs_tplvariableconfig", (int)1);
                    dynamicObject.set("id", (Object)longIds[0]);
                    Long aLong = (Long)parentIdReplace.get(esignUpgradTempVo.getParentId());
                    dynamicObject.set("parentid", (Object)(aLong == null || aLong == 0L ? esignUpgradTempVo.getParentId() : aLong));
                    dynamicObject.set("parententity", (Object)esignUpgradTempVo.getParentNumber());
                    dynamicObject.set("sonentity", (Object)esignUpgradTempVo.getEntityNumber());
                    dynamicObject.set("mainentity", (Object)"hlcm_contractapplybase");
                    dynamicObject.set("createorg", (Object)KeywordMappingServiceHelper.getOrgRootId());
                    dynamicObject.set("ctrlstrategy", (Object)"5");
                    dynamicObject.set("status", (Object)"C");
                    dynamicObject.set("entrynumber", (Object)esignUpgradTempVo.getEntryNumber());
                    dynamicObject.set("entryname", (Object)esignUpgradTempVo.getEntryName());
                    dynamicObject.set("rule", (Object)esignUpgradTempVo.getFilterConditon());
                    if (HRStringUtils.equals((String)"1", (String)isEntry)) {
                        dynamicObject.set("isentry", (Object)"1");
                    } else {
                        dynamicObject.set("isentry", (Object)"0");
                    }
                    DynamicObjectCollection dynamicObjects = serviceHelper.generateEmptyEntryCollection(dynamicObject, "entryentity");
                    DynamicObjectCollection mapping = esignUpgradTempVo.getMapping();
                    for (DynamicObject entry : mapping) {
                        DynamicObject entryEntity = serviceHelper.generateEmptyEntryDynamicObject("entryentity");
                        entryEntity.set("parentfield", (Object)entry.getString("parentfield"));
                        entryEntity.set("sonfield", (Object)entry.getString("sonfield"));
                        entryEntity.set("parentfieldname", (Object)entry.getString("parentfieldname"));
                        entryEntity.set("sonfieldname", (Object)entry.getString("sonfieldname"));
                        entryEntity.set("fieldcondition", (Object)ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"TplVariableConfigPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                        dynamicObjects.add((Object)entryEntity);
                    }
                    serviceHelper.saveOne(dynamicObject);
                    parentIdReplace.put(esignUpgradTempVo.getId(), longIds[0]);
                }
            }
            esignUpgradTempVos = i;
            i = i + 1;
            iterator = i;
        }
        KeywordMappingServiceHelper.replaceTempRelateIdNew(parentIdReplace);
        Set longs = parentIdReplace.keySet();
        ArrayList deleteId = Lists.newArrayListWithCapacity((int)16);
        deleteId.addAll(longs);
        for (Map.Entry<Long, List<Long>> entry : replaceMap.entrySet()) {
            List<Long> value = entry.getValue();
            deleteId.addAll(value);
        }
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", (Object)deleteId)});
    }

    private static void distinctTplConfig(HashMap<String, List<EsignUpgradTempVo>> dataMap, HashMap<Long, List<Long>> replaceMap) {
        Integer i = 1;
        while (i <= dataMap.size()) {
            List<EsignUpgradTempVo> esignUpgradTempVos = dataMap.get(i.toString());
            ArrayList targetList = Lists.newArrayListWithCapacity((int)16);
            for (EsignUpgradTempVo dynamicObject : esignUpgradTempVos) {
                List parent = dynamicObject.getParent();
                boolean flag = false;
                for (EsignUpgradTempVo esignUpgradTempVo : targetList) {
                    boolean compareTplConfg;
                    List parentDealed = esignUpgradTempVo.getParent();
                    if (parent.size() != parentDealed.size()) continue;
                    boolean parentFlag = true;
                    for (int i1 = 0; i1 < parent.size(); ++i1) {
                        boolean compareTplConfg2 = KeywordMappingServiceHelper.compareTplConfg((EsignUpgradTempVo)parent.get(i1), (EsignUpgradTempVo)parentDealed.get(i1));
                        if (compareTplConfg2) continue;
                        parentFlag = false;
                        break;
                    }
                    if (!parentFlag || !(compareTplConfg = KeywordMappingServiceHelper.compareTplConfg(dynamicObject, esignUpgradTempVo))) continue;
                    flag = true;
                    List<Long> longs = replaceMap.get(esignUpgradTempVo.getId());
                    if (CollectionUtils.isEmpty(longs)) {
                        ArrayList repeatIds = Lists.newArrayListWithCapacity((int)16);
                        repeatIds.add(dynamicObject.getId());
                        replaceMap.put(esignUpgradTempVo.getId(), repeatIds);
                        break;
                    }
                    longs.add(dynamicObject.getId());
                    replaceMap.put(esignUpgradTempVo.getId(), longs);
                    break;
                }
                if (flag) continue;
                for (Map.Entry entry : replaceMap.entrySet()) {
                    Long key = (Long)entry.getKey();
                    List value = (List)entry.getValue();
                    if (!value.contains(dynamicObject.getParentId())) continue;
                    dynamicObject.setParentId(key);
                }
                targetList.add(dynamicObject);
            }
            dataMap.put(i.toString(), targetList);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    private static boolean compareTplConfg(EsignUpgradTempVo from, EsignUpgradTempVo to) {
        String isentry = from.getIsEntry();
        String isentryDealed = to.getIsEntry();
        boolean flag = false;
        String filterConditon = from.getFilterConditon();
        String filterConditonDealed = to.getFilterConditon();
        if (isentry.equals(isentryDealed)) {
            if ("1".equals(isentry)) {
                boolean filterControls;
                String entrynumber = from.getEntryNumber();
                String[] split = entrynumber.split("\\.");
                String entrynumberDealed = to.getEntryNumber();
                if (entrynumber.equals(entrynumberDealed) && !(filterControls = KeywordMappingServiceHelper.compareFilterControls(filterConditon, filterConditonDealed, split[0]))) {
                    flag = true;
                }
            } else {
                String numberDealed;
                String number = from.getEntityNumber();
                if (number.equals(numberDealed = to.getEntityNumber())) {
                    DynamicObjectCollection entryentity = from.getMapping();
                    DynamicObjectCollection entryentityDealed = to.getMapping();
                    boolean entryFlag = KeywordMappingServiceHelper.compareTplConfigEntry(entryentity, entryentityDealed);
                    boolean filterControls = KeywordMappingServiceHelper.compareFilterControls(filterConditon, filterConditonDealed, number);
                    if (!filterControls && entryFlag) {
                        flag = true;
                    }
                }
            }
        }
        return flag;
    }

    public static void mergeTplConfigByParentId(Long parentid, List<EsignUpgradTempVo> parentDy, Integer deep, HashMap<String, List<EsignUpgradTempVo>> dataMap) {
        DynamicObject[] entityByParentId;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        for (DynamicObject dynamicObject : entityByParentId = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("parentid", "=", (Object)parentid)})) {
            String fieldcondition = dynamicObject.getString("rule");
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            EsignUpgradTempVo esignUpgradTempVo = new EsignUpgradTempVo();
            String isentry = dynamicObject.getString("isentry");
            esignUpgradTempVo.setIsEntry(isentry);
            esignUpgradTempVo.setDeep(deep.toString());
            esignUpgradTempVo.setId((Long)dynamicObject.getPkValue());
            esignUpgradTempVo.setFilterConditon(fieldcondition);
            esignUpgradTempVo.setMapping(entryentity);
            esignUpgradTempVo.setParentId(parentid);
            DynamicObject parentDynamicObject = dynamicObject.getDynamicObject("parententity");
            if (parentDynamicObject != null) {
                esignUpgradTempVo.setParentNumber(dynamicObject.getDynamicObject("parententity").getString("number"));
            }
            if (HRStringUtils.equals((String)"1", (String)isentry)) {
                esignUpgradTempVo.setEntryNumber(dynamicObject.getString("entrynumber"));
                esignUpgradTempVo.setEntryName(dynamicObject.getString("entryname"));
            } else {
                String number = dynamicObject.getDynamicObject("sonentity").getString("number");
                esignUpgradTempVo.setEntityNumber(number);
            }
            ArrayList<EsignUpgradTempVo> nextParentList = new ArrayList<EsignUpgradTempVo>();
            nextParentList.addAll(parentDy);
            esignUpgradTempVo.setParent(parentDy);
            nextParentList.add(esignUpgradTempVo);
            List<EsignUpgradTempVo> esignUpgradTempVos = dataMap.get(deep.toString());
            if (CollectionUtils.isEmpty(esignUpgradTempVos)) {
                ArrayList objects = Lists.newArrayListWithCapacity((int)16);
                objects.add(esignUpgradTempVo);
                dataMap.put(deep.toString(), objects);
            } else {
                esignUpgradTempVos.add(esignUpgradTempVo);
                dataMap.put(deep.toString(), esignUpgradTempVos);
            }
            int index = deep + 1;
            KeywordMappingServiceHelper.mergeTplConfigByParentId((Long)dynamicObject.getPkValue(), nextParentList, index, dataMap);
        }
    }

    private static boolean compareTplConfigEntry(DynamicObjectCollection entryentity, DynamicObjectCollection entryentityDealed) {
        String sonfield;
        String parentfield;
        ArrayList entryentityStrList = Lists.newArrayListWithCapacity((int)16);
        ArrayList entryentityDealedStrList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dynamicObject : entryentity) {
            parentfield = dynamicObject.getString("parentfield");
            sonfield = dynamicObject.getString("sonfield");
            entryentityStrList.add(parentfield + "=" + sonfield);
        }
        for (DynamicObject dynamicObject : entryentityDealed) {
            parentfield = dynamicObject.getString("parentfield");
            sonfield = dynamicObject.getString("sonfield");
            entryentityDealedStrList.add(parentfield + "=" + sonfield);
        }
        for (String mappingStr : entryentityStrList) {
            if (entryentityDealedStrList.contains(mappingStr)) continue;
            return false;
        }
        for (String mappingStr : entryentityDealedStrList) {
            if (entryentityStrList.contains(mappingStr)) continue;
            return false;
        }
        return true;
    }

    public static void commonVariableDataUpgrad() {
        try (TXHandle txHandle = TX.required();){
            try {
                KeywordMappingServiceHelper.updateMainEntityFilterConditionNew();
            }
            catch (Exception exception) {
                LOGGER.error("updateMainEntityFilterConditionNew error", (Throwable)exception);
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_commonvariable");
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
            HRBaseServiceHelper templateService = new HRBaseServiceHelper("hlcm_contracttemplate");
            DynamicObject[] preSetTemplate = templateService.query("vid", new QFilter[]{new QFilter("issyspreset", "=", (Object)"1")});
            List preSetVids = Arrays.stream(preSetTemplate).map(template -> template.get("vid")).collect(Collectors.toList());
            DynamicObject[] query = baseServiceHelper.query(new QFilter[]{new QFilter("contempid", "not in", preSetVids)});
            DynamicObject[] contempTwo = baseServiceHelper.query(new QFilter[]{new QFilter("upgrad", "=", (Object)"2")});
            if (contempTwo != null && contempTwo.length > 0) {
                ScheduleService.getInstance().getObjectFactory().getScheduleDao().disableSchedule("3R=A901XBN4D");
                ScheduleService.getInstance().getObjectFactory().getScheduleDao().delete("3R=A901XBN4D");
                return;
            }
            if (query == null || query.length == 0) {
                ScheduleService.getInstance().getObjectFactory().getScheduleDao().disableSchedule("3R=A901XBN4D");
                ScheduleService.getInstance().getObjectFactory().getScheduleDao().delete("3R=A901XBN4D");
                return;
            }
            DynamicObject[] templateArr = templateService.query("vid", new QFilter[0]);
            List templateIds = Arrays.stream(templateArr).map(template -> template.get("vid")).collect(Collectors.toList());
            DynamicObject[] contempIdListPrset = baseServiceHelper.query("upgrad,entryentity.entitynumber,entryentity.iscustomize,entryentity.customizekey,entryentity.wordfield,entryentity.relateentityid,entryentity.filtercondition,entryentity.entityfield,entryentity.variableid,entryentity.multlang", new QFilter[]{new QFilter("contempid", "=", (Object)1555680070209637376L), new QFilter("upgrad", "!=", (Object)"2")});
            DynamicObjectCollection alerdyDeal = new DynamicObjectCollection();
            DynamicObjectCollection generNewData = new DynamicObjectCollection();
            ArrayList names = Lists.newArrayListWithCapacity((int)16);
            HashMap alerdyDealDyAndVar = Maps.newHashMapWithExpectedSize((int)16);
            Integer number = 1010;
            number = KeywordMappingServiceHelper.generateVariable(serviceHelper, contempIdListPrset, alerdyDeal, names, number, alerdyDealDyAndVar, generNewData, "1", "0");
            templateIds.remove(1555680070209637376L);
            DynamicObject[] contempIdList = baseServiceHelper.query("upgrad,entryentity.entitynumber,entryentity.iscustomize,entryentity.customizekey,entryentity.wordfield,entryentity.relateentityid,entryentity.filtercondition,entryentity.entityfield,entryentity.variableid,entryentity.multlang", new QFilter[]{new QFilter("contempid", "in", templateIds), new QFilter("upgrad", "!=", (Object)"2")});
            KeywordMappingServiceHelper.generateVariable(serviceHelper, contempIdList, alerdyDeal, names, number, alerdyDealDyAndVar, generNewData, "0", "1");
            serviceHelper.save(generNewData);
            baseServiceHelper.update(contempIdListPrset);
            baseServiceHelper.update(contempIdList);
            KeywordMappingServiceHelper.initModelUpgradFlag();
            ScheduleService.getInstance().getObjectFactory().getScheduleDao().disableSchedule("3R=A901XBN4D");
            ScheduleService.getInstance().getObjectFactory().getScheduleDao().delete("3R=A901XBN4D");
        }
    }

    public static void updateMainEntityFilterConditionNew() {
        Long relateentityid;
        String keyWordEntityNumber;
        DynamicObjectCollection entryentity;
        DynamicObject[] contempIds;
        boolean flag = false;
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        for (DynamicObject dynamicObject : contempIds = baseServiceHelper.query("entryentity.entitynumber,entryentity.relateentityid,entryentity.filtercondition", new QFilter[0])) {
            entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryentity) {
                keyWordEntityNumber = object.getString("entitynumber");
                relateentityid = object.getLong("relateentityid");
                if (!"hlcm_contractapplybase".equals(keyWordEntityNumber) || relateentityid != 0L) continue;
                flag = true;
            }
        }
        if (!flag) {
            return;
        }
        for (DynamicObject dynamicObject : contempIds) {
            entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryentity) {
                keyWordEntityNumber = object.getString("entitynumber");
                relateentityid = object.getLong("relateentityid");
                if (!"hlcm_contractapplybase".equals(keyWordEntityNumber) || relateentityid != 0L) continue;
                object.set("relateentityid", (Object)EContractConstant.ROOT_ID);
                String filtercondition = object.getString("filtercondition");
                if (KeywordMappingServiceHelper.setFilterConditionNew(filtercondition, EContractConstant.ROOT_ID.toString(), object)) continue;
            }
        }
        baseServiceHelper.update(contempIds);
    }

    private static Integer generateVariable(HRBaseServiceHelper serviceHelper, DynamicObject[] contempIdList, DynamicObjectCollection alerdyDeal, ArrayList<String> names, Integer number, HashMap<Long, Long> alerdyDealDyAndVar, DynamicObjectCollection generNewData, String issyspreset, String varUpgradFlag) {
        HashMap<Long, DynamicObject> allTplVariableConfigMap = KeywordMappingServiceHelper.getAllTplVariableConfigMap();
        for (DynamicObject contemp : contempIdList) {
            DynamicObjectCollection dynamicObjectCollection = contemp.getDynamicObjectCollection("entryentity");
            contemp.set("upgrad", (Object)"2");
            for (DynamicObject contempId : dynamicObjectCollection) {
                DynamicObject dynamicObject2;
                String entityField = contempId.getString("entityfield");
                String entityNumber = contempId.getString("entitynumber");
                String filterCondition = contempId.getString("filtercondition");
                String wordfield = contempId.getString("wordfield");
                Long relateEntityId = contempId.getLong("relateentityid");
                if ("hlcm_contractapplybase".equals(entityNumber)) {
                    contempId.set("relateentityid", (Object)Long.valueOf(KeywordMappingServiceHelper.getRootId("hlcm_contractapplybase")));
                    relateEntityId = Long.valueOf(KeywordMappingServiceHelper.getRootId("hlcm_contractapplybase"));
                }
                String isCustomize = contempId.getString("iscustomize");
                String customizekey = contempId.getString("customizekey");
                if (!"hlcm_contractapplybase".equals(entityNumber) && relateEntityId == 0L && !"1".equals(isCustomize)) continue;
                boolean flag = false;
                for (DynamicObject dynamicObject2 : alerdyDeal) {
                    String entityFieldDealed = dynamicObject2.getString("entityfield");
                    String entityNumberDealed = dynamicObject2.getString("entitynumber");
                    String filterConditionDealed = dynamicObject2.getString("filtercondition");
                    Long relateEntityIdDealed = dynamicObject2.getLong("relateentityid");
                    String wordfieldDealed = dynamicObject2.getString("wordfield");
                    String isCustomizeDealed = dynamicObject2.getString("iscustomize");
                    String customizekeyDealed = dynamicObject2.getString("customizekey");
                    String multlang = dynamicObject2.getString("multlang");
                    if (HRStringUtils.equals((String)"1", (String)isCustomizeDealed) && HRStringUtils.equals((String)"1", (String)isCustomize)) {
                        if (!customizekey.equals(customizekeyDealed)) continue;
                        contempId.set("variableid", (Object)alerdyDealDyAndVar.get(dynamicObject2.getPkValue()));
                        flag = true;
                        break;
                    }
                    if (HRStringUtils.equals((String)"1", (String)isCustomizeDealed) || HRStringUtils.equals((String)"1", (String)isCustomize) || !entityField.equals(entityFieldDealed) || !relateEntityId.equals(relateEntityIdDealed) || !entityNumber.equals(entityNumberDealed) || KeywordMappingServiceHelper.compareFieldFilterControls(filterCondition, filterConditionDealed, entityNumberDealed)) continue;
                    if ("hlcm_contractapplybase".equals(entityNumber)) {
                        contempId.set("relateentityid", (Object)KeywordMappingServiceHelper.getRootId("hlcm_contractapplybase"));
                    }
                    contempId.set("variableid", (Object)alerdyDealDyAndVar.get(dynamicObject2.getPkValue()));
                    contempId.set("multlang", (Object)multlang);
                    flag = true;
                    break;
                }
                Map<String, List<String>> collect = names.stream().collect(Collectors.groupingBy(name -> {
                    if (name.contains("_")) {
                        return name.substring(0, name.indexOf("_"));
                    }
                    return name;
                }));
                if (flag) continue;
                dynamicObject2 = serviceHelper.generateEmptyDynamicObject();
                String name2 = wordfield.substring(wordfield.indexOf("{") + 1, wordfield.indexOf("}"));
                long[] longIds = DBServiceHelper.genLongIds((String)"hrcs_commonvariable", (int)1);
                dynamicObject2.set("id", (Object)longIds[0]);
                if (collect.containsKey(name2)) {
                    List<String> values = collect.get(name2);
                    name2 = name2 + "_" + values.size();
                    names.add(name2);
                    KeywordMappingServiceHelper.setCommonVariableProperty(number, entityField, entityNumber, filterCondition, relateEntityId, isCustomize, customizekey, dynamicObject2, name2, issyspreset, allTplVariableConfigMap, contempId, varUpgradFlag);
                } else {
                    names.add(name2);
                    KeywordMappingServiceHelper.setCommonVariableProperty(number, entityField, entityNumber, filterCondition, relateEntityId, isCustomize, customizekey, dynamicObject2, name2, issyspreset, allTplVariableConfigMap, contempId, varUpgradFlag);
                }
                alerdyDealDyAndVar.put((Long)contempId.getPkValue(), longIds[0]);
                contempId.set("variableid", (Object)longIds[0]);
                alerdyDeal.add((Object)contempId);
                generNewData.add((Object)dynamicObject2);
                number = number + 10;
            }
        }
        return number;
    }

    private static void setCommonVariableProperty(int number, String entityField, String entityNumber, String filterCondition, Long relateEntityId, String isCustomize, String customizekey, DynamicObject dynamicObject, String name, String issyspreset, HashMap<Long, DynamicObject> allTplVariableConfigMap, DynamicObject contempId, String varUpgradFlag) {
        dynamicObject.set("number", (Object)(number + "_S"));
        dynamicObject.set("name", (Object)name);
        dynamicObject.set("description", (Object)name);
        if (HRStringUtils.equals((String)"1", (String)isCustomize)) {
            dynamicObject.set("custkey", (Object)customizekey);
            dynamicObject.set("getvalueway", (Object)"2");
        } else {
            DynamicObject tplVariableConfig;
            dynamicObject.set("getvalueway", (Object)"1");
            if ("hlcm_contractapplybase".equals(entityNumber)) {
                dynamicObject.set("relateentityid", (Object)KeywordMappingServiceHelper.getRootId("hlcm_contractapplybase"));
            } else {
                dynamicObject.set("relateentityid", (Object)relateEntityId);
            }
            dynamicObject.set("entityfield", (Object)entityField);
            dynamicObject.set("entitynumber", (Object)entityNumber);
            dynamicObject.set("filtercondition", (Object)filterCondition);
            try {
                tplVariableConfig = KeywordMappingServiceHelper.getTplVariableConfig(relateEntityId);
            }
            catch (Exception exception) {
                LOGGER.error("getTplVariableConfig err relateEntityId={}", (Object)relateEntityId);
                return;
            }
            String isEntry = tplVariableConfig.getString("isentry");
            String entryNumber = tplVariableConfig.getString("entrynumber");
            ArrayList pathList = Lists.newArrayListWithCapacity((int)16);
            String[] split = entityField.split("\\.");
            if ("1".equals(isEntry)) {
                KeywordMappingServiceHelper.getPrePathList(entryNumber, split, pathList);
            } else {
                KeywordMappingServiceHelper.getPrePathList(entityNumber, split, pathList);
            }
            Collections.reverse(pathList);
            String entityPath = KeywordMappingServiceHelper.getdisplayEntityPath(relateEntityId, pathList, allTplVariableConfigMap);
            String entityMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\uff1a", (String)"CommonVariablePlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            String buildFilterDesc = KeywordMappingServiceHelper.buildFilterDesc(entityMsg + entityPath, entityNumber, filterCondition, relateEntityId.toString());
            dynamicObject.set("entityproperty", (Object)entityPath);
            dynamicObject.set("ruletext", (Object)buildFilterDesc);
            String muliLang = KeywordMappingServiceHelper.getMuliLang(entityNumber, entityField.split("\\."));
            dynamicObject.set("multilang", (Object)muliLang);
            if ("1".equals(muliLang)) {
                contempId.set("multlang", (Object)"zh_CN");
            }
        }
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("variableupgradflag", (Object)varUpgradFlag);
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("issyspreset", (Object)issyspreset);
        dynamicObject.set("mainentity", (Object)"hlcm_contractapplybase");
    }

    public static String getMuliLang(String entityNumber, String[] split) {
        int index = 0;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)split[index]);
        if (split.length - 1 == index) {
            if (iDataEntityProperty instanceof MuliLangTextProp) {
                return "1";
            }
            return "0";
        }
        if (iDataEntityProperty instanceof EntryProp) {
            return KeywordMappingServiceHelper.entryEntity(split, index, iDataEntityProperty);
        }
        if (iDataEntityProperty instanceof BasedataProp) {
            LOGGER.info("split:{},field:{},fieldvalue:{}", (Object)split, (Object)split[index]);
            return KeywordMappingServiceHelper.baseDataEntity(split, index, iDataEntityProperty);
        }
        return "0";
    }

    public static String entryEntity(String[] split, int index, IDataEntityProperty iDataEntityProperty) {
        if (split.length - 1 == ++index) {
            DynamicObjectType dynamicCollectionItemPropertyType = ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType();
            DynamicProperty property = dynamicCollectionItemPropertyType.getProperty(split[index]);
            if (property instanceof MuliLangTextProp) {
                return "1";
            }
            return "0";
        }
        DynamicObjectType dynamicCollectionItemPropertyType = ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType();
        DynamicProperty property = dynamicCollectionItemPropertyType.getProperty(split[index]);
        if (property instanceof EntryProp) {
            return KeywordMappingServiceHelper.entryEntity(split, index, (IDataEntityProperty)property);
        }
        if (property instanceof BasedataProp) {
            return KeywordMappingServiceHelper.baseDataEntity(split, index, (IDataEntityProperty)property);
        }
        return "0";
    }

    public static String baseDataEntity(String[] split, int index, IDataEntityProperty iDataEntityProperty) {
        if (split.length - 1 == ++index) {
            String baseEntityId = ((BasedataProp)iDataEntityProperty).getBaseEntityId();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            IDataEntityProperty subEntityProperty = (IDataEntityProperty)properties.get((Object)split[index]);
            if (subEntityProperty instanceof MuliLangTextProp) {
                return "1";
            }
            return "0";
        }
        String baseEntityId = ((BasedataProp)iDataEntityProperty).getBaseEntityId();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty subEntityProperty = (IDataEntityProperty)properties.get((Object)split[index]);
        if (subEntityProperty instanceof EntryProp) {
            return KeywordMappingServiceHelper.entryEntity(split, index, subEntityProperty);
        }
        if (subEntityProperty instanceof BasedataProp) {
            return KeywordMappingServiceHelper.baseDataEntity(split, index, subEntityProperty);
        }
        return "0";
    }

    public static boolean compareFilterControls(String currentFilterCondition, String filterConditionDealed, String entityNumber) {
        QFilter newQFilter = HRStringUtils.isEmpty((String)currentFilterCondition) ? new QFilter("1", "=", (Object)"1") : KeywordMappingServiceHelper.convertJsonToQFilter(entityNumber, currentFilterCondition);
        QFilter oldQFilter = HRStringUtils.isEmpty((String)filterConditionDealed) ? new QFilter("1", "=", (Object)"1") : KeywordMappingServiceHelper.convertJsonToQFilter(entityNumber, filterConditionDealed);
        if (newQFilter != null && oldQFilter != null) {
            String newQFilterStr = newQFilter.toSerializedString();
            String oldQFilterStr = oldQFilter.toSerializedString();
            boolean equals = oldQFilterStr.equals(newQFilterStr);
            if (!equals) {
                return true;
            }
        }
        return false;
    }

    public static boolean compareFieldFilterControls(String currentFilterCondition, String filterConditionDealed, String entityNumber) {
        QFilter oldQFilter;
        String value;
        Map filterCondition;
        QFilter newQFilter;
        if (HRStringUtils.isEmpty((String)currentFilterCondition)) {
            newQFilter = new QFilter("1", "=", (Object)"1");
        } else if (!currentFilterCondition.startsWith("{\"filterRow")) {
            filterCondition = (Map)SerializationUtils.fromJsonString((String)currentFilterCondition, Map.class);
            value = "";
            for (Map.Entry entry : filterCondition.entrySet()) {
                value = entry.getValue();
            }
            newQFilter = KeywordMappingServiceHelper.convertJsonToQFilter(entityNumber, SerializationUtils.toJsonString((Object)value));
        } else {
            newQFilter = KeywordMappingServiceHelper.convertJsonToQFilter(entityNumber, currentFilterCondition);
        }
        if (HRStringUtils.isEmpty((String)filterConditionDealed)) {
            oldQFilter = new QFilter("1", "=", (Object)"1");
        } else if (!filterConditionDealed.startsWith("{\"filterRow")) {
            filterCondition = (Map)SerializationUtils.fromJsonString((String)filterConditionDealed, Map.class);
            value = "";
            for (Map.Entry entry : filterCondition.entrySet()) {
                value = entry.getValue();
            }
            oldQFilter = KeywordMappingServiceHelper.convertJsonToQFilter(entityNumber, SerializationUtils.toJsonString((Object)value));
        } else {
            oldQFilter = KeywordMappingServiceHelper.convertJsonToQFilter(entityNumber, filterConditionDealed);
        }
        if (newQFilter != null && oldQFilter != null) {
            String newQFilterStr = newQFilter.toSerializedString();
            String oldQFilterStr = oldQFilter.toSerializedString();
            boolean equals = oldQFilterStr.equals(newQFilterStr);
            if (!equals) {
                return true;
            }
        }
        return false;
    }

    public static void updateModelUpgradFlag(String formNumber, String type) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        DynamicObject tplVariableMainEntity = KeywordMappingServiceHelper.getTplVariableMainEntity(formNumber);
        String entityupgradflag = tplVariableMainEntity.getString("entityupgradflag");
        String variableupgradflag = tplVariableMainEntity.getString("variableupgradflag");
        if ("1".equals(type)) {
            if ("1".equals(entityupgradflag)) {
                return;
            }
            tplVariableMainEntity.set("entityupgradflag", (Object)"1");
            serviceHelper.updateOne(tplVariableMainEntity);
        } else {
            if ("1".equals(variableupgradflag)) {
                return;
            }
            tplVariableMainEntity.set("variableupgradflag", (Object)"1");
            serviceHelper.updateOne(tplVariableMainEntity);
        }
    }

    public static void initModelUpgradFlag() {
        DynamicObject[] issyspresets;
        DynamicObject[] data;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        HRBaseServiceHelper commonVarHelper = new HRBaseServiceHelper("hrcs_commonvariable");
        for (DynamicObject item : data = serviceHelper.query("issyspreset", new QFilter[0])) {
            Boolean issyspreset = item.getBoolean("issyspreset");
            if (issyspreset.booleanValue()) continue;
            KeywordMappingServiceHelper.updateModelUpgradFlag("hlcm_contractapplybase", "1");
            break;
        }
        for (DynamicObject item : issyspresets = commonVarHelper.query("issyspreset", new QFilter[0])) {
            Boolean issyspreset = item.getBoolean("issyspreset");
            if (issyspreset.booleanValue()) continue;
            KeywordMappingServiceHelper.updateModelUpgradFlag("hlcm_contractapplybase", "2");
            break;
        }
    }
}

