/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.hismodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.repository.hismodel.EventEntityRepository;
import kd.hr.hrcs.bussiness.service.hismodel.model.constant.HisSystemConstants;

public class HisVerCpColCfgServiceHelper
implements HisSystemConstants {
    public static Map<String, Map<String, Object>> getEntityVerCpCol(String entityNumber) {
        Map allFields = EntityMetadataCache.getDataEntityType((String)entityNumber).getAllFields();
        FormMetadata formMeta = HisVerCpColCfgServiceHelper.getFormMetadataByEntityNumber(entityNumber);
        return HisVerCpColCfgServiceHelper.getAllVerCpColByFormData(formMeta, allFields);
    }

    public static List<Map<String, Object>> getEntityVerCpColCfg(String entityNumber) {
        Map allFields = EntityMetadataCache.getDataEntityType((String)entityNumber).getAllFields();
        FormMetadata formMeta = HisVerCpColCfgServiceHelper.getFormMetadataByEntityNumber(entityNumber);
        Map<String, Map<String, Object>> allVerCpCol = HisVerCpColCfgServiceHelper.getAllVerCpColByFormData(formMeta, allFields);
        FormRoot rootControl = FormMetadataCache.getRootControl((String)entityNumber);
        HashMap<String, String> attachmentKeys = new HashMap<String, String>(16);
        HisVerCpColCfgServiceHelper.findRealColFlagMap((Control)rootControl, attachmentKeys);
        ArrayList<Map<String, Object>> verCpColCfgList = new ArrayList<Map<String, Object>>();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_vercpcolcfg");
        QFilter qfilter = new QFilter("entitytype", "=", (Object)entityNumber);
        boolean existsCfg = helper.isExists(qfilter);
        if (existsCfg) {
            DynamicObject verCpColCfgDb = helper.queryOne("entryentity.colflag,entryentity.colseq", qfilter);
            DynamicObjectCollection verCpColCfgColl = verCpColCfgDb.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < verCpColCfgColl.size(); ++i) {
                LocaleString colName;
                DynamicObject verCpEntry = (DynamicObject)verCpColCfgColl.get(i);
                HashMap<String, Object> verCpColCfg = new HashMap<String, Object>(3);
                String colFlag = verCpEntry.getString("colflag");
                if (StringUtils.isEmpty((CharSequence)colFlag)) continue;
                if (allFields.containsKey(colFlag) && allVerCpCol.containsKey(colFlag)) {
                    verCpColCfg.put("colflag", colFlag);
                } else {
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)attachmentKeys.get(colFlag)))) continue;
                    verCpColCfg.put("colflag", attachmentKeys.get(colFlag));
                }
                if (null == allVerCpCol.get(colFlag) || null == (colName = (LocaleString)allVerCpCol.get(colFlag).get("colname"))) continue;
                verCpColCfg.put("colname", colName.getLocaleValue());
                verCpColCfg.put("colseq", verCpEntry.get("colseq"));
                verCpColCfgList.add(verCpColCfg);
            }
        } else {
            String inheritPath = formMeta.getInheritPath();
            boolean entityIsCtrl = HisVerCpColCfgServiceHelper.chkEntityIsCtrlByInheritPath(inheritPath);
            for (Map.Entry<String, Map<String, Object>> entry : allVerCpCol.entrySet()) {
                String colType;
                String colFlag = entry.getKey();
                if (StringUtils.isEmpty((CharSequence)colFlag) || !HisVerCpColCfgServiceHelper.isShowCol(colFlag, entityIsCtrl, colType = (String)entry.getValue().get("coltype"))) continue;
                HashMap<String, Object> verCpColCfg = new HashMap<String, Object>(3);
                if (allFields.containsKey(colFlag)) {
                    verCpColCfg.put("colflag", colFlag);
                } else {
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)attachmentKeys.get(colFlag)))) continue;
                    verCpColCfg.put("colflag", attachmentKeys.get(colFlag));
                }
                LocaleString colName = (LocaleString)entry.getValue().get("colname");
                if (null == colName) continue;
                verCpColCfg.put("colname", colName.getLocaleValue());
                verCpColCfg.put("colseq", 0);
                verCpColCfgList.add(verCpColCfg);
            }
        }
        return verCpColCfgList;
    }

    public static QFilter buildHisF7Filter() {
        DynamicObject[] dynamicObjects;
        ArrayList<String> hisModelList = new ArrayList<String>(Arrays.asList(LINE_TIME_TPL));
        ArrayList<String> nonLineTimeTplS = new ArrayList<String>(Arrays.asList(NON_LINE_TIME_TPL));
        hisModelList.addAll(nonLineTimeTplS);
        QFilter filter = new QFilter("number", "in", hisModelList);
        DynamicObject[] result = EventEntityRepository.getOriginalDynamicObjects("bos_entitymeta", filter, "id");
        List ids = Arrays.stream(result).map(id -> id.getString("id")).collect(Collectors.toList());
        ArrayList allHistEntityIds = Lists.newArrayListWithExpectedSize((int)16);
        block0: for (DynamicObject dy : dynamicObjects = EventEntityRepository.getOriginalDynamicObjects("bos_entitymeta", QFilter.of((String)"1==1", (Object[])new Object[0]), "id,number,inheritpath")) {
            String inheritPath = dy.getString("inheritpath");
            List inheritPaths = Arrays.stream(inheritPath.split(",")).collect(Collectors.toList());
            for (String parentId : inheritPaths) {
                if (!ids.contains(parentId)) continue;
                allHistEntityIds.add(dy.get("id"));
                continue block0;
            }
        }
        return new QFilter("dentityid", "in", (Object)allHistEntityIds);
    }

    public static FormMetadata getFormMetadataByEntityNumber(String entityNumber) {
        String id = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        return formMeta;
    }

    public static boolean chkEntityIsCtrl(String entityNumber) {
        FormMetadata formMeta = HisVerCpColCfgServiceHelper.getFormMetadataByEntityNumber(entityNumber);
        String inheritPath = formMeta.getInheritPath();
        return HisVerCpColCfgServiceHelper.chkEntityIsCtrlByInheritPath(inheritPath);
    }

    public static boolean isShowCol(String colFlag, boolean entityIsCtrl, String colType) {
        if (EXCLUDE_COL.contains(colFlag)) {
            return false;
        }
        if (entityIsCtrl && EXCLUDE_COL_CTRL.contains(colFlag)) {
            return false;
        }
        if ("EntryFieldAp".equals(colType) && colFlag.startsWith("entryboid")) {
            return false;
        }
        return !"CardEntryFieldAp".equals(colType) || !colFlag.startsWith("entryboid");
    }

    private static Map<String, Map<String, Object>> getAllVerCpColByFormData(FormMetadata formMeta, Map<String, IDataEntityProperty> allFields) {
        List allItems = formMeta.getItems();
        HashMap<String, Map<String, Object>> entityInfos = new HashMap<String, Map<String, Object>>(16);
        for (int i = 0; i < allItems.size(); ++i) {
            String colFlag;
            ControlAp item = (ControlAp)allItems.get(i);
            String fieldName = item.getClass().getSimpleName();
            if (!HRStringUtils.equals((String)fieldName, (String)"FieldAp") && !HRStringUtils.equals((String)fieldName, (String)"EntryFieldAp") && !HRStringUtils.equals((String)fieldName, (String)"CardEntryFieldAp") || allFields.containsKey(colFlag = item.getKey()) && StringUtils.isEmpty((CharSequence)allFields.get(colFlag).getAlias())) continue;
            HashMap<String, String> entityInfo = new HashMap<String, String>(3);
            entityInfo.put("colflag", item.getKey());
            entityInfo.put("colname", (String)item.getName());
            entityInfo.put("coltype", fieldName);
            entityInfos.put(item.getKey(), entityInfo);
        }
        return entityInfos;
    }

    private static boolean chkEntityIsCtrlByInheritPath(String inheritPath) {
        boolean isCtrl = false;
        for (String tplId : BU_TEMPLATE_ID) {
            if (StringUtils.isEmpty((CharSequence)inheritPath)) {
                isCtrl = false;
                break;
            }
            if (!inheritPath.contains(tplId)) continue;
            isCtrl = true;
            break;
        }
        return isCtrl;
    }

    public static void findRealColFlagMap(Control control, Map<String, String> attachmentKeys) {
        if (control instanceof Container) {
            for (Control item : ((Container)control).getItems()) {
                HisVerCpColCfgServiceHelper.findRealColFlagMap(item, attachmentKeys);
            }
        } else if (control instanceof BasedataPropEdit) {
            BasedataPropEdit baseProEdit = (BasedataPropEdit)control;
            String levelOne = baseProEdit.getRefBasedataProp();
            String levelTwo = baseProEdit.getRefDisplayProp();
            if (!StringUtils.isEmpty((CharSequence)levelTwo)) {
                attachmentKeys.put(control.getKey(), levelOne + "." + levelTwo);
            }
        }
    }
}

