/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.utils.ParamsUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.function.FunctionSubPageService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelService;
import kd.hr.hrcs.bussiness.service.label.LabelTaskStorageService;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelPolicyServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.label.LblHelperConstants;
import kd.hr.hrcs.common.constants.label.LabelManageConstants;
import kd.hr.hrcs.common.constants.label.LabelRuleEngineConstants;
import kd.hr.hrcs.common.model.label.LabelSaveSceneBO;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class LabelServiceHelper
implements LabelRuleEngineConstants,
LabelManageConstants {
    private static final Log LOGGER = LogFactory.getLog(LabelServiceHelper.class);
    private static final String LABEL_ENTITY = "hrcs_label";
    private static final String LABEL_OBJECT_ENTITY = "hrcs_labelobject";
    private static final String LABEL_OBJECT_REL_ENTITY = "hrcs_labelobjectrel";
    private static final String LABEL_VALUE_ENTITY = "hrcs_labelvalue";
    private static final String LABEL_VALUE_RULE_ENTITY = "hrcs_labelvaluerule";
    private static final String LABEL_PARAM_ENTITY = "hrcs_labelparam";
    private static final String OBJECT_FIELD_ENTRY = "hrcs_lblobjectfield";
    private static final String STRATEGY_ENTRY = "hrcs_lblstrategy";
    private static final String POLICY_TASK_ENTRY = "hrcs_labelpolicytask";
    private static final String OBJECT_CONFIG_ENTRY = "hrcs_lblobjconfig";
    private static final String LABEL_PREFIX = "Label_";
    private static final HRBaseServiceHelper labelEntryServiceHelper = new HRBaseServiceHelper("hrcs_label");
    private static final HRBaseServiceHelper labelObjectEntryServiceHelper = new HRBaseServiceHelper("hrcs_labelobject");
    private static final HRBaseServiceHelper labelObjectRelServiceHelper = new HRBaseServiceHelper("hrcs_labelobjectrel");
    private static final HRBaseServiceHelper labelValueServiceHelper = new HRBaseServiceHelper("hrcs_labelvalue");
    private static final HRBaseServiceHelper labelValueRuleServiceHelper = new HRBaseServiceHelper("hrcs_labelvaluerule");
    private static final HRBaseServiceHelper labelParamServiceHelper = new HRBaseServiceHelper("hrcs_labelparam");
    private static final HRBaseServiceHelper objectFiledServiceHelper = new HRBaseServiceHelper("hrcs_lblobjectfield");
    private static final HRBaseServiceHelper strategyServiceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
    private static final HRBaseServiceHelper policyTaskServiceHelper = new HRBaseServiceHelper("hrcs_labelpolicytask");
    private static final LabelPolicyServiceHelper labelPolicyServiceHelper = new LabelPolicyServiceHelper();
    private static final HRBaseServiceHelper objectConfigServiceHelper = new HRBaseServiceHelper("hrcs_lblobjconfig");
    private static final String HRCS_BIZAPP = "15NPDX/GJFOO";
    private static final HRBaseServiceHelper sceneServiceHelper = new HRBaseServiceHelper("brm_scene");
    private static final Log logger = LogFactory.getLog(LabelServiceHelper.class);
    LabelService labelService = new LabelService();

    public DynamicObject[] getLabels(List<Long> idList) {
        return labelEntryServiceHelper.loadDynamicObjectArray(idList.toArray());
    }

    public DynamicObject loadObject(long objectId) {
        return labelObjectEntryServiceHelper.loadSingle((Object)objectId);
    }

    public void addLabelValueFact(DynamicObjectCollection dynamicObjectCollection, DynamicObject label, Map<Integer, Map<String, Map<String, Object>>> exprMap, Map<Long, List<Map<String, Object>>> addParamMap) {
        if (dynamicObjectCollection.isEmpty()) {
            return;
        }
        this.addLabelValueRule(dynamicObjectCollection, label, exprMap, addParamMap);
    }

    public void updateLabelValueFact(DynamicObjectCollection dynamicObjectCollection, DynamicObject label, Map<Integer, Map<String, Map<String, Object>>> exprMap, Map<Long, List<Map<String, Object>>> addParamMap) {
        if (dynamicObjectCollection.isEmpty()) {
            return;
        }
        this.updateLabelValueRule(dynamicObjectCollection, label, exprMap, addParamMap);
    }

    public void deleteLabelValue(List<Long> delLabelValueIdList, Long lblId) {
        if (CollectionUtils.isEmpty(delLabelValueIdList)) {
            return;
        }
        DynamicObject[] rulesByLabelValue = this.getRulesByLabelValue(delLabelValueIdList);
        ArrayList labelVRIdList = Lists.newArrayListWithExpectedSize((int)rulesByLabelValue.length);
        for (DynamicObject labelVR : rulesByLabelValue) {
            labelVRIdList.add(labelVR.getLong("id"));
        }
        this.deleteTargetAndParams(delLabelValueIdList, rulesByLabelValue, lblId);
        labelValueRuleServiceHelper.delete(labelVRIdList.toArray());
    }

    public void deleteTargetAndParams(List<Long> delLabelValueIdList, DynamicObject[] rulesByLabelValue, Long lblId) {
        if (rulesByLabelValue.length == 0) {
            return;
        }
        ArrayList targetIdList = Lists.newArrayListWithExpectedSize((int)rulesByLabelValue.length);
        for (DynamicObject labelVR : rulesByLabelValue) {
            long id = labelVR.getLong("brmtarget.id");
            if (id == 0L) continue;
            targetIdList.add(id);
        }
        this.deleteBrmTarget(targetIdList);
        List<Long> paramIdList = this.deleteParams(lblId, delLabelValueIdList);
        labelParamServiceHelper.delete(paramIdList.toArray());
    }

    private List<Long> deleteParams(Long lblId, List<Long> delLabelValueIdList) {
        DynamicObject[] paramsByLabelValue = this.getParamsByLabel(lblId);
        DynamicObjectCollection filterParams = new DynamicObjectCollection();
        HashSet duplicateParam = Sets.newHashSetWithExpectedSize((int)paramsByLabelValue.length);
        ArrayList paramIdList = Lists.newArrayListWithExpectedSize((int)paramsByLabelValue.length);
        for (DynamicObject param : paramsByLabelValue) {
            long labelValueId = param.getLong("labelvalue.id");
            long brmInputParamId = param.getLong("brmiputparam.id");
            if (labelValueId == 0L || delLabelValueIdList.contains(labelValueId)) {
                paramIdList.add(param.getLong("id"));
                if (!duplicateParam.add(brmInputParamId)) continue;
                filterParams.add((Object)param);
                continue;
            }
            if (duplicateParam.add(brmInputParamId)) continue;
            filterParams.removeIf(filterParam -> Objects.equals(brmInputParamId, filterParam.getLong("brmiputparam.id")));
        }
        HashMap groupParams = Maps.newHashMapWithExpectedSize((int)paramsByLabelValue.length);
        for (DynamicObject param : filterParams) {
            long sceneId = param.getLong("brmscene.id");
            List groupList = groupParams.getOrDefault(sceneId, Lists.newArrayListWithExpectedSize((int)paramsByLabelValue.length));
            groupList.add(param);
            groupParams.put(sceneId, groupList);
        }
        groupParams.forEach((key, value) -> {
            HashMap<String, Object> requestMap = new HashMap<String, Object>();
            String sceneName = ((DynamicObject)value.get(0)).getString("brmscene.name");
            requestMap.put("name", sceneName);
            requestMap.put("bizappid", HRCS_BIZAPP);
            requestMap.put("status", "C");
            requestMap.put("id", key);
            ArrayList inputList = Lists.newArrayListWithExpectedSize((int)value.size());
            value.forEach(param -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", param.get("brmiputparam.id"));
                map.put("inputnumber", param.get("brmiputparam.number"));
                map.put("modifystatus", "delete");
                inputList.add(map);
            });
            requestMap.put("inputparams", inputList);
            Map brmSceneResult = (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMSceneService", (String)"modifyScene", (Object[])new Object[]{requestMap});
            if (!"200".equals(brmSceneResult.get("resultCode").toString())) {
                throw new KDBizException(brmSceneResult.get("errorMsg").toString());
            }
        });
        return paramIdList;
    }

    public DynamicObject[] getLabelValueCollection(long labelId) {
        QFilter qFilter = new QFilter("label", "=", (Object)labelId);
        return labelValueServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getLabelValueCollection(List<Long> labelId) {
        QFilter qFilter = new QFilter("label", "in", labelId);
        return labelValueServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getLabelObjectRelCollection(long labelId) {
        QFilter qFilter = new QFilter("label", "=", (Object)labelId);
        return labelObjectRelServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObjectCollection queryLabelObjectRelCollection(long labelId) {
        if (labelEntryServiceHelper.isExists((Object)labelId)) {
            DynamicObject label = this.getLabel(labelId);
            return label.getDynamicObjectCollection("entryentityrange");
        }
        return null;
    }

    public DynamicObject[] getLabelObjectRelCollection(List<Long> labelId) {
        QFilter qFilter = new QFilter("label", "in", labelId);
        return labelObjectRelServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject getLabel(long labelId) {
        return labelEntryServiceHelper.loadSingle((Object)labelId);
    }

    public List<Map<String, Object>> getLabelHitResult(Long policyId, String[] selects, List<QFilter> qFilters, int pageIndex, int pageSize) {
        return this.getLabelHitResult(policyId, selects, qFilters, pageIndex, pageSize, null);
    }

    public List<Map<String, Object>> getLabelHitResult(Long policyId, String[] selects, List<QFilter> qFilters, int pageIndex, int pageSize, String taskNo) {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        String taskNumber = HRStringUtils.isEmpty((String)taskNo) ? LabelPolicyServiceHelper.getViewTaskNumber(policyId) : taskNo;
        try {
            logger.info("label result->policy:{},tasknumber:{},selects:{},qfilter:{}", new Object[]{policyId, taskNumber, selects, qFilters});
            List<QFilter> qFilterList = this.qFilterTrans(qFilters);
            for (QFilter filter : qFilterList) {
                filter.clearNests();
            }
            LabelTaskStorageService labelTaskStorageService = new LabelTaskStorageService(policyId, taskNumber);
            resultList = labelTaskStorageService.getResultList(selects, qFilterList, pageIndex, pageSize);
            logger.info("label result->resultList:{}", resultList);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return resultList;
        }
        return resultList;
    }

    private List<QFilter> qFilterTrans(List<QFilter> qFilters) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (qFilters == null || qFilters.isEmpty()) {
            return list;
        }
        QFilter qFilter = qFilters.get(0);
        list.add(qFilter);
        while (!qFilter.getNests(true).isEmpty()) {
            qFilter = ((QFilter.QFilterNest)qFilter.getNests(true).get(0)).getFilter();
            list.add(qFilter);
        }
        return list;
    }

    public int countResult(long policyId, List<QFilter> qFilters) {
        int result = 0;
        DynamicObject labelPolicyDyn = labelPolicyServiceHelper.getPolicy(policyId);
        if (labelPolicyDyn == null) {
            return result;
        }
        String taskNumber = "1".equals(labelPolicyDyn.getString("worktype")) ? "hand" : LabelPolicyServiceHelper.getViewTaskNumber(policyId);
        try {
            LabelTaskStorageService labelTaskStorageService = new LabelTaskStorageService(policyId, taskNumber);
            result = labelTaskStorageService.getCount(qFilters);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return result;
        }
        return result;
    }

    public List<Long> listLabelValueByLabelIdList(List<Long> labelIdList) {
        return Arrays.stream(labelValueServiceHelper.query(new QFilter[]{new QFilter("label", "in", labelIdList)})).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    public Map<String, Object> createBrmScene(DynamicObject label, long objectId, String objectName, List<Map<String, Object>> inputMaps, List<Map<String, Object>> outputMaps) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        long labelId = label.getLong("id");
        String sceneName = this.geneSceneName(label.getString("name"), objectName);
        requestMap.put("name", sceneName);
        requestMap.put("number", LABEL_PREFIX + labelId + "_" + objectId);
        requestMap.put("bizappid", HRCS_BIZAPP);
        requestMap.put("description", "");
        requestMap.put("status", "C");
        requestMap.put("inputparams", inputMaps);
        requestMap.put("outputparams", outputMaps);
        requestMap.put("iseditscene", Boolean.FALSE.toString());
        requestMap.put("iseditrule", Boolean.FALSE.toString());
        return (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMSceneService", (String)"addScene", (Object[])new Object[]{requestMap});
    }

    public String geneTargetName(String labelName, String objectName, String labelValueName) {
        String targetName = LABEL_PREFIX + labelName + "_" + objectName + "_" + labelValueName;
        if (targetName.length() > 50) {
            String targetPrefix = LABEL_PREFIX + labelName + "_" + objectName;
            targetPrefix = targetPrefix.substring(0, 50 - labelValueName.length() - 1);
            targetName = targetPrefix + "_" + labelValueName;
        }
        return targetName;
    }

    private String geneSceneName(String labelName, String objectName) {
        String sceneName = LABEL_PREFIX + labelName + "_" + objectName;
        if (sceneName.length() > 50) {
            sceneName = sceneName.substring(0, 50);
        }
        return sceneName;
    }

    public Map<String, Object> updateBrmScene(Long sceneId, String objectName, DynamicObject label, List<Map<String, Object>> inputMaps, List<Map<String, Object>> outputMaps) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        String sceneName = this.geneSceneName(label.getString("name"), objectName);
        requestMap.put("name", sceneName);
        requestMap.put("bizappid", HRCS_BIZAPP);
        requestMap.put("description", "");
        requestMap.put("id", sceneId);
        requestMap.put("status", "C");
        requestMap.put("inputparams", inputMaps);
        requestMap.put("outputparams", outputMaps);
        return (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMSceneService", (String)"modifyScene", (Object[])new Object[]{requestMap});
    }

    public Map<String, Object> deleteBrmScene(List<Long> sceneIds) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMSceneService", (String)"deleteScene", (Object[])new Object[]{sceneIds});
    }

    private Map<String, Object> createBrmTarget(String name, String number, String expression, String analysisExpression, Long brmSceneId) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("bu", OrgServiceUtil.getHRRootOrgId());
        requestMap.put("name", name);
        requestMap.put("number", number);
        requestMap.put("bizapp", HRCS_BIZAPP);
        requestMap.put("scene", brmSceneId);
        requestMap.put("returntype", "string");
        requestMap.put("status", "C");
        requestMap.put("enable", "1");
        requestMap.put("targettypegroup", "function");
        requestMap.put("displayfunctiontext", expression);
        requestMap.put("conditions", analysisExpression);
        return (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMTargetService", (String)"addTarget", (Object[])new Object[]{requestMap});
    }

    public Map<String, Object> updateBrmTarget(long targetId, String name, String number, String expression, String analysisExpression, Long brmSceneId, String status) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("id", targetId);
        requestMap.put("bu", OrgServiceUtil.getHRRootOrgId());
        requestMap.put("name", name);
        requestMap.put("number", number);
        requestMap.put("bizapp", HRCS_BIZAPP);
        requestMap.put("scene", brmSceneId);
        requestMap.put("returntype", "string");
        requestMap.put("enable", "1");
        requestMap.put("status", status);
        requestMap.put("targettypegroup", "function");
        requestMap.put("displayfunctiontext", expression);
        requestMap.put("conditions", analysisExpression);
        return (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMTargetService", (String)"modifyTarget", (Object[])new Object[]{requestMap});
    }

    private Map<String, Object> deleteBrmTarget(List<Long> targetIdList) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMTargetService", (String)"deleteTarget", (Object[])new Object[]{targetIdList});
    }

    public void addLabelValueRule(DynamicObjectCollection labelValueCol, DynamicObject label, Map<Integer, Map<String, Map<String, Object>>> groupExprMap, Map<Long, List<Map<String, Object>>> addParamMap) {
        long labelId = label.getLong("id");
        DynamicObjectCollection labelValueRuleCollection = new DynamicObjectCollection();
        DynamicObjectCollection labelParamCollection = new DynamicObjectCollection();
        DynamicObjectCollection range = label.getDynamicObjectCollection("entryentityrange");
        Map<Long, Map<String, Long>> inputParamMap = this.getInputParamMap(range);
        HashMap successSceneIdMap = Maps.newHashMapWithExpectedSize((int)labelValueCol.size());
        ArrayList successTargetIdList = Lists.newArrayListWithExpectedSize((int)labelValueCol.size());
        for (int i = 0; i < labelValueCol.size(); ++i) {
            DynamicObject newLabelValue = (DynamicObject)labelValueCol.get(i);
            long labelValueId = newLabelValue.getLong("id");
            Map<String, Map<String, Object>> exprMap = groupExprMap.get(i);
            for (DynamicObject row : range) {
                Map<String, Object> brmTargetResult;
                DynamicObject object = row.getDynamicObject("labelobject");
                String objectName = object.getString("name");
                long objectId = object.getLong("id");
                long brmSceneId = this.getSceneId(row);
                successSceneIdMap.put(objectId, Pair.of((Object)brmSceneId, (Object)objectName));
                Map<String, Object> value = exprMap.get(objectId + "");
                try {
                    brmTargetResult = this.createBrmTarget(this.geneTargetName(label.getString("name"), objectName, newLabelValue.getString("labelvalue")), LABEL_PREFIX + brmSceneId + "_" + labelValueId, (String)value.get("displayfunctiontext"), (String)value.get("expr"), brmSceneId);
                }
                catch (Exception e) {
                    this.rollBackByTarget(addParamMap, successSceneIdMap, label, inputParamMap, successTargetIdList);
                    throw new KDBizException(e.getMessage());
                }
                if ("200".equals(brmTargetResult.get("resultCode").toString())) {
                    Long targetId = (Long)brmTargetResult.get("targetId");
                    successTargetIdList.add(targetId);
                    DynamicObject labelValueRule = labelValueRuleServiceHelper.generateEmptyDynamicObject();
                    labelValueRule.set("brmtarget", (Object)targetId);
                    labelValueRule.set("labelvalue", (Object)newLabelValue.getLong("id"));
                    labelValueRule.set("labelobject", (Object)objectId);
                    labelValueRuleCollection.add((Object)labelValueRule);
                    Set<Long> selectField = this.getSelectField(value);
                    labelParamCollection.addAll((Collection)this.fullLabelParam(labelId, labelValueId, objectId, brmSceneId, selectField));
                    continue;
                }
                this.rollBackByTarget(addParamMap, successSceneIdMap, label, inputParamMap, successTargetIdList);
                throw new KDBizException(brmTargetResult.get("errorMsg").toString());
            }
        }
        labelValueRuleServiceHelper.save(labelValueRuleCollection);
        labelParamServiceHelper.save(labelParamCollection);
    }

    public void updateLabelValueRule(DynamicObjectCollection updateLabelValueCol, DynamicObject label, Map<Integer, Map<String, Map<String, Object>>> groupExprMap, Map<Long, List<Map<String, Object>>> addParamMap) {
        long labelId = label.getLong("id");
        DynamicObjectCollection range = label.getDynamicObjectCollection("entryentityrange");
        DynamicObjectCollection labelParamCollection = new DynamicObjectCollection();
        DynamicObjectCollection addLabelValueRuleCollection = new DynamicObjectCollection();
        DynamicObjectCollection updateLabelValueRuleCollection = new DynamicObjectCollection();
        ArrayList lblValueIdList = Lists.newArrayListWithExpectedSize((int)updateLabelValueCol.size());
        for (DynamicObject dynamicObject : updateLabelValueCol) {
            lblValueIdList.add(dynamicObject.getLong("id"));
        }
        DynamicObject[] rulesByLabelValue = this.getRulesByLabelValue(lblValueIdList);
        Map<Long, List<DynamicObject>> lblVRGroupMap = Arrays.stream(rulesByLabelValue).collect(Collectors.groupingBy(target -> target.getLong("labelvalue.id")));
        Map<Long, Map<String, Long>> inputParamMap = this.getInputParamMap(range);
        HashMap successSceneIdMap = Maps.newHashMapWithExpectedSize((int)updateLabelValueCol.size());
        ArrayList successTargetIdList = Lists.newArrayListWithExpectedSize((int)updateLabelValueCol.size());
        for (int i = 0; i < updateLabelValueCol.size(); ++i) {
            DynamicObject updateLabelValue = (DynamicObject)updateLabelValueCol.get(i);
            String labelValueStr = updateLabelValue.getString("labelvalue");
            long labelValueId = updateLabelValue.getLong("id");
            List<DynamicObject> lblVRList = lblVRGroupMap.get(labelValueId);
            Map<Object, Object> lblObjGroupVR = lblVRList == null ? Maps.newHashMapWithExpectedSize((int)1) : lblVRList.stream().collect(Collectors.toMap(lv -> lv.getLong("labelobject.id"), lv -> lv));
            Map<String, Map<String, Object>> exprMap = groupExprMap.get(i);
            for (DynamicObject row : range) {
                Map<String, Object> brmTargetResult;
                DynamicObject object = row.getDynamicObject("labelobject");
                long objectId = object.getLong("id");
                String objectName = object.getString("name");
                long brmSceneId = this.getSceneId(row);
                successSceneIdMap.put(objectId, Pair.of((Object)brmSceneId, (Object)objectName));
                Map<String, Object> resultMap = exprMap.get(objectId + "");
                String displayExpr = (String)resultMap.get("displayfunctiontext");
                String expr = (String)resultMap.get("expr");
                DynamicObject vr = (DynamicObject)lblObjGroupVR.get(objectId);
                if (vr == null || vr.getLong("brmtarget.id") == 0L) {
                    try {
                        brmTargetResult = this.createBrmTarget(this.geneTargetName(label.getString("name"), objectName, updateLabelValue.getString("labelvalue")), LABEL_PREFIX + brmSceneId + "_" + labelValueId, displayExpr, expr, brmSceneId);
                    }
                    catch (Exception e) {
                        this.rollBackByTarget(addParamMap, successSceneIdMap, label, inputParamMap, successTargetIdList);
                        throw new KDBizException(e.getMessage());
                    }
                    Long targetId = (Long)brmTargetResult.get("targetId");
                    successTargetIdList.add(targetId);
                    if (vr == null) {
                        DynamicObject labelValueRule = labelValueRuleServiceHelper.generateEmptyDynamicObject();
                        labelValueRule.set("brmtarget", (Object)targetId);
                        labelValueRule.set("labelvalue", (Object)labelValueId);
                        labelValueRule.set("labelobject", (Object)objectId);
                        addLabelValueRuleCollection.add((Object)labelValueRule);
                    } else {
                        vr.set("brmtarget", (Object)targetId);
                        vr.set("service", null);
                        updateLabelValueRuleCollection.add((Object)vr);
                    }
                } else {
                    try {
                        brmTargetResult = this.updateBrmTarget(vr.getLong("brmtarget.id"), this.geneTargetName(label.getString("name"), objectName, labelValueStr), LABEL_PREFIX + brmSceneId + "_" + labelValueId, displayExpr, expr, brmSceneId, label.getString("status"));
                    }
                    catch (Exception e) {
                        this.rollBackByTarget(addParamMap, successSceneIdMap, label, inputParamMap, successTargetIdList);
                        throw new KDBizException(e.getMessage());
                    }
                }
                if (!"200".equals(brmTargetResult.get("resultCode").toString())) {
                    this.rollBackByTarget(addParamMap, successSceneIdMap, label, inputParamMap, successTargetIdList);
                    throw new KDBizException(brmTargetResult.get("errorMsg").toString());
                }
                QFilter labelFilter = new QFilter("label", "=", (Object)labelId);
                QFilter labelValueFilter = new QFilter("labelvalue", "=", (Object)labelValueId);
                QFilter objectFilter = new QFilter("labelobject", "=", (Object)objectId);
                QFilter sourceFilter = new QFilter("source", "=", (Object)"10");
                LblHelperConstants.labelParamServiceHelper.deleteByFilter(new QFilter[]{labelFilter, labelValueFilter, objectFilter, sourceFilter});
                Set<Long> selectField = this.getSelectField(resultMap);
                labelParamCollection.addAll((Collection)this.fullLabelParam(labelId, labelValueId, objectId, brmSceneId, selectField));
            }
        }
        labelValueRuleServiceHelper.save(addLabelValueRuleCollection);
        labelValueRuleServiceHelper.save(updateLabelValueRuleCollection);
        labelParamServiceHelper.save(labelParamCollection);
    }

    private List<Map<String, Object>> getInputParamMaps(Set<Long> SelectedParam, Set<Long> paramSetFromDB) {
        ArrayList newFieldIdList = Lists.newArrayListWithExpectedSize((int)SelectedParam.size());
        for (Long fieldId : SelectedParam) {
            if (paramSetFromDB.contains(fieldId)) continue;
            newFieldIdList.add(fieldId);
        }
        DynamicObject[] fields = objectFiledServiceHelper.loadDynamicObjectArray(newFieldIdList.toArray());
        ArrayList inputList = Lists.newArrayListWithExpectedSize((int)fields.length);
        for (DynamicObject field : fields) {
            inputList.add(this.labelService.buildBrmSceneParamMap(field, true));
        }
        return inputList;
    }

    private List<Map<String, Object>> geneAddBrmSceneInputParam(long labelId, long objectId, Set<Long> selectFieldSet) {
        DynamicObject[] paramsByUniqueIds = this.getParamsByUniqueIds(labelId, objectId, "10");
        HashSet<Long> paramSetFromDb = new HashSet<Long>(16);
        for (DynamicObject params : paramsByUniqueIds) {
            paramSetFromDb.add(params.getLong("param.id"));
        }
        return this.getInputParamMaps(selectFieldSet, paramSetFromDb);
    }

    private List<Map<String, Object>> geneDelBrmSceneInputParam(long labelId, long objectId, Set<Long> selectFieldSet) {
        DynamicObject[] paramsByUniqueIds;
        ArrayList<Map<String, Object>> inputList = new ArrayList<Map<String, Object>>();
        for (DynamicObject params : paramsByUniqueIds = this.getParamsByUniqueIds(labelId, objectId, "10")) {
            long fieldId = params.getLong("param.id");
            if (selectFieldSet.contains(fieldId)) continue;
            DynamicObject paramDy = objectFiledServiceHelper.loadSingle((Object)fieldId);
            String paramId = paramDy.getString("id");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", params.getLong("brmiputparam.id"));
            map.put("inputnumber", "pl" + paramId);
            map.put("modifystatus", "delete");
            inputList.add(map);
        }
        return inputList;
    }

    private DynamicObjectCollection fullLabelParam(Long labelId, Long labelValueId, Long labelObjectId, long brmSceneId, Set<Long> selectField) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        DynamicObject brmScene = sceneServiceHelper.loadSingle((Object)brmSceneId);
        DynamicObjectCollection sceneInputParams = brmScene.getDynamicObjectCollection("sceneinputparams");
        Map<String, DynamicObject> inputParamMap = sceneInputParams.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("inputnumber"), dy -> dy));
        for (Long fieldId : selectField) {
            DynamicObject labelParam = labelParamServiceHelper.generateEmptyDynamicObject();
            labelParam.set("param", (Object)fieldId);
            labelParam.set("label", (Object)labelId);
            labelParam.set("labelvalue", (Object)labelValueId);
            labelParam.set("labelobject", (Object)labelObjectId);
            labelParam.set("brmscene", (Object)brmSceneId);
            labelParam.set("brmiputparam", (Object)inputParamMap.get("pl" + fieldId).getLong("id"));
            labelParam.set("source", (Object)"10");
            dynamicObjectCollection.add((Object)labelParam);
        }
        return dynamicObjectCollection;
    }

    public Long getLabelId() {
        return ORM.create().genLongId(LABEL_ENTITY);
    }

    public DynamicObject[] listLabelStrategyList(Long labelId) {
        QFilter qFilter = new QFilter("label", "=", (Object)labelId);
        return strategyServiceHelper.query(new QFilter[]{qFilter});
    }

    public List<DynamicObject> listLabelValueRuleByLabelValueId(Long labelValueId) {
        return Arrays.asList(labelValueRuleServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("labelvalue", "=", (Object)labelValueId)}));
    }

    public void deleteLabelParam(List<Long> labelIdList) {
        QFilter qFilter = new QFilter("label", "in", labelIdList);
        QFilter sourceFilter = new QFilter("source", "=", (Object)"10");
        labelParamServiceHelper.deleteByFilter(new QFilter[]{qFilter, sourceFilter});
    }

    @ExcludeFromJacocoGeneratedReport
    public void deleteTargetAndScene(List<Map<String, Long>> deleteInfoList) {
        if (deleteInfoList.isEmpty()) {
            return;
        }
        ArrayList targetIdList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList deleteSceneList = Lists.newArrayListWithExpectedSize((int)deleteInfoList.size());
        ArrayList labelObjectIdList = Lists.newArrayListWithExpectedSize((int)deleteInfoList.size());
        ArrayList labelIdList = Lists.newArrayListWithExpectedSize((int)deleteInfoList.size());
        if (!CollectionUtils.isEmpty(deleteInfoList)) {
            deleteInfoList.forEach(deleteInfo -> {
                labelIdList.add(deleteInfo.get("label"));
                labelObjectIdList.add(deleteInfo.get("labelobject"));
                deleteSceneList.add(deleteInfo.get("scene"));
            });
            targetIdList.addAll(this.listTargetByLabelIdAndObjectId(labelIdList, labelObjectIdList));
        }
        if (targetIdList.isEmpty()) {
            Map<String, Object> sceneMap = this.deleteBrmScene(deleteSceneList);
            if (!"200".equals(sceneMap.get("resultCode").toString())) {
                throw new KDBizException(sceneMap.get("errorMsg").toString());
            }
        } else {
            Map<String, Object> map = this.deleteBrmTarget(targetIdList);
            if ("200".equals(map.get("resultCode").toString())) {
                Map<String, Object> sceneMap = this.deleteBrmScene(deleteSceneList);
                if (!"200".equals(sceneMap.get("resultCode").toString())) {
                    throw new KDBizException(sceneMap.get("errorMsg").toString());
                }
                this.deleteRuleAndParam(labelObjectIdList, labelIdList);
            } else {
                throw new KDBizException(map.get("errorMsg").toString());
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void deleteLabelValueAndRule(List<Long> labelIdList) {
        Map<String, Object> map;
        QFilter qFilter = new QFilter("label", "in", labelIdList);
        List<Long> targetList = this.listTargetByLabelIdList(labelIdList);
        List<Long> labelValueIdList = this.listLabelValueByLabelIdList(labelIdList);
        labelValueServiceHelper.deleteByFilter(new QFilter[]{qFilter});
        QFilter labelValueIdFilter = new QFilter("labelvalue", "in", labelValueIdList);
        labelValueRuleServiceHelper.deleteByFilter(new QFilter[]{labelValueIdFilter});
        if (!CollectionUtils.isEmpty(targetList) && (map = this.deleteBrmTarget(targetList)) != null && !"200".equals(map.get("resultCode").toString())) {
            throw new KDBizException(map.get("errorMsg").toString());
        }
    }

    private DynamicObject[] getRules(List<Long> lblObjIdList) {
        return labelValueRuleServiceHelper.query("id,labelvalue", new QFilter[]{new QFilter("labelobject", "in", lblObjIdList)});
    }

    public DynamicObject[] getRulesByLabelValue(List<Long> lblValueIdList) {
        return labelValueRuleServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("labelvalue", "in", lblValueIdList)});
    }

    public DynamicObject[] getRulesByLabelAndLabelObject(Long labelId, Long labelObjectId) {
        ArrayList<Long> labelIdList = new ArrayList<Long>();
        labelIdList.add(labelId);
        List<Long> lblValueIdList = this.listLabelValueByLabelIdList(labelIdList);
        return labelValueRuleServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("labelvalue", "in", lblValueIdList), new QFilter("labelobject", "=", (Object)labelObjectId)});
    }

    private DynamicObject[] getParams(List<Long> lblObjIdList) {
        return labelParamServiceHelper.query("id,labelvalue", new QFilter[]{new QFilter("labelobject", "in", lblObjIdList), new QFilter("source", "=", (Object)"10")});
    }

    private DynamicObject[] getParamsByLabelValue(List<Long> lblValueIdList) {
        return labelParamServiceHelper.query("id,labelvalue,brmscene,brmscene.name,brmiputparam,brmiputparam.number", new QFilter[]{new QFilter("labelvalue", "in", lblValueIdList), new QFilter("source", "=", (Object)"10")});
    }

    private DynamicObject[] getParamsByLabel(Long lblId) {
        return labelParamServiceHelper.query("id,labelvalue,brmscene,brmscene.name,brmiputparam,brmiputparam.number", new QFilter[]{new QFilter("label", "=", (Object)lblId), new QFilter("source", "=", (Object)"10")});
    }

    public DynamicObject[] getLabelsByLabelObjects(List<Long> labelObjectIds) {
        QFilter[] filters = new QFilter[]{new QFilter("entryentityrange.labelobject.id", "in", labelObjectIds)};
        return labelEntryServiceHelper.query("id,number,name,status,enable,group,group.id,group.name,group.number,description,entryentityrange,entryentityrange.labelobject,entryentityrange.labelobject.id,type,entryentitylabelvalue.labelvalue,entryentitylabelvalue.labelvalue,entryentitylabelvalue.labelvaluedesc", filters, "group.index ,group.createtime desc,createtime desc,id,entryentitylabelvalue.seq asc");
    }

    public int getLabelsCount(String enable, String status, Map<String, Object> filters) {
        List<QFilter> filterList = this.getQFilterList(enable, status, filters);
        return labelEntryServiceHelper.count(LABEL_ENTITY, filterList.toArray(new QFilter[0]));
    }

    public DynamicObject[] getLabels(String enable, String status, Map<String, Object> filters, int start, int pageSize) {
        List<QFilter> filterList = this.getQFilterList(enable, status, filters);
        int top = (pageSize > 10000 ? 10000 : pageSize) + start;
        DynamicObject[] result = labelEntryServiceHelper.query("id,number,name,status,enable,group,group.id,group.name,group.number,description,entryentityrange,entryentityrange.labelobject,entryentityrange.labelobject.id,type,entryentitylabelvalue.labelvalue,entryentitylabelvalue.labelvalue,entryentitylabelvalue.labelvaluedesc", filterList.toArray(new QFilter[0]), "group.index ,group.createtime desc,createtime desc, id,entryentitylabelvalue.seq asc", top);
        if (result.length > start) {
            return Arrays.copyOfRange(result, start, result.length);
        }
        return null;
    }

    private List<QFilter> getQFilterList(String enable, String status, Map<String, Object> filters) {
        String[] values;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (enable != null && !"".equals(enable)) {
            values = enable.split(";");
            filterList.add(new QFilter("enable", "in", (Object)values));
        }
        if (status != null && !"".equals(status)) {
            values = status.split(";");
            filterList.add(new QFilter("status", "in", (Object)values));
        }
        if (filters != null) {
            for (Map.Entry<String, Object> entry : filters.entrySet()) {
                if ("labelIds".equalsIgnoreCase(entry.getKey())) {
                    filterList.add(new QFilter("id", "in", entry.getValue()));
                    continue;
                }
                if ("labelObjects".equalsIgnoreCase(entry.getKey())) {
                    filterList.add(new QFilter("entryentityrange.labelobject.id", "in", entry.getValue()));
                    continue;
                }
                if ("labelGroups".equalsIgnoreCase(entry.getKey())) {
                    filterList.add(new QFilter("group.id", "in", entry.getValue()));
                    continue;
                }
                if (!"labelTypes".equalsIgnoreCase(entry.getKey()) || entry.getValue() == null || "".equals(entry.getValue())) continue;
                filterList.add(new QFilter("type", "in", (Object)entry.getValue().toString().split(";")));
            }
        }
        return filterList;
    }

    private static DynamicObject[] getParamsByScene(Long sceneId) {
        return labelParamServiceHelper.query("id,labelvalue,labelobject,param,param.valuetype,brmscene", new QFilter[]{new QFilter("brmscene", "=", (Object)sceneId), new QFilter("source", "=", (Object)"10")});
    }

    @ExcludeFromJacocoGeneratedReport
    private void deleteRuleAndParam(List<Long> labelObjectIdList, List<Long> labelIdList) {
        DynamicObject[] rules = this.getRules(labelObjectIdList);
        DynamicObject[] params = this.getParams(labelObjectIdList);
        List<Long> labelValueIdList = this.listLabelValueByLabelIdList(labelIdList);
        Object[] ruleIds = Arrays.stream(rules).filter(rule -> labelValueIdList.contains(rule.getLong("labelvalue.id"))).map(rule -> rule.getLong("id")).toArray();
        Object[] paramIds = Arrays.stream(params).filter(param -> labelValueIdList.contains(param.getLong("labelvalue.id"))).map(param -> param.getLong("id")).toArray();
        labelValueRuleServiceHelper.delete(ruleIds);
        labelParamServiceHelper.delete(paramIds);
    }

    public DynamicObject[] listTargetByLabelValueIdListAndObjectId(List<Long> labelValueIdList, List<Long> objectIdList) {
        QFilter qFilter = new QFilter("labelvalue", "in", labelValueIdList);
        QFilter qFilterObject = new QFilter("labelobject", "in", objectIdList);
        return labelValueRuleServiceHelper.query("brmtarget", new QFilter[]{qFilter, qFilterObject});
    }

    public DynamicObject[] listVRByLabelValueIdAndObjectIdList(Long labelValueId, List<Long> objectIdList) {
        QFilter qFilter = new QFilter("labelvalue", "=", (Object)labelValueId);
        QFilter qFilterObject = new QFilter("labelobject", "in", objectIdList);
        return labelValueRuleServiceHelper.query("brmtarget,labelobject,labelvalue", new QFilter[]{qFilter, qFilterObject});
    }

    public List<Long> listTargetByLabelIdAndObjectId(List<Long> labelIdList, List<Long> objectIdList) {
        List<Long> labelValueIdList = this.listLabelValueByLabelIdList(labelIdList);
        DynamicObject[] targetDyArr = this.listTargetByLabelValueIdListAndObjectId(labelValueIdList, objectIdList);
        ArrayList targetIdList = Lists.newArrayListWithExpectedSize((int)targetDyArr.length);
        for (DynamicObject dynamicObject : targetDyArr) {
            long targetId = dynamicObject.getLong("brmtarget.id");
            if (targetId == 0L) continue;
            targetIdList.add(targetId);
        }
        return targetIdList;
    }

    private DynamicObject[] getTargetByLabelValueId(Long labelValueId) {
        QFilter qFilter = new QFilter("labelvalue", "=", (Object)labelValueId);
        return labelValueRuleServiceHelper.query("brmtarget,labelobject", new QFilter[]{qFilter});
    }

    public List<Long> listTargetByLabelIdList(List<Long> labelIdList) {
        ArrayList<Long> targetList = new ArrayList<Long>();
        QFilter qFilter = new QFilter("label", "in", labelIdList);
        DynamicObject[] labelValueArr = labelValueServiceHelper.query(new QFilter[]{qFilter});
        if (labelValueArr == null || labelValueArr.length == 0) {
            return targetList;
        }
        List labelValueIdList = Arrays.stream(labelValueArr).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        QFilter qFilterRule = new QFilter("labelvalue", "in", labelValueIdList);
        DynamicObject[] brmTargets = labelValueRuleServiceHelper.query("brmtarget", new QFilter[]{qFilterRule});
        if (brmTargets == null || brmTargets.length == 0) {
            return targetList;
        }
        return Arrays.stream(brmTargets).filter(dynamicObject -> dynamicObject.getLong("brmtarget_id") != 0L).map(dynamicObject -> dynamicObject.getLong("brmtarget_id")).collect(Collectors.toList());
    }

    public List<Long> listBrmSceneByLabelIdList(List<Long> labelIdList) {
        QFilter labelFilter = new QFilter("label", "in", labelIdList);
        DynamicObject[] brmSceneArr = labelObjectRelServiceHelper.query("brmscene", new QFilter[]{labelFilter});
        if (brmSceneArr == null || brmSceneArr.length == 0) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(brmSceneArr).map(dynamicObject -> dynamicObject.getLong("brmscene_id")).collect(Collectors.toList());
    }

    public boolean labelHaveFinishPolicyTask(Long labelId) {
        DynamicObject[] strategyList = this.listLabelStrategyList(labelId);
        if (strategyList == null || strategyList.length == 0) {
            return false;
        }
        List policyIdList = Arrays.stream(strategyList).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        QFilter policy = new QFilter("labelpolicy", "in", policyIdList);
        DynamicObject[] result = policyTaskServiceHelper.query("id", new QFilter[]{policy});
        return result != null && result.length != 0;
    }

    public boolean isExistStrategy(Long labelId, List<Long> lblObjIds) {
        QFilter label = new QFilter("label", "=", (Object)labelId);
        QFilter lblObj = new QFilter("labelobject", "in", lblObjIds);
        return strategyServiceHelper.isExists(new QFilter[]{label, lblObj});
    }

    public DynamicObject[] getParamsByUniqueIds(long labelId, long objectId, String sourceCode) {
        QFilter labelFilter = new QFilter("label", "=", (Object)labelId);
        QFilter objectFilter = new QFilter("labelobject", "=", (Object)objectId);
        QFilter sourceFilter = new QFilter("source", "=", (Object)sourceCode);
        return labelParamServiceHelper.query("param.fieldname,brmiputparam", new QFilter[]{labelFilter, objectFilter, sourceFilter});
    }

    public DynamicObjectCollection listLabelShowDy(Long objectId) {
        DynamicObject dynamicObject = objectConfigServiceHelper.loadDynamicObject(new QFilter[]{new QFilter("labelobjectid", "=", (Object)objectId)});
        if (dynamicObject == null) {
            return new DynamicObjectCollection();
        }
        return dynamicObject.getDynamicObjectCollection("displayentryentity");
    }

    public Map<String, Map<String, Map<String, Object>>> getGroupExprMap(Long labelId) {
        DynamicObject[] labelRel = this.getLabelObjectRelCollection(labelId);
        Map<Long, Long> sceneIdMap = Arrays.stream(labelRel).collect(Collectors.toMap(rel -> rel.getLong("labelobject.id"), rel -> rel.getLong("brmscene.id")));
        HashMap groupExprMap = Maps.newHashMapWithExpectedSize((int)labelRel.length);
        DynamicObject[] labelValues = this.getLabelValueCollection(labelId);
        for (int i = 0; i < labelValues.length; ++i) {
            DynamicObject labelValue = labelValues[i];
            List<DynamicObject> lblVRList = this.listLabelValueRuleByLabelValueId(labelValue.getLong("id"));
            FunctionSubPageService functionSubPageService = new FunctionSubPageService();
            HashMap exprMap = Maps.newHashMapWithExpectedSize((int)labelValues.length);
            for (DynamicObject lblVR : lblVRList) {
                long lblObjId = lblVR.getLong("labelobject.id");
                Long sceneId = sceneIdMap.get(lblObjId);
                StringBuilder errMsg = new StringBuilder();
                String exprParsed = lblVR.getString("brmtarget.conditions");
                List<Map<String, Object>> fieldList = LabelServiceHelper.getFieldList(lblObjId, sceneId);
                exprParsed = functionSubPageService.replaceFieldName(exprParsed, fieldList);
                Map resultMap = functionSubPageService.parseFunctionExpr(errMsg, exprParsed, SerializationUtils.toJsonString(LabelServiceHelper.getFieldMap(fieldList)));
                if (errMsg.length() != 0) {
                    LOGGER.error("parseFunctionExpr_error:{}", (Object)errMsg.toString());
                    continue;
                }
                exprParsed = exprParsed.replaceAll("\\[", "").replaceAll("]", "");
                resultMap.put("displayfunctiontext", exprParsed);
                exprMap.put(lblObjId + "", resultMap);
            }
            groupExprMap.put(i + "", exprMap);
        }
        return groupExprMap;
    }

    public static List<Map<String, Object>> getFieldList(Long lblObjId, Long sceneId) {
        DynamicObject[] fields = LabelObjectServiceHelper.getFields(lblObjId);
        ArrayList fieldMapList = Lists.newArrayListWithExpectedSize((int)fields.length);
        HashSet inputParamSet = Sets.newHashSetWithExpectedSize((int)fields.length);
        if (sceneId != null && sceneId != 0L) {
            Map<Long, String> typeMap = LabelServiceHelper.getTypeMap(sceneId);
            List inputParamData = ParamsUtil.getInputParamData((Long)sceneId);
            inputParamData.forEach(ip -> {
                String number = (String)ip.get("number");
                Optional<Long> first = typeMap.keySet().stream().filter(fieldId -> number.contains(fieldId.toString())).findFirst();
                if (number.startsWith("pl") && first.isPresent()) {
                    String type = (String)typeMap.get(first.get());
                    fieldMapList.add(LabelServiceHelper.buildFieldMap((String)ip.get("number"), (ILocaleString)new LocaleString((String)ip.get("name")), type));
                    inputParamSet.add(ip.get("number"));
                }
            });
        }
        for (DynamicObject field : fields) {
            String number = "pl" + field.getLong("id");
            boolean hasAdd = false;
            for (String ip2 : inputParamSet) {
                if (!ip2.contains(number)) continue;
                hasAdd = true;
                break;
            }
            if (hasAdd) continue;
            ILocaleString name = field.getLocaleString("fieldname");
            String type = field.getString("valuetype");
            fieldMapList.add(LabelServiceHelper.buildFieldMap(number, name, type));
        }
        return fieldMapList;
    }

    private static Map<Long, String> getTypeMap(Long sceneId) {
        DynamicObject[] paramsByScene = LabelServiceHelper.getParamsByScene(sceneId);
        HashMap typeMap = Maps.newHashMapWithExpectedSize((int)paramsByScene.length);
        for (DynamicObject param : paramsByScene) {
            typeMap.put(param.getLong("param.id"), param.getString("param.valuetype"));
        }
        return typeMap;
    }

    private static Map<String, String> getFieldMap(List<Map<String, Object>> fieldList) {
        HashMap fieldsMap = Maps.newHashMapWithExpectedSize((int)fieldList.size());
        for (Map<String, Object> map : fieldList) {
            String name = ((ILocaleString)map.get("fieldName")).getLocaleValue();
            String number = (String)map.get("fieldNumber");
            fieldsMap.put("[" + name + "]", number);
        }
        return fieldsMap;
    }

    private static Map<String, Object> buildFieldMap(String number, ILocaleString name, String type) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("fieldNumber", number);
        map.put("fieldName", name);
        map.put("valueType", type);
        return map;
    }

    private Set<Long> getSelectField(Map<String, Object> resultMap) {
        List refFieldNumSet = (List)resultMap.get("refFieldNums");
        HashSet selectFieldSet = Sets.newHashSetWithExpectedSize((int)refFieldNumSet.size());
        for (String fieldNum : refFieldNumSet) {
            int index = fieldNum.indexOf(46);
            String id = index != -1 ? fieldNum.substring(2, index) : fieldNum.substring(2);
            selectFieldSet.add(Long.parseLong(id));
        }
        return selectFieldSet;
    }

    private Map<Long, Set<Long>> getSelectField(DynamicObjectCollection labelValueCol, Map<String, Map<String, Map<String, Object>>> groupExprMap) {
        HashMap selectFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < labelValueCol.size(); ++i) {
            Map<String, Map<String, Object>> exprMap = groupExprMap.get(i + "");
            exprMap.forEach((key, value) -> {
                Long lblObjId = Long.parseLong(key);
                Set selectFieldSet = (Set)selectFieldMap.get(lblObjId);
                Set<Long> selectField = this.getSelectField((Map<String, Object>)value);
                if (selectFieldSet == null) {
                    selectFieldMap.put(lblObjId, selectField);
                } else {
                    selectFieldSet.addAll(selectField);
                }
            });
        }
        return selectFieldMap;
    }

    private void updateBrmScene(Long brmSceneId, String objectName, DynamicObject label, List<Map<String, Object>> inputMaps) {
        Map<String, Object> brmSceneResult = this.updateBrmScene(brmSceneId, objectName, label, inputMaps, new ArrayList<Map<String, Object>>());
        if (!"200".equals(brmSceneResult.get("resultCode").toString())) {
            throw new KDBizException(brmSceneResult.get("errorMsg").toString());
        }
    }

    private long getSceneId(DynamicObject row) {
        long brmSceneId = row.getLong("brmscene.id");
        if (brmSceneId == 0L) {
            brmSceneId = row.getLong("brmscene");
        }
        return brmSceneId;
    }

    public LabelSaveSceneBO handleScene(DynamicObject label, DynamicObjectCollection entryEntityLabelValue, Map<String, Map<String, Map<String, Object>>> groupExprMap) {
        long labelId = label.getLong("id");
        DynamicObjectCollection range = label.getDynamicObjectCollection("entryentityrange");
        Map<Long, Set<Long>> selectFieldMap = this.getSelectField(entryEntityLabelValue, groupExprMap);
        HashMap delParamMap = Maps.newHashMapWithExpectedSize((int)range.size());
        HashMap addParamMap = Maps.newHashMapWithExpectedSize((int)range.size());
        for (DynamicObject row : range) {
            DynamicObject object = row.getDynamicObject("labelobject");
            if (object == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6253\u6807\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"LabelServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            String objectName = object.getString("name");
            long objectId = object.getLong("id");
            long brmSceneId = this.getSceneId(row);
            ArrayList addParamList = Lists.newArrayListWithExpectedSize((int)entryEntityLabelValue.size());
            ArrayList delParamList = Lists.newArrayListWithExpectedSize((int)entryEntityLabelValue.size());
            Set<Long> selectField = selectFieldMap.get(objectId);
            addParamList.addAll(this.geneAddBrmSceneInputParam(labelId, objectId, selectField));
            delParamList.addAll(this.geneDelBrmSceneInputParam(labelId, objectId, selectField));
            if (!addParamList.isEmpty()) {
                addParamMap.put(objectId, addParamList);
                this.updateBrmScene(brmSceneId, objectName, label, addParamList);
            }
            delParamMap.put(objectId, delParamList);
        }
        return new LabelSaveSceneBO((Map)delParamMap, (Map)addParamMap);
    }

    public void deleteSceneParam(Map<Long, List<Map<String, Object>>> delParamMap, DynamicObject label) {
        DynamicObjectCollection range = label.getDynamicObjectCollection("entryentityrange");
        for (DynamicObject row : range) {
            DynamicObject object = row.getDynamicObject("labelobject");
            long objectId = object.getLong("id");
            String objectName = object.getString("name");
            List<Map<String, Object>> delList = delParamMap.get(objectId);
            long brmSceneId = this.getSceneId(row);
            if (CollectionUtils.isEmpty(delList)) continue;
            this.updateBrmScene(brmSceneId, objectName, label, delList);
        }
    }

    private void rollBackByTarget(Map<Long, List<Map<String, Object>>> addParamMap, Map<Long, Pair<Long, String>> successSceneIdMap, DynamicObject label, Map<Long, Map<String, Long>> inputParamMap, List<Long> successTargetIdList) {
        this.deleteBrmTarget(successTargetIdList);
        for (Map.Entry<Long, Pair<Long, String>> entry : successSceneIdMap.entrySet()) {
            Long objectId = entry.getKey();
            Pair<Long, String> value = entry.getValue();
            List<Map<String, Object>> delList = addParamMap.get(objectId);
            Map<String, Long> inputNumMap = inputParamMap.get(value.getLeft());
            Long brmSceneId = (Long)value.getLeft();
            if (CollectionUtils.isEmpty(delList) || inputNumMap == null) continue;
            int count = 0;
            for (Map<String, Object> map : delList) {
                Long id = inputNumMap.get(map.get("inputnumber"));
                if (id != null) {
                    map.put("id", id);
                    ++count;
                }
                map.put("modifystatus", "delete");
            }
            if (count == inputNumMap.size() && count > 0) {
                this.deleteBrmScene(Lists.newArrayList((Object[])new Long[]{brmSceneId}));
                continue;
            }
            this.updateBrmScene(brmSceneId, (String)value.getRight(), label, delList);
        }
    }

    private Map<Long, Map<String, Long>> getInputParamMap(DynamicObjectCollection range) {
        ArrayList brmSceneIdList = Lists.newArrayListWithExpectedSize((int)range.size());
        for (DynamicObject row : range) {
            long brmSceneId = this.getSceneId(row);
            brmSceneIdList.add(brmSceneId);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("brm_scene");
        DynamicObject[] scenes = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)brmSceneIdList)});
        HashMap inputParamMap = Maps.newHashMapWithExpectedSize((int)scenes.length);
        for (DynamicObject scene : scenes) {
            long sceneId = scene.getLong("id");
            Map inputParamIdMap = inputParamMap.getOrDefault(sceneId, Maps.newHashMapWithExpectedSize((int)6));
            DynamicObjectCollection params = scene.getDynamicObjectCollection("sceneinputparams");
            for (DynamicObject param : params) {
                inputParamIdMap.put(param.getString("inputnumber"), param.getLong("id"));
            }
            inputParamMap.put(sceneId, inputParamIdMap);
        }
        return inputParamMap;
    }
}

