/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.ChoiceFieldPageCustomQueryService;
import kd.hr.hrcs.bussiness.servicehelper.perm.SaveRoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DynamicControlHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import org.apache.commons.collections.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class EntityCtrlViewHelper {
    private static final Log LOGGER = LogFactory.getLog(EntityCtrlViewHelper.class);

    public static void fillEntryentity(IFormView formView) {
        IDataModel model = formView.getModel();
        Map customParams = formView.getFormShowParameter().getCustomParams();
        Long currentDimId = (Long)customParams.get("dimId");
        String mainPageId = (String)customParams.get("mainPageId");
        String currentBuCaFuncId = (String)customParams.get("currentHRbuCaFunc");
        String roleDimRelatStr = (String)customParams.get("roleDimRelat");
        HashSet<String> roleDimRelat = new HashSet(16);
        if (HRStringUtils.isNotEmpty((String)roleDimRelatStr)) {
            roleDimRelat = (Set)SerializationUtils.fromJsonString((String)roleDimRelatStr, Set.class);
        }
        IFormView mainPageView = formView.getView(mainPageId);
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(mainPageView, false);
        LinkedHashMap entityCtrlMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        EntityCtrlViewHelper.prepareData(formView, currentBuCaFuncId, currentDimId, entityCtrlMap, permPageCacheUtil);
        EntityCtrlViewHelper.fillData(formView, model, currentDimId, roleDimRelat, entityCtrlMap);
    }

    private static void fillData(IFormView formView, IDataModel model, Long currentDimId, Set<String> roleDimRelat, Map<String, Map<String, String>> entityCtrlMap) {
        if (entityCtrlMap.isEmpty()) {
            return;
        }
        Map customParams = formView.getFormShowParameter().getCustomParams();
        Boolean parentCard = (Boolean)customParams.get("parentCard");
        String viewStatusStr = (String)customParams.get("viewstatus");
        boolean viewStatus = HRStringUtils.equals((String)"1", (String)viewStatusStr);
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", entityCtrlMap.size());
        List ids = entityCtrlMap.keySet().stream().sorted((o1, o2) -> {
            int o2Code;
            int o1Code = o1.split("#")[2].hashCode();
            if (o1Code > (o2Code = o2.split("#")[2].hashCode())) {
                return -1;
            }
            if (o1Code < o2Code) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
        int index = 0;
        for (String key : ids) {
            String[] keyArray = key.split("#");
            Map<String, String> dimEntry = entityCtrlMap.get(key);
            boolean enableRow = !viewStatus && !"1".equals(dimEntry.get("ismust"));
            String app = dimEntry.get("app");
            Long[] crossOt = HRStringUtils.isEmpty((String)dimEntry.get("crossot")) ? new Long[]{} : (Long[])Arrays.stream(dimEntry.get("crossot").split(",")).map(Long::parseLong).toArray(Long[]::new);
            Long[] structProject = HRStringUtils.isEmpty((String)dimEntry.get("structproject")) ? new Long[]{} : (Long[])Arrays.stream(dimEntry.get("structproject").split(",")).map(Long::parseLong).toArray(Long[]::new);
            model.setValue("entitytype", (Object)keyArray[0], index);
            model.setValue("propname", (Object)dimEntry.get("propname"), index);
            model.setValue("propkey", (Object)dimEntry.get("propkey"), index);
            model.setValue("dimension", (Object)currentDimId, index);
            model.setValue("app", (Object)app, index);
            model.setValue("appbasedata", (Object)app, index);
            model.setValue("ismust", (Object)dimEntry.get("ismust"), index);
            model.setValue("issyspreset", (Object)dimEntry.get("issyspreset"), index);
            model.setValue("enable", (Object)(parentCard != false && !roleDimRelat.contains(app + keyArray[0] + keyArray[1]) ? 1 : 0), index);
            model.setValue("description", (Object)dimEntry.get("description"), index);
            model.setValue("authrange", (Object)dimEntry.get("authrange"), index);
            model.setValue("crossot", (Object)crossOt, index);
            model.setValue("structproject", (Object)structProject, index);
            formView.setEnable(Boolean.valueOf(enableRow), index, new String[]{"enable"});
            ++index;
        }
        model.endInit();
        formView.updateView("entryentity");
    }

    private static void doPrepareData(IFormView formView, String currentBuCaFuncId, Long currentDimId, DynamicObject[] dims, Map<String, Map<String, String>> entityCtrlMap, PermPageCacheUtil permPageCacheUtil, String roleId, List<String> entityCtrlInfos) {
        HashSet roleDimensionIdSet = new HashSet();
        if (HRStringUtils.isNotEmpty((String)roleId)) {
            HRBaseServiceHelper roleDimensionHelper = new HRBaseServiceHelper("hrcs_roledimension");
            roleDimensionIdSet.addAll(Arrays.stream(roleDimensionHelper.query("dimension", new QFilter[]{new QFilter("role", "=", (Object)roleId), new QFilter("bucafunc", "=", (Object)Long.valueOf(currentBuCaFuncId))})).map(it -> it.getLong("dimension.id")).collect(Collectors.toSet()));
        }
        Map<String, Map<String, String>> assignedEntityBuCaFuncMap = permPageCacheUtil.getAssignedEntityBuCaFuncMap();
        HRBaseServiceHelper dynaFormCtrl = new HRBaseServiceHelper("hrcs_dynaformctrl");
        Map<String, Map> structProjectParam = Arrays.stream(dims).collect(Collectors.toMap(dimObj -> dimObj.getString("entitytype.id"), dimObj -> {
            HashMap properKeyMap = new HashMap(16);
            DynamicObjectCollection dimensionColl = dimObj.getDynamicObjectCollection("entryentity");
            List properKeys = dimensionColl.stream().filter(dimensionItem -> {
                if (HRStringUtils.isNotEmpty((String)roleId) && !roleDimensionIdSet.isEmpty() && roleDimensionIdSet.contains(currentDimId)) {
                    return currentDimId.equals(dimensionItem.getLong("dimension.id"));
                }
                return currentDimId.equals(dimensionItem.getLong("dimension.id")) && !SaveRoleServiceHelper.checkDimDisable(dimensionItem);
            }).map(dimensionItem -> dimensionItem.getString("propkey")).collect(Collectors.toList());
            properKeyMap.put("propkey", properKeys);
            String modelType = dimObj.getString("entitytype.modeltype");
            if (HRStringUtils.equals((String)"DynamicFormModel", (String)modelType) || HRStringUtils.equals((String)"ReportFormModel", (String)modelType)) {
                List dataTypes = Arrays.stream(dynaFormCtrl.query("entryentity.propkey,entryentity.bdtype", new QFilter[]{new QFilter("entitytype.id", "=", (Object)dimObj.getString("entitytype.id")), new QFilter("entryentity.propkey", "in", properKeys)})).flatMap(dyItems -> dyItems.getDynamicObjectCollection("entryentity").stream()).filter(dyItem -> properKeys.contains(dyItem.getString("propkey"))).map(dyItem -> dyItem.getString("bdtype.number")).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                properKeyMap.put("baseDataType", dataTypes);
            }
            return properKeyMap;
        }, (oldValue, newValue) -> {
            ArrayList newValues = Lists.newArrayList((Iterable)Iterables.concat((Iterable)oldValue.getOrDefault("propkey", new ArrayList()), (Iterable)newValue.getOrDefault("propkey", new ArrayList())));
            HashMap<String, ArrayList> properKeyMap = new HashMap<String, ArrayList>(16);
            properKeyMap.put("propkey", newValues);
            return properKeyMap;
        }));
        List structProjectInfos = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"batchQueryStructProConfig", (Object[])new Object[]{structProjectParam});
        LOGGER.info("Got struct project params: [{}].", structProjectParam);
        LOGGER.info("Got struct project result: [{}].", (Object)structProjectInfos);
        Map<String, List> structProjectMap = structProjectInfos.stream().collect(Collectors.toMap(it -> it.get("entitytype").toString() + "," + it.get("propkey").toString(), it -> DynamicControlHelper.sortStructProjects(Optional.ofNullable((List)it.get("structproject")).orElseGet(ArrayList::new).stream().filter(sp -> null != sp.get("id")).map(sp -> Long.parseLong(sp.get("id").toString())).collect(Collectors.toSet())).stream().map(dy -> dy.getString("id")).collect(Collectors.toList()), (oldValue, newValue) -> oldValue));
        for (DynamicObject dimObj2 : dims) {
            String entityType = dimObj2.getString("entitytype.id");
            String modelType = dimObj2.getString("entitytype.modeltype");
            boolean isDynamicForm = HRStringUtils.equals((String)modelType, (String)"DynamicFormModel") || HRStringUtils.equals((String)modelType, (String)"ReportFormModel");
            DynamicObjectCollection dimensionColl = dimObj2.getDynamicObjectCollection("entryentity");
            dimensionColl.forEach(dimensionItem -> {
                long dimensionId = dimensionItem.getLong("dimension.id");
                if (!currentDimId.equals(dimensionId)) {
                    return;
                }
                if (SaveRoleServiceHelper.checkDimDisable(dimensionItem) && HRStringUtils.isNotEmpty((String)roleId) && !roleDimensionIdSet.isEmpty() && !roleDimensionIdSet.contains(currentDimId)) {
                    return;
                }
                String propKey = dimensionItem.getString("propkey");
                boolean isMust = dimensionItem.getBoolean("ismust");
                boolean isSysPreSet = dimensionItem.getBoolean("issyspreset");
                String description = dimObj2.getString("description");
                String authRange = dimensionItem.getString("authrange");
                Set crossOtIds = dimensionItem.getDynamicObjectCollection("crossot").stream().map(it -> it.getString("fbasedataid.id")).collect(Collectors.toSet());
                Map appBuMap = (Map)assignedEntityBuCaFuncMap.get(entityType);
                if (kd.bos.orm.util.CollectionUtils.isEmpty((Map)appBuMap) || HRStringUtils.isEmpty((String)propKey)) {
                    return;
                }
                appBuMap.forEach((appId, buCaFuncId) -> {
                    if (!currentBuCaFuncId.equals(buCaFuncId)) {
                        return;
                    }
                    String localeValue = "";
                    if (isDynamicForm) {
                        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaformctrl");
                        DynamicObject entity = serviceHelper.queryOne("entryentity.propkey,entryentity.propname", new QFilter[]{new QFilter("entitytype", "=", (Object)entityType)});
                        if (null != entity) {
                            for (DynamicObject row : entity.getDynamicObjectCollection("entryentity")) {
                                if (!HRStringUtils.equals((String)row.getString("propkey"), (String)propKey)) continue;
                                localeValue = row.getString("propname");
                                break;
                            }
                        }
                    } else {
                        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityType);
                        ChoiceFieldPageCustomQueryService customQuery = new ChoiceFieldPageCustomQueryService();
                        Map formViewCustomParam = formView.getFormShowParameter().getCustomParams();
                        formViewCustomParam.remove("isJoinEntity");
                        formViewCustomParam.remove("isQueryEntityType");
                        List<Map<String, String>> propertyList = customQuery.parsePropertySub((IDataEntityType)mainEntityType, null, formViewCustomParam, null, new ArrayList<String>(10));
                        List propInfo = propertyList.stream().filter(it -> ((String)it.get("field_id")).equals(propKey)).collect(Collectors.toList());
                        if (propInfo.size() > 0) {
                            localeValue = (String)((Map)propInfo.get(0)).get("field_name");
                        }
                    }
                    localeValue = HRStringUtils.isEmpty((String)localeValue) ? propKey : localeValue;
                    String rowKey = entityType + "#" + propKey + "#" + appId;
                    if (CollectionUtils.isNotEmpty((Collection)entityCtrlInfos) && entityCtrlInfos.contains(rowKey) || CollectionUtils.isEmpty((Collection)entityCtrlInfos)) {
                        Map dimEntry = entityCtrlMap.computeIfAbsent(rowKey, k -> Maps.newHashMapWithExpectedSize((int)16));
                        dimEntry.put("propname", localeValue);
                        dimEntry.put("propkey", propKey);
                        dimEntry.put("app", appId);
                        dimEntry.put("ismust", isMust ? "1" : "0");
                        dimEntry.put("issyspreset", isSysPreSet ? "1" : "0");
                        dimEntry.put("description", description);
                        dimEntry.put("authrange", authRange);
                        dimEntry.put("crossot", String.join((CharSequence)",", crossOtIds));
                        dimEntry.put("structproject", String.join((CharSequence)",", structProjectMap.getOrDefault(entityType + "," + propKey, new ArrayList())));
                    }
                });
            });
        }
    }

    private static void doPrepareDataForJudgement(String currentBuCaFuncId, Long currentDimId, DynamicObject[] dims, Map<String, Map<String, String>> entityCtrlMap, PermPageCacheUtil permPageCacheUtil, String roleId) {
        HashSet roleDimensionIdSet = new HashSet();
        if (HRStringUtils.isNotEmpty((String)roleId)) {
            HRBaseServiceHelper roleDimensionHelper = new HRBaseServiceHelper("hrcs_roledimension");
            roleDimensionIdSet.addAll(Arrays.stream(roleDimensionHelper.query("dimension", new QFilter[]{new QFilter("role", "=", (Object)roleId), new QFilter("bucafunc", "=", (Object)Long.valueOf(currentBuCaFuncId))})).map(it -> it.getLong("dimension.id")).collect(Collectors.toSet()));
        }
        Map<String, Map<String, String>> assignedEntityBuCaFuncMap = permPageCacheUtil.getAssignedEntityBuCaFuncMap();
        for (DynamicObject dimObj : dims) {
            String entityType = dimObj.getString("entitytype.id");
            DynamicObjectCollection dimensionColl = dimObj.getDynamicObjectCollection("entryentity");
            dimensionColl.forEach(dimensionItem -> {
                long dimensionId = dimensionItem.getLong("dimension.id");
                if (!currentDimId.equals(dimensionId)) {
                    return;
                }
                if (SaveRoleServiceHelper.checkDimDisable(dimensionItem) && HRStringUtils.isNotEmpty((String)roleId) && !roleDimensionIdSet.isEmpty() && !roleDimensionIdSet.contains(currentDimId)) {
                    return;
                }
                String propKey = dimensionItem.getString("propkey");
                Map appBuMap = (Map)assignedEntityBuCaFuncMap.get(entityType);
                if (kd.bos.orm.util.CollectionUtils.isEmpty((Map)appBuMap) || HRStringUtils.isEmpty((String)propKey)) {
                    return;
                }
                appBuMap.forEach((appId, buCaFuncId) -> {
                    if (!currentBuCaFuncId.equals(buCaFuncId)) {
                        return;
                    }
                    Map dimEntry = entityCtrlMap.computeIfAbsent(entityType + "#" + propKey + "#" + appId, k -> Maps.newHashMapWithExpectedSize((int)16));
                    dimEntry.put("app", appId);
                });
            });
        }
    }

    public static void returnDataToParent(IFormView formView) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        Long currentDimId = (Long)formView.getFormShowParameter().getCustomParam("dimId");
        int rowIndex = (Integer)formView.getFormShowParameter().getCustomParam("rowIndex");
        HashSet<String> roleDimEntityDisableSet = new HashSet<String>(16);
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : entryEntity) {
            if (row.getBoolean("enable")) continue;
            roleDimEntityDisableSet.add(row.getString("app") + row.getString("entitytype.id") + row.getString("propkey"));
        }
        boolean enableCard = roleDimEntityDisableSet.size() != entryEntity.size();
        boolean cascade = !enableCard ? true : roleDimEntityDisableSet.isEmpty();
        resultMap.put("actionId", "1");
        resultMap.put("dimId", currentDimId.toString());
        resultMap.put("resultSet", roleDimEntityDisableSet);
        resultMap.put("rowIndex", rowIndex);
        resultMap.put("enableCard", enableCard);
        resultMap.put("cascade", cascade);
        formView.returnDataToParent(resultMap);
        formView.close();
    }

    private static DynamicObject[] getEntityCtrl(Long currentDimId, PermPageCacheUtil permPageCacheUtil, String currentBuCaFuncId, String roleId) {
        return EntityCtrlViewHelper.getEntityCtrl(currentDimId, permPageCacheUtil, currentBuCaFuncId, roleId, Lists.newArrayListWithExpectedSize((int)0));
    }

    private static DynamicObject[] getEntityCtrl(Long currentDimId, PermPageCacheUtil permPageCacheUtil, String currentBuCaFuncId, String roleId, List<String> entityCtrlInfos) {
        List<Map<String, String>> funcPermDataList = permPageCacheUtil.getFuncPermDataList();
        Set entityList = funcPermDataList.stream().map(item -> (String)item.get("entityNumber")).collect(Collectors.toSet());
        String viewStatus = permPageCacheUtil.get("viewStatus");
        HashMap entityPropMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList entityCtrlInfoTemp = Lists.newArrayListWithExpectedSize((int)10);
        if (HRStringUtils.equals((String)"1", (String)viewStatus) && HRStringUtils.isNotEmpty((String)roleId)) {
            HRBaseServiceHelper roleDimensionHelper = new HRBaseServiceHelper("hrcs_roledimension");
            DynamicObject roleDimension = roleDimensionHelper.queryOne("entry.entitytype,entry.propkey,entry.app", new QFilter[]{new QFilter("role", "=", (Object)roleId).and("dimension", "=", (Object)currentDimId).and("bucafunc", "=", (Object)Long.valueOf(currentBuCaFuncId))});
            if (null != roleDimension) {
                DynamicObjectCollection entry = roleDimension.getDynamicObjectCollection("entry");
                entityList = entry.stream().map(it -> it.getString("entitytype.id")).collect(Collectors.toSet());
                entityPropMap = Maps.newHashMapWithExpectedSize((int)entry.size());
                for (DynamicObject row : entry) {
                    String entity = row.getString("entitytype.id");
                    String propKey = row.getString("propkey");
                    List props = entityPropMap.computeIfAbsent(entity, key -> Lists.newArrayListWithExpectedSize((int)10));
                    props.add(propKey);
                    entityCtrlInfoTemp.add(entity + "#" + propKey + "#" + row.getString("app.id"));
                }
                entityCtrlInfos.addAll(entityCtrlInfoTemp);
            } else {
                List<Map<String, String>> roleFuncPermDataList = permPageCacheUtil.getRoleFuncPermDataList();
                entityList = roleFuncPermDataList.stream().map(item -> (String)item.get("entityNumber")).collect(Collectors.toSet());
            }
        }
        HRBaseServiceHelper entityCtrlHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        QFilter[] filters = new QFilter[]{new QFilter("entitytype", "in", entityList), new QFilter("entryentity.dimension", "=", (Object)currentDimId)};
        DynamicObject[] entityCtrls = entityCtrlHelper.query("bizapp,entitytype,entryentity.propkey,entryentity.dimension,entryentity.ismust,entryentity.issyspreset,entryentity.authrange,entryentity.crossot,entryentity.crossot.fbasedataid,description", filters, "bizapp desc");
        if (MapUtils.isNotEmpty((Map)entityPropMap)) {
            for (DynamicObject entityCtrl : entityCtrls) {
                String entity = entityCtrl.getString("entitytype.id");
                if (!entityPropMap.containsKey(entity)) continue;
                List props = (List)entityPropMap.get(entity);
                entityCtrl.getDynamicObjectCollection("entryentity").removeIf(it -> !props.contains(it.getString("propkey")));
            }
        }
        return entityCtrls;
    }

    public static void prepareData(IFormView formView, String currentBuCaFuncId, Long currentDimId, Map<String, Map<String, String>> entityCtrlMap, PermPageCacheUtil permPageCacheUtil) {
        ArrayList entityCtrlInfos;
        String roleId = (String)formView.getFormShowParameter().getCustomParam("roleId");
        DynamicObject[] items = EntityCtrlViewHelper.getEntityCtrl(currentDimId, permPageCacheUtil, currentBuCaFuncId, roleId, entityCtrlInfos = Lists.newArrayListWithExpectedSize((int)10));
        if (items == null || items.length == 0) {
            return;
        }
        EntityCtrlViewHelper.doPrepareData(formView, currentBuCaFuncId, currentDimId, items, entityCtrlMap, permPageCacheUtil, roleId, entityCtrlInfos);
    }

    public static void prepareDataForJudgement(String currentBuCaFuncId, Long currentDimId, Map<String, Map<String, String>> entityCtrlMap, PermPageCacheUtil permPageCacheUtil, String roleId) {
        DynamicObject[] items = EntityCtrlViewHelper.getEntityCtrl(currentDimId, permPageCacheUtil, currentBuCaFuncId, null);
        if (items == null || items.length == 0) {
            return;
        }
        EntityCtrlViewHelper.doPrepareDataForJudgement(currentBuCaFuncId, currentDimId, items, entityCtrlMap, permPageCacheUtil, roleId);
    }
}

