/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.constants.perm.RoleEditNewConst;
import org.apache.commons.lang3.ObjectUtils;

public class HRBuCaServiceHelper {
    private static Log logger = LogFactory.getLog(HRBuCaServiceHelper.class);

    public static String getBuCaFunc(String entityNumber, String appId) {
        String buCaFuncId = HRBuCaServiceHelper.getBuCaFuncFromEntity(entityNumber);
        if (HRStringUtils.isEmpty((String)buCaFuncId)) {
            Long appFuncId = HRBuCaServiceHelper.getAppFuncId(appId);
            buCaFuncId = appFuncId == null ? "11" : String.valueOf(appFuncId);
        }
        if (HRStringUtils.isEmpty((String)buCaFuncId)) {
            buCaFuncId = RoleEditNewConst.HR_VIEW_LONG_ID.toString();
        }
        return buCaFuncId;
    }

    public static String getBuCaFuncFromSpec(String entityNumber, String appId) {
        Long appFuncId;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entityspecfunc");
        DynamicObject specFunc = serviceHelper.queryOriginalOne("id,bucafunc.id", new QFilter[]{new QFilter("entity", "=", (Object)entityNumber)});
        String buCaFuncId = ObjectUtils.isNotEmpty((Object)specFunc) ? specFunc.getString("bucafunc.id") : ((appFuncId = HRBuCaServiceHelper.getAppFuncId(appId)) == null ? "11" : String.valueOf(appFuncId));
        if (HRStringUtils.isEmpty((String)buCaFuncId)) {
            buCaFuncId = RoleEditNewConst.HR_VIEW_LONG_ID.toString();
        }
        return buCaFuncId;
    }

    public static Map<String, Map<String, DynamicObject>> getBuCaFuncFromSpec(Map<String, List<String>> entityMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entityspecfunc");
        ArrayList entityNumList = Lists.newArrayListWithExpectedSize((int)entityMap.size());
        entityMap.forEach((key, value) -> entityNumList.addAll(value));
        DynamicObject[] specFunc = serviceHelper.query("id,bucafunc,entity.number", new QFilter[]{new QFilter("entity", "in", (Object)entityNumList)});
        Map<String, DynamicObject> funcGroup = Arrays.stream(specFunc).collect(Collectors.toMap(func -> func.getString("entity.number"), func -> func.getDynamicObject("bucafunc"), (key1, key2) -> key2));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)specFunc.length);
        HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)entityMap.size());
        entityMap.forEach((key, value) -> value.forEach(entityNum -> {
            DynamicObject func = (DynamicObject)funcGroup.get(entityNum);
            if (func == null) {
                appIdSet.add(key);
            }
            Map funcMap = resultMap.getOrDefault(key, Maps.newHashMapWithExpectedSize((int)value.size()));
            funcMap.put(entityNum, func);
            resultMap.put(key, funcMap);
        }));
        DynamicObject[] appFunc = HRBuCaServiceHelper.getAppFunc(appIdSet);
        DynamicObject hrOrg = HRBuCaServiceHelper.getHROrg();
        HashMap funcMap = Maps.newHashMapWithExpectedSize((int)appFunc.length);
        HashSet funcIdSet = Sets.newHashSetWithExpectedSize((int)appFunc.length);
        for (DynamicObject dynamicObject : appFunc) {
            String appId = dynamicObject.getString("app.id");
            funcIdSet.add(dynamicObject.getLong("businesstype.controlfuntype.id"));
            funcMap.put(appId, dynamicObject.getDynamicObject("businesstype.controlfuntype"));
        }
        HRBaseServiceHelper hrOrgServiceHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        DynamicObject[] hrFunc = hrOrgServiceHelper.queryOriginalArray("id,number,name", new QFilter[]{new QFilter("id", "in", (Object)funcIdSet)});
        Map<Long, DynamicObject> hfFuncMap = Arrays.stream(hrFunc).collect(Collectors.toMap(hf -> hf.getLong("id"), hf -> hf));
        resultMap.forEach((key, value) -> value.forEach((entityNum, func) -> {
            if (func == null) {
                DynamicObject funcDyn = (DynamicObject)funcMap.get(key);
                if (funcDyn == null) {
                    value.put(entityNum, hrOrg);
                } else {
                    long funcId = funcDyn.getLong("id");
                    DynamicObject newFuncDyn = (DynamicObject)hfFuncMap.get(funcId);
                    if (newFuncDyn == null) {
                        newFuncDyn = hrOrgServiceHelper.generateEmptyDynamicObject();
                        newFuncDyn.set("id", (Object)funcId);
                        newFuncDyn.set("number", (Object)funcDyn.getString("fnumber"));
                        newFuncDyn.set("name", (Object)funcDyn.getString("fname"));
                    }
                    value.put(entityNum, newFuncDyn);
                }
            }
        }));
        return resultMap;
    }

    public static String getBuCaFuncFromEntity(String entityNumber) {
        DynamicProperty typeProperty;
        MainEntityType dataEntityType = null;
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        String mainOrg = "";
        if (null != dataEntityType) {
            mainOrg = dataEntityType.getMainOrg();
        }
        String finalBuCaFuncId = "";
        if (null != dataEntityType && !HRStringUtils.isEmpty((String)mainOrg) && (typeProperty = dataEntityType.getProperty(mainOrg)) instanceof OrgProp) {
            finalBuCaFuncId = ((OrgProp)typeProperty).getOrgFunc();
        }
        return finalBuCaFuncId;
    }

    public static Long getAppFuncId(String appId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_appbusinesstype");
        QFilter[] qFilters = new QFilter[]{new QFilter("app", "=", (Object)appId), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")};
        DynamicObject dyno = helper.queryOne("businesstype.controlfuntype", qFilters);
        if (dyno == null) {
            return null;
        }
        return dyno.getLong("businesstype.controlfuntype.id");
    }

    public static DynamicObject[] getAppFunc(Set<String> appIdSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_appbusinesstype");
        QFilter[] qFilters = new QFilter[]{new QFilter("app", "in", appIdSet), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")};
        return helper.query("app,businesstype.controlfuntype", qFilters);
    }

    public static DynamicObject getHROrg() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        return serviceHelper.queryOriginalOne("id,number,name", new QFilter("id", "=", (Object)11L));
    }
}

