/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.FieldPermModel;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;

public class HRListFieldPermServiceHelper {
    public static Map<String, UserRoleFieldPermInfo> getRoleFieldPermInfoFromDatabase(String appIdStr, String entityNumStr, String roleId) {
        DynamicObject[] roleFieldDys;
        HashMap userRoleFieldPermInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper roleFieldHelper = new HRBaseServiceHelper("hrcs_rolefield");
        QFilter qFilter = new QFilter("role", "=", (Object)roleId);
        if (HRStringUtils.isNotEmpty((String)entityNumStr) && HRStringUtils.isNotEmpty((String)appIdStr)) {
            qFilter.and(new QFilter("entitytype", "=", (Object)entityNumStr)).and(new QFilter("app", "=", (Object)appIdStr));
        }
        if (Objects.isNull(roleFieldDys = roleFieldHelper.query("id, app,entitytype, fieldpermentry, fieldpermentry.fieldname, fieldpermentry.isbanread, fieldpermentry.isbanwrite", new QFilter[]{qFilter}))) {
            return userRoleFieldPermInfoMap;
        }
        for (DynamicObject roleFieldDy : roleFieldDys) {
            String appId = roleFieldDy.getString("app");
            String entityNum = roleFieldDy.getString("entitytype_id");
            String key = appId + "@" + entityNum;
            UserRoleFieldPermInfo userRoleFieldPermInfo = new UserRoleFieldPermInfo();
            userRoleFieldPermInfo.setId(roleFieldDy.getLong("id"));
            Map<String, String> fieldMap = RoleServiceHelper.getEntityFieldMap(entityNum);
            List<FieldPermModel> fieldPermModelList = userRoleFieldPermInfo.getFieldPermModelList();
            DynamicObjectCollection roleFieldEntry = roleFieldDy.getDynamicObjectCollection("fieldpermentry");
            for (DynamicObject userFieldRow : roleFieldEntry) {
                FieldPermModel fieldPermModel = new FieldPermModel();
                fieldPermModel.setRoleFieldId(roleId);
                fieldPermModel.setEntryId(userFieldRow.get("id"));
                String fieldName = userFieldRow.getString("fieldname");
                fieldPermModel.setFiledNum(fieldName);
                fieldPermModel.setEntityNum(entityNum);
                fieldPermModel.setFiledName(fieldMap.get(fieldName));
                fieldPermModel.setIsBanRead(HRListFieldPermServiceHelper.getBlValue(userFieldRow.getString("isbanread")));
                fieldPermModel.setIsBanWrite(HRListFieldPermServiceHelper.getBlValue(userFieldRow.getString("isbanwrite")));
                fieldPermModelList.add(fieldPermModel);
            }
            userRoleFieldPermInfoMap.put(key, userRoleFieldPermInfo);
        }
        return userRoleFieldPermInfoMap;
    }

    public static String getBlValue(String value) {
        if (HRStringUtils.equals((String)"true", (String)value)) {
            return "1";
        }
        if (HRStringUtils.equals((String)"false", (String)value)) {
            return "0";
        }
        if (HRStringUtils.equals((String)"1", (String)value)) {
            return "1";
        }
        if (HRStringUtils.equals((String)"0", (String)value)) {
            return "0";
        }
        return null;
    }
}

