/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;

public class HRPermServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRPermServiceHelper.class);

    public static void saveRoleDataRules(DynamicObjectCollection roleDataRuleCol, DynamicObjectCollection roleDataRuleEntryCol, DynamicObjectCollection roleBDRuleEntryCol) {
        HRBaseServiceHelper roleDataRuleHelper = new HRBaseServiceHelper("hrcs_roledatarule");
        HRBaseServiceHelper roleDataRuleEntryHelper = new HRBaseServiceHelper("hrcs_roledataruleentry");
        HRBaseServiceHelper roleBDRuleEntryHelper = new HRBaseServiceHelper("hrcs_rolebdruleentry");
        roleDataRuleHelper.save(roleDataRuleCol);
        roleDataRuleEntryHelper.save(roleDataRuleEntryCol);
        roleBDRuleEntryHelper.save(roleBDRuleEntryCol);
    }

    public static DynamicObjectCollection queryMultiUserDataRule(Set<Long> userRoleRelateIdSet) {
        HRBaseServiceHelper roleDataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        return roleDataRuleHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("userrolerelate", "in", userRoleRelateIdSet)});
    }

    public static void deleteUserDataRuleAndEntry(List<Long> ids) {
        HRBaseServiceHelper roleDataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        roleDataRuleHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", ids)});
        HRBaseServiceHelper userDataRuleEntryHelper = new HRBaseServiceHelper("hrcs_userdataruleentry");
        userDataRuleEntryHelper.deleteByFilter(new QFilter[]{new QFilter("userdatarule", "in", ids)});
        HRBaseServiceHelper userBdDataRuleEntryHelper = new HRBaseServiceHelper("hrcs_userbdruleentry");
        userBdDataRuleEntryHelper.deleteByFilter(new QFilter[]{new QFilter("userdatarule", "in", ids)});
    }

    public static void saveUserRoleRelate(DynamicObjectCollection userRoleRelateCol) {
        HRBaseServiceHelper roleDataRuleHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        roleDataRuleHelper.save(userRoleRelateCol);
    }

    public static void saveUserDataRules(DynamicObjectCollection userDataRuleCol, DynamicObjectCollection userDataRuleEntryCol, DynamicObjectCollection userBDRuleEntryCol) {
        HRBaseServiceHelper roleDataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        HRBaseServiceHelper roleDataRuleEntryHelper = new HRBaseServiceHelper("hrcs_userdataruleentry");
        HRBaseServiceHelper roleBDRuleEntryHelper = new HRBaseServiceHelper("hrcs_userbdruleentry");
        roleDataRuleHelper.save(userDataRuleCol);
        roleDataRuleEntryHelper.save(userDataRuleEntryCol);
        roleBDRuleEntryHelper.save(userBDRuleEntryCol);
    }

    public static DynamicObjectCollection queryMultiUserFieldPerm(Set<Long> userRoleRelateIdSet) {
        HRBaseServiceHelper userFieldHelper = new HRBaseServiceHelper("hrcs_userfield");
        return userFieldHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("userrolerealt", "in", userRoleRelateIdSet)});
    }

    public static void deleteUserFieldPerm(List<Long> userFieldPermIds) {
        HRBaseServiceHelper userFieldHelper = new HRBaseServiceHelper("hrcs_userfield");
        userFieldHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", userFieldPermIds)});
    }

    public static List<Long> getAdminGroupIds() {
        HRBaseServiceHelper userAdminGroupServiceHelper = new HRBaseServiceHelper("perm_useradmingroup");
        DynamicObject[] adminGroupItems = userAdminGroupServiceHelper.query("usergroup.id", new QFilter[]{new QFilter("user.id", "=", (Object)RequestContext.get().getCurrUserId())});
        Set adminGroupIds = Arrays.stream(adminGroupItems).map(it -> it.getLong("usergroup.id")).collect(Collectors.toSet());
        HRBaseServiceHelper adminGroupServiceHelper = new HRBaseServiceHelper("perm_admingroup");
        DynamicObject[] items = adminGroupServiceHelper.query("id", new QFilter[]{new QFilter("id", "in", adminGroupIds), new QFilter("isdomain", "=", (Object)"1"), new QFilter("domain", "=", (Object)1386267129346523136L)});
        return Arrays.stream(items).map(it -> it.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getAdminGroupFunc(long currentHRbuCaFunc) {
        List<Long> adminGroupIds = HRPermServiceHelper.getAdminGroupIds();
        if (adminGroupIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HRBaseServiceHelper adminGroupFuncServiceHelper = new HRBaseServiceHelper("hrcs_admingroupfunc");
        return Arrays.stream(adminGroupFuncServiceHelper.query("entryentity.org", new QFilter[]{new QFilter("admingroup.id", "in", adminGroupIds), new QFilter("bucafunc.id", "=", (Object)currentHRbuCaFunc)})).flatMap(it -> it.getDynamicObjectCollection("entryentity").stream()).map(it -> it.getLong("org.id")).collect(Collectors.toList());
    }

    public static List<Long> getUserPermFile() {
        List<Long> adminGroupIds = HRPermServiceHelper.getAdminGroupIds();
        if (adminGroupIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_admingroupfile");
        return Arrays.stream(serviceHelper.query("org.id", new QFilter[]{new QFilter("admingroup.id", "in", adminGroupIds)})).map(it -> it.getLong("org.id")).collect(Collectors.toList());
    }

    public static long getUserGroupMinLevel() {
        List<Long> adminGroupIds = HRPermServiceHelper.getAdminGroupIds();
        if (adminGroupIds.isEmpty()) {
            return -1L;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_admingroup");
        return Arrays.stream(serviceHelper.query("level", new QFilter[]{new QFilter("id", "in", adminGroupIds)})).mapToLong(it -> it.getLong("level")).min().orElse(-1L);
    }

    public static List<Long> getStructProjects(Set<Long> otClassifyIds) {
        List<Long> adminGroupIds = HRPermServiceHelper.getAdminGroupIds();
        if (adminGroupIds.isEmpty()) {
            return Collections.emptyList();
        }
        HRBaseServiceHelper adminGroupOrgServiceHelper = new HRBaseServiceHelper("hrcs_admingrouporg");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("admingroup.id", "in", adminGroupIds));
        if (!otClassifyIds.isEmpty()) {
            qFilters.add(new QFilter("struct.otclassify.id", "in", otClassifyIds));
        }
        return Arrays.stream(adminGroupOrgServiceHelper.query("adminorg.id,struct.id", HRPermCommonUtil.listToQFilters(qFilters))).map(it -> it.getLong("struct.id")).distinct().collect(Collectors.toList());
    }

    public static List<Long> getAdminGroupOrgTeams(List<Long> structProjectIds) {
        List<Long> adminGroupIds = HRPermServiceHelper.getAdminGroupIds();
        if (adminGroupIds.isEmpty()) {
            return Collections.emptyList();
        }
        HRBaseServiceHelper adminGroupOrgServiceHelper = new HRBaseServiceHelper("hrcs_admingrouporg");
        return Arrays.stream(adminGroupOrgServiceHelper.query("adminorg.id", new QFilter[]{new QFilter("admingroup.id", "in", adminGroupIds), new QFilter("struct", "in", structProjectIds)})).map(it -> it.getLong("adminorg_id")).collect(Collectors.toList());
    }
}

