/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.PermRelateServiceHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.PermFormCommonUtil;

public class HRRoleFunctionPermHelper {
    private static final String CLOUDL_NAME = "cloudl_name";
    private static final String APP_INDUSTRY = "app_industry";
    private static final String APP_NUM = "app_num";
    private static final String CLOUD_APP_DS = "cloudAppDS";
    private static final String ENTD_ID = "entd_id";
    private static final String PERMITEML_NAME = "permiteml_name";
    private static final String FUNCPERM_ID = "funcperm_id";
    private static final String PERMITEM_NUM = "permitem_num";
    private static final String BURF_APPID = "burf_appid";
    private static final String FUNCPERM_ENTID = "funcperm_entid";
    private static final String PARENTID = "parentid";
    private static final String EXPAND = "_expand_";
    private static final String ADD_NODES = "_addNodes_";
    private static final String ENTD_NUM = "entd_num";
    private static final String APP_ID = "app_id";
    private static final String PERMITEML_ID = "permiteml_id";
    private static final String CLOUDL_ID = "cloudl_id";
    private static final String ROLEPD_ENTNUM = "rolepd_entnum";
    private static final String ROLEPD_PERMITEMID = "rolepd_permitemid";
    private static final String ROLEPD_APPID = "rolepd_appid";
    private static final String PERM_ITEM_DS = "permItemDS";
    private static final String ENTITY_DS = "entityDS";
    private static final String PARENT_ID = "parentId";
    private static final Log LOGGER = LogFactory.getLog(HRRoleFunctionPermHelper.class);

    public static Map<String, List<String>> getRoleAppEntityRelate(String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_roleperm");
        DynamicObject[] rolePerms = helper.query("roleperm.entity,roleperm.permitem,roleperm.bizapp", new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
        HashMap appEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        if (rolePerms == null) {
            return appEntityMap;
        }
        DynamicObjectCollection rolePermColl = rolePerms[0].getDynamicObjectCollection("roleperm");
        for (DynamicObject rolePerm : rolePermColl) {
            String appId = rolePerm.getString("bizapp.id");
            if (HRStringUtils.isEmpty((String)appId)) continue;
            List entitySet = (List)appEntityMap.get(appId);
            if (CollectionUtils.isEmpty((Collection)entitySet)) {
                entitySet = Lists.newArrayListWithCapacity((int)16);
                appEntityMap.put(appId, entitySet);
            }
            entitySet.add(rolePerm.getString("entity.number"));
        }
        LOGGER.info("GotRoleAppEntityRelate result: {}", (Object)appEntityMap);
        return appEntityMap;
    }

    public static List<Map<String, String>> getRoleAppPermItems(String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_roleperm");
        DynamicObject[] rolePerms = helper.query("roleperm.entity,roleperm.permitem,roleperm.bizapp", new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
        ArrayList appEntityMap = Lists.newArrayListWithCapacity((int)16);
        if (rolePerms == null || rolePerms.length == 0) {
            return appEntityMap;
        }
        DynamicObjectCollection rolePermColl = rolePerms[0].getDynamicObjectCollection("roleperm");
        rolePermColl.forEach(rolePerm -> {
            String entityNumber = rolePerm.getString("entity.number");
            String permItemId = rolePerm.getString("permitem.id");
            if (HRStringUtils.isNotEmpty((String)entityNumber) && HRStringUtils.isNotEmpty((String)permItemId)) {
                HashMap itemMap = Maps.newHashMapWithExpectedSize((int)16);
                itemMap.put("appId", rolePerm.getString("bizapp.id"));
                itemMap.put("entityNumber", entityNumber);
                itemMap.put("permItemId", permItemId);
                appEntityMap.add(itemMap);
            }
        });
        LOGGER.info("GotRoleAppPermItems result: {}", (Object)appEntityMap);
        return appEntityMap;
    }

    public static Map<String, Set<String>> reloadAssignedBuCaFunc(Map<String, Map<String, String>> nodeMap, Map<String, Map<String, String>> parentMap, PermPageCacheUtil permPageCacheUtil) {
        Map<String, Map<String, String>> assignedAppHrBuCaMap = permPageCacheUtil.getAssignedAppHrBuCaMap();
        HashMap cloudBuCaFunc = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, Map<String, Object>> allHrBuCaMap = permPageCacheUtil.getAllHrBuCaMap();
        HashMap entityBuCaFuncMap = Maps.newHashMapWithExpectedSize((int)16);
        LOGGER.info("loadAssignedBuCaFuncByFuncData assignedAppHrBuCaMap = {}", assignedAppHrBuCaMap);
        LOGGER.info("loadAssignedBuCaFuncByFuncData parentMap = {}", parentMap);
        HRRoleFunctionPermHelper.loadAssignedBuCaFuncByFuncData(assignedAppHrBuCaMap, allHrBuCaMap, nodeMap, parentMap, cloudBuCaFunc, entityBuCaFuncMap);
        HashSet assignedBuCaFuncIds = Sets.newHashSetWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty((Map)cloudBuCaFunc)) {
            cloudBuCaFunc.forEach((cloudId, buCaFuncIds) -> assignedBuCaFuncIds.addAll(buCaFuncIds));
        }
        permPageCacheUtil.setAssignedHrBuCaSet(assignedBuCaFuncIds);
        permPageCacheUtil.setEntityBuCaFuncMap(entityBuCaFuncMap);
        return cloudBuCaFunc;
    }

    private static void loadAssignedBuCaFuncByFuncData(Map<String, Map<String, String>> assignedAppHrBuCaMap, Map<String, Map<String, Object>> allHrBuCaMap, Map<String, Map<String, String>> nodeMap, Map<String, Map<String, String>> parentMap, Map<String, Set<String>> cloudBuCaFunc, Map<String, Map<String, String>> entityBuCaFuncMap) {
        Map<String, Long> entitySpecFuncMap = HRRoleFunctionPermHelper.getAllEntitySpecFunc();
        for (Map.Entry<String, Map<String, String>> entry : nodeMap.entrySet()) {
            String nodeKey = entry.getKey();
            if (!nodeKey.endsWith("#entity")) continue;
            Map<String, String> entityMap = parentMap.get(nodeKey);
            String appKey = entityMap.get(PARENT_ID);
            Map<String, String> appInfo = parentMap.get(appKey);
            String cloudKey = appInfo.get(PARENT_ID);
            String entityNumber = nodeKey.substring(nodeKey.indexOf("|") + 1, nodeKey.indexOf("@"));
            String[] cloudKeyArr = cloudKey.split("#");
            Set buCaFuncSet = cloudBuCaFunc.computeIfAbsent(cloudKeyArr[0], it -> new HashSet());
            HRRoleFunctionPermHelper.getBuCaFuncByDb(entitySpecFuncMap, assignedAppHrBuCaMap, allHrBuCaMap, appKey, entityNumber, buCaFuncSet, entityBuCaFuncMap);
            cloudBuCaFunc.put(cloudKeyArr[0], buCaFuncSet);
        }
    }

    private static void getBuCaFunc(Map<String, Map<String, String>> assignedAppHrBuCaMap, Map<String, Map<String, Object>> allHrBuCaMap, String appKey, String entityNumber, Set<String> buCaFuncSet, Map<String, Map<String, String>> entityBuCaFuncMap) {
        MainEntityType dataEntityType = null;
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        catch (Exception e) {
            LOGGER.info("get dataEntityType error\uff1a {} ", (Object)entityNumber);
        }
        String mainOrg = "";
        String finalBuCaFuncId = "";
        if (Objects.isNull(dataEntityType)) {
            finalBuCaFuncId = HRRoleFunctionPermHelper.getHrBuCaFuncIdByApp(assignedAppHrBuCaMap, appKey, finalBuCaFuncId);
        } else {
            mainOrg = dataEntityType.getMainOrg();
            DynamicProperty typeProperty = dataEntityType.getProperty(mainOrg);
            if (typeProperty instanceof OrgProp) {
                finalBuCaFuncId = ((OrgProp)typeProperty).getOrgFunc();
            }
            if (HRStringUtils.isEmpty((String)finalBuCaFuncId)) {
                finalBuCaFuncId = HRRoleFunctionPermHelper.getHrBuCaFuncIdByApp(assignedAppHrBuCaMap, appKey, finalBuCaFuncId);
            }
        }
        Map<String, Object> buCaInfo = allHrBuCaMap.get(finalBuCaFuncId);
        if (!CollectionUtils.isEmpty(buCaInfo)) {
            buCaFuncSet.add(finalBuCaFuncId);
        }
        Map appBuCaFuncMap = entityBuCaFuncMap.getOrDefault(entityNumber, new HashMap());
        appBuCaFuncMap.put(appKey.replace("#app", ""), finalBuCaFuncId);
        entityBuCaFuncMap.put(entityNumber, appBuCaFuncMap);
    }

    public static Map<String, Long> getAllEntitySpecFunc() {
        HRBaseServiceHelper specFuncHelper = new HRBaseServiceHelper("hrcs_entityspecfunc");
        DynamicObject[] dynoArr = specFuncHelper.queryOriginalArray("entity,bucafunc", null);
        HashMap entitySpecFuncMap = Maps.newHashMapWithExpectedSize((int)dynoArr.length);
        for (DynamicObject dyno : dynoArr) {
            entitySpecFuncMap.put(dyno.getString("entity"), dyno.getLong("bucafunc"));
        }
        return entitySpecFuncMap;
    }

    private static void getBuCaFuncByDb(Map<String, Long> entitySpecFuncMap, Map<String, Map<String, String>> assignedAppHrBuCaMap, Map<String, Map<String, Object>> allHrBuCaMap, String appKey, String entityNumber, Set<String> buCaFuncSet, Map<String, Map<String, String>> entityBuCaFuncMap) {
        Long entitySpecFuncId = entitySpecFuncMap.get(entityNumber);
        String finalBuCaFuncId = "";
        finalBuCaFuncId = Objects.isNull(entitySpecFuncId) ? HRRoleFunctionPermHelper.getHrBuCaFuncIdByApp(assignedAppHrBuCaMap, appKey, finalBuCaFuncId) : entitySpecFuncId.toString();
        Map<String, Object> buCaInfo = allHrBuCaMap.get(finalBuCaFuncId);
        if (!CollectionUtils.isEmpty(buCaInfo)) {
            buCaFuncSet.add(finalBuCaFuncId);
        }
        Map appBuCaFuncMap = entityBuCaFuncMap.getOrDefault(entityNumber, new HashMap());
        appBuCaFuncMap.put(appKey.replace("#app", ""), finalBuCaFuncId);
        entityBuCaFuncMap.put(entityNumber, appBuCaFuncMap);
    }

    private static String getHrBuCaFuncIdByApp(Map<String, Map<String, String>> assignedAppHrBuCaMap, String appKey, String finalBuCaFuncId) {
        String hrBuCaId;
        String[] appArray = appKey.split("#");
        String appId = appArray[0];
        Map<String, String> buCaFuncMap = assignedAppHrBuCaMap.get(appId);
        boolean find = false;
        if (!CollectionUtils.isEmpty(buCaFuncMap) && HRStringUtils.isNotEmpty((String)(hrBuCaId = buCaFuncMap.get("buCaFuncId")))) {
            finalBuCaFuncId = hrBuCaId;
            find = true;
        }
        if (!find) {
            finalBuCaFuncId = "11";
        }
        return finalBuCaFuncId;
    }

    public static void setAssignedAppEntity(IFormView formView, String roleId) {
        Map<String, List<String>> roleAppEntityRelate = HRRoleFunctionPermHelper.loadRolePermFromDB(roleId, formView);
        List<Map<String, String>> roleAppPermItems = HRRoleFunctionPermHelper.getRoleAppPermItems(roleId);
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        permPageCacheUtil.updateFuncPermDataList(roleAppPermItems);
        permPageCacheUtil.setOriginalFuncPermDataList(roleAppPermItems);
        permPageCacheUtil.setAssignedAppEntity(roleAppEntityRelate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<String>> loadRolePermFromDB(String roleId, IFormView view) {
        Map<String, List<String>> map;
        if (HRStringUtils.isEmpty((String)roleId)) {
            return new HashMap<String, List<String>>();
        }
        String langStr = RequestContext.get().getLang().name();
        String algoKeyPrefix = "HRRoleFunctionPermHelper.loadRolePermFromDB.loadRolePermFromDB.";
        DataSet permItemDS = null;
        DataSet finalDS = null;
        DataSet rolePermDS = null;
        DataSet entityDS = null;
        DataSet cloudAppDS = null;
        DataSet tempDS1 = null;
        DataSet tempDS2 = null;
        try {
            rolePermDS = HRRoleFunctionPermHelper.getRolePermDS(roleId, algoKeyPrefix);
            cloudAppDS = HRRoleFunctionPermHelper.getCloudAppDS(langStr, algoKeyPrefix);
            entityDS = HRRoleFunctionPermHelper.getEntityDS(algoKeyPrefix);
            permItemDS = HRRoleFunctionPermHelper.getPermItemDS(langStr, algoKeyPrefix);
            tempDS1 = rolePermDS.join(cloudAppDS).on(ROLEPD_APPID, APP_ID).select(new String[]{ROLEPD_ENTNUM, ROLEPD_PERMITEMID}, new String[]{CLOUDL_ID, CLOUDL_NAME, APP_ID, APP_NUM, APP_INDUSTRY}).finish();
            tempDS2 = tempDS1.join(entityDS).on(ROLEPD_ENTNUM, ENTD_NUM).select(new String[]{CLOUDL_ID, CLOUDL_NAME, APP_ID, APP_NUM, APP_INDUSTRY, ROLEPD_PERMITEMID, "entd_name"}, new String[]{ENTD_NUM, ENTD_ID}).finish();
            finalDS = HRRoleFunctionPermHelper.getFinalDS(permItemDS, tempDS2);
            map = HRRoleFunctionPermHelper.queryDataBySQL(finalDS, view);
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{rolePermDS, entityDS, permItemDS, cloudAppDS, finalDS, tempDS1, tempDS2});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{rolePermDS, entityDS, permItemDS, cloudAppDS, finalDS, tempDS1, tempDS2});
        return map;
    }

    public static DataSet getPermItemDS(String langStr, String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + PERM_ITEM_DS), (DBRoute)DBRoute.permission, (String)"  SELECT permiteml.fid permiteml_id, permiteml.FNAME permiteml_name, permitem.fnumber permitem_num  FROM t_perm_permitem permitem  INNER JOIN t_perm_permitem_l permiteml ON (permiteml.FID = permitem.FID AND permiteml.FLOCALEID = ?) ", (Object[])new Object[]{langStr});
    }

    public static DataSet getEntityDS(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + ENTITY_DS), (DBRoute)DBRoute.meta, (String)HRRoleFunctionPermHelper.buildEntitySql().toString(), (Object[])new Object[]{RequestContext.get().getLang().name()});
    }

    private static StringBuilder buildEntitySql() {
        return new StringBuilder().append("select entd.FID entd_id, entdl.fname entd_name, entd.fnumber entd_num ").append("  from t_meta_entitydesign entd ").append(" INNER JOIN t_meta_entitydesign_l entdl on (entd.fid = entdl.fid and entdl.FLOCALEID = ?) ").append(" where entd.FISTEMPLATE = '0'");
    }

    public static DataSet getCloudAppDS(String langStr, String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)" SELECT  cloudl.fid cloudl_id, cloudl.fname cloudl_name,  app.fid app_id, app.fnumber app_num,  app.findustry app_industry  FROM t_meta_bizapp app  INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = app.FBIZCLOUDID and cloudl.FLOCALEID = ?)  WHERE app.FDEPLOYSTATUS = '2' ", (Object[])new Object[]{langStr});
    }

    public static DataSet getRolePermDS(String roleId, String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + "rolePermDS"), (DBRoute)DBRoute.permission, (String)" SELECT  rolepd.fentitytypeid rolepd_entnum,  rolepd.FBIZAPPID rolepd_appid,  rolepd.FPERMITEMID rolepd_permitemid  FROM t_perm_roleperm rolep  INNER JOIN t_perm_rolepermdetial rolepd ON (rolepd.FID = rolep.FID)  WHERE rolep.FROLEID = ?", (Object[])new Object[]{roleId});
    }

    public static DataSet getFinalDS(DataSet permItemDS, DataSet tempDS2) {
        return tempDS2.join(permItemDS).on(ROLEPD_PERMITEMID, PERMITEML_ID).select(new String[]{CLOUDL_ID, CLOUDL_NAME, APP_ID, APP_NUM, APP_INDUSTRY, ENTD_NUM, ENTD_ID, "entd_name"}, new String[]{PERMITEML_ID, PERMITEM_NUM, PERMITEML_NAME}).finish().orderBy(new String[]{"cloudl_id   asc", "app_id   asc", "entd_num asc", "permiteml_id  asc"});
    }

    private static Map<String, List<String>> queryDataBySQL(DataSet ds, IFormView view) {
        Map<String, Map<String, Set<String>>> entityPermMapCach;
        Map extAppAndOrgnlAppRel = PermFormCommonUtil.getExtAppAndOrgnlAppRel();
        Map entityPermMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap appEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        String allRelatedPermStr = view.getPageCache().get("AllRelatedPerms");
        if (HRStringUtils.isEmpty((String)allRelatedPermStr) && !CollectionUtils.isEmpty(entityPermMapCach = PermRelateServiceHelper.buildAllRelatedPerm())) {
            view.getPageCache().put("AllRelatedPerms", SerializationUtils.toJsonString(entityPermMapCach));
            allRelatedPermStr = view.getPageCache().get("AllRelatedPerms");
        }
        boolean hasPermItems = false;
        if (HRStringUtils.isNotEmpty((String)allRelatedPermStr)) {
            entityPermMap = (Map)SerializationUtils.fromJsonString((String)allRelatedPermStr, Map.class);
            hasPermItems = true;
        }
        while (ds.hasNext()) {
            Row row = ds.next();
            String newAppId = row.getString(APP_ID);
            newAppId = (String)extAppAndOrgnlAppRel.get(newAppId);
            String newEntityNumber = row.getString(ENTD_NUM);
            if (!hasPermItems || HRStringUtils.isEmpty((String)newAppId) || entityPermMap.get(newAppId) != null && ((Map)entityPermMap.get(newAppId)).get(newEntityNumber) != null && ((ArrayList)((Map)entityPermMap.get(newAppId)).get(newEntityNumber)).contains(row.getString(PERMITEM_NUM))) continue;
            List entitySet = (List)appEntityMap.get(newAppId);
            if (CollectionUtils.isEmpty((Collection)entitySet)) {
                entitySet = Lists.newArrayListWithCapacity((int)16);
                appEntityMap.put(newAppId, entitySet);
            }
            entitySet.add(newEntityNumber);
        }
        return appEntityMap;
    }

    public static Map<String, Set<String>> buildAllRelatedPerm() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permrelat");
        DynamicObject[] permRelates = serviceHelper.query("entryentity.entitytypeid,entryentity.permitemid", new QFilter[0]);
        HashMap<String, Set<String>> entityPermMap = new HashMap<String, Set<String>>(16);
        if (permRelates.length > 0) {
            for (DynamicObject permRelate : permRelates) {
                DynamicObjectCollection entry = permRelate.getDynamicObjectCollection("entryentity");
                for (DynamicObject dy : entry) {
                    String entityTypeId = dy.getString("entitytypeid.id");
                    if (null == entityTypeId) continue;
                    HashSet permItems = (HashSet)entityPermMap.get(entityTypeId);
                    if (null == permItems) {
                        permItems = new HashSet(16);
                        entityPermMap.put(entityTypeId, permItems);
                    }
                    Set idSet = Arrays.stream(dy.getString("permitemid").split(",")).collect(Collectors.toSet());
                    permItems.addAll(idSet);
                }
            }
        }
        return entityPermMap;
    }
}

