/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.SaveRoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DimensionHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DynamicControlHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;

public class NewRoleWizardHelper {
    private static final Log LOGGER = LogFactory.getLog(NewRoleWizardHelper.class);

    public static void doStepAction(IFormView formView, boolean forward) {
        Tab tab = (Tab)formView.getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        int tabIndex = 0;
        for (int i = 0; i < tab.getItems().size(); ++i) {
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            if (forward) {
                tab.activeTab(((Control)tab.getItems().get(i + 1)).getKey());
                tabIndex = i + 1;
                break;
            }
            tab.activeTab(((Control)tab.getItems().get(i - 1)).getKey());
            tabIndex = i - 1;
            break;
        }
        formView.getPageCache().put("wizardTabIndex", tabIndex + "");
    }

    public static void handleCtrlVisible(IFormView formView) {
        String tabIndex = formView.getPageCache().get("wizardTabIndex");
        if (HRStringUtils.equals((String)"1", (String)tabIndex)) {
            formView.setVisible(Boolean.TRUE, new String[]{"roleinfopanel"});
        }
        if (tabIndex == null || HRStringUtils.equals((String)"0", (String)tabIndex)) {
            formView.setVisible(Boolean.FALSE, new String[]{"btnprev", "roleinfopanel"});
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"btnprev", "roleinfopanel"});
        }
        if (HRStringUtils.equals((String)"4", (String)tabIndex)) {
            formView.setVisible(Boolean.FALSE, new String[]{"btnnext"});
            formView.setVisible(Boolean.TRUE, new String[]{"btnsave"});
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"btnnext"});
            formView.setVisible(Boolean.FALSE, new String[]{"btnsave"});
        }
    }

    public static void handleDimEntryCard(IFormView formView, String tabIndex) {
        if (HRStringUtils.equals((String)"2", (String)tabIndex)) {
            boolean isFunctionChangedInit;
            PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
            String functionChangeStatus = RoleServiceHelper.getFunctionChangeStatus(formView);
            boolean isFunctionChanged = HRStringUtils.equals((String)"1", (String)functionChangeStatus);
            boolean bl = isFunctionChangedInit = null == functionChangeStatus;
            if (isFunctionChanged || isFunctionChangedInit) {
                if (isFunctionChanged) {
                    RoleServiceHelper.revertFunctionChanged(formView);
                }
                Tab tab = (Tab)formView.getControl("guidecontent");
                String currentTab = tab.getCurrentTab();
                List<Map<String, String>> funcPermDataList = permPageCacheUtil.getFuncPermDataList();
                if (CollectionUtils.isEmpty(funcPermDataList)) {
                    formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u914d\u529f\u80fd\u6743\u9650\u3002", (String)"NewRoleWizardHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                    tab.activeTab(currentTab);
                    formView.getPageCache().put("wizardTabIndex", Integer.parseInt(tabIndex) - 1 + "");
                    return;
                }
                NewRoleWizardHelper.showDimEntryCard(formView, true, permPageCacheUtil);
            }
        }
    }

    public static void showDimEntryCard(IFormView formView, boolean forceRefresh, PermPageCacheUtil permPageCacheUtil) {
        NewRoleWizardHelper.reloadPermInfo(permPageCacheUtil, forceRefresh);
        DimensionHelper.addDimCardEntry("dimcardentry", formView, permPageCacheUtil);
    }

    public static void reloadPermInfo(PermPageCacheUtil permPageCacheUtil, boolean forceRefresh) {
        HashMap assignedDimInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, RoleDataPermModel> dataPermMap = permPageCacheUtil.getDataPermMap();
        NewRoleWizardHelper.addOrRemoveDim(permPageCacheUtil, assignedDimInfoMap, dataPermMap, forceRefresh);
        NewRoleWizardHelper.cacheData(permPageCacheUtil, assignedDimInfoMap, dataPermMap, forceRefresh);
    }

    private static DynamicObject[] getDimFromFuncPerm(PermPageCacheUtil permPageCacheUtil) {
        List<Map<String, String>> funcPermDataList = permPageCacheUtil.getFuncPermDataList();
        LOGGER.info("Got func perm data list: {}.", funcPermDataList);
        Set relateAppEntitySet = NewRoleWizardHelper.getAllRelatedPerms(funcPermDataList).stream().map(it -> it.getString("entitytypeid.id")).collect(Collectors.toSet());
        Set appEntitySet = funcPermDataList.stream().map(item -> (String)item.get("entityNumber")).collect(Collectors.toSet());
        appEntitySet.addAll(relateAppEntitySet);
        DynamicObject[] dims = new DynamicObject[]{};
        if (!CollectionUtils.isEmpty(appEntitySet)) {
            QFilter[] filters = new QFilter[]{new QFilter("entitytype", "in", appEntitySet)};
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_entityctrl");
            dims = helper.query("entitytype,entryentity.dimension.enable,entryentity.dimension.number,entryentity.dimension.datasource,entryentity.dimension,entryentity.ismust", filters);
        } else {
            permPageCacheUtil.clearAssignedHrBuCaDim();
            LOGGER.info("dimension count 0 ");
        }
        return dims;
    }

    public static Set<DynamicObject> getAllRelatedPerms(List<Map<String, String>> funcPermDataList) {
        if (funcPermDataList.isEmpty()) {
            return new HashSet<DynamicObject>(16);
        }
        HRBaseServiceHelper permRelateServiceHelper = new HRBaseServiceHelper("hrcs_permrelat");
        DynamicObject[] items = permRelateServiceHelper.query("entryentity.entitytypeid,entryentity.app,entryentity.permitemid", new QFilter[]{new QFilter("entryentity.entitytypeid", "in", funcPermDataList.stream().map(it -> (String)it.get("entityNumber")).collect(Collectors.toSet()))});
        Set allPermItemNumbers = Arrays.stream(items).flatMap(it -> it.getDynamicObjectCollection("entryentity").stream()).flatMap(it -> Arrays.stream(it.getString("permitemid").split(","))).collect(Collectors.toSet());
        HRBaseServiceHelper permItemServiceHelper = new HRBaseServiceHelper("perm_permitem");
        Map<String, String> permItemMap = Arrays.stream(permItemServiceHelper.query("id,number", new QFilter[]{new QFilter("number", "in", allPermItemNumbers)})).collect(Collectors.toMap(it -> it.getString("number"), it -> it.getString("id"), (oldValue, newValue) -> oldValue));
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(items.length);
        for (DynamicObject item : items) {
            DynamicObjectCollection collection = item.getDynamicObjectCollection("entryentity");
            for (DynamicObject it2 : collection) {
                String[] permItemNumbers;
                String appId = it2.getString("app.id");
                String entityId = it2.getString("entitytypeid.id");
                for (String permItemNumber : permItemNumbers = it2.getString("permitemid").split(",")) {
                    map.put(appId + "|" + entityId + "|" + permItemMap.getOrDefault(permItemNumber, "-"), it2);
                }
            }
        }
        Set permRelateSet = map.keySet();
        HRBaseServiceHelper independentServiceHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        Set independentSet = Arrays.stream(independentServiceHelper.query("app,entitytype,permitem", new QFilter[]{new QFilter("isassign", "=", (Object)"1")})).map(it -> it.getString("app.id") + "|" + it.getString("entitytype.id") + "|" + it.getString("permitem.number")).collect(Collectors.toSet());
        return funcPermDataList.stream().map(it -> (String)it.get("appId") + "|" + (String)it.get("entityNumber") + "|" + (String)it.get("permItemId")).filter(key -> permRelateSet.contains(key) && !independentSet.contains(key)).map(map::get).collect(Collectors.toSet());
    }

    public static void addRelatedNodeMap(Map<String, Map<String, String>> nodeMap, Map<String, Map<String, String>> parentMap, List<Map<String, String>> funcPermDataList) {
        Set<DynamicObject> dynamicObjectSet = NewRoleWizardHelper.getAllRelatedPerms(funcPermDataList);
        dynamicObjectSet.stream().forEach(item -> {
            String key = item.getString("entitytypeid.dentityid") + "|" + item.getString("entitytypeid.id") + "@" + item.getString("app.id") + "#entity";
            final String name = item.getString("entitytypeid.name");
            final String appKey = item.getString("app.id") + "#app";
            final String appName = item.getString("app.name");
            final String cloudKey = item.getString("app.bizcloud.id") + "#cloud";
            final String cloudName = item.getString("app.bizcloud.name");
            HashMap<String, String> value = new HashMap<String, String>(){
                private static final long serialVersionUID = -6805978012696136194L;
                {
                    this.put("parentId", appKey);
                    this.put("name", name);
                }
            };
            HashMap<String, String> appValue = new HashMap<String, String>(){
                private static final long serialVersionUID = 118614074988098930L;
                {
                    this.put("parentId", cloudKey);
                    this.put("name", appName);
                }
            };
            nodeMap.putIfAbsent(key, value);
            parentMap.putIfAbsent(key, value);
            parentMap.putIfAbsent(appKey, appValue);
            parentMap.putIfAbsent(cloudKey, new HashMap<String, String>(){
                private static final long serialVersionUID = -5207830951217723403L;
                {
                    this.put("name", cloudName);
                }
            });
        });
    }

    private static void addOrRemoveDim(PermPageCacheUtil permPageCacheUtil, Map<String, Map<String, Object>> assignedDimInfoMap, Map<String, RoleDataPermModel> dataPermMap, boolean forceRefresh) {
        Map<String, Map<String, Object>> assignedHrBuCaMap = permPageCacheUtil.getAssignedHrBuCaMap();
        HashMap allHrBuCaDim = Maps.newHashMapWithExpectedSize((int)16);
        NewRoleWizardHelper.reloadPermInfo(permPageCacheUtil, assignedDimInfoMap, allHrBuCaDim, dataPermMap, forceRefresh);
        Map<String, Map<String, Map<String, Object>>> roleBuCaFuncDimMap = permPageCacheUtil.getAssignedHrBuCaDim();
        NewRoleWizardHelper.deleteDim(permPageCacheUtil, allHrBuCaDim, roleBuCaFuncDimMap, dataPermMap);
        Iterator<Map.Entry<String, RoleDataPermModel>> dataPermIterator = dataPermMap.entrySet().iterator();
        while (dataPermIterator.hasNext()) {
            Map.Entry<String, RoleDataPermModel> dataPermEntry = dataPermIterator.next();
            String buCaFuncId = dataPermEntry.getKey();
            Map<String, Object> buCaFuncInfo = assignedHrBuCaMap.get(buCaFuncId);
            if (!CollectionUtils.isEmpty(buCaFuncInfo)) continue;
            dataPermIterator.remove();
        }
        permPageCacheUtil.setAssignedHrBuCaDim(roleBuCaFuncDimMap);
    }

    private static void cacheData(PermPageCacheUtil permPageCacheUtil, Map<String, Map<String, Object>> assignedDimInfoMap, Map<String, RoleDataPermModel> dataPermMap, boolean forceRefresh) {
        if (forceRefresh) {
            permPageCacheUtil.setDataPerm(dataPermMap);
        }
        permPageCacheUtil.setAssignedDimIntoCache(assignedDimInfoMap);
    }

    private static void reloadPermInfo(PermPageCacheUtil permPageCacheUtil, Map<String, Map<String, Object>> assignedDimInfoMap, Map<String, Map<String, Map<String, Object>>> allHrBuCaDim, Map<String, RoleDataPermModel> dataPermMap, boolean forceRefresh) {
        HashMap realTimeAssignedHrBuCaDim = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, Map<String, Map<String, Object>>> roleBuCaFuncDimMap = permPageCacheUtil.getAssignedHrBuCaDim();
        Map<String, Map<String, Map<String, Object>>> originalHrBuCaDim = permPageCacheUtil.getOriginalHrBuCaDim();
        if (originalHrBuCaDim.isEmpty()) {
            roleBuCaFuncDimMap.clear();
        }
        DynamicObject[] dims = NewRoleWizardHelper.getDimFromFuncPerm(permPageCacheUtil);
        Map<String, Map<String, String>> assignedEntityBuCaFuncMap = permPageCacheUtil.getAssignedEntityBuCaFuncMap();
        LOGGER.info("Reload perm info. Got roleBuCaFuncDimMap: \u3010{}\u3011, originalHrBuCaDim: \u3010{}\u3011 assignedEntityBuCaFuncMap: \u3010{}\u3011, dim length: {}.", new Object[]{roleBuCaFuncDimMap, originalHrBuCaDim, assignedEntityBuCaFuncMap, dims.length});
        for (DynamicObject dim : dims) {
            String entityNumber = dim.getString("entitytype.number");
            Map<String, String> buCaFuncAppMap = assignedEntityBuCaFuncMap.get(entityNumber);
            if (CollectionUtils.isEmpty(buCaFuncAppMap)) {
                LOGGER.info("Ignore null buCaFuncAppMap with number[{}].", (Object)entityNumber);
                continue;
            }
            HashSet<String> buSet = new HashSet<String>(buCaFuncAppMap.values());
            buSet.forEach(buCaFuncId -> {
                Map dimTempMap = realTimeAssignedHrBuCaDim.computeIfAbsent(buCaFuncId, item -> new HashMap());
                Map allHrBuCaDimTempMap = allHrBuCaDim.computeIfAbsent((String)buCaFuncId, item -> new HashMap());
                DynamicObjectCollection collection = dim.getDynamicObjectCollection("entryentity");
                for (DynamicObject dimCtrlEntry : collection) {
                    DynamicObjectCollection dimEnumColl;
                    String dimId = dimCtrlEntry.getString("dimension.id");
                    String showType = dimCtrlEntry.getString("dimension.showtype");
                    String dimNumber = dimCtrlEntry.getString("dimension.number");
                    String dimName = dimCtrlEntry.getString("dimension.name");
                    String dimDataSource = dimCtrlEntry.getString("dimension.datasource");
                    Map currentBuCaFuncDimMap = originalHrBuCaDim.getOrDefault(buCaFuncId, new HashMap());
                    Map assignDimItem = (Map)currentBuCaFuncDimMap.get(dimId);
                    if (SaveRoleServiceHelper.checkDimDisable(dimCtrlEntry) && CollectionUtils.isEmpty((Map)assignDimItem)) {
                        LOGGER.info("Check dim[id:{}, entry id: {}, entry dimension id: {}] failed.", new Object[]{dim.getPkValue(), dimCtrlEntry.getPkValue(), dimId});
                        continue;
                    }
                    HashMap tempInfo = Maps.newHashMapWithExpectedSize((int)3);
                    tempInfo.put("dimId", dimId);
                    tempInfo.put("dimensionNumber", dimNumber);
                    tempInfo.put("dimensionName", dimName);
                    tempInfo.put("dataSource", dimDataSource);
                    boolean mustInput = dimCtrlEntry.getBoolean("ismust");
                    tempInfo.put("ismust", mustInput ? "1" : "0");
                    tempInfo.put("showType", showType);
                    if (HRStringUtils.equals((String)"checkbox", (String)showType) && !CollectionUtils.isEmpty((Collection)(dimEnumColl = dimCtrlEntry.getDynamicObjectCollection("dimension.entry")))) {
                        List valueList = dimEnumColl.stream().map(enumItem -> enumItem.getString("value")).collect(Collectors.toList());
                        List idList = dimEnumColl.stream().map(enumItem -> enumItem.getLong("id")).collect(Collectors.toList());
                        tempInfo.put("enumList", valueList);
                        tempInfo.put("enumIdList", idList);
                    }
                    if (mustInput) {
                        NewRoleWizardHelper.addRoleDim(roleBuCaFuncDimMap, dataPermMap, buCaFuncId, dimId, tempInfo);
                    }
                    NewRoleWizardHelper.setDim(assignedDimInfoMap, dimId, tempInfo, mustInput);
                    NewRoleWizardHelper.setDim(dimTempMap, dimId, tempInfo, mustInput);
                    allHrBuCaDimTempMap.putIfAbsent(dimId, tempInfo);
                }
            });
        }
        permPageCacheUtil.setAssignedHrBuCaDim(roleBuCaFuncDimMap);
        permPageCacheUtil.setRealTimeBuCaFuncDim(realTimeAssignedHrBuCaDim);
    }

    private static void setDim(Map<String, Map<String, Object>> assignedDimInfoMap, String dimId, Map<String, Object> tempInfo, boolean mustInput) {
        Map<String, Object> dimInfo = assignedDimInfoMap.get(dimId);
        if (CollectionUtils.isEmpty(dimInfo) || HRStringUtils.equals((String)"0", (String)((String)dimInfo.get("ismust"))) && mustInput) {
            assignedDimInfoMap.put(dimId, tempInfo);
        }
    }

    private static void deleteDim(PermPageCacheUtil permPageCacheUtil, Map<String, Map<String, Map<String, Object>>> buCaFuncDimMap, Map<String, Map<String, Map<String, Object>>> roleBuCaFuncDimMap, Map<String, RoleDataPermModel> permDataMap) {
        Iterator<Map.Entry<String, Map<String, Map<String, Object>>>> roleBuCaFuncDimIterator = roleBuCaFuncDimMap.entrySet().iterator();
        Set<String> hrBuCaFuncSet = permPageCacheUtil.getAssignedHrBuCaSet();
        while (roleBuCaFuncDimIterator.hasNext()) {
            Map.Entry<String, Map<String, Map<String, Object>>> roleBuCaFuncDimEntry = roleBuCaFuncDimIterator.next();
            String buCaFuncId = roleBuCaFuncDimEntry.getKey();
            Map<String, Map<String, Object>> roleBuCaFuncDim = roleBuCaFuncDimEntry.getValue();
            Map<String, Map<String, Object>> tempDimMap = buCaFuncDimMap.get(buCaFuncId);
            if (CollectionUtils.isEmpty(tempDimMap)) {
                roleBuCaFuncDimIterator.remove();
                if (hrBuCaFuncSet.contains(buCaFuncId)) {
                    Optional.ofNullable(permDataMap.get(buCaFuncId)).ifPresent(it -> {
                        Map orgMap = it.getOrgMap();
                        it = new RoleDataPermModel();
                        it.setOrgMap(orgMap);
                    });
                    continue;
                }
                permDataMap.remove(buCaFuncId);
                continue;
            }
            Iterator<Map.Entry<String, Map<String, Object>>> dimEntryIterator = roleBuCaFuncDim.entrySet().iterator();
            while (dimEntryIterator.hasNext()) {
                Map.Entry<String, Map<String, Object>> dimInfoEntry = dimEntryIterator.next();
                String dimId = dimInfoEntry.getKey();
                Map<String, Object> dimInfo = tempDimMap.get(dimId);
                if (dimInfo != null) continue;
                NewRoleWizardHelper.deleteDim(permDataMap, buCaFuncId, dimEntryIterator, dimInfoEntry);
            }
        }
    }

    private static void deleteDim(Map<String, RoleDataPermModel> permDataMap, String buCaFuncId, Iterator<Map.Entry<String, Map<String, Object>>> dimEntryIterator, Map.Entry<String, Map<String, Object>> dimInfoEntry) {
        Map<String, Object> delDimInfo = dimInfoEntry.getValue();
        RoleDataPermModel roleDataPermModel = permDataMap.get(buCaFuncId);
        if (roleDataPermModel == null) {
            return;
        }
        Map dimGroupMap = roleDataPermModel.getDimGroupMap();
        if (CollectionUtils.isEmpty((Map)dimGroupMap)) {
            return;
        }
        for (Map.Entry dimGrpEntry : dimGroupMap.entrySet()) {
            DimGrpModel dimGrpModel = (DimGrpModel)dimGrpEntry.getValue();
            TreeMap dimMap = dimGrpModel.getDimMap();
            if (CollectionUtils.isEmpty((Map)dimMap)) continue;
            dimMap.remove(delDimInfo.get("dimensionNumber"));
        }
        dimEntryIterator.remove();
    }

    private static void addRoleDim(Map<String, Map<String, Map<String, Object>>> roleBuCaFuncDimMap, Map<String, RoleDataPermModel> dataPermMap, String buCaFuncId, String dimId, Map<String, Object> tempInfo) {
        Map roleDimMap = roleBuCaFuncDimMap.computeIfAbsent(buCaFuncId, item -> new HashMap());
        roleDimMap.put(dimId, tempInfo);
        RoleDataPermModel roleDataPermModel = dataPermMap.get(buCaFuncId);
        if (Objects.isNull(roleDataPermModel)) {
            roleDataPermModel = new RoleDataPermModel();
            roleDataPermModel.setHrBuCaFunc(Long.parseLong(buCaFuncId));
            dataPermMap.put(buCaFuncId, roleDataPermModel);
        }
        DimModel model = new DimModel();
        model.setDimId((String)tempInfo.get("dimId"));
        model.setDimNumber((String)tempInfo.get("dimensionNumber"));
        Map dimGroupMap = roleDataPermModel.getDimGroupMap();
        if (CollectionUtils.isEmpty((Map)dimGroupMap)) {
            String groupPanelId = DynamicControlHelper.genControlId("group");
            DimGrpModel dimGrpModel2 = new DimGrpModel();
            TreeMap<String, DimModel> dimMap = new TreeMap<String, DimModel>();
            dimMap.put((String)tempInfo.get("dimensionNumber"), model);
            dimGrpModel2.setDimMap(dimMap);
            dimGroupMap.put(groupPanelId, dimGrpModel2);
            return;
        }
        dimGroupMap.forEach((grpId, dimGrpModel) -> {
            TreeMap dimMap = dimGrpModel.getDimMap();
            dimMap.computeIfAbsent((String)tempInfo.get("dimensionNumber"), key -> model);
        });
    }

    public static void handleDataPermTab(IFormView formView, String tabIndex) {
        if (HRStringUtils.equals((String)"3", (String)tabIndex)) {
            RoleServiceHelper.reloadDataPermContainer(formView, true);
        }
    }

    public static boolean checkPermDataComplete(IFormView formView, IFormPlugin confirmCallBackPlugin) {
        if ("tabpageap3".equals(((Tab)formView.getControl("guidecontent")).getCurrentTab())) {
            String roleProperty = (String)formView.getModel().getValue("property");
            StringBuilder processInfo = new StringBuilder();
            return RoleServiceHelper.checkPermDataComplete(formView, roleProperty, true, processInfo, confirmCallBackPlugin);
        }
        return false;
    }

    public static boolean checkBaseInfo(IFormView formView) {
        boolean result = false;
        String tabIndex = formView.getPageCache().get("wizardTabIndex");
        if (HRStringUtils.equals((String)"0", (String)tabIndex) || HRStringUtils.isEmpty((String)tabIndex)) {
            IDataModel model = formView.getModel();
            OrmLocaleValue roleName = (OrmLocaleValue)model.getValue("name");
            String roleNumber = (String)model.getValue("number");
            if (HRStringUtils.isEmpty((String)roleNumber)) {
                result = true;
                FieldTip numberTip = RoleServiceHelper.showValidatTip(formView, false, ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewRoleWizardHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "number");
                formView.showFieldTip(numberTip);
            }
            if (Objects.isNull(roleName) || roleName.size() == 0 || HRStringUtils.isEmpty((String)roleName.getLocaleValue())) {
                result = true;
                FieldTip nameTip = RoleServiceHelper.showValidatTip(formView, false, ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewRoleWizardHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "name");
                formView.showFieldTip(nameTip);
            }
            result = result | NewRoleWizardHelper.validateRoleType(formView) | NewRoleWizardHelper.validateCreateAdminGrp(formView);
        }
        return result;
    }

    private static boolean validateRoleType(IFormView formView) {
        Object value = formView.getModel().getValue("roletype");
        if (value == null) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u79cd\u201c\u89d2\u8272\u7c7b\u578b\u201d\u3002", (String)"NewRoleWizardHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            return true;
        }
        String[] types = value.toString().split(",");
        int size = (int)Arrays.stream(types).filter(HRStringUtils::isNotEmpty).count();
        if (size > 5) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u201c\u89d2\u8272\u7c7b\u578b\u201d\u957f\u5ea6\u8fc7\u957f\uff0c\u5efa\u8bae\u52fe\u9009\u4e0d\u8d85\u8fc75\u9879\u3002", (String)"NewRoleWizardHelper_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static boolean validateCreateAdminGrp(IFormView formView) {
        DynamicObjectCollection collection;
        long count;
        DynamicObject dataEntity = formView.getModel().getDataEntity(true);
        DynamicObject createAdminGrp = dataEntity.getDynamicObject("createadmingrp");
        String useScope = dataEntity.getString("usescope");
        boolean noCreateAdminGrp = null == createAdminGrp;
        boolean flag = false;
        if (HRStringUtils.equals((String)"0", (String)useScope)) {
            if (noCreateAdminGrp) {
                NewRoleWizardHelper.showNoCreateAdminGrpTip(formView);
                flag = true;
            }
        } else if (HRStringUtils.equals((String)"1", (String)useScope)) {
            if (noCreateAdminGrp) {
                NewRoleWizardHelper.showNoCreateAdminGrpTip(formView);
                flag = true;
            }
        } else if (HRStringUtils.equals((String)"2", (String)useScope) && (count = (collection = dataEntity.getDynamicObjectCollection("entryentity")).stream().filter(it -> it.getLong("admingroup.id") > 0L).count()) > 0L && noCreateAdminGrp) {
            NewRoleWizardHelper.showNoCreateAdminGrpTip(formView);
            flag = true;
        }
        if (!flag) {
            FieldTip createAdminGrpTip = RoleServiceHelper.showValidatTip(formView, true, ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NewRoleWizardHelper_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "createadmingrp");
            formView.showFieldTip(createAdminGrpTip);
        }
        return flag;
    }

    private static void showNoCreateAdminGrpTip(IFormView formView) {
        FieldTip createAdminGrpTip = RoleServiceHelper.showValidatTip(formView, false, ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NewRoleWizardHelper_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "createadmingrp");
        formView.showFieldTip(createAdminGrpTip);
    }
}

