/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.PermCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.helper.DynamicFormHelper;
import kd.hr.hrcs.common.constants.MethodSource;
import kd.hr.hrcs.common.constants.perm.PermOrgConst;
import kd.hr.hrcs.common.model.RoleRuleInfo;

public class OrgTeamStructProjectServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(OrgTeamStructProjectServiceHelper.class);

    public static List<Map<String, Object>> queryStructProConfig(String entityNumber, String propKey, Map<String, Object> customParam) {
        return OrgTeamStructProjectServiceHelper.queryStructProConfig(entityNumber, propKey, null, customParam);
    }

    public static List<Map<String, Object>> queryStructProConfig(String entityNumber, String propKey, String propBdNumber, Map<String, Object> customParam) {
        long start = System.currentTimeMillis();
        HashMap propMap = Maps.newHashMapWithExpectedSize((int)1);
        propMap.put("propkey", Lists.newArrayList((Object[])new String[]{propKey}));
        if (HRStringUtils.isNotEmpty((String)propBdNumber)) {
            propMap.put("baseDataType", Lists.newArrayList((Object[])new String[]{propBdNumber}));
        }
        if (customParam.containsKey("needToAllAreasStructProject")) {
            propMap.put("needToAllAreasStructProject", customParam.get("needToAllAreasStructProject"));
        }
        HashMap structConfigParam = Maps.newHashMapWithExpectedSize((int)1);
        structConfigParam.put(entityNumber, propMap);
        List viewUseConfig = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"batchQueryStructProConfig", (Object[])new Object[]{structConfigParam});
        LOGGER.info("OrgTeamStructProjectServiceHelper queryStructProConfig result,cost_mills:{},param:entityNumber={},propKey={},propBdNumber={},return:{}", new Object[]{System.currentTimeMillis() - start, entityNumber, propKey, propBdNumber, viewUseConfig});
        return viewUseConfig;
    }

    public static List<Map<String, Object>> batchQueryStructProConfig(Map<String, Map<String, List<String>>> structConfigParam) {
        long start = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(structConfigParam)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        List viewUseConfig = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"batchQueryStructProConfig", (Object[])new Object[]{structConfigParam});
        LOGGER.info("OrgTeamStructProjectServiceHelper batchQueryStructProConfig result,cost_mills:{},param:{}, return:{}", new Object[]{System.currentTimeMillis() - start, structConfigParam, viewUseConfig});
        return viewUseConfig;
    }

    public static Map<Long, Long> queryStructRootOrg(List<Long> structFromParam) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_structproject");
        DynamicObjectCollection coll = helper.queryOriginalCollection("id,rootorg.id", new QFilter[]{new QFilter("id", "in", structFromParam)});
        HashMap structRootMap = Maps.newHashMapWithExpectedSize((int)structFromParam.size());
        for (DynamicObject dyna : coll) {
            structRootMap.put(dyna.getLong("id"), dyna.getLong("rootorg.id"));
        }
        return structRootMap;
    }

    private static List<Long> parseStructListFromMap(List<Map<String, Object>> structProConfigs) {
        ArrayList structFromHaos = Lists.newArrayListWithExpectedSize((int)16);
        for (Map<String, Object> structProConfig : structProConfigs) {
            List structProjectMaps = (List)structProConfig.get("structproject");
            for (Map singleStructProject : structProjectMaps) {
                Long structProjectId = (Long)singleStructProject.get("id");
                if (structProjectId == null) continue;
                structFromHaos.add(structProjectId);
            }
        }
        return structFromHaos;
    }

    public static List<Long> queryStructIdsFromHaos(String entityNumber, String propKey, Map<String, Object> customParam) {
        List<Map<String, Object>> structProConfigs = null;
        String propBdNumber = DynamicFormHelper.getPropTypeFromDynamicForm(entityNumber, propKey);
        structProConfigs = HRStringUtils.isEmpty((String)propBdNumber) ? OrgTeamStructProjectServiceHelper.queryStructProConfig(entityNumber, propKey, customParam) : OrgTeamStructProjectServiceHelper.queryStructProConfig(entityNumber, propKey, propBdNumber, customParam);
        return OrgTeamStructProjectServiceHelper.parseStructListFromMap(structProConfigs);
    }

    public static Map<Long, Long> queryStructDependMapFromHaos(String entityNumber, String propKey) {
        List<Long> structIds = OrgTeamStructProjectServiceHelper.queryStructIdsFromHaos(entityNumber, propKey, Maps.newHashMap());
        return OrgTeamStructProjectServiceHelper.queryDependStructProject(structIds);
    }

    public static void setStructProjectConfig(String entityNumber, Map<String, List<RoleRuleInfo>> colmDimRelatMap, Map<String, Object> customParam) {
        HashMap structConfigParam = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entityPropKeyMap = Maps.newHashMapWithExpectedSize((int)16);
        structConfigParam.put(entityNumber, entityPropKeyMap);
        Map<String, String> dynaFormPropEntityNumberMap = DynamicFormHelper.getMultiPropEnityNumber(entityNumber);
        for (Map.Entry<String, List<RoleRuleInfo>> entry : colmDimRelatMap.entrySet()) {
            List<RoleRuleInfo> colmDimRelats = entry.getValue();
            for (RoleRuleInfo colmDimRelat : colmDimRelats) {
                if (!HRStringUtils.equals((String)colmDimRelat.getDimensionType(), (String)"orgteam")) continue;
                List propKeys = entityPropKeyMap.getOrDefault("propkey", Lists.newArrayListWithExpectedSize((int)16));
                propKeys.add(colmDimRelat.getPropkey());
                entityPropKeyMap.put("propkey", propKeys);
                if (CollectionUtils.isEmpty(dynaFormPropEntityNumberMap)) continue;
                List propBdNumbers = entityPropKeyMap.getOrDefault("baseDataType", Lists.newArrayListWithExpectedSize((int)16));
                propBdNumbers.add(dynaFormPropEntityNumberMap.get(colmDimRelat.getPropkey()));
                entityPropKeyMap.put("baseDataType", propBdNumbers);
            }
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)entityPropKeyMap.get("propkey")))) {
            LOGGER.info("OrgTeamStructProjectServiceHelper batchQueryStructProConfig propKeys is empty. No need to invoke.");
            return;
        }
        List<Map<String, Object>> structConfigList = OrgTeamStructProjectServiceHelper.batchQueryStructProConfig(structConfigParam);
        Map<Long, DynamicObject> allStructProjectMap = OrgTeamStructProjectServiceHelper.queryStructProjectInfo();
        for (Map.Entry<String, List<RoleRuleInfo>> entry : colmDimRelatMap.entrySet()) {
            List<RoleRuleInfo> colmDimRelats = entry.getValue();
            for (RoleRuleInfo colmDimRelat : colmDimRelats) {
                Map<String, Object> structConfig = OrgTeamStructProjectServiceHelper.pickColmStructConfig(colmDimRelat.getEntityNum(), colmDimRelat.getPropkey(), structConfigList);
                if (structConfig == null || structConfig.size() == 0) continue;
                LinkedHashMap structProjectMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
                LinkedHashMap structRootOrgMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
                List structProjectMaps = (List)structConfig.get("structproject");
                for (Map singleStructProject : structProjectMaps) {
                    List<Long> structFromParam;
                    Long structProjectId = (Long)singleStructProject.get("id");
                    if (structProjectId == null || (structFromParam = PermCheckService.getStructProjectIdsFromCustomParam(customParam, colmDimRelat.getPropkey())) != null && (structFromParam == null || !structFromParam.contains(structProjectId))) continue;
                    Long dependId = OrgTeamStructProjectServiceHelper.pickDependStructId(allStructProjectMap, structProjectId);
                    structProjectMap.put(structProjectId, dependId);
                    if (dependId != null && !Objects.equals(dependId, 0L)) {
                        structRootOrgMap.put(structProjectId, OrgTeamStructProjectServiceHelper.pickRootOrgId(allStructProjectMap, dependId));
                        continue;
                    }
                    structRootOrgMap.put(structProjectId, OrgTeamStructProjectServiceHelper.pickRootOrgId(allStructProjectMap, structProjectId));
                }
                colmDimRelat.setStructProjectMap((Map)structProjectMap);
                colmDimRelat.setStructRootMap((Map)structRootOrgMap);
            }
        }
    }

    private static Map<String, Object> pickColmStructConfig(String entity, String propKey, List<Map<String, Object>> structConfigList) {
        for (Map<String, Object> structConfig : structConfigList) {
            if (!HRStringUtils.equals((String)((String)structConfig.get("entitytype")), (String)entity) || !HRStringUtils.equals((String)((String)structConfig.get("propkey")), (String)propKey)) continue;
            return structConfig;
        }
        return null;
    }

    private static Map<Long, DynamicObject> queryStructProjectInfo() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_structproject");
        DynamicObjectCollection structDynaColl = helper.queryOriginalCollection("id,relyonstructproject.id,rootorg.id", new QFilter[0]);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject structDyna : structDynaColl) {
            result.put(structDyna.getLong("id"), structDyna);
        }
        return result;
    }

    public static Map<Long, Long> queryDependStructProject(List<Long> structProjectList) {
        if (CollectionUtils.isEmpty(structProjectList)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<Long, DynamicObject> allStructInfoMap = OrgTeamStructProjectServiceHelper.queryStructProjectInfo();
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (Long structId : structProjectList) {
            result.put(structId, OrgTeamStructProjectServiceHelper.pickDependStructId(allStructInfoMap, structId));
        }
        return result;
    }

    private static Long pickDependStructId(Map<Long, DynamicObject> allStructInfoMap, Long structId) {
        Long dependId = 0L;
        DynamicObject structDyna = allStructInfoMap.get(structId);
        if (structDyna != null) {
            dependId = structDyna.getLong("relyonstructproject.id");
        }
        return dependId;
    }

    private static Long pickRootOrgId(Map<Long, DynamicObject> allStructInfoMap, Long structId) {
        Long rootOrgId = 0L;
        DynamicObject structDyna = allStructInfoMap.get(structId);
        if (structDyna != null) {
            rootOrgId = structDyna.getLong("rootorg.id");
        }
        return rootOrgId;
    }

    public static List<Long> queryStructProjectByClassify(Long otClassifyId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_structproject");
        DynamicObjectCollection structDynaColl = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("otclassify", "=", (Object)otClassifyId)});
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject structDyna : structDynaColl) {
            result.add(structDyna.getLong("id"));
        }
        return result;
    }

    public static void resetStructProjectParam(Map<String, Object> customParam, String entityNumber, String propKey, String methodSource) {
        List<Long> structFromParam = PermCheckService.getStructProjectIdsFromCustomParam(customParam, propKey);
        structFromParam = CollectionUtils.isEmpty(structFromParam) ? OrgTeamStructProjectServiceHelper.queryStructProjectByClassify(PermOrgConst.OT_CLASSIFY_ADMIN_FUNC_ID) : OrgTeamStructProjectServiceHelper.convertToLongList(structFromParam);
        String cascadeFullPropKey = OrgTeamStructProjectServiceHelper.queryCascadeFullPropKey(entityNumber, propKey, methodSource);
        List<Long> structFromHaos = OrgTeamStructProjectServiceHelper.queryStructIdsFromHaos(entityNumber, cascadeFullPropKey, Maps.newHashMap());
        structFromParam.retainAll(structFromHaos);
        customParam.put("hr_dataperm_structprojectid_prop_" + propKey, structFromParam);
    }

    public static String queryCascadeFullPropKey(String entityNumber, String propKey, String methodSource) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObjectCollection dimPropRelatColl = helper.queryOriginalCollection("entryentity.dimension.datasource,entryentity.propkey,entryentity.authrange", new QFilter[]{new QFilter("entitytype.id", "=", (Object)entityNumber)});
        if (dimPropRelatColl == null || dimPropRelatColl.size() == 0) {
            return propKey;
        }
        for (DynamicObject dyna : dimPropRelatColl) {
            if (!HRStringUtils.equals((String)dyna.getString("entryentity.dimension.datasource"), (String)"orgteam")) continue;
            String authRange = dyna.getString("entryentity.authrange");
            String propKeyInDb = dyna.getString("entryentity.propkey");
            if (!propKeyInDb.contains(propKey + ".") || !HRStringUtils.equals((String)authRange, (String)MethodSource.METHOD_ALL.getCode()) && !HRStringUtils.equals((String)authRange, (String)methodSource)) continue;
            return propKeyInDb;
        }
        return propKey;
    }

    private static List<Long> convertToLongList(List list) {
        ArrayList structFromParam = Lists.newArrayListWithExpectedSize((int)list.size());
        for (Object structId : list) {
            if (structId instanceof Integer) {
                structFromParam.add(((Integer)structId).longValue());
                continue;
            }
            if (structId instanceof Long) {
                structFromParam.add((Long)structId);
                continue;
            }
            LOGGER.error("convertToLongList error. structId:{}", structId);
        }
        return structFromParam;
    }
}

