/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.extpoint.permission.role.IRoleDimF7CustomFilterPlugin;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermCommonTreeSupplier;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.constants.perm.PermDimTreeEntryModel;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class PermCommonTreeHelper {
    private static final Log LOG = LogFactory.getLog(PermCommonTreeHelper.class);
    private static final Map<String, String> NUMBER_STRUCT_MAP = Maps.newHashMapWithExpectedSize((int)4);
    private static final Map<String, String> NUMBER_ID_MAP = Maps.newHashMapWithExpectedSize((int)4);
    private static final Map<String, String> NUMBER_NAME_MAP = Maps.newHashMapWithExpectedSize((int)4);
    private static final Map<String, String> NUMBER_PARENT_MAP = Maps.newHashMapWithExpectedSize((int)2);

    private PermCommonTreeHelper() {
    }

    public static PermCommonTreeHelper getInstance() {
        return PermCommonTreeHandler.INSTANCE;
    }

    public TreeNode buildTree(IFormView formView, String text) {
        String currentHrBuFunc = (String)formView.getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        boolean skipPermissionControl = HRStringUtils.equals((String)"1", (String)((String)formView.getFormShowParameter().getCustomParam("skipPermissionControl")));
        TreeNode rootNode = this.getRootNode(formView);
        DynamicObject[] infos = this.getDataInfo(formView, text);
        Pair<Boolean, List<Long>> permAdminFunc = PermCommonTreeHelper.getHasPermAdminFunc(currentHrBuFunc, skipPermissionControl);
        TreeView treeview = (TreeView)formView.getControl("treeview");
        HRPageCache pageCache = new HRPageCache(formView);
        HashMap dataInfo = Maps.newHashMapWithExpectedSize((int)infos.length);
        HashMap parentMap = Maps.newHashMapWithExpectedSize((int)infos.length);
        ArrayList nodeList = Lists.newArrayListWithCapacity((int)infos.length);
        String disabledPostfix = ResManager.loadKDString((String)"\uff08\u7981\u7528\uff09", (String)"PermCommonTreeHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        for (DynamicObject dynamicObject : infos) {
            Map tempNode;
            Map<String, String> nodeValue = this.getNodeValue(formView, dynamicObject);
            String nodeId = nodeValue.get("id");
            String nodeName = nodeValue.get("name");
            String nodeNumber = nodeValue.get("number");
            String parentId = nodeValue.get("parent");
            if (dataInfo.containsKey(nodeId)) continue;
            if (HRStringUtils.equals((String)"0", (String)parentId) || HRStringUtils.isEmpty((String)parentId)) {
                rootNode.setLongNumber(nodeNumber);
                if (!((Boolean)permAdminFunc.getKey()).booleanValue()) {
                    rootNode.setDisabled(!((List)permAdminFunc.getValue()).contains(Long.parseLong(nodeId)));
                }
                treeview.addNode(rootNode);
                treeview.expand(rootNode.getId());
            } else {
                if ("0".equals(nodeValue.get("enable"))) {
                    nodeName = nodeName + disabledPostfix;
                }
                TreeNode treeNode = new TreeNode(parentId, nodeId, nodeName);
                treeNode.setLongNumber(nodeNumber);
                if (!((Boolean)permAdminFunc.getKey()).booleanValue()) {
                    treeNode.setDisabled(!((List)permAdminFunc.getValue()).contains(Long.parseLong(nodeId)));
                }
                nodeList.add(treeNode);
                if (!HRStringUtils.isEmpty((String)text)) {
                    treeview.expand(treeNode.getId());
                }
            }
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)3);
            HashMap<String, HashMap> childrenMap = (HashMap<String, HashMap>)parentMap.get(parentId);
            if (CollectionUtils.isEmpty((Map)childrenMap)) {
                childrenMap = new HashMap<String, HashMap>(16);
            }
            if (Objects.isNull(tempNode = (Map)childrenMap.get(nodeId))) {
                childrenMap.put(nodeId, tempMap);
                parentMap.put(parentId, childrenMap);
            }
            tempMap.put("id", nodeId);
            tempMap.put("name", nodeName);
            tempMap.put("number", nodeNumber);
            tempMap.put("parentId", parentId);
            dataInfo.put(nodeId, tempMap);
        }
        Map<String, List<TreeNode>> parent2Child = nodeList.stream().collect(Collectors.groupingBy(TreeNode::getParentid));
        parent2Child.values().forEach(nodes -> nodes.forEach(node -> node.setChildren((List)parent2Child.get(node.getId()))));
        List<TreeNode> rootChilds = parent2Child.get(rootNode.getId());
        LOG.info("buildTree() rootChilds.length:{}", (Object)(rootChilds == null ? 0 : rootChilds.size()));
        rootNode.setChildren(rootChilds);
        dataInfo.entrySet().forEach(item -> {
            Map m = (Map)item.getValue();
            m.put("haschildren", CollectionUtils.isEmpty((Collection)((Collection)parent2Child.get(item.getKey()))) ? "0" : "1");
        });
        HashMap treeProMap = Maps.newHashMapWithExpectedSize((int)1);
        treeProMap.put("cpn", Boolean.FALSE);
        formView.updateControlMetadata("treeview", (Map)treeProMap);
        pageCache.put("dataInfo", (Object)dataInfo);
        pageCache.put("parentMap", (Object)parentMap);
        TreeNode tempFinalTreeNode = rootNode;
        HRPluginProxy proxy = new HRPluginProxy(null, IRoleDimF7CustomFilterPlugin.class, "kd.hr.hrcs.formplugin.web.perm.role.component.CustomCtrlPlugin#beforeF7Select", null);
        List treeNodeList = proxy.callReplace(p -> p.postProcessTreeNode(Collections.singletonList(tempFinalTreeNode), formView.getFormShowParameter().getCustomParams())).stream().filter(Objects::nonNull).findFirst().orElseGet(() -> Collections.singletonList(tempFinalTreeNode));
        rootNode = treeNodeList.stream().findFirst().orElse(tempFinalTreeNode);
        LOG.info("Complete tree node post process.");
        return rootNode;
    }

    public TreeNode getRootNode(IFormView formView) {
        List<QFilter> baseFilter = PermCommonTreeSupplier.getInstance().getFilter(formView);
        String entityNumber = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        LOG.info("getRootNode() entityNumber:{}", (Object)entityNumber);
        baseFilter.add(new QFilter(NUMBER_PARENT_MAP.getOrDefault(entityNumber, "parent"), "=", (Object)0));
        HRBaseServiceHelper helper = new HRBaseServiceHelper(NUMBER_STRUCT_MAP.getOrDefault(entityNumber, entityNumber));
        String id = NUMBER_ID_MAP.getOrDefault(entityNumber, "id");
        String name = NUMBER_NAME_MAP.getOrDefault(entityNumber, "name");
        DynamicObject org = helper.queryOriginalOne(id + "," + name, HRPermCommonUtil.listToQFilters(baseFilter));
        if (Objects.isNull(org)) {
            LOG.error("getRootNode() is null.");
            return new TreeNode("", OrgServiceUtil.getHRRootOrgId() + "", "ALL", true);
        }
        TreeNode rootNode = new TreeNode("", org.getString(id), org.getString(name), true);
        LOG.info("getRootNode() rooNode:{}", (Object)rootNode);
        formView.getPageCache().put("treeViewRootNodeId", rootNode.getId());
        return rootNode;
    }

    public DynamicObject[] getDataInfo(IFormView formView, String text) {
        String entityNumber = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        LOG.info("getDataInfo() entityNumber:{}", (Object)entityNumber);
        Map<String, Supplier<DynamicObject[]>> dataInfoAction = PermCommonTreeSupplier.getInstance().getDataInfoAction(formView, text);
        Supplier<DynamicObject[]> supplier = dataInfoAction.get(entityNumber);
        DynamicObject[] infos = Objects.isNull(supplier) ? PermCommonTreeSupplier.getInstance().getDataInfoCommon(formView, text) : supplier.get();
        return infos;
    }

    public static Pair<Boolean, List<Long>> getHasPermAdminFunc(String currentHrBuFunc, boolean skipPermissionControl) {
        long level = HRPermServiceHelper.getUserGroupMinLevel();
        if (skipPermissionControl || HRStringUtils.isEmpty((String)currentHrBuFunc) || level >= 0L && level <= 2L) {
            return Pair.of((Object)true, Collections.emptyList());
        }
        long currentHRbuCaFunc = Long.parseLong(currentHrBuFunc);
        List<Long> adminGroupOrgIds = HRPermServiceHelper.getAdminGroupFunc(currentHRbuCaFunc);
        return Pair.of((Object)false, adminGroupOrgIds);
    }

    private Map<String, String> getNodeValue(IFormView formView, DynamicObject dynamicObject) {
        String entityNumber = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        Map<String, Supplier<Map<String, String>>> treeNodeValueAction = PermCommonTreeSupplier.getInstance().getTreeNodeValueAction(dynamicObject);
        Supplier<Map<String, String>> valueSupplier = treeNodeValueAction.get(entityNumber);
        Map<String, String> nodeValue = Objects.isNull(valueSupplier) ? PermCommonTreeSupplier.getInstance().getNodeValue4Common(dynamicObject) : valueSupplier.get();
        return nodeValue;
    }

    public static String queryChildren(Map<String, Map<String, Map<String, String>>> parentMap, List<TreeNode> nodeList, Map.Entry<String, Map<String, String>> childDataEntry) {
        String childId = childDataEntry.getKey();
        Map<String, String> childDataInfo = childDataEntry.getValue();
        Map<String, Map<String, String>> tempMap = parentMap.get(childId);
        boolean isParent = false;
        if (!CollectionUtils.isEmpty(tempMap)) {
            isParent = true;
        }
        nodeList.add(new TreeNode(childDataInfo.get("parentId"), childDataInfo.get("id"), childDataInfo.get("name"), isParent));
        return childId;
    }

    private static void getChildrenNodes(String id, Map<String, Map<String, Map<String, String>>> parentMap, Set<String> nodeSet) {
        Map<String, Map<String, String>> childrenMap = parentMap.get(id);
        if (CollectionUtils.isEmpty(childrenMap)) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> tempMap : childrenMap.entrySet()) {
            Map<String, String> child = tempMap.getValue();
            String nodeId = child.get("id");
            PermCommonTreeHelper.getChildrenNodes(nodeId, parentMap, nodeSet);
            nodeSet.add(nodeId);
        }
    }

    private static void buildCheckNodes(IDataModel model, int index, String id, Map<String, Map<String, Map<String, String>>> parentMap, List<TreeNode> nodeList, String rootNodeId, Set<String> existedIds) {
        Map<String, Map<String, String>> childrenMap = parentMap.get(id);
        if (CollectionUtils.isEmpty(childrenMap)) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> tempMap : childrenMap.entrySet()) {
            Map<String, String> child = tempMap.getValue();
            String parentId = child.get("parentId");
            String childId = child.get("id");
            String name = child.get("name");
            if (existedIds.contains(childId)) continue;
            PermCommonTreeHelper.buildCheckNodes(model, index, childId, parentMap, nodeList, rootNodeId, existedIds);
            Map<String, Map<String, String>> tempChilrenMap = parentMap.get(childId);
            boolean isParent = false;
            if (!CollectionUtils.isEmpty(tempChilrenMap)) {
                isParent = true;
            }
            if (!HRStringUtils.equals((String)rootNodeId, (String)childId)) {
                model.insertEntryRow("entryentity", index);
                model.setValue("id", (Object)childId, index);
                model.setValue("name", (Object)name, index);
                model.setValue("number", (Object)child.get("number"), index);
                model.setValue("haschildren", (Object)(isParent ? "1" : "0"), index);
                ++index;
            }
            TreeNode treeNode = new TreeNode(parentId, childId, name, isParent);
            treeNode.setLongNumber(child.get("number"));
            nodeList.add(treeNode);
        }
    }

    public void handleTreeNodeCheck(IFormView formView, TreeNodeCheckEvent treeNodeCheckEvent, List<String> notHasRightIds) {
        IPageCache cache = formView.getPageCache();
        String deleteEntryFlag = cache.get("deleteEntry");
        if (HRStringUtils.isNotEmpty((String)deleteEntryFlag)) {
            return;
        }
        TreeView treeView = (TreeView)treeNodeCheckEvent.getSource();
        IDataModel model = formView.getModel();
        boolean checked = treeNodeCheckEvent.getChecked();
        String nodeid = (String)treeNodeCheckEvent.getNodeId();
        treeNodeCheckEvent.getExpandedNode();
        boolean includeSub = (Boolean)model.getValue("cbincludesub");
        HRPageCache pageCache = new HRPageCache(formView);
        String rootNodeId = (String)pageCache.get("treeViewRootNodeId", String.class);
        DynamicObjectCollection collection = model.getEntryEntity("entryentity");
        Map parentMap = (Map)pageCache.get("parentMap", Map.class);
        if (checked) {
            int index = collection.size();
            ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
            model.beginInit();
            Map dataInfoMap = (Map)pageCache.get("dataInfo", Map.class);
            Map dataInfo = (Map)dataInfoMap.get(nodeid);
            String id = (String)dataInfo.get("id");
            Set<String> existedIds = collection.stream().map(dyno -> dyno.getString("id")).collect(Collectors.toSet());
            if (!existedIds.contains(dataInfo.get("id"))) {
                model.insertEntryRow("entryentity", index);
                model.setValue("id", dataInfo.get("id"), index);
                model.setValue("name", dataInfo.get("name"), index);
                model.setValue("number", dataInfo.get("number"), index);
                model.setValue("haschildren", dataInfo.get("haschildren"), index);
                ++index;
                if (includeSub) {
                    PermCommonTreeHelper.buildCheckNodes(model, index, id, parentMap, nodeList, rootNodeId, existedIds);
                    treeView.checkNodes(nodeList);
                }
                this.updateMemoryEntry(formView, dataInfo, includeSub, nodeList);
            }
            DynamicObjectCollection entities = model.getEntryEntity("entryentity");
            for (int tmpIndex = 0; !notHasRightIds.isEmpty() && tmpIndex < entities.size(); ++tmpIndex) {
                if (!notHasRightIds.contains(((DynamicObject)entities.get(tmpIndex)).getString("id"))) continue;
                formView.setEnable(Boolean.FALSE, tmpIndex, new String[]{"includesub", "haschildren"});
            }
            model.endInit();
            formView.updateView("entryentity");
        } else {
            ArrayList collectionIndex = Lists.newArrayList();
            ArrayList uncheckList = Lists.newArrayList();
            HashSet childrenNodes = Sets.newHashSet();
            childrenNodes.add(nodeid);
            if (includeSub) {
                PermCommonTreeHelper.getChildrenNodes(nodeid, parentMap, childrenNodes);
            }
            for (int i2 = 0; i2 < collection.size(); ++i2) {
                DynamicObject item = (DynamicObject)collection.get(i2);
                String nodeId = item.getString("id");
                if (!childrenNodes.contains(nodeId)) continue;
                collectionIndex.add(i2);
                uncheckList.add(nodeId);
            }
            if (!CollectionUtils.isEmpty((Collection)collectionIndex)) {
                int[] resultArr = collectionIndex.stream().mapToInt(i -> i).toArray();
                pageCache.put("uncheck", (Object)"1");
                model.deleteEntryRows("entryentity", resultArr);
                pageCache.remove("uncheck");
            }
            if (includeSub || HRStringUtils.equals((String)rootNodeId, (String)nodeid)) {
                treeView.uncheckNodes((List)uncheckList);
            }
            this.deleteMemoryEntry(formView, uncheckList);
        }
    }

    private void updateMemoryEntry(IFormView formView, Map<String, String> dataInfo, boolean includeSub, List<TreeNode> nodeList) {
        String originalEntryValue = formView.getPageCache().get("originalEntryValue");
        if (HRStringUtils.isEmpty((String)originalEntryValue)) {
            return;
        }
        List<PermDimTreeEntryModel> memoryEntry = this.getMemoryEntry(formView);
        PermDimTreeEntryModel parentModel = new PermDimTreeEntryModel();
        parentModel.setId(dataInfo.get("id"));
        parentModel.setNumber(dataInfo.get("number"));
        parentModel.setName(dataInfo.get("name"));
        parentModel.setName(dataInfo.get("haschildren"));
        memoryEntry.add(parentModel);
        if (includeSub) {
            nodeList.forEach(node -> {
                PermDimTreeEntryModel model = new PermDimTreeEntryModel();
                model.setId(node.getId());
                model.setNumber(node.getLongNumber());
                model.setName(node.getText());
                model.setHaschildren(!Objects.isNull(node.getChildren()));
                memoryEntry.add(model);
            });
        }
        formView.getPageCache().put("originalEntryValue", SerializationUtils.toJsonString(memoryEntry));
    }

    private void deleteMemoryEntry(IFormView formView, List<String> uncheckList) {
        String originalEntryValue = formView.getPageCache().get("originalEntryValue");
        if (HRStringUtils.isEmpty((String)originalEntryValue)) {
            return;
        }
        List<PermDimTreeEntryModel> memoryEntry = this.getMemoryEntry(formView);
        memoryEntry.removeIf(model -> uncheckList.contains(model.getId()));
        formView.getPageCache().put("originalEntryValue", SerializationUtils.toJsonString(memoryEntry));
    }

    public List<PermDimTreeEntryModel> getMemoryEntry(IFormView formView) {
        List memoryEntryTemp = SerializationUtils.fromJsonStringToList((String)formView.getPageCache().get("originalEntryValue"), PermDimTreeEntryModel.class);
        if (CollectionUtils.isEmpty((Collection)memoryEntryTemp)) {
            return Lists.newArrayListWithExpectedSize((int)1);
        }
        return memoryEntryTemp.stream().sorted(Comparator.comparing(PermDimTreeEntryModel::getSeq)).collect(Collectors.toList());
    }

    public static void handleClearAll(IFormView formView) {
        EntryGrid eg = (EntryGrid)formView.getControl("entryentity");
        int[] selectRows = eg.getSelectRows();
        if (selectRows.length <= 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6e05\u7a7a\u7684\u6570\u636e\u3002", (String)"PermCommonTreeHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            return;
        }
        TreeView treeView = (TreeView)formView.getControl("treeview");
        ArrayList selectRowIds = Lists.newArrayListWithExpectedSize((int)selectRows.length);
        for (int selectRow : selectRows) {
            String nodeId = (String)formView.getModel().getValue("id", selectRow);
            selectRowIds.add(nodeId);
        }
        treeView.uncheckNodes((List)selectRowIds);
        formView.getModel().deleteEntryRows("entryentity", selectRows);
        eg.selectRows(-1);
        if (!HRStringUtils.isEmpty((String)formView.getPageCache().get("originalEntryValue"))) {
            List<PermDimTreeEntryModel> memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(formView);
            memoryEntry.removeIf(model -> selectRowIds.contains(model.getId()));
            formView.getPageCache().put("originalEntryValue", SerializationUtils.toJsonString(memoryEntry));
        }
    }

    public static void handleOk(IFormView formView) {
        DynamicObjectCollection collection = formView.getModel().getEntryEntity("entryentity");
        String controlId = (String)formView.getFormShowParameter().getCustomParam("controlId");
        String dimensionNumber = (String)formView.getFormShowParameter().getCustomParam("dimensionNumber");
        String dimId = (String)formView.getFormShowParameter().getCustomParam("dimId");
        String htmlControlKey = (String)formView.getFormShowParameter().getCustomParam("htmlControlKey");
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)3);
        returnData.put("controlId", controlId);
        returnData.put("dimensionNumber", dimensionNumber);
        returnData.put("dimId", dimId);
        returnData.put("collection", collection);
        returnData.put("htmlControlKey", htmlControlKey);
        formView.returnDataToParent((Object)returnData);
        formView.close();
    }

    static {
        NUMBER_STRUCT_MAP.put("bos_org", "bos_org_structure");
        NUMBER_STRUCT_MAP.put("haos_adminorgteam", "haos_adminorgstructure");
        NUMBER_STRUCT_MAP.put("haos_adminorghr", "haos_adminorgstruct");
        NUMBER_ID_MAP.put("bos_org", "org.id");
        NUMBER_ID_MAP.put("haos_adminorgteam", "orgteam.id");
        NUMBER_ID_MAP.put("haos_adminorghr", "adminorg.id");
        NUMBER_NAME_MAP.put("bos_org", "org.name");
        NUMBER_NAME_MAP.put("haos_adminorgteam", "orgteam.name");
        NUMBER_NAME_MAP.put("haos_adminorghr", "adminorg.name");
        NUMBER_PARENT_MAP.put("haos_adminorgteam", "parentorgteam");
        NUMBER_PARENT_MAP.put("haos_adminorghr", "parentorg");
    }

    private static class PermCommonTreeHandler {
        private static final PermCommonTreeHelper INSTANCE = new PermCommonTreeHelper();

        private PermCommonTreeHandler() {
        }
    }
}

