/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hrcs.bussiness.servicehelper.MsgCenterServiceHelper;
import kd.hr.hrcs.bussiness.util.CalculateUtil;

public class PermFileSyncServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(PermFileSyncServiceHelper.class);
    private static final String PERFILE_STATUS_DISABLE = "0";
    private static final String PERFILE_STATUS_ENABLE = "1";
    private static final String BUSINESS_STATUS_ENABLE = "1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public static HRMServiceResult consumerSaveMsg(DynamicObject tplDy) {
        String contentBase64 = tplDy.getString("msgcontent");
        Map msgContent = (Map)SerializationUtils.deSerializeFromBase64((String)contentBase64);
        LOGGER.info("PermFileSyncServiceHelper-msgInfo:msgNumber:{},msgName:{},recordId:{}", new Object[]{tplDy.get("number"), null == tplDy.get("name") ? "" : tplDy.get("name").toString(), msgContent.get("recordId")});
        boolean successFlag = true;
        try {
            Map<String, Object> fourDataMap = PermFileSyncServiceHelper.getChgInfoByRecordId(msgContent.get("recordId"));
            if (CollectionUtils.isEmpty(fourDataMap)) {
                successFlag = true;
                LOGGER.info("PermFileSyncServiceHelper-consumer-msg:req-fourData-finished-recordId={}", msgContent.get("recordId"));
                HRMServiceResult hRMServiceResult = HRMServiceResult.success();
                return hRMServiceResult;
            }
            DynamicObject[] erManFiles = PermFileSyncServiceHelper.getErmanFiles(fourDataMap);
            if (null == erManFiles || erManFiles.length == 0) {
                successFlag = false;
                LOGGER.info("PermFileSyncServiceHelper-erManFiles-count-is-null.");
                HRMServiceResult exc = HRMServiceResult.fail((String)"consumer-msg-fail:req-getErManFiles-error.");
                return exc;
            }
            LOGGER.info("PermFileSyncServiceHelper-count:{}", (Object)erManFiles.length);
            DynamicObject erManFile = erManFiles[0];
            if (!"1".equals(erManFile.getString("businessstatus"))) {
                LOGGER.info("PermFileSyncServiceHelper-erManFiles-status-is:{}", (Object)erManFile.getString("businessstatus"));
                HRMServiceResult exc = HRMServiceResult.success();
                return exc;
            }
            boolean isNeedSync = PermFileSyncServiceHelper.chkFileType(erManFile);
            if (!isNeedSync) {
                LOGGER.info("PermFileSyncServiceHelper-erManFiles-chkFileType-result:false");
                HRMServiceResult exc = HRMServiceResult.success();
                return exc;
            }
            DynamicObject person = erManFile.getDynamicObject("person");
            Object sysUserId = PermFileSyncServiceHelper.getSysUserId((Long)person.getPkValue());
            LOGGER.info("PermFileSyncServiceHelper-sysUserId:{}", sysUserId);
            if (null != sysUserId) {
                PermFileSyncServiceHelper.syncUserPermFile(erManFile, sysUserId, tplDy);
            }
        }
        catch (Exception exc) {
            successFlag = false;
            LOGGER.error("PermFileSyncServiceHelper-consumer-msg-fail.", (Throwable)exc);
        }
        finally {
            try {
                String successMsg = ResManager.loadKDString((String)"\u6743\u9650\u6863\u6848\u540c\u6b65\u6210\u529f\u3002", (String)"PermFileSyncServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                String failMsg = ResManager.loadKDString((String)"\u540c\u6b65\u6743\u9650\u6863\u6848\u5931\u8d25\u3002", (String)"PermFileSyncServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                PermFileSyncServiceHelper.rspConsumerMsg(tplDy, successFlag, successMsg, failMsg);
            }
            catch (Exception exc) {
                LOGGER.error("PermFileSyncServiceHelper-rsp-consumer-msg-fail.", (Throwable)exc);
            }
        }
        LOGGER.info("PermFileSyncServiceHelper-consumer-msg-finished:msgNumber={}", tplDy.get("number"));
        return HRMServiceResult.success();
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] getErmanFiles(Map<String, Object> fourDataMap) {
        Map depemp = (Map)fourDataMap.get("hrpi_depemp");
        if (null == depemp) {
            return new DynamicObject[0];
        }
        ArrayList<Long> depEmpIds = new ArrayList<Long>(depemp.size());
        if (!CollectionUtils.isEmpty((Map)depemp)) {
            Long depEmpId = (Long)depemp.get("boid");
            depEmpIds.add(depEmpId);
        }
        LOGGER.info("EventPermService-getErmanFileByDepempId-depEmpIds={}", depEmpIds);
        return (DynamicObject[])HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanFileByDepempId", (Object[])new Object[]{depEmpIds});
    }

    @ExcludeFromJacocoGeneratedReport
    public static void syncUserPermFile(DynamicObject erManFile, Object sysUserId, DynamicObject tplDy) {
        HRBaseServiceHelper actionHelper = new HRBaseServiceHelper("hbss_action");
        DynamicObject msgAction = actionHelper.queryOne(tplDy.get("msgaction"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
        DynamicObject org = (DynamicObject)erManFile.get("org");
        QFilter[] personBuFilter = new QFilter[]{new QFilter("user", "=", sysUserId), new QFilter("org", "=", org.getPkValue())};
        boolean existsPermFile = helper.isExists(personBuFilter);
        if (existsPermFile) {
            DynamicObject userPermFile = helper.queryOne("permfileenable,description", personBuFilter);
            if (PERFILE_STATUS_DISABLE.equals(userPermFile.getString("permfileenable"))) {
                userPermFile.set("permfileenable", (Object)"1");
                userPermFile.set("description", (Object)ResManager.loadKDString((String)"\u7531\u4eba\u5458\u7684%s\u81ea\u52a8\u751f\u6548", (String)"PermFileSyncServiceHelper_4", (String)"hrmp-hrcs-business", (Object[])new Object[]{msgAction.get("name").toString()}));
                helper.updateOne(userPermFile);
            }
        } else {
            DynamicObject newPermFile = helper.generateEmptyDynamicObject();
            newPermFile.set("user", sysUserId);
            newPermFile.set("org", org.getPkValue());
            newPermFile.set("permfileenable", (Object)"1");
            HRBaseServiceHelper bosUserHelper = new HRBaseServiceHelper("bos_user");
            DynamicObject user = bosUserHelper.queryOne("name", sysUserId);
            newPermFile.set("username", user.get("name"));
            newPermFile.set("description", (Object)ResManager.loadKDString((String)"\u7531\u4eba\u5458\u7684%s\u81ea\u52a8\u521b\u5efa", (String)"PermFileSyncServiceHelper_5", (String)"hrmp-hrcs-business", (Object[])new Object[]{msgAction.get("name").toString()}));
            helper.saveOne(newPermFile);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static Object getSysUserId(Long personId) {
        ArrayList<Long> pIds = new ArrayList<Long>(1);
        pIds.add(personId);
        HashMap<String, ArrayList<Long>> idMaps = new HashMap<String, ArrayList<Long>>(1);
        idMaps.put("person", pIds);
        LOGGER.info("getSysUserId invoke IHRPIPersonService.getUserIdByPersonInfo,param:{}", idMaps);
        Map sysUserInfos = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        LOGGER.info("getSysUserId invoke IHRPIPersonService.getUserIdByPersonInfo,result:{}", (Object)sysUserInfos);
        Map sysUserInfoMaps = (Map)sysUserInfos.get("data");
        if (null != sysUserInfoMaps) {
            Map sysUserInfoMap = (Map)sysUserInfoMaps.get(personId);
            return sysUserInfoMap.get("user");
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean chkFileType(DynamicObject erManFile) {
        boolean isNeedSync = true;
        if (null == erManFile.get("person") || null == erManFile.getDynamicObject("filetype")) {
            LOGGER.info("PermFileSyncServiceHelper-erManFiles-chkFileType-result:false, reason:person or filetype is null");
            isNeedSync = false;
        }
        return isNeedSync;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, Object> getChgInfoByRecordId(Object recordId) {
        Map res = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoByRecordId", (Object[])new Object[]{recordId});
        LOGGER.info("PermFileSyncServiceHelper.getChgInfoByRecordId recordId:{},result:{}", recordId, (Object)res);
        boolean reqResult = (Boolean)res.get("success");
        Map<String, Object> fourDataMap = new HashMap<String, Object>(4);
        if (reqResult) {
            Map data = (Map)res.get("data");
            ArrayList fourData = (ArrayList)data.get("data");
            if (null != fourData && !CollectionUtils.isEmpty((Map)((Map)fourData.get(0)))) {
                fourDataMap = (Map)fourData.get(0);
                fourDataMap.put("billId", data.get("billId"));
                fourDataMap.put("billSource", data.get("billSource"));
                fourDataMap.put("billNo", data.get("billNo"));
            }
        } else {
            LOGGER.info("PermFileSyncServiceHelper-fourData-error:{}", res.get("errorMsg"));
        }
        return fourDataMap;
    }

    public static int getErmanFilesCount(List<Long> labreltypeclsList, List<Long> labrelstatusclsList) {
        return (Integer)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"countErmanFilesByTypeclsAndStatuscls", (Object[])new Object[]{labreltypeclsList, labrelstatusclsList});
    }

    public static DynamicObject[] getErmanFiles(List<Long> labreltypeclsList, List<Long> labrelstatusclsList, long id, int top) {
        return (DynamicObject[])HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"listErmanFilesByTypeclsAndStatuscls", (Object[])new Object[]{labreltypeclsList, labrelstatusclsList, "person,org,name,filetype,businessstatus,empentrel.laborreltype,empentrel.laborrelstatus", id, top});
    }

    public static Map<String, Object> genPermFiles(DynamicObject[] ermanFiles) {
        Map<Long, Map<String, Object>> personRelSysUserIds = PermFileSyncServiceHelper.getPersonRelSysUserIdsMap(ermanFiles);
        if (CollectionUtils.isEmpty(personRelSysUserIds)) {
            return PermFileSyncServiceHelper.buildRspMap(0, 0, 0, 0, 0, ermanFiles.length);
        }
        List<Object> sysUserIds = PermFileSyncServiceHelper.getSysUserIds(personRelSysUserIds);
        Map<Long, Object> sysUserNameMap = PermFileSyncServiceHelper.getSysUserNameMap(sysUserIds);
        HRBaseServiceHelper permHelper = new HRBaseServiceHelper("hrcs_userpermfile");
        DynamicObjectCollection newPermFiles = new DynamicObjectCollection();
        DynamicObjectCollection updPermFiles = new DynamicObjectCollection();
        DynamicObject[] existsPermFiles = permHelper.query("id,user,org,permfileenable,description", new QFilter[]{new QFilter("user", "in", sysUserIds)});
        int chkIsNotPassCount = 0;
        int chkUserIdCount = 0;
        int chkEnableCount = 0;
        LOGGER.info("SyncPermFilesTask-genPermFiles-personRelSysUserIds:{}", personRelSysUserIds);
        block0: for (int i = 0; i < ermanFiles.length; ++i) {
            DynamicObject currErmanFile = ermanFiles[i];
            LOGGER.info("SyncPermFilesTask-currErmanFile name:{},businessstatus:{},org_id:{},person_id:{}", new Object[]{currErmanFile.getString("name"), currErmanFile.getString("businessstatus"), currErmanFile.getLong("org_id"), currErmanFile.getLong("person_id")});
            boolean isPass = PermFileSyncServiceHelper.chkData(currErmanFile, personRelSysUserIds);
            if (!isPass) {
                ++chkIsNotPassCount;
                continue;
            }
            Long orgId = currErmanFile.getLong("org_id");
            Long personId = currErmanFile.getLong("person_id");
            Map<String, Object> currSysUserIdMap = personRelSysUserIds.get(personId);
            Object currUser = currSysUserIdMap.get("user");
            Object currUserName = sysUserNameMap.get(currUser);
            if (existsPermFiles.length == 0) {
                PermFileSyncServiceHelper.buildNewPermFile(newPermFiles, permHelper, currUser, orgId, currUserName);
                continue;
            }
            for (int j = 0; j < existsPermFiles.length; ++j) {
                DynamicObject existsPermFile = existsPermFiles[j];
                if (null == existsPermFile.get("user.id") && ObjectUtils.nullSafeEquals((Object)existsPermFile.get("user_id"), (Object)currUser) && ObjectUtils.nullSafeEquals((Object)existsPermFile.get("org_id"), (Object)orgId)) {
                    ++chkUserIdCount;
                    continue block0;
                }
                if (PERFILE_STATUS_DISABLE.equals(existsPermFile.getString("permfileenable")) && ObjectUtils.nullSafeEquals((Object)existsPermFile.get("user_id"), (Object)currUser) && ObjectUtils.nullSafeEquals((Object)existsPermFile.get("org_id"), (Object)orgId)) {
                    existsPermFile.set("permfileenable", (Object)"1");
                    existsPermFile.set("description", (Object)ResManager.loadKDString((String)"\u7531\u4eba\u4e8b\u6863\u6848\u81ea\u52a8\u751f\u6548", (String)"PermFileSyncServiceHelper_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                    updPermFiles.add((Object)existsPermFile);
                    continue block0;
                }
                if (ObjectUtils.nullSafeEquals((Object)existsPermFile.get("user_id"), (Object)currUser) && ObjectUtils.nullSafeEquals((Object)existsPermFile.get("org_id"), (Object)orgId)) {
                    ++chkEnableCount;
                    continue block0;
                }
                if (j != existsPermFiles.length - 1) continue;
                PermFileSyncServiceHelper.buildNewPermFile(newPermFiles, permHelper, currUser, orgId, currUserName);
            }
        }
        permHelper.save(updPermFiles);
        permHelper.save(newPermFiles);
        return PermFileSyncServiceHelper.buildRspMap(updPermFiles.size(), newPermFiles.size(), chkIsNotPassCount, chkUserIdCount, chkEnableCount, 0);
    }

    private static boolean chkData(DynamicObject currErmanFile, Map<Long, Map<String, Object>> personRelSysUserIds) {
        if (!"1".equals(currErmanFile.getString("businessstatus"))) {
            return false;
        }
        Long orgId = currErmanFile.getLong("org_id");
        Long personId = currErmanFile.getLong("person_id");
        if (Objects.isNull(orgId) || Objects.isNull(personId)) {
            return false;
        }
        Map<String, Object> currSysUserIdMap = personRelSysUserIds.get(personId);
        return !Objects.isNull(currSysUserIdMap) && !Objects.isNull(currSysUserIdMap.get("user"));
    }

    private static Map<Long, Map<String, Object>> getPersonRelSysUserIdsMap(DynamicObject[] erManFiles) {
        ArrayList<Long> pIds = new ArrayList<Long>(erManFiles.length);
        for (int i = 0; i < erManFiles.length; ++i) {
            Long personId = erManFiles[i].getLong("person_id");
            if (Objects.isNull(personId)) continue;
            pIds.add(personId);
        }
        HashMap<String, ArrayList<Long>> personIdMaps = new HashMap<String, ArrayList<Long>>(1);
        personIdMaps.put("person", pIds);
        Map personRelSysUserIds = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{personIdMaps});
        if (!CollectionUtils.isEmpty((Map)personRelSysUserIds)) {
            return (Map)personRelSysUserIds.get("data");
        }
        return new HashMap<Long, Map<String, Object>>(1);
    }

    private static Map<Long, Object> getSysUserNameMap(List<Object> sysUserIds) {
        HRBaseServiceHelper bosUserHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject[] sysUserNames = bosUserHelper.query("name", new QFilter[]{new QFilter("id", "in", sysUserIds)});
        HashMap<Long, Object> sysUserNameMap = new HashMap<Long, Object>(CalculateUtil.getCeilPowerOfTwo(sysUserIds.size()));
        for (int i = 0; i < sysUserNames.length; ++i) {
            DynamicObject sysUserName = sysUserNames[i];
            sysUserNameMap.put((Long)sysUserName.getPkValue(), sysUserName.get("name"));
        }
        return sysUserNameMap;
    }

    private static List<Object> getSysUserIds(Map<Long, Map<String, Object>> personRelSysUserIds) {
        ArrayList<Object> sysUserIds = new ArrayList<Object>(personRelSysUserIds.size());
        if (!CollectionUtils.isEmpty(personRelSysUserIds)) {
            personRelSysUserIds.entrySet().forEach(entry -> sysUserIds.add(((Map)entry.getValue()).get("user")));
        }
        return sysUserIds;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void buildNewPermFile(DynamicObjectCollection newPermFiles, HRBaseServiceHelper permHelper, Object currUser, Long orgId, Object currUserName) {
        boolean flag = true;
        for (int i = 0; i < newPermFiles.size(); ++i) {
            if (!ObjectUtils.nullSafeEquals((Object)((DynamicObject)newPermFiles.get(i)).get("user"), (Object)currUser) || !ObjectUtils.nullSafeEquals((Object)((DynamicObject)newPermFiles.get(i)).get("org"), (Object)orgId)) continue;
            flag = false;
            break;
        }
        if (flag) {
            DynamicObject newPermFile = permHelper.generateEmptyDynamicObject();
            newPermFile.set("user", currUser);
            newPermFile.set("org", (Object)orgId);
            newPermFile.set("permfileenable", (Object)"1");
            newPermFile.set("username", currUserName);
            newPermFile.set("description", (Object)ResManager.loadKDString((String)"\u7531\u4eba\u4e8b\u6863\u6848\u81ea\u52a8\u521b\u5efa", (String)"PermFileSyncServiceHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            newPermFiles.add((Object)newPermFile);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void rspConsumerMsg(DynamicObject tplDy, boolean successFlag, String successMsg, String failMsg) {
        HashMap<String, Object> consumeMsgMap = new HashMap<String, Object>(8);
        consumeMsgMap.put("msgCenterId", tplDy.getLong("msgcenterbo"));
        consumeMsgMap.put("msgSubNo", tplDy.get("msgsubno"));
        consumeMsgMap.put("businessTypeId", tplDy.getLong("msgbusinesstype"));
        consumeMsgMap.put("handleStatus", successFlag ? "1" : "3");
        consumeMsgMap.put("consumeMsg", successFlag ? successMsg : failMsg);
        MsgCenterServiceHelper.updateConsumeMsgInfo(consumeMsgMap);
    }

    private static Map<String, Object> buildRspMap(int updCount, int newCount, int chkIsNotPassCount, int chkUserIdCount, int chkEnableCount, int chkRelSysUserCount) {
        HashMap<String, Object> rspMap = new HashMap<String, Object>(8);
        rspMap.put("updCount", updCount);
        rspMap.put("newCount", newCount);
        rspMap.put("chkIsNotPassCount", chkIsNotPassCount);
        rspMap.put("chkUserIdCount", chkUserIdCount);
        rspMap.put("chkEnableCount", chkEnableCount);
        rspMap.put("chkRelSysUserCount", chkRelSysUserCount);
        return rspMap;
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<Long> getAllLaborrelTypes() {
        ArrayList laborreltype = Lists.newArrayListWithExpectedSize((int)16);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborreltype", (String)"id", (QFilter[])new QFilter[]{enableFilter, statusFilter});
        if (!CollectionUtils.isEmpty((Map)entityCfMap)) {
            entityCfMap.values().forEach(labrel -> laborreltype.add(labrel.getLong("id")));
        }
        return laborreltype;
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<Long> getLaborrelTypesFromStatus(List<Long> labrelstatusclsList) {
        DynamicObject[] dynamicObjects;
        HashSet labrelType = Sets.newHashSetWithExpectedSize((int)16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_laborrelstatus");
        QFilter qFilter = new QFilter("labrelstatuscls", "in", labrelstatusclsList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        for (DynamicObject value : dynamicObjects = serviceHelper.query("number,name,laborreltype", new QFilter[]{qFilter, enableFilter, statusFilter})) {
            MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)value.get("laborreltype");
            List labrelTypeList = collection.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
            labrelType.addAll(labrelTypeList);
        }
        return Lists.newArrayList((Iterable)labrelType);
    }
}

