/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.perm.AssignSource;
import kd.hr.hbp.common.model.perm.UserRoleAssignParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.RoleMemberService;
import kd.hr.hrcs.bussiness.service.perm.common.RoleAssignParamBuilder;
import kd.hr.hrcs.bussiness.service.perm.common.RoleAssignService;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRRoleFunctionPermHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleDataPermHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.SaveRoleServiceHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.RoleBdDataRuleEntryModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import kd.hr.hrcs.common.constants.perm.RoleDataRuleEntryModel;
import kd.hr.hrcs.common.constants.perm.RoleDataRuleMainModel;
import kd.hr.hrcs.common.constants.perm.RoleMemberDetailModel;
import kd.hr.hrcs.common.constants.perm.RoleMemberModel;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class RoleMemberAssignSaveService {
    private static final Log LOGGER = LogFactory.getLog(RoleMemberAssignSaveService.class);
    private static final HRBaseServiceHelper RELATION_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
    private static final HRBaseServiceHelper USER_ROLE_HELPER = new HRBaseServiceHelper("hrcs_userrole");
    private static final HRBaseServiceHelper PERM_ROLE_HELPER = new HRBaseServiceHelper("perm_userrole");
    private static final HRBaseServiceHelper DIM_GRP_HELPER = new HRBaseServiceHelper("hrcs_userroledimgrp");
    private static final HRBaseServiceHelper DATA_RULE_HELPER = new HRBaseServiceHelper("hrcs_userdatarule");

    public static boolean deleteRoleMember(String roleId, Set<Long> permFileIds, Map<Long, String> relationAndCustom) {
        QFilter[] qFilters = new QFilter[]{new QFilter("permfile", "in", permFileIds), new QFilter("role", "=", (Object)roleId)};
        return RoleMemberAssignSaveService.doDelete(relationAndCustom, qFilters, Lists.newArrayList(permFileIds));
    }

    public static boolean deleteMemberRole(String[] roleIds, long permFileId, Map<Long, String> relationAndCustom) {
        QFilter[] qFilters = new QFilter[]{new QFilter("permfile", "=", (Object)permFileId), new QFilter("role", "in", (Object)roleIds)};
        return RoleMemberAssignSaveService.doDelete(relationAndCustom, qFilters, Lists.newArrayList((Object[])new Long[]{permFileId}));
    }

    private static boolean doDelete(Map<Long, String> relationAndCustom, QFilter[] qFilters, List<Long> permFileIds) {
        if (CollectionUtils.isEmpty(relationAndCustom)) {
            return false;
        }
        Set<Long> customRelationIds = relationAndCustom.entrySet().stream().filter(dy -> "1".equals(dy.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        LOGGER.info("deleteUserRoleData() customRelationIds:{}", customRelationIds);
        boolean result = RoleMemberAssignSaveService.doDeleteSame(relationAndCustom.keySet(), customRelationIds, qFilters);
        HRPermCacheMgr.clearAllCacheAndNotifyAsync(permFileIds);
        return result;
    }

    private static void doDeleteCustom(Set<Long> custom, QFilter[] qFilters) {
        DynamicObjectCollection userDataRuleCol = HRPermServiceHelper.queryMultiUserDataRule(custom);
        List<Long> userDataRuleIds = userDataRuleCol.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        HRPermServiceHelper.deleteUserDataRuleAndEntry(userDataRuleIds);
        DynamicObjectCollection userFieldPermCol = HRPermServiceHelper.queryMultiUserFieldPerm(custom);
        List<Long> userFieldPermIds = userFieldPermCol.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        HRPermServiceHelper.deleteUserFieldPerm(userFieldPermIds);
        HRBaseServiceHelper dimGrpHelper = new HRBaseServiceHelper("hrcs_userroledimgrp");
        dimGrpHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerelat", "in", custom)});
    }

    private static boolean doDeleteSame(Set<Long> relationIds, Set<Long> customRelationIds, QFilter[] qFilters) {
        Object[] unDelete;
        QFilter[] permRoleFilter;
        int cnt;
        boolean result = true;
        DynamicObject[] userRoles = RoleMemberAssignServiceHelper.getPermRoleByUserRole(relationIds);
        HashSet permRoleIds = Sets.newHashSetWithExpectedSize((int)userRoles.length);
        HashSet userRoleIds = Sets.newHashSetWithExpectedSize((int)userRoles.length);
        Arrays.stream(userRoles).forEach(userRole -> {
            permRoleIds.add(userRole.getString("userrolepf.id"));
            userRoleIds.add(userRole.getLong("id"));
        });
        if (!CollectionUtils.isEmpty((Collection)permRoleIds) && (cnt = PERM_ROLE_HELPER.deleteByFilter(permRoleFilter = new QFilter[]{new QFilter("id", "in", (Object)permRoleIds)})) < 1 && !ObjectUtils.isEmpty((Object[])(unDelete = PERM_ROLE_HELPER.queryOriginalArray("id", permRoleFilter)))) {
            LOGGER.error("doDeleteSame() delete permRole fail. ");
            return false;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (!CollectionUtils.isEmpty((Collection)userRoleIds)) {
                    USER_ROLE_HELPER.delete((Object[])userRoleIds.toArray(new Long[0]));
                }
                RELATION_HELPER.delete((Object[])relationIds.toArray(new Long[0]));
                if (!CollectionUtils.isEmpty(customRelationIds)) {
                    RoleMemberAssignSaveService.doDeleteCustom(customRelationIds, qFilters);
                }
            }
            catch (Exception ex) {
                LOGGER.error("doDeleteSame userRole or relation fail.{}", (Object)ex.getMessage());
                tx.markRollback();
                result = false;
            }
        }
        return result;
    }

    public static void saveRoleMember(Long[] permFileIds, String roleId, Date startDate, Date endDate, String operationType, Long relationIdBefore, String pageSource) {
        RoleMemberModel model = new RoleMemberModel();
        model.setRoleId(roleId);
        ArrayList details = Lists.newArrayListWithExpectedSize((int)permFileIds.length);
        Arrays.stream(permFileIds).forEach(permFileId -> {
            RoleMemberDetailModel detail = new RoleMemberDetailModel(permFileId.longValue(), startDate, endDate, "0", 0L);
            details.add(detail);
        });
        model.setDetails((List)details);
        RoleMemberAssignSaveService.saveRoleMember(Collections.singletonList(model), operationType, relationIdBefore, pageSource);
    }

    public static void saveRoleMember(List<RoleMemberModel> roleMembers, String operationType, Long relationIdBefore, String pageSource) {
        if (CollectionUtils.isEmpty(roleMembers)) {
            return;
        }
        ArrayList userRoleAssignParams = Lists.newArrayListWithExpectedSize((int)16);
        for (RoleMemberModel roleMember : roleMembers) {
            for (RoleMemberDetailModel memberDetail : roleMember.getDetails()) {
                UserRoleAssignParam param2 = new UserRoleAssignParam(Long.valueOf(memberDetail.getPermFileId()), roleMember.getRoleId(), memberDetail.getValidStart(), memberDetail.getValidEnd(), Long.valueOf(RequestContext.get().getCurrUserId()));
                AssignSource assignSource = param2.getAssignSource();
                assignSource.setSourceType("1");
                assignSource.setPageSource(pageSource);
                if (HRStringUtils.equals((String)operationType, (String)"userRoleCopy")) {
                    assignSource.setSourceType("2");
                } else {
                    assignSource.setSourceType("1");
                }
                try {
                    if (HRStringUtils.equals((String)"userRoleAdd", (String)operationType) || HRStringUtils.equals((String)"userRoleCopy", (String)operationType) || HRStringUtils.equals((String)"userRoleInit", (String)operationType)) {
                        assignSource.setObType(operationType);
                    } else {
                        assignSource.setObType("userRoleModify");
                        if (relationIdBefore != 0L) {
                            HRBaseServiceHelper USER_ROLE_RE_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
                            DynamicObject relateDyBefore = USER_ROLE_RE_HELPER.queryOne((Object)relationIdBefore);
                            String customenable = relateDyBefore.getString("customenable");
                            if (HRStringUtils.equals((String)"1", (String)customenable)) {
                                UserRoleAssignParam userRoleAssignParam = RoleAssignParamBuilder.buildBeforeUserRoleAssignParams(roleMember.getRoleId(), relationIdBefore);
                                param2.setUserRoleAssignParamBefore(userRoleAssignParam);
                            } else {
                                long permFileId = relateDyBefore.getLong("permfile.id");
                                Date validStart = relateDyBefore.getDate("validstart");
                                Date validEnd = relateDyBefore.getDate("validend");
                                UserRoleAssignParam beforeParam = new UserRoleAssignParam(Long.valueOf(permFileId), roleMember.getRoleId(), validStart, validEnd, Long.valueOf(RequestContext.get().getCurrUserId()));
                                AssignSource beforeAssignSource = beforeParam.getAssignSource();
                                beforeAssignSource.setRelateId(relationIdBefore);
                                beforeAssignSource.setSourceType(relateDyBefore.getString("sourcetype"));
                                beforeAssignSource.setInitRecordId(Long.valueOf(relateDyBefore.getLong("initrecord.id")));
                                beforeAssignSource.setSchemeId(Long.valueOf(relateDyBefore.getLong("scheme.id")));
                                param2.setUserRoleAssignParamBefore(beforeParam);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("saveRoleMember permlog error", (Throwable)ex);
                }
                userRoleAssignParams.add(param2);
            }
        }
        RoleAssignService.roleAssignUserBatch(userRoleAssignParams);
        HRPermCacheMgr.clearAllCacheAndNotifyAsync(userRoleAssignParams.stream().map(param -> param.getPermFileId()).collect(Collectors.toList()));
    }

    @ExcludeFromJacocoGeneratedReport
    public static void saveUserRole(String[] roleIds, Long permFileId, Date startDate, Date endDate, String operationType, Long relationIdBefore, String pageSource) {
        if (ObjectUtils.isEmpty((Object[])roleIds)) {
            LOGGER.error("saveUserRole() roleIds is empty.");
            return;
        }
        ArrayList models = Lists.newArrayListWithExpectedSize((int)roleIds.length);
        Arrays.stream(roleIds).forEach(roleId -> {
            RoleMemberModel model = new RoleMemberModel();
            model.setRoleId(roleId);
            model.setDetails(Collections.singletonList(new RoleMemberDetailModel(permFileId.longValue(), startDate, endDate, "0", 0L)));
            models.add(model);
        });
        RoleMemberAssignSaveService.saveRoleMember(models, operationType, relationIdBefore, pageSource);
    }

    public static void saveUserPermRole(List<String> roleIds, List<Long> permFileIds, Date startDate, Date endDate, String operationType, String pageSource) {
        if (ObjectUtils.isEmpty(roleIds)) {
            return;
        }
        ArrayList models = Lists.newArrayListWithExpectedSize((int)roleIds.size());
        for (String roleId : roleIds) {
            RoleMemberModel model = new RoleMemberModel();
            model.setRoleId(roleId);
            ArrayList detailModels = Lists.newArrayListWithExpectedSize((int)permFileIds.size());
            for (Long permFileId : permFileIds) {
                detailModels.add(new RoleMemberDetailModel(permFileId.longValue(), startDate, endDate, "0", 0L));
            }
            model.setDetails((List)detailModels);
            models.add(model);
        }
        RoleMemberAssignSaveService.saveRoleMember(models, operationType, 0L, pageSource);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void saveUserPermRoleCustom(List<Pair<String, Long>> roleRelationIdPairs, List<Long> permFileIds, Date startDate, Date endDate, String operationType, String pageSource) {
        for (Long permFileId : permFileIds) {
            for (Pair<String, Long> roleRelationIdPair : roleRelationIdPairs) {
                String roleId = (String)roleRelationIdPair.getLeft();
                Long relationId = (Long)roleRelationIdPair.getRight();
                Map<String, UserRoleFieldPermInfo> userFieldPermInfo = RoleMemberService.getUserFieldPermInfoFromDatabase(null, null, relationId);
                List<RoleDataPermModel> roleMemberInfoCustom = RoleMemberAssignSaveService.getRoleMemberInfoCustom(relationId);
                if (CollectionUtils.isEmpty(roleMemberInfoCustom)) continue;
                List<UserRoleAssignParam> params = RoleAssignParamBuilder.buildUserRoleAssignParams(roleId, permFileId, startDate, endDate, roleMemberInfoCustom, userFieldPermInfo, operationType, 0L, pageSource);
                RoleAssignService.roleAssignUserBatch(params);
            }
        }
        HRPermCacheMgr.clearAllCacheAndNotifyAsync(permFileIds);
    }

    public static void saveRoleMemCustom(IFormView view, String roleId, long permFileId, Date validStart, Date validEnd, List<RoleDataPermModel> models, String operationType, Long beforeRelateId, String pageSource) {
        if (CollectionUtils.isEmpty(models)) {
            return;
        }
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        Map<String, UserRoleFieldPermInfo> fieldPermInfo = pageCacheUtil.getFieldPermData();
        List<UserRoleAssignParam> params = RoleAssignParamBuilder.buildUserRoleAssignParams(roleId, permFileId, validStart, validEnd, models, fieldPermInfo, operationType, beforeRelateId, pageSource);
        RoleAssignService.roleAssignUserBatch(params);
        HRPermCacheMgr.clearAllCacheAndNotifyAsync(permFileId);
    }

    public static void setSysField(DynamicObject object, Date date) {
        object.set("createtime", (Object)date);
        object.set("creator", (Object)RequestContext.get().getCurrUserId());
        object.set("modifytime", (Object)date);
        object.set("modifier", (Object)RequestContext.get().getCurrUserId());
    }

    public static Map<String, RoleDataPermModel> assembleRoleDataPermModelList(String roleId, boolean newflag) {
        HashMap roleDataPermModelMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, List<DynamicObject>> roleBuById = RoleMemberAssignServiceHelper.getRoleBuGroupByBu(roleId);
        Set<Long> buIdSet = roleBuById.keySet();
        DynamicObject[] roleImgGrpDys = RoleMemberAssignServiceHelper.geRoledimgrp(roleId, buIdSet);
        Map<Long, List<DynamicObject>> roleImgGrpDysGroupByBu = Arrays.stream(roleImgGrpDys).collect(Collectors.groupingBy(roleImgGrpDy -> roleImgGrpDy.getLong("bucafunc.id")));
        Map<Long, List<String>> appByHrbucafunc = RoleMemberAssignServiceHelper.getAppByHrbucafunc(buIdSet);
        HashMap roleDataRuleByHrbu = Maps.newHashMapWithExpectedSize((int)16);
        appByHrbucafunc.forEach((appByBuKey, appByBuValue) -> {
            DynamicObject[] roleDataRuleDynamic = RoleMemberAssignServiceHelper.geDataRuleByApp(appByBuValue, roleId);
            roleDataRuleByHrbu.put(appByBuKey, roleDataRuleDynamic);
        });
        roleBuById.forEach((buKey, value) -> {
            HashMap appEntity2DataRules = Maps.newHashMapWithExpectedSize((int)16);
            HashMap dimGroupMap = Maps.newHashMapWithExpectedSize((int)16);
            RoleDataPermModel roleDataPermModel = new RoleDataPermModel();
            RoleMemberAssignSaveService.setOrgList(buKey, value, roleDataPermModel, newflag);
            List roleImgGrpList = (List)roleImgGrpDysGroupByBu.get(buKey);
            if (newflag && null != roleImgGrpList && roleImgGrpList.size() > 1) {
                DynamicObject roleImgGrp = (DynamicObject)roleImgGrpList.get(0);
                roleImgGrpList.clear();
                roleImgGrpList.add(roleImgGrp);
            }
            Optional.ofNullable(roleImgGrpList).ifPresent(roleImgGrps -> roleImgGrps.forEach(roleImgGrp -> {
                DimGrpModel dimGrpModel = new DimGrpModel();
                RoleMemberAssignSaveService.setDimGroupModel(dimGroupMap, roleImgGrp, dimGrpModel, newflag);
            }));
            roleDataPermModel.setDimGroupMap((Map)dimGroupMap);
            RoleMemberAssignSaveService.setRoleDataRuleModel(appEntity2DataRules, roleDataRuleByHrbu.getOrDefault(buKey, new DynamicObject[0]), newflag);
            roleDataPermModel.setAppEntity2DataRules((Map)appEntity2DataRules);
            roleDataPermModelMap.put(buKey.toString(), roleDataPermModel);
        });
        return roleDataPermModelMap;
    }

    private static void setRoleDataRuleModel(Map<String, RoleDataRuleMainModel> appEntity2DataRules, DynamicObject[] roleDataRuleDynamic, boolean newflag) {
        Arrays.stream(roleDataRuleDynamic).forEach(roleDataRuleObj -> {
            String entitytype = roleDataRuleObj.getString("entitytype");
            RoleDataRuleMainModel roleDataRuleMainModel = new RoleDataRuleMainModel();
            DynamicObjectCollection roleDataruleEntry = roleDataRuleObj.getDynamicObjectCollection("roledataruleentry");
            DynamicObjectCollection roleBdRuleEntry = roleDataRuleObj.getDynamicObjectCollection("hrcs_rolebdruleentry");
            HashMap dataRuleMap = Maps.newHashMapWithExpectedSize((int)roleDataruleEntry.size());
            HashMap bdDataRuleMap = Maps.newHashMapWithExpectedSize((int)roleBdRuleEntry.size());
            Map<Long, List<DynamicObject>> dataRule = roleDataruleEntry.stream().collect(Collectors.groupingBy(roleDataGroup -> roleDataGroup.getLong("datarule.id")));
            dataRule.forEach((dataRuleKey, dataRuleValue) -> {
                RoleDataRuleEntryModel roleDataRuleEntryModel = new RoleDataRuleEntryModel();
                roleDataRuleEntryModel.setBusinessObject(entitytype);
                roleDataRuleEntryModel.setDataRuleId(String.valueOf(dataRuleKey));
                roleDataRuleEntryModel.setPermItem(dataRuleValue.stream().map(roleDataRuleEntryDynamic -> roleDataRuleEntryDynamic.getString("permitem.id")).collect(Collectors.toList()));
                dataRuleMap.put(String.valueOf(dataRuleKey), roleDataRuleEntryModel);
            });
            roleBdRuleEntry.forEach(roleBdRuleEntryDyn -> {
                RoleBdDataRuleEntryModel roleBdDataRuleEntryModel = new RoleBdDataRuleEntryModel();
                String proKey = roleBdRuleEntryDyn.getString("propkey");
                roleBdDataRuleEntryModel.setBusinessObject(entitytype);
                roleBdDataRuleEntryModel.setDataRuleId(roleBdRuleEntryDyn.getString("bddatarule.id"));
                roleBdDataRuleEntryModel.setProperty(roleBdRuleEntryDyn.getString("propkey"));
                roleBdDataRuleEntryModel.setPropertyNum(roleBdRuleEntryDyn.getString("propentnum"));
                bdDataRuleMap.put(proKey, roleBdDataRuleEntryModel);
            });
            if (newflag) {
                roleDataRuleMainModel.setDataRuleMap(new HashMap());
                roleDataRuleMainModel.setBdDataRuleMap(new HashMap());
            } else {
                roleDataRuleMainModel.setDataRuleMap((Map)dataRuleMap);
                roleDataRuleMainModel.setBdDataRuleMap((Map)bdDataRuleMap);
            }
            String concat = roleDataRuleObj.getString("app").concat("#").concat(entitytype);
            appEntity2DataRules.put(concat, roleDataRuleMainModel);
        });
    }

    private static void setDimGroupModel(Map<String, DimGrpModel> dimGroupMap, DynamicObject roleImgGrp, DimGrpModel dimGrpModel, boolean newflag) {
        TreeMap dimMap = Maps.newTreeMap();
        dimGrpModel.setDimGroup(String.valueOf(roleImgGrp.get("id")));
        dimGrpModel.setSeq(roleImgGrp.getInt("index"));
        DynamicObjectCollection entry = roleImgGrp.getDynamicObjectCollection("entry");
        Map<Long, List<DynamicObject>> collect = entry.stream().collect(Collectors.groupingBy(en -> en.getLong("dimension.id")));
        collect.forEach((dimId, dimensionValue) -> {
            String dimNumber = ((DynamicObject)dimensionValue.get(0)).getString("dimension.number");
            DimModel dimModel = new DimModel();
            dimModel.setDimId(dimId.toString());
            dimModel.setDimNumber(dimNumber);
            HashMap dimValues = Maps.newHashMapWithExpectedSize((int)dimensionValue.size());
            dimensionValue.forEach(dimModelVal -> {
                HashMap dimValMap = Maps.newHashMapWithExpectedSize((int)16);
                dimModel.setDimNumber(dimModelVal.getString("dimension.number"));
                if (newflag) {
                    return;
                }
                DynamicObject structProject = dimModelVal.getDynamicObject("structproject");
                String dimVal = dimModelVal.getString("dimval");
                RoleDataPermHelper.getDimensionValName(dimModelVal, dimValMap, dimVal);
                dimValMap.put("includeSub", dimModelVal.get("containssub"));
                dimValMap.put("includeSubAdminOrg", dimModelVal.get("admincontainssub"));
                dimValMap.put("dimval", dimVal);
                dimValMap.put("id", dimVal);
                dimValMap.put("valueType", dimModelVal.getString("valtype"));
                dimValMap.put("dynamicCondition", dimModelVal.getString("dynacond.id"));
                dimModel.setLimit(dimModelVal.getBoolean("isall") ? "1" : "0");
                if (null != structProject) {
                    dimValMap.put("structProject", structProject);
                    dimValues.put(dimVal + "#" + structProject.getPkValue(), dimValMap);
                } else {
                    dimValues.put(dimVal, dimValMap);
                }
            });
            dimModel.setDimValues((Map)dimValues);
            dimMap.put(dimNumber, dimModel);
        });
        dimGrpModel.setDimMap(dimMap);
        dimGroupMap.put(roleImgGrp.getString("id"), dimGrpModel);
    }

    private static void setOrgList(Long buKey, List<DynamicObject> value, RoleDataPermModel roleDataPermModel, boolean newflag) {
        HashMap orgMap = Maps.newHashMapWithExpectedSize((int)16);
        roleDataPermModel.setHrBuCaFunc(buKey.longValue());
        value.forEach(dynamicObject -> {
            if (HRStringUtils.isEmpty((String)dynamicObject.getString("org.id"))) {
                return;
            }
            HashMap orgInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            orgInfoMap.put("id", dynamicObject.getString("org.id"));
            orgInfoMap.put("name", dynamicObject.getString("org.name"));
            orgInfoMap.put("includeSub", dynamicObject.getBoolean("containssub"));
            orgMap.put(dynamicObject.getString("org.id"), orgInfoMap);
        });
        if (newflag) {
            roleDataPermModel.setOrgMap(new HashMap());
        } else {
            roleDataPermModel.setOrgMap((Map)orgMap);
        }
    }

    public static List<RoleDataPermModel> getRoleMemberInfoCustom(Long relationId) {
        ArrayList roleDataPermModels = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject[] userRoleByRelation = RoleMemberAssignServiceHelper.getUserRoleByRelation(relationId);
        Set<Long> bucafuncIds = Arrays.stream(userRoleByRelation).map(dy -> Long.valueOf(dy.getString("bucafunc"))).collect(Collectors.toSet());
        DynamicObject[] userDimGrps = RoleMemberAssignServiceHelper.getUserDimGrps(relationId, bucafuncIds);
        DynamicObject[] userDataRule = RoleMemberAssignServiceHelper.getUserDataRule(relationId);
        return RoleMemberAssignSaveService.assemblePermModel(bucafuncIds, userRoleByRelation, userDimGrps, userDataRule, roleDataPermModels);
    }

    private static List<RoleDataPermModel> assemblePermModel(Set<Long> bucafuncIds, DynamicObject[] userRoleByRelation, DynamicObject[] userDimGrps, DynamicObject[] userDataRule, List<RoleDataPermModel> roleDataPermModels) {
        Map<String, List<DynamicObject>> orgByBucafunc = Arrays.stream(userRoleByRelation).collect(Collectors.groupingBy(dy -> dy.getString("bucafunc")));
        Map<String, List<DynamicObject>> dimGroupByBucafunc = Arrays.stream(userDimGrps).collect(Collectors.groupingBy(dy -> dy.getString("bucafunc.id")));
        Map<Long, Set<String>> appsByHrbucafunc = RoleMemberAssignServiceHelper.getAppsByHrbucafunc(bucafuncIds);
        Map<String, Long> entitySpecFuncMap = HRRoleFunctionPermHelper.getAllEntitySpecFunc();
        orgByBucafunc.forEach((bucafunc, orgs) -> {
            RoleDataPermModel permModel = new RoleDataPermModel();
            permModel.setHrBuCaFunc(Long.parseLong(bucafunc));
            permModel.setDimGroupMap(RoleMemberAssignSaveService.genDimGrpModel((List)dimGroupByBucafunc.get(bucafunc)));
            permModel.setOrgMap(RoleMemberAssignSaveService.genOrgMaps((List)orgByBucafunc.get(bucafunc)));
            Set appIds = (Set)appsByHrbucafunc.get(Long.parseLong(bucafunc));
            if (CollectionUtils.isEmpty((Collection)appIds)) {
                LOGGER.error("assemblePermModel() bucafunc:{} mapping appId is null", bucafunc);
            } else if (!ObjectUtils.isEmpty((Object[])userDataRule)) {
                LOGGER.info("assemblePermModel() bucafunc:{} mapping appId:{}", bucafunc, (Object)appIds);
                List<DynamicObject> userDataRulesByAppId = Arrays.stream(userDataRule).filter(dy -> appIds.contains(dy.getString("app.id")) || entitySpecFuncMap.containsKey(dy.getString("entitytype.number")) && HRStringUtils.equals((String)((Long)entitySpecFuncMap.get(dy.getString("entitytype.number"))).toString(), (String)bucafunc)).collect(Collectors.toList());
                permModel.setAppEntity2DataRules(RoleMemberAssignSaveService.genDataRuleModel(userDataRulesByAppId));
            }
            roleDataPermModels.add(permModel);
        });
        return roleDataPermModels;
    }

    private static Map<String, Map<String, Object>> genOrgMaps(List<DynamicObject> orgInfos) {
        HashMap orgMaps = Maps.newHashMapWithExpectedSize((int)orgInfos.size());
        orgInfos.forEach(orgInfo -> {
            HashMap orgMap = Maps.newHashMapWithExpectedSize((int)orgInfos.size());
            orgMap.put("id", orgInfo.getLong("org.id"));
            orgMap.put("name", orgInfo.getString("org.name"));
            orgMap.put("includeSub", orgInfo.getBoolean("includesuborg"));
            orgMaps.put(orgInfo.getString("org.id"), orgMap);
        });
        return orgMaps;
    }

    private static Map<String, DimGrpModel> genDimGrpModel(List<DynamicObject> dimGroups) {
        HashMap dimGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(dimGroups)) {
            return dimGroupMap;
        }
        Set dimIdSet = dimGroups.stream().flatMap(it -> it.getDynamicObjectCollection("entry").stream()).map(it -> it.getLong("dimension.id")).collect(Collectors.toSet());
        HRBaseServiceHelper dimServiceHelper = new HRBaseServiceHelper("hrcs_dimension");
        Map<String, String> showTypeMap = Arrays.stream(dimServiceHelper.query("id,showtype", new QFilter[]{new QFilter("id", "in", dimIdSet)})).collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("showtype"), (oldValue, newValue) -> oldValue));
        dimGroups.forEach(dimGrp -> {
            DimGrpModel dimGrpModel = new DimGrpModel();
            dimGrpModel.setSeq(dimGrp.getInt("index"));
            dimGrpModel.setDimGroup(dimGrp.getString("id"));
            DynamicObjectCollection dimEntry = dimGrp.getDynamicObjectCollection("entry");
            Map<String, List<DynamicObject>> dimValuesById = dimEntry.stream().collect(Collectors.groupingBy(dy -> dy.getString("dimension.id")));
            TreeMap dimModelMap = Maps.newTreeMap();
            dimValuesById.forEach((dimId, dimValues) -> {
                DimModel dimModel = new DimModel();
                dimModel.setDimId(dimId);
                dimModel.setDimNumber(((DynamicObject)dimValues.get(0)).getString("dimension.number"));
                dimModel.setLimit(((DynamicObject)dimValues.get(0)).getBoolean("isall") ? "1" : "0");
                String showType = (String)showTypeMap.get(dimId);
                HashMap dimValuesMap = Maps.newHashMapWithExpectedSize((int)dimValues.size());
                dimValues.forEach(dimValue -> {
                    HashMap valueMap = Maps.newHashMapWithExpectedSize((int)4);
                    String dimVal = dimValue.getString("dimval");
                    DynamicObject structProject = dimValue.getDynamicObject("structproject");
                    DynamicObject originalStructProject = null;
                    if (HRStringUtils.equals((String)"teamblock", (String)showType)) {
                        originalStructProject = RoleDataPermHelper.getStructProject(dimValue);
                    }
                    valueMap.put("id", dimVal);
                    RoleDataPermHelper.getDimensionValName(dimValue, valueMap, dimVal);
                    valueMap.put("includeSub", dimValue.getBoolean("containssub"));
                    valueMap.put("includeSubAdminOrg", dimValue.getBoolean("admincontainssub"));
                    valueMap.put("valueType", dimValue.getString("valtype"));
                    valueMap.put("dynamicCondition", dimValue.getString("dynacond.id"));
                    if (null != structProject && null != originalStructProject) {
                        valueMap.put("structProject", structProject);
                        valueMap.put("currentstructproject", originalStructProject);
                        dimValuesMap.put(dimVal + "#" + structProject.getPkValue(), valueMap);
                    } else {
                        dimValuesMap.put(dimVal, valueMap);
                    }
                });
                dimModel.setDimValues((Map)dimValuesMap);
                dimModelMap.put(((DynamicObject)dimValues.get(0)).getString("dimension.number"), dimModel);
            });
            dimGrpModel.setDimMap(dimModelMap);
            dimGroupMap.put(dimGrp.getString("id"), dimGrpModel);
        });
        return dimGroupMap;
    }

    private static Map<String, RoleDataRuleMainModel> genDataRuleModel(List<DynamicObject> mainDataRules) {
        HashMap appEntity2DataRules = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(mainDataRules)) {
            return appEntity2DataRules;
        }
        for (DynamicObject mainDataRule : mainDataRules) {
            RoleDataRuleMainModel mainModel = new RoleDataRuleMainModel();
            String entityTypeId = mainDataRule.getString("entitytype.id");
            if (HRStringUtils.isEmpty((String)entityTypeId)) {
                LOGGER.error("genDataRuleModel() mainDataRule:{} entityTypeId is null.", (Object)mainDataRule.getString("id"));
                continue;
            }
            DynamicObjectCollection dataRuleEntry = mainDataRule.getDynamicObjectCollection("dataruleentry");
            Map dataRuleById = dataRuleEntry.stream().collect(Collectors.groupingBy(dy -> dy.getString("datarule.id"), Collectors.mapping(dy -> dy.getString("permitem.id"), Collectors.toList())));
            HashMap entryModels = Maps.newHashMapWithExpectedSize((int)dataRuleById.size());
            dataRuleById.forEach((ruleId, permItems) -> {
                RoleDataRuleEntryModel entryModel = new RoleDataRuleEntryModel();
                entryModel.setBusinessObject(entityTypeId);
                entryModel.setDataRuleId(ruleId);
                entryModel.setPermItem(permItems);
                entryModels.put(ruleId, entryModel);
            });
            mainModel.setDataRuleMap((Map)entryModels);
            DynamicObjectCollection bdDataRuleEntry = mainDataRule.getDynamicObjectCollection("bddataruleentry");
            HashMap bdEntryModels = Maps.newHashMapWithExpectedSize((int)dataRuleById.size());
            bdDataRuleEntry.forEach(rule -> {
                RoleBdDataRuleEntryModel entryModel = new RoleBdDataRuleEntryModel();
                entryModel.setBusinessObject(entityTypeId);
                entryModel.setDataRuleId(rule.getString("bddatarule.id"));
                entryModel.setProperty(rule.getString("propkey"));
                entryModel.setPropertyNum(rule.getString("propentnum"));
                bdEntryModels.put(rule.getString("propkey"), entryModel);
            });
            mainModel.setBdDataRuleMap((Map)bdEntryModels);
            appEntity2DataRules.put(mainDataRule.getString("app.id") + "#" + entityTypeId, mainModel);
        }
        return appEntity2DataRules;
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean checkSaveRoleMember(IFormView formView, StringBuilder processInfo, List<RoleDataPermModel> modelList) {
        boolean result = false;
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView, false);
        Map<String, Map<String, Object>> allHrBuCaMap = permPageCacheUtil.getAllHrBuCaMap();
        Map<String, Map<String, Map<String, Object>>> assignedHrBuCaDim = permPageCacheUtil.getAssignedHrBuCaDim();
        Set<String> dimResultSet = permPageCacheUtil.getDimResultSet();
        HashSet buCaFuncTipsSet = Sets.newHashSetWithExpectedSize((int)16);
        LOGGER.info("Got allHrBuCaMap: {}, assignedHrBuCaDim: {}, assignedDim: {}, assignedDimInfo: {}, dimResultSet: {}, dataPermMap: {}.", new Object[]{allHrBuCaMap, assignedHrBuCaDim, permPageCacheUtil.getAssignedDim(), permPageCacheUtil.getAssignedDimInfo(), dimResultSet, permPageCacheUtil.getDataPermMap()});
        block0: for (RoleDataPermModel roleDataPermModel : modelList) {
            Collection values;
            Map orgMap = roleDataPermModel.getOrgMap();
            Map dimGroupMap = roleDataPermModel.getDimGroupMap();
            Map<String, Map<String, Object>> assignDimMap = assignedHrBuCaDim.get(String.valueOf(roleDataPermModel.getHrBuCaFunc()));
            LOGGER.info("CheckSaveRoleMember item. assignDimMap: {}, dimResultSet: {}.", assignDimMap, dimResultSet);
            if (CollectionUtils.isEmpty((Map)orgMap)) {
                buCaFuncTipsSet.add((String)allHrBuCaMap.get(String.valueOf(roleDataPermModel.getHrBuCaFunc())).get("name"));
            }
            if (null == assignDimMap || assignDimMap.isEmpty()) {
                LOGGER.info("Ignore hrbu[{}] for mismatch between db and page.", (Object)roleDataPermModel.getHrBuCaFunc());
                continue;
            }
            if (CollectionUtils.isEmpty((Map)dimGroupMap) || CollectionUtils.isEmpty(values = dimGroupMap.values())) continue;
            for (DimGrpModel dimGrpModel : values) {
                TreeMap dimMap = dimGrpModel.getDimMap();
                Collection dimValues = dimMap.values();
                for (DimModel dimModel : dimValues) {
                    String dimId = dimModel.getDimId();
                    if (HRStringUtils.isNotEmpty((String)dimId) && (null != assignDimMap && !assignDimMap.containsKey(dimId) || null != dimResultSet && !dimResultSet.contains(dimId))) {
                        LOGGER.info("Ignore dimension[{}] for mismatch between db and page.", (Object)dimId);
                        continue;
                    }
                    if ("1".equals(dimModel.getLimit())) continue;
                    Map dimValue = dimModel.getDimValues();
                    if (CollectionUtils.isEmpty((Map)dimValue)) {
                        buCaFuncTipsSet.add((String)allHrBuCaMap.get(String.valueOf(roleDataPermModel.getHrBuCaFunc())).get("name"));
                        continue block0;
                    }
                    for (Map.Entry dimvalueEntry : dimValue.entrySet()) {
                        String key = (String)dimvalueEntry.getKey();
                        if (!HRStringUtils.isEmpty((String)key)) continue;
                        buCaFuncTipsSet.add((String)allHrBuCaMap.get(String.valueOf(roleDataPermModel.getHrBuCaFunc())).get("name"));
                        continue block0;
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)buCaFuncTipsSet)) {
            String message = Joiner.on((String)"\uff0c").skipNulls().join((Iterable)buCaFuncTipsSet);
            processInfo.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u8303\u56f4\u6216\u4e1a\u52a1\u6570\u636e\u8303\u56f4\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\uff1a", (String)"RoleMemberAssignSaveService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(message);
            result = true;
        } else {
            result = SaveRoleServiceHelper.checkDataRule(formView);
        }
        return result;
    }
}

