/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.extpoint.permission.role.IRoleMemCusListPlugin;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class RoleMemberAssignServiceHelper
implements IRoleMemCusListPlugin {
    private static final Log LOG = LogFactory.getLog(RoleMemberAssignServiceHelper.class);

    public static int getUserCountByRole(String roleId, List<QFilter> qFilters) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(2);
        HRBaseServiceHelper relateHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        list.add(new QFilter("role.id", "=", (Object)roleId));
        if (null != qFilters && !qFilters.isEmpty()) {
            list.addAll(qFilters);
        }
        HRPluginProxy proxy = new HRPluginProxy((Object)new RoleMemberAssignServiceHelper(), IRoleMemCusListPlugin.class, "kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper#getUserInfoByRole", null);
        List filterList = proxy.callAfter(IRoleMemCusListPlugin::filterRoleMemList);
        filterList.stream().filter(CollectionUtils::isNotEmpty).forEach(list::addAll);
        long level = HRPermServiceHelper.getUserGroupMinLevel();
        if (-1L == level || level > 2L) {
            List<Long> userPermOrgIds = HRPermServiceHelper.getUserPermFile();
            list.add(new QFilter("permfile.org.id", "in", userPermOrgIds));
        }
        return relateHelper.count("hrcs_userrolerelat", list.toArray(new QFilter[0]));
    }

    public static DynamicObject[] getUserInfoByRole(String roleId, List<QFilter> qFilters, String orderBy, int pageIndex, int pageSize) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(2);
        HRBaseServiceHelper relateHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        list.add(new QFilter("role.id", "=", (Object)roleId));
        if (null != qFilters && !qFilters.isEmpty()) {
            list.addAll(qFilters);
        }
        HRPluginProxy proxy = new HRPluginProxy((Object)new RoleMemberAssignServiceHelper(), IRoleMemCusListPlugin.class, "kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper#getUserInfoByRole", null);
        List filterList = proxy.callAfter(IRoleMemCusListPlugin::filterRoleMemList);
        filterList.stream().filter(CollectionUtils::isNotEmpty).forEach(list::addAll);
        long level = HRPermServiceHelper.getUserGroupMinLevel();
        if (-1L == level || level > 2L) {
            List<Long> userPermOrgIds = HRPermServiceHelper.getUserPermFile();
            list.add(new QFilter("permfile.org.id", "in", userPermOrgIds));
        }
        LOG.info("start query relate dataset.");
        return BusinessDataServiceHelper.load((String)"hrcs_userrolerelat", (String)"id,permfile.id,permfile.org.id,permfile.org.name,user.id,user.number,user.name,user.picturefield,user.headsculpture,user.isforbidden,role.id,customenable,validstart,validend,createtime,creator.id,creator.name,sourcetype,scheme,initrecord", (QFilter[])list.toArray(new QFilter[0]), (String)orderBy, (int)pageIndex, (int)pageSize);
    }

    public static DynamicObject getRelationInfoById(Long relationId) {
        HRBaseServiceHelper relateHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        return relateHelper.queryOne("id,permfile,user,role.id,customenable,validstart,validend", (Object)relationId);
    }

    public static boolean enablePermValidateTime() {
        return PermCommonUtil.isEnableValidateTime();
    }

    public static Map<Long, DynamicObject> getPermFilesById(Long[] permFileIds) {
        HRBaseServiceHelper permFileHelper = new HRBaseServiceHelper("hrcs_permfiles");
        DynamicObject[] dynamicObjects = permFileHelper.queryOriginalArray("id,user.id,org.id,enable", new QFilter[]{new QFilter("id", "in", (Object)permFileIds)});
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
    }

    public static Map<String, List<DynamicObject>> getRoleBuById(List<String> roleIds) {
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        DynamicObject[] roleBu = roleBuHelper.queryOriginalArray("id,role,org.id,containssub,hrbucafunc", new QFilter[]{new QFilter("role", "in", roleIds)});
        return Arrays.stream(roleBu).collect(Collectors.groupingBy(dy -> dy.getString("role")));
    }

    public static long[] genLongIds(String entityName, int size) {
        return ORM.create().genLongIds(entityName, size);
    }

    public static long genLongId(String entityName) {
        return ORM.create().genLongId(entityName);
    }

    public static String[] genStringIds(String entityName, int size) {
        return ORM.create().genStringIds(entityName, size);
    }

    public static String genStringId(String entityName) {
        return ORM.create().genStringId(entityName);
    }

    public static boolean roleExistDataRange(String roleId) {
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        Object[] roleBu = roleBuHelper.queryOriginalArray("id", new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        return !ObjectUtils.isEmpty((Object[])roleBu);
    }

    public static List<String> existDataRangeRoles(List<String> roleIds) {
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        DynamicObject[] roleBu = roleBuHelper.queryOriginalArray("role", new QFilter[]{new QFilter("role", "in", roleIds)});
        return Arrays.stream(roleBu).map(it -> it.getString("role")).collect(Collectors.toList());
    }

    public static Set<String> getStrBuCaFuncByRoleId(String roleId) {
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebucafunc");
        DynamicObject[] roleBu = roleBuHelper.queryOriginalArray("hrbucafunc", new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        return Arrays.stream(roleBu).map(dy -> dy.getString("hrbucafunc")).collect(Collectors.toSet());
    }

    public static DynamicObject getPermFileById(Long permFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
        return helper.queryOne("user,org.id,department.id,permfileenable", (Object)permFileId);
    }

    public static DynamicObject getGrpByPermFile(Long permFileId) {
        HRBaseServiceHelper permfileGrpHelper = new HRBaseServiceHelper("hrcs_permfilegrpmember");
        return permfileGrpHelper.queryOne("permfilegrp", new QFilter[]{new QFilter("permfile", "=", (Object)permFileId)});
    }

    public static List<Map<String, Object>> getRelationGroupByPermFile(Long permFileId) {
        HRBaseServiceHelper hrUserRoleHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        QFilter[] hrRoleFilters = new QFilter[]{new QFilter("permfile", "=", (Object)permFileId)};
        try (DataSet hrRoleDataSet = hrUserRoleHelper.queryDataSet("hr_hrcs_RoleMemberAssignServiceHelper_loadRoleList", "id,role,customenable, validstart, validend,createtime,creator,sourcetype,scheme.id,initrecord.id", hrRoleFilters, "createtime desc");){
            ArrayList userRoles = Lists.newArrayListWithExpectedSize((int)16);
            if (!hrRoleDataSet.hasNext()) {
                ArrayList arrayList = userRoles;
                return arrayList;
            }
            for (Row row : hrRoleDataSet) {
                HashMap tempMap = Maps.newHashMapWithExpectedSize((int)2);
                String roleId = row.getString("role");
                Object id = row.get("id");
                tempMap.put("userrolerelateid", id);
                tempMap.put("role", roleId);
                tempMap.put("customenable", row.getString("customenable"));
                tempMap.put("validstart", row.getString("validstart"));
                tempMap.put("validend", row.getString("validend"));
                tempMap.put("createtime", row.get("createtime"));
                tempMap.put("creator", row.get("creator"));
                String sourceType = row.getString("sourcetype");
                tempMap.put("sourcetype", sourceType);
                if (HRStringUtils.equals((String)sourceType, (String)"3")) {
                    tempMap.put("sourcebdtype", "hrcs_perminitrecord");
                    tempMap.put("sourcebd", row.get("initrecord.id"));
                } else if (HRStringUtils.equals((String)sourceType, (String)"4")) {
                    tempMap.put("sourcebdtype", "hrcs_dynascheme");
                    tempMap.put("sourcebd", row.get("scheme.id"));
                }
                userRoles.add(tempMap);
            }
            ArrayList arrayList = userRoles;
            return arrayList;
        }
    }

    public static long getMainDepIdByUser(Long userId) {
        HRBaseServiceHelper hrUserRoleHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject user = hrUserRoleHelper.queryOne("entryentity,entryentity.ispartjob,entryentity.dpt", (Object)userId);
        DynamicObjectCollection userPosition = user.getDynamicObjectCollection("entryentity");
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)userPosition)) {
            LOG.error("getMainDepIdByUser() getUserPosition is empty.");
            return 0L;
        }
        for (DynamicObject position : userPosition) {
            if (position.getBoolean("ispartjob")) continue;
            return position.getLong("dpt.id");
        }
        return 0L;
    }

    public static DynamicObject getPermRoleById(String roleId) {
        HRBaseServiceHelper relateHelper = new HRBaseServiceHelper("perm_role");
        return relateHelper.queryOriginalOne("id,number,name", (Object)roleId);
    }

    public static DynamicObject getHRRoleById(String roleId) {
        HRBaseServiceHelper relateHelper = new HRBaseServiceHelper("hrcs_role");
        return relateHelper.queryOriginalOne("id,rolegrp,rolegrp.name,property", (Object)roleId);
    }

    public static DynamicObject[] getPermRoleByUserRole(Set<Long> relationIds) {
        HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper("hrcs_userrole");
        QFilter relationFilter = new QFilter("userrolerealt", "in", relationIds);
        return userRoleHelper.queryOriginalArray("id,userrolepf.id", new QFilter[]{relationFilter});
    }

    public static DynamicObject[] geRoledimgrp(String roleId, Set<Long> bucafuncid) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledimgrp");
        DynamicObject[] roleBu = helper.query("id,index,bucafunc,entry,entry.dimension,entry.isall,entry.dimval,entry.containssub,entry.admincontainssub,entry.otclassify,entry.structproject,entry.valtype,entry.dynacond", new QFilter[]{new QFilter("role", "=", (Object)roleId), new QFilter("bucafunc", "in", bucafuncid)});
        return roleBu;
    }

    public static Map<Long, List<DynamicObject>> getRoleBuGroupByBu(String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_rolebu");
        DynamicObject[] roleBu = helper.queryOriginalArray("id,org.id,org.name,containssub,hrbucafunc", new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        return Arrays.stream(roleBu).collect(Collectors.groupingBy(dy -> dy.getLong("hrbucafunc")));
    }

    public static DynamicObject[] geDataRuleByApp(List<String> appIds, String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledatarule");
        DynamicObject[] roleBu = helper.query("id,app,entitytype,roledataruleentry,hrcs_rolebdruleentry,roledataruleentry.datarule,hrcs_rolebdruleentry.bddatarule,roledataruleentry.permitem,hrcs_rolebdruleentry.propkey,hrcs_rolebdruleentry.propentnum", new QFilter[]{new QFilter("app", "in", appIds), new QFilter("role", "=", (Object)roleId)});
        return roleBu;
    }

    public static Map<Long, List<String>> getAppByHrbucafunc(Set<Long> controlfuntype) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_appbusinesstype");
        DynamicObject[] roleBu = helper.queryOriginalArray("id,app,businesstype.controlfuntype", new QFilter[]{new QFilter("businesstype.controlfuntype", "in", controlfuntype)});
        return Arrays.stream(roleBu).collect(Collectors.groupingBy(roleBuGroup -> roleBuGroup.getLong("businesstype.controlfuntype"), Collectors.mapping(roleBuGroup -> roleBuGroup.getString("app"), Collectors.toList())));
    }

    public static DynamicObject[] getUserInfoByRoleAndUserId(String roleId, Long userId) {
        HRBaseServiceHelper relateHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        QFilter roleFilter = new QFilter("role.id", "=", (Object)roleId);
        QFilter userFilter = new QFilter("user.id", "=", (Object)userId);
        return relateHelper.query("id,permfile,user,role.id,customenable,validstart,validend", new QFilter[]{roleFilter, userFilter});
    }

    public static DynamicObject[] getUserRoleByRelation(Long relationId) {
        HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper("hrcs_userrole");
        QFilter relationFilter = new QFilter("userrolerealt.id", "=", (Object)relationId);
        return userRoleHelper.queryOriginalArray("id,org.id,org.name,includesuborg,index,userrolerealt.id,bucafunc", new QFilter[]{relationFilter});
    }

    public static DynamicObject[] getUserDimGrps(Long relationId, Set<Long> bucafuncIds) {
        HRBaseServiceHelper dimGrpFilter = new HRBaseServiceHelper("hrcs_userroledimgrp");
        QFilter relationFilter = new QFilter("userrolerelat.id", "=", (Object)relationId);
        QFilter bucafuncFilter = new QFilter("bucafunc.id", "in", bucafuncIds);
        return dimGrpFilter.query("id,userrolerelat.id,bucafunc.id,index,entry,entry.dimension,entry.dimension.datasource,entry.dimension.entitytype,entry.isall,entry.containssub,entry.admincontainssub,entry.otclassify,entry.dimval,entry.structproject,entry.valtype,entry.dynacond", new QFilter[]{relationFilter, bucafuncFilter});
    }

    public static DynamicObject[] getUserDataRule(Long relationId) {
        HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        QFilter relationFilter = new QFilter("userrolerelate.id", "=", (Object)relationId);
        return dataRuleHelper.query("id,app.id,entitytype.id,userrolerelate,dataruleentry,dataruleentry.permitem,dataruleentry.datarule,bddataruleentry,bddataruleentry.propkey,bddataruleentry.propentnum,bddataruleentry.bddatarule", new QFilter[]{relationFilter});
    }

    public static Map<Long, Set<String>> getAppsByHrbucafunc(Set<Long> funcIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_appbusinesstype");
        DynamicObject[] appIds = helper.queryOriginalArray("id,app.id,businesstype.controlfuntype.id", new QFilter[]{new QFilter("businesstype.controlfuntype", "in", funcIds)});
        Map<Long, Set<String>> appsByHrbucafunc = Arrays.stream(appIds).collect(Collectors.groupingBy(dy -> dy.getLong("businesstype.controlfuntype.id"), Collectors.mapping(dy -> dy.getString("app.id"), Collectors.toSet())));
        if (funcIds.contains(11L)) {
            HashSet hasHrBucaAppIds = Sets.newHashSetWithExpectedSize((int)16);
            appsByHrbucafunc.values().forEach(hasHrBucaAppIds::addAll);
            HRBaseServiceHelper appHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
            Set noHrBucaAppIds = appHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "not in", (Object)hasHrBucaAppIds).and("deploystatus", "=", (Object)"2")}).stream().map(it -> it.getString("id")).collect(Collectors.toSet());
            appsByHrbucafunc.get(11L).addAll(noHrBucaAppIds);
        }
        return appsByHrbucafunc;
    }

    public static DynamicObjectCollection getAppById(Set<String> appId) {
        HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        QFilter appFilter = new QFilter("id", "in", appId);
        return dataRuleHelper.queryOriginalCollection("id,name", new QFilter[]{appFilter});
    }

    public static DynamicObject getRoleName(String roleId) {
        HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("perm_role");
        QFilter appFilter = new QFilter("id", "=", (Object)roleId);
        return dataRuleHelper.queryOne("id,name", new QFilter[]{appFilter});
    }

    public static boolean isMutexDataLock(String objectId, String entitykey, String operationkey) {
        HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("bos_datalock");
        QFilter relationFilter = new QFilter("objectid", "=", (Object)objectId);
        QFilter relationFilter2 = new QFilter("operationkey", "=", (Object)operationkey);
        QFilter relationFilter3 = new QFilter("entitykey", "=", (Object)entitykey);
        return dataRuleHelper.isExists(new QFilter[]{relationFilter, relationFilter2, relationFilter3});
    }

    public static void roleAssignMembHandleLock(IFormView formView) {
        DynamicObject roleName = RoleMemberAssignServiceHelper.getRoleName(RoleServiceHelper.getRoleId(formView));
        ILocaleString nameLocal = roleName.getLocaleString("name");
        String name = nameLocal.getLocaleValue();
        boolean roleAssignDataLock = RoleMemberAssignServiceHelper.isMutexDataLock(name, "hrcs_role", "assign");
        if (!roleAssignDataLock) {
            RoleServiceHelper.handleLock(roleName.getString("name"), "hrcs_role", formView, "assign", ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u6b63\u5728\u4fee\u6539\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u6210\u5458\u3002", (String)"RoleMemberAssignDetailPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    public static void assignMembHandleLock(IFormView formView, String key) {
        boolean roleAssignDataLock = RoleMemberAssignServiceHelper.isMutexDataLock(key, "hrcs_role", "assign");
        if (!roleAssignDataLock) {
            RoleServiceHelper.handleLock(key, "hrcs_role", formView, "assign", ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u6b63\u5728\u4fee\u6539\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u6210\u5458\u3002", (String)"RoleMemberAssignDetailPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    public static DynamicObject[] mutexDataLockUser(String objectId, String entitykey, String operationkey) {
        HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("bos_datalock");
        QFilter relationFilter = new QFilter("objectid", "=", (Object)objectId);
        QFilter relationFilter2 = new QFilter("operationkey", "=", (Object)operationkey);
        QFilter relationFilter3 = new QFilter("entitykey", "=", (Object)entitykey);
        return dataRuleHelper.query("user", new QFilter[]{relationFilter, relationFilter2, relationFilter3});
    }

    public static void showRoleEditTips(IFormView view) {
        DynamicObject[] dynamicObjects = RoleMemberAssignServiceHelper.mutexDataLockUser(RoleServiceHelper.getRoleId(view), "perm_role", "modify");
        String name = "";
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            name = dynamicObjects[0].getString("user.name");
        }
        view.showTipNotification(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"AdminGroupPermEdit_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{name}));
    }

    public static void showRoleAssignEditTips(IFormView view, String key) {
        DynamicObject[] dynamicObjects = RoleMemberAssignServiceHelper.mutexDataLockUser(key, "hrcs_role", "assign");
        String name = "";
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            name = dynamicObjects[0].getString("user.name");
            view.showTipNotification(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"AdminGroupPermEdit_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{name}));
        }
    }

    public List<QFilter> filterRoleMemList() {
        return null;
    }
}

