/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.base.Joiner;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.RoleInfo;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.FieldPermModel;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.log.PermLogService;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRListFieldPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignSaveService;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.PermFormCommonUtil;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import kd.hr.hrcs.common.constants.perm.log.RoleInfoLogModel;

@ExcludeFromJacocoGeneratedReport
public class SaveRoleServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(SaveRoleServiceHelper.class);
    private static final String HRBUCA = "hrbuca";
    private static final String HRBUCAFUNC = "hrbucafunc";
    private static final String ENTITYTYPE = "entitytype";
    private static final String FIELDPERMENTRY = "fieldpermentry";
    private static final HRBaseServiceHelper DATA_RULE_HELPER = new HRBaseServiceHelper("hrcs_roledatarule");
    private static final HRBaseServiceHelper PERM_USERROLE_HELPER = new HRBaseServiceHelper("perm_userrole");
    private static final HRBaseServiceHelper USER_ROLE_HELPER = new HRBaseServiceHelper("hrcs_userrole");
    private static final HRBaseServiceHelper HR_USER_DATARRLE_HELPER = new HRBaseServiceHelper("hrcs_userdatarule");
    private static final HRBaseServiceHelper ROLE_DIM_HELPER = new HRBaseServiceHelper("hrcs_roledimension");
    private static final HRBaseServiceHelper RELATION_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
    private static final HRBaseServiceHelper USER_ROLE_DIM_GRP_HELPER = new HRBaseServiceHelper("hrcs_userroledimgrp");
    static final String KEY_CONTAINS_SUB = "containssub";
    static final String ENTITY_HBSS_USERROLE = "hrcs_userrole";
    private static final String ENTITY_HRCS_USERROLE_RELAT = "hrcs_userrolerelat";
    static final String FIELD_PERM_FILE = "permfile";
    static final String FIELD_CUSTOM_ENABLE = "customenable";
    static final String PERM_USERROLE = "perm_userrole";
    private static final String USERROLEPF = "userrolepf";
    private static final String USERROLEREALT = "userrolerealt";
    static final String USERROLEID = "userroleid";
    static final String VALIDSTART = "validstart";
    static final String VALIDEND = "validend";

    public static void newRole(IFormView formView, IFormPlugin confirmCallBackPlugin) {
        StringBuilder processInfo;
        IDataModel model = formView.getModel();
        if (!SaveRoleServiceHelper.checkSavePermission(formView)) {
            return;
        }
        if (SaveRoleServiceHelper.checkFuncPermComplete(formView, true)) {
            return;
        }
        String roleProperty = (String)formView.getModel().getValue("property");
        if (RoleServiceHelper.checkPermDataComplete(formView, roleProperty, true, processInfo = new StringBuilder(), confirmCallBackPlugin)) {
            return;
        }
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setEnable(Boolean.TRUE.booleanValue());
        DynamicObject roleGrp = (DynamicObject)model.getValue("group");
        if (Objects.nonNull(roleGrp)) {
            String groupId = roleGrp.getString("id");
            roleInfo.setGroupId(groupId);
        }
        roleInfo.setNum((String)model.getValue("number"));
        roleInfo.setRemarkLocale((ILocaleString)((OrmLocaleValue)model.getValue("remark")));
        roleInfo.setLocaleName((ILocaleString)((OrmLocaleValue)model.getValue("name")));
        String roleType = (String)model.getValue("roletype");
        if (HRStringUtils.isNotEmpty((String)roleType)) {
            roleInfo.setType(roleType);
        }
        roleInfo.setUseScope("0");
        DynamicObject createAdminGrp = (DynamicObject)model.getValue("createadmingrp");
        if (null != createAdminGrp) {
            roleInfo.setCreateAdminGrp(createAdminGrp.getString("id"));
        }
        if (!PermissionServiceHelper.newRole((RoleInfo)roleInfo, (StringBuilder)processInfo)) {
            formView.showTipNotification(processInfo.toString());
            return;
        }
        String roleId = roleInfo.getId();
        boolean fail = SaveRoleServiceHelper.commonSaveRole(formView, roleId, true, null, null);
        if (fail) {
            SaveRoleServiceHelper.rollbackBosData4New(roleInfo, processInfo);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_modifyrole");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(roleInfo.getLocaleName().getLocaleValue());
        showParameter.setCustomParam("roleId", (Object)roleId);
        formView.showForm(showParameter);
        formView.close();
    }

    public static boolean modifyRole(IFormView formView, IFormPlugin confirmCallBackPlugin) {
        StringBuilder processInfo;
        if (SaveRoleServiceHelper.checkFuncPermComplete(formView, true)) {
            return false;
        }
        String roleProperty = (String)formView.getModel().getValue("roleproperty");
        if (RoleServiceHelper.checkPermDataComplete(formView, roleProperty, true, processInfo = new StringBuilder(), confirmCallBackPlugin)) {
            return false;
        }
        boolean isCopy = HRStringUtils.equals((String)"1", (String)formView.getPageCache().get("copy"));
        if (isCopy) {
            String roleId = SaveRoleServiceHelper.newRole(formView);
            DynamicObjectCollection bosUserRole = new DynamicObjectCollection();
            HashMap<String, Object> bosPrePareData4CustomDisable = new HashMap<String, Object>(16);
            HashMap<String, Object> bosPrePareData4CustomEnable = new HashMap<String, Object>(16);
            boolean fail = SaveRoleServiceHelper.commonSaveRole(formView, roleId, true, bosUserRole, bosPrePareData4CustomDisable);
            if (fail) {
                SaveRoleServiceHelper.rollBack4Modify(roleId, formView, processInfo, bosPrePareData4CustomDisable, bosPrePareData4CustomEnable);
                return false;
            }
            formView.getFormShowParameter().setCustomParam("roleId", (Object)roleId);
            formView.getPageCache().put("roleId", roleId);
        } else {
            String roleId = (String)formView.getFormShowParameter().getCustomParam("roleId");
            DynamicObjectCollection bosUserRole = new DynamicObjectCollection();
            HashMap<String, Object> bosPrePareData4CustomDisable = new HashMap<String, Object>(16);
            HashMap<String, Object> bosPrePareData4CustomEnable = new HashMap<String, Object>(16);
            boolean fail = SaveRoleServiceHelper.commonSaveRole(formView, roleId, false, bosUserRole, bosPrePareData4CustomDisable);
            if (fail) {
                SaveRoleServiceHelper.rollBack4Modify(roleId, formView, processInfo, bosPrePareData4CustomDisable, bosPrePareData4CustomEnable);
                return false;
            }
        }
        formView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SaveRoleServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        RoleServiceHelper.releaseLock(formView);
        return true;
    }

    private static String newRole(IFormView formView) {
        StringBuilder processInfo;
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setEnable(Boolean.TRUE.booleanValue());
        DynamicObject roleGrp = (DynamicObject)formView.getModel().getValue("rolegroup");
        if (Objects.nonNull(roleGrp)) {
            String groupId = roleGrp.getString("id");
            roleInfo.setGroupId(groupId);
        }
        roleInfo.setNum((String)formView.getModel().getValue("rolenumber"));
        roleInfo.setRemarkLocale((ILocaleString)((OrmLocaleValue)formView.getModel().getValue("roleremark")));
        roleInfo.setLocaleName((ILocaleString)((OrmLocaleValue)formView.getModel().getValue("rolename")));
        String roleType = (String)formView.getModel().getValue("roletype");
        if (HRStringUtils.isNotEmpty((String)roleType)) {
            roleInfo.setType(roleType);
        }
        roleInfo.setUseScope("0");
        DynamicObject createAdminGrp = (DynamicObject)formView.getModel().getValue("createadmingrp");
        if (null != createAdminGrp) {
            roleInfo.setCreateAdminGrp(createAdminGrp.getString("id"));
        }
        if (!PermissionServiceHelper.newRole((RoleInfo)roleInfo, (StringBuilder)(processInfo = new StringBuilder()))) {
            formView.showTipNotification(processInfo.toString());
            return null;
        }
        String roleId = roleInfo.getId();
        return roleId;
    }

    public static void updatePermCache(IFormView formView) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        permPageCacheUtil.setOriginalFuncPermDataList(permPageCacheUtil.getFuncPermDataList());
        permPageCacheUtil.setOriginalDataPerm(permPageCacheUtil.getDataPermMap());
    }

    private static boolean commonSaveRole(IFormView formView, String roleId, boolean isNew, DynamicObjectCollection bosUserRole4rollBack, Map<String, Object> bosPrePareData4CustomDisable) {
        Throwable userRoleRelatHelper;
        if (!SaveRoleServiceHelper.saveFuncPerm(roleId, formView, isNew)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u529f\u80fd\u6743\u9650\u4fdd\u5b58\u5931\u8d25\u3002", (String)"SaveRoleServiceHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            return true;
        }
        if (SaveRoleServiceHelper.checkDataRule(formView)) {
            return true;
        }
        boolean fail = false;
        HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper(ENTITY_HBSS_USERROLE);
        HashMap<String, Object> hrPrePareData4CustomDis = new HashMap<String, Object>(16);
        QFilter[] delMemberHrBuFilters = new QFilter[]{};
        Object[] bosUserRoleArr = new Object[]{};
        HashSet delBuCaFuncSet = new HashSet(16);
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        RoleInfoLogModel beforeRoleInfoLogModel = new RoleInfoLogModel();
        if (!isNew) {
            RolePermLogServiceHelper.setPermLogDataByRoleId(beforeRoleInfoLogModel, pageCacheUtil.getOriginalFuncPermDataList(), roleId);
        }
        Map<String, RoleDataPermModel> permDataMap = pageCacheUtil.getDataPermMap();
        if (!isNew) {
            Set userRoleRelatIdSet;
            DynamicObject[] hrUserRole;
            HRBaseServiceHelper userRolePfHelper;
            DynamicObject[] bosUserRole;
            DynamicObject[] userRoleRelat;
            Set hrBuCaFuncSet = permDataMap.keySet().stream().map(Long::valueOf).collect(Collectors.toSet());
            userRoleRelatHelper = new HRBaseServiceHelper(ENTITY_HRCS_USERROLE_RELAT);
            HRBaseServiceHelper rolebucafuncHelper = new HRBaseServiceHelper("hrcs_rolebucafunc");
            DynamicObject[] rolebucafuncArr = rolebucafuncHelper.query(HRBUCAFUNC, new QFilter[]{new QFilter("role", "=", (Object)roleId)});
            Set orginalHrBuCaFuncSet = Arrays.stream(rolebucafuncArr).map(item -> item.getLong(HRBUCAFUNC)).collect(Collectors.toSet());
            Sets.SetView delHrBuCaFuncView = Sets.difference(orginalHrBuCaFuncSet, hrBuCaFuncSet);
            delHrBuCaFuncView.copyInto(delBuCaFuncSet);
            Set<Object> userRolePfidSet = new HashSet(16);
            if (!CollectionUtils.isEmpty(delBuCaFuncSet) && (userRoleRelat = userRoleRelatHelper.query(new QFilter[]{new QFilter("role", "=", (Object)roleId), new QFilter(FIELD_CUSTOM_ENABLE, "=", (Object)"1")})) != null && userRoleRelat.length > 0 && Objects.nonNull(bosUserRole = (userRolePfHelper = new HRBaseServiceHelper(PERM_USERROLE)).query("user,org,role,includesuborg,source,bizroleid,dimtype,starttime,endtime", new QFilter[]{new QFilter("id", "in", userRolePfidSet = Arrays.stream(hrUserRole = userRoleHelper.query(USERROLEPF, new QFilter[]{new QFilter(USERROLEREALT, "in", userRoleRelatIdSet = Arrays.stream(userRoleRelat).map(item -> item.getLong("id")).collect(Collectors.toSet())), new QFilter("bucafunc", "in", delBuCaFuncSet)})).map(item -> item.getString("userrolepf.id")).collect(Collectors.toSet()))})) && bosUserRole.length > 0) {
                bosUserRole4rollBack.addAll((Collection)Arrays.stream(bosUserRole).collect(Collectors.toList()));
                bosPrePareData4CustomDisable.put("bosOriginalData", bosUserRole);
                delMemberHrBuFilters = new QFilter[]{new QFilter("bucafunc", "in", delBuCaFuncSet), new QFilter(USERROLEREALT, "in", userRoleRelatIdSet)};
                if (!CollectionUtils.isEmpty(userRolePfidSet)) {
                    try (TXHandle txSysHandle = TX.required();){
                        try {
                            userRolePfHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", userRolePfidSet)});
                        }
                        catch (Exception ex) {
                            txSysHandle.markRollback();
                            LOGGER.info("commonSaveRole delete perm_userrole fail", (Object)ex);
                            fail = true;
                        }
                    }
                    if (fail) {
                        return true;
                    }
                }
            }
            SaveRoleServiceHelper.buildBosRoleMemberData(roleId, permDataMap, hrPrePareData4CustomDis, bosPrePareData4CustomDisable);
            QFilter[] bosDelFilters = (QFilter[])bosPrePareData4CustomDisable.get("bosDelFilters");
            DynamicObjectCollection bosCurrentData = (DynamicObjectCollection)bosPrePareData4CustomDisable.getOrDefault("bosCurrentData", new DynamicObjectCollection());
            Object[] userRoleRelat2 = (DynamicObject[])bosPrePareData4CustomDisable.getOrDefault("userRoleRelat", new DynamicObject[0]);
            try (TXHandle tx = TX.requiresNew();){
                try {
                    SaveRoleServiceHelper.saveRoleBaseInfo(roleId, formView, false);
                    if (!ObjectUtils.isEmpty((Object[])userRoleRelat2)) {
                        PERM_USERROLE_HELPER.deleteByFilter(bosDelFilters);
                    }
                    if (!CollectionUtils.isEmpty((Collection)bosCurrentData)) {
                        bosUserRoleArr = PERM_USERROLE_HELPER.save(bosCurrentData);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("commonSaveRole save userRole or relation fail.", (Throwable)ex);
                    tx.markRollback();
                    fail = true;
                }
            }
        }
        userRoleRelatHelper = null;
        try (TXHandle txHandle = TX.required();){
            try {
                if (!isNew) {
                    if (delMemberHrBuFilters.length > 0) {
                        userRoleHelper.deleteByFilter(delMemberHrBuFilters);
                    }
                    QFilter[] hrDelFilters = (QFilter[])hrPrePareData4CustomDis.get("hrDelFilters");
                    DynamicObjectCollection userRoles = (DynamicObjectCollection)hrPrePareData4CustomDis.get("hrCurrentData");
                    if (!ObjectUtils.isEmpty((Object[])bosUserRoleArr) && !CollectionUtils.isEmpty((Collection)userRoles)) {
                        USER_ROLE_HELPER.deleteByFilter(hrDelFilters);
                        USER_ROLE_HELPER.save(userRoles);
                    }
                }
                SaveRoleServiceHelper.saveHrRoleData(roleId, formView, isNew);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                formView.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25", (String)"SaveRoleServiceHelper_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                LOGGER.info("commonSaveRole save hrdata of permrole fail : {}", (Object)ex);
                fail = true;
            }
        }
        catch (Throwable ex) {
            userRoleRelatHelper = ex;
            throw ex;
        }
        if (!fail) {
            RoleInfoLogModel afterRoleInfoLogModel = new RoleInfoLogModel();
            RolePermLogServiceHelper.setPermLogDataByRoleId(afterRoleInfoLogModel, pageCacheUtil.getFuncPermDataList(), roleId);
            boolean isCopy = HRStringUtils.equals((String)"1", (String)formView.getPageCache().get("copy"));
            String opType = "modify";
            if (isNew) {
                opType = "add";
            }
            if (isCopy) {
                opType = "copy";
            }
            PermLogService.initPermLog(opType, beforeRoleInfoLogModel, afterRoleInfoLogModel, roleId);
        }
        return fail;
    }

    private static void putToSetOfMap(Map<String, Set<String>> map, String mapKey, String listValue) {
        LinkedHashSet list = map.get(mapKey);
        if (list == null) {
            list = Sets.newLinkedHashSetWithExpectedSize((int)16);
            map.put(mapKey, list);
        }
        list.add(listValue);
    }

    public static boolean checkDataRule(IFormView formView) {
        LinkedHashMap tipMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        Map<String, RoleDataPermModel> permDataMap = pageCacheUtil.getDataPermMap();
        Map<String, Map<String, Object>> allHrBuCaMap = pageCacheUtil.getAllHrBuCaMap();
        permDataMap.forEach((buCaFun, roleDataPermModel) -> {
            Map appEntity2DataRules = roleDataPermModel.getAppEntity2DataRules();
            appEntity2DataRules.forEach((entity, roleDataRuleMainModel) -> {
                Map dataRuleMap = roleDataRuleMainModel.getDataRuleMap();
                Map bdDataRuleMap = roleDataRuleMainModel.getBdDataRuleMap();
                dataRuleMap.forEach((key, roleDataRuleEntryModel) -> {
                    if ("emptyFlag".equals(key)) {
                        return;
                    }
                    List permItem = roleDataRuleEntryModel.getPermItem();
                    String dataRuleId = roleDataRuleEntryModel.getDataRuleId();
                    if (CollectionUtils.isEmpty((Collection)permItem) || HRStringUtils.isEmpty((String)dataRuleId)) {
                        String bucaFuncName = (String)((Map)allHrBuCaMap.get(buCaFun)).get("name");
                        String entityName = EntityMetadataCache.getDataEntityType((String)roleDataRuleEntryModel.getBusinessObject()).getDisplayName().getLocaleValue();
                        String listValue = ResManager.loadKDString((String)"\u201c%s\u201d", (String)"RoleServiceHelper_15", (String)"hrmp-hrcs-business", (Object[])new Object[]{entityName});
                        SaveRoleServiceHelper.putToSetOfMap(tipMap, bucaFuncName, listValue);
                    }
                });
                bdDataRuleMap.forEach((key, roleBdDataRuleEntryModel) -> {
                    if ("emptyFlag".equals(key)) {
                        return;
                    }
                    String dataRuleId = roleBdDataRuleEntryModel.getDataRuleId();
                    if (HRStringUtils.isEmpty((String)dataRuleId)) {
                        String bucaFuncName = (String)((Map)allHrBuCaMap.get(buCaFun)).get("name");
                        String entityName = EntityMetadataCache.getDataEntityType((String)roleBdDataRuleEntryModel.getBusinessObject()).getDisplayName().getLocaleValue();
                        String listValue = ResManager.loadKDString((String)"\u201c%s\u201d", (String)"RoleServiceHelper_15", (String)"hrmp-hrcs-business", (Object[])new Object[]{entityName});
                        SaveRoleServiceHelper.putToSetOfMap(tipMap, bucaFuncName, listValue);
                    }
                });
            });
        });
        if (!CollectionUtils.isEmpty((Map)tipMap)) {
            String entityNameSplitter = ResManager.loadKDString((String)"\u3001", (String)"RoleServiceHelper_14", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            for (Map.Entry entry : tipMap.entrySet()) {
                String entityNames = Joiner.on((String)entityNameSplitter).skipNulls().join((Iterable)entry.getValue());
                String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u201c%2$s\u201d\u7684\u6570\u636e\u89c4\u5219\u6216\u57fa\u7840\u8d44\u6599\u8303\u56f4\u672a\u5b8c\u6574\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RoleServiceHelper_13", (String)"hrmp-hrcs-business", (Object[])new Object[0]), entry.getKey(), entityNames);
                formView.showTipNotification(message);
            }
            return true;
        }
        Map<String, UserRoleFieldPermInfo> fieldPermData = pageCacheUtil.getFieldPermData();
        for (Map.Entry<String, UserRoleFieldPermInfo> tempMap : fieldPermData.entrySet()) {
            UserRoleFieldPermInfo userRoleFieldPermInfo = tempMap.getValue();
            List<FieldPermModel> fieldList = userRoleFieldPermInfo.getFieldPermModelList();
            for (FieldPermModel field : fieldList) {
                if (!HRStringUtils.isEmpty((String)field.getIsBanRead()) && !HRStringUtils.isEmpty((String)field.getIsBanWrite())) continue;
                formView.showTipNotification(ResManager.loadKDString((String)"\u89d2\u8272\u5b57\u6bb5\u6743\u9650\u672a\u5b8c\u6574\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RoleServiceHelper_16", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private static void rollbackBosData4New(RoleInfo roleInfo, StringBuilder processInfo) {
        roleInfo.setEnable(false);
        HRBaseServiceHelper bosRoleHelper = new HRBaseServiceHelper("perm_role");
        DynamicObject bosRole = bosRoleHelper.queryOne((Object)roleInfo.getId());
        bosRole.set("enable", (Object)"0");
        OperationServiceHelper.executeOperate((String)"save", (String)"perm_role", (DynamicObject[])new DynamicObject[]{bosRole}, (OperateOption)OperateOption.create());
        PermissionServiceHelper.deleteRole((RoleInfo)roleInfo, (StringBuilder)processInfo);
    }

    private static void saveRoleBaseInfo(String roleId, IFormView formView, boolean revert) {
        Object roleRemark;
        Object roleGroup;
        Object roleType;
        Object roleName;
        Object roleNumber;
        Object createAdminGrp;
        Date roleModifyDate;
        Object roleModifier;
        Map roleInfo = (Map)SerializationUtils.fromJsonString((String)formView.getPageCache().get("roleInfo"), Map.class);
        if (revert) {
            roleModifier = roleInfo.get("originalRoleModifier");
            roleModifyDate = Date.from(Instant.ofEpochMilli(Long.parseLong((String)roleInfo.get("originalRoleModifyTime"))));
            createAdminGrp = roleInfo.get("createadmingrp");
            roleNumber = roleInfo.get("originalRoleNumber");
            roleName = roleInfo.get("originalRoleName");
            roleType = roleInfo.get("originalRoleType");
            roleGroup = roleInfo.get("originalRoleGroup");
            roleRemark = roleInfo.get("originalRoleRemark");
        } else {
            roleModifier = RequestContext.get().getCurrUserId();
            roleModifyDate = TimeServiceHelper.now();
            roleNumber = formView.getModel().getValue("rolenumber");
            roleName = formView.getModel().getValue("rolename");
            roleType = formView.getModel().getValue("roletype");
            roleGroup = formView.getModel().getValue("rolegroup");
            roleRemark = formView.getModel().getValue("roleremark");
            createAdminGrp = formView.getModel().getValue("createadmingrp");
        }
        HRBaseServiceHelper bosRoleHelp = new HRBaseServiceHelper("perm_role");
        DynamicObject dObj = bosRoleHelp.queryOne((Object)roleId);
        dObj.set("modifier", roleModifier);
        dObj.set("modifytime", (Object)roleModifyDate);
        dObj.set("number", roleNumber);
        dObj.set("name", roleName);
        dObj.set("roletype", roleType);
        dObj.set("group", roleGroup);
        dObj.set("remark", roleRemark);
        dObj.set("usescope", (Object)"0");
        dObj.set("createadmingrp", createAdminGrp);
        bosRoleHelp.saveOne(dObj);
    }

    private static void saveHrRoleData(String roleId, IFormView formView, boolean isNew) {
        SaveRoleServiceHelper.saveHrBaseRoleInfo(roleId, formView, isNew);
        String needValidateUseScope = formView.getPageCache().get("needValidateUseScope");
        if (isNew || HRStringUtils.equals((String)"true", (String)needValidateUseScope)) {
            SaveRoleServiceHelper.saveRoleUseScope(roleId, formView, isNew);
        }
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        Map<String, RoleDataPermModel> permDataMap = pageCacheUtil.getDataPermMap();
        SaveRoleServiceHelper.saveHrBu(roleId, permDataMap);
        SaveRoleServiceHelper.saveHrBuFunc(roleId, pageCacheUtil);
        SaveRoleServiceHelper.saveDimData(roleId, permDataMap, pageCacheUtil, isNew);
        SaveRoleServiceHelper.saveRoleDataRule(roleId, permDataMap);
        Map<String, UserRoleFieldPermInfo> fieldPermData = pageCacheUtil.getFieldPermData();
        SaveRoleServiceHelper.saveRoleFieldPerm(roleId, fieldPermData);
    }

    private static void saveRoleUseScope(String roleId, IFormView formView, boolean isNew) {
        DynamicObject dataEntity = formView.getModel().getDataEntity(true);
        String useScope = dataEntity.getString("usescope");
        HRBaseServiceHelper openServiceHelper = new HRBaseServiceHelper("hrcs_roleopenscope");
        HRBaseServiceHelper assignServiceHelper = new HRBaseServiceHelper("hrcs_roleassignscope");
        if (!isNew) {
            openServiceHelper.deleteByFilter(new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
            assignServiceHelper.deleteByFilter(new QFilter[]{new QFilter("roleid.id", "=", (Object)roleId)});
        }
        if (HRStringUtils.equals((String)"0", (String)useScope)) {
            return;
        }
        if (HRStringUtils.equals((String)"2", (String)useScope)) {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            List rows = collection.stream().filter(it -> it.getDynamicObject("admingroup") != null).collect(Collectors.toList());
            DynamicObject[] toSaveRows = new DynamicObject[rows.size()];
            for (int index = 0; index < rows.size(); ++index) {
                DynamicObject dy = (DynamicObject)rows.get(index);
                DynamicObject temp = openServiceHelper.generateEmptyDynamicObject();
                temp.set("roleid", (Object)roleId);
                temp.set("admingroup", (Object)dy.getLong("admingroup.id"));
                toSaveRows[index] = temp;
            }
            openServiceHelper.save(toSaveRows);
        } else {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("assignentryentity");
            List rows = collection.stream().filter(it -> it.getDynamicObject("admingroup1") != null).collect(Collectors.toList());
            DynamicObject[] toSaveRows = new DynamicObject[rows.size()];
            for (int index = 0; index < rows.size(); ++index) {
                DynamicObject dy = (DynamicObject)rows.get(index);
                DynamicObject temp = assignServiceHelper.generateEmptyDynamicObject();
                temp.set("roleid", (Object)roleId);
                temp.set("admingroup", (Object)dy.getLong("admingroup1.id"));
                temp.set("ismodifiable", (Object)dy.getString("ismodifiable"));
                toSaveRows[index] = temp;
            }
            assignServiceHelper.save(toSaveRows);
        }
    }

    private static void handleMemberDataRule(PermPageCacheUtil permPageCacheUtil, DynamicObjectCollection hrCustomEnableUserRoleRelats) {
        Set<String> appEntitySet = SaveRoleServiceHelper.compareDelAppEntity(permPageCacheUtil);
        Set userRoleRelatIds = hrCustomEnableUserRoleRelats.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] userDataRules = HR_USER_DATARRLE_HELPER.queryOriginalArray("id,app,entitytype", new QFilter[]{new QFilter("userrolerelate", "in", userRoleRelatIds)});
        ArrayList<Long> userDataRuleIds = new ArrayList<Long>(16);
        for (DynamicObject userDataRule : userDataRules) {
            String key = userDataRule.getString("app") + userDataRule.getString(ENTITYTYPE);
            if (!appEntitySet.contains(key)) continue;
            userDataRuleIds.add(userDataRule.getLong("id"));
        }
        if (!CollectionUtils.isEmpty(userDataRuleIds)) {
            HR_USER_DATARRLE_HELPER.delete((Object[])userDataRuleIds.toArray(new Long[0]));
        }
    }

    private static Set<String> compareDelAppEntity(PermPageCacheUtil permPageCacheUtil) {
        HashSet<Map<String, String>> originalFuncPermDataSet = new HashSet<Map<String, String>>(permPageCacheUtil.getOriginalFuncPermDataList());
        HashSet<Map<String, String>> curFuncPermDataSet = new HashSet<Map<String, String>>(permPageCacheUtil.getFuncPermDataList());
        Set<String> originalAppEntity = originalFuncPermDataSet.stream().map(it -> (String)it.get("appId") + (String)it.get("entityNumber")).collect(Collectors.toSet());
        Set curAppEntity = curFuncPermDataSet.stream().map(it -> (String)it.get("appId") + (String)it.get("entityNumber")).collect(Collectors.toSet());
        originalAppEntity.removeAll(curAppEntity);
        return originalAppEntity;
    }

    private static void saveHrBuFunc(String roleId, PermPageCacheUtil pageCacheUtil) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_rolebucafunc");
        Set<String> assignedHrBuCaSet = pageCacheUtil.getAssignedHrBuCaSet();
        DynamicObjectCollection coll = new DynamicObjectCollection();
        assignedHrBuCaSet.forEach(hrBuCaFuncId -> {
            DynamicObject buCaFuncObj = helper.generateEmptyDynamicObject();
            buCaFuncObj.set("role", (Object)roleId);
            buCaFuncObj.set(HRBUCAFUNC, hrBuCaFuncId);
            coll.add((Object)buCaFuncObj);
        });
        helper.deleteByFilter(new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        if (!CollectionUtils.isEmpty((Collection)coll)) {
            helper.save(coll);
        }
    }

    private static void saveDimData(String roleId, Map<String, RoleDataPermModel> permDataMap, PermPageCacheUtil permPageCacheUtil, boolean isNew) {
        List<Map<String, String>> funcPermDataList;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledimgrp");
        QFilter[] delFilters = new QFilter[]{new QFilter("role", "=", (Object)roleId)};
        DynamicObjectCollection dimGrpCollection = new DynamicObjectCollection();
        if (!permPageCacheUtil.getDoNotSaveDimGrp()) {
            SaveRoleServiceHelper.buildDimGrpData(roleId, permDataMap, helper, dimGrpCollection);
        }
        helper.deleteByFilter(delFilters);
        if (!CollectionUtils.isEmpty((Collection)dimGrpCollection)) {
            helper.save(dimGrpCollection);
        }
        if (CollectionUtils.isEmpty(funcPermDataList = permPageCacheUtil.getFuncPermDataList())) {
            return;
        }
        List entityList = funcPermDataList.stream().map(item -> (String)item.get("entityNumber")).collect(Collectors.toList());
        QFilter[] filters = new QFilter[]{new QFilter(ENTITYTYPE, "in", entityList)};
        HRBaseServiceHelper entityCtrlHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject[] dims = entityCtrlHelper.query("entitytype,entryentity.propkey,entryentity.dimension,entryentity.ismust,bizapp", filters);
        HashMap entityCtrlMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, Map<String, String>> assignedDim = permPageCacheUtil.getAssignedDim();
        Map<String, Map<String, String>> assignedEntityBuCaFuncMap = permPageCacheUtil.getAssignedEntityBuCaFuncMap();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (DynamicObject dimObj : dims) {
            String entityType = dimObj.getString("entitytype.id");
            DynamicObjectCollection dimensionColl = dimObj.getDynamicObjectCollection("entryentity");
            dimensionColl.forEach(dimensionItem -> {
                if (SaveRoleServiceHelper.checkDimDisable(dimensionItem)) {
                    return;
                }
                DynamicObject dimension = dimensionItem.getDynamicObject("dimension");
                String propKey = dimensionItem.getString("propkey");
                Map appBuMap = (Map)assignedEntityBuCaFuncMap.get(entityType);
                if (CollectionUtils.isEmpty((Map)appBuMap) || HRStringUtils.isEmpty((String)propKey)) {
                    return;
                }
                appBuMap.forEach((appId, buCaFuncId) -> {
                    String dimBuCaKey = dimension.getString("id") + "#" + buCaFuncId;
                    String appEntityProp = appId + "#" + entityType + "#" + propKey;
                    Set appEntityPropSet = (Set)entityCtrlMap.get(dimBuCaKey);
                    if (CollectionUtils.isEmpty((Collection)appEntityPropSet)) {
                        appEntityPropSet = Sets.newHashSetWithExpectedSize((int)16);
                    }
                    appEntityPropSet.add(appEntityProp);
                    entityCtrlMap.put(dimBuCaKey, appEntityPropSet);
                });
            });
        }
        HashSet<String> currentRoleDimSet = new HashSet<String>(16);
        entityCtrlMap.forEach((key, valueSet) -> {
            String[] keyArray = key.split("#");
            String dimId = keyArray[0];
            String buCaFuncId = keyArray[1];
            if (assignedDim.get(dimId + "#" + buCaFuncId) == null) {
                return;
            }
            if (!buCaFuncId.equals(((Map)assignedDim.get(dimId + "#" + buCaFuncId)).get("buCaFuncId"))) {
                return;
            }
            String hrBuCaId = keyArray[1];
            DynamicObject dynamicObject = ROLE_DIM_HELPER.generateEmptyDynamicObject();
            dynamicObject.set("role", (Object)roleId);
            dynamicObject.set("dimension", (Object)dimId);
            dynamicObject.set("bucafunc", (Object)hrBuCaId);
            currentRoleDimSet.add(dimId + "#" + hrBuCaId);
            RoleDataPermModel roleDataPermModel = permDataMap.computeIfAbsent(hrBuCaId, tempKey -> new RoleDataPermModel());
            Map roleDimRelatDisableMap = roleDataPermModel.getRoleDimRelatDisableMap();
            DynamicObjectCollection entryCollection = ROLE_DIM_HELPER.generateEmptyEntryCollection(dynamicObject, "entry");
            valueSet.forEach(appEntityProp -> {
                DynamicObject entry = ROLE_DIM_HELPER.generateEmptyEntryDynamicObject("entry");
                String[] array = appEntityProp.split("#");
                entry.set("app", (Object)array[0]);
                entry.set(ENTITYTYPE, (Object)array[1]);
                entry.set("propkey", (Object)array[2]);
                Set disableEntitySet = roleDimRelatDisableMap.getOrDefault(dimId, new HashSet(16));
                entry.set("enable", (Object)(disableEntitySet.contains(array[0] + array[1] + array[2]) ? "0" : "1"));
                entryCollection.add((Object)entry);
            });
            collection.add((Object)dynamicObject);
        });
        if (!isNew) {
            DynamicObjectCollection originalRoleDimColl = ROLE_DIM_HELPER.queryOriginalCollection("dimension,bucafunc", new QFilter[]{new QFilter("role", "=", (Object)roleId)});
            DynamicObjectCollection hrCustomEnableUserRoleRelats = RELATION_HELPER.queryOriginalCollection("id", new QFilter[]{new QFilter("role", "=", (Object)roleId), new QFilter(FIELD_CUSTOM_ENABLE, "=", (Object)"1")});
            if (!CollectionUtils.isEmpty((Collection)hrCustomEnableUserRoleRelats)) {
                SaveRoleServiceHelper.handleMemberDimGrp(permPageCacheUtil, currentRoleDimSet, originalRoleDimColl, hrCustomEnableUserRoleRelats);
                SaveRoleServiceHelper.handleMemberDataRule(permPageCacheUtil, hrCustomEnableUserRoleRelats);
            }
        }
        ROLE_DIM_HELPER.deleteByFilter(delFilters);
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            ROLE_DIM_HELPER.save(collection);
        }
    }

    private static void handleMemberDimGrp(PermPageCacheUtil permPageCacheUtil, Set<String> currentRoleDimSet, DynamicObjectCollection originalRoleDimColl, DynamicObjectCollection hrCustomEnableUserRoleRelats) {
        Set originalRoleDimSet = originalRoleDimColl.stream().map(item -> item.getString("dimension") + "#" + item.getString("bucafunc")).collect(Collectors.toSet());
        Sets.SetView delDimView = Sets.difference(originalRoleDimSet, currentRoleDimSet);
        Sets.SetView addDimView = Sets.difference(currentRoleDimSet, originalRoleDimSet);
        HashSet<String> delUserRoleDimSet = new HashSet<String>(16);
        HashSet<String> addUserRoleDimSet = new HashSet<String>(16);
        delDimView.copyInto(delUserRoleDimSet);
        addDimView.copyInto(addUserRoleDimSet);
        HashMap<String, Set<String>> delUserRoleDimMap = new HashMap<String, Set<String>>(16);
        HashMap<String, Set<String>> addUserRoleDimMap = new HashMap<String, Set<String>>(16);
        SaveRoleServiceHelper.getDimSet(delUserRoleDimSet, delUserRoleDimMap);
        SaveRoleServiceHelper.getDimSet(addUserRoleDimSet, addUserRoleDimMap);
        Map<String, Map<String, Map<String, Object>>> originalHrBuCaDim = permPageCacheUtil.getOriginalHrBuCaDim();
        Map<String, Map<String, Map<String, Object>>> assignedHrBuCaDim = permPageCacheUtil.getAssignedHrBuCaDim();
        MapDifference buCaFuncDimdiff = Maps.difference(originalHrBuCaDim, assignedHrBuCaDim);
        Map delBuCaFuncDim = buCaFuncDimdiff.entriesOnlyOnLeft();
        Set delBuCaFuncSet = delBuCaFuncDim.keySet();
        Set userRoleRelatIds = hrCustomEnableUserRoleRelats.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] userRoleDims = USER_ROLE_DIM_GRP_HELPER.query("userrolerelat,bucafunc,entry,entry.dimension,entry.isall,entry.containssub", new QFilter[]{new QFilter("userrolerelat", "in", userRoleRelatIds)});
        DynamicObjectCollection modifyUserRoleDimColl = new DynamicObjectCollection();
        if (!(CollectionUtils.isEmpty(delUserRoleDimMap) && CollectionUtils.isEmpty(delBuCaFuncSet) && CollectionUtils.isEmpty(addUserRoleDimMap))) {
            for (DynamicObject userRoleDim : userRoleDims) {
                String buCaFuncId = userRoleDim.getString("bucafunc.id");
                Set dimSet = (Set)delUserRoleDimMap.get(buCaFuncId);
                if (!CollectionUtils.isEmpty((Collection)dimSet)) {
                    DynamicObjectCollection dimValColl = userRoleDim.getDynamicObjectCollection("entry");
                    Iterator iterator = dimValColl.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject dimVal = (DynamicObject)iterator.next();
                        String dimId = dimVal.getString("dimension.id");
                        if (!dimSet.contains(dimId)) continue;
                        iterator.remove();
                    }
                    if (CollectionUtils.isEmpty((Collection)dimValColl)) {
                        USER_ROLE_DIM_GRP_HELPER.deleteOne((Object)userRoleDim);
                    }
                }
                modifyUserRoleDimColl.add((Object)userRoleDim);
            }
            if (!CollectionUtils.isEmpty((Collection)modifyUserRoleDimColl)) {
                USER_ROLE_DIM_GRP_HELPER.save(modifyUserRoleDimColl);
            }
        }
        DynamicObjectCollection addUserRoleDimColl = new DynamicObjectCollection();
        Map addBuCaFuncDim = buCaFuncDimdiff.entriesOnlyOnRight();
        if (!CollectionUtils.isEmpty((Map)addBuCaFuncDim)) {
            for (Long userRoleRelatId : userRoleRelatIds) {
                for (Map.Entry buCaFuncDims : addBuCaFuncDim.entrySet()) {
                    String buCaFuncId = (String)buCaFuncDims.getKey();
                    DynamicObject userRoleDimObject = USER_ROLE_DIM_GRP_HELPER.generateEmptyDynamicObject();
                    userRoleDimObject.set("userrolerelat", (Object)userRoleRelatId);
                    userRoleDimObject.set("bucafunc", (Object)Long.valueOf(buCaFuncId));
                    DynamicObjectCollection entryColl = userRoleDimObject.getDynamicObjectCollection("entry");
                    Set dimInfo = ((Map)buCaFuncDims.getValue()).keySet();
                    for (String dimId : dimInfo) {
                        DynamicObject dimValEntry = USER_ROLE_DIM_GRP_HELPER.generateEmptyEntryDynamicObject("entry");
                        dimValEntry.set("dimension", (Object)Long.valueOf(dimId));
                        entryColl.add((Object)dimValEntry);
                    }
                    addUserRoleDimColl.add((Object)userRoleDimObject);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)addUserRoleDimColl)) {
                USER_ROLE_DIM_GRP_HELPER.save(addUserRoleDimColl);
            }
        }
    }

    private static void getDimSet(Set<String> delUserRoleDimSet, Map<String, Set<String>> delUserRoleDimMap) {
        delUserRoleDimSet.forEach(item -> {
            String buCaFuncId = item.substring(item.indexOf("#") + 1);
            Set orDefault = delUserRoleDimMap.computeIfAbsent(buCaFuncId, k -> new HashSet(16));
            orDefault.add(item.substring(0, item.indexOf("#")));
        });
    }

    public static boolean checkDimDisable(DynamicObject dimObj) {
        String authType = dimObj.getString("dimension.authtype");
        String enable = dimObj.getString("dimension.enable");
        if (HRStringUtils.equals((String)"0", (String)enable)) {
            return true;
        }
        return !HRStringUtils.equals((String)"row", (String)authType);
    }

    private static void buildDimGrpData(String roleId, Map<String, RoleDataPermModel> permDataMap, HRBaseServiceHelper helper, DynamicObjectCollection dimGrpCollection) {
        for (Map.Entry<String, RoleDataPermModel> entry : permDataMap.entrySet()) {
            RoleDataPermModel roleDataPermModel = entry.getValue();
            String buCaFuncId = entry.getKey();
            Map dimGroupMap = roleDataPermModel.getDimGroupMap();
            AtomicInteger seq = new AtomicInteger(1);
            for (Map.Entry dimGroupEntry : dimGroupMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).sorted(Comparator.comparingInt(it -> ((DimGrpModel)it.getValue()).getSeq())).collect(Collectors.toList())) {
                DimGrpModel dimGroup = (DimGrpModel)dimGroupEntry.getValue();
                TreeMap dimMap = dimGroup.getDimMap();
                if (null == dimMap || dimMap.isEmpty()) continue;
                DynamicObject dimGrpDynamicObject = helper.generateEmptyDynamicObject();
                DynamicObjectCollection entryColl = helper.generateEmptyEntryCollection(dimGrpDynamicObject, "entry");
                dimGrpDynamicObject.set("role", (Object)roleId);
                dimGrpDynamicObject.set("bucafunc", (Object)buCaFuncId);
                dimGrpDynamicObject.set("index", (Object)seq.get());
                boolean insertItem = true;
                for (Map.Entry<String, DimModel> entry2 : dimMap.entrySet()) {
                    DimModel dimModel = (DimModel)entry2.getValue();
                    if (CollectionUtils.isEmpty((Map)dimModel.getDimValues()) && HRStringUtils.equals((String)"0", (String)dimModel.getLimit())) {
                        insertItem = false;
                        break;
                    }
                    SaveRoleServiceHelper.fillDimGrpEntry(helper, entryColl, entry2);
                }
                if (!insertItem) continue;
                dimGrpCollection.add((Object)dimGrpDynamicObject);
                seq.incrementAndGet();
            }
        }
    }

    private static void fillDimGrpEntry(HRBaseServiceHelper helper, DynamicObjectCollection entryColl, Map.Entry<String, DimModel> dim) {
        DynamicObject dataRuleEntry = helper.generateEmptyEntryDynamicObject("entry");
        DimModel dimModel = dim.getValue();
        Map dimValues = dimModel.getDimValues();
        if (CollectionUtils.isEmpty((Map)dimValues)) {
            dataRuleEntry.set("dimension", (Object)dimModel.getDimId());
            dataRuleEntry.set("isall", (Object)dimModel.getLimit());
            entryColl.add((Object)dataRuleEntry);
        } else {
            for (Map.Entry entry : dimValues.entrySet()) {
                Object structProject;
                dataRuleEntry = helper.generateEmptyEntryDynamicObject("entry");
                Map value = (Map)entry.getValue();
                String dynaCond = value.getOrDefault("dynamicCondition", "0");
                dataRuleEntry.set("dimension", (Object)dimModel.getDimId());
                dataRuleEntry.set("isall", (Object)dimModel.getLimit());
                dataRuleEntry.set(KEY_CONTAINS_SUB, value.get("includeSub"));
                dataRuleEntry.set("admincontainssub", (Object)value.getOrDefault("includeSubAdminOrg", Boolean.FALSE));
                dataRuleEntry.set("dimval", value.get("id"));
                dataRuleEntry.set("valtype", (Object)value.getOrDefault("valueType", "1"));
                dataRuleEntry.set("dynacond", (Object)Long.parseLong(HRStringUtils.isEmpty((String)dynaCond) ? "0" : dynaCond));
                Object classify = value.get("otClassify");
                if (Objects.nonNull(classify)) {
                    if (classify instanceof Map) {
                        dataRuleEntry.set("otclassify", (Object)Long.parseLong(((Map)classify).get("id").toString()));
                    } else {
                        dataRuleEntry.set("otclassify", (Object)Long.parseLong(classify.toString()));
                    }
                }
                if (Objects.nonNull(structProject = value.get("structProject"))) {
                    if (structProject instanceof Map) {
                        dataRuleEntry.set("structproject", (Object)Long.parseLong(((Map)structProject).get("id").toString()));
                    } else {
                        dataRuleEntry.set("structproject", (Object)Long.parseLong(structProject.toString()));
                    }
                }
                entryColl.add((Object)dataRuleEntry);
            }
        }
    }

    private static void saveRoleFieldPerm(String roleId, Map<String, UserRoleFieldPermInfo> fieldPermInfo) {
        HRBaseServiceHelper roleFieldPermHelper = new HRBaseServiceHelper("hrcs_rolefield");
        DynamicObject roleFieldPerm = roleFieldPermHelper.generateEmptyDynamicObject();
        DynamicObjectType roleFieldType = roleFieldPerm.getDynamicObjectType();
        DynamicObjectCollection roleFieldPerms = new DynamicObjectCollection();
        for (Map.Entry<String, UserRoleFieldPermInfo> tempMap : fieldPermInfo.entrySet()) {
            String[] entityTypeInfo = tempMap.getKey().split("@");
            roleFieldPerm = new DynamicObject(roleFieldType);
            roleFieldPerm.set("role", (Object)roleId);
            roleFieldPerm.set(ENTITYTYPE, (Object)entityTypeInfo[1]);
            roleFieldPerm.set("app", (Object)entityTypeInfo[0]);
            UserRoleFieldPermInfo userRoleFieldPermInfo = tempMap.getValue();
            List<FieldPermModel> fieldList = userRoleFieldPermInfo.getFieldPermModelList();
            DynamicObjectCollection coll = roleFieldPermHelper.generateEmptyEntryCollection(roleFieldPerm, FIELDPERMENTRY);
            for (FieldPermModel field : fieldList) {
                DynamicObject fieldPermEntry = roleFieldPermHelper.generateEmptyEntryDynamicObject(FIELDPERMENTRY);
                fieldPermEntry.set("fieldname", (Object)field.getFiledNum());
                fieldPermEntry.set("isbanread", (Object)HRListFieldPermServiceHelper.getBlValue(field.getIsBanRead()));
                fieldPermEntry.set("isbanwrite", (Object)HRListFieldPermServiceHelper.getBlValue(field.getIsBanWrite()));
                coll.add((Object)fieldPermEntry);
            }
            roleFieldPerm.set(FIELDPERMENTRY, (Object)coll);
            roleFieldPerms.add((Object)roleFieldPerm);
        }
        roleFieldPermHelper.deleteByFilter(new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        if (!CollectionUtils.isEmpty((Collection)roleFieldPerms)) {
            roleFieldPermHelper.save(roleFieldPerms);
        }
    }

    private static void saveHrBu(String roleId, Map<String, RoleDataPermModel> permDataMap) {
        Optional<Integer> reduce = permDataMap.values().stream().map(roleDataPermModel -> roleDataPermModel.getOrgMap().size()).reduce(Integer::sum);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_rolebu");
        helper.deleteByFilter(new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        if (!reduce.isPresent()) {
            return;
        }
        int hrBuSize = reduce.get();
        long[] ids = DBServiceHelper.genLongIds((String)"hrcs_rolebu", (int)hrBuSize);
        int idIdx = 0;
        DynamicObjectCollection saveDyColl = new DynamicObjectCollection();
        DynamicObject emptyDy = helper.generateEmptyDynamicObject();
        for (Map.Entry<String, RoleDataPermModel> roleDataPermEntry : permDataMap.entrySet()) {
            String buCaId = roleDataPermEntry.getKey();
            Map orgMap = roleDataPermEntry.getValue().getOrgMap();
            for (Map.Entry orgEntry : orgMap.entrySet()) {
                Map orgInfo = (Map)orgEntry.getValue();
                DynamicObject dy = new DynamicObject(emptyDy.getDynamicObjectType());
                dy.set("id", (Object)ids[idIdx]);
                dy.set("role", (Object)roleId);
                dy.set("org", (Object)Long.parseLong(String.valueOf(orgInfo.get("id"))));
                dy.set(KEY_CONTAINS_SUB, orgInfo.get("includeSub"));
                dy.set(HRBUCA, (Object)Long.parseLong(buCaId));
                dy.set(HRBUCAFUNC, (Object)Long.parseLong(buCaId));
                saveDyColl.add((Object)dy);
                ++idIdx;
            }
        }
        helper.save(saveDyColl);
    }

    public static void buildBosRoleMemberData(String roleId, Map<String, RoleDataPermModel> permDataMap, Map<String, Object> hrPrePareData4CustomDis, Map<String, Object> bosPrePareData4CustomDis) {
        HRBaseServiceHelper RELATION_HELPER = new HRBaseServiceHelper(ENTITY_HRCS_USERROLE_RELAT);
        DynamicObject[] userRoleRelat = RELATION_HELPER.query("id,user,user.id,validstart,validend", new QFilter[]{new QFilter("role", "=", (Object)roleId), new QFilter(FIELD_CUSTOM_ENABLE, "=", (Object)"0")});
        List userrolerelat = Arrays.stream(userRoleRelat).map(userRoleRelatDy -> userRoleRelatDy.getLong("id")).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(userrolerelat)) {
            return;
        }
        DynamicObject[] userRoleRelats = USER_ROLE_HELPER.query("userrolepf.id", new QFilter[]{new QFilter(USERROLEREALT, "in", userrolerelat)});
        Set bosUserRoleIds = Arrays.stream(userRoleRelats).map(item -> item.getString("userrolepf.id")).collect(Collectors.toSet());
        DynamicObjectCollection userRoles = new DynamicObjectCollection();
        DynamicObjectCollection permUserRoles = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : userRoleRelat) {
            for (Map.Entry<String, RoleDataPermModel> roleDataPermEntry : permDataMap.entrySet()) {
                String buCaId = roleDataPermEntry.getKey();
                Map orgMap = roleDataPermEntry.getValue().getOrgMap();
                for (Map.Entry orgEntry : orgMap.entrySet()) {
                    Map orgInfo = (Map)orgEntry.getValue();
                    DynamicObject permUserRole = SaveRoleServiceHelper.assemblePermUserRole(dynamicObject, roleId, orgInfo);
                    DynamicObject userRole = SaveRoleServiceHelper.assembleUserRole(dynamicObject, orgInfo, buCaId, permUserRole.getString("id"));
                    permUserRoles.add((Object)permUserRole);
                    userRoles.add((Object)userRole);
                }
            }
        }
        QFilter[] bosDelFilters = new QFilter[]{new QFilter("id", "in", bosUserRoleIds)};
        DynamicObject[] bosOrginalData = PERM_USERROLE_HELPER.query("user,org,role,includesuborg,source,bizroleid,dimtype,starttime,endtime", bosDelFilters);
        bosPrePareData4CustomDis.put("bosDelFilters", bosDelFilters);
        bosPrePareData4CustomDis.put("bosOriginalData", bosOrginalData);
        bosPrePareData4CustomDis.put("bosCurrentData", permUserRoles);
        bosPrePareData4CustomDis.put("userRoleRelat", userRoleRelat);
        Object[] permRoleSave = new Object[]{};
        QFilter[] hrDelFilters = new QFilter[]{new QFilter(USERROLEREALT, "in", userrolerelat)};
        hrPrePareData4CustomDis.put("hrDelFilters", hrDelFilters);
        hrPrePareData4CustomDis.put("hrCurrentData", userRoles);
        hrPrePareData4CustomDis.put("bosUserRoleData", permRoleSave);
    }

    private static DynamicObject assemblePermUserRole(DynamicObject relation, String roleId, Map<String, Object> orgInfo) {
        DynamicObject permUserRole = PERM_USERROLE_HELPER.generateEmptyDynamicObject();
        long userId = relation.getLong("user.id");
        String[] permIds = RoleMemberAssignServiceHelper.genStringIds(PERM_USERROLE, 1);
        permUserRole.set("id", (Object)permIds[0]);
        permUserRole.set("role", (Object)roleId);
        permUserRole.set("org", (Object)Long.parseLong(String.valueOf(orgInfo.get("id"))));
        permUserRole.set("user", (Object)userId);
        permUserRole.set("includesuborg", orgInfo.get("includeSub"));
        permUserRole.set("dimtype", (Object)"bos_org");
        permUserRole.set("source", (Object)"hr");
        boolean enableValidateTime = RoleMemberAssignServiceHelper.enablePermValidateTime();
        if (enableValidateTime) {
            permUserRole.set("starttime", relation.get(VALIDSTART));
            permUserRole.set("endtime", relation.get(VALIDEND));
        }
        return permUserRole;
    }

    private static DynamicObject assembleUserRole(DynamicObject relation, Map<String, Object> orgInfo, String bucafunc, String userrolepf) {
        DynamicObject userRole = USER_ROLE_HELPER.generateEmptyDynamicObject();
        userRole.set("org", (Object)Long.parseLong(String.valueOf(orgInfo.get("id"))));
        userRole.set("includesuborg", orgInfo.get("includeSub"));
        userRole.set(USERROLEREALT, relation.get("id"));
        userRole.set(USERROLEPF, (Object)userrolepf);
        userRole.set("bucafunc", (Object)bucafunc);
        return userRole;
    }

    private static void saveHrBaseRoleInfo(String roleId, IFormView formView, boolean isNew) {
        DynamicObject permRoleDy;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_role");
        DynamicObject dataEntity = formView.getModel().getDataEntity();
        long createAdminGrp = dataEntity.getLong("createadmingrp.id");
        String useScope = dataEntity.getString("usescope");
        if (isNew) {
            permRoleDy = serviceHelper.generateEmptyDynamicObject();
            boolean isCopy = HRStringUtils.equals((String)"1", (String)((String)formView.getFormShowParameter().getCustomParam("copy")));
            if (isCopy) {
                permRoleDy.set("id", (Object)roleId);
                String property = (String)formView.getModel().getValue("roleproperty");
                permRoleDy.set("property", (Object)property);
                permRoleDy.set("rolegrp", formView.getModel().getValue("rolegroup"));
                String intersection = HRStringUtils.equals((String)"0", (String)property) ? " " : (String)formView.getModel().getValue("rolecbisintersection");
                permRoleDy.set("isintersection", (Object)intersection);
            } else {
                permRoleDy.set("id", (Object)roleId);
                String property = (String)formView.getModel().getValue("property");
                permRoleDy.set("property", (Object)property);
                permRoleDy.set("rolegrp", formView.getModel().getValue("group"));
                String intersection = HRStringUtils.equals((String)"0", (String)property) ? " " : (String)formView.getModel().getValue("isintersection");
                permRoleDy.set("isintersection", (Object)intersection);
            }
        } else {
            permRoleDy = serviceHelper.queryOne((Object)roleId);
            String property = (String)formView.getModel().getValue("roleproperty");
            permRoleDy.set("property", formView.getModel().getValue("roleproperty"));
            permRoleDy.set("rolegrp", formView.getModel().getValue("rolegroup"));
            String intersection = HRStringUtils.equals((String)"0", (String)property) ? " " : (String)formView.getModel().getValue("rolecbisintersection");
            permRoleDy.set("isintersection", (Object)intersection);
        }
        permRoleDy.set("usescope", (Object)useScope);
        permRoleDy.set("createadmingrp", (Object)createAdminGrp);
        serviceHelper.saveOne(permRoleDy);
    }

    private static void saveRoleDataRule(String roleId, Map<String, RoleDataPermModel> permDataMap) {
        Date now = new Date();
        DynamicObjectCollection dataRules = new DynamicObjectCollection();
        permDataMap.forEach((buCaFuncId, model) -> {
            Map appEntity2DataRules = model.getAppEntity2DataRules();
            if (appEntity2DataRules == null) {
                return;
            }
            appEntity2DataRules.forEach((appEntity, dataRuleMainModel) -> {
                String[] split = appEntity.split("#");
                DynamicObject dataRuleMain = DATA_RULE_HELPER.generateEmptyDynamicObject();
                dataRuleMain.set("app", (Object)split[0]);
                dataRuleMain.set(ENTITYTYPE, (Object)split[1]);
                dataRuleMain.set("role", (Object)roleId);
                RoleMemberAssignSaveService.setSysField(dataRuleMain, now);
                DynamicObjectCollection entryColl = DATA_RULE_HELPER.generateEmptyEntryCollection(dataRuleMain, "roledataruleentry");
                if (!CollectionUtils.isEmpty((Map)dataRuleMainModel.getDataRuleMap())) {
                    dataRuleMainModel.getDataRuleMap().forEach((key, value) -> {
                        if (HRStringUtils.equals((String)"emptyFlag", (String)key)) {
                            return;
                        }
                        value.getPermItem().forEach(permItem -> {
                            DynamicObject dataRuleEntry = DATA_RULE_HELPER.generateEmptyEntryDynamicObject("roledataruleentry");
                            dataRuleEntry.set("permitem", permItem);
                            dataRuleEntry.set("datarule", (Object)value.getDataRuleId());
                            entryColl.add((Object)dataRuleEntry);
                        });
                    });
                }
                DynamicObjectCollection bdEntryColl = DATA_RULE_HELPER.generateEmptyEntryCollection(dataRuleMain, "hrcs_rolebdruleentry");
                if (!CollectionUtils.isEmpty((Map)dataRuleMainModel.getBdDataRuleMap())) {
                    dataRuleMainModel.getBdDataRuleMap().forEach((propKey, bdDataRuleEntryModel) -> {
                        String property = bdDataRuleEntryModel.getProperty();
                        if (HRStringUtils.equals((String)"emptyFlag", (String)propKey)) {
                            return;
                        }
                        DynamicObject dataRuleEntry = DATA_RULE_HELPER.generateEmptyEntryDynamicObject("hrcs_rolebdruleentry");
                        dataRuleEntry.set("propkey", (Object)bdDataRuleEntryModel.getProperty());
                        dataRuleEntry.set("propkey", (Object)property);
                        dataRuleEntry.set("propentnum", (Object)bdDataRuleEntryModel.getPropertyNum());
                        dataRuleEntry.set("bddatarule", (Object)bdDataRuleEntryModel.getDataRuleId());
                        bdEntryColl.add((Object)dataRuleEntry);
                    });
                }
                if (CollectionUtils.isEmpty((Collection)bdEntryColl) && CollectionUtils.isEmpty((Collection)entryColl)) {
                    return;
                }
                dataRules.add((Object)dataRuleMain);
            });
        });
        DATA_RULE_HELPER.deleteByFilter(new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        if (!CollectionUtils.isEmpty((Collection)dataRules)) {
            DATA_RULE_HELPER.save(dataRules);
        }
    }

    public static void removeRoleDataRuleCach(PermPageCacheUtil permPageCacheUtil, List<Map<String, Object>> selectedNodes) {
        Map<String, RoleDataPermModel> dataPermMap = permPageCacheUtil.getDataPermMap();
        selectedNodes.forEach(selectNodeMap -> selectNodeMap.forEach((key, value) -> {
            String[] idSplit;
            String valueId;
            if ("id".equals(key) && (valueId = (String)selectNodeMap.get(key)).contains("|") && valueId.contains("@") && valueId.contains("#") && (idSplit = valueId.split("#")).length >= 1 && "entity".equals(idSplit[idSplit.length - 1])) {
                String entityNum = valueId.substring(valueId.indexOf("|") + 1, valueId.indexOf("@"));
                String appNum = valueId.substring(valueId.indexOf("@") + 1, valueId.indexOf("#"));
                String appEntityNode = appNum + "#" + entityNum;
                dataPermMap.forEach((buCaFuncId, model) -> {
                    Map appEntity2DataRules = model.getAppEntity2DataRules();
                    Iterator iterator = appEntity2DataRules.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry next = iterator.next();
                        String appEntity = (String)next.getKey();
                        if (!appEntityNode.equals(appEntity)) continue;
                        iterator.remove();
                    }
                });
            }
        }));
        permPageCacheUtil.setDataPerm(dataPermMap);
    }

    private static boolean saveFuncPerm(String roleId, IFormView formView, boolean isNew) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        List<Map<String, String>> dataLists = permPageCacheUtil.getFuncPermDataList();
        StringBuilder processInfo = new StringBuilder();
        boolean result = isNew ? SaveRoleServiceHelper.doSaveFuncPerm4New(roleId, dataLists, processInfo) : SaveRoleServiceHelper.doSaveFuncPerm4Modify(roleId, formView, processInfo);
        if (!result) {
            formView.showErrorNotification(processInfo.toString());
        }
        if (!isNew && result) {
            HRPermCacheMgr.clearAllCacheAndNotifyAsync(roleId);
        }
        PermFormCommonUtil.setDataChanged((IDataModel)formView.getModel(), (boolean)true, (boolean)false);
        return result;
    }

    private static boolean doSaveFuncPerm4Modify(String roleId, IFormView formView, StringBuilder processInfo) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        HashSet<Map<String, String>> originalFuncPermDataSet = new HashSet<Map<String, String>>(permPageCacheUtil.getOriginalFuncPermDataList());
        HashSet<Map<String, String>> curFuncPermDataSet = new HashSet<Map<String, String>>(permPageCacheUtil.getFuncPermDataList());
        return SaveRoleServiceHelper.doModifyFuncPerm(roleId, processInfo, originalFuncPermDataSet, curFuncPermDataSet);
    }

    private static void rollBack4Modify(String roleId, IFormView formView, StringBuilder processInfo, Map<String, Object> bosPrePareData4CustomDisable, Map<String, Object> bosPrePareData4CustomEnable) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        HashSet<Map<String, String>> curFuncPermDataSet = new HashSet<Map<String, String>>(permPageCacheUtil.getFuncPermDataList());
        HashSet<Map<String, String>> originalFuncPermDataSet = new HashSet<Map<String, String>>(permPageCacheUtil.getOriginalFuncPermDataList());
        SaveRoleServiceHelper.doModifyFuncPerm(roleId, processInfo, curFuncPermDataSet, originalFuncPermDataSet);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(PERM_USERROLE);
        Object[] bosOriginalData4Disable = (DynamicObject[])bosPrePareData4CustomDisable.getOrDefault("bosOriginalData", new DynamicObject[0]);
        DynamicObjectCollection bosCurrentData = (DynamicObjectCollection)bosPrePareData4CustomDisable.getOrDefault("bosCurrentData", new DynamicObjectCollection());
        DynamicObjectCollection bosOriginalData4Enable = (DynamicObjectCollection)bosPrePareData4CustomEnable.getOrDefault("bosOriginalData", new DynamicObjectCollection());
        try (TXHandle txSysHandle = TX.required();){
            try {
                if (CollectionUtils.isEmpty((Collection)bosCurrentData)) {
                    helper.delete(bosCurrentData.stream().map(item -> item.get("id")).toArray());
                }
                if (!ObjectUtils.isEmpty((Object[])bosOriginalData4Disable)) {
                    helper.save((DynamicObject[])bosOriginalData4Disable);
                }
                if (!ObjectUtils.isEmpty((Object)bosOriginalData4Enable)) {
                    helper.save(bosOriginalData4Enable);
                }
                SaveRoleServiceHelper.saveRoleBaseInfo(roleId, formView, true);
            }
            catch (Exception ex) {
                txSysHandle.markRollback();
                LOGGER.info("roleback perm_userrole fail : {}", (Object)ex.getMessage());
            }
        }
    }

    private static boolean doModifyFuncPerm(String roleId, StringBuilder processInfo, Set<Map<String, String>> originalFuncPermDataSet, Set<Map<String, String>> curFuncPermDataSet) {
        Set originalFuncPermDataInfoSet = originalFuncPermDataSet.stream().map(it -> (String)it.get("entityNumber") + "|" + (String)it.get("permItemId") + "|" + (String)it.get("appId")).collect(Collectors.toSet());
        Set curFuncPermDataInfoSet = curFuncPermDataSet.stream().map(it -> (String)it.get("entityNumber") + "|" + (String)it.get("permItemId") + "|" + (String)it.get("appId")).collect(Collectors.toSet());
        Sets.SetView delPermItemView = Sets.difference(originalFuncPermDataInfoSet, curFuncPermDataInfoSet);
        Sets.SetView addPermItemView = Sets.difference(curFuncPermDataInfoSet, originalFuncPermDataInfoSet);
        HashSet delPermItemInfo = Sets.newHashSetWithExpectedSize((int)delPermItemView.size());
        delPermItemView.copyInto((Set)delPermItemInfo);
        HashSet addPermItemInfo = Sets.newHashSetWithExpectedSize((int)addPermItemView.size());
        addPermItemView.copyInto((Set)addPermItemInfo);
        Set<Map<String, String>> delPermItem = SaveRoleServiceHelper.transferToMap(delPermItemInfo);
        Set<Map<String, String>> addPermItem = SaveRoleServiceHelper.transferToMap(addPermItemInfo);
        HashMap<String, List<String>> appEntity = new HashMap<String, List<String>>(16);
        Map<String, Map<String, List<String>>> addAppEntityPermItemMap = SaveRoleServiceHelper.getAppEntityPermItemMap(addPermItem, appEntity);
        boolean result = PermissionServiceHelper.roleAssignFuncPerm((String)roleId, addAppEntityPermItemMap, (boolean)true, (StringBuilder)processInfo);
        if (!result) {
            return false;
        }
        Map<String, Map<String, List<String>>> delAppEntityPermItemMap = SaveRoleServiceHelper.getAppEntityPermItemMap(delPermItem, null);
        result = PermissionServiceHelper.roleAssignFuncPerm((String)roleId, delAppEntityPermItemMap, (boolean)false, (StringBuilder)processInfo);
        if (!result) {
            PermissionServiceHelper.roleAssignFuncPerm((String)roleId, addAppEntityPermItemMap, (boolean)false, (StringBuilder)processInfo);
            return false;
        }
        SaveRoleServiceHelper.handleLicense(roleId, appEntity);
        return true;
    }

    private static Set<Map<String, String>> transferToMap(Set<String> permItemInfos) {
        HashSet<Map<String, String>> result = new HashSet<Map<String, String>>(permItemInfos.size());
        for (String permItemInfo : permItemInfos) {
            String[] infos = permItemInfo.split("\\|");
            HashMap<String, String> temp = new HashMap<String, String>(3);
            temp.put("entityNumber", infos[0]);
            temp.put("permItemId", infos[1]);
            temp.put("appId", infos[2]);
            result.add(temp);
        }
        return result;
    }

    private static Map<String, Map<String, List<String>>> getAppEntityPermItemMap(Set<Map<String, String>> funcPermDataList, Map<String, List<String>> appEntity) {
        HashMap<String, Map<String, List<String>>> appEntityPermItemMap = new HashMap<String, Map<String, List<String>>>(16);
        for (Map<String, String> data : funcPermDataList) {
            String appId = data.get("appId");
            String entityNum = data.get("entityNumber");
            String permItemId = data.get("permItemId");
            appEntityPermItemMap.computeIfAbsent(appId, key -> new HashMap()).computeIfAbsent(entityNum, key -> new ArrayList()).add(permItemId);
            if (appEntity == null) continue;
            appEntity.computeIfAbsent(appId, key -> new ArrayList()).add(entityNum);
        }
        return appEntityPermItemMap;
    }

    public static boolean doSaveFuncPerm4New(String roleId, List<Map<String, String>> dataLists, StringBuilder processInfo) {
        HashMap<String, List<String>> appEntity = new HashMap<String, List<String>>(16);
        HashMap<String, Map> appEntityPermItemMap = new HashMap<String, Map>(16);
        for (Map<String, String> data : dataLists) {
            String appId = data.get("appId");
            String permItemId = data.get("permItemId");
            String entityNum = data.get("entityNumber");
            appEntityPermItemMap.computeIfAbsent(appId, key -> new HashMap()).computeIfAbsent(entityNum, key -> new ArrayList()).add(permItemId);
            appEntity.computeIfAbsent(appId, key -> new ArrayList()).add(entityNum);
        }
        boolean result = PermissionServiceHelper.roleAssignFuncPerm((String)roleId, appEntityPermItemMap, (boolean)true, (StringBuilder)processInfo);
        if (!result) {
            return false;
        }
        SaveRoleServiceHelper.handleLicense(roleId, appEntity);
        return true;
    }

    private static void handleLicense(String roleId, Map<String, List<String>> appEntity) {
        List userIDs = PermCommonUtil.getUserByRole((String)roleId);
        if (!CollectionUtils.isEmpty((Collection)userIDs) && !CollectionUtils.isEmpty(appEntity)) {
            LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj((List)userIDs, appEntity);
        }
    }

    public static void setNameLabel(IFormView formView, PropertyChangedArgs args) {
        String newValue;
        IDataModel model = formView.getModel();
        ChangeData changeData = args.getChangeSet()[0];
        String oldValue = changeData.getOldValue().toString();
        if (HRStringUtils.equals((String)oldValue, (String)(newValue = changeData.getNewValue().toString()))) {
            return;
        }
        Label label = (Label)formView.getControl("lblname");
        OrmLocaleValue value = (OrmLocaleValue)model.getValue("name");
        String localValueName = value.getLocaleValue();
        label.setText(RoleServiceHelper.getFixNumberWords(localValueName.trim()));
    }

    public static void setNumberLabel(IFormView formView, PropertyChangedArgs args) {
        String newValue;
        IDataModel model = formView.getModel();
        ChangeData changeData = args.getChangeSet()[0];
        Object oldValueObj = changeData.getOldValue();
        Object newValueObj = changeData.getNewValue();
        String oldValue = Objects.isNull(oldValueObj) ? "" : oldValueObj.toString();
        String string = newValue = Objects.isNull(newValueObj) ? "" : newValueObj.toString();
        if (HRStringUtils.equals((String)oldValue, (String)newValue)) {
            return;
        }
        Label label = (Label)formView.getControl("lblnumber");
        String number = (String)model.getValue("number");
        label.setText(RoleServiceHelper.getFixNumberWords(number));
    }

    public static void clearDataPermMap(PermPageCacheUtil permPageCacheUtil) {
        permPageCacheUtil.clearDataPerm();
    }

    public static boolean checkFuncPermComplete(IFormView formView, boolean showTips) {
        boolean flag = true;
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(formView, false);
        List<Map<String, String>> dataLists = pageCacheUtil.getFuncPermDataList();
        if (CollectionUtils.isEmpty(dataLists) && showTips) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u529f\u80fd\u6743\u9650\u6388\u6743\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4e0b\u4e00\u6b65\u64cd\u4f5c\u3002", (String)"SaveRoleServiceHelper_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            flag = false;
        }
        return !flag;
    }

    public static boolean checkSavePermission(IFormView formView) {
        String permItemId = "47156aff000000ac";
        String tips = ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u8fdb\u884c\u89d2\u8272\u7ba1\u7406\u4e2d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u3002", (String)"SaveRoleServiceHelper_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        return SaveRoleServiceHelper.doCheckPermission(formView, permItemId, tips);
    }

    public static boolean checkUpdatePermission(IFormView formView) {
        String permItemId = "4715a0df000000ac";
        String tips = ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u4fee\u6539\u89d2\u8272\u7ba1\u7406\u64cd\u4f5c\u3002", (String)"SaveRoleServiceHelper_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        return SaveRoleServiceHelper.doCheckPermission(formView, permItemId, tips);
    }

    public static boolean checkCopyPermission(IFormView formView) {
        String permItemId = "4730fc9f000020ae";
        String tips = ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u590d\u5236\u89d2\u8272\u7ba1\u7406\u64cd\u4f5c\u3002", (String)"SaveRoleServiceHelper_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        return SaveRoleServiceHelper.doCheckPermission(formView, permItemId, tips);
    }

    private static boolean doCheckPermission(IFormView formView, String permItemId, String tips) {
        boolean hasRight = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"hrcs", (String)"hrcs_rolequery", (String)permItemId);
        if (!hasRight) {
            formView.showErrorNotification(tips);
        }
        return hasRight;
    }

    @Deprecated
    public static boolean setRoleMemberDataProp(String roleId, IFormView view) {
        Map<Long, Map<String, Object>> roleMembers = SaveRoleServiceHelper.getRoleMember(roleId);
        if (CollectionUtils.isEmpty(roleMembers)) {
            return true;
        }
        DynamicObject[] hrbus = SaveRoleServiceHelper.queryHrBuDys(roleId);
        HashSet<Long> allUserIds = new HashSet<Long>(roleMembers.size());
        for (Map.Entry<Long, Map<String, Object>> member : roleMembers.entrySet()) {
            allUserIds.add((Long)member.getValue().get("user"));
        }
        HRBaseServiceHelper hrUserRoleHelper = new HRBaseServiceHelper(ENTITY_HBSS_USERROLE);
        HRBaseServiceHelper bosUserRoleHelper = new HRBaseServiceHelper(PERM_USERROLE);
        HRBaseServiceHelper userRoleRelateHelper = new HRBaseServiceHelper(ENTITY_HRCS_USERROLE_RELAT);
        DynamicObject[] userRoles = SaveRoleServiceHelper.queryUserRoleDys(roleId, userRoleRelateHelper);
        DynamicObjectCollection userRoleRelateColl = new DynamicObjectCollection();
        List<Long> userRoleRelateIds = SaveRoleServiceHelper.buildUserRoleRelateIds(userRoles);
        DynamicObject hrUserRoleObj = hrUserRoleHelper.generateEmptyDynamicObject();
        DynamicObject bosUserRoleObj = bosUserRoleHelper.generateEmptyDynamicObject();
        int userRoleSize = hrbus.length * userRoles.length;
        DynamicObjectCollection hrSaveObjs = new DynamicObjectCollection();
        DynamicObjectCollection bosSaveObjs = new DynamicObjectCollection();
        long[] hrUserRoleIds = DBServiceHelper.genLongIds((String)ENTITY_HBSS_USERROLE, (int)userRoleSize);
        String[] bosUserRoleIds = DBServiceHelper.genStringIds((String)PERM_USERROLE, (int)userRoleSize);
        String curCtrlTypeEntNum = SaveRoleServiceHelper.getCtrlTypeEntityNum(view);
        int idIndex = 0;
        for (DynamicObject userRoleRelate : userRoles) {
            userRoleRelate.set(FIELD_CUSTOM_ENABLE, (Object)"0");
            userRoleRelateColl.add((Object)userRoleRelate);
            for (DynamicObject hrbu : hrbus) {
                bosUserRoleObj = SaveRoleServiceHelper.setBosUserRoleDy(roleId, bosUserRoleObj.getDynamicObjectType(), bosUserRoleIds[idIndex], curCtrlTypeEntNum, userRoleRelate, hrbu);
                bosSaveObjs.add((Object)bosUserRoleObj);
                hrUserRoleObj = SaveRoleServiceHelper.setHrUserRoleDy(hrUserRoleObj.getDynamicObjectType(), hrUserRoleIds[idIndex], bosUserRoleIds[idIndex], userRoleRelate, hrbu);
                hrSaveObjs.add((Object)hrUserRoleObj);
                ++idIndex;
            }
        }
        DynamicObjectCollection hrUserRoleColl = SaveRoleServiceHelper.queryHrUserRoleColl(hrUserRoleHelper, userRoleRelateIds);
        List<String> bosUserRoleList = SaveRoleServiceHelper.buildBosUserRole(hrUserRoleColl);
        QFilter[] delBosFilters = new QFilter[]{new QFilter("id", "in", bosUserRoleList)};
        if (SaveRoleServiceHelper.handleBosUserRoleData(roleId, allUserIds, bosSaveObjs, delBosFilters)) {
            return SaveRoleServiceHelper.handleHrData(roleId, hrSaveObjs, userRoleRelateColl);
        }
        return false;
    }

    public static DynamicObject[] queryUserRoleRelate(String roleId) {
        HRBaseServiceHelper userRoleRelateHelper = new HRBaseServiceHelper(ENTITY_HRCS_USERROLE_RELAT);
        DynamicObject[] userRoles = SaveRoleServiceHelper.queryUserRoleDys(roleId, userRoleRelateHelper);
        return userRoles;
    }

    private static List<String> buildBosUserRole(DynamicObjectCollection hrUserRoleColl) {
        return hrUserRoleColl.stream().map(userRole -> userRole.getString(USERROLEPF)).collect(Collectors.toList());
    }

    private static List<Long> buildUserRoleRelateIds(DynamicObject[] userRoles) {
        return Arrays.stream(userRoles).map(userRoleRelate -> userRoleRelate.getLong("id")).collect(Collectors.toList());
    }

    private static DynamicObjectCollection queryHrUserRoleColl(HRBaseServiceHelper hrUserRoleHelper, List<Long> userRoleRelateIds) {
        return hrUserRoleHelper.queryOriginalCollection(USERROLEPF, new QFilter[]{new QFilter(USERROLEREALT, "in", userRoleRelateIds)});
    }

    private static DynamicObject setHrUserRoleDy(DynamicObjectType hrUserRoleObjType, long hrUserRoleId, String bosUserRoleId, DynamicObject userRoleRelate, DynamicObject hrbu) {
        DynamicObject hrUserRoleObj = new DynamicObject(hrUserRoleObjType);
        hrUserRoleObj.set("id", (Object)hrUserRoleId);
        hrUserRoleObj.set("org", (Object)hrbu.getLong("org"));
        hrUserRoleObj.set("includesuborg", hrbu.get(KEY_CONTAINS_SUB));
        hrUserRoleObj.set(USERROLEREALT, userRoleRelate.get("id"));
        hrUserRoleObj.set(USERROLEPF, (Object)bosUserRoleId);
        hrUserRoleObj.set("bucafunc", hrbu.get(HRBUCAFUNC));
        return hrUserRoleObj;
    }

    private static DynamicObject setBosUserRoleDy(String roleId, DynamicObjectType bosUserRoleObjType, String bosUserRoleId, String curCtrlTypeEntNum, DynamicObject userRoleRelate, DynamicObject hrbu) {
        DynamicObject bosUserRoleObj = new DynamicObject(bosUserRoleObjType);
        bosUserRoleObj.set("id", (Object)bosUserRoleId);
        bosUserRoleObj.set("org", (Object)hrbu.getLong("org"));
        bosUserRoleObj.set("includesuborg", hrbu.get(KEY_CONTAINS_SUB));
        bosUserRoleObj.set("user", userRoleRelate.get("user"));
        bosUserRoleObj.set("role", (Object)roleId);
        bosUserRoleObj.set("source", (Object)"hr");
        bosUserRoleObj.set("dimtype", (Object)curCtrlTypeEntNum);
        return bosUserRoleObj;
    }

    private static DynamicObject[] queryHrBuDys(String roleId) {
        HRBaseServiceHelper hrbuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        QFilter[] buFilters = new QFilter[]{new QFilter("role", "=", (Object)roleId)};
        return hrbuHelper.queryOriginalArray("org,containssub,hrbucafunc", buFilters);
    }

    private static DynamicObject[] queryUserRoleDys(String roleId, HRBaseServiceHelper userRoleRelateHelper) {
        QFilter[] filters = new QFilter[]{new QFilter("role", "=", (Object)roleId)};
        return userRoleRelateHelper.query("id,user,customenable", filters);
    }

    @Deprecated
    private static boolean handleBosUserRoleData(String roleId, Set<Long> allUserIds, DynamicObjectCollection bosSaveObjs, QFilter[] deleteFilters) {
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper(PERM_USERROLE);
            userRoleHelper.deleteByFilter(deleteFilters);
            userRoleHelper.save(bosSaveObjs);
            RoleServiceHelper.clearUserRolePermCache();
            HashSet roleIds = Sets.newHashSetWithExpectedSize((int)1);
            roleIds.add(roleId);
            Map appEntity = PermissionServiceHelper.getAppEntityByRoleSet((Set)roleIds);
            if (!PermRoleUtil.handleUserRoleLicense(new ArrayList<Long>(allUserIds), appEntity)) {
                throw new KDBizException("Sync license failed");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exc) {
            txHandle.markRollback();
            LOGGER.error("Role Save Failed ,Please Check Data Correct! Exception Msg : {}" + exc.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Deprecated
    private static boolean handleHrData(String roleId, DynamicObjectCollection hrSaveObjs, DynamicObjectCollection userRoleRelateColl) {
        HRBaseServiceHelper hrUserRoleHelper = new HRBaseServiceHelper(ENTITY_HBSS_USERROLE);
        HRBaseServiceHelper userRoleRelateHelper = new HRBaseServiceHelper(ENTITY_HRCS_USERROLE_RELAT);
        HRBaseServiceHelper hrUserDataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        QFilter[] deleteFilters = new QFilter[]{new QFilter("role", "=", (Object)roleId), new QFilter(FIELD_PERM_FILE, "!=", (Object)0L)};
        try (TXHandle txHandle = TX.required();){
            try {
                userRoleRelateHelper.save(userRoleRelateColl);
                List userRoleRelateIds = userRoleRelateColl.stream().map(userRole -> userRole.getLong("id")).collect(Collectors.toList());
                hrUserDataRuleHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerelate", "in", userRoleRelateIds)});
                hrUserRoleHelper.deleteByFilter(new QFilter[]{new QFilter(USERROLEREALT, "in", userRoleRelateIds)});
                hrUserRoleHelper.save(hrSaveObjs);
            }
            catch (Exception exc) {
                txHandle.markRollback();
                LOGGER.error("Role Save Failed, Please Check Data Correct! Exception Msg : {}" + exc.getMessage());
                boolean bl = false;
                if (txHandle != null) {
                    if (var8_8 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public static Map<Long, Map<String, Object>> getRoleMember(String roleId) {
        return SaveRoleServiceHelper.queryMember(roleId);
    }

    private static Map<Long, Map<String, Object>> queryMember(String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_HRCS_USERROLE_RELAT);
        QFilter[] filters = new QFilter[]{new QFilter("role", "=", (Object)roleId)};
        DynamicObjectCollection coll = helper.queryOriginalCollection("id, permfile,customenable,user,validstart,validend", filters);
        HashMap members = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : coll) {
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)4);
            Long userRoleId = dynamicObject.getLong("id");
            tempMap.put(USERROLEID, userRoleId);
            tempMap.put(FIELD_PERM_FILE, dynamicObject.get(FIELD_PERM_FILE));
            tempMap.put("user", dynamicObject.get("user"));
            tempMap.put(FIELD_CUSTOM_ENABLE, dynamicObject.get(FIELD_CUSTOM_ENABLE));
            tempMap.put(VALIDSTART, dynamicObject.get(VALIDSTART));
            tempMap.put(VALIDEND, dynamicObject.get(VALIDEND));
            members.put(userRoleId, tempMap);
        }
        return members;
    }

    public static String getCtrlTypeEntityNum(IFormView view) {
        HRPageCache cache = new HRPageCache(view);
        String ctrlTypeEntNum = null;
        try {
            ctrlTypeEntNum = (String)cache.get("FormShowParam_CtrlType_EntityNum", String.class);
        }
        catch (Exception ex) {
            LOGGER.error("Cast Attach Failed ,Please Check Cache ! Exception : {}" + ex.getMessage());
        }
        if (HRStringUtils.isNotEmpty((String)ctrlTypeEntNum)) {
            return ctrlTypeEntNum;
        }
        ctrlTypeEntNum = (String)view.getFormShowParameter().getCustomParam("FormShowParam_CtrlType_EntityNum");
        if (HRStringUtils.isNotEmpty((String)ctrlTypeEntNum)) {
            cache.put("FormShowParam_CtrlType_EntityNum", (Object)ctrlTypeEntNum);
            return ctrlTypeEntNum;
        }
        DynamicObject curCtrlTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_ctrltype", (String)"bizobjectid.id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)SaveRoleServiceHelper.getCtrlType(view))});
        ctrlTypeEntNum = curCtrlTypeObj.getString("bizobjectid.id");
        cache.put("FormShowParam_CtrlType_EntityNum", (Object)ctrlTypeEntNum);
        return ctrlTypeEntNum;
    }

    public static String getCtrlType(IFormView view) {
        HRPageCache cache = new HRPageCache(view);
        String dimType = null;
        try {
            dimType = (String)cache.get("FormShowParam_dimension", String.class);
        }
        catch (Exception ex) {
            LOGGER.error("Type Cast Control Type Failed ,Please Check Data Correct ! Exception : {}" + ex.getMessage());
        }
        if (HRStringUtils.isNotEmpty((String)dimType)) {
            return dimType;
        }
        dimType = (String)view.getFormShowParameter().getCustomParam("FormShowParam_dimension");
        if (HRStringUtils.isEmpty((String)dimType)) {
            dimType = "DIM_ORG";
        } else {
            DynamicObject curCtryTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_ctrltype", (String)"number", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "=", (Object)dimType)});
            if (curCtryTypeObj != null) {
                dimType = curCtryTypeObj.getString("number");
            }
        }
        cache.put("FormShowParam_dimension", (Object)dimType);
        return dimType;
    }
}

